<?php
if ( ! defined('BASEPATH')) exit('No direct script access allowed');
class Twtest extends MY_Controller {
public function index() {

		$this->load->helper(array('cookie','date','form','email'));
		$this->load->library(array('encrypt','form_validation'));		
		$this->load->model(array('user_model','product_model'));
		
$this->load->library('twconnect');
$this->load->helper('url');

echo '<p><a href="' . base_url() . 'twtest/redirect">Connect to Twitter</a></p>';
echo '<p><a href="' . base_url() . 'twtest/clearsession">Clear session</a></p>';

echo 'Session data:<br/><pre>';
print_r($this->session->all_userdata());
echo '</pre>';
}

/* redirect to Twitter for authentication */
public function redirect() {

		$twitter_data = $this->session->userdata('tw_access_token');
		$twitter_data_status = $this->session->userdata('tw_status');
		$shopsy_session_temp_id = $this->session->userdata('shopsy_session_temp_id');
		$this->session->unset_userdata($twitter_data);
		$this->session->unset_userdata($twitter_data_status);
		$this->session->unset_userdata($shopsy_session_temp_id);
//echo "<pre>";print_r($this->session->all_userdata);
//redirect('twtest/redirect');
$this->load->library('twconnect');

/* twredirect() parameter - callback point in your application */
/* by default the path from config file will be used */
$ok = $this->twconnect->twredirect('twtest/callback');
$ok = $this->twconnect->twredirect('twtest/callback');

if (!$ok) {
echo 'Could not connect to Twitter. Refresh the page or try again later.';
}
}


/* return point from Twitter */
/* you have to call $this->twconnect->twprocess_callback() here! */
public function callback() {
$this->load->library('twconnect');

$ok = $this->twconnect->twprocess_callback();

if ( $ok ) { redirect('twtest/success'); }
else redirect ('twtest/failure');
}


/* authentication successful */
/* it should be a different function from callback */
/* twconnect library should be re-loaded */
/* but you can just call this function, not necessarily redirect to it */
public function success() {

echo 'Twitter connect succeded<br/>';
echo '<p><a href="' . base_url() . 'twtest/clearsession">Do it again!</a></p>';

$this->load->library('twconnect');
$this->load->library('session');
// saves Twitter user information to $this->twconnect->tw_user_info
// twaccount_verify_credentials returns the same information
$this->twconnect->twaccount_verify_credentials();



echo 'Authenticated user info ("GET account/verify_credentials"):<br/><pre>';


$twConnectId = $this->twconnect->tw_user_info;
 
$twitterId = $twConnectId->id;
$this->load->model('user_model');
$twitterCountById = $this->user_model->social_network_login_check($twitterId);

$a = $this->session->all_userdata();


$aa= $this->session->userdata('tw_access_token');

if($twitterCountById != 0)
{
 
	//echo "redirect to login success page";
	$getLoginDetails = $this->user_model->get_social_login_details($twitterId);	
	$userdata = array(
							'shopsy_session_user_id' => $getLoginDetails['id'],
							'shopsy_session_user_name' => $getLoginDetails['user_name'], 
							'shopsy_session_user_email' => $getLoginDetails['email'] 
						);
	$this->session->set_userdata($userdata);
	
	$this->setErrorMessage('success','Login successfully');
	redirect(base_url());
	
}
else
{

	$getFileNameArray = explode('/',$twConnectId->profile_image_url);
	
	 $fileNameDetails = $getFileNameArray[5];
	 
	 if($fileNameDetails != '')
	 {
	 	$fileNameDetails = $getFileNameArray[5];
	 }
	 else
	 {
	 	$fileNameDetails = '';
	 }
	
	$twitter_login_details = array('social_login_name'=>$twConnectId->name,'social_login_unique_id'=>$twConnectId->id,'screen_name'=>$twConnectId->screen_name,'social_image_name'=>$fileNameDetails);
	
	
	$url = $twConnectId->profile_image_url;
	$img = 'images/users/'.$fileNameDetails ;
	file_put_contents($img, file_get_contents($url));
	
	
	//echo "redirect to registration page";
	$social_login_name = $twConnectId->name;
	$this->session->set_userdata($twitter_login_details);
	//echo $a =$this->session->userdata($twise);
	redirect('signup');
	
	
	//redirect("signup#");
}
//echo "<br>".count($twitterQueryDetails);





}


/* authentication un-successful */
public function failure() {

//echo '<p>Twitter connect failed</p>';
//echo '<p><a href="' . base_url() . 'twtest/clearsession">Try again!</a></p>';
redirect('signup');
}


/* clear session */
public function clearsession() {

//$this->session->sess_destroy();

redirect('/twtest');
}

}