<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

/** 
 * 
 * User related functions
 * @author Teamtweaks
 *
 **/ 

class User extends MY_Controller { 

	function __construct(){
	
        parent::__construct();
		$this->load->helper(array('cookie','date','form','email'));
		$this->load->library(array('encrypt','form_validation'));		
		$this->load->library('session');
		$this->load->model(array('user_model','product_model','seller_model','product_attribute_model'));
		  
		
		$this->data['loginCheck'] = $this->checkLogin('U');
		$this->data['likedProducts'] = array();
	 	if ($this->data['loginCheck'] != ''){
	 		$this->data['likedProducts'] = $this->product_model->get_all_details(PRODUCT_LIKES,array('user_id'=>$this->checkLogin('U')));
	 	}
		
    }
    
    /**
     * 
     * Function for quick signup
     */
	public function quickSignup(){
		$email = $this->input->post('email');
		$returnStr['success'] = '0';
		if (valid_email($email)){
			$condition = array('email'=>$email);
			$duplicateMail = $this->user_model->get_all_details(USERS,$condition);
			if ($duplicateMail->num_rows()>0){
				$returnStr['msg'] = 'Email id already exists';	
			}else {
				$fullname = substr($email, 0,strpos($email, '@'));
				$checkAvail = $this->user_model->get_all_details(USERS,array('user_name'=>$fullname));
				if ($checkAvail->num_rows()>0){
					$avail = FALSE;
				}else {
					$avail = TRUE;
					$username = $fullname;
				}
				while (!$avail){
					$username = $fullname.rand(1111, 999999);
					$checkAvail = $this->user_model->get_all_details(USERS,array('user_name'=>$username));
					if ($checkAvail->num_rows()>0){
						$avail = FALSE;
					}else {
						$avail = TRUE;
					}
				}
				if ($avail){
					$pwd = $this->get_rand_str('6');
					$this->user_model->insertUserQuick($fullname,$username,$email,$pwd);
					$this->session->set_userdata('quick_user_name',$email);
					$returnStr['msg'] = 'Successfully registered';
					$returnStr['full_name'] = $fullname;
					$returnStr['user_name'] = $username;
					$returnStr['password'] = $pwd;
					$returnStr['email'] = $email;
					$returnStr['success'] = '1';
				}
			}
		}else {
			$returnStr['msg'] = "Invalid email id";
		}
		echo json_encode($returnStr);
	}
    
    /**
     * 
     * Function for quick signup update
     */
	public function quickSignupUpdate(){
		$returnStr['success'] = '0';
		$unameArr = $this->config->item('unameArr');
		$username = $this->input->post('username');
		if (!preg_match('/^\w{1,}$/', trim($username))){
			$returnStr['msg'] = 'User name not valid. Only alphanumeric allowed';
		}elseif (in_array($username, $unameArr)){
			$returnStr['msg'] = 'User name already exists';
		}else {
			$email = $this->input->post('email');
			$condition = array('user_name'=>$username,'email !='=>$email);
			$duplicateName = $this->user_model->get_all_details(USERS,$condition);
			if ($duplicateName->num_rows()>0){
				$returnStr['msg'] = 'Username already exists';	
			}else {
				$pwd = $this->input->post('password');
				$fullname = $this->input->post('fullname');
				$this->user_model->updateUserQuick($fullname,$username,$email,$pwd);
				$this->session->set_userdata('quick_user_name',$email);
				$returnStr['msg'] = 'Successfully registered';
				$returnStr['success'] = '1';
			}
		}
		echo json_encode($returnStr);
	}
	
	public function send_quick_register_mail(){

		if ($this->checkLogin('U') != ''){
			redirect(base_url());
		}else {
			$quick_user_name = $this->session->userdata('quick_user_name');
			if ($quick_user_name == ''){
				redirect(base_url());
			}else {
				$condition = array('email'=>$quick_user_name);
				$userDetails = $this->user_model->get_all_details(USERS,$condition);
				if ($userDetails->num_rows() == 1){
					$this->send_confirm_mail($userDetails);
					$this->login_after_signup($userDetails);
					
					$this->session->set_userdata('quick_user_name','');
					if ($userDetails->row()->is_brand == 'yes'){
						redirect(base_url().'create-brand');
					}else {
									$this->setErrorMessage('success','You are sucessfully Registered!!!');

						redirect(base_url());
					}
				}else {
					redirect(base_url());
				}
			}
		}
	}
	
	
	/*send register mail*/
	public function send_register_mail(){

		if ($this->checkLogin('U') != ''){
			redirect(base_url());
		}else {			
			$email = $this->session->userdata('shopsy_session_user_email');
			if ($email == ''){
				redirect(base_url());
			}else {
				$condition = array('email'=>$email);
				$userDetails = $this->user_model->get_all_details(USERS,$condition);
				###echo "<pre>"; print_r($userDetails); die;
				if ($userDetails->num_rows() == 1){
					$this->send_confirm_mail($userDetails);
					$this->login_after_signup($userDetails);
					
					$this->session->set_userdata('shopsy_session_user_email','');					
				}else {
					redirect(base_url());
				}
			}
		}
	}
	
	
	public function feedback(){
			$voter_id = $this->input->post('user_id');
			$shop_id = $this->input->post('shop_id');
			$seller_product_id = $this->input->post('product_id');
			$deal_code = $this->input->post('deal_code');
			$description = $this->input->post('description');
			$rating = $this->input->post('rating');
			
			$dataArray=array('voter_id' => $voter_id,
							'shop_id' => $shop_id,
							'seller_product_id'=>$seller_product_id,
							'deal_code'=>$deal_code, 
							'description' => $description, 
							'rating' => $rating);
			if($voter_id!='')
			{
				if($this->input->post("mode")==''){
					$this->user_model->simple_insert(PRODUCT_FEEDBACK,$dataArray);
				}else if($this->input->post("mode")!=''){
					$dataArr = array('description'=>$description,'rating' => $rating);
					$condition = array('id'=>$this->input->post("mode"));
					$this->user_model->update_details(PRODUCT_FEEDBACK,$dataArr,$condition);
				}
				$query="SELECT AVG(rating) as shop_ratting,COUNT(*) as review_count  FROM ".PRODUCT_FEEDBACK." WHERE status='Active' and shop_id=".$shop_id; 
				$shop_ratting=$this->user_model->ExecuteQuery($query)->row();
				$ratting=round($shop_ratting->shop_ratting,2);
				$review_count=$shop_ratting->review_count;
				$condition = array('seller_id'=>$shop_id);
				$dataArr = array('shop_ratting'=>$ratting,'review_count'=>$review_count);
				$this->user_model->update_details(SELLER,$dataArr,$condition);			
			}
			redirect($base_url.'view-order/'.$voter_id.'/'.$deal_code);
	}
	
	public function find_friends(){
		if ($this->checkLogin('U') == ''){
			redirect(base_url());
		}else {
			$this->load->view('site/user/find_friends',$this->data);
		}
	}
	/******************Invite Friends********************/
     public function app_twitter(){
		$returnStr['status_code'] = 1;
		$returnStr['url'] = base_url().'twtest/get_twitter_user';
		$returnStr['message'] = '';
		echo json_encode($returnStr);
	}
	
	public function find_friends_twitter(){
		$returnStr['status_code'] = 1;
		$returnStr['url'] = base_url().'twtest/invite_friends';
		$returnStr['message'] = '';
		echo json_encode($returnStr);
	}

	public function find_friends_gmail(){
		$returnStr['status_code'] = 1;
		error_reporting(0);
		include_once './invite_friends/GmailOath.php';
		include_once './invite_friends/Config.php';
		$oauth =new GmailOath($consumer_key, $consumer_secret, $argarray, $debug, $callback);
		$getcontact=new GmailGetContacts();
		$access_token=$getcontact->get_request_token($oauth, false, true, true);
		$this->session->set_userdata('oauth_token',$access_token['oauth_token']);
		$this->session->set_userdata('oauth_token_secret',$access_token['oauth_token_secret']);
		$returnStr['url'] = "https://www.google.com/accounts/OAuthAuthorizeToken?oauth_token=".$oauth->rfc3986_decode($access_token['oauth_token']);
		$returnStr['message'] = '';
		echo json_encode($returnStr);
	}

	public function find_friends_gmail_callback(){
		include_once './invite_friends/GmailOath.php';
		include_once './invite_friends/Config.php';
		error_reporting(0);
		$oauth =new GmailOath($consumer_key, $consumer_secret, $argarray, $debug, $callback);
		$getcontact_access=new GmailGetContacts();
		
		$request_token=$oauth->rfc3986_decode($this->input->get('oauth_token'));
		$request_token_secret=$oauth->rfc3986_decode($this->session->userdata('oauth_token_secret'));
		$oauth_verifier= $oauth->rfc3986_decode($this->input->get('oauth_verifier'));

		$contact_access = $getcontact_access->get_access_token($oauth,$request_token, $request_token_secret,$oauth_verifier, false, true, true);
		$access_token=$oauth->rfc3986_decode($contact_access['oauth_token']);
		$access_token_secret=$oauth->rfc3986_decode($contact_access['oauth_token_secret']);
		$contacts= $getcontact_access->GetContacts($oauth, $access_token, $access_token_secret, false, true,$emails_count);
		echo "/<pre>"; print_r($contacts); die;
		$count = 0;
		foreach($contacts as $k => $a)
		{
			$final = end($contacts[$k]);
			foreach($final as $email)
			{
				$this->send_invite_mail($email["address"]);
				$count++;
			}
		}
		if ($count>0){
			echo "
			<script>
				alert('Invitations sent successfully');
				window.close();
			</script>
			";
		}else {
			echo "
			<script>
				window.close();
			</script>
			";
		}
	}


	/***************************************************/
	
	/*public function addProduct()
	
	{
		$product_name =  $this->input->post('product_name');
		$price = $this->input->post('price');
		$quantity = $this->input->post('quantity');
		$shipMethod = $this->input->post('shipMethod');
		$category1 =  $this->input->post('category1');
		$category2 =  $this->input->post('category2');
		$category3 =  $this->input->post('category3');
		$store1 = $this->input->post('store1');
		$store2 = $this->input->post('store2');
		$store3 = $this->input->post('store3');
		$description = $this->input->post('description');
		$materials = $this->input->post('materials');
		$pre_order = $this->input->post('pre_order');
		$pre_shipping = $this->config->item('pre_shipping');
		$tag = $this->input->post('tag');

		$category_id = $category1.",".$category2.",".$category3;
		$store_id = $store1.",".$store2.",".$store3;
		
		$config['encrypt_name'] = TRUE;
                       $config['overwrite'] = FALSE;
                   $config['allowed_types'] = 'jpg|jpeg|gif|png|bmp';
//                    $config['max_size'] = 2000;
$config['upload_path'] = './images/product';
                   $this->load->library('upload', $config);
                       //echo "<pre>";print_r($_FILES);die;
                   if ( $this->upload->do_multi_upload('product_image')){
                           $logoDetails = $this->upload->get_multi_upload_data();
                           foreach ($logoDetails as $fileDetails){
                                   $this->ImageResizeWithCrop(650, 360, $fileDetails['file_name'], './images/product/');
                                   $ImageName .= $fileDetails['file_name'].',';
                           }
                       }
				
				
			$this->product_model->simple_insert(PRODUCT,array('product_name'=>$product_name,'category_id'=>$category_id,'store_id'=>$store_id,'price'=>$price,'description'=>$description,'materials'=>$materials,'tag'=>$tag,'quantity'=>$quantity,'image'=>$imgDetails,'shippingType_id'=>$shipMethod));

		//	$this->session->set_userdata('quick_user_name',$username);
					
						$returnStr['msg'] = 'Successfully registered';
						$returnStr['success'] = '1';
		
		$returnStr['msg'] = 'User name not valid. Only alphanumeric allowed';
			echo json_encode($returnStr);
	}
			*/


/*public function deleteImages(){
		$ingIDD = $this->input->post('imgId');
		$currentPage = $this->input->post('cpage');
		$id = $this->input->post('val');


		$position = $this->input->post('position');
		$imgId = $this->input->post('imgId');
		
		
		
		$delete_prod_image = $this->user_model->delete_prod_image($position,$imgId);
		/*$productImage = explode(',',$this->session->userdata('product_image_'.$ingIDD));
		$productImage = explode(',','product_image_'.$ingIDD);
				print_r($productImage); die;*/

		/*if(3 < 2) {
			echo json_encode("No");exit();
		} else {
			$empImg = 0;
			foreach ($productImage as $product) {

				if ($product != ''){

					$empImg++;
				}
			}
			if (3 < 2){
				echo json_encode("No");exit();
			}
			$this->session->unset_userdata('product_image_'.$ingIDD);
			
			$resultVar = $this->setPictureProducts($productImage,$this->input->post('position'));
						print_r($resultVar); die;

			$insertArrayItems = trim(implode(',',$resultVar)); //need validation here...because the array key changed here
			$this->session->set_userdata(array('product_image_'.$ingIDD => $insertArrayItems));	
			$dataArr = array('image' => $insertArrayItems);
			$condition = array('id' => $ingIDD);
			$this->product_model->update_details(PRODUCT,$dataArr,$condition);
			echo json_encode($insertArrayItems);
		}
}*/
	public function registerUser(){

		$returnStr['success'] = '0';
		$unameArr = $this->config->item('unameArr');		
		$fullname = $this->input->post('fullname');
		$lastname = $this->input->post('lastname');
		$gender = $this->input->post('gender');
		$email = $this->input->post('email');
		$pwd = md5($this->input->post('pwd'));
		$Confirmpwd = $this->input->post('Confirmpwd');
		$username = stripslashes($this->input->post('username').trim());
		$subscription= $this->input->post('subscription');
		
		if (!preg_match('/^\w{1,}$/', trim($username))){
			$returnStr['msg'] = 'User name not valid. Only alphanumeric allowed';
		}
		elseif (in_array($username, $unameArr)){
			$returnStr['msg'] = 'User name already exists';
		}else {
			if (valid_email($email)){
				$condition = array('user_name'=>$username);
				$duplicateName = $this->user_model->get_all_details(USERS,$condition);
				if ($duplicateName->num_rows()>0){
					$returnStr['msg'] = 'User name already exists';	
				}else {
					$condition = array('email'=>$email);
					$duplicateMail = $this->user_model->get_all_details(USERS,$condition);
					if ($duplicateMail->num_rows()>0){
						$returnStr['msg'] = 'Email id already exists';	
					}else {
						$dataArr = array('full_name'=>$fullname,'user_name'=>$username,'last_name'=>$lastname,'email'=>$email,'password'=>$pwd,'status'=>'Active','gender'=>$gender,'is_verified'=>'No');
						$this->user_model->simple_insert(USERS,$dataArr);
						
						$checkUser = $this->user_model->get_all_details(USERS,array('email'=>$email));
						//$this->user_model->insertUserQuick($fullname,$username,$lastname,$email,$pwd,$brand);
						$this->session->set_userdata('quick_user_name',$email);
						$userdata = array(
								'shopsy_session_user_id' => $checkUser->row()->id,
								'shopsy_session_user_name' => $checkUser->row()->user_name,
								'shopsy_session_full_name' => $checkUser->row()->full_name,
								'shopsy_session_user_email' => $checkUser->row()->email,
								'shopsy_session_user_confirm' => $checkUser->row()->is_verified,
								'userType'=>$checkUser->row()->group
							);
						if($subscription=='on'){
							$this->subscribeUserRegister($checkUser->row()->email);
						}
						$this->session->set_userdata($userdata);											$this->user_model->updategiftcard(GIFTCARDS_TEMP,$this->checkLogin('T'),$checkUser->row()->id);				   $this->user_model->updateShopingCart(SHOPPING_CART,$this->checkLogin('T'),$checkUser->row()->id);				   $this->user_model->updateUserShopingCart(USER_SHOPPING_CART,$this->checkLogin('T'),$checkUser->row()->id);
						$userDetails=$checkUser;
						$this->send_confirm_mail($userDetails);
						$returnStr['msg'] = 'Successfully registered';
						$returnStr['success'] = '1';
					}
				}
			}else {
				$returnStr['msg'] = "Invalid email id";
			}
		}
		$this->setErrorMessage('success','Your account Registerd with '.$this->config->item('email_title'));
		echo json_encode($returnStr);
	}
	public function subscribeUserRegister($email)
	{
			
			$checkUser = $this->user_model->get_all_details(SUBSCRIBERS_LIST,array('subscrip_mail'=>$email));
			
			if($checkUser->num_rows()==0){
				$condition = array('email'=>$email);
				$datestring = "%Y-%m-%d %h:%i:%s";
				$time = time();
				$createdTime = mdate($datestring,$time);
				$randStr = $this->get_rand_str('10');	
				$dataArr = array('subscrip_mail'=>$email,'active'=>0,'status'=>'Active','dateAdded'=>$createdTime,'verification_mail'=>$randStr); 
				$this->user_model->simple_insert(SUBSCRIBERS_LIST,$dataArr);
				$maxidd = $this->db->insert_id();
			}
	}
	
	
	public function loginsubscribeUser()
	{
		if($this->checkLogin('U')!='')	{
			$email = $this->session->userdata['shopsy_session_user_email']; //exit;
			
			$checkUser = $this->user_model->get_all_details(SUBSCRIBERS_LIST,array('subscrip_mail'=>$email));
			
			if($checkUser->num_rows()==0){

				$condition = array('email'=>$email);
				$datestring = "%Y-%m-%d %h:%i:%s";
				$time = time();
				$createdTime = mdate($datestring,$time);
				$randStr = $this->get_rand_str('10');
				
		
				$dataArr = array('subscrip_mail'=>$email,'active'=>0,'status'=>'Active','dateAdded'=>$createdTime,'verification_mail'=>$randStr); 
				$this->user_model->simple_insert(SUBSCRIBERS_LIST,$dataArr);
				$maxidd = $this->db->insert_id();
				$cfmurl = base_url().'site/user/confirm_register_subscribe/'.$maxidd."/";
				//$this->setErrorMessage('success','Thanks for subscribing newsletter !');
				//redirect(base_url());
				
				$newsid='16';
				$subject = 'From: '.$this->config->item('email_title');
				$adminnewstemplateArr=array('email_title'=> $this->config->item('email_title'),'logo'=> $this->data['logo']);
				extract($adminnewstemplateArr);
				$header .="Content-Type: text/plain; charset=ISO-8859-1\r\n";
				
				$message .= '<!DOCTYPE HTML>
				<html>
				<head>
				<meta http-equiv="Content-Type" content="text/html; charset=utf-8">
				<meta name="viewport" content="width=device-width"/><body>';
				include('./newsletter/registeration'.$newsid.'.php');	
				$message .= '</body>
				</html>';
				//$returnStr['msg'] = 'Successfully registered';
				//$returnStr['success'] = '1';
					
				if($template_values['sender_name']=='' && $template_values['sender_email']==''){
					$sender_email=$this->data['siteContactMail'];
					$sender_name=$this->data['siteTitle'];
				}else{
					$sender_name=$template_values['sender_name'];
					$sender_email=$template_values['sender_email'];
				}
	
				$email_values = array('mail_type'=>'html',
								'from_mail_id'=>$sender_email,
								'mail_name'=>$sender_name,
								'to_mail_id'=>$email,
								'subject_message'=>$template_values['news_subject'],
								'body_messages'=>$message
								);
				$email_send_to_common = $this->user_model->common_email_send($email_values);
				
				$this->setErrorMessage('success','Thanks for subscribing newsletter!!!');
				//redirect(base_url());
				redirect('home');
			}
			else
			{
				$this->setErrorMessage('error','You Are Already subscribed!!!');
				//redirect(base_url());
				redirect('home');
			}
		}
	}
	
	public function subscribeUser()
	{
		$email = $this->input->post('emaill');
		
		if(valid_email($email)){
			$sel_qry = $this->db->query("SELECT * FROM ".SUBSCRIBERS_LIST." WHERE subscrip_mail='$email'");
			
			if($sel_qry->num_rows()==0){
				$condition = array('email'=>$email);
				$datestring = "%Y-%m-%d %h:%i:%s"; 
				$time = time();
				$createdTime = mdate($datestring,$time); //exit;
				$randStr = $this->get_rand_str('10');
				
				$dataArr = array('subscrip_mail'=>$email,'active'=>0,'status'=>'Active','dateAdded'=>$createdTime,'verification_mail'=>$randStr); 
				$this->user_model->simple_insert(SUBSCRIBERS_LIST,$dataArr);
				$maxidd = $this->db->insert_id();
				
				$cfmurl = base_url().'site/user/confirm_register_subscribe/'.$maxidd."/";
				
				$newsid='16';
				$subject = 'From: '.$this->config->item('email_title');
				$adminnewstemplateArr=array('email_title'=> $this->config->item('email_title'),'logo'=> $this->data['logo']);
				extract($adminnewstemplateArr);
				$header .="Content-Type: text/plain; charset=ISO-8859-1\r\n";
				
				$message .= '<!DOCTYPE HTML>
				<html>
				<head>
				<meta http-equiv="Content-Type" content="text/html; charset=utf-8">
				<meta name="viewport" content="width=device-width"/><body>';
				include('./newsletter/registeration'.$newsid.'.php');	
				$message .= '</body>
				</html>';
				//$returnStr['msg'] = 'Successfully registered';
				//$returnStr['success'] = '1';
					
				if($template_values['sender_name']=='' && $template_values['sender_email']==''){
					$sender_email=$this->data['siteContactMail'];
					$sender_name=$this->data['siteTitle'];
				}else{
					$sender_name=$template_values['sender_name'];
					$sender_email=$template_values['sender_email'];
				}
	
				$email_values = array('mail_type'=>'html',
								'from_mail_id'=>$sender_email,
								'mail_name'=>$sender_name,
								'to_mail_id'=>$email,
								'subject_message'=>$template_values['news_subject'],
								'body_messages'=>$message
								);
				$email_send_to_common = $this->user_model->common_email_send($email_values);
				
				$this->setErrorMessage('success','Thanks for subscribing newsletter !');
				redirect(base_url());
			}else{
				$this->setErrorMessage('error','Email Id Already Exists !');
				redirect(base_url());
			}
		}else{
			$returnStr['msg'] = "Invalid email id";
			$this->setErrorMessage('error','Invalid email id !');
			redirect(base_url());
		}	
	}
	
	public function emailExists($email='')
	{
		$condition = array('email'=>$this->input->post('email'));
		$duplicateName = $this->user_model->get_all_details(USERS,$condition);
		if ($duplicateName->num_rows()>0){
			echo 'exist';
		}else{
			echo 'new';
		}
	}
	
	function check_user_availability()
    {
        $emaill = $this->input->post('emaill');
        //$existing_users=$this->user_model->get_all_usernames();
		$query = $this->db->query("SELECT * FROM ".SUBSCRIBERS_LIST." WHERE subscrip_mail='$emaill'");
        //$emaill= $emaill;

        /*if (in_array($emaill, $existing_users))
        {
            echo "no";
        } 
        else
        {
            echo "yes";
        }*/
		//if (valid_email('email@somesite.com'))
		//if($emaill!='')
		if($emaill!='')
		{
			if($query->num_rows()>0)
			{
				//return true;
				echo "no";
			}
			else
			{
				//return false;
				echo "yes";
			}
		}
	}
	public function verify_user_email(){
		$this->data['heading'] = 'Verify'; 
		$this->load->view('site/user/verify_email.php',$this->data);
	}
	public function resend_confirm_mail(){
		$mail = $this->input->post('mail');
		if ($mail == ''){
			echo '0';
		}else {
			$condition = array('email'=>$mail);
			$userDetails = $this->user_model->get_all_details(USERS,$condition);
			$this->send_confirm_mail($userDetails);
			echo '1';
		}
	}
	
	public function send_email_confirmation(){
		$returnStr['status_code'] = 0;
		if ($this->checkLogin('U') == ''){
			$returnStr['message'] = 'Login required';
		}else {
			$this->send_confirm_mail($this->data['userDetails']);
			$returnStr['status_code'] = 1;
		}
		echo json_encode($returnStr);
	}
	
	public function send_confirm_mail($userDetails=''){
	
		$uid = $userDetails->row()->id;
		$email = $userDetails->row()->email;
		$randStr = $this->get_rand_str('10');
		$condition = array('id'=>$uid);
		$dataArr = array('verify_code'=>$randStr);
		$this->user_model->update_details(USERS,$dataArr,$condition);
		$newsid='3';
		$template_values=$this->user_model->get_newsletter_template_details($newsid);
		
		$cfmurl = base_url().'site/user/confirm_register/'.$uid."/".$randStr."/confirmation";
		$subject = 'From: '.$this->config->item('email_title').' - '.$template_values['news_subject'];
		$adminnewstemplateArr=array('email_title'=> $this->config->item('email_title'),'logo'=> $this->data['logo'],'footer_content'=> $this->config->item('footer_content'));
		extract($adminnewstemplateArr);
		//$ddd =htmlentities($template_values['news_descrip'],null,'UTF-8');
		$header .="Content-Type: text/plain; charset=ISO-8859-1\r\n";
		
		$message .= '<!DOCTYPE HTML>
			<html>
			<head>
			<meta http-equiv="Content-Type" content="text/html; charset=utf-8">
			<meta name="viewport" content="width=device-width"/><body>';
		include('./newsletter/registeration'.$newsid.'.php');	
		
		$message .= '</body>
			</html>';
		
		if($template_values['sender_name']=='' && $template_values['sender_email']==''){
			$sender_email=$this->data['siteContactMail'];
			$sender_name=$this->data['siteTitle'];
		}else{
			$sender_name=$template_values['sender_name'];
			$sender_email=$template_values['sender_email'];
		}

		$email_values = array('mail_type'=>'html',
							'from_mail_id'=>$sender_email,
							'mail_name'=>$sender_name,
							'to_mail_id'=>$email,
							'subject_message'=>$template_values['news_subject'],
							'body_messages'=>$message
							);
		#echo "<pre>"; print_r($email_values);				
		$email_send_to_common = $this->user_model->common_email_send($email_values);
	}
	
	public function signup_form(){
		if ($this->checkLogin('U') != ''){
			redirect('');
		}else {
			$this->data['next'] = $this->input->get('next');
			$this->data['heading'] = 'Sign in'; 
			$this->load->view('site/user/signup.php',$this->data);
		}
	}
	public function register_form(){
		if ($this->checkLogin('U') != ''){
			redirect('');
		}else {
			$this->data['next'] = $this->input->get('next');
			$this->data['heading'] = 'Sign up'; 
			$this->load->view('site/user/register.php',$this->data);
		}
	}
	/**
	 * 
	 * Loading login page
	 */
	public function login_form(){
		if ($this->checkLogin('U')!=''){
			redirect(base_url());
		}else {
			$this->data['next'] = $this->input->get('next');
			//echo $this->data['next'];die;
			$this->data['heading'] = 'Sign in'; 
			$this->load->view('site/user/signup.php',$this->data);
		}
	}
	
	public function login_user(){

		$this->form_validation->set_rules('emailAddr', 'Email Address', 'required');
		$this->form_validation->set_rules('password', 'Password', 'required');
		$next = $this->input->post('next_url');	
		if ($this->form_validation->run() === FALSE)		{			$this->setErrorMessage('error','Email and password fields required');			if($next!=''){				redirect('login?action='.urlencode($next));			}else {				redirect('login');			}		}
		else {
			$email = $this->input->post('emailAddr');
			$pwd = md5($this->input->post('password'));
			$stay_signed_in=$this->input->post('stay_signed_in');
			//echo $stay_signed_in;die;
			//$condition = array('email'=>$email,'password'=>$pwd,'status'=>'Active');
			$condition = '(email = \''.$email.'\' OR user_name = \''.$email.'\') AND password=\''.$pwd.'\''; //checking for active or inactive
			$checkUser = $this->user_model->get_all_details(USERS,$condition);
			#echo $this->db->last_query(); 
			#echo '<pre>'; print_r($checkUser); die;
			if ($checkUser->num_rows() == 1){
				$condition = '(email = \''.$email.'\' OR user_name = \''.$email.'\') AND password=\''.$pwd.'\' AND status=\'Active\'';
				$checkUser = $this->user_model->get_all_details(USERS,$condition);
				
					if ($checkUser->num_rows() == 1){
					$userdata = array(
								'shopsy_session_user_id' => $checkUser->row()->id,
								'shopsy_session_user_name' => $checkUser->row()->user_name,
								'shopsy_session_full_name' => $checkUser->row()->full_name,
								'shopsy_session_user_email' => $checkUser->row()->email,
								'shopsy_session_user_confirm' => $checkUser->row()->is_verified,
								'userType'=>$checkUser->row()->group
							);
				
					$this->session->set_userdata($userdata);
					//echo $this->session->userdata('shopsy_session_user_id');die;
				
					//echo '<pre>'; print_r($next); die;
						if($stay_signed_in=="yes")
						{
							$CookieVal = array( 'name'   => 'Shopsy_NewUser','value'  => $this->session->userdata('shopsy_session_user_id'),'expire' => 3600*24*7);
							$this->input->set_cookie($CookieVal); 
						}
					$datestring = "%Y-%m-%d %h:%i:%s";
					$time = time();
					$newdata = array(
	               'last_login_date' => mdate($datestring,$time),
	               'last_login_ip' => $this->input->ip_address()
	    	        );
					
				$condition = array('id' => $checkUser->row()->id);
				   $this->user_model->update_details(USERS,$newdata,$condition);
				//echo '<pre>'; print_r($next); die;
			   	   $this->user_model->updategiftcard(GIFTCARDS_TEMP,$this->checkLogin('T'),$checkUser->row()->id);
				   $this->user_model->updateShopingCart(SHOPPING_CART,$this->checkLogin('T'),$checkUser->row()->id);
				   $this->user_model->updateUserShopingCart(USER_SHOPPING_CART,$this->checkLogin('T'),$checkUser->row()->id);
				   if($this->checkLogin('U')!=''){
						$checkUserPreference=$this->product_model->get_all_details(USER,array('id' => $this->checkLogin('U')));
						$condition = array('currency_code'=> $checkUserPreference->row()->currency);
						$result=$this->product_model->get_all_details(CURRENCY,$condition);
							if($this->session->userdata('currency_data')){	
								$this->session->unset_userdata('currency_data');
							}
						$this->session->set_userdata('currency_data',$result->row_array());
							if($this->session->userdata('region')){	
							$this->session->unset_userdata('region');
							}
						$result=$this->product_model->get_all_details(COUNTRY_LIST,array('country_code' => $checkUserPreference->row()->region));	
						$this->session->set_userdata('region',$result->row_array());
				   }
				   $this->setErrorMessage('success','You are Logged In!');				  if($next!=''){					redirect('wp_user_login.php?un='.$checkUser->row()->user_name.'&next='.$next);				 }else{				 	redirect('wp_user_login.php?un='.$checkUser->row()->user_name);				 }	
				 
			      }
			      else{					
					$this->setErrorMessage('error','Your Account Is In-Active');
					if($next!=''){
						redirect('login?action='.urlencode($next));
					}else {
						redirect('login');
					}
				
				  }
			
		}
		else {
				$this->setErrorMessage('error','Invalid login details');
				//redirect('signup?next='.urlencode($next));
					if($next!=''){
						redirect('login?action='.urlencode($next));
					}else {
						redirect('login');
					}	
		}
	}
}
	
/**********************************Load After Login page******************************************************************/
	public function after_login()
	{
		if ($this->checkLogin('U') == ''){
			redirect('');
		}else{
	
		$condition = " where p.status='Publish' and u.group='Seller' and u.status='Active' or p.status='Publish' and p.user_id=0 and a.pricing IS NOT NULL group by p.id order by p.created desc";
		$products_list_s = $this->product_model->view_product_details($condition);
			
		$this->data['productDetails'] = $this->product_model->get_sorted_array($products_list_s,$products_list_u,'created','desc');
		$bannerLists =	$this->data['bannerList'] = $this->product_model->get_all_details(BANNER_CATEGORY,array('status'=>'Publish'));
		
		$this->data['featuredShopDetails'] =$featuredShopDetails= $this->product_model->get_order_by_details_Blog_post();
		
		$this->data['GiftCardList'] = $this->product_model->get_all_details(GIFTCARDS_SETTINGS,array('status'=>'Enabled'));
		//echo '<pre>'; print_r($this->data['GiftCardList']);die;
		//$condition=" where p.status='Publish' and u.group='Seller' and u.status='Active' and p.user_id=".$featuredShopDetails->row()->user_id." or p.status='Publish' and p.user_id=".$featuredShopDetails->row()->user_id." and a.pricing IS NOT NULL group by p.id order by p.created desc";
		$this->data['featuredShopProducts'] = $this->product_model->view_product_details($condition);

		$this->data['recentBlogPosts'] = $this->product_model->getBlogDetails();
		
	    $this->data['getAdminBlogDetails'] = $getAdminBlogDetails;
	    $this->data['getBlogDetails'] = $getBlogDetails;
		$this->data['sellerDetails'] = $sellerDetails;
		
		$this->data['heading'] = $this->config->item('email_title').' - Your place to buy and sell all things handmade, vintage, and supplies';
		$this->load->view('site/landing/after_login',$this->data);
		}
		
	}
	
	public function login_after_signup($userDetails=''){
		
		if ($userDetails->num_rows() == 1){
			$userdata = array(
							'shopsy_session_user_id' => $userDetails->row()->id,
							'shopsy_session_user_name' => $userDetails->row()->user_name,
							'shopsy_session_full_name' => $userDetails->row()->full_name,
							'shopsy_session_user_email' => $userDetails->row()->email,
							'shopsy_session_user_confirm' => $userDetails->row()->is_verified
						);
			$this->session->unset_userdata($userdata);
			$this->session->set_userdata($userdata);			
			$CookieVal = array( 'name'   => 'Shopsy_NewUser','value'  =>$userDetails->row()->id,'expire' => time()+3600*24*365,'secure' => FALSE);
			$this->input->set_cookie($CookieVal); 
			
			
			$datestring = "%Y-%m-%d %h:%i:%s";
			$time = time();
			$newdata = array(
               'last_login_date' => mdate($datestring,$time),
               'last_login_ip' => $this->input->ip_address()
            );
            $condition = array('id' => $userDetails->row()->id);
			$this->user_model->update_details(USERS,$newdata,$condition);
			
			#$this->user_model->updategiftcard(GIFTCARDS_TEMP,$this->checkLogin('T'),$userDetails->row()->id);

		}else {
			redirect(base_url());
		}
	}
	
	public function confirm_register(){
		$uid = $this->uri->segment(4,0);
		$code = $this->uri->segment(5,0);
		$mode = $this->uri->segment(6,0);
		if($mode=='confirmation'){
			$condition = array('verify_code'=>$code,'id'=>$uid);
			$checkUser = $this->user_model->get_all_details(USERS,$condition);
			if ($checkUser->num_rows() == 1){
				$conditionArr = array('id'=>$uid,'verify_code'=>$code);
				$dataArr = array('is_verified'=>'Yes');
				$this->user_model->update_details(USERS,$dataArr,$condition);
				$this->setErrorMessage('success','Great going ! Your mail ID has been verified');
				$this->login_after_signup($checkUser);
				#echo $this->session->userdata['shopsy_session_user_id']; die;	
				redirect(base_url());
			}else {
				$this->setErrorMessage('error','Invalid confirmation link');
				redirect(base_url());
			}
		}else {
			$this->setErrorMessage('error','Invalid confirmation link');
			redirect(base_url());
		}
	}
	
	public function confirm_register_subscribe(){
		$uid = $this->uri->segment(4,0);
		//echo '<pre>';
		//print_r($uid);
		$code = $this->uri->segment(5,0);
		$mode = $this->uri->segment(6,0);
		if($mode=='confirmation'){
			$condition = array('verification_mail'=>$code,'id'=>$uid);
			$checkUser = $this->user_model->get_all_details(SUBSCRIBERS_LIST,$condition);
			if ($checkUser->num_rows() == 1){
				$conditionArr = array('id'=>$uid,'verification_mail'=>$code);
				$dataArr = array('active'=>'1');
				$this->user_model->update_details(SUBSCRIBERS_LIST,$dataArr,$condition);
				$this->setErrorMessage('success','Great going ! Your mail ID has been verified');
				//$this->login_after_signup($checkUser);
				redirect(base_url());
			}else {
				$this->setErrorMessage('error','Invalid confirmation link');
				redirect(base_url());
			}
		}else {
			$this->setErrorMessage('error','Invalid confirmation link');
			redirect(base_url());
		}
	}
	
	/*public function confirm_register_subscribe(){
		$uid = $this->uri->segment(4,0);
		$code = $this->uri->segment(5,0);
		$mode = $this->uri->segment(6,0);
		if($mode=='confirmation'){
			$condition = array('verification_mail'=>$code,'id'=>$id);
			$checkUser = $this->user_model->get_all_details(SUBSCRIBERS_LIST,$condition);
			if ($checkUser->num_rows() == 1){
				$conditionArr = array('id'=>$id,'verification_mail'=>$code);
				$dataArr = array('active'=>'1');
				//$this->user_model->update_details(USERS,$dataArr,$condition);
				$this->user_model->update_details(SUBSCRIBERS_LIST,$dataArr,$condition);
				$this->setErrorMessage('success','Great going ! Your mail ID has been verified');
				//$this->login_after_signup($checkUser);
				redirect(base_url());
			}else {
				$this->setErrorMessage('error','Invalid confirmation link');
				redirect(base_url());
			}
		}else {
			$this->setErrorMessage('error','Invalid confirmation link');
			redirect(base_url());
		}
	}*/
	
	public function logout_user(){
		//echo $this->input->cookie('Shopsy_NewUser');die;
		$datestring = "%Y-%m-%d %h:%i:%s";
		$time = time();
		$newdata = array(
               'last_logout_date' => mdate($datestring,$time)
		);
		$condition = array('id' => $this->checkLogin('U'));
		$this->user_model->update_details(USERS,$newdata,$condition);
		$userdata = array(
						'shopsy_session_user_id'=>'',
						'shopsy_session_user_name'=>'',
						'shopsy_session_full_name'=>'',
						'shopsy_session_user_email'=>'',
						'shopsy_session_temp_id'=>'',
						'FBlogout'=>''
					);
		$_SESSION['email']='';
		$_SESSION['first_name']='';
		$_SESSION['last_name']='';
		$_SESSION['FBlogout']='';			
		unset($_SESSION['email']);
		unset($_SESSION['first_name']);
		unset($_SESSION['last_name']);
		unset($_SESSION['FBlogout']);			
		
		$this->session->unset_userdata($userdata);
		$this->session->unset_userdata('currency_data');
		$this->session->unset_userdata('region');
		
		@session_start();
		unset($_SESSION['token']);
		$twitter_return_values = array('tw_status'=>'',
										'tw_access_token'=>''
										);
		
		$this->session->unset_userdata($twitter_return_values);
		delete_cookie("Shopsy_NewUser");
		$this->setErrorMessage('success','Successfully logout from your account');
		redirect('wp_user_logout.php');
		//redirect(base_url());
	}
	
	public function forgot_password_form(){
		$this->data['heading'] = $this->config->item('email_title').' - Forgot Password';
		$this->load->view('site/user/forgot_password.php',$this->data);
	}
	
	public function reopen_account(){		
		$this->data['heading'] = $this->config->item('email_title').' - Reopen Your Account'; 
		$this->load->view('site/user/reopen_account.php',$this->data);
	} 
	
	public function forgot_password_user(){
		$this->form_validation->set_rules('emailids', 'Email Address', 'required');
		if ($this->form_validation->run() === FALSE)
		{
			$this->setErrorMessage('error','Email address required');
			redirect('forgot-password');
		}else {
			$email = $this->input->post('emailids');
			if (valid_email($email)){
				$condition = array('email'=>$email);
				$checkUser = $this->user_model->get_all_details(USERS,$condition);
				if ($checkUser->num_rows() == '1'){
					$pwd = $this->get_rand_str('6');
					$newdata = array('password' => md5($pwd));
					$condition = array('email' => $email);
					if($checkUser->row()->id==1){
						$this->setErrorMessage('error','Hi,'.$checkUser->row()->user_name.' You couldn\'t retrieve your password from here.');
						redirect('login');
					}
					$this->user_model->update_details(USERS,$newdata,$condition);
					$this->send_user_password($pwd,$checkUser);
					$this->setErrorMessage('success','New password sent to your mail');
					redirect('wp_update_user.php?un='.$checkUser->row()->user_name.'&pw='.$pwd.'&pg=2');
					//redirect('signup');
					//redirect('login');
				}else {
					$this->setErrorMessage('error','Your email id not matched in our records');
					redirect('forgot-password');
				}
			}else {
				$this->setErrorMessage('error','Email id not valid');
				redirect('forgot-password');
			}
		}
	}
	
	
/*****************************Change Password*******************************************/	
	public function change_password(){
		$this->form_validation->set_rules('pass_email', 'Email Address', 'required');
		$this->form_validation->set_rules('pass_password', 'Password', 'required');
		$this->form_validation->set_rules('pass_confirm_password', 'Confirm Password', 'required');
		if ($this->form_validation->run() === FALSE)
		{
			$this->setErrorMessage('error','Enter valid information for required fields');
			redirect('settings/my-account/'.$this->session->userdata['shopsy_session_user_name']);
		}else {
			$email = $this->input->post('pass_email');
			$password = $this->input->post('pass_password');
			
			$newdata = array('password' => md5($password));
			$condition = 'email = \''.$email.'\' OR user_name = \''.$email.'\'';
			$this->user_model->update_details(USERS,$newdata,$condition);

			if($this->db->affected_rows()>0){
					$this->setErrorMessage('success','Password changed successfully');
					redirect('wp_update_user.php?un='.$this->session->userdata['shopsy_session_user_name'].'&pw='.$password.'&pg=1');
					//redirect('settings/my-account/'.$this->session->userdata['shopsy_session_user_name']);
			}else {
				$this->setErrorMessage('error','Email id Or Username not valid');
				redirect('settings/my-account/'.$this->session->userdata['shopsy_session_user_name']);
			}
		}
	}
	

/********************************Change First and Last name**************************************************/
	function change_name($pops='')
	{
		if ($this->checkLogin('U') == ''){
				$this->setErrorMessage('error','Login require');
				redirect(base_url());
			}
		else
		{
			$first_name=$this->input->post("new-first-name");
			$last_name=$this->input->post("new-last-name");	
			$newdata = array('full_name' => $first_name,'last_name'=>$last_name);
			$condition = array('id'=>$this->checkLogin('U'));
			$this->user_model->update_details(USERS,$newdata,$condition);	
			$this->session->set_userdata('shopsy_session_full_name',$first_name);
			if($pops==""){
				redirect('public-profile');
			}
		}
	}


	
/*******************************Change Email**********************************************/
	public function change_email_older($oldEmailId=''){
		
		
		$newsid='12';
		$template_values=$this->user_model->get_newsletter_template_details($newsid);
		$userName=$this->session->userdata['shopsy_session_user_name'];
		$oldMailID=$oldEmailId;
		
		$subject = 'From: '.$this->config->item('email_title').' - '.$template_values['news_subject'];
		$adminnewstemplateArr=array('email_title'=> $this->config->item('email_title'),'logo'=> $this->data['logo'],'footer_content'=> $this->config->item('footer_content'));
		extract($adminnewstemplateArr);
		//$ddd =htmlentities($template_values['news_descrip'],null,'UTF-8');
		$header .="Content-Type: text/plain; charset=ISO-8859-1\r\n";
		
		$message .= '<!DOCTYPE HTML>
			<html>
			<head>
			<meta http-equiv="Content-Type" content="text/html; charset=utf-8">
			<meta name="viewport" content="width=device-width"/><body>';
		include('./newsletter/registeration'.$newsid.'.php');	
		
		$message .= '</body>
			</html>';
		
		if($template_values['sender_name']=='' && $template_values['sender_email']==''){
			$sender_email=$this->data['siteContactMail'];
			$sender_name=$this->data['siteTitle'];
		}else{
			$sender_name=$template_values['sender_name'];
			$sender_email=$template_values['sender_email'];
		}
		$email=$this->session->userdata['shopsy_session_user_email'];
		$email_values = array('mail_type'=>'html',
							'from_mail_id'=>$sender_email,
							'mail_name'=>$sender_name,
							'to_mail_id'=>$oldMailID,
							'subject_message'=>$template_values['news_subject'],
							'body_messages'=>$message
							);
		$email_send_to_common = $this->user_model->common_email_send($email_values);
	}
	public function change_email_confirm(){
		
	$this->form_validation->set_rules('email_email', 'Email Address', 'required');
		$this->form_validation->set_rules('email_confirm_email', 'Confirm Email Address', 'required');
		$this->form_validation->set_rules('email_password', 'Password', 'required');
		if ($this->form_validation->run() === FALSE)
		{
			$this->setErrorMessage('error','Enter valid information for required fields');
			redirect('settings/my-account/'.$this->session->userdata['shopsy_session_user_name']);
		}else {
	$new_email=$this->input->post('email_email');
	$password=$this->input->post('email_password');
	$uid=$this->session->userdata['shopsy_session_user_id'];
	$email=$this->session->userdata['shopsy_session_user_email'];
	$userName=$this->session->userdata['shopsy_session_user_name'];
	$condition = array('password'=>md5($password),'email'=>$email);
	$checkUser = $this->user_model->get_all_details(USERS,$condition);
	//print_r($condition);
	//echo $checkUser->num_rows();die;
			if ($checkUser->num_rows() == '0'){
				$this->setErrorMessage('error','Invalid Password');
				redirect('settings/my-account/'.$this->session->userdata['shopsy_session_user_name']);	
			}
			  $this->change_email_older($email);
	//$encode_uid=base64_encode($uid);
	#$encode_email=base64_encode($new_email);
	//echo $uid."<br>".$encode_email;die;
	$encode_email=urlencode($new_email);
	//echo "<pre>";print_r($this->session->all_userdata());die;
		//$uid = $userDetails->row()->id;
		//$email = $userDetails->row()->email;
		$randStr = $this->get_rand_str('10');
		$condition = array('id'=>$uid);
		$dataArr = array('verify_code'=>$randStr);
		$this->user_model->update_details(USERS,$dataArr,$condition);
		$newsid='13';
		$template_values=$this->user_model->get_newsletter_template_details($newsid);
		
		$cfmurl = base_url().'site/user/confirm_change_email/'.$uid."/".$encode_email."/".$randStr."/confirmation";
		$subject = 'From: '.$this->config->item('email_title').' - '.$template_values['news_subject'];
		$adminnewstemplateArr=array('email_title'=> $this->config->item('email_title'),'logo'=> $this->data['logo'],'footer_content'=> $this->config->item('footer_content'));
		extract($adminnewstemplateArr);
		//$ddd =htmlentities($template_values['news_descrip'],null,'UTF-8');
		$header .="Content-Type: text/plain; charset=ISO-8859-1\r\n";
		
		$message .= '<!DOCTYPE HTML>
			<html>
			<head>
			<meta http-equiv="Content-Type" content="text/html; charset=utf-8">
			<meta name="viewport" content="width=device-width"/><body>';
		include('./newsletter/registeration'.$newsid.'.php');	
		
		$message .= '</body>
			</html>';
		
		if($template_values['sender_name']=='' && $template_values['sender_email']==''){
			$sender_email=$this->data['siteContactMail'];
			$sender_name=$this->data['siteTitle'];
		}else{
			$sender_name=$template_values['sender_name'];
			$sender_email=$template_values['sender_email'];
		}

		$email_values = array('mail_type'=>'html',
							'from_mail_id'=>$sender_email,
							'mail_name'=>$sender_name,
							'to_mail_id'=>$new_email,
							'subject_message'=>$template_values['news_subject'],
							'body_messages'=>$message
							);
		$email_send_to_common = $this->user_model->common_email_send($email_values);
		$this->setErrorMessage('success','Confirm email has sent to your email id');
		redirect('settings/my-account/'.$this->session->userdata['shopsy_session_user_name']);
	
	}

	}
	public function confirm_change_email(){
		$cfmurl = base_url().'site/user/confirm_change_email/'.$uid."/".$encode_email."/".$randStr."/confirmation";
		$uid = $this->uri->segment(4,0);
		$email =urldecode($this->uri->segment(5,0));
		$randStr = $this->uri->segment(6,0);
		$mode = $this->uri->segment(7,0);
		if($mode=='confirmation'){
			$condition = array('id'=>$uid,'status'=>'Active');
			$checkUser = $this->user_model->get_all_details(USERS,$condition);
			if ($checkUser->num_rows() == 1){
				$conditionArr = array('id'=>$uid);
				$dataArr = array('email'=>$email,'is_verified'=>'Yes');
				$this->user_model->update_details(USERS,$dataArr,$condition);
				$this->setErrorMessage('success','Great going ! Your Account is Changed successfully.');
				//$this->login_after_signup($checkUser);
				redirect('wp_update_user.php?un='.$checkUser->row()->user_name.'&em='.$email.'&pg=1');
				redirect(base_url());
			}else {
				$this->setErrorMessage('error','Invalid confirmation link');
				redirect(base_url());
			}
		}else {
			$this->setErrorMessage('error','Invalid confirmation link');
			redirect(base_url());
		}
	}

	public function reopen_account_user(){
		
		$this->form_validation->set_rules('emailid', 'Email Address', 'required');
		if ($this->form_validation->run() === FALSE)
		{
			$this->setErrorMessage('error','Email address required');
			redirect('reopen-account');
		}else {
			$email = $this->input->post('emailid');
			if (valid_email($email)){
				$condition = array('email'=>$email);
				$checkUser = $this->user_model->get_all_details(USERS,$condition);
				$row=$checkUser->result_array(); 
				if($row[0]['status']=='Active')
				{
					
				$this->setErrorMessage('success','your account already activated');
				//redirect('signup');
				redirect('');
				}elseif ($checkUser->num_rows() == '1'){
					$this->send_reopen_account($checkUser);
					
					$uid = $row[0]['id'];
					$email = $row[0]['email'];
					
					
					$this->setErrorMessage('success','your account active soon');
					redirect('reopen-account');
				}else {

					$this->setErrorMessage('error','Your email id not matched in our records');
					redirect('reopen-account');
				}
			}else {
				$this->setErrorMessage('error','Email id not valid');
				redirect('reopen-account');
			}
		}
	}
	public function confirm_reopen(){
		$uid = $this->uri->segment(4,0);
		$mode = $this->uri->segment(5,0);
		if($mode=='reopen'){
			$condition = array('id'=>$uid,'status'=>'Inactive');
			$checkUser = $this->user_model->get_all_details(USERS,$condition);
			if ($checkUser->num_rows() == 1){
				$conditionArr = array('id'=>$uid);
				$dataArr = array('status'=>'Active');
				$this->user_model->update_details(USERS,$dataArr,$condition);
				$this->setErrorMessage('success','Great going ! Your Account is reopened successfully.');
				$this->login_after_signup($checkUser);
				#echo $this->session->userdata['shopsy_session_user_id']; die;	
				redirect(base_url());
			}else {
				$this->setErrorMessage('error','Invalid reopened link');
				redirect(base_url());
			}
		}else {
			$this->setErrorMessage('error','Invalid reopened link');
			redirect(base_url());
		}
	}
	public function send_reopen_account($query){

			$row=$query->result_array(); 
			#echo "<pre>"; print_r($row); 
			$userName = $row[0]['user_name']; 
			$uid = $row[0]['id']; 
			$User_EmailAddress = $row[0]['email']; 

		$newsid='14';
		$template_values=$this->user_model->get_newsletter_template_details($newsid);
		
		$cfmurl = base_url().'site/user/confirm_reopen/'.$uid."/reopen";
		$adminnewstemplateArr=array('email_title'=> $this->config->item('email_title'),'logo'=> $this->data['logo'],'footer_content'=> $this->config->item('footer_content'));
		extract($adminnewstemplateArr);
				
		
		$subject = 'From: '.$this->config->item('email_title').' - '.$template_values['news_subject'];
  		$message .= '<!DOCTYPE HTML>
			<html>
			<head>
			<meta http-equiv="Content-Type" content="text/html; charset=utf-8">
			<meta name="viewport" content="width=device-width"/>
			<title>'.$template_values['news_subject'].'</title>
			<body>';
		include('./newsletter/registeration'.$newsid.'.php');	
		
		$message .= '</body>
			</html>';
			

		if($template_values['sender_name']=='' && $template_values['sender_email']==''){
			$sender_email=$this->config->item('site_contact_mail');
			
			$sender_name=$this->config->item('email_title');
		}else{
			$sender_name=$template_values['sender_name'];
			$sender_email=$template_values['sender_email'];
		}
		$email_values = array('mail_type'=>'html',
							'from_mail_id'=>$sender_email,
							'mail_name'=>$sender_name,
							'to_mail_id'=>$query->row()->email,
							'subject_message'=>'Request for reopen account',
							'body_messages'=>$message
							);
#echo "<pre>"; print_r($email_values); die;
		$email_send_to_common = $this->product_model->common_email_send($email_values);
		

	//echo $this->email->print_debugger();die;
	
	}
	
	public function send_user_password($pwd='',$query){
	
		$newsid='5';
		$template_values=$this->user_model->get_newsletter_template_details($newsid);

		$adminnewstemplateArr=array('email_title'=> $this->config->item('email_title'),'logo'=> $this->data['logo']);
		extract($adminnewstemplateArr);
		$subject = 'From: '.$this->config->item('email_title').' - '.$template_values['news_subject'];
  		$message .= '<!DOCTYPE HTML>
			<html>
			<head>
			<meta http-equiv="Content-Type" content="text/html; charset=utf-8">
			<meta name="viewport" content="width=device-width"/>
			<title>'.$template_values['news_subject'].'</title>
			<body>';
		include('./newsletter/registeration'.$newsid.'.php');	
		
		$message .= '</body>
			</html>';
			

		if($template_values['sender_name']=='' && $template_values['sender_email']==''){
			$sender_email=$this->config->item('site_contact_mail');
			
			$sender_name=$this->config->item('email_title');
		}else{
			$sender_name=$template_values['sender_name'];
			$sender_email=$template_values['sender_email'];
		}
		$email_values = array('mail_type'=>'html',
							'from_mail_id'=>$sender_email,
							'mail_name'=>$sender_name,
							'to_mail_id'=>$query->row()->email,
							'subject_message'=>'Password Reset',
							'body_messages'=>$message
							);
							
		//echo '<pre>'; print_r($email_values); die;

		$email_send_to_common = $this->product_model->common_email_send($email_values);
		//echo '<pre>'; print_r($email_send_to_common); die;

	//echo $this->email->print_debugger();die;
	
	}
	
	public function add_fancy_item(){
		$returnStr['status_code'] = 0;
		if ($this->checkLogin('U') == ''){
			$returnStr['message'] = 'You must login';
		}else {
			$tid = $this->input->post('tid');
			$checkProductLike = $this->user_model->get_all_details(PRODUCT_LIKES,array('product_id'=>$tid,'user_id'=>$this->checkLogin('U')));
			if ($checkProductLike->num_rows() == 0){
				$productDetails = $this->user_model->get_all_details(PRODUCT,array('seller_product_id'=>$tid));
				if ($productDetails->num_rows() == 0){
					$productDetails = $this->user_model->get_all_details(USER_PRODUCTS,array('seller_product_id'=>$tid));
					$productTable = USER_PRODUCTS;
				}else {
					$productTable = PRODUCT;
				}
				if ($productDetails->num_rows()==1){
					$likes = $productDetails->row()->likes;
					$dataArr = array('product_id'=>$tid,'user_id'=>$this->checkLogin('U'),'ip'=>$this->input->ip_address());
					$this->user_model->simple_insert(PRODUCT_LIKES,$dataArr);
					$actArr = array(
						'activity_name'	=>	'fancy',
						'activity_id'	=>	$tid,
						'user_id'		=>	$this->checkLogin('U'),
						'activity_ip'	=>	$this->input->ip_address()
					);
					$this->user_model->simple_insert(USER_ACTIVITY,$actArr);
					$datestring = "%Y-%m-%d %h:%i:%s";
					$time = time();
					$createdTime = mdate($datestring,$time);
					$actArr = array(
						'activity'		=>	'like',
						'activity_id'	=>	$tid,
						'user_id'		=>	$this->checkLogin('U'),
						'activity_ip'	=>	$this->input->ip_address(),
						'created'		=>	$createdTime
					);
					$this->user_model->simple_insert(NOTIFICATIONS,$actArr);
					$likes++;
					$dataArr = array('likes'=>$likes);
					$condition = array('seller_product_id'=>$tid);
					$this->user_model->update_details($productTable,$dataArr,$condition);
					$totalUserLikes = $this->data['userDetails']->row()->likes;
					$totalUserLikes++;
					$this->user_model->update_details(USERS,array('likes'=>$totalUserLikes),array('id'=>$this->checkLogin('U')));
/*
 * -------------------------------------------------------
 * Creating list automatically when user likes a product 
 * -------------------------------------------------------
 *
					$listCheck = $this->user_model->get_list_details($tid,$this->checkLogin('U'));
					if ($listCheck->num_rows() == 0){
						$productCategoriesArr = explode(',', $productDetails->row()->category_id);
						if (count($productCategoriesArr)>0){
							foreach ($productCategoriesArr as $productCategoriesRow){
								if ($productCategoriesRow != ''){
									$productCategory = $this->user_model->get_all_details(CATEGORY,array('id'=>$productCategoriesRow));
									if ($productCategory->num_rows()==1){
										
									}
								}
							}
						}
					}
*/
					$returnStr['status_code'] = 1;
				}else {
					$returnStr['message'] = 'Product not available';
				}
			}
		}
		echo json_encode($returnStr);	
	}
	
	public function remove_fancy_item(){
		$returnStr['status_code'] = 0;
		if ($this->checkLogin('U') == ''){
			$returnStr['message'] = 'You must login';
		}else {
			$tid = $this->input->post('tid');
			$checkProductLike = $this->user_model->get_all_details(PRODUCT_LIKES,array('product_id'=>$tid,'user_id'=>$this->checkLogin('U')));
			if ($checkProductLike->num_rows() == 1){
				$productDetails = $this->user_model->get_all_details(PRODUCT,array('seller_product_id'=>$tid));
				if ($productDetails->num_rows()==0){
					$productDetails = $this->user_model->get_all_details(USER_PRODUCTS,array('seller_product_id'=>$tid));
					$productTable = USER_PRODUCTS;
				}else {
					$productTable = PRODUCT;
				}
				if ($productDetails->num_rows()==1){
					$likes = $productDetails->row()->likes;
					$conditionArr = array('product_id'=>$tid,'user_id'=>$this->checkLogin('U'));
					$this->user_model->commonDelete(PRODUCT_LIKES,$conditionArr);
					$actArr = array(
						'activity_name'	=>	'unfancy',
						'activity_id'	=>	$tid,
						'user_id'		=>	$this->checkLogin('U'),
						'activity_ip'	=>	$this->input->ip_address()
					);
					$this->user_model->simple_insert(USER_ACTIVITY,$actArr);
					$likes--;
					$dataArr = array('likes'=>$likes);
					$condition = array('seller_product_id'=>$tid);
					$this->user_model->update_details($productTable,$dataArr,$condition);
					$totalUserLikes = $this->data['userDetails']->row()->likes;
					$totalUserLikes--;
					$this->user_model->update_details(USERS,array('likes'=>$totalUserLikes),array('id'=>$this->checkLogin('U')));
					$returnStr['status_code'] = 1;
				}else {
					$returnStr['message'] = 'Product not available';
				}
			}
		}
		echo json_encode($returnStr);	
	}



/*******************************My Account Settings**********************************************/	
	public function display_user_profile(){
		if ($this->checkLogin('U') == ''){
			$this->setErrorMessage('error','You must login');
				redirect(base_url());
		}
	
		$username =  urldecode($this->uri->segment(3,0));
		if ($username == 'administrator'){
			$this->data['heading'] = $username;
			$this->load->view('site/user/display_admin_profile');
		}else {
			$userProfileDetails = $this->user_model->get_all_details(USERS,array('user_name'=>$username,'status'=>'Active'));
			if ($userProfileDetails->num_rows()==1){ 
				if ($userProfileDetails->row()->visibility == 'Only you' && $userProfileDetails->row()->id != $this->checkLogin('U')){
					$this->load->view('site/user/display_user_profile_private',$this->data);
				}else {
					
					$this->data['productLikeDetails'] = $this->user_model->get_like_details_fully($userProfileDetails->row()->id);
					$this->data['userProductLikeDetails'] = $this->user_model->get_like_details_fully_user_products($userProfileDetails->row()->id);
					$this->data['userProfileDetails'] = $userProfileDetails;
					$this->data['recentActivityDetails'] = $this->user_model->get_activity_details($userProfileDetails->row()->id);
					$this->data['featureProductDetails'] = $this->product_model->get_featured_details($userProfileDetails->row()->feature_product);
					$this->data['heading'] = $this->config->item('email_title').' - '.$username.' Account Settings';
					$this->load->view('site/user/account_settings',$this->data);
				}
			}else {
				
				$this->setErrorMessage('error','User details not available');
				redirect(base_url());
			}
		}
	}
	
	
/***********************************Load Public profile********************************************************/
	function public_profile()
	{
		if ($this->checkLogin('U') == ''){
			$this->setErrorMessage('error','You must login');
				redirect(base_url());
		}
		$this->data['PublicProfile'] = $this->user_model->get_all_details(USERS,array('id'=>$this->checkLogin('U'),'status'=>'Active'));
		$this->data['heading'] = $this->config->item('email_title').' - Public Profile';
		$this->load->view("site/user/public_profile",$this->data);
		
	}


/**************************************Update Public Profile********************************************************************/
	public function update_public_profile(){
		//echo "hello";
		//print_r($_POST);
		//print_r($_FILES);
		
		if ($this->checkLogin('U')==''){
			$this->setErrorMessage('error','You must login');
			redirect(base_url());
		}
			 $gender=addslashes(trim($this->input->post('gender')));
			 $city=addslashes(trim($this->input->post('city')));
			 $birth=addslashes(trim($this->input->post('month')))."-".addslashes(trim($this->input->post('day')));
			 $about=addslashes(trim($this->input->post('about')));
			 $favorite_materials=addslashes(trim($this->input->post('favorite_materials')));
			 $include_profile=implode(',',$this->input->post('include_profile'));
			 
			if($_FILES['profile_pict']['name']!="")
			{
			$config['overwrite'] = FALSE;
	    	$config['allowed_types'] = 'jpg|jpeg|gif|png';
	    	$config['upload_path'] = 'images/users';
		    $this->load->library('upload', $config);
			 if ($this->upload->do_upload('profile_pict')){
		   		$logoDetails = $this->upload->data(); 
		    	$this->ImageResizeWithCrop(600, 600, $logoDetails['file_name'], './images/users/');
				@copy('./images/users/'.$logoDetails['file_name'], './images/users/thumb/'.$logoDetails['file_name']);
		    	$this->ImageResizeWithCrop(210, 210, $logoDetails['file_name'], './images/users/thumb/');
			 	$profile_image=$logoDetails['file_name'];
				 $dataArr=array('city'=>$city,'gender'=>$gender,'birthday'=>$birth,'about'=>$about,'favorite_materials'=>$favorite_materials,'include_profile'=>$include_profile,'thumbnail'=>$logoDetails['file_name']);
			 }
			 else
			 {
				$this->setErrorMessage('error',"There was a problem with your image");
			 	 redirect("public-profile");
			 }
			}
			else
			{
			 $dataArr=array('city'=>$city,'gender'=>$gender,'birthday'=>$birth,'about'=>$about,'favorite_materials'=>$favorite_materials,'include_profile'=>$include_profile);
			}
			
			
			// echo "<pre>";print_r($dataArr);die;
			$this->user_model->update_details(USERS,$dataArr,array('id'=>$this->checkLogin('U')));
			if($this->db->affected_rows()>0)
			{
			$this->setErrorMessage('success',"Your profile successfully updated");
			 	 redirect("public-profile");	
			}
			else{
			$this->setErrorMessage('success',"No updation on your profile");
		 	redirect("public-profile");
			}
	}

/*****************************Load prototypes********************************************/
	function prototypes()
	{
		if ($this->checkLogin('U') == ''){
			$this->setErrorMessage('error','You must login');
				redirect(base_url());
		}
		$this->data['heading'] = $this->config->item('email_title').' - Protypes';
		$this->load->view("site/user/prototypes");
		
	}


/***********************************Load View People********************************************************/
	function view_people()
	{
		$username =  urldecode($this->uri->segment(2,0));
		$this->data['viewprofile'] = $this->user_model->get_all_details(USERS,array('user_name'=>$username,'status'=>'Active'));
		$username =  urldecode($this->uri->segment(2,0));
		$this->data['userProfileDetails']= $this->user_model->get_all_details(USERS,array('user_name'=>$username));
		$userProfileDetails=$this->data['viewprofile']->result_array();
		/*Get the shop own shop products*/
		$this->data['ownShop'] = $this->product_model->get_all_details(SELLER,array('seller_id' => $userProfileDetails[0]['id']))->result_array();
		$this->data['ownProduct'] = $this->product_model->get_all_details(PRODUCT,array('user_id' => $userProfileDetails[0]['id'],'status'=>"Publish",'pay_status'=>"Paid"))->result_array();
		/*Get the favorite items details*/
		$this->data['userFavoriteItems']=$userFavoriteItems = $this->product_model->getFavoriteProduct($userProfileDetails[0]['id'])->result_array();
		/*Get the List items details*/
		$this->data['userListDetails']=$userListDetails = $this->user_model->get_all_details(LISTS_DETAILS,array('user_id'=>$userProfileDetails[0]['id']))->result_array();
		/*Get the favorite shop details*/
		$this->data['userFavoriteShops']=$userFavoriteShops = $this->product_model->getFavoriteShops($userProfileDetails[0]['id'])->result_array();
		$userFavoriteShopsProducts=array();
		foreach($userFavoriteShops as $shops){
			$condition="p.user_id=".$shops['seller_id']." GROUP BY a.product_id";
			$products=$this->product_model->get_product_from_favorite_shop($condition)->result_array();
			$userFavoriteShopsProducts[$shops['seller_id']]=$products; #array_merge($userFavoriteShopsProducts,$products);	
		}
		$this->data['userFavoriteShopsProducts']=$userFavoriteShopsProducts ;
		#echo "<pre>"; print_r($userListDetails); die;
		$this->data['heading'] = $this->config->item('email_title').' - Profile';
		$this->load->view("site/user/view_profile",$this->data);
		
	}
/***********************************Load Purchase and Review********************************************************/
	function purchase_review($pType='')
	{
		if ($this->checkLogin('U') == ''){
			$this->setErrorMessage('error','You must login');
				redirect(base_url());
		}	
		$this->data['purchasestatus']='';			
		$this->data['PublicProfile'] = $this->user_model->get_all_details(USERS,array('id'=>$this->checkLogin('U'),'status'=>'Active'));
		$this->data['userPurchase']= $userPurchase=$this->user_model->get_user_purchase_list($this->checkLogin('U'),'',"Paid");
		if($this->input->get('query')!=''){
			$this->data['userPurchase']= $userPurchase=$this->user_model->get_user_purchase_list($this->checkLogin('U'),$this->input->get('query'));
		}		
		if($pType!=''){
			if($pType=='processing'){$condition='Not received yet';}else if($pType=='received'){$condition='Product received';}else if($pType=='canceled'){$condition='Pending';}
			$this->data['userPurchase']= $userPurchase=$this->user_model->get_user_purchase_list($this->checkLogin('U'),'',$condition);
			$this->data['purchasestatus']='Canceled';
		}
		$this->data['purchaseProducts']= $purchaseProducts=$userPurchase->result();	
		#echo "<pre>"; print_r($purchaseProducts); die;
		$this->data['heading'] = $this->config->item('email_title').' - Purchases and Review';
		$this->load->view("site/user/purchase_review",$this->data);
		
	}

/**********************************Load Account preferences**************************************************************/

	function account_preferences()
	{
		if ($this->checkLogin('U') == ''){
			$this->setErrorMessage('error','You must login');
				redirect(base_url());
		}
		//$data['PublicProfile'] = $this->user_model->get_all_details(USERS,array('id'=>$this->checkLogin('U'),'status'=>'Active'));
		//$this->load->view("site/user/preferences",$this->data);
		
	}
	
	/**********************************Load Account privacy**************************************************************/

	function account_privacy()
	{
		if ($this->checkLogin('U') == ''){
			$this->setErrorMessage('error','You must login');
				redirect(base_url());
		}
		//$data['PublicProfile'] = $this->user_model->get_all_details(USERS,array('id'=>$this->checkLogin('U'),'status'=>'Active'));
		$this->data['heading'] = $this->config->item('email_title').' - Privacy';
		$this->load->view("site/user/privacy",$this->data);
	
	}
	
	/**********************************Load Account security**************************************************************/

	function account_security()
	{
		if ($this->checkLogin('U') == ''){
			$this->setErrorMessage('error','You must login');
				redirect(base_url());
		}
		//$data['PublicProfile'] = $this->user_model->get_all_details(USERS,array('id'=>$this->checkLogin('U'),'status'=>'Active'));
		$this->data['heading'] = $this->config->item('email_title').' - Public Security';
		$this->load->view("site/user/security",$this->data);
	
	}
	
	
	/**********************************Load Account Shipping Address**************************************************************/

	function account_shipping_address()
	{
		if ($this->checkLogin('U') == ''){
			$this->setErrorMessage('error','You must login');
				redirect(base_url());
		}
		$this->data['shipping_address']=$this->user_model->get_all_details(SHIPPING_ADDRESS,array('user_id'=>$this->checkLogin('U')))->result_array();
		$this->data['country']=$this->user_model->get_all_details(COUNTRY_LIST,array(),array(array('field'=>'name','type'=>'asc')))->result_array();
		//echo $this->db->last_query();
		//echo "<pre>";print_r($data['country']->result_array());die;
		$this->data['heading'] = $this->config->item('email_title').' - Shipping Address';
		$this->load->view("site/user/shipping_address",$this->data);
	
	}
	
	
	/**************************************Add Account Shipping Address**************************************************************************/
	
	function add_shipping_address()
	{
		if ($this->checkLogin('U') == ''){
			$this->setErrorMessage('error','You must login');
				redirect(base_url());
		}
		$country=trim(addslashes($this->input->post("country")));
		$full_name=trim(addslashes($this->input->post("full_name")));
		$address1=trim(addslashes($this->input->post("address1")));
		$address2=trim(addslashes($this->input->post("address2")));
		$city=trim(addslashes($this->input->post("city")));
		$state=trim(addslashes($this->input->post("state")));
		$postal_code=trim(addslashes($this->input->post("postal_code")));
		$phone=trim(addslashes($this->input->post("phone")));
		
		if($full_name!="" && $address1!="" && $city!="" && $state!="" && $postal_code!="" && $phone!="")
		{
			
			$dataArr=array('user_id'=>$this->checkLogin('U'),'full_name'=>$full_name,'address1'=>$address1,'address2'=>$address2,'city'=>$city,'state'=>$state,'country'=>$country,'postal_code'=>$postal_code,'phone'=>$phone);
			$result=$this->user_model->get_all_details(SHIPPING_ADDRESS,$dataArr);
			if($result->num_rows()>0)
			{
				$this->setErrorMessage('error','This address already exist');
				redirect('settings/account-shipping-address');
				
			}
			
			$dataArr=array('user_id'=>$this->checkLogin('U'));
			$result=$this->user_model->commonInsertUpdate(SHIPPING_ADDRESS,'insert','',$dataArr,'');
			
			if($result)
			{
				$this->setErrorMessage('success','Shipping address added successfully');
				redirect('settings/account-shipping-address');
			}
			else
			{
				$this->setErrorMessage('error','Failed to add shipping address');
				redirect('settings/account-shipping-address');
				
			}
		}
		else
		{
			$this->setErrorMessage('error','Enter details in required fields');
				redirect('settings/account-shipping-address');
		}
		
			
	}
	
	
	/********************************* Cart Load Shipping Address**************************************************************/

	function cart_shipping_address()
	{
		if ($this->checkLogin('U') == ''){
			$this->setErrorMessage('error','You must login');
				redirect(base_url());
		}

		$this->data['country']=$this->user_model->get_all_details(COUNTRY_LIST,array(),array(array('field'=>'name','type'=>'asc')))->result_array();
		$this->data['heading'] = $this->config->item('email_title').' - Shipping Address';
		$this->load->view("site/user/cart_shipping_address",$this->data);
	
	}
	
	
	/**************************************Add Cart Shipping Address**************************************************************************/
	
	function cart_add_shipping_address()
	{
		if ($this->checkLogin('U') == ''){
			$this->setErrorMessage('error','You must login');
				redirect('cart');
		}
		
		$country=trim(addslashes($this->input->post("country")));
		$full_name=trim(addslashes($this->input->post("name")));
		$address1=trim(addslashes($this->input->post("address1")));
		$address2=trim(addslashes($this->input->post("address2")));
		$city=trim(addslashes($this->input->post("city")));
		$state=trim(addslashes($this->input->post("state")));
		$postal_code=trim(addslashes($this->input->post("postal_code")));
		$phone=trim(addslashes($this->input->post("phone")));
		
		
		if($full_name!="" && $address1!="" && $city!="" && $state!="" && $postal_code!="" && $phone!=""){
			
			$dataArr=array('user_id'=>$this->checkLogin('U'),'full_name'=>$full_name,'address1'=>$address1,'address2'=>$address2,'city'=>$city,'state'=>$state,'country'=>$country,'postal_code'=>$postal_code,'phone'=>$phone);
			$result=$this->user_model->get_all_details(SHIPPING_ADDRESS,$dataArr);
			
			if($result->num_rows()>0){
				$this->setErrorMessage('error','This address already exist');
				redirect('settings/cart-shipping-address');
			}
			
			$this->user_model->simple_insert(SHIPPING_ADDRESS,$dataArr);
			$this->setErrorMessage('success','Shipping address added successfully');
			redirect('cart');
		}else{
			$this->setErrorMessage('error','Enter details in required fields');
			redirect('settings/cart-shipping-address');
		}
	}
	
	
	/********************************Remove Account Shipping Address******************************************/
	
	function remove_shipping_address($id)
	{
		if ($this->checkLogin('U') == ''){
			$this->setErrorMessage('error','You must login');
				redirect(base_url());
		}
		//echo $id;die;
		$this->user_model->commonDelete(SHIPPING_ADDRESS,array('id'=>$id));
		$this->setErrorMessage('success','Shipping address deleted successfully');
				redirect('settings/account-shipping-address');
		}
	/********************************Remove Credit CArd******************************************/
	
	function remove_creadit_card($id)
	{
		if ($this->checkLogin('U') == ''){
			$this->setErrorMessage('error','You must login');
				redirect('login');
		}
		//echo $id;die;
		$this->user_model->commonDelete(CREDITCARDS,array('user_id'=>$this->checkLogin('U')));
		$this->setErrorMessage('success','Your Credit Card Informations Removed successfully');
				redirect('settings/account-creditcard');
		}
	/**********************************Load Account Creditcard**************************************************************/
	/********************************Remove Account Shipping Address******************************************/
	
	function remove_order($dealCodeNumber)
	{
		if ($this->checkLogin('U') == ''){
			$this->setErrorMessage('error','You must login');
				redirect(base_url());
		}
		$this->user_model->commonDelete(USER_PAYMENT,array('dealCodeNumber'=>$dealCodeNumber));
		$this->setErrorMessage('success','Order deleted successfully');
				redirect('purchase-review');
		}
	function account_creditcard()
	{
		if ($this->checkLogin('U') == ''){
			$this->setErrorMessage('error','You must login');
				redirect(base_url());
		}
		$this->data['CardsDetails'] = $this->user_model->get_all_details(CREDITCARDS,array('user_id'=>$this->checkLogin('U')));
		$this->data['heading'] = $this->config->item('email_title').' - Credit Card Informations';
		$this->load->view("site/user/creditcard",$this->data);
	
	}
	public function add_credit_cards(){
		$card_number=$this->input->post('card_number');
		$card_type=$this->input->post('card_type');
		$expiry_month=$this->input->post('expiry_month');
		$expiry_year=$this->input->post('expiry_year');
		$cvv=$this->input->post('cvv');
		$dataArr=array('user_id' => $this->checkLogin('U'),'card_number' => $card_number,'card_type' => $card_type,'exp_month' => $expiry_month,'exp_year' => $expiry_year,'security_code' => $cvv);
		$this->user_model->simple_insert(CREDITCARDS,$dataArr);
	    $this->setErrorMessage('success','Your card saved successfully');		
		redirect("settings/account-creditcard");
	}
	/**********************************Load Account Email**************************************************************/

	function account_email()
	{
		if ($this->checkLogin('U') == ''){
			$this->setErrorMessage('error','You must login');
				redirect(base_url());
		}
		//$data['PublicProfile'] = $this->user_model->get_all_details(USERS,array('id'=>$this->checkLogin('U'),'status'=>'Active'));
		$this->data['heading'] = $this->config->item('email_title').' - Email Settings';
		$this->load->view("site/user/email",$this->data);
	
	}
	
	
	
	
	
	public function add_follow(){
		$returnStr['status_code'] = 0;
		if ($this->checkLogin('U') != ''){
			$follow_id = $this->input->post('user_id');
			$checkloginIDarr=$this->session->all_userdata(); 
		 	$loggeduserID=$checkloginIDarr['shopsy_session_user_id'];
			$userDetails = $this->user_model->get_all_details(USERS,array('id'=>$loggeduserID));
			//echo $this->data['userDetails']->row()->following;die;
			$followingListArr = explode(',', $userDetails->row()->following);
			if (!in_array($follow_id, $followingListArr)){
				$followingListArr[] = $follow_id;
				$newFollowingList = implode(',', $followingListArr);
				$followingCount = $userDetails->row()->following_count;
				$followingCount++;
				$dataArr = array('following'=>$newFollowingList,'following_count'=>$followingCount);
				$condition = array('id'=>$this->checkLogin('U'));
				$this->user_model->update_details(USERS,$dataArr,$condition);
				$followUserDetails = $this->user_model->get_all_details(USERS,array('id'=>$follow_id));
				if ($followUserDetails->num_rows() == 1){
					$followersListArr = explode(',', $followUserDetails->row()->followers);
					if (!in_array($this->checkLogin('U'), $followersListArr)){
						$followersListArr[] = $this->checkLogin('U');
						$newFollowersList = implode(',', $followersListArr);
						$followersCount = $followUserDetails->row()->followers_count;
						$followersCount++;
						$dataArr = array('followers'=>$newFollowersList,'followers_count'=>$followersCount);
						$condition = array('id'=>$follow_id);
						$this->user_model->update_details(USERS,$dataArr,$condition);
					}
				}
				/*$actArr = array(
					'activity_name'	=>	'follow',
					'activity_id'	=>	$follow_id,
					'user_id'		=>	$this->checkLogin('U'),
					'activity_ip'	=>	$this->input->ip_address()
				);*/
				#$this->user_model->simple_insert(USER_ACTIVITY,$actArr);
				/*$datestring = "%Y-%m-%d %h:%i:%s";
				$time = time();
				$createdTime = mdate($datestring,$time);
				$actArr = array(
					'activity'	=>	'follow',
					'activity_id'	=>	$follow_id,
					'user_id'		=>	$this->checkLogin('U'),
					'activity_ip'	=>	$this->input->ip_address(),
					'created'		=>	$createdTime
				);*/
				#$this->user_model->simple_insert(NOTIFICATIONS,$actArr);
				#$this->send_noty_mail($followUserDetails->result_array());
				$returnStr['status_code'] = 1;
			}else {
				$returnStr['status_code'] = 1;
			}
		}
		echo json_encode($returnStr); 
	}
	
	/*public function add_follows(){
		$returnStr['status_code'] = 0;
		if ($this->checkLogin('U') != ''){
			$follow_ids = $this->input->post('user_ids');
			$follow_ids_arr = explode(',', $follow_ids);
			$followingListArr = explode(',', $this->data['userDetails']->row()->following);
			foreach ($follow_ids_arr as $flwRow){
				if (in_array($flwRow, $followingListArr)){
					if (($key = array_search($flwRow, $follow_ids_arr)) !== false){
						unset($follow_ids_arr[$key]);
					}
				}
			}
			if (count($follow_ids_arr)>0){
				$newfollowingListArr = array_merge($followingListArr,$follow_ids_arr);
				$newFollowingList = implode(',', $newfollowingListArr);
				$followingCount = $this->data['userDetails']->row()->following_count;
				$newCount = count($follow_ids_arr);
				$followingCount = $followingCount+$newCount;
				$dataArr = array('following'=>$newFollowingList,'following_count'=>$followingCount);
				$condition = array('id'=>$this->checkLogin('U'));
				$this->user_model->update_details(USERS,$dataArr,$condition);
				$conditionStr = 'where id IN ('.implode(',', $follow_ids_arr).')';
				$followUserDetailsArr = $this->user_model->get_users_details($conditionStr);
				if ($followUserDetailsArr->num_rows() > 0){
					foreach ($followUserDetailsArr->result() as $followUserDetails){
						$followersListArr = explode(',', $followUserDetails->followers);
						if (!in_array($this->checkLogin('U'), $followersListArr)){
							$followersListArr[] = $this->checkLogin('U');
							$newFollowersList = implode(',', $followersListArr);
							$followersCount = $followUserDetails->followers_count;
							$followersCount++;
							$dataArr = array('followers'=>$newFollowersList,'followers_count'=>$followersCount);
							$condition = array('id'=>$followUserDetails->id);
							$this->user_model->update_details(USERS,$dataArr,$condition);
							$datestring = "%Y-%m-%d %h:%i:%s";
							$time = time();
							$createdTime = mdate($datestring,$time);
							$actArr = array(
								'activity'	=>	'follow',
								'activity_id'	=>	$followUserDetails->id,
								'user_id'		=>	$this->checkLogin('U'),
								'activity_ip'	=>	$this->input->ip_address(),
								'created'		=>	$createdTime
							);
							$this->user_model->simple_insert(NOTIFICATIONS,$actArr);
							$this->send_noty_mails($followUserDetails);
						}
					}
				}
				$returnStr['status_code'] = 1;
			}else {
				$returnStr['status_code'] = 1;
			}
		}
		echo json_encode($returnStr); 
	}*/
	
	public function delete_follow(){
		$returnStr['status_code'] = 0;
		if ($this->checkLogin('U') != ''){
			$follow_id = $this->input->post('user_id');
			$checkloginIDarr=$this->session->all_userdata(); 
		 	$loggeduserID=$checkloginIDarr['shopsy_session_user_id'];			
			$userDetails = $this->user_model->get_all_details(USERS,array('id'=>$loggeduserID));			
			$followingListArr = explode(',', $userDetails->row()->following);
			if (in_array($follow_id,$followingListArr)){
				if(($key = array_search($follow_id, $followingListArr)) !== false) {
				    unset($followingListArr[$key]);
				}
				$newFollowingList = @implode(',', $followingListArr);
				$followingCount = $userDetails->row()->following_count;
				$followingCount--;
				$dataArr = array('following'=>$newFollowingList,'following_count'=>$followingCount);
				$condition = array('id'=>$loggeduserID);
				$this->user_model->update_details(USERS,$dataArr,$condition);
				$followUserDetails = $this->user_model->get_all_details(USERS,array('id'=>$follow_id));
				if ($followUserDetails->num_rows() == 1){
					$followersListArr = explode(',', $followUserDetails->row()->followers);
					if (in_array($this->checkLogin('U'), $followersListArr)){
						if(($key = array_search($this->checkLogin('U'), $followersListArr)) !== false) {
						    unset($followersListArr[$key]);
						}
						$newFollowersList = implode(',', $followersListArr);
						$followersCount = $followUserDetails->row()->followers_count;
						$followersCount--;
						$dataArr = array('followers'=>$newFollowersList,'followers_count'=>$followersCount);
						$condition = array('id'=>$follow_id);
						$this->user_model->update_details(USERS,$dataArr,$condition);
					}
				}
				/*$actArr = array(
					'activity_name'	=>	'unfollow',
					'activity_id'	=>	$follow_id,
					'user_id'		=>	$this->checkLogin('U'),
					'activity_ip'	=>	$this->input->ip_address()
				);*/
				//$this->user_model->simple_insert(USER_ACTIVITY,$actArr);
				$returnStr['status_code'] = 1;
			}else {
				$returnStr['status_code'] = 1;
			}
		} 
		echo json_encode($returnStr);
	}
	
	public function display_user_added(){
		$username =  urldecode($this->uri->segment(2,0));
		$userProfileDetails = $this->user_model->get_all_details(USERS,array('user_name'=>$username));
		if ($userProfileDetails->num_rows()==1){
			if ($userProfileDetails->row()->visibility == 'Only you' && $userProfileDetails->row()->id != $this->checkLogin('U')){
				$this->data['heading'] = $this->config->item('email_title').' - Profile';
				$this->load->view('site/user/display_user_profile_private',$this->data);
			}else {
				$this->data['heading'] = $username;
				$this->data['userProfileDetails'] = $userProfileDetails;
				$this->data['recentActivityDetails'] = $this->user_model->get_activity_details($userProfileDetails->row()->id);
				$this->data['addedProductDetails'] = $this->product_model->view_product_details(' where p.user_id='.$userProfileDetails->row()->id.' and p.status="Publish"');
				$this->data['notSellProducts'] = $this->product_model->view_notsell_product_details(' where p.user_id='.$userProfileDetails->row()->id.' and p.status="Publish"');
				$this->data['heading'] = $this->config->item('email_title').' - Profile';
				$this->load->view('site/user/display_user_added',$this->data);
			}
		}else {
			redirect(base_url());
		}
	}
	
	public function display_user_add(){
				
				$this->data['heading'] =$this->config->item('meta_title').' - Add product'; 
					$userProfileDetailss = $this->seller_model->get_sellers_store_details();
					$attribute_Val = $this->product_attribute_model->view_attribute_details(PRODUCT_ATTRIBUTE,array('status'=>'Active'));
					$shipping = $this->seller_model->get_all_details(SHIPPING,array('status'=>'Active'));
					$this->data['userProfileDetailss'] = $userProfileDetailss;
					$this->data['shipping'] = $shipping;
					$this->data['attribute_Val'] = $attribute_Val;
					$this->load->view('site/user/display_user_add',$this->data);
		
	}
	/*	public function user_add(){
							echo "<pre>";print_r($_POST); die;

					$userProfileDetailss = $this->seller_model->get_sellers_store_details();
					$this->data['userProfileDetailss'] = $userProfileDetailss;
					$this->load->view('site/user/display_user_add',$this->data);
		
	}*/

	public function display_user_lists(){
		$username =  urldecode($this->uri->segment(2,0));
		$userProfileDetails = $this->user_model->get_all_details(USERS,array('user_name'=>$username));
		if ($userProfileDetails->num_rows()==1){
			if ($userProfileDetails->row()->visibility == 'Only you' && $userProfileDetails->row()->id != $this->checkLogin('U')){
				$this->load->view('site/user/display_user_profile_private',$this->data);
			}else {
				$this->data['heading'] = $username;
				$this->data['userProfileDetails'] = $userProfileDetails;
				$this->data['recentActivityDetails'] = $this->user_model->get_activity_details($userProfileDetails->row()->id);
				$this->data['listDetails'] = $this->product_model->get_all_details(LISTS_DETAILS,array('user_id'=>$userProfileDetails->row()->id));
				if ($this->data['listDetails']->num_rows()>0){
					foreach ($this->data['listDetails']->result() as $listDetailsRow){
						$this->data['listImg'][$listDetailsRow->id] = '';
						if ($listDetailsRow->product_id != ''){
							$pidArr = array_filter(explode(',', $listDetailsRow->product_id));
							
							$productDetails = '';
							if (count($pidArr)>0){
								foreach ($pidArr as $pidRow){
									if ($pidRow!=''){
										$productDetails = $this->product_model->get_all_details(PRODUCT,array('seller_product_id'=>$pidRow,'status'=>'Publish'));
										if ($productDetails->num_rows()==0){
											$productDetails = $this->product_model->get_all_details(USER_PRODUCTS,array('seller_product_id'=>$pidRow,'status'=>'Publish'));
										}
										if ($productDetails->num_rows()==1)break;
									}
								}
							}
							if ($productDetails != '' && $productDetails->num_rows()==1){
								$this->data['listImg'][$listDetailsRow->id] = $productDetails->row()->image;
							}
						}
					}
				}
				$this->load->view('site/user/display_user_lists',$this->data);
			}
		}else {
			redirect(base_url());
		}
	}
	
	public function display_user_wants(){
		$username =  urldecode($this->uri->segment(2,0));
		$userProfileDetails = $this->user_model->get_all_details(USERS,array('user_name'=>$username));
		if ($userProfileDetails->num_rows()==1){
			if ($userProfileDetails->row()->visibility == 'Only you' && $userProfileDetails->row()->id != $this->checkLogin('U')){
				$this->load->view('site/user/display_user_profile_private',$this->data);
			}else {
				$this->data['heading'] = $username;
				$this->data['userProfileDetails'] = $userProfileDetails;
				$this->data['recentActivityDetails'] = $this->user_model->get_activity_details($userProfileDetails->row()->id);
				$wantList = $this->user_model->get_all_details(WANTS_DETAILS,array('user_id'=>$userProfileDetails->row()->id));
				$this->data['wantProductDetails'] = $this->product_model->get_wants_product($wantList);
				$this->data['notSellProducts'] = $this->product_model->get_notsell_wants_product($wantList);
				$this->load->view('site/user/display_user_wants',$this->data);
			}
		}else {
			redirect(base_url());
		}
	}
	
	public function display_user_owns(){
		$username =  urldecode($this->uri->segment(2,0));
		$userProfileDetails = $this->user_model->get_all_details(USERS,array('user_name'=>$username));
		if ($userProfileDetails->num_rows()==1){
			if ($userProfileDetails->row()->visibility == 'Only you' && $userProfileDetails->row()->id != $this->checkLogin('U')){
				$this->load->view('site/user/display_user_profile_private',$this->data);
			}else {
				$this->data['heading'] = $username;
				$this->data['userProfileDetails'] = $userProfileDetails;
				$this->data['recentActivityDetails'] = $this->user_model->get_activity_details($userProfileDetails->row()->id);
				$productIdsArr = array_filter(explode(',', $userProfileDetails->row()->own_products));
				$productIds = '';
				if (count($productIdsArr)>0){
					foreach ($productIdsArr as $pidRow){
						if ($pidRow != ''){
							$productIds .= $pidRow.',';
						}
					}
					$productIds = substr($productIds, 0,-1);
				}
				if ($productIds != ''){
					$this->data['ownsProductDetails'] = $this->product_model->view_product_details(' where p.seller_product_id in ('.$productIds.') and p.status="Publish"');
					$this->data['notSellProducts'] = $this->product_model->view_notsell_product_details(' where p.seller_product_id in ('.$productIds.') and p.status="Publish"');
				}else {
					$this->data['addedProductDetails'] = '';
					$this->data['notSellProducts'] = '';
				}
				$this->load->view('site/user/display_user_owns',$this->data);
			}
		}else {
			redirect(base_url());
		}
	}
	
	public function display_user_following(){
		$username =  urldecode($this->uri->segment(2,0));
		$userProfileDetails = $this->user_model->get_all_details(USERS,array('user_name'=>$username));
		#echo "<pre>"; print_r($userProfileDetails->result_array()); 
		if ($userProfileDetails->num_rows()==1){
			if ($userProfileDetails->row()->visibility == 'Only you' && $userProfileDetails->row()->id != $this->checkLogin('U')){
				$this->load->view('site/user/following_list',$this->data);
			}else {
				$this->data['heading'] = $username;
				$this->data['userProfileDetails'] = $userProfileDetails;
				$this->data['recentActivityDetails'] = $this->user_model->get_activity_details($userProfileDetails->row()->id);
				$fieldsArr = array('*');
				$searchName = 'id';
				$searchArr = explode(',', $userProfileDetails->row()->following);
				$joinArr = array();
				$sortArr = array();
				$limit = '';
				$followingUserDetails = $this->product_model->get_fields_from_many(USERS,$fieldsArr,$searchName,$searchArr,$joinArr,$sortArr,$limit);				
				$this->data['followingUserDetails'] = $followingUserDetails->result_array();
				if ($followingUserDetails->num_rows()>0){
					foreach ($followingUserDetails->result() as $followingUserRow){
						$this->data['followingUserfavDetails'][$followingUserRow->id] = $this->user_model->get_userfav_products($followingUserRow->id);
						$this->data['followingUserfavProdDetails'][$followingUserRow->id] = $this->user_model->get_userfav_products($followingUserRow->id)->result_array();						
					}
				}
				#echo "<pre>"; print_r($this->data['followingUserfavProdDetails']); die;
				$this->data['heading'] = $this->config->item('email_title').' - Following List';
				$this->load->view('site/user/following_list',$this->data);
			}
		}else {
			redirect(base_url());
		}
	}
	
	public function display_user_followers(){
		$username =  urldecode($this->uri->segment(2,0));
		$userProfileDetails = $this->user_model->get_all_details(USERS,array('user_name'=>$username));
		$this->data['userProfileDetails'] =$this->user_model->get_all_details(USERS,array('user_name'=>$username)); 
		#echo "<pre>"; print_r($this->data['userProfileDetails']); die;
		if ($userProfileDetails->num_rows()==1){
			if ($userProfileDetails->row()->visibility == 'Only you' && $userProfileDetails->row()->id != $this->checkLogin('U')){
				#$this->load->view('site/user/display_user_profile_private',$this->data);
			}else {
				$this->data['heading'] = $username;
				$this->data['userProfileDetails'] = $userProfileDetails;
				$this->data['recentActivityDetails'] = $this->user_model->get_activity_details($userProfileDetails->row()->id);
				$fieldsArr = array('*');
				$searchName = 'id';
				$searchArr = explode(',', $userProfileDetails->row()->followers);
				$joinArr = array();
				$sortArr = array();
				$limit = '';
				$followingUserDetails = $this->product_model->get_fields_from_many(USERS,$fieldsArr,$searchName,$searchArr,$joinArr,$sortArr,$limit);
				$this->data['followingUserDetails'] = $followingUserDetails->result_array();				
				if ($followingUserDetails->num_rows()>0){
					foreach ($followingUserDetails->result() as $followingUserRow){
						$this->data['followingUserfavDetails'][$followingUserRow->id] = $this->user_model->get_userfav_products($followingUserRow->id);
						$this->data['followingUserfavProdDetails'][$followingUserRow->id] = $this->user_model->get_userfav_products($followingUserRow->id)->result_array();
						
					}
				}
				#echo "<pre>"; print_r($this->data['followingUserfavProdDetails']);
				#echo "<pre>"; print_r($this->data['followingUserfavDetails']); #die;
				$this->data['heading'] = $this->config->item('email_title').' - Follower List';
				$this->load->view('site/user/followers_list',$this->data);
			}
		}else {
			redirect(base_url());
		}
	}
	public function add_list($name=''){		
		if ($this->checkLogin('U')!=''){
			$username =  urldecode($this->uri->segment(2,0));
			if($name==''){
				$name=$this->input->post('list');
			}else{
				$rdir=1;	
			}						
			$listConditionArr = array('name'=>$name,'user_id'=>$this->checkLogin('U'));
			if($this->input->post('ddl'))
			{
				$productId=$this->input->post('productId');
				$listArr = array('name'=>$name,'product_id'=>$productId.',','user_id'=>$this->checkLogin('U'),'product_count'=>1);
			}
			else
			{
				$listArr = array('name'=>$name,'user_id'=>$this->checkLogin('U'));
			}
			$listCheck = $this->user_model->get_all_details(LISTS_DETAILS,$listConditionArr);
			#print_r($listCheck);
			#echo "<pre>"; print_r($listConditionArr); die;
			if ($listCheck->num_rows()==0){
				$this->user_model->simple_insert(LISTS_DETAILS,$listArr);
				$this->setErrorMessage('success','List '.$name.' created successfully');				
				if($this->input->post('ddl')){ redirect('');}
				redirect('/people/'.$this->session->userdata('shopsy_session_user_name').'/favorites');
			}
			else 
			{
				$this->setErrorMessage('error',$name.' is already in you List');
				if($rdir){
					redirect('/people/'.$this->session->userdata('shopsy_session_user_name').'/favorites');
				}
				redirect('/people/'.$this->session->userdata('shopsy_session_user_name').'/favorites');
			}
			
		}
		else
		{
			$this->setErrorMessage('error','Login Required');
			redirect('login');
			#redirect('login?action='.urlencode('site/user/add_list/'.$this->input->post('list')));
		}
	}
	public function update_list($id=''){		
		if ($this->checkLogin('U')!=''){
			$username =  urldecode($this->uri->segment(2,0));								
			$listId=$list_name=$this->input->post('list_Id');
			$list_name=$this->input->post('list_name');
			$privacy_level=$this->input->post('privacy_level');
			
			if ($listId!=''){
				$dataArr = array('name'=>$list_name,'privacy'=>$privacy_level);
				$condition = array('id'=>$listId);
				#echo "<pre>"; print_r($dataArr); print_r($condition); die;
				$this->user_model->update_details(LISTS_DETAILS,$dataArr,$condition);		
						
				$this->setErrorMessage('success','List '.$list_name.' Updated successfully');
				redirect('/people/'.$username.'/favorites/list/'.$listId.'-'.$list_name);
			}
		}
		else
		{
			$this->setErrorMessage('error','Login Required');
			redirect('login');
		}
	}
	
	public function add_list_when_fancyy(){
		$returnStr['status_code'] = 0;
		$returnStr['listCnt'] = '';
		$returnStr['wanted'] = 0;
		$uniqueListNames = array();
		if ($this->checkLogin('U') == ''){
			$returnStr['message'] = 'Login required';
		}else {
			$tid = $this->input->post('tid');
			$firstCatName = '';
			$firstCatDetails = '';
			$count = 1;
			
			//Adding lists which was not already created from product categories
			$productDetails = $this->user_model->get_all_details(PRODUCT,array('seller_product_id'=>$tid));
			if ($productDetails->num_rows()==0){
				$productDetails = $this->user_model->get_all_details(USER_PRODUCTS,array('seller_product_id'=>$tid));
			}
			if ($productDetails->num_rows()==1){
				$productCatArr = explode(',', $productDetails->row()->category_id);
				if (count($productCatArr)>0){
					$productCatNameArr = array();
					foreach ($productCatArr as $productCatID){
						if ($productCatID != ''){
							$productCatDetails = $this->user_model->get_all_details(CATEGORY,array('id'=>$productCatID));
							if ($productCatDetails->num_rows()==1){
								if ($count == 1){	
									$firstCatName = $productCatDetails->row()->cat_name;
								}
								$listConditionArr = array('name'=>$productCatDetails->row()->cat_name,'user_id'=>$this->checkLogin('U'));
								$listCheck = $this->user_model->get_all_details(LISTS_DETAILS,$listConditionArr);
								if ($count == 1){	
									$firstCatDetails = $listCheck;
								}
								if ($listCheck->num_rows()==0){
									$this->user_model->simple_insert(LISTS_DETAILS,$listConditionArr);
									$userDetails = $this->user_model->get_all_details(USERS,array('id'=>$this->checkLogin('U')));
									$listCount = $userDetails->row()->lists;
									if ($listCount<0 || $listCount == ''){
										$listCount = 0;
									}
									$listCount++;
									$this->user_model->update_details(USERS,array('lists'=>$listCount),array('id'=>$this->checkLogin('U')));
								}
								$count++;
							}
						}
					}
				}
			}
			
			//Check the product id in list table
			$checkListsArr = $this->user_model->get_list_details($tid,$this->checkLogin('U'));
			
			if ($checkListsArr->num_rows() == 0){
				
				//Add the product id under the first category name
				if ($firstCatName!=''){
					$listConditionArr = array('name'=>$firstCatName,'user_id'=>$this->checkLogin('U'));
					if ($firstCatDetails == '' || $firstCatDetails->num_rows() == 0){
						$dataArr = array('product_id'=>$tid);
					}else {
						$productRowArr = explode(',', $firstCatDetails->row()->product_id);
						$productRowArr[] = $tid;
						$newProductRowArr = implode(',', $productRowArr);
						$dataArr = array('product_id'=>$newProductRowArr);
					}
					$this->user_model->update_details(LISTS_DETAILS,$dataArr,$listConditionArr);
					$listCntDetails = $this->user_model->get_all_details(LISTS_DETAILS,$listConditionArr);
					if ($listCntDetails->num_rows()==1){
						array_push($uniqueListNames, $listCntDetails->row()->id);
						$returnStr['listCnt'] .= '<li class="selected"><label for="'.$listCntDetails->row()->id.'"><input type="checkbox" checked="checked" id="'.$listCntDetails->row()->id.'" name="'.$listCntDetails->row()->id.'">'.$listCntDetails->row()->name.'</label></li>';
					}
				}
			}else {
				
				//Get all the lists which contain this product
				foreach ($checkListsArr->result() as $checkListsRow){
					array_push($uniqueListNames, $checkListsRow->id);
					$returnStr['listCnt'] .= '<li class="selected"><label for="'.$checkListsRow->id.'"><input type="checkbox" checked="checked" id="'.$checkListsRow->id.'" name="'.$checkListsRow->id.'">'.$checkListsRow->name.'</label></li>';
				}
			}
			$all_lists = $this->user_model->get_all_details(LISTS_DETAILS,array('user_id'=>$this->checkLogin('U')));
			if ($all_lists->num_rows()>0){
				foreach ($all_lists->result() as $all_lists_row){
					if (!in_array($all_lists_row->id, $uniqueListNames)){
						$returnStr['listCnt'] .= '<li><label for="'.$all_lists_row->id.'"><input type="checkbox" id="'.$all_lists_row->id.'" name="'.$all_lists_row->id.'">'.$all_lists_row->name.'</label></li>';
					}
				}
			}
			
			//Check the product wanted status
			$wantedProducts = $this->user_model->get_all_details(WANTS_DETAILS,array('user_id'=>$this->checkLogin('U')));
			if ($wantedProducts->num_rows()==1){
				$wantedProductsArr = explode(',', $wantedProducts->row()->product_id);
				if (in_array($tid, $wantedProductsArr)){
					$returnStr['wanted'] = 1;
				}
			}
			$returnStr['status_code'] = 1; 
		}
		echo json_encode($returnStr);
	}
	
	public function add_item_to_lists(){
		$returnStr['status_code'] = 0;
		if ($this->checkLogin('U')==''){
			$returnStr['message'] = 'You must login';
		}else {
			$tid = $this->input->post('tid');
			$lid = $this->input->post('list_ids');
			$listDetails = $this->user_model->get_all_details(LISTS_DETAILS,array('id'=>$lid));
			if ($listDetails->num_rows()==1){
				$product_ids = explode(',', $listDetails->row()->product_id);
				if (!in_array($tid, $product_ids)){
					array_push($product_ids, $tid);
				}
				$new_product_ids = implode(',', $product_ids);
				$this->user_model->update_details(LISTS_DETAILS,array('product_id'=>$new_product_ids),array('id'=>$lid));
				$returnStr['status_code'] = 1;
			}
		}
		echo json_encode($returnStr);
	}
	
	public function remove_item_from_lists(){
		$returnStr['status_code'] = 0;
		if ($this->checkLogin('U')==''){
			$returnStr['message'] = 'You must login';
		}else {
			$tid = $this->input->post('tid');
			$lid = $this->input->post('list_ids');
			$listDetails = $this->user_model->get_all_details(LISTS_DETAILS,array('id'=>$lid));
			if ($listDetails->num_rows()==1){
				$product_ids = explode(',', $listDetails->row()->product_id);
				if (in_array($tid, $product_ids)){
					if(($key = array_search($tid, $product_ids)) !== false) {
					    unset($product_ids[$key]);
					}
				}
				$new_product_ids = implode(',', $product_ids);
				$this->user_model->update_details(LISTS_DETAILS,array('product_id'=>$new_product_ids),array('id'=>$lid));
				$returnStr['status_code'] = 1;
			}
		}
		echo json_encode($returnStr);
	}
	
	public function add_want_tag(){
		$returnStr['status_code'] = 0;
		if ($this->checkLogin('U')==''){
			$returnStr['message'] = 'You must login';
		}else {
			$tid = $this->input->post('thing_id');
			$wantDetails = $this->user_model->get_all_details(WANTS_DETAILS,array('user_id'=>$this->checkLogin('U')));
			if ($wantDetails->num_rows()==1){
				$product_ids = explode(',', $wantDetails->row()->product_id);
				if (!in_array($tid, $product_ids)){
					array_push($product_ids, $tid);
				}
				$new_product_ids = implode(',', $product_ids);
				$this->user_model->update_details(WANTS_DETAILS,array('product_id'=>$new_product_ids),array('user_id'=>$this->checkLogin('U')));
			}else {
				$dataArr = array('user_id'=>$this->checkLogin('U'),'product_id'=>$tid);
				$this->user_model->simple_insert(WANTS_DETAILS,$dataArr);
			}
			$wantCount = $this->data['userDetails']->row()->want_count;
			if ($wantCount<=0 || $wantCount==''){
				$wantCount = 0;
			}
			$wantCount++;
			$dataArr = array('want_count'=>$wantCount);
			$ownProducts = explode(',', $this->data['userDetails']->row()->own_products);
			if (in_array($tid, $ownProducts)){
				if (($key = array_search($tid, $ownProducts)) !== false){
					unset($ownProducts[$key]);
				}
				$ownCount = $this->data['userDetails']->row()->own_count;
				$ownCount--;
				$dataArr['own_count'] = $ownCount;
				$dataArr['own_products'] = implode(',', $ownProducts);
			}
			$this->user_model->update_details(USERS,$dataArr,array('id'=>$this->checkLogin('U')));
			$returnStr['status_code'] = 1;
		}
		echo json_encode($returnStr);
	}
	
	public function delete_want_tag(){
		$returnStr['status_code'] = 0;
		if ($this->checkLogin('U')==''){
			$returnStr['message'] = 'You must login';
		}else {
			$tid = $this->input->post('thing_id');
			$wantDetails = $this->user_model->get_all_details(WANTS_DETAILS,array('user_id'=>$this->checkLogin('U')));
			if ($wantDetails->num_rows()==1){
				$product_ids = explode(',', $wantDetails->row()->product_id);
				if (in_array($tid, $product_ids)){
					if(($key = array_search($tid, $product_ids)) !== false) {
					    unset($product_ids[$key]);
					}
				}
				$new_product_ids = implode(',', $product_ids);
				$this->user_model->update_details(WANTS_DETAILS,array('product_id'=>$new_product_ids),array('user_id'=>$this->checkLogin('U')));
				$wantCount = $this->data['userDetails']->row()->want_count;
				if ($wantCount<=0 || $wantCount==''){
					$wantCount = 1;
				}
				$wantCount--;
				$this->user_model->update_details(USERS,array('want_count'=>$wantCount),array('id'=>$this->checkLogin('U')));
				$returnStr['status_code'] = 1;
			}
		}
		echo json_encode($returnStr);
	}
	
	public function create_list(){
		$returnStr['status_code'] = 0;
		if ($this->checkLogin('U')==''){
			$returnStr['message'] = 'You must login';
		}else {
			$tid = $this->input->post('tid');
			$list_name = $this->input->post('list_name');
			$category_id = $this->input->post('category_id');
			$checkList = $this->user_model->get_all_details(LISTS_DETAILS,array('name'=>$list_name,'user_id'=>$this->checkLogin('U')));
			if ($checkList->num_rows() == 0){
				$dataArr = array('user_id'=>$this->checkLogin('U'),'name'=>$list_name,'product_id'=>$tid);
				if ($category_id != ''){
					$dataArr['category_id'] = $category_id;
				}
				$this->user_model->simple_insert(LISTS_DETAILS,$dataArr);
				$userDetails = $this->user_model->get_all_details(USERS,array('id'=>$this->checkLogin('U')));
				$listCount = $userDetails->row()->lists;
				if ($listCount<0 || $listCount == ''){
					$listCount = 0;
				}
				$listCount++;
				$this->user_model->update_details(USERS,array('lists'=>$listCount),array('id'=>$this->checkLogin('U')));
				$returnStr['list_id'] = $this->user_model->get_last_insert_id();
				$returnStr['new_list'] = 1;
			}else {
				$productArr = explode(',', $checkList->row()->product_id);
				if (!in_array($tid, $productArr)){
					array_push($productArr, $tid);
				}
				$product_id = implode(',', $productArr);
				$dataArr = array('product_id'=>$product_id);
				if ($category_id != ''){
					$dataArr['category_id'] = $category_id;
				}	
				$this->user_model->update_details(LISTS_DETAILS,$dataArr,array('user_id'=>$this->checkLogin('U'),'name'=>$list_name));
				$returnStr['list_id'] = $checkList->row()->id;
				$returnStr['new_list'] = 0;
			}
			$returnStr['status_code'] = 1;
		}
		echo json_encode($returnStr);
	}
	
	public function search_users(){
		$search_key = $this->input->post('term');
		$returnStr = array();
		if ($search_key != ''){
			$userList = $this->user_model->get_search_user_list($search_key,$this->checkLogin('U'));
			if ($userList->num_rows()>0){
				$i=0;
				foreach ($userList->result() as $userRow){
					$userArr['id'] = $userRow->id;
					$userArr['fullname'] = $userRow->full_name;
					$userArr['username'] = $userRow->user_name;
					if ($userRow->thumbnail != ''){
						$userArr['image_url'] = 'images/users/'.$userRow->thumbnail;
					}else {
						$userArr['image_url'] = 'images/users/user-thumb1.png';
					}
					array_push($returnStr, $userArr);
					$i++;
				}
			}
		}
		echo json_encode($returnStr);
	}
	
	public function seller_signup_form(){
		if ($this->checkLogin('U')==''){
			redirect(base_url());
		}else {
			if ($this->data['userDetails']->row()->is_verified == 'No'){
				$this->setErrorMessage('error','Please confirm your email first');
				redirect(base_url());
			}else {
				$this->data['heading'] = 'Seller Signup';
				$this->load->view('site/user/seller_register',$this->data);
			}
		}
	}

	public function create_brand_form(){
		if ($this->checkLogin('U')==''){
			redirect(base_url());
		}else {
			$this->data['heading'] = 'Seller Signup';
			$this->load->view('site/user/seller_register',$this->data);
		}
	}
	
	
	
	public function seller_signup(){
	
		if ($this->checkLogin('U')==''){
			redirect(base_url());
		}else {
			if ($this->data['userDetails']->row()->is_verified == 'No'){
				$this->setErrorMessage('error','Please confirm your email first');
				redirect('create-brand');
//				echo "<script>window.history.go(-1)/script>";
			}else {
				$dataArr = array(
					'request_status'	=>	'Pending'
				);
				$this->user_model->commonInsertUpdate(USERS,'update',array(),$dataArr,array('id'=>$this->checkLogin('U')));
				$this->setErrorMessage('success','Welcome onboard ! Our team is evaluating your request. We will contact you shortly');
				redirect(base_url());
			}
		}
	}
	
	/*public function find_friends_twitter(){
		$returnStr['status_code'] = 1;
//		$returnStr['url'] = base_url().'twfollows.php';
		$returnStr['url'] = 'https://api.twitter.com/oauth/authorize?oauth_token=395839017-A1lVlw1uWXwDnzPFQuOBGGypMxYHLP3nrEICkyIs';
		$returnStr['message'] = '';
		echo json_encode($returnStr);
	}*/
	 
	public function view_purchase(){ 
		if ($this->checkLogin('U') == ''){
			show_404();
		}else {
			$uid = $this->uri->segment(2,0);
			$dealCode = $this->uri->segment(3,0);
			if ($uid != $this->checkLogin('U')){
				#show_404();
				redirect('login');
			}else {
				$purchaseList = $this->user_model->get_purchase_list($uid,$dealCode);
				//echo '<pre>'; print_r($purchaseList->result()); die;
				$invoice = $this->get_invoice($purchaseList);
				echo $invoice;
			}
		}
	}
	
	public function view_seller_purchase(){ 
		if ($this->checkLogin('U') == ''){
			show_404();
		}else {
			$uid = $this->uri->segment(2,0);
			$dealCode = $this->uri->segment(3,0);
			if ($uid != $this->checkLogin('U')){
				show_404();
			}else {
				$purchaseList = $this->user_model->get_seller_purchase_list($uid,$dealCode);
				$invoice = $this->get_invoice($purchaseList);
				echo $invoice;
			}
		}
	}

	public function view_order(){
		if ($this->checkLogin('U') == ''){
			show_404();
		}else {
			$uid = $this->uri->segment(2,0);
			$dealCode = $this->uri->segment(3,0);
			if ($uid != $this->checkLogin('U')){
				show_404();
			}else {
				//$orderList = $this->user_model->get_user_purchase_list($uid,$dealCode);
				##echo "<pre>"; print_r($orderList); die;
				$invoice = $this->get_invoice($uid,$dealCode);
				echo $invoice; die;
			}
		}
	}
	
	public function view_seller_order(){
		if ($this->checkLogin('U') == ''){
			show_404();
		}else {
			$uid = $this->uri->segment(2,0);
			$dealCode = $this->uri->segment(3,0);
			if ($uid != $this->checkLogin('U')){
				show_404();
			}else {
				$orderList = $this->user_model->get_seller_order_list($uid,$dealCode);
				$invoice = $this->get_invoice($orderList);
				echo $invoice;
			}
		}
	}
	
	public function get_invoice($userid,$randomId){
		
		$this->db->select('p.*,u.email,u.full_name,u.address,u.phone_no,u.postal_code,u.state,u.country,u.city,pd.product_name,pd.image,pd.id as PrdID,pAr.attr_name');
		$this->db->from(USER_PAYMENT.' as p');
		$this->db->join(USERS.' as u' , 'p.user_id = u.id');
		$this->db->join(PRODUCT.' as pd' , 'pd.id = p.product_id');		
		$this->db->join(PRODUCT_ATTRIBUTE.' as pAr' , 'pAr.id = p.attribute_values','left');				
		$this->db->where('p.user_id = "'.$userid.'" and p.dealCodeNumber="'.$randomId.'"');
		$PrdList = $this->db->get();
	
	$shipAddRess = $this->user_model->get_all_details(SHIPPING_ADDRESS,array( 'id' => $PrdList->row()->shippingid ));
	$BillAddRess = $this->user_model->get_all_details(BILLING_ADDRESS,array( 'id' => $PrdList->row()->billingid ));
	$enc_dealCodeNumber=strtr($this->encrypt->encode($PrdList->row()->dealCodeNumber), '+/=', '-.~');
	$enc_user_id=strtr($this->encrypt->encode($PrdList->row()->user_id), '+/=', '-.~');
	
	$message = '<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml"><head><meta http-equiv="Content-Type" content="text/html; charset=utf-8">
<meta name="viewport" content="width=device-width"/>
<meta name="viewport" content="width=device-width"/><script src="'.base_url().'js/validation.js" type="text/javascript"></script>
<script src="'.base_url().'js/site/jquery-1.9.0.js" type="text/javascript"></script>
<script type="text/javascript">
	var baseURL = "'.base_url().'";
</script>
<script src="'.base_url().'js/jquery.colorbox.js"></script>
<link rel="stylesheet" href="'.base_url().'css/site/shopsy_style.css" type="text/css" media="all" />
<link rel="stylesheet" type="text/css" href="'.base_url().'css/colorbox.css" media="all" />
<!--[if lt IE 9]>
<script src="'.base_url().'js/html5shiv/dist/html5shiv.js"></script>
<![endif]-->
<style>

#cboxClose {
    background: url("../../images/close_img.png") no-repeat scroll 0 0 rgba(0, 0, 0, 0);
    border: medium none;
    height: 16px;
    position: absolute;
    right: 0;
    text-indent: -9999px;
    top: 8px;
    width: 20px;
}

#cboxClose:hover {
background: url("../../images/buttons-master.20140130192956.png") no-repeat scroll -31px -1326px rgba(0, 0, 0, 0);
}
</style>
</head>
<title>View Invoice</title>
<body>
<div style="width:1012px;background:#FFFFFF; margin:0 auto;">
<div style="width:100%;background:#454B56; float:left; margin:0 auto;">
    <div style="padding:20px 0 10px 15px;float:left; width:50%;"><a href="'.base_url().'" target="_blank" id="logo"><img src="'.base_url().'images/logo/'.$this->data['logo'].'" alt="'.$this->data['WebsiteTitle'].'" title="'.$this->data['WebsiteTitle'].'" width="100"></a></div>
	
</div>			
<!--END OF LOGO-->
    
 <!--start of deal-->
    <div style="width:970px;background:#FFFFFF;float:left; padding:20px; border:1px solid #454B56; ">
    
	<div style=" float:right; width:35%; margin-bottom:20px; margin-right:7px;">
		<table width="100%" border="0" cellspacing="0" cellpadding="0" style="border:1px solid #cecece;">
			  <tr bgcolor="#f3f3f3">
                <td width="87"  style="border-right:1px solid #cecece;"><span style="font-size:13px; font-family:Arial, Helvetica, sans-serif; text-align:center; width:100%; font-weight:bold; color:#000000; line-height:38px; float:left;">Order Id</span></td>
                <td  width="100"><span style="font-size:12px; font-family:Arial, Helvetica, sans-serif; font-weight:normal; color:#000000; line-height:38px; text-align:center; width:100%; float:left;">'.$PrdList->row()->dealCodeNumber.'</span></td>
              </tr>
              <tr bgcolor="#f3f3f3">
                <td width="87"  style="border-right:1px solid #cecece;"><span style="font-size:13px; font-family:Arial, Helvetica, sans-serif; text-align:center; width:100%; font-weight:bold; color:#000000; line-height:38px; float:left;">Order Date</span></td>
                <td  width="100"><span style="font-size:12px; font-family:Arial, Helvetica, sans-serif; font-weight:normal; color:#000000; line-height:38px; text-align:center; width:100%; float:left;">'.date("F j, Y g:i a",strtotime($PrdList->row()->created)).'</span></td>
              </tr>
			 
              </table>
        	</div>
		
    <div style="float:left; width:100%;">
	
    <div style="width:49%; float:left; border:1px solid #cccccc; margin-right:10px;">
    	<span style=" border-bottom:1px solid #cccccc; background:#f3f3f3; width:95.8%; float:left; padding:10px; font-family:Arial, Helvetica, sans-serif; font-size:13px; font-weight:bold; color:#000305;">Shipping Address</span>
    		<div style="float:left; padding:10px; width:96%;  font-family:Arial, Helvetica, sans-serif; font-size:13px; color:#030002; line-height:28px;">
            	<table width="100%" border="0" cellpadding="0" cellspacing="0">
                	<tr><td>Full Name</td><td>:</td><td>'.stripslashes($shipAddRess->row()->full_name).'</td></tr>
                    <tr><td>Address</td><td>:</td><td>'.stripslashes($shipAddRess->row()->address1).'</td></tr>
					<tr><td>Address 2</td><td>:</td><td>'.stripslashes($shipAddRess->row()->address2).'</td></tr>
					<tr><td>City</td><td>:</td><td>'.stripslashes($shipAddRess->row()->city).'</td></tr>
					<tr><td>Country</td><td>:</td><td>'.stripslashes($shipAddRess->row()->country).'</td></tr>
					<tr><td>State</td><td>:</td><td>'.stripslashes($shipAddRess->row()->state).'</td></tr>
					<tr><td>Zipcode</td><td>:</td><td>'.stripslashes($shipAddRess->row()->postal_code).'</td></tr>
					<tr><td>Phone Number</td><td>:</td><td>'.stripslashes($shipAddRess->row()->phone).'</td></tr>
            	</table>
            </div>
     </div>
    
   <div style="width:49%; float:left; border:1px solid #cccccc;">
    	<span style=" border-bottom:1px solid #cccccc; background:#f3f3f3; width:95.7%; float:left; padding:10px; font-family:Arial, Helvetica, sans-serif; font-size:13px; font-weight:bold; color:#000305;">Billing Address</span>
    		<div style="float:left; padding:10px; width:96%;  font-family:Arial, Helvetica, sans-serif; font-size:13px; color:#030002; line-height:28px;">
            	<table width="100%" border="0" cellpadding="0" cellspacing="0">
                	<tr><td>Full Name</td><td>:</td><td>'.stripslashes($BillAddRess->row()->full_name).'</td></tr>
                    <tr><td>Address</td><td>:</td><td>'.stripslashes($BillAddRess->row()->address1).'</td></tr>
					<tr><td>Address 2</td><td>:</td><td>'.stripslashes($BillAddRess->row()->address2).'</td></tr>
					<tr><td>City</td><td>:</td><td>'.stripslashes($BillAddRess->row()->city).'</td></tr>
					<tr><td>Country</td><td>:</td><td>'.stripslashes($BillAddRess->row()->country).'</td></tr>
					<tr><td>State</td><td>:</td><td>'.stripslashes($BillAddRess->row()->state).'</td></tr>
					<tr><td>Zipcode</td><td>:</td><td>'.stripslashes($BillAddRess->row()->postal_code).'</td></tr>
					<tr><td>Phone Number</td><td>:</td><td>'.stripslashes($BillAddRess->row()->phone).'</td></tr>
            	</table>
            </div>
    </div>
</div>
	   
<div style="float:left; width:100%; margin-right:3%; margin-top:10px; font-size:14px; font-weight:normal; line-height:28px;  font-family:Arial, Helvetica, sans-serif; color:#000; overflow:hidden;">   
	<table width="100%" border="0" cellpadding="0" cellspacing="0">
    <tr>
    	<td colspan="3"><table width="100%" border="0" cellspacing="0" cellpadding="0" style="border:1px solid #cecece; width:99.5%;">
        <tr bgcolor="#f3f3f3">
        	<td width="17%" style="border-right:1px solid #cecece; text-align:center;"><span style="font-size:12px; font-family:Arial, Helvetica, sans-serif; font-weight:bold; color:#000000; line-height:38px; text-align:center;">Bag Items</span></td>
            <td width="43%" style="border-right:1px solid #cecece;text-align:center;"><span style="font-size:12px; font-family:Arial, Helvetica, sans-serif; font-weight:bold; color:#000000; line-height:38px; text-align:center;">Product Name</span></td>
            <td width="12%" style="border-right:1px solid #cecece;text-align:center;"><span style="font-size:12px; font-family:Arial, Helvetica, sans-serif; font-weight:bold; color:#000000; line-height:38px; text-align:center;">Qty</span></td>
            <td width="14%" style="border-right:1px solid #cecece;text-align:center;"><span style="font-size:12px; font-family:Arial, Helvetica, sans-serif; font-weight:bold; color:#000000; line-height:38px; text-align:center;">Unit Price</span></td>
            <td width="15%" style="text-align:center;"><span style="font-size:12px; font-family:Arial, Helvetica, sans-serif; font-weight:bold; color:#000000; line-height:38px; text-align:center;">Sub Total</span></td>
         </tr>';	   
			
$disTotal =0; $shipCost = $grantTotal = 0;$digiDownload=0;
foreach ($PrdList->result() as $cartRow) { $InvImg = @explode(',',$cartRow->image); 
$unitPrice = $cartRow->price; 
$uTot = $unitPrice*$cartRow->quantity;
if($cartRow->attribute_values != ''){ $atr = '<br>'.$cartRow->attribute_values; }elseif($catRow->attribute_values !=''){$atr = '<br>'.$cartRow->attribute_values; }else{ $atr = '';}
if($cartRow->digital_files != ''){ $digiDownload++; }
$message.='<tr>
            <td style="border-right:1px solid #cecece; text-align:center;border-top:1px solid #cecece;"><span style="font-size:13px; font-family:Arial, Helvetica, sans-serif; font-weight:normal; color:#000000; line-height:30px;  text-align:center;"><img src="'.base_url().PRODUCTPATHTHUMB.$InvImg[0].'" alt="'.stripslashes($cartRow->product_name).'" width="70" /></span><br><a href="javascript:void(0);" onClick="makeReview('.$cartRow->user_id.','.$cartRow->product_id.','.$cartRow->dealCodeNumber.');" class="rev-popup">Review</a></td>
			<td style="border-right:1px solid #cecece;text-align:center;border-top:1px solid #cecece;"><span style="font-size:13px; font-family:Arial, Helvetica, sans-serif; font-weight:normal; color:#000000; line-height:30px;  text-align:center;">'.stripslashes($cartRow->product_name).$atr.'</span></td>
            <td style="border-right:1px solid #cecece;text-align:center;border-top:1px solid #cecece;"><span style="font-size:13px; font-family:Arial, Helvetica, sans-serif; font-weight:normal; color:#000000; line-height:30px;  text-align:center;">'.strtoupper($cartRow->quantity).'</span></td>
            <td style="border-right:1px solid #cecece;text-align:center;border-top:1px solid #cecece;"><span style="font-size:13px; font-family:Arial, Helvetica, sans-serif; font-weight:normal; color:#000000; line-height:30px;  text-align:center;">'.$this->data['currencySymbol'].number_format($unitPrice * $this->data['currencyValue'],2,'.','').'</span></td>
            <td style="text-align:center;border-top:1px solid #cecece;"><span style="font-size:13px; font-family:Arial, Helvetica, sans-serif; font-weight:normal; color:#000000; line-height:30px;  text-align:center;">'.$this->data['currencySymbol'].number_format($uTot * $this->data['currencyValue'],2,'.','').'</span></td>
        </tr>';
	$grantTotal = $grantTotal + $uTot;
	$shipCost = $shipCost + $cartRow->shippingcost;
}
	$private_total = $grantTotal - $PrdList->row()->discountAmount;
	$private_total = $grantTotal - $PrdList->row()->giftdiscountAmount;	
	$private_total = $private_total + $PrdList->row()->tax + $shipCost;
				 
$message.='</table></td> </tr><tr><td colspan="3"><table border="0" cellspacing="0" cellpadding="0" style=" margin:10px 0px; width:99.5%;"><tr>
			<td width="460" valign="top" >';
			if($PrdList->row()->note !=''){
$message.='<table width="97%" border="0"  cellspacing="0" cellpadding="0"><tr>
                <td width="87" ><span style="font-size:13px; font-family:Arial, Helvetica, sans-serif; text-align:left; width:100%; font-weight:bold; color:#000000; line-height:38px; float:left;">Note:</span></td>
               
            </tr>
			<tr>
                <td width="87"  style="border:1px solid #cecece;"><span style="font-size:13px; font-family:Arial, Helvetica, sans-serif; text-align:left; width:97%; color:#000000; line-height:24px; float:left; margin:10px;">'.stripslashes($PrdList->row()->note).'</span></td>
            </tr></table>';
			}
			
			if($PrdList->row()->order_gift == 1){
$message.='<table width="97%" border="0"  cellspacing="0" cellpadding="0"  style="margin-top:10px;"><tr>
                <td width="87"  style="border:1px solid #cecece;"><span style="font-size:16px; font-weight:bold; font-family:Arial, Helvetica, sans-serif; text-align:center; width:97%; color:#000000; line-height:24px; float:left; margin:10px;">This Order is a gift</span></td>
            </tr></table>';
			}
			
$message.='</td>
            <td width="174" valign="top"><table width="100%" border="0" cellspacing="0" cellpadding="0" style="border:1px solid #cecece;">
            <tr bgcolor="#f3f3f3">
                <td width="87"  style="border-right:1px solid #cecece;border-bottom:1px solid #cecece;"><span style="font-size:13px; font-family:Arial, Helvetica, sans-serif; text-align:center; width:100%; font-weight:bold; color:#000000; line-height:38px; float:left;">Sub Total</span></td>
                <td  style="border-bottom:1px solid #cecece;" width="69"><span style="font-size:12px; font-family:Arial, Helvetica, sans-serif; font-weight:normal; color:#000000; line-height:38px; text-align:center; width:100%; float:left;">'.$this->data['currencySymbol'].number_format($grantTotal * $this->data['currencyValue'],'2','.','').'</span></td>
            </tr>';
			
			if($PrdList->row()->discountAmount !='0.00'){
			$message.='<tr>
                <td width="87"  style="border-right:1px solid #cecece;border-bottom:1px solid #cecece;"><span style="font-size:13px; font-family:Arial, Helvetica, sans-serif; text-align:center; width:100%; font-weight:bold; color:#000000; line-height:38px; float:left;">Coupon Discount</span></td>
                <td  style="border-bottom:1px solid #cecece;" width="69"><span style="font-size:12px; font-family:Arial, Helvetica, sans-serif; font-weight:normal; color:#000000; line-height:38px; text-align:center; width:100%; float:left;">'.$this->data['currencySymbol'].number_format($PrdList->row()->discountAmount * $this->data['currencyValue'],'2','.','').'</span></td>
            </tr>';
			}
			if($PrdList->row()->giftdiscountAmount !='0.00'){
			$message.='<tr>
                <td width="87"  style="border-right:1px solid #cecece;border-bottom:1px solid #cecece;"><span style="font-size:13px; font-family:Arial, Helvetica, sans-serif; text-align:center; width:100%; font-weight:bold; color:#000000; line-height:38px; float:left;">Gift Discount</span></td>
                <td  style="border-bottom:1px solid #cecece;" width="69"><span style="font-size:12px; font-family:Arial, Helvetica, sans-serif; font-weight:normal; color:#000000; line-height:38px; text-align:center; width:100%; float:left;">'.$this->data['currencySymbol'].number_format($PrdList->row()->giftdiscountAmount * $this->data['currencyValue'],'2','.','').'</span></td>
            </tr>';
			}
		$message.='<tr bgcolor="#f3f3f3">            <td width="31" style="border-right:1px solid #cecece;border-bottom:1px solid #cecece;"><span style="font-size:13px; font-family:Arial, Helvetica, sans-serif; font-weight:bold; text-align:center; width:100%; color:#000000; line-height:38px; float:left;">Shipping Cost</span></td>
                <td  style="border-bottom:1px solid #cecece;" width="69"><span style="font-size:12px; font-family:Arial, Helvetica, sans-serif; font-weight:normal; color:#000000; line-height:38px; text-align:center; width:100%;  float:left;">'.$this->data['currencySymbol'].number_format($shipCost * $this->data['currencyValue'],2,'.','').'</span></td>
              </tr>
			  <tr>
            <td width="31" style="border-right:1px solid #cecece;border-bottom:1px solid #cecece;"><span style="font-size:13px; font-family:Arial, Helvetica, sans-serif; font-weight:bold; text-align:center; width:100%; color:#000000; line-height:38px; float:left;">Shipping Tax</span></td>
                <td  style="border-bottom:1px solid #cecece;" width="69"><span style="font-size:12px; font-family:Arial, Helvetica, sans-serif; font-weight:normal; color:#000000; line-height:38px; text-align:center; width:100%;  float:left;">'.$this->data['currencySymbol'].number_format($PrdList->row()->tax * $this->data['currencyValue'],2,'.','').'</span></td>
              </tr>
			  <tr bgcolor="#f3f3f3">
                <td width="87" style="border-right:1px solid #cecece;"><span style="font-size:13px; font-family:Arial, Helvetica, sans-serif; font-weight:bold; color:#000000; line-height:38px; text-align:center; width:100%; float:left;">Grand Total</span></td>
                <td width="31"><span style="font-size:12px; font-family:Arial, Helvetica, sans-serif; font-weight:normal; color:#000000; line-height:38px; text-align:center; width:100%;  float:left;">'.$this->data['currencySymbol'].number_format($private_total * $this->data['currencyValue'],'2','.','').'</span></td>
              </tr>
            </table></td>
            </tr>
        </table></td>
        </tr>
    </table>
        </div>
        
        <!--end of left--> 
		<div style="width:50%; float:left;">';
		if($digiDownload>0){
				$message.='<div style="float:left; width:100%;font-size:12px; font-family:Arial, Helvetica, sans-serif; font-weight:normal; width:100%; color:#000000; line-height:38px; ">'.$digiDownload.' Products are having the digital files in this order, Click <span><a href="'.base_url().'digital-files/'.$enc_user_id.'/'.$enc_dealCodeNumber.'"> here</a> </span>to download these.</div>';
		}
            	$message.='<div style="float:left; width:100%;font-size:12px; font-family:Arial, Helvetica, sans-serif; font-weight:normal; width:100%; color:#000000; line-height:38px; "><span>'.stripslashes($PrdList->row()->full_name).'</span>,thank you for your purchase.</div>
               <ul style="width:100%; margin:10px 0px 0px 0px; padding:0; list-style:none; float:left; font-size:12px; font-weight:normal; line-height:19px; font-family:Arial, Helvetica, sans-serif; color:#000;">
                    <li>If you have any concerns please contact us.</li>
                    <li>Email: <span>'.stripslashes($this->data['siteContactMail']).' </span></li>
               </ul>
        	</div>
            
            <div style="width:27.4%; margin-right:5px; float:right;">
            
           
            </div>
        
        <div style="clear:both"></div>
        
    </div>
    </div>
	<div style="display:none;">
	<div id="inline_reg1" style=""></div>
	</div
	></body></html>';	
		return $message;
	}
	
	public function change_order_status(){
		if ($this->checkLogin('U') == ''){
			show_404();
		}else {
			$uid = $this->input->post('seller');
			if ($uid != $this->checkLogin('U')){
				show_404();
			}else {
				$returnStr['status_code'] = 0;
				$dealCode = $this->input->post('dealCode');
				$status = $this->input->post('value');
				$dataArr = array('shipping_status'=>$status);
				$conditionArr = array('dealCodeNumber'=>$dealCode,'sell_id'=>$uid);
				$this->user_model->update_details(PAYMENT,$dataArr,$conditionArr);
				$returnStr['status_code'] = 1;
				echo json_encode($returnStr);
			}
		}
	}
	
	public function display_user_lists_home(){
		$lid = $this->uri->segment('4','0');
		$uname = $this->uri->segment('2','0');
		$this->data['user_profile_details'] = $userProfileDetails = $this->user_model->get_all_details(USERS,array('user_name'=>$uname));
		if ($userProfileDetails->row()->visibility == 'Only you' && $userProfileDetails->row()->id != $this->checkLogin('U')){
			$this->load->view('site/user/display_user_profile_private',$this->data);
		}else {
			$this->data['list_details'] = $list_details = $this->product_model->get_all_details(LISTS_DETAILS,array('id'=>$lid,'user_id'=>$this->data['user_profile_details']->row()->id));
			if ($this->data['list_details']->num_rows()==0){
				show_404();
			}else {
				$searchArr = array_filter(explode(',', $list_details->row()->product_id));
				if (count($searchArr)>0){
					$fieldsArr = array(PRODUCT.'.*',USERS.'.user_name',USERS.'.full_name');
					$condition = array(PRODUCT.'.status'=>'Publish');
					$joinArr1 = array('table'=>USERS,'on'=>USERS.'.id='.PRODUCT.'.user_id','type'=>'');
					$joinArr = array($joinArr1);
					$this->data['product_details'] = $product_details = $this->product_model->get_fields_from_many(PRODUCT,$fieldsArr,PRODUCT.'.seller_product_id',$searchArr,$joinArr,'','',$condition);
					$this->data['totalProducts'] = count($searchArr);
					$fieldsArr = array(USER_PRODUCTS.'.*',USERS.'.user_name',USERS.'.full_name');
					$condition = array(USER_PRODUCTS.'.status'=>'Publish');
					$joinArr1 = array('table'=>USERS,'on'=>USERS.'.id='.USER_PRODUCTS.'.user_id','type'=>'');
					$joinArr = array($joinArr1);
					$this->data['notsell_product_details'] = $this->product_model->get_fields_from_many(USER_PRODUCTS,$fieldsArr,USER_PRODUCTS.'.seller_product_id',$searchArr,$joinArr,'','',$condition);
				}else {
					$this->data['notsell_product_details'] = '';
					$this->data['product_details'] = '';
					$this->data['totalProducts'] = 0;
				}
				$this->load->view('site/user/user_list_home',$this->data);
			}
		}
	}
	
	public function display_user_lists_followers(){
		$lid = $this->uri->segment('4','0');
		$uname = $this->uri->segment('2','0');
		$this->data['user_profile_details'] = $userProfileDetails = $this->user_model->get_all_details(USERS,array('user_name'=>$uname));
		if ($userProfileDetails->row()->visibility == 'Only you' && $userProfileDetails->row()->id != $this->checkLogin('U')){
			$this->load->view('site/user/display_user_profile_private',$this->data);
		}else {
			$this->data['list_details'] = $list_details = $this->product_model->get_all_details(LISTS_DETAILS,array('id'=>$lid,'user_id'=>$this->data['user_profile_details']->row()->id));
			if ($this->data['list_details']->num_rows()==0){
				show_404();
			}else {
				$fieldsArr = '*';
				$searchArr = explode(',', $list_details->row()->followers);
				$this->data['user_details'] = $user_details = $this->product_model->get_fields_from_many(USERS,$fieldsArr,'id',$searchArr);
				if ($user_details->num_rows()>0){
					foreach ($user_details->result() as $userRow){
						$fieldsArr = array(PRODUCT_LIKES.'.*',PRODUCT.'.product_name',PRODUCT.'.image',PRODUCT.'.id as PID');
						$searchArr = array($userRow->id);
						$joinArr1 = array('table'=>PRODUCT,'on'=>PRODUCT_LIKES.'.product_id='.PRODUCT.'.seller_product_id','type'=>'');
						$joinArr = array($joinArr1);
						$sortArr1 = array('field'=>PRODUCT.'.created','type'=>'desc');
						$sortArr = array($sortArr1);
						$this->data['product_details'][$userRow->id] = $this->product_model->get_fields_from_many(PRODUCT_LIKES,$fieldsArr,PRODUCT_LIKES.'.user_id',$searchArr,$joinArr,$sortArr,'5');
					}
				}
				$fieldsArr = array(PRODUCT.'.*',USERS.'.user_name',USERS.'.full_name');
				$searchArr = array_filter(explode(',', $list_details->row()->product_id));
				if (count($searchArr)>0){
					$this->data['totalProducts'] = count($searchArr);
				}else {
					$this->data['totalProducts'] = 0;
				}
				
				$this->load->view('site/user/user_list_followers',$this->data);
			}
		}
	}
	
	public function follow_list(){
		$returnStr['status_code'] = 0;
		$lid = $this->input->post('lid');
		if ($this->checkLogin('U') != ''){
			$listDetails = $this->product_model->get_all_details(LISTS_DETAILS,array('id'=>$lid));
			$followersArr = explode(',', $listDetails->row()->followers);
			$followersCount = $listDetails->row()->followers_count;
			$oldDetails = explode(',', $this->data['userDetails']->row()->following_user_lists);
			if (!in_array($lid, $oldDetails)){
				array_push($oldDetails, $lid);
			}
			if (!in_array($this->checkLogin('U'), $followersArr)){
				array_push($followersArr, $this->checkLogin('U'));
				$followersCount++;
			}
			$this->product_model->update_details(USERS,array('following_user_lists'=>implode(',', $oldDetails)),array('id'=>$this->checkLogin('U')));
			$this->product_model->update_details(LISTS_DETAILS,array('followers'=>implode(',', $followersArr),'followers_count'=>$followersCount),array('id'=>$lid));
			$returnStr['status_code'] = 1;
		}
		echo json_encode($returnStr);
	}
	
	public function unfollow_list(){
		$returnStr['status_code'] = 0;
		$lid = $this->input->post('lid');
		if ($this->checkLogin('U') != ''){
			$listDetails = $this->product_model->get_all_details(LISTS_DETAILS,array('id'=>$lid));
			$followersArr = explode(',', $listDetails->row()->followers);
			$followersCount = $listDetails->row()->followers_count;
			$oldDetails = explode(',', $this->data['userDetails']->row()->following_user_lists);
			if (in_array($lid, $oldDetails)){
				if ($key = array_search($lid, $oldDetails) !== false){
					unset($oldDetails[$key]);
				}
			}
			if (in_array($this->checkLogin('U'), $followersArr)){
				if ($key = array_search($this->checkLogin('U'), $followersArr) !== false){
					unset($followersArr[$key]);
				}
				$followersCount--;
			}
			$this->product_model->update_details(USERS,array('following_user_lists'=>implode(',', $oldDetails)),array('id'=>$this->checkLogin('U')));
			$this->product_model->update_details(LISTS_DETAILS,array('followers'=>implode(',', $followersArr),'followers_count'=>$followersCount),array('id'=>$lid));
			$returnStr['status_code'] = 1;
		}
		echo json_encode($returnStr);
	}
	
	public function edit_user_lists(){
		if ($this->checkLogin('U') == ''){
			redirect('login');
		}else {
			$lid = $this->uri->segment('4','0');
			$uname = $this->uri->segment('2','0');
			if ($uname != $this->data['userDetails']->row()->user_name){
				show_404();
			}else {
				$this->data['user_profile_details'] = $this->user_model->get_all_details(USERS,array('user_name'=>$uname));
				$this->data['list_details'] = $list_details = $this->product_model->get_all_details(LISTS_DETAILS,array('id'=>$lid,'user_id'=>$this->data['user_profile_details']->row()->id));
				if ($this->data['list_details']->num_rows()==0){
					show_404();
				}else {
					$this->data['list_category_details'] = $this->user_model->get_all_details(CATEGORY,array('id'=>$this->data['list_details']->row()->category_id));
					$this->data['heading'] = 'Edit List';
					$this->load->view('site/user/edit_user_list',$this->data);
				}
			}
		}
	}
	
	public function edit_user_list_details(){
		if ($this->checkLogin('U') == ''){
			redirect('login');
		}else {
			$lid = $this->input->post('lid');
			$uid = $this->input->post('uid');
			if ($uid != $this->checkLogin('U')){
				show_404();
			}else {
				$list_title = $this->input->post('setting-title');
				$catID = $this->input->post('category');
				$duplicateCheck = $this->user_model->get_all_details(LISTS_DETAILS,array('user_id'=>$uid,'id !='=>$lid,'name'=>$list_title));
				if ($duplicateCheck->num_rows()>0){
					$this->setErrorMessage('error','List title already exists');
					echo '<script>window.history.go(-1);</script>';
				}else {
					if ($catID == ''){
						$catID = 0;
					}
					$this->user_model->update_details(LISTS_DETAILS,array('name'=>$list_title,'category_id'=>$catID),array('id'=>$lid,'user_id'=>$uid));
					$this->setErrorMessage('success','List updated successfully');
					echo '<script>window.history.go(-1);</script>';
				}
			}
		}
	}
	
	public function delete_user_list(){
		$returnStr['status_code'] = 0;
		if ($this->checkLogin('U')==''){
			$returnStr['message'] = 'Login required';
		}else {
			$lid = $this->input->post('lid');
			$uid = $this->input->post('uid');
			if ($uid != $this->checkLogin('U')){
				$returnStr['message'] = 'You can\'t delete other\'s list';
			}else {
				$list_details = $this->user_model->get_all_details(LISTS_DETAILS,array('id'=>$lid,'user_id'=>$uid));
				if ($list_details->num_rows() == 1){
					$followers_id = $list_details->row()->followers;
					if ($followers_id != ''){
						$searchArr = array_filter(explode(',', $followers_id));
						$fieldsArr = array('following_user_lists','id');
						$followersArr = $this->user_model->get_fields_from_many(USERS,$fieldsArr,'id',$searchArr);
						if ($followersArr->num_rows()>0){
							foreach ($followersArr->result() as $followersRow){
								$listArr = array_filter(explode(',', $followersRow->following_user_lists));
								if (in_array($lid, $listArr)){
									if (($key = array_search($lid, $listArr)) != false){
										unset($listArr[$key]);
										$this->user_model->update_details(USERS,array('following_user_lists'=>implode(',', $listArr)),array('id'=>$followersRow->id));
									}
								}
							}
						}
					}
					$this->user_model->commonDelete(LISTS_DETAILS,array('id'=>$lid,'user_id'=>$this->checkLogin('U')));
					$listCount = $this->data['userDetails']->row()->lists;
					$listCount--;
					if ($listCount == '' || $listCount < 0){
						$listCount = 0;
					}
					$this->user_model->update_details(USERS,array('lists'=>$listCount),array('id'=>$this->checkLogin('U')));
					$returnStr['url'] = base_url().'people/'.$this->data['userDetails']->row()->user_name.'/favorites';
					$this->setErrorMessage('success','List deleted successfully');
					$returnStr['status_code'] = 1;
				}else {
					$returnStr['message'] = 'List not available';
				}
			}
		}
		echo json_encode($returnStr);
	}
	
	public function image_crop(){
		if($this->checkLogin('U') == ''){
			redirect('login');
		}else {
			$uid = $this->uri->segment(2,0);
			if ($uid != $this->checkLogin('U')){
				show_404();
			}else {
				$this->data['heading'] = 'Cropping Image';
				$this->load->view('site/user/crop_image',$this->data);
			}
		}
	}
	
	public function image_crop_process(){
		if($this->checkLogin('U') == ''){
			redirect('login');
		}else {
			$targ_w = $targ_h = 240;
			$jpeg_quality = 90;
		
			$src = 'images/users/'.$this->data['userDetails']->row()->thumbnail;
			$ext = substr($src, strpos($src , '.')+1);
			if ($ext == 'png'){
				$jpgImg = imagecreatefrompng($src);
				imagejpeg($jpgImg, $src, 90);
			}
			$img_r = imagecreatefromjpeg($src);
			$dst_r = ImageCreateTrueColor( $targ_w, $targ_h );
			
//			list($width, $height) = getimagesize($src);
		
			imagecopyresampled($dst_r,$img_r,0,0,$_POST['x1'],$_POST['y1'],	$targ_w,$targ_h,$_POST['w'],$_POST['h']);
//		imagecopyresized($dst_r,$img_r,0,0,$_POST['x1'],$_POST['y1'],	$targ_w,$targ_h,$_POST['w'],$_POST['h']);
//		imagecopyresized($dst_r, $img_r,0,0, $_POST['x1'],$_POST['y1'], $_POST['x2'],$_POST['y2'],1024,980);
//			header('Content-type: image/jpeg');
			imagejpeg($dst_r,'images/users/'.$this->data['userDetails']->row()->thumbnail);
			$this->setErrorMessage('success','Profile photo changed successfully');
			redirect('settings');
			exit;
		}
	}
	
	public function send_noty_mail($followUserDetails=array()){
		if (count($followUserDetails)>0){
			$emailNoty = explode(',', $followUserDetails[0]['email_notifications']);
			if (in_array('following', $emailNoty)){
				$newsid='7';
		  		$template_values=$this->product_model->get_newsletter_template_details($newsid);
		$adminnewstemplateArr=array('logo'=> $this->data['logo'],'meta_title'=>$this->config->item('meta_title'),'full_name'=>$followUserDetails[0]['full_name'],'cfull_name'=>$this->data['userDetails']->row()->full_name,'user_name'=>$this->data['userDetails']->row()->user_name);
        extract($adminnewstemplateArr);
		$subject = 'From: '.$this->config->item('email_title').' - '.$template_values['news_subject'];
  		$message .= '<!DOCTYPE HTML>
			<html>
			<head>
			<meta http-equiv="Content-Type" content="text/html; charset=utf-8">
			<meta name="viewport" content="width=device-width"/>
			<title>'.$template_values['news_subject'].'</title><body>';
		include('./newsletter/registeration'.$newsid.'.php');	
		
		$message .= '</body>
			</html>';
				
				
                if($template_values['sender_name']=='' && $template_values['sender_email']==''){
                    $sender_email=$this->data['siteContactMail'];
                    $sender_name=$this->data['siteTitle'];
                }else{
                    $sender_name=$template_values['sender_name'];
                    $sender_email=$template_values['sender_email'];
                }

                $email_values = array('mail_type'=>'html',
                                    'from_mail_id'=>$sender_email,
                                    'mail_name'=>$sender_name,
									'to_mail_id'=>$followUserDetails[0]['email'],
									'subject_message'=>$subject,
									'body_messages'=>$message
									);
				$email_send_to_common = $this->product_model->common_email_send($email_values);
			}
		}
	}
	
	public function send_noty_mails($followUserDetails=array()){
		if (count($followUserDetails)>0){
			$emailNoty = explode(',', $followUserDetails->email_notifications);
			if (in_array('following', $emailNoty)){
            
            $newsid='9';
		  		$template_values=$this->product_model->get_newsletter_template_details($newsid);
		$adminnewstemplateArr=array('logo'=> $this->data['logo'],'meta_title'=>$this->config->item('meta_title'),'full_name'=>$followUserDetails[0]['full_name'],'cfull_name'=>$this->data['userDetails']->row()->full_name,'user_name'=>$this->data['userDetails']->row()->user_name);
        extract($adminnewstemplateArr);
		$subject = 'From: '.$this->config->item('email_title').' - '.$template_values['news_subject'];
  		$message .= '<!DOCTYPE HTML>
			<html>
			<head>
			<meta http-equiv="Content-Type" content="text/html; charset=utf-8">
			<meta name="viewport" content="width=device-width"/>
			<title>'.$template_values['news_subject'].'</title><body>';
		include('./newsletter/registeration'.$newsid.'.php');	
		
		$message .= '</body>
			</html>';
            
                if($template_values['sender_name']=='' && $template_values['sender_email']==''){
                    $sender_email=$this->data['siteContactMail'];
                    $sender_name=$this->data['siteTitle'];
                }else{
                    $sender_name=$template_values['sender_name'];
                    $sender_email=$template_values['sender_email'];
                }

                $email_values = array('mail_type'=>'html',
                                    'from_mail_id'=>$sender_email,
                                    'mail_name'=>$sender_name,
									'to_mail_id'=>$followUserDetails->email,
									'subject_message'=>$subject,
									'body_messages'=>$message
									);
				$email_send_to_common = $this->product_model->common_email_send($email_values);
			}
		}
	}
	
	public function order_review(){
		if ($this->checkLogin('U')==''){
			show_404();
		}else {
			$uid = $this->uri->segment(2,0);
			$sid = $this->uri->segment(3,0);
			$dealCode = $this->uri->segment(4,0);
			if ($uid == $this->checkLogin('U')){
				$view_mode = 'user';
			}else if ($sid == $this->checkLogin('U')){
				$view_mode = 'seller';
			}else {
				$view_mode = '';
			}
			if ($view_mode == ''){
				show_404();
			}else {
				if ($view_mode == 'seller'){
					$this->db->select('p.*,pAr.attr_name');
					$this->db->from(PAYMENT.' as p');
					$this->db->join(PRODUCT_ATTRIBUTE.' as pAr' , 'pAr.id = p.attribute_values','left');
					$this->db->where('p.sell_id = "'.$sid.'" and p.status = "Paid" and p.dealCodeNumber = "'.$dealCode.'"');
					$order_details = $this->db->get();
					
					//$order_details = $this->user_model->get_all_details(PAYMENT,array('dealCodeNumber'=>$dealCode,'status'=>'Paid','sell_id'=>$sid));
				}else {
				
				//$order_details = $this->user_model->get_all_details(PAYMENT,array('dealCodeNumber'=>$dealCode,'status'=>'Paid'));
					$this->db->select('p.*,pAr.attr_name');
					$this->db->from(PAYMENT.' as p');
					$this->db->join(PRODUCT_ATTRIBUTE.' as pAr' , 'pAr.id = p.attribute_values','left');
					$this->db->where("p.status = 'Paid' and p.dealCodeNumber = '".$dealCode."'");
					$order_details = $this->db->get();

					
				}
				
				if ($order_details->num_rows()==0){
					show_404();
				}else {
					if ($view_mode == 'user'){
						$this->data['user_details'] = $this->data['userDetails'];
						$this->data['seller_details'] = $this->user_model->get_all_details(USERS,array('id'=>$sid));
					}elseif ($view_mode == 'seller'){
						$this->data['user_details'] = $this->user_model->get_all_details(USERS,array('id'=>$uid));
						$this->data['seller_details'] = $this->data['userDetails'];
					}
					foreach ($order_details->result() as $order_details_row){
						$this->data['prod_details'][$order_details_row->product_id] = $this->user_model->get_all_details(PRODUCT,array('id'=>$order_details_row->product_id));
					}
					$this->data['view_mode'] = $view_mode;
					$this->data['order_details'] = $order_details;
					$sortArr1 = array('field'=>'date','type'=>'desc');
					$sortArr = array($sortArr1);
					$this->data['order_comments'] = $this->user_model->get_all_details(REVIEW_COMMENTS,array('deal_code'=>$dealCode),$sortArr);
					$this->load->view('site/user/display_order_reviews',$this->data);
				}
			}
		}
	}
	
	public function order_seller_review(){
		if ($this->checkLogin('U')==''){
			show_404();
		}else {
			$uid = $this->uri->segment(2,0);
			$sid = $this->uri->segment(3,0);
			$dealCode = $this->uri->segment(4,0);
			if ($uid == $this->checkLogin('U')){
				$view_mode = 'user';
			}else if ($sid == $this->checkLogin('U')){
				$view_mode = 'seller';
			}else {
				$view_mode = '';
			}
			if ($view_mode == ''){
				show_404();
			}else {
				if ($view_mode == 'seller'){
					$this->db->select('p.*');
					$this->db->from(USER_PAYMENT.' as p');
					$this->db->where('p.sell_id = "'.$sid.'" and p.status = "Paid" and p.dealCodeNumber = "'.$dealCode.'"');
					$order_details = $this->db->get();
					
					//$order_details = $this->user_model->get_all_details(PAYMENT,array('dealCodeNumber'=>$dealCode,'status'=>'Paid','sell_id'=>$sid));
				}else {
				
				//$order_details = $this->user_model->get_all_details(PAYMENT,array('dealCodeNumber'=>$dealCode,'status'=>'Paid'));
					$this->db->select('p.*');
					$this->db->from(USER_PAYMENT.' as p');
					$this->db->where("p.status = 'Paid' and p.dealCodeNumber = '".$dealCode."'");
					$order_details = $this->db->get();

					
				}
				
				if ($order_details->num_rows()==0){
					show_404();
				}else {
					if ($view_mode == 'user'){
						$this->data['user_details'] = $this->data['userDetails'];
						$this->data['seller_details'] = $this->user_model->get_all_details(USERS,array('id'=>$sid));
					}elseif ($view_mode == 'seller'){
						$this->data['user_details'] = $this->user_model->get_all_details(USERS,array('id'=>$uid));
						$this->data['seller_details'] = $this->data['userDetails'];
					}
					foreach ($order_details->result() as $order_details_row){
						$this->data['prod_details'][$order_details_row->product_id] = $this->user_model->get_all_details(USER_PRODUCTS,array('id'=>$order_details_row->product_id));
					}
					$this->data['view_mode'] = $view_mode;
					$this->data['order_details'] = $order_details;
					$sortArr1 = array('field'=>'date','type'=>'desc');
					$sortArr = array($sortArr1);
					$this->data['order_comments'] = $this->user_model->get_all_details(REVIEW_COMMENTS,array('deal_code'=>$dealCode),$sortArr);
					$this->load->view('site/user/display_order_reviews',$this->data);
				}
			}
		}
	}
	
	
	//S Codes
	
	
	
	// Seller Shop product Settings
	public function shop_temp() 
	{
    	extract($_POST);
			if ($this->checkLogin('U')!=''){
				 
				$this->user_model->updateUserQuickTemp();
				$this->setErrorMessage('success','Shop Product Setup Updated Successfully');	
				redirect('settings');
				
			}else {
				$this->data['next'] = $this->input->get('next');
				//echo $this->data['next'];die;
				$this->data['heading'] = 'Sign in'; 
				$this->load->view('site/user/signup.php',$this->data);
			}

  	}
	
	
	
	public function post_order_comment(){
		if ($this->checkLogin('U') != ''){
			$this->user_model->commonInsertUpdate(REVIEW_COMMENTS,'insert',array(),array(),'');
		}
	}
	
	public function change_received_status(){
		if ($this->checkLogin('U')!=''){
			$status = $this->input->post('status');
			$rid = $this->input->post('rid');
			$this->user_model->update_details(PAYMENT,array('received_status'=>$status),array('id'=>$rid));
		}
	}
	public function update_favorite_status(){
		if ($this->checkLogin('U')!=''){
			$status = $this->input->post('status');
			$rid = $this->input->post('rid');
			$this->user_model->commonDelete(FAVORITE,array('received_status'=>$status),array('id'=>$rid));
		}
	}

	public function insert_favorite_status($shopid='',$type=''){
		$returnStr['status_code'] = 0;
		if($shopid!=''){
			$rdir=1;
		}
		if ($this->checkLogin('U')!=''){
			$userid = $this->checkLogin('U');
			if($shopid==''){
			$shopid = $this->input->post('shopid');}
			if($type==''){
			$type = $this->input->post('type');}
			if($type == 'Fresh'){
				$checkShopStaus = $this->user_model->get_all_details(FAVORITE,array('shop_id'=>$shopid,'user_id'=>$userid,'favorite'=>'Yes'));
				if ($checkShopStaus->num_rows() < 1){
					$dataArr = array('shop_id'=>$shopid,'user_id'=>$userid,'favorite'=>'Yes');
					$this->user_model->simple_insert(FAVORITE,$dataArr);
					# addding favorites shop count and add to activity table
					$checkShopLike = $this->user_model->get_all_details(FAVORITE,array('shop_id'=>$shopid));
					if ($checkShopLike->num_rows() > 0){
						$userDetails = $this->user_model->get_all_details(USERS,array('id'=>$shopid));
						if ($userDetails->num_rows()>0){
							$likes = $userDetails->row()->likes;
							$actArr = array(
								'activity_name'	=>	'favorite shop',
								'activity_id'	=>	$shopid,
								'user_id'		=>	$this->checkLogin('U'),
								'activity_ip'	=>	$this->input->ip_address()
							);
							$checkShopStatus = $this->user_model->get_all_details(USER_ACTIVITY,array('activity_id'=>$shopid,'user_id'=>$this->checkLogin('U')));
							if ($checkShopStatus->num_rows() < 1){
							$this->user_model->simple_insert(USER_ACTIVITY,$actArr);
							}
							else
							{
								$this->user_model->commonDelete(USER_ACTIVITY,array('activity_id'=>$shopid,'user_id'=>$this->checkLogin('U')));
								$this->user_model->simple_insert(USER_ACTIVITY,$actArr);
							}
							$likes++;
							$dataArr = array('likes'=>$likes);
							$condition = array('id'=>$shopid);
							$this->user_model->update_details(USERS,$dataArr,$condition);					
							#$returnStr['status_code'] = 1;
						}
					}
				}
				$this->setErrorMessage('success','This Shop Added to Your Favorite List!');	
				$returnStr['status_code'] = 1;
				if($rdir){
					redirect('people/'.$this->session->userdata('shopsy_session_user_name').'/favorites/shop');
				}
			}else if($type == 'Old'){
				# Updating favorites shop count and update to activity table
				$checkShopLike = $this->user_model->get_all_details(FAVORITE,array('shop_id'=>$shopid));
				
				if ($checkShopLike->num_rows() > 0){
				$userDetails = $this->user_model->get_all_details(USERS,array('id'=>$shopid));
				if ($userDetails->num_rows()>0){
					$likes = $userDetails->row()->likes;
					$actArr = array(
						'activity_name'	=>	'Unfavorite shop',
						'activity_id'	=>	$shopid,
						'user_id'		=>	$this->checkLogin('U'),
						'activity_ip'	=>	$this->input->ip_address()
					);
					$condition = array('activity_id'=>$shopid,'user_id'=>$this->checkLogin('U'));
					$this->user_model->update_details(USER_ACTIVITY,$actArr,$condition);					
					$likes--;
					$dataArr = array('likes'=>$likes);
					$condition = array('id'=>$shopid);
					$this->user_model->update_details(USERS,$dataArr,$condition);					
					#$returnStr['status_code'] = 1;
				}
				$this->user_model->fav_delete($userid,$shopid);
				$this->setErrorMessage('success','This Shop Removed From Your Favorite List!');
				if($rdir){
					redirect('people/'.$this->session->userdata('shopsy_session_user_name').'/favorites/shop');
				}
				
			}
			$returnStr['status_code'] = 1;			
			}
		}
		else
		{
			$this->setErrorMessage('error','Login Required for Adding this shop to your favorites');
			$returnStr['status_code'] = 0;
			$returnStr['next_url']=urlencode('site/user/insert_favorite_status/'.$this->input->post('shopid').'/'.$this->input->post('type'));
		}
		echo json_encode($returnStr);
	}	
	
	/*Product to favorite List*/
	public function product_favorite_status($pid='',$type=''){
		$returnStr['status_code'] = 0;
		if($type!=''){
			$rdir = 1;
		}
		if ($this->checkLogin('U')!=''){
			$userid = $this->checkLogin('U');
			if($pid==''){
			$pid = $this->input->post('pid');}
			if($type==''){
			$type = $this->input->post('type');}
			if($type == 'Fresh'){
				$checkFavStatus = $this->user_model->get_all_details(FAVORITE,array('p_id'=>$pid,'user_id'=>$userid,'favorite'=>'Yes'));
				if ($checkFavStatus->num_rows() < 1){				
					$dataArr = array('p_id'=>$pid,'user_id'=>$userid,'favorite'=>'Yes');
					$this->user_model->simple_insert(FAVORITE,$dataArr);	
					
					# addding favorites count and add to activity table
					$checkProductLike = $this->user_model->get_all_details(FAVORITE,array('p_id'=>$pid));
					if ($checkProductLike->num_rows() > 0){
						$productDetails = $this->user_model->get_all_details(PRODUCT,array('id'=>$pid));
						if ($productDetails->num_rows()>0){
							$likes = $productDetails->row()->likes;
							$actArr = array(
								'activity_name'	=>	'favorite item',
								'activity_id'	=>	$pid,
								'user_id'		=>	$this->checkLogin('U'),
								'activity_ip'	=>	$this->input->ip_address()
							);
							$checkProductStatus = $this->user_model->get_all_details(USER_ACTIVITY,array('activity_id'=>$pid,'user_id'=>$this->checkLogin('U')));
							if ($checkProductStatus->num_rows() < 1){
							$this->user_model->simple_insert(USER_ACTIVITY,$actArr);
							}
							else
							{
								$this->user_model->commonDelete(USER_ACTIVITY,array('activity_id'=>$pid,'user_id'=>$this->checkLogin('U')));
								$this->user_model->simple_insert(USER_ACTIVITY,$actArr);
							}
							
							$likes++;
							$dataArr = array('likes'=>$likes);
							$condition = array('id'=>$pid);
							$this->user_model->update_details(PRODUCT,$dataArr,$condition);					
							$returnStr['status_code'] = 1;
						}
					}
				$returnStr['status_code'] = 1;
				}
				$this->setErrorMessage('success','Product Added to Favorite List!');
				if($rdir){
					redirect('people/'.$this->session->userdata('shopsy_session_user_name').'/favorites/items-i-love');		
				}
			}else if($type == 'Old'){
				$checkFavStatus = $this->user_model->get_all_details(FAVORITE,array('p_id'=>$pid,'user_id'=>$userid,'favorite'=>'Yes'));
				if ($checkFavStatus->num_rows() > 0){
					# Updating favorites count and update to activity table
					$checkProductLike = $this->user_model->get_all_details(FAVORITE,array('p_id'=>$pid));
					
					if ($checkProductLike->num_rows() > 0){
					$productDetails = $this->user_model->get_all_details(PRODUCT,array('id'=>$pid));
					if ($productDetails->num_rows()>0){
						$likes = $productDetails->row()->likes;
						$actArr = array(
							'activity_name'	=>	'Unfavorite item',
							'activity_id'	=>	$pid,
							'user_id'		=>	$this->checkLogin('U'),
							'activity_ip'	=>	$this->input->ip_address()
						);
						$condition = array('activity_id'=>$pid,'user_id'=>$this->checkLogin('U'));
						$this->user_model->update_details(USER_ACTIVITY,$actArr,$condition);					
						$likes--;
						$dataArr = array('likes'=>$likes);
						$condition = array('id'=>$pid);
						$this->user_model->update_details(PRODUCT,$dataArr,$condition);					
						#$returnStr['status_code'] = 1;
					}
					$this->user_model->product_fav_delete($userid,$pid);
					$this->setErrorMessage('success','Product Removed from Favorite List!');
					if($rdir){
						redirect('people/'.$this->session->userdata('shopsy_session_user_name').'/favorites/items-i-love');
					}
				}
				$returnStr['status_code'] = 1;
			}
			$returnStr['status_code'] = 1;
		}
		}
		else
		{
			$this->setErrorMessage('error','Login Required for Adding this product to your favorites');
			$returnStr['status_code'] = 0;
			$returnStr['next_url'] =urlencode('site/user/product_favorite_status/'.$this->input->post('pid').'/'.$this->input->post('type'));
			
		}
		echo json_encode($returnStr);
	}
	
	/*People favorite List*/
	public function people_favorite_list(){
		#if ($this->checkLogin('U')!=''){
			$this->data['currUser']=$checkloginIDarr=$this->session->all_userdata(); 
		 	$loggeduserID=$checkloginIDarr['shopsy_session_user_id'];
			$username =  urldecode($this->uri->segment(2,0));
			$userDetails= $this->user_model->get_all_details(USERS,array('user_name'=>$username))->result_array();
			$uid=$userDetails[0]['id'];
			$this->data['userProfileDetails']=$userProfileDetails = $this->user_model->get_all_details(USERS,array('id'=>$userDetails[0]['id'],'status'=>'Active'))->result_array();
			$this->data['userFavoriteItems']=$userFavoriteItems = $this->product_model->getFavoriteProduct($userDetails[0]['id'])->result_array();
			$this->data['userListDetails']=$userProfileDetails = $this->user_model->get_all_details(LISTS_DETAILS,array('user_id'=>$userDetails[0]['id']))->result_array();
			#echo "<pre>"; print_r($userProfileDetails); print_r($userFavoriteItems); die;
			if($_GET['a']){
				$search_key=$_GET['a'];				
				$this->data['searchtProducts']= $searchtProducts= $this->user_model->get_search_favorite_list($search_key,$uid)->result_array();
				#echo "<pre>"; print_r($searchtProducts); die;
			}
			$this->data['heading'] = $username.' Favorites on '.$this->config->item('email_title');
			$this->load->view('site/user/favorites',$this->data);
			
		#}
		
	}
	/*People favorite List*/
	public function people_favorite_list_itemsilove(){
		#if ($this->checkLogin('U')!=''){
			$this->data['currUser']=$checkloginIDarr=$this->session->all_userdata(); 
		 	$this->data['loggeduserID']=$loggeduserID=$checkloginIDarr['shopsy_session_user_id'];
			$username =  urldecode($this->uri->segment(2,0));
			$userDetails= $this->user_model->get_all_details(USERS,array('user_name'=>$username))->result_array();
			$userDetails[0]['id'];
				$condition='';
				if($_GET['a']){
					$search_key=$_GET['a'];
					$condition="p.product_name LIKE '%".$search_key."%' and";
				}	
				if($_GET['filter']){
					$condition="p.status='Publish' and p.quantity>2 and";
				}
			$this->data['userProfileDetails']=$userProfileDetails = $this->user_model->get_all_details(USERS,array('id'=>$userDetails[0]['id'],'status'=>'Active'))->result_array();
			$this->data['userFavoriteItems']=$userFavoriteItems = $this->product_model->getFavoriteProduct($userDetails[0]['id'],$condition,8,0)->result_array();
			#echo "<pre>"; print_r($userProfileDetails); print_r($userFavoriteItems); die;
			$this->data['heading'] = 'Items I love by '.$username.' on '.$this->config->item('email_title');
			$this->load->view('site/user/itemsilove',$this->data);
			
		#}
		
	}
	/*People favorite List*/
	public function people_list_items(){
		#if ($this->checkLogin('U')!=''){
			$urlValArr=$this->uri->segment_array();
			$urlVal=explode('-',$urlValArr[count($urlValArr)]);
			$this->data['listId']=$listId=$urlVal[0];
			$this->data['listName']=$listName=$urlVal[1];
			$listProduct=array();
			$this->data['listProductVal']=$listProductVal= $this->user_model->get_all_details(LISTS_DETAILS,array('id'=>$listId))->result_array();
			$products=explode(',',$listProductVal[0]['product_id']);
			for($i=0;$i<count($products);$i++)
			{	
				$condition='';
				if($_GET['a']){
					$search_key=$_GET['a'];
					$condition="p.product_name LIKE '%".$search_key."%' and";
				}
				if($_GET['filter']){
					$condition="p.status='Publish' and p.quantity>0 and";
				}
				$listProduct=array_merge($listProduct,$this->product_model->get_list_product_details($products[$i],$condition)->result_array());
				#echo $this->db->last_query();
			}
			#die;
			$this->data['listProduct']=$listProduct;
			$checkloginIDarr=$this->session->all_userdata(); 
		 	$this->data['loggeduserID']= $loggeduserID=$checkloginIDarr['shopsy_session_user_id'];
			$username =  urldecode($this->uri->segment(2,0));
			$userDetails= $this->user_model->get_all_details(USERS,array('user_name'=>$username))->result_array();
			$userDetails[0]['id'];
			$this->data['userProfileDetails']=$userProfileDetails = $this->user_model->get_all_details(USERS,array('id'=>$userDetails[0]['id'],'status'=>'Active'))->result_array();
			$this->data['heading'] = $urlVal[1].' by '.$username.' on '.$this->config->item('email_title');
			$this->load->view('site/user/favorites_list_items',$this->data);
			
		#}
		
	}
	
	/*People favorite List*/
	public function people_favorite_shoplist(){
		#if ($this->checkLogin('U')!=''){
			$this->data['currUser']=$checkloginIDarr=$this->session->all_userdata(); 
		 	$loggeduserID=$checkloginIDarr['shopsy_session_user_id'];
			$username =  urldecode($this->uri->segment(2,0));
			$this->data['userDetails']=$userDetails= $this->user_model->get_all_details(USERS,array('user_name'=>$username))->result_array();
			#$userDetails[0]['id'];
			$this->data['userProfileDetails']=$userProfileDetails = $this->user_model->get_all_details(USERS,array('id'=>$userDetails[0]['id'],'status'=>'Active'))->result_array();
			$this->data['userFavoriteShops']=$userFavoriteShops = $this->product_model->getFavoriteShops($userDetails[0]['id'])->result_array();
			$userFavoriteShopsProducts=array();
			foreach($userFavoriteShops as $shops)
			{
				$condition="p.user_id=".$shops['seller_id']." GROUP BY a.product_id";
				$products=$this->product_model->get_product_from_favorite_shop($condition)->result_array();
				$userFavoriteShopsProducts=array_merge($userFavoriteShopsProducts,$products);	
				#echo "<pre>"; print_r($this->data["'shop_'".$shop_product.'"']);
			}
			$this->data['userFavoriteShopsProducts']=$userFavoriteShopsProducts ;
			#echo "<pre>"; print_r($userProfileDetails); print_r($userFavoriteShops); print_r($userFavoriteShopsProducts); die;
			$username =  urldecode($this->uri->segment(2,0));
			$userProfileDetails =$this->data['userProfileDetails']= $this->user_model->get_all_details(USERS,array('user_name'=>$username));
			$this->data['heading'] = $username.'\'s Favorites on '.$this->config->item('email_title');
			$this->load->view('site/user/favorite_shop',$this->data);
			
		#}
		
	}	
	/*User AddEdit products to List*/
	public function user_addproducttolist(){
		if ($this->checkLogin('U')!=''){
			$listId=$this->input->post('listId');
			$prodId=$this->input->post('prodId');
			echo '/'.$listId; echo '/'.$prodId;
			$this->data['listProduct']=$listProduct = $this->user_model->get_all_details(LISTS_DETAILS,array('id'=>$listId))->result_array();
			$productArr=explode(',',$listProduct[0]['product_id']);
			if(in_array($prodId,$productArr))
			{ 
				$newproductlist=str_replace($prodId.',','',$listProduct[0]['product_id']);
				$productCount=$listProduct[0]['product_count']-1; 
				 
			}
			else
			{ 
				$newproductlist=$listProduct[0]['product_id'].$prodId.','; $productCount=$listProduct[0]['product_count']+1; 
			}
			//echo "<pre>"; print_r($listProduct); print_r($productArr);  echo $newproductlist;echo '/'.$productCount; die;
			$this->user_model->update_details(LISTS_DETAILS,array('product_id'=>$newproductlist,'product_count'=>$productCount),array('id'=>$listId));
			$this->setErrorMessage('success','Your List has been updated');
			
		}
	}
	/*update user favorite status*/
	public function update_user_favorite_status($id=''){		
		if ($this->checkLogin('U')!=''){
			$username =  urldecode($this->uri->segment(2,0));
			
			$privacy_level=$this->input->post('privacy_level');
			
				$dataArr = array('favorites_visibility'=>$privacy_level);
				$condition = array('id'=>$this->session->userdata('shopsy_session_user_id'));
				#echo "<pre>"; print_r($dataArr); print_r($condition); die;
				$this->user_model->update_details(USERS,$dataArr,$condition);		
						
				$this->setErrorMessage('success','List  Updated successfully');
				redirect('/people/'.$this->session->userdata('shopsy_session_user_name').'/favorites/items-i-love');
			
		}
		else
		{
			$this->setErrorMessage('error','Login Required');
			redirect('login');
		}
	}
	/*update user favorite shop visibility */
	public function update_user_favorite_shop_staus($id=''){		
		if ($this->checkLogin('U')!=''){
			$username =  urldecode($this->uri->segment(2,0));
			
			$privacy_level=$this->input->post('privacy_level');
			
				$dataArr = array('shop_visibility'=>$privacy_level);
				$condition = array('id'=>$this->session->userdata('shopsy_session_user_id'));
				#echo "<pre>"; print_r($dataArr); print_r($condition); die;
				$this->user_model->update_details(USERS,$dataArr,$condition);		
						
				$this->setErrorMessage('success','your shop visibilty changed successfully');
				redirect('/people/'.$this->session->userdata('shopsy_session_user_name').'/favorites/shop');
			
		}
		else
		{
			$this->setErrorMessage('error','Login Required');
			redirect('login');
		}
	}
	/*************************** Contact Shop Owner Check product popup function  *************************************/
	
	public function contactshop(){
	
		$usrId = $this->input->post('usrId'); 
		$orderId = $this->input->post('orderId'); 
		
		$userPurchase=$this->user_model->get_user_purchase_list($usrId,$orderId);
		$purchaseProducts=$userPurchase->result();
		$UserVal = $this->user_model->get_all_details(USERS,array( 'id' => $this->data['common_user_id']));	
		
		
		if($purchaseProducts[0]->thumbnail !=''){
			$srcVal = 'images/users/'.$purchaseProducts[0]->thumbnail;
			
		}else{
			$srcVal = 'images/default_avat.png';
		}
		$datestring ="%M %d,%Y "; $time = $purchaseProducts[0]->inserttime;
		$transactionon=mdate($datestring,$time);
		
		$popupVal = '<div class="conversation"><div class="conversation_container">
			    <h2 class="conversation_headline">New conversation with '.ucfirst($purchaseProducts[0]->full_name).' from '.ucfirst($purchaseProducts[0]->shopname).'</h2>
    			<div class="conversation_thumb"><img width="75" height="75" src="'.$srcVal.'"></div>
				<div class="conversation_right">
				<form name="contactshopowener" id="contactshopowener" method="post" action="site/user/purchasecontactshopowner">
					<input class="conversation-subject" type="text" name="subject" placeholder="Subject" value="Re: Order #'.$purchaseProducts[0]->dealCodeNumber.' on '.$transactionon.'">
	    			<textarea class="conversation-textarea" rows="11" name="message_text" placeholder="Message text">Invoice: '.base_url().'view-order/'.$UserVal->row()->id.'/'.$purchaseProducts[0]->dealCodeNumber.'</textarea>
					
					<input type="hidden" name="username" id="username" value="'.$UserVal->row()->full_name.'" >
					<input type="hidden" name="useremail" id="useremail" value="'.$UserVal->row()->email.'" >
					<input type="hidden" name="userid" id="userid" value="'.$UserVal->row()->id.'" >
					<input type="hidden" name="selleremail" id="selleremail" value="'.$purchaseProducts[0]->seller_email.'" >
					<input type="hidden" name="sellerid" id="sellerid" value="'.$purchaseProducts[0]->sell_id.'" >
					<input type="hidden" name="dealcode_number" id="dealcode_number" value="'.$purchaseProducts[0]->dealCodeNumber.'" >
					<input type="hidden" name="subject_name" id="subject_name" value="New conversation with '.ucfirst($purchaseProducts[0]->full_name).' from '.ucfirst($purchaseProducts[0]->shopname).'">
					
    				<input class="subscribe_btn" type="submit" value="send" style="height: auto; padding: 7px 10px; margin: 10px 0 7px 20px; font-weight: bold;">
		</form>			
  				</div> 
    			</div>
			    </div>';
		echo $popupVal;		
		
		return;
	
	}
	
	public function purchasecontactshopowner(){
		$dataArr = array('username'=>$this->input->post('username'),'useremail'=>$this->input->post('useremail'),'user_id'=>$this->input->post('userid'),'selleremail'=>$this->input->post('selleremail'),'sellerid'=>$this->input->post('sellerid'),'dealcode_number'=>$this->input->post('dealcode_number'),'description'=>$this->input->post('message_text'));
		
		#echo "<pre>"; print_r($dataArr); die;
		
		$this->user_model->simple_insert(CONTACTSHOPSELLER,$dataArr);
		$dataArry = array('sender_email'=>$this->input->post('useremail'),'sender_id'=>$this->input->post('userid'),'receiver_email'=>$this->input->post('selleremail'),'receiver_id'=>$this->input->post('sellerid'),'subject'=>$this->input->post('subject'),'message'=>$this->input->post('message_text'),'dataAdded'=>date('Y-m-d H:i:s'));
		$this->user_model->simple_insert(CONTACTPEOPLE,$dataArry);
		
		$userid = $this->input->post('user_id');
		$dealcode_number = $this->input->post('dealcode_number');
		$userrname = $this->input->post('username');
		$description = $this->input->post('message_text');
		$email = $this->input->post('selleremail');
		
		$newsid='17';
		$template_values=$this->user_model->get_newsletter_template_details($newsid);
		
		$subject = 'From: '.$this->config->item('email_title').' - '.$template_values['news_subject'];
		$adminnewstemplateArr=array('email_title'=> $this->config->item('email_title'),'logo'=> $this->data['logo']);
		extract($adminnewstemplateArr);
		//$ddd =htmlentities($template_values['news_descrip'],null,'UTF-8');
		$header .="Content-Type: text/plain; charset=ISO-8859-1\r\n";
		
		$message .= '<!DOCTYPE HTML>
			<html>
			<head>
			<meta http-equiv="Content-Type" content="text/html; charset=utf-8">
			<meta name="viewport" content="width=device-width"/><body>';
		include('./newsletter/registeration'.$newsid.'.php');	
		
		$message .= '</body>
			</html>';
		
		if($template_values['sender_name']=='' && $template_values['sender_email']==''){
			$sender_email=$this->data['siteContactMail'];
			$sender_name=$this->data['siteTitle'];
		}else{
			$sender_name=$template_values['sender_name'];
			$sender_email=$template_values['sender_email'];
		}

		$email_values = array('mail_type'=>'html',
							'from_mail_id'=>$sender_email,
							'mail_name'=>$sender_name,
							'to_mail_id'=>$email,
							'subject_message'=>$template_values['news_subject'],
							'body_messages'=>$message
							);
		#echo '<pre>'; print_r($email_values); die;
		$email_send_to_common = $this->user_model->common_email_send($email_values);
		
		
		
		$this->setErrorMessage('success','Contact Shop Owner Mail Sent Successfully.');
		redirect('purchase-review');
			
	}
	
	/*Product Detail Page Contact Shop Owner*/
	public function prddetailaskQues(){
		
		$dataArr = array('username'=>$this->input->post('username'),'useremail'=>$this->input->post('useremail'),'user_id'=>$this->input->post('userid'),'selleremail'=>$this->input->post('selleremail'),'sellerid'=>$this->input->post('sellerid'),'product_id'=>$this->input->post('productid'),'product_name'=>$this->input->post('productname'),'description'=>$this->input->post('message_text'));
		$this->user_model->simple_insert(CONTACTSELLER,$dataArr);
		$dataArry = array('sender_email'=>$this->input->post('useremail'),'sender_id'=>$this->input->post('userid'),'receiver_email'=>$this->input->post('selleremail'),'receiver_id'=>$this->input->post('sellerid'),'subject'=>$this->input->post('subject'),'message'=>$this->input->post('message_text'),'dataAdded'=>date('Y-m-d H:i:s'));
		$this->user_model->simple_insert(CONTACTPEOPLE,$dataArry);
		
		
		$productName = $this->input->post('productname');
		$userrname = $this->input->post('username');
		$description = $this->input->post('message_text');
		$email = $this->input->post('selleremail');
		
		$newsid='15';
		$template_values=$this->user_model->get_newsletter_template_details($newsid);
		
		$subject = 'From: '.$this->config->item('email_title').' - '.$template_values['news_subject'];
		$adminnewstemplateArr=array('email_title'=> $this->config->item('email_title'),'logo'=> $this->data['logo']);
		extract($adminnewstemplateArr);
		//$ddd =htmlentities($template_values['news_descrip'],null,'UTF-8');
		$header .="Content-Type: text/plain; charset=ISO-8859-1\r\n";
		
		$message .= '<!DOCTYPE HTML>
			<html>
			<head>
			<meta http-equiv="Content-Type" content="text/html; charset=utf-8">
			<meta name="viewport" content="width=device-width"/><body>';
		include('./newsletter/registeration'.$newsid.'.php');	
		
		$message .= '</body>
			</html>';
		
		if($template_values['sender_name']=='' && $template_values['sender_email']==''){
			$sender_email=$this->data['siteContactMail'];
			$sender_name=$this->data['siteTitle'];
		}else{
			$sender_name=$template_values['sender_name'];
			$sender_email=$template_values['sender_email'];
		}

		$email_values = array('mail_type'=>'html',
							'from_mail_id'=>$sender_email,
							'mail_name'=>$sender_name,
							'to_mail_id'=>$email,
							'subject_message'=>$template_values['news_subject'],
							'body_messages'=>$message
							);
		//echo '<pre>'; print_r($email_values); die;
		$email_send_to_common = $this->user_model->common_email_send($email_values);
		
		
		
		$this->setErrorMessage('success','Contact Shop Owner Mail Sent Successfully.');
		redirect('products/'.$this->input->post('productseourl'));
			
	}
	/*************************** Contact Shop Owner Check product popup function  *************************************/
	
	public function makeReviewBox(){
	
		$userId = $this->input->post('userId'); 
		$product_id = $this->input->post('product_id'); 
		$dealCode=$this->input->post('dealCode'); 
		$review = $this->user_model->get_all_details(PRODUCT_FEEDBACK,array('voter_id'=>$userId,'seller_product_id'=>$product_id,'deal_code'=>$dealCode))->row();		
		
		$UserVal = $this->user_model->get_all_details(USERS,array('id'=>$userId));
		$ProdVal = $this->user_model->get_all_details(PRODUCT,array('id'=>$product_id));	
		
		
		if($UserVal->row()->thumbnail !=''){
			$revByImg = 'images/users/'.$UserVal->row()->thumbnail;
		}else{
			$revByImg = 'images/default_avat.png';
		}
		
		if($ProdVal->row()->image !=''){
			$img=explode(',',$ProdVal->row()->image);
			$prdImg = 'images/product/thumb/'.$img[0];
		}else{
			$prdImg = 'images/dummyProductImage.jpg';
		}
		if(empty($review)){				
		$popupVal=' 
				<div style="background:#EAF7FD; margin:0px" class="sign_in_form">
				<form action="'.base_url().'site/user/feedback" method="post" onSubmit="return rattingValidation();" >
				<input type="hidden" value="" name="mode" />
					<div style="border:none;" class="sign_in_form-inner">
						<div style="float:left; width:93%;" class="sign_head">
							<div class="sign_text">
							 <h2>Write a Review</h2>
							</div>
						</div>
						<div style="float:left; width:100%; background:#FFF;" class="sign-in-middle">
							<div style="float:left; width:20%" class="sign-in-middle-left">
								
								<img style="height:60px ;  margin: 21px 0 0 20px; width:60px" src="'.base_url().$prdImg.'" />
							</div>
							<div style="float:left; width:69%; padding:20px 0 0 0" class="sign-in-middle-right">
								<h3>'.$ProdVal->row()->product_name.'</h3>
								<!--<img src="'.base_url().'images/starrating.png" />-->
								<input type="radio" id="1" value="1" name="rating" style="display:none;">
								<label for="1" onClick="ratting_star(1)"  class="star-active" id="r1"></label>
								<input type="radio" id="2" value="3" name="rating" style="display:none;">
								<label for="2" onClick="ratting_star(2)" class="star-active" id="r2"></label>
								<input type="radio" id="3" value="3" name="rating" style="display:none;">
								<label for="3" onClick="ratting_star(3)"  class="star-active"  id="r3"></label>
								<input type="radio" id="4" value="4" name="rating" style="display:none;">
								<label for="4" onClick="ratting_star(4)" class="star-active" id="r4"></label>
								<input type="radio" id="5" value="5" name="rating" style="display:none;" checked="checked">
								<label for="5"  onclick="ratting_star(5)" class="star-active" id="r5"></label>
								<input type="hidden" value="'.$dealCode.'" name="deal_code" />
								<input type="hidden" value="'.$ProdVal->row()->id.'" name="product_id" />
								<input type="hidden" value="'.$ProdVal->row()->user_id.'" name="shop_id" />
								<input type="hidden" value="'.$UserVal->row()->id.'" name="user_id" />
								<textarea style="width:382px; margin:10px 0;" class="conversation-textarea" placeholder="Message text" name="description" rows="8" id="description"></textarea>
								<span id="descriptionErr" style="color:red;"></span><br>
								<img style="border-radius:60px; height:30px; width:30px" src="'.base_url().$revByImg.'" />
								<span style="color:#999; margin:0 3px 0 0">Reviewd by</span>
								<a href="'.base_url().'view-people/'.$UserVal->row()->user_name.'">'.ucfirst($UserVal->row()->full_name).'</a>
							</div>
						</div>
					</div>
					<div style="float:left; width:100%;  border-top:1px solid #77B3CD; " class="popup-page-footer">	
						<div class="popup_login" style="margin-bottom: 15px; margin-right: 15px; float: right; width: auto;">
							<input style="margin:0 10px 0 0" class="submit_btn" type="submit" value="Post your Review">
							<input class="submit_btn" type="button" value="Cancel" onClick="javascript:$(\'#cboxClose\').trigger(\'click\');">
						</div>
					</div>
				</form>
				</div>';
		}else{
			$ratting_value=round($review->rating);
			$RTT='';
			for($i=1;$i<=5;$i++){
				if($i<=$ratting_value){
					$RTT.='<input type="radio" id="'.$i.'" value="'.$i.'" name="rating" style="display:none;"';
					if($i==$ratting_value){
						$RTT.=' checked="checked"';
					}
					$RTT.='>
					<label for="'.$i.'" onclick="ratting_star('.$i.')"  class="star-active" id="r'.$i.'"></label>';
				}else{
					$RTT.='<input type="radio" id="'.$i.'" value="'.$i.'" name="rating" style="display:none;">
					<label for="'.$i.'" onClick="ratting_star('.$i.')"  class="star-inactive" id="r'.$i.'"></label>';
				}
			}
			$popupVal=' 
				<div style="background:#EAF7FD; margin:0px" class="sign_in_form">
				<form action="'.base_url().'site/user/feedback" method="post" onSubmit="return rattingValidation();" >
				<input type="hidden" value="'.$review->id.'" name="mode" />
					<div style="border:none;" class="sign_in_form-inner">
						<div style="float:left; width:93%;" class="sign_head">
							<div class="sign_text">
							 <h2>Edit Your Review</h2>
							</div>
						</div>
						<div style="float:left; width:100%; background:#FFF;" class="sign-in-middle">
							<div style="float:left; width:20%" class="sign-in-middle-left">
								
								<img style="height:60px ;  margin: 21px 0 0 20px; width:60px" src="'.base_url().$prdImg.'" />
							</div>
							<div style="float:left; width:69%; padding:20px 0 0 0" class="sign-in-middle-right">
								<h3>'.$ProdVal->row()->product_name.'</h3>
								<!--<img src="'.base_url().'images/starrating.png" />-->
								'.$RTT.'
								<input type="hidden" value="'.$dealCode.'" name="deal_code" />
								<input type="hidden" value="'.$ProdVal->row()->id.'" name="product_id" />
								<input type="hidden" value="'.$ProdVal->row()->user_id.'" name="shop_id" />
								<input type="hidden" value="'.$UserVal->row()->id.'" name="user_id" />
								<textarea style="width:382px; margin:10px 0;" class="conversation-textarea" placeholder="Message text" name="description" rows="8" id="description">'.$review->description.'</textarea>
								<span id="descriptionErr" style="color:red;"></span><br>
								<img style="border-radius:60px; height:30px; width:30px" src="'.base_url().$revByImg.'" />
								<span style="color:#999; margin:0 3px 0 0">Reviewd by</span>
								<a href="'.base_url().'view-order/'.$UserVal->row()->id.'">'.ucfirst($UserVal->row()->full_name).'</a>
							</div>
						</div>
					</div>
					<div style="float:left; width:100%;  border-top:1px solid #77B3CD; " class="popup-page-footer">	
						<div class="popup_login" style="margin-bottom: 15px; margin-right: 15px; float: right; width: auto;">
							<input style="margin:0 10px 0 0" class="submit_btn" type="submit" value="Post your Review">
							<input class="submit_btn" type="button" value="Cancel" onClick="javascript:$(\'#cboxClose\').trigger(\'click\');">
						</div>
					</div>
				</form>
				</div>';
		}
		echo $popupVal;		
		
		return;
	
	}	
	
	public function activity(){
		if ($this->checkLogin('U')!=''){		
			$this->data['currUser']=$checkloginIDarr=$this->session->all_userdata(); 
		 	$loggeduserID=$checkloginIDarr['shopsy_session_user_id'];
			/*Update the user last Visited Activity Time */
			$datestring = "%Y-%m-%d %H:%i:%s";
			$time = time();
			$newdata = array(
               'last_activity_visit' => mdate($datestring,$time),
            );
            $condition = array('id' => $loggeduserID);
			$this->user_model->update_details(USERS,$newdata,$condition);
			/*Get the  user details*/
			$this->data['userProfileDetails']=$userProfileDetails= $this->user_model->get_all_details(USERS,array('id'=>$loggeduserID))->result_array();
			$userList=explode(',',$userProfileDetails[0]['following']);
			$userList[0]=$loggeduserID;$condition='';
			foreach($userList as $userIds){
				/*$this->data['userDetails']->$userIds=$userDetails->$userIds= $this->user_model->get_all_details(USER,array('id'=>$userIds))->result();
				$this->data['userActivity'][$userIds]=$userActivity[$userIds]= $this->user_model->get_all_details(USER_ACTIVITY,array('user_id'=>$userIds),array('field'=>'activity_time','type'=>'desc'))->result_array();*/
				$condition.="ua.user_id = ".$userIds." or ";
			}
			$len=strlen($condition);
			$condition=substr($condition,0,$len-4);
			$this->data['userActivity']=$userActivity= $this->user_model->get_activity($condition)->result_array();
			$this->data['heading'] = $this->config->item('email_title').'-Your Activity';
			$this->load->view('site/user/activity',$this->data);
		}else{
			redirect('login');
		}
	}
	public function activity_interaction(){
		if ($this->checkLogin('U')!=''){		
			$this->data['currUser']=$checkloginIDarr=$this->session->all_userdata(); 
		 	$loggeduserID=$checkloginIDarr['shopsy_session_user_id'];			
			/*Get the  user details*/
			$this->data['userProfileDetails']=$userProfileDetails= $this->user_model->get_all_details(USERS,array('id'=>$loggeduserID))->result_array();
			$followersArr=explode(',',ltrim($userProfileDetails[0]['followers'],','));
			foreach($followersArr as $followersList){
				$this->data['userfollowersDetails'][$followersList]=$userfollowersDetails[$followersList]= $this->user_model->get_all_details(USERS,array('id'=>$followersList))->row();
			}
			$this->data['heading'] = $this->config->item('email_title').'-Your Activity';
			$this->load->view('site/user/activity_interaction',$this->data);
		}else{
			redirect('login');
		}
	}
	public function activity_shop(){
		if ($this->checkLogin('U')!=''){
			$this->data['currUser']=$checkloginIDarr=$this->session->all_userdata(); 
		 	$loggeduserID=$checkloginIDarr['shopsy_session_user_id'];			
			/*Get the  user details*/
			$this->data['userProfileDetails']=$userProfileDetails= $this->user_model->get_all_details(USERS,array('id'=>$loggeduserID))->result_array();
			/*get my shop products*/
			$myshopproductArr= $this->user_model->get_all_details(PRODUCT,array('user_id'=>$loggeduserID))->result_array();
			$prd='';
			foreach($myshopproductArr as $prdId){
				$prd.=$prdId['id'].',';
			}
			/*My Shop Activity*/
			$condition="ua.activity_id =".$loggeduserID." or FIND_IN_SET(ua.activity_id,'".rtrim($prd,',')."')";
			$this->data['myshopactivity']=$myshopactivity= $this->user_model->get_myshopactivity($condition)->result_array();
			
			$this->data['heading'] = $this->config->item('email_title').'-Your Shop Activity';
			$this->load->view('site/user/activity_shop',$this->data);
		}else{
			redirect('login');
		}
	}
	public function category(){
		$this->data['MainCategoriesLists'] = $this->user_model->get_all_details(CATEGORY,array('rootID'=>'0','status'=>'Active'),array(array('field'=>'cat_name','type'=>'asc')));
		$this->data['heading'] =$this->config->item('email_title').' - Browse Shopping Categories';
		$this->load->view('site/list/category',$this->data);
	}
	/* Contact People*/
	public function contactpeople(){
		
		$dataArr = array('sender_email'=>$this->input->post('sender_email'),'sender_id'=>$this->input->post('sender_id'),'receiver_email'=>$this->input->post('receiver_email'),'receiver_id'=>$this->input->post('receiver_id'),'subject'=>$this->input->post('subject'),'message'=>$this->input->post('message_text'),'dataAdded'=>date('Y-m-d H:i:s'));
		#echo "<pre>"; print_r($dataArr);die;
		$this->user_model->simple_insert(CONTACTPEOPLE,$dataArr);
		
		
		$this->setErrorMessage('success','Message Sent Successfully.');
		if($this->input->post('FromURL')=='ContactUser'){
			redirect('shops/'.$this->input->post('current_user').'/contact-user');
		}
		if($this->input->post('FromURL')=='Conversation'){
			redirect('people/'.$this->input->post('current_user').'/conversations');
		}
		redirect('view-people/'.$this->input->post('current_user'));
			
	}
	
	public function user_manageRegistryProduct(){
		if ($this->checkLogin('U')!=''){
			$userId=$this->input->post('userId');
			$prodId=$this->input->post('prodId');
			
			$registryProduct = $this->user_model->get_all_details(REGISTRY_LISTINGS,array('collection_id'=>$userId,'listing_id'=>$prodId))->result_array();
			if(empty($registryProduct)){
				$dataArr = array('collection_id'=>$userId,'listing_id'=>$prodId);
				$this->user_model->simple_insert(REGISTRY_LISTINGS,$dataArr);
			}else{
				$this->user_model->commonDelete(REGISTRY_LISTINGS,array('collection_id'=>$userId,'listing_id'=>$prodId));
			}
			$this->setErrorMessage('success','Your Registry has been updated');		
		}
	}	
		
	public function language_change(){
		$language_code= $this->uri->segment('2');
		$selectedLangCode = $this->session->set_userdata('language_code',$language_code);
		redirect('');
	}
	
	/*Coversation starts Here*/
	public function display_conversations(){
		if ($this->checkLogin('U')!=''){
			$this->data['heading'] =$this->config->item('email_title').' - Conversation';		
			#$this->data['conversations'] = $this->user_model->get_all_details(CONTACTPEOPLE,array('receiver_id'=>$this->checkLogin('U')),array(array('field'=>'dataAdded','type'=>'desc')));
			if(isset($_GET['qv'])){
			$typev= $_GET['qv'];
			}else{
			$typev= 'all';
			}
			$this->data['viewfolder'] =$typev;
			$this->data['conversations'] = $this->user_model->get_conversation_details($this->checkLogin('U'),$typev);
			#echo "<pre>"; print_r($this->data['conversations']);
			$this->load->view('site/user/conversation',$this->data);
		}else{
			$this->setErrorMessage('error','Login Required');	
			redirect('login');
		}
	}
	public function view_message(){
		if ($this->checkLogin('U')!=''){
			$msgid=$this->uri->segment(5,0);
			$this->data['viewfolder'] =$this->uri->segment(4,0);
			$this->data['MessageDetail'] = $this->user_model->get_message_details($msgid);
			if($this->data['MessageDetail']->row()->sender_id==$this->checkLogin('U')){
				$colstatus='sender_status';
			}else if($this->data['MessageDetail']->row()->receiver_id==$this->checkLogin('U')){
				$colstatus='receiver_status';
			}
			$newdata=array($colstatus=>'Read');
			$condition = array('id' => $this->data['MessageDetail']->row()->id);
			$this->user_model->update_details(CONTACTPEOPLE,$newdata,$condition);
			
			$this->data['heading'] =$this->config->item('email_title').' - Conversation';
			$this->load->view('site/user/view_conversation',$this->data);
		}else{
			$this->setErrorMessage('error','Login Required');	
			redirect('login');
		}
	}
	public function ajax_conversation_action(){
		$MsgId=$this->input->post('MsgId');
		$UsrId=$this->input->post('UsrId');
		$folder=$this->input->post('folder');
		$actionTake=$this->input->post('actionTake');
		$chkMsgArr=@explode('|',rtrim($MsgId,'|'));   
		$chgId='';
		foreach($chkMsgArr as $MsgId){
			$msgDetail = $this->user_model->get_all_details(CONTACTPEOPLE,array('id'=>$MsgId));
			if($msgDetail->row()->sender_id==$UsrId){
				$colstatus='sender_status';
			}else if($msgDetail->row()->receiver_id==$UsrId){
				$colstatus='receiver_status';
			}
			$newdata=array($colstatus=>$actionTake);
			$condition = array('id' => $MsgId);
			if($this->user_model->update_details(CONTACTPEOPLE,$newdata,$condition)){
				$chgId=$chgId.$MsgId.'|';  
			}
		}	
		echo rtrim($chgId,'|');	
	}
	
	public function ajax_activity(){
		if ($this->checkLogin('U')!=''){		
			$this->data['currUser']=$checkloginIDarr=$this->session->all_userdata(); 
		 	$loggeduserID=$checkloginIDarr['shopsy_session_user_id'];
			$datestring = "%Y-%m-%d %H:%i:%s";
			$time = time();
			$newdata = array(
               'last_activity_visit' => mdate($datestring,$time),
            );
            $condition = array('id' => $loggeduserID);
			$this->user_model->update_details(USERS,$newdata,$condition);
			$this->data['userProfileDetails']=$userProfileDetails= $this->user_model->get_all_details(USERS,array('id'=>$loggeduserID))->result_array();
			$userList=explode(',',$userProfileDetails[0]['following']);
			$userList[0]=$loggeduserID;$condition='';
			foreach($userList as $userIds){
				$condition.="ua.user_id = ".$userIds." or ";
			}
			$len=strlen($condition);
			$condition=substr($condition,0,$len-4);
			$offset = is_numeric($_POST['offset']) ? $_POST['offset'] : die();
			$postnumbers = is_numeric($_POST['number']) ? $_POST['number'] : die();
			$this->data['userActivity']=$userActivity= $this->user_model->get_activity($condition,$postnumbers,$offset)->result_array();
			$this->data['heading'] = $this->config->item('email_title').'-Your Activity';
			$loginCheck = $this->checkLogin('U');
			if(!empty($userActivity)){ 
         	$content ='<ul id="activity-list">';
                $hover=0; $s=0;$l=1; 
				foreach($userActivity as $actFav){ 
                if($s<3 && $l<4){ $cls="small"; $s++; } else if($s>2 && $l<4){ $cls="large"; $l++;} else {$s=0;$l=1;}
              
				$userProfileDetails= $this->user_model->get_all_details(USERS,array('id'=>$actFav['user_id']))->result_array();
				if($actFav['activity_name']=='Unfavorite item' || $actFav['activity_name']=='favorite item') { 
				$hover++;
					$productDetail = $this->user_model->get_all_details(PRODUCT,array('id'=>$actFav['activity_id']))->row();
					$imgArr=explode(',',$productDetail->image);
                     $content .='<li class="activity small-wid '.$cls.'">
                        <div class="activity-desc">
                            <div class="activity-avatar trigger-action-toolbox" data-source="hp_tastemaker">
                                <a href="view-profile/'.$userProfileDetails[0]['user_name'].'" >';
                                	if($userProfileDetails[0]['thumbnail']!=''){ $profile_pic='users/thumb/'.$userProfileDetails[0]['thumbnail']; } else { $profile_pic='default_avat.png';}
                                    $content .='<img width="75" height="75" src="images/'.$profile_pic.'">
                                </a>
                            </div>
                            <p class="activity-name">';
                               if($userProfileDetails[0]['id']!=$loginCheck){ $content .= $userProfileDetails[0]['user_name']; } else { $content .= 'You';} 
                               		if($this->lang->line('favorited') != '') { $content .= stripslashes($this->lang->line('favorited')); } else {$content .= "favorited";}
                               $content .='<a class="member-name" href="products/'.$productDetail->seourl.'">'; 
							   if($this->lang->line('user_thisitem') != '') { $content .=stripslashes($this->lang->line('user_thisitem')); } else $content .='"this item"';
                               $content .='..</a>';
                            $content .='</p>
                        </div>
                        <div class="activity-favorites  full-wid">
                            <a href="products/'.$productDetail->seourl.'" class="activity-full">
                                <img alt="'.$productDetail->product_name.'" src="images/product/'.$imgArr[0].'">
                            </a>
                        </div>
                        <div class="story-info clear">
                            <div class="product-dtl">'.$productDetail->product_name.'</div>
                            <div class="product_fv">';
                            		 if($loginCheck !=''){
                                        $favArr = $this->product_model->getUserFavoriteProductDetails($productDetail->id);
                                        if(empty($favArr)){ 
                                       $content .='<a href="javascript:void(0);" onClick="return changeProductToFavourite(\''.$productDetail->id.'\',\'Fresh\');">
                                            <input type="submit" value="" class="hoverfav_icon" />
                                        </a>';
                                        } else {                       
                                        $content .='<a href="javascript:void(0);" onClick="return changeProductToFavourite(\''.$productDetail->id.'\',\'Old\');">
                                            <input type="submit" value="" class="hoverfav_icon1" />
                                        </a>';
                                        }} else {
                                        $content .='<a href="login" class="reg-popup" >
                                            <input type="submit" value="" class="hoverfav_icon" />
                                        </a>';
                                 }  
                                $content .='<div class="hoverdrop2_icon">
                                    <a href="javascript:hoverView(\''.$hover.'\');">
                                        <div class="hover_lists" id="hoverlist'.$hover.'">
                                            <h2>Your Lists</h2> 
                                            <div class="lists_check">';                                            
											foreach($this->data['userLists'] as $Lists){ 
                                            $haveListIn = $this->user_model->check_list_products(stripslashes($productDetail->id),$Lists['id'])->num_rows();
                                            if($haveListIn>0){$chk='checked="checked"';}else{ $chk='';}
                                            
                                            $content .='<input type="checkbox" class="check_box" onClick="return addproducttoList(\''.$Lists['id'].'\',\''.$productDetail->id.'\');" '.$chk.'/>';
                                            $content .='<label>'.$Lists['name'].'</label>';
                                            } 
                                            $content .='</div>                                                    
                                            <div class="new_list">
                                                <form method="post" action="site/user/add_list">
                                                    <input type="hidden" value="1" name="ddl" />
                                                    <input type="hidden" value="'.$productDetail->id.'" name="productId" />
                                                    <input type="text" placeholder="';
													if($this->lang->line('user_new_list') != '') { 
													$content .=stripslashes($this->lang->line('user_new_list')); 
													} else {
													$content .='New list';}
													$content .='" class="list_scroll" name="list" id="creat_list_'.$hover.'" />
                                                    <input type="submit" value="';
													if($this->lang->line("user_add") != "") { 
													$content .=stripslashes($this->lang->line('user_add')); 
													} else{ $content .='Add'; }
													$content .='" class="primary-button" onclick="return validate_create_list(\''.$hover.'\');" />
                                                </form>
                                            </div>   
                                        </div>
                                    </a>
                                </div>
                            </div>	
                        </div>
                    </li> ';
                }else if($actFav['activity_name']=='Unfavorite shop' || $actFav['activity_name']=='favorite shop') {                  
                 
					$shopproductDetail = $this->user_model->getfavshops_activity($actFav['activity_id'])->result_array();
				
                $content .='<li class="activity '.$cls.'">
                    <div class="activity-desc">
                        <div class="activity-avatar trigger-action-toolbox" data-source="hp_tastemaker">
                            <a href="view-profile/'.$userProfileDetails[0]['user_name'].'" >';
                                	if($userProfileDetails[0]['thumbnail']!=''){ $profile_pic='users/thumb/'.$userProfileDetails[0]['thumbnail']; } else { $profile_pic='default_avat.png';}
                                    $content .='<img width="75" height="75" src="images/'.$profile_pic.'">
                                </a>
                        </div>
                        <p class="activity-name">';
                            if($userProfileDetails[0]['id']!=$loginCheck){ $content .=$userProfileDetails[0]['user_name']; } else { if($this->lang->line('user_you')!='') { $content .= stripslashes($this->lang->line('user_you')); } else $content .="You"; } 
							if($this->lang->line('favorited') != '') { $content .= stripslashes($this->lang->line('favorited')); } else $content .="favorited"; 
							$content .='<a class="member-name" href="shop-section/'.$shopproductDetail[0]['shopurl'].'">'; 
							if($this->lang->line('user_thisshop') != '') { 
							$content .= stripslashes($this->lang->line('user_thisshop')); } else $content .= "this shop"; 
							$content .='</a> 
                        </p>
                    </div>
                    <div class="activity-favorites">';
                    	if(count($shopproductDetail)<4){$count=count($shopproductDetail); } else{ $count=4; } for($i=0;$i<$count;$i++){ 
                            $content .='<a href="shop-section/'.$shopproductDetail[0]['shopurl'].'" class="favorite">';
                            	$imgArr=explode(',',$shopproductDetail[$i]['image']); 
                                $content .='<img  width="170" height="135" alt="'.$shopproductDetail[$i]['product_name'].'" src="images/product/'.$imgArr[0].'">
                            </a> ';                       
                         } 
                        if($count!=4) {for($j=4-$count;$j<$count;$j++){ 
                           $content .=' <a class="favorite">
                            </a>       ';                 
                         } } 
                    $content .='</div>
                    <div class="activity-link clear">
                        <div class="activeright">
                            <span class="newimages"></span>
                            <p class="line-type">';
                            	if($this->lang->line('shop') != '') { $content .= stripslashes($this->lang->line('shop')); } else $content .= "SHOP"; 
                            $content .='</p>
                            <p><a class="name_line" href="shop-section/'.$shopproductDetail[0]['shopurl'].'">'.$shopproductDetail[0]['shopname'].'</a></p>
                        </div>';
                        if($loginCheck !=''){
                        $favArr = $this->product_model->getUserFavoriteShopDetails($actFav['activity_id']);
                        if(empty($favArr)){ 
                        $content .='<a href="javascript:void(0);" onClick="return changeShopToFavourite(\''.$actFav['activity_id'].'\',\'Fresh\');">
						<input type="submit" value="" class="hoverfav_icon">
                        </a>';
                          } else { 
                        $content .='<a href="javascript:void(0);" onClick="return changeShopToFavourite(\''.$actFav['activity_id'].'\',\'Old\');">
                        <input type="submit" value="" class="hoverfav_icon1">
                        </a>';
                        }} else { 
                        $content .='<input type="submit" value="" class="hoverfav_icon">';
                          }
                    $content .='</div>
                </li>';
                 } }
                $content .='</ul>';
                 } else { 
                $content ='';
                 }
		 echo $content;}else{
			redirect('login');
		}		
	}
	
	public function ajax_activity_shop(){
		if ($this->checkLogin('U')!=''){
		$loginCheck = $this->checkLogin('U');
			$this->data['currUser']=$checkloginIDarr=$this->session->all_userdata(); 
		 	$loggeduserID=$checkloginIDarr['shopsy_session_user_id'];	
			$this->data['userProfileDetails']=$userProfileDetails= $this->user_model->get_all_details(USERS,array('id'=>$loggeduserID))->result_array();
			$myshopproductArr= $this->user_model->get_all_details(PRODUCT,array('user_id'=>$loggeduserID))->result_array();
			$prd='';
			foreach($myshopproductArr as $prdId){
				$prd.=$prdId['id'].',';
			}
			$condition="ua.activity_id =".$loggeduserID." or FIND_IN_SET(ua.activity_id,'".rtrim($prd,',')."')";
			$offset = is_numeric($_POST['offset']) ? $_POST['offset'] : die();
			$postnumbers = is_numeric($_POST['number']) ? $_POST['number'] : die();
			$this->data['myshopactivity']=$myshopactivity= $this->user_model->get_myshopactivity($condition,$postnumbers,$offset)->result_array();
			
			$this->data['heading'] = $this->config->item('email_title').'-Your Shop Activity';
			if(!empty($myshopactivity)){   
                $content ='<ul id="activity-list">';
                $hover=0; $s=0;$l=1; foreach($myshopactivity as $actFav){ 
                 if($s<3 && $l<4){ $cls="small"; $s++; } else if($s>2 && $l<4){ $cls="large"; $l++;} else {$s=0;$l=1;}
				$userProfileDetails= $this->user_model->get_all_details(USERS,array('id'=>$actFav['user_id']))->result_array();
				if($actFav['activity_name']=='Unfavorite item' || $actFav['activity_name']=='favorite item') { 
				$hover++;
					$productDetail = $this->user_model->get_all_details(PRODUCT,array('id'=>$actFav['activity_id']))->row();
					$imgArr=explode(',',$productDetail->image);
                    $content .='<li class="activity small-wid '.$cls.'">
                        <div class="activity-desc">
                            <div class="activity-avatar trigger-action-toolbox" data-source="hp_tastemaker">
                                <a href="view-profile/'.$userProfileDetails[0]['user_name'].'" >';
                                	if($userProfileDetails[0]['thumbnail']!=''){ $profile_pic='users/thumb/'.$userProfileDetails[0]['thumbnail']; } else { $profile_pic='default_avat.png';}
                                    $content .='<img width="75" height="75" src="images/'.$profile_pic.'">
                                </a>
                            </div>
                            <p class="activity-name">';
                               if($userProfileDetails[0]['id']!=$loginCheck){ $content .= $userProfileDetails[0]['user_name']; } else { $content .= 'You';}
                               		if($this->lang->line('favorited') != '') { $content .= stripslashes($this->lang->line('favorited')); } else $content .= "favorited"; 
                               $content .='<a class="member-name" href="products/'.$productDetail->seourl.'"> your item..</a>
                            </p>
                        </div>
                        <div class="activity-favorites  full-wid">
                            <a href="products/'.$productDetail->seourl.'" class="activity-full">
                                <img alt="'.$productDetail->product_name.'" src="images/product/'.$imgArr[0].'">
                            </a>
                        </div>
                        <div class="story-info clear">
                            <div class="product-dtl">'.$productDetail->product_name.'</div>
                            <div class="product_fv">';
                            	if($loginCheck !=''){
                                        $favArr = $this->product_model->getUserFavoriteProductDetails($productDetail->id);
                                        if(empty($favArr)){ 
                                        $content .='<a href="javascript:void(0);" onClick="return changeProductToFavourite(\''.$productDetail->id.'\',\'Fresh\');">
                                            <input type="submit" value="" class="hoverfav_icon" />
                                        </a>';
                                        } else {   
                                        $content .='<a href="javascript:void(0);" onClick="return changeProductToFavourite(\''.$productDetail->id.'\',\'Old\');">
                                            <input type="submit" value="" class="hoverfav_icon1" />
                                        </a>';
                                        }} else {
                                        $content .='<a href="login" class="reg-popup" >
                                            <input type="submit" value="" class="hoverfav_icon" />
                                        </a>';
                                } 
                                $content .='<div class="hoverdrop2_icon">
                                    <a href="javascript:hoverView('.$hover.');">
                                        <div class="hover_lists" id="hoverlist'.$hover.'">
                                            <h2>';
											if($this->lang->line('user_your_lists') != '') { $content .= stripslashes($this->lang->line('user_your_lists')); } else $content .= "Your Lists"; $content .='</h2> 
                                            <div class="lists_check">';
                                            foreach($this->data['userLists'] as $Lists){ 
                                            $haveListIn = $this->user_model->check_list_products(stripslashes($productDetail->id),$Lists['id'])->num_rows();
                                            if($haveListIn>0){$chk='checked="checked"';}else{ $chk='';}
                                            
                                            $content .='<input type="checkbox" class="check_box" onClick="return addproducttoList(\''.$Lists['id'].'\',\''.$productDetail->id.'\');" '.$chk.'/>
                                            <label>'.$Lists["name"].'</label>';
                                             } 
                                            $content .='</div>                                                    
                                            <div class="new_list">
                                                <form method="post" action="site/user/add_list">
                                                    <input type="hidden" value="1" name="ddl" />
                                                    <input type="hidden" value="'.$productDetail->id.'" name="productId" />
                                                    <input type="text" placeholder="';if($this->lang->line('user_new_list') != '') { $content .= stripslashes($this->lang->line('user_new_list')); } else $content .= 'New list';$content .='" class="list_scroll" name="list" id="creat_list_'.$hover.'" />
                                                    <input type="submit" value="';if($this->lang->line('user_add') != '') { $content .= stripslashes($this->lang->line('user_add')); } else $content .= 'Add'; $content .='" class="primary-button" onClick="return validate_create_list(\''.$hover.'\');" />
                                                </form>
                                            </div>   
                                        </div>
                                    </a>
                                </div>
                            </div>	
                        </div>
                    </li> ';
                 }else if($actFav['activity_name']=='Unfavorite shop' || $actFav['activity_name']=='favorite shop') {  
					$shopproductDetail = $this->user_model->getfavshops_activity($actFav['activity_id'])->result_array();
               $content .=' <li class="activity '.$cls.'">
                    <div class="activity-desc">
                        <div class="activity-avatar trigger-action-toolbox" data-source="hp_tastemaker">
                            <a href="view-profile/'.$userProfileDetails[0]['user_name'].'" >';
                             if($userProfileDetails[0]['thumbnail']!=''){ $profile_pic='users/thumb/'.$userProfileDetails[0]['thumbnail']; } else { $profile_pic='default_avat.png';}
                                   $content .=' <img width="75" height="75" src="images/'.$profile_pic.'">
                                </a>
                        </div>
                        <p class="activity-name">';
                            if($userProfileDetails[0]['id']!=$loginCheck){ $content .= $userProfileDetails[0]['user_name']; } else { $content .= 'You';} 
                            	if($this->lang->line('favorited') != '') { $content .= stripslashes($this->lang->line('favorited')); } else $content .= "favorited"; 
                            $content .='<a class="member-name" href="shop-section/'.$shopproductDetail[0]['shopurl'].'"> your shop.</a> 
                        </p>
                    </div>
                    <div class="activity-favorites">';
                    	if(count($shopproductDetail)<4){$count=count($shopproductDetail); } else{ $count=4; } for($i=0;$i<$count;$i++){ 
                           $content .=' <a href="shop-section/'.$shopproductDetail[0]['shopurl'].'" class="favorite">';
                            	$imgArr=explode(',',$shopproductDetail[$i]['image']); 
                                $content .='<img  width="170" height="135" alt="'.$shopproductDetail[$i]['product_name'].'" src="images/product/'.$imgArr[0].'">
                            </a>   ';                     
                        } 
                        if($count!=4) {for($j=4-$count;$j<$count;$j++){ 
                            $content .='<a class="favorite">
                            </a>        ';                
                         } } 
                    $content .='</div>
                    <div class="activity-link clear">
                        <div class="activeright">
                            <span class="newimages"></span>
                            <p class="line-type">';
								if($this->lang->line('shop') != '') { $content .= stripslashes($this->lang->line('shop')); } else $content .= "SHOP"; 
                           $content .=' </p>
                            <p><a class="name_line" href="shop-section/'.$shopproductDetail[0]['shopurl'].'">'.$shopproductDetail[0]['shopname'].'</a></p>
                        </div>';
                        if($loginCheck !=''){
                        $favArr = $this->product_model->getUserFavoriteShopDetails($actFav['activity_id']);
                        if(empty($favArr)){ 
                        $content .='<a href="javascript:void(0);" onClick="return changeShopToFavourite(\''.$actFav['activity_id'].'\',\'Fresh\');">
						<input type="submit" value="" class="hoverfav_icon">
                        </a>';
                         } else { 
                        $content .='<a href="javascript:void(0);" onClick="return changeShopToFavourite(\''.$actFav['activity_id'].'\',\'Old\');">
                        <input type="submit" value="" class="hoverfav_icon1">
                        </a>';
                        }} else { 
                        $content .='<input type="submit" value="" class="hoverfav_icon">';
                         } 
                    $content .='</div>
                </li>';
                 } }
                $content .='</ul>     ';
                }else { 
               $content ='';
                 } 
				 echo $content;
		}else{
			redirect('login');
		}
	}
	
	public function ajax_people_favorite_list_itemsilove(){
		$loginCheck = $this->checkLogin('U');
			$this->data['currUser']=$checkloginIDarr=$this->session->all_userdata(); 
		 	$this->data['loggeduserID']=$loggeduserID=$checkloginIDarr['shopsy_session_user_id'];
			$username =  urldecode($this->uri->segment(4,0));
			$userDetails= $this->user_model->get_all_details(USERS,array('user_name'=>$username))->result_array();
			$userDetails[0]['id'];
				$condition='';
				if($_GET['a']){
					$search_key=$_GET['a'];
					$condition="p.product_name LIKE '%".$search_key."%' and";
				}	
				if($_GET['filter']){
					$condition="p.status='Publish' and p.quantity>2 and";
				}
			$this->data['userProfileDetails']=$userProfileDetails = $this->user_model->get_all_details(USERS,array('id'=>$userDetails[0]['id'],'status'=>'Active'))->result_array();			
			$offset = is_numeric($_POST['offset']) ? $_POST['offset'] : die();
			$postnumbers = is_numeric($_POST['number']) ? $_POST['number'] : die();
			$this->data['userFavoriteItems']=$userFavoriteItems = $this->product_model->getFavoriteProduct($userDetails[0]['id'],$condition,$postnumbers,$offset)->result_array();
			$i=1;  foreach($userFavoriteItems as $products){ $img=explode(',',$products['image']);
                        	$content .='<li>
                            	<div class="product_img">
                                	<div class="product_hide">
                                    	<div class="product_fav">';
                                            if($loginCheck !=''){
											$favArr = $this->product_model->getUserFavoriteProductDetails(stripslashes($products['id']));
											if(empty($favArr)){ 
		$content .='<a href="javascript:void(0);" onClick="return changeProductToFavourite(\''.stripslashes($products['id']).'\',\'Fresh\');">
												<input type="submit" value="" class="hoverfav_icon" />
											</a>';
											} else { 
	$content .='<a href="javascript:void(0);" onClick="return changeProductToFavourite(\''.stripslashes($products['id']).'\',\'Old\');">
												<input type="submit" value="" class="hoverfav_icon1" />
											</a>';
											}} else {
											$content .='<a href="login"  >
												<input type="submit" value="" class="hoverfav_icon" />
											</a>';
											 } 
	$content .='<div class="hoverdrop_icon">
                                    		<a href="javascript:hoverView('.$i.');">  </a>
                                        	<div class="hover_lists" id="hoverlist'.$i.'">
                                               	<h2>';
												if($this->lang->line('user_your_lists') != '') { $content .=stripslashes($this->lang->line('user_your_lists')); } else $content .= 'Your Lists'; $content .='</h2>
                                                <div class="lists_check">';
                                                	foreach($this->data['userLists'] as $Lists){ 
													$haveListIn = $this->user_model->check_list_products(stripslashes($products['id']),$Lists['id'])->num_rows();
													if($haveListIn>0){$chk='checked="checked"';}else{ $chk='';}
                                                     $content .='<input type="checkbox" class="check_box" onClick="return addproducttoList(\''.$Lists['id'].'\',\''.stripslashes($products['id']).'\');" '.$chk.' />
                                                    <label>'.$Lists['name'].'</label>';
                                                    }
                                                    if(!empty($userRegistry)){ 
														$haveRegisryIn = $this->user_model->check_registry_products($products['id'],$userRegistry->user_id)->num_rows();
														if($haveRegisryIn>0){$chk='checked="checked"';}else{ $chk='';}
													 $content .='<input type="checkbox" class="check_box" onClick="return manageRegisrtyProduct(\''.$userRegistry->user_id.'\',\''.$products['id'].'\');" '.$chk.' />
													<label><span class="registry_icon"></span>';
													if($this->lang->line('prod_wedding') != '') {  $content .= stripslashes($this->lang->line('prod_wedding')); } else  $content .= 'Wedding Registry';  $content .='</label>';
													 }  
                                                     $content .='</div>                                                    
                                                    <div class="new_list">
                                                    <form method="post" action="site/user/add_list">
                                                        <input type="hidden" value="1" name="ddl" />
                                                        <input type="hidden" value="'.$products['id'].'" name="productId" />
                                                        <input type="text" placeholder="';if($this->lang->line('user_new_list') != '') {  $content .= stripslashes($this->lang->line('user_new_list')); } else  $content .= 'New list';  $content .='" class="list_scroll" name="list" id="creat_list_'.$i.'" />
                                                        <input type="submit" value="';if($this->lang->line('user_add') != '') {  $content .= stripslashes($this->lang->line('user_add')); } else  $content .= 'Add';  $content .='" class="primary-button" onClick="return validate_create_list(\''.$i.'\');" />
                                                    </form>
                                                </div>
                                        	</div>
                                    	
                                   	</div>
                                        </div>
                                    </div>
                                    <a href="products/'.$products['seourl'].'">
                                    <img src="images/product/'.$img[0].'" alt="Product-1" title="Product-1" />
                                    </a>
                                </div>
                                <div class="product_title"><a href="products/'.$products['seourl'].'">'.$products['product_name'].'</a></div>
                                <div class="product_maker"><a href="shop-section/'.$products['seller_seourl'].'">'.$products['seller_businessname'].'</a></div>
                                <div class="product_price">';
                                if($products['price'] != 0.00) {
                                $content .=' <span class="currency_value">'.$this->data['currencySymbol'].' '.number_format($this->data['currencyValue']*$products['price'],2).'</span>
                                <span class="currency_code">';
                                	#if($this->lang->line('user_usd') != '') {  $content .= stripslashes($this->lang->line('user_usd')); } else  $content .= "USD"; 
                                $content .=$this->data['currencyType'].' </span>';
                                } else { 
                                 $content .='<span class="currency_value">'.$this->data['currencySymbol'].' '.number_format($this->data['currencyValue']*$products['pricing'],2).'+'.'</span>
                                <span class="currency_code">';
                                 #if($this->lang->line('user_usd') != '') {  $content .= stripslashes($this->lang->line('user_usd')); } else  $content .= "USD"; 
                                 $content .=$this->data['currencyType'].'</span>';
                                 }
                                 $content .='</div>
                            </li>';
                             $i++;  }
							 echo $content;
			
		
	}
	
}

/* End of file user.php */
/* Location: ./application/controllers/site/user.php */