<?php  if ( ! defined('BASEPATH')) exit('No direct script access allowed');
/*
| -------------------------------------------------------------------------
| URI ROUTING
| -------------------------------------------------------------------------
| This file lets you re-map URI requests to specific controller functions.
|
| Typically there is a one-to-one relationship between a URL string
| and its corresponding controller class/method. The segments in a
| URL normally follow this pattern:
|
|	example.com/class/method/id/
|
| In some instances, however, you may want to remap this relationship
| so that a different class/function is called than the one
| corresponding to the URL.
|

| Please see the user guide for complete details:
|
|	http://codeigniter.com/user_guide/general/routing.html
|
| -------------------------------------------------------------------------
| RESERVED ROUTES
| -------------------------------------------------------------------------
|
| There area two reserved routes:
|
|	$route['default_controller'] = 'welcome';
|
| This route indicates which controller class should be loaded if the
| URI contains no data. In the above example, the "welcome" class
| would be loaded.
|
|	$route['404_override'] = 'errors/page_missing';
|
| This route will tell the Router what URI segments to use if those provided
| in the URL cannot be matched to a valid route.
|
*/

$route['default_controller'] = "site/landing";
$route['404_override'] = '';

$route['admin'] = "admin/adminlogin";
$route['signup'] = "site/user/signup_form";
$route['login'] = "site/user/signup_form";
$route['register'] = "site/user/register_form";
$route['logout'] = "site/user/logout_user";
$route['forgot-password'] = "site/user/forgot_password_form";
$route['reopen-account'] = "site/user/reopen_account";
$route['settings-password'] = "site/user_settings/password_settings";
$route['friends'] = "site/user/find_friends";
$route['lang/(:any)'] = "site/user/language_change/$1";
/****************Cart and Checkout routes start**********************/
$route['cart'] = "site/cart";
$route['checkout/(:any)'] = "site/checkout";
$route['order/(:any)'] = "site/order";
$route['gift-cards'] = "site/giftcard";
$route['gift-cards/(:any)'] = "site/giftcard/edit/$1";
/*****************Cart and Checkout routes end*******************/

/***************** Order View Routes Start *******************/
$route['view-purchase/(:any)'] = "site/user/view_purchase"; 
$route['view-seller-purchase/(:any)'] = "site/user/view_seller_purchase"; 
$route['view-order/(:any)'] = "site/user/view_order";
$route['view-seller-order/(:any)'] = "site/user/view_seller_order";
$route['order-review/(:num)/(:num)/(:any)'] = "site/user/order_review"; 
$route['order-seller-review/(:num)/(:num)/(:any)'] = "site/user/order_seller_review"; 
$route['order-review/(:num)'] = "admin/order/order_review";
/***************** Order View Routes Start *******************/

/****************** Community Routes Start*************************/

$route['community'] = "site/community/community_home";

$route['pages/(:any)'] = "site/cms";
$route['events'] = "site/community/events_list";
$route['add-event'] = "site/community/useraddEvent";
$route['edit-event/(:any)'] = "site/community/useraddEvent";
$route['manage-events'] ="site/community/eventmanageview";

$route['teams'] = "site/community/teams_list"; 
$route['team-members/(:any)'] = "site/community/team_members"; 
$route['teams-search/(:any)'] = "site/community/teams_searchlist"; 
$route['team/(:any)'] = "site/community/team_detail"; 
$route['add-team'] = "site/community/add_team_form";
$route['edit-team/(:any)'] = "site/community/add_team_form";
$route['discuss/(:any)'] = "site/community/discussionDetails";
$route['create-thread/(:any)'] = "site/community/teamaddnewthread";
$route['join-team/(:any)'] = "site/community/joinTeam";
$route['leave-team/(:any)'] = "site/community/leaveTeam";
$route['manage-teams'] ="site/community/teammanageview";
$route['manage-discussions'] ="site/community/teamdiscussionview";
$route['manage-discussions-thread/(:any)'] ="site/community/teamdiscussionThreadview";
$route['discussions/(:any)'] = "site/community/team_discussions"; 

$route['manage-community'] ="site/community/blogpostview";
$route['community-new-post'] ="site/community/blogaddpost";
$route['community-post-comments'] ="site/community/blogcommentsview";
$route['community-newslist'] ="site/community/userBlogPage";
$route['(:any)/news-details'] ="site/community/userPostComments";

/****************** Community Routes End*************************/


/****************product routes start**********************/
$route['products/(:any)'] = "site/product/display_product_detail/$1"; 
$route['product/(:any)/favoriters'] = "site/product/display_product_favoriters/$1";
$route['add-product'] = "site/product/add_shop_product";
$route['edit-product/(:any)'] = "site/product/edit_shop_items/$1"; 
$route['admin-edit-product/(:any)'] = "site/product/edit_shop_items/$1"; 
$route['category-list/(:any)'] = "site/product/load_category_Listpage/$1";
$route['browse/(:any)'] = "site/product/load_product_Listpage/$1";
$route['search/(:any)'] = "site/product/search_product/$1";
$route['find/(:any)'] = "site/search/find";
$route['preview/(:any)'] = "site/shop/Preview/$1";   
$route['admin-preview/(:any)'] = "site/shop/Preview/$1";   
$route['currency'] = "site/user_settings/change_currency"; 

//$route['sizeby/(:any)'] = "site/searchShop/search_sizeby/$1";

/*****************product routes end*******************

/*****************people routes start*******************/
$route['settings/giftcards'] = "site/user_settings/user_giftcards";
$route['people/(:any)/favorites']="site/user/people_favorite_list";
$route['people/(:any)/favorites/items-i-love']="site/user/people_favorite_list_itemsilove";
$route['people/(:any)/favorites/list/(:any)']="site/user/people_list_items";
$route['people/(:any)/favorites/(:any)']="site/user/people_favorite_shoplist";
$route['people/(:any)/following']="site/user/display_user_following";
$route['people/(:any)/followers']="site/user/display_user_followers";
$route['people/(:any)/conversations']="site/user/display_conversations";
$route['people/(:any)/conversations/(:any)/(:any)']="site/user/view_message";
$route['view-people/(:any)']="site/user/view_people/$1";
$route['activity']="site/user/activity";
$route['activity/shop']="site/user/activity_shop";
$route['activity/interaction']="site/user/activity_interaction";
$route['category']="site/user/category";
$route['verify']="site/user/verify_user_email";
/*****************people routes end*******************/

/****************** Seller Start*************************/

//$route['shop/(:any)/(:any)'] = "site/seller/seller_product_view/$1";
$route['your-shop'] = "site/shop/open_new_shop/";
$route['shop/(:any)'] = "site/shop/load_shop_open/$1";
$route['appearance/(:any)/(:any)']="site/shop/load_info_appearance";
$route['policies/(:any)/(:any)']="site/shop/load_shop_policies";
$route['shops/(:any)/profile']="site/shop/load_shopowner_profile";
$route['shops/(:any)/sections/(:any)']="site/shop/load_shop_sections";
$route['shops/(:any)/Preview/(:any)']="site/shop/load_shop_preview/$1/$2";
$route['shops/(:any)/favoriters']="site/shop/display_shop_favoriters/$1";
$route['promote-shop']="site/shop/promote_shop";
$route['shops/(:any)/coupon-code']="site/shop/display_couponcards";
$route['shops/(:any)/add-coupon-code']="site/shop/add_couponcard";
$route['shops/(:any)/edit-coupon-code/(:any)']="site/shop/edit_couponcard/$2";
$route['shops/(:any)/contact-user']="site/shop/display_contact_user";
$route['shops/(:any)/view-contact-user/(:any)']="site/shop/view_contact_user";
$route['shops/(:any)/replay-contact-user/(:any)']="site/shop/replay_contact_user";
$route['shops/(:any)/delete-contact-user/(:any)']="site/shop/delete_contact_user";
$route['shops/(:any)/shop-transaction']="site/shop/display_shop_transaction";
/*$route['shops/(:any)/view-transaction/(:any)']="site/shop/view_shop_transaction";*/
$route['shops/(:any)/view-transaction/(:any)']="site/shop/view_shop_transaction";
$route['shops/(:any)/shop-orders']="site/shop/display_shop_orders";
$route['shops/(:any)/view-orders/(:any)']="site/shop/view_shop_orders";
$route['discussion/(:any)']="site/order/discussion/$1";
/****************** Seller End*************************/


/****************** Blog Routes Start******************************************************************************/
$route['view-blog'] ="blog/blog_controller/userCommonBlog";
$route['blog-all-post'] ="blog/blog_controller/blogpostview";
$route['blog-unpublished'] ="blog/blog_controller/blogunpublishview";
$route['blog-published'] ="blog/blog_controller/blogpublishview";
$route['blog-comments'] ="blog/blog_controller/blogcommentsview";
$route['blog-new-post'] ="blog/blog_controller/blogaddpost";
$route['blog-edit-post'] ="blog/blog_controller/blogeditpost";
$route['blog-drafts'] ="blog/blog_controller/blogdraftview";
$route['blog-setup'] ="blog/blog_controller/blogsetup";
$route['store-blog-page'] ="blog/blog_controller/userBlogPage";
$route['store-blog-page/(:any)'] ="blog/blog_controller/userBlogPage";
$route['store-blog-archive/(:any)'] ="blog/blog_controller/userArchivePage";
$route['(:any)/store-post-comments'] ="blog/blog_controller/userPostComments";
$route['(:any)/store-post-comments/(:any)'] ="blog/blog_controller/userPostComments/$1";
$route['send-confirm-mail'] ="site/user/send_register_mail";
$route['settings/my-account/(:any)']="site/user/display_user_profile/$1";
$route['public-profile']="site/user/public_profile";
$route['view-profile/(:any)']="site/user/view_people/$1";
$route['prototypes']="site/user/prototypes";
$route['home']="site/user/after_login";
$route['purchase-review']="site/user/purchase_review";
$route['purchases/(:any)']="site/user/purchase_review/$1";
$route['delete-order/(:any)']='site/user/remove_order/$1';
$route['settings/account-preferences']="site/user_settings/account_preferences";
$route['update-preferences']="site/user_settings/update_preference_settings";
$route['update_privacy']="site/user_settings/update_privacy_settings";
$route['settings/account-privacy']="site/user_settings/account_privacy";
$route['settings/account-security']="site/user/account_security";
$route['settings/account-shipping-address']="site/user/account_shipping_address";
$route['settings/account-creditcard']="site/user/account_creditcard";
$route['settings/account-email']="site/user/account_email";
$route['settings/cart-shipping-address']="site/user/cart_shipping_address";

/****************** Shop Sections routes start************************/
$route['shop/(:any)'] = "site/shop/load_shop_open/$1";
$route['shop-section/(:any)']="site/shop_section/get_shop_section_list/$1";
/****************** Shop Sections routes end************************/

$route['digital-files/(:any)/(:any)'] = "site/order/digital_files/$1/$2";
$route['download-file/(:any)/(:any)/(:any)'] = "site/order/donwload/$1/$2/$3";
$route['link-expire'] = "site/order/expire_link";
/****************** registry  routes start here************************/
$route['registry'] = "site/market/loadRegistry";
$route['upload-products'] = "site/product/upload_product_form";

/**************** registry routes ends here*****************************/


/****************** market  routes start************************/
$route['market/(:any)'] = "site/market";
$route['spam-report'] = "site/market/spam_report";   
/*$route['admin/spam/spamProductList'] = "admin/market/spam_product_List";
$route['admin/spam/spamShopList'] = "admin/market/spam_shop_List"; 
$route['admin/spam/view_product_spam'] = "admin/market/view_product_spam";
$route['admin/spam/delete_product_spam'] = "admin/spam/delete_product_spam";   //*/

/****************** market  routes end************************/


/****************** Blog Routes End*********************************************************************************/
/* End of file routes.php */
/* Location: ./application/config/routes.php */