<?php
/**
 * Github
 *
 * @package llorix-one-lite
 */
?>

<div id="github" class="llorix-one-lite-tab-pane">

	<h1><?php esc_html_e( 'How can I contribute?', 'llorix-one-lite' ); ?></h1>

	<hr/>

	<div class="llorix-one-lite-tab-pane-half llorix-one-lite-tab-pane-first-half">

		<p><strong><?php esc_html_e( 'Found a bug? Want to contribute with a fix or create a new feature?', 'llorix-one-lite' ); ?></strong></p>

		<p><?php esc_html_e( 'GitHub is the place to go!', 'llorix-one-lite' ); ?></p>

		<p>
			<a href="https://github.com/Codeinwp/llorix-one-lite/" class="github-button button button-primary"><?php esc_html_e( 'Llorix One Lite on GitHub', 'llorix-one-lite' ); ?></a>
		</p>

		<hr>

	</div>
	<div class="llorix-one-lite-tab-pane-half">

		<p><strong><?php esc_html_e( 'Are you a polyglot? Want to translate Llorix One Lite into your own language?', 'llorix-one-lite' ); ?></strong></p>

		<p><?php esc_html_e( 'Get involved at WordPress.org.', 'llorix-one-lite' ); ?></p>

		<p>
			<a href="<?php echo esc_url( 'https://translate.wordpress.org/projects/wp-themes/llorix-one-lite/' ); ?>" class="translate-button button button-primary"><?php _e( 'Translate Llorix One Lite', 'llorix-one-lite' ); ?></a>
		</p>

	</div>

	<div>

		<h4><?php esc_html_e( 'Are you enjoying Llorix One Lite?', 'llorix-one-lite' ); ?></h4>

		<p class="review-link"><?php /* translators: %1$s is the leave a review link */ echo sprintf( esc_html__( 'Rate our theme on %1$sWordPress.org%1$s. We\'d really appreciate it!', 'llorix-one-lite' ), '<a href="https://wordpress.org/support/theme/llorix-one-lite/">', '</a>' ); ?></p>

		<p><span class="dashicons dashicons-star-filled"></span><span class="dashicons dashicons-star-filled"></span><span class="dashicons dashicons-star-filled"></span><span class="dashicons dashicons-star-filled"></span><span class="dashicons dashicons-star-filled"></span></p>

	</div>

</div>
