<?php
/**
 * The template used for displaying page content in page.php
 *
 * @package Ion
 */
?>

<article id="post-<?php the_ID(); ?>" <?php post_class(); ?>>

	<?php
	// Customized to display the featured image at
	// the top of a WordPress page that has a
	// featured image set.
	if ( has_post_thumbnail() ) {
		echo '<div class="featured-image">';
		the_post_thumbnail( 'large' );
		echo '</div>';
	}
	?>


	<div class="entry-content padding">
		<?php the_content(); ?>
		
		<?php edit_post_link( __( 'Edit', 'ap3-ion-theme' ), '<footer class="entry-meta"><span class="edit-link">', '</span></footer>' ); ?>
	</div><!-- .entry-content -->

	<?php get_template_part( 'content', 'below_page' ); ?>

</article><!-- #post-## -->
