<?php
class installerPps {
	static public $update_to_version_method = '';
	static private $_firstTimeActivated = false;
	static public function init( $isUpdate = false ) {
		global $wpdb;
		$wpPrefix = $wpdb->prefix; /* add to 0.0.3 Versiom */
		require_once(ABSPATH . 'wp-admin/includes/upgrade.php');
		$current_version = get_option($wpPrefix. PPS_DB_PREF. 'db_version', 0);
		if(!$current_version)
			self::$_firstTimeActivated = true;
		/**
		 * modules 
		 */
		if (!dbPps::exist("@__modules")) {
			dbDelta(dbPps::prepareQuery("CREATE TABLE IF NOT EXISTS `@__modules` (
			  `id` smallint(3) NOT NULL AUTO_INCREMENT,
			  `code` varchar(32) NOT NULL,
			  `active` tinyint(1) NOT NULL DEFAULT '0',
			  `type_id` tinyint(1) NOT NULL DEFAULT '0',
			  `label` varchar(64) DEFAULT NULL,
			  `ex_plug_dir` varchar(255) DEFAULT NULL,
			  PRIMARY KEY (`id`),
			  UNIQUE INDEX `code` (`code`)
			) DEFAULT CHARSET=utf8;"));
			dbPps::query("INSERT INTO `@__modules` (id, code, active, type_id, label) VALUES
				(NULL, 'adminmenu',1,1,'Admin Menu'),
				(NULL, 'options',1,1,'Options'),
				(NULL, 'user',1,1,'Users'),
				(NULL, 'pages',1,1,'Pages'),
				(NULL, 'templates',1,1,'templates'),
				(NULL, 'supsystic_promo',1,1,'supsystic_promo'),
				(NULL, 'admin_nav',1,1,'admin_nav'),
				
				(NULL, 'popup',1,1,'popup'),
				(NULL, 'subscribe',1,1,'subscribe'),
				(NULL, 'sm',1,1,'sm'),
				(NULL, 'statistics',1,1,'statistics'),
				
				(NULL, 'mail',1,1,'mail');");
		}
		if(!dbPps::exist("@__modules", "code", "tgm_promo")) {
			dbPps::query("INSERT INTO `@__modules` (id, code, active, type_id, label) VALUES (NULL, 'tgm_promo',1,1,'tgm_promo')");
		}
		/**
		 *  modules_type 
		 */
		if(!dbPps::exist("@__modules_type")) {
			dbDelta(dbPps::prepareQuery("CREATE TABLE IF NOT EXISTS `@__modules_type` (
			  `id` smallint(3) NOT NULL AUTO_INCREMENT,
			  `label` varchar(32) NOT NULL,
			  PRIMARY KEY (`id`)
			) AUTO_INCREMENT=4 DEFAULT CHARSET=utf8;"));
			dbPps::query("INSERT INTO `@__modules_type` VALUES
				(1,'system'),
				(6,'addons');");
		}
		/**
		 * Popup table
		 */
		if (!dbPps::exist("@__popup")) {
			dbDelta(dbPps::prepareQuery("CREATE TABLE IF NOT EXISTS `@__popup` (
				`id` INT(11) NOT NULL AUTO_INCREMENT,
				`label` VARCHAR(255) NOT NULL,
				`active` TINYINT(1) NOT NULL,
				`original_id` INT(11) NOT NULL DEFAULT '0',
				`params` TEXT NOT NULL,
				`html` TEXT NOT NULL,
				`css` TEXT NOT NULL,
				`img_preview` VARCHAR(128) NULL DEFAULT NULL,
				`show_on` TINYINT(1) NOT NULL DEFAULT '0',
				`show_to` TINYINT(1) NOT NULL DEFAULT '0',
				`show_pages` TINYINT(1) NOT NULL DEFAULT '0',
				`type_id` TINYINT(1) NOT NULL DEFAULT '1',
				
				`views` INT(11) NOT NULL DEFAULT '0',
				`unique_views` INT(11) NOT NULL DEFAULT '0',
				`actions` INT(11) NOT NULL DEFAULT '0',
				
				`date_created` TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP,
				PRIMARY KEY (`id`)
			) DEFAULT CHARSET=utf8;"));
		}
		if(!dbPps::exist("@__popup", "show_on")) {
			dbPps::query("ALTER TABLE `@__popup` ADD COLUMN `show_on` TINYINT(1) NOT NULL DEFAULT '0';");
		}
		if(!dbPps::exist("@__popup", "views")) {	// All those columns - were added in one update - so can place them in one condition - to not overload database
			dbPps::query("ALTER TABLE `@__popup` 
				ADD COLUMN `views` INT(11) NOT NULL DEFAULT '0',
				ADD COLUMN `unique_views` INT(11) NOT NULL DEFAULT '0',
				ADD COLUMN `actions` INT(11) NOT NULL DEFAULT '0';");
		}
		if(!dbPps::exist("@__popup", "sort_order")) {	// So, let's add some sorting here?;)
			dbPps::query("ALTER TABLE `@__popup` ADD COLUMN `sort_order` MEDIUMINT(5) NOT NULL DEFAULT '0';");
		}
		if(!dbPps::exist("@__popup", "show_in_admin_area")) {	// So, let's add some sorting here?;)
			dbPps::query("ALTER TABLE `@__popup` ADD COLUMN `show_in_admin_area` TINYINT(1) NOT NULL DEFAULT '0';");
		}
		self::addAdditionalPopups();
		self::makeTextFieldsCssUpdate();
		self::makeTextFieldsCssUpdateRound2();
		/**
		 * Popup ShowOn pages
		 */
		if (!dbPps::exist("@__popup_show_pages")) {
			dbDelta(dbPps::prepareQuery("CREATE TABLE `@__popup_show_pages` (
				`popup_id` INT(10) NOT NULL,
				`post_id` INT(10) NOT NULL,
				`not_show` TINYINT(1) NOT NULL DEFAULT '0'
			) DEFAULT CHARSET=utf8;"));
		}
		/**
		 * Popup ShowOn categories (terms)
		 */
		if (!dbPps::exist("@__popup_show_categories")) {
			dbDelta(dbPps::prepareQuery("CREATE TABLE `@__popup_show_categories` (
				`popup_id` INT(10) NOT NULL,
				`term_id` INT(10) NOT NULL,
				`not_show` TINYINT(1) NOT NULL DEFAULT '0'
			) DEFAULT CHARSET=utf8;"));
		}
		/**
		* Plugin usage statistics
		*/
		if(!dbPps::exist("@__usage_stat")) {
			dbDelta(dbPps::prepareQuery("CREATE TABLE `@__usage_stat` (
			  `id` int(11) NOT NULL AUTO_INCREMENT,
			  `code` varchar(64) NOT NULL,
			  `visits` int(11) NOT NULL DEFAULT '0',
			  `spent_time` int(11) NOT NULL DEFAULT '0',
			  `modify_timestamp` TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
			  UNIQUE INDEX `code` (`code`),
			  PRIMARY KEY (`id`)
			) DEFAULT CHARSET=utf8"));
			dbPps::query("INSERT INTO `@__usage_stat` (code, visits) VALUES ('installed', 1)");
		}
		/**
		 * Statistics
		 */
		if (!dbPps::exist("@__statistics")) {
			  dbDelta(dbPps::prepareQuery("CREATE TABLE `@__statistics` (
				`id` int(11) NOT NULL AUTO_INCREMENT,
				`popup_id` int(11) NOT NULL DEFAULT '0',
				`type` TINYINT(2) NOT NULL DEFAULT '0',
				`sm_id` TINYINT(2) NOT NULL DEFAULT '0',
				`is_unique` TINYINT(1) NOT NULL DEFAULT '0',
				`date_created` TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
				PRIMARY KEY (`id`)
			  ) DEFAULT CHARSET=utf8;"));
		}
		if(!dbPps::exist("@__statistics", "sm_id")) {	// Social Media ID
			dbPps::query("ALTER TABLE `@__statistics` ADD COLUMN `sm_id` TINYINT(2) NOT NULL DEFAULT '0';");
		}
		if(!dbPps::exist("@__statistics", "is_unique")) {	// Unique
			dbPps::query("ALTER TABLE `@__statistics` ADD COLUMN `is_unique` TINYINT(1) NOT NULL DEFAULT '0';");
		}
		/**
		 * Subscribers
		 */
		if (!dbPps::exist("@__subscribers")) {
			  dbDelta(dbPps::prepareQuery("CREATE TABLE `@__subscribers` (
				`id` int(11) NOT NULL AUTO_INCREMENT,
				`username` VARCHAR(128) NULL DEFAULT NULL,
				`email` VARCHAR(128) NOT NULL,
				`hash` VARCHAR(128) NOT NULL,
				`activated` TINYINT(1) NOT NULL DEFAULT '0',
				`popup_id` int(11) NOT NULL DEFAULT '0',
				`date_created` TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
				`all_data` TEXT NOT NULL,
				PRIMARY KEY (`id`)
			  ) DEFAULT CHARSET=utf8;"));
		}
		if(!dbPps::exist("@__subscribers", "popup_id")) {	// Popup ID for subscribers
			dbPps::query("ALTER TABLE `@__subscribers` ADD COLUMN `popup_id` int(11) NOT NULL DEFAULT '0';");
		}
		if(!dbPps::exist("@__subscribers", "all_data")) {	// All submit data for subscribers
			dbPps::query("ALTER TABLE `@__subscribers` ADD COLUMN `all_data` TEXT NOT NULL;");
		}
		/**
		 * Countries
		 */
		if (!dbPps::exist("@__countries")) {
			  dbDelta(dbPps::prepareQuery("CREATE TABLE `@__countries` (
				`id` int(11) NOT NULL AUTO_INCREMENT,
				`name` varchar(128) NOT NULL,
				`iso_code_2` varchar(2) DEFAULT NULL,
				`iso_code_3` varchar(3) DEFAULT NULL,
				PRIMARY KEY (`id`)
			  ) DEFAULT CHARSET=utf8;"));
			  self::_insertCountries();
		}
		installerDbUpdaterPps::runUpdate();
		if($current_version && !self::$_firstTimeActivated) {
			self::setUsed();
			self::_setOldUser();
			// For users that just updated our plugin - don't need tp show step-by-step tutorial
			update_user_meta(get_current_user_id(), PPS_CODE . '-tour-hst', array('closed' => 1));
		}
		update_option($wpPrefix. PPS_DB_PREF. 'db_version', PPS_VERSION);
		add_option($wpPrefix. PPS_DB_PREF. 'db_installed', 1);
	}
	
	static private function _setOldUser() {
		update_option(PPS_DB_PREF. 'is_old_user', 1);
	}
	
	static public function isNewUser() {
		$isOld = (int)get_option(PPS_DB_PREF. 'is_old_user');
		return !$isOld;
	}
	
	static public function setUsed() {
		update_option(PPS_DB_PREF. 'plug_was_used', 1);
	}
	static public function isUsed() {
		//return true;	// No welcome page for now
		//return 0;
		return (int) get_option(PPS_DB_PREF. 'plug_was_used');
	}
	static public function delete() {
		self::_checkSendStat('delete');
		global $wpdb;
		$wpPrefix = $wpdb->prefix;
		$wpdb->query("DROP TABLE IF EXISTS `".$wpPrefix.PPS_DB_PREF."modules`");
		$wpdb->query("DROP TABLE IF EXISTS `".$wpPrefix.PPS_DB_PREF."modules_type`");
		$wpdb->query("DROP TABLE IF EXISTS `".$wpPrefix.PPS_DB_PREF."usage_stat`");
		//$wpdb->query("DROP TABLE IF EXISTS `".$wpPrefix.PPS_DB_PREF."popup`");
		$wpdb->query("DROP TABLE IF EXISTS `".$wpPrefix.PPS_DB_PREF."popup_show_pages`");
		$wpdb->query("DROP TABLE IF EXISTS `".$wpPrefix.PPS_DB_PREF."statistics`");
		$wpdb->query("DROP TABLE IF EXISTS `".$wpPrefix.PPS_DB_PREF."statistics_sm`");
		$wpdb->query("DROP TABLE IF EXISTS `".$wpPrefix.PPS_DB_PREF."subscribers`");
		delete_option($wpPrefix. PPS_DB_PREF. 'db_version');
		delete_option($wpPrefix. PPS_DB_PREF. 'db_installed');
	}
	static public function deactivate() {
		self::_checkSendStat('deactivate');
	}
	static private function _checkSendStat($statCode) {
		if(class_exists('framePps') 
			&& framePps::_()->getModule('supsystic_promo')
			&& framePps::_()->getModule('options')
		) {
			framePps::_()->getModule('supsystic_promo')->getModel()->saveUsageStat( $statCode );
			framePps::_()->getModule('supsystic_promo')->getModel()->checkAndSend( true );
		}
	}
	static public function update() {
		global $wpdb;
		$wpPrefix = $wpdb->prefix; /* add to 0.0.3 Versiom */
		$currentVersion = get_option($wpPrefix. PPS_DB_PREF. 'db_version', 0);
		if(!$currentVersion || version_compare(PPS_VERSION, $currentVersion, '>')) {
			self::init( true );
			update_option($wpPrefix. PPS_DB_PREF. 'db_version', PPS_VERSION);
		}
	}
	static private function _insertCountries() {
		dbPps::query('INSERT INTO @__countries VALUES 
			(1, "Afghanistan", "AF", "AFG"),
			(2, "Albania", "AL", "ALB"),
			(3, "Algeria", "DZ", "DZA"),
			(4, "American Samoa", "AS", "ASM"),
			(5, "Andorra", "AD", "AND"),
			(6, "Angola", "AO", "AGO"),
			(7, "Anguilla", "AI", "AIA"),
			(8, "Antarctica", "AQ", "ATA"),
			(9, "Antigua and Barbuda", "AG", "ATG"),
			(10, "Argentina", "AR", "ARG"),
			(11, "Armenia", "AM", "ARM"),
			(12, "Aruba", "AW", "ABW"),
			(13, "Australia", "AU", "AUS"),
			(14, "Austria", "AT", "AUT"),
			(15, "Azerbaijan", "AZ", "AZE"),
			(16, "Bahamas", "BS", "BHS"),
			(17, "Bahrain", "BH", "BHR"),
			(18, "Bangladesh", "BD", "BGD"),
			(19, "Barbados", "BB", "BRB"),
			(20, "Belarus", "BY", "BLR"),
			(21, "Belgium", "BE", "BEL"),
			(22, "Belize", "BZ", "BLZ"),
			(23, "Benin", "BJ", "BEN"),
			(24, "Bermuda", "BM", "BMU"),
			(25, "Bhutan", "BT", "BTN"),
			(26, "Bolivia", "BO", "BOL"),
			(27, "Bosnia and Herzegowina", "BA", "BIH"),
			(28, "Botswana", "BW", "BWA"),
			(29, "Bouvet Island", "BV", "BVT"),
			(30, "Brazil", "BR", "BRA"),
			(31, "British Indian Ocean Territory", "IO", "IOT"),
			(32, "Brunei Darussalam", "BN", "BRN"),
			(33, "Bulgaria", "BG", "BGR"),
			(34, "Burkina Faso", "BF", "BFA"),
			(35, "Burundi", "BI", "BDI"),
			(36, "Cambodia", "KH", "KHM"),
			(37, "Cameroon", "CM", "CMR"),
			(38, "Canada", "CA", "CAN"),
			(39, "Cape Verde", "CV", "CPV"),
			(40, "Cayman Islands", "KY", "CYM"),
			(41, "Central African Republic", "CF", "CAF"),
			(42, "Chad", "TD", "TCD"),
			(43, "Chile", "CL", "CHL"),
			(44, "China", "CN", "CHN"),
			(45, "Christmas Island", "CX", "CXR"),
			(46, "Cocos (Keeling) Islands", "CC", "CCK"),
			(47, "Colombia", "CO", "COL"),
			(48, "Comoros", "KM", "COM"),
			(49, "Congo", "CG", "COG"),
			(50, "Cook Islands", "CK", "COK"),
			(51, "Costa Rica", "CR", "CRI"),
			(52, "Cote D\'Ivoire", "CI", "CIV"),
			(53, "Croatia", "HR", "HRV"),
			(54, "Cuba", "CU", "CUB"),
			(55, "Cyprus", "CY", "CYP"),
			(56, "Czech Republic", "CZ", "CZE"),
			(57, "Denmark", "DK", "DNK"),
			(58, "Djibouti", "DJ", "DJI"),
			(59, "Dominica", "DM", "DMA"),
			(60, "Dominican Republic", "DO", "DOM"),
			(61, "East Timor", "TP", "TMP"),
			(62, "Ecuador", "EC", "ECU"),
			(63, "Egypt", "EG", "EGY"),
			(64, "El Salvador", "SV", "SLV"),
			(65, "Equatorial Guinea", "GQ", "GNQ"),
			(66, "Eritrea", "ER", "ERI"),
			(67, "Estonia", "EE", "EST"),
			(68, "Ethiopia", "ET", "ETH"),
			(69, "Falkland Islands (Malvinas)", "FK", "FLK"),
			(70, "Faroe Islands", "FO", "FRO"),
			(71, "Fiji", "FJ", "FJI"),
			(72, "Finland", "FI", "FIN"),
			(73, "France", "FR", "FRA"),
			(74, "France, Metropolitan", "FX", "FXX"),
			(75, "French Guiana", "GF", "GUF"),
			(76, "French Polynesia", "PF", "PYF"),
			(77, "French Southern Territories", "TF", "ATF"),
			(78, "Gabon", "GA", "GAB"),
			(79, "Gambia", "GM", "GMB"),
			(80, "Georgia", "GE", "GEO"),
			(81, "Germany", "DE", "DEU"),
			(82, "Ghana", "GH", "GHA"),
			(83, "Gibraltar", "GI", "GIB"),
			(84, "Greece", "GR", "GRC"),
			(85, "Greenland", "GL", "GRL"),
			(86, "Grenada", "GD", "GRD"),
			(87, "Guadeloupe", "GP", "GLP"),
			(88, "Guam", "GU", "GUM"),
			(89, "Guatemala", "GT", "GTM"),
			(90, "Guinea", "GN", "GIN"),
			(91, "Guinea-bissau", "GW", "GNB"),
			(92, "Guyana", "GY", "GUY"),
			(93, "Haiti", "HT", "HTI"),
			(94, "Heard and Mc Donald Islands", "HM", "HMD"),
			(95, "Honduras", "HN", "HND"),
			(96, "Hong Kong", "HK", "HKG"),
			(97, "Hungary", "HU", "HUN"),
			(98, "Iceland", "IS", "ISL"),
			(99, "India", "IN", "IND"),
			(100, "Indonesia", "ID", "IDN"),
			(101, "Iran (Islamic Republic of)", "IR", "IRN"),
			(102, "Iraq", "IQ", "IRQ"),
			(103, "Ireland", "IE", "IRL"),
			(104, "Israel", "IL", "ISR"),
			(105, "Italy", "IT", "ITA"),
			(106, "Jamaica", "JM", "JAM"),
			(107, "Japan", "JP", "JPN"),
			(108, "Jordan", "JO", "JOR"),
			(109, "Kazakhstan", "KZ", "KAZ"),
			(110, "Kenya", "KE", "KEN"),
			(111, "Kiribati", "KI", "KIR"),
			(112, "Korea, Democratic People\'s Republic of", "KP", "PRK"),
			(113, "Korea, Republic of", "KR", "KOR"),
			(114, "Kuwait", "KW", "KWT"),
			(115, "Kyrgyzstan", "KG", "KGZ"),
			(116, "Lao People\'s Democratic Republic", "LA", "LAO"),
			(117, "Latvia", "LV", "LVA"),
			(118, "Lebanon", "LB", "LBN"),
			(119, "Lesotho", "LS", "LSO"),
			(120, "Liberia", "LR", "LBR"),
			(121, "Libyan Arab Jamahiriya", "LY", "LBY"),
			(122, "Liechtenstein", "LI", "LIE"),
			(123, "Lithuania", "LT", "LTU"),
			(124, "Luxembourg", "LU", "LUX"),
			(125, "Macau", "MO", "MAC"),
			(126, "Macedonia, The Former Yugoslav Republic of", "MK", "MKD"),
			(127, "Madagascar", "MG", "MDG"),
			(128, "Malawi", "MW", "MWI"),
			(129, "Malaysia", "MY", "MYS"),
			(130, "Maldives", "MV", "MDV"),
			(131, "Mali", "ML", "MLI"),
			(132, "Malta", "MT", "MLT"),
			(133, "Marshall Islands", "MH", "MHL"),
			(134, "Martinique", "MQ", "MTQ"),
			(135, "Mauritania", "MR", "MRT"),
			(136, "Mauritius", "MU", "MUS"),
			(137, "Mayotte", "YT", "MYT"),
			(138, "Mexico", "MX", "MEX"),
			(139, "Micronesia, Federated States of", "FM", "FSM"),
			(140, "Moldova, Republic of", "MD", "MDA"),
			(141, "Monaco", "MC", "MCO"),
			(142, "Mongolia", "MN", "MNG"),
			(143, "Montenegro", "ME", "MNE"),
			(144, "Montserrat", "MS", "MSR"),
			(145, "Morocco", "MA", "MAR"),
			(146, "Mozambique", "MZ", "MOZ"),
			(147, "Myanmar", "MM", "MMR"),
			(148, "Namibia", "NA", "NAM"),
			(149, "Nauru", "NR", "NRU"),
			(150, "Nepal", "NP", "NPL"),
			(151, "Netherlands", "NL", "NLD"),
			(152, "Netherlands Antilles", "AN", "ANT"),
			(153, "New Caledonia", "NC", "NCL"),
			(154, "New Zealand", "NZ", "NZL"),
			(155, "Nicaragua", "NI", "NIC"),
			(156, "Niger", "NE", "NER"),
			(157, "Nigeria", "NG", "NGA"),
			(158, "Niue", "NU", "NIU"),
			(159, "Norfolk Island", "NF", "NFK"),
			(160, "Northern Mariana Islands", "MP", "MNP"),
			(161, "Norway", "NO", "NOR"),
			(162, "Oman", "OM", "OMN"),
			(163, "Pakistan", "PK", "PAK"),
			(164, "Palau", "PW", "PLW"),
			(165, "Panama", "PA", "PAN"),
			(166, "Papua New Guinea", "PG", "PNG"),
			(167, "Paraguay", "PY", "PRY"),
			(168, "Peru", "PE", "PER"),
			(169, "Philippines", "PH", "PHL"),
			(170, "Pitcairn", "PN", "PCN"),
			(171, "Poland", "PL", "POL"),
			(172, "Portugal", "PT", "PRT"),
			(173, "Puerto Rico", "PR", "PRI"),
			(174, "Qatar", "QA", "QAT"),
			(175, "Reunion", "RE", "REU"),
			(176, "Romania", "RO", "ROM"),
			(177, "Russian Federation", "RU", "RUS"),
			(178, "Rwanda", "RW", "RWA"),
			(179, "Saint Kitts and Nevis", "KN", "KNA"),
			(180, "Saint Lucia", "LC", "LCA"),
			(181, "Saint Vincent and the Grenadines", "VC", "VCT"),
			(182, "Samoa", "WS", "WSM"),
			(183, "San Marino", "SM", "SMR"),
			(184, "Sao Tome and Principe", "ST", "STP"),
			(185, "Saudi Arabia", "SA", "SAU"),
			(186, "Senegal", "SN", "SEN"),
			(187, "Serbia", "RS", "SRB"),
			(188, "Seychelles", "SC", "SYC"),
			(189, "Sierra Leone", "SL", "SLE"),
			(190, "Singapore", "SG", "SGP"),
			(191, "Slovakia (Slovak Republic)", "SK", "SVK"),
			(192, "Slovenia", "SI", "SVN"),
			(193, "Solomon Islands", "SB", "SLB"),
			(194, "Somalia", "SO", "SOM"),
			(195, "South Africa", "ZA", "ZAF"),
			(196, "South Georgia and the South Sandwich Islands", "GS", "SGS"),
			(197, "Spain", "ES", "ESP"),
			(198, "Sri Lanka", "LK", "LKA"),
			(199, "St. Helena", "SH", "SHN"),
			(200, "St. Pierre and Miquelon", "PM", "SPM"),
			(201, "Sudan", "SD", "SDN"),
			(202, "Suriname", "SR", "SUR"),
			(203, "Svalbard and Jan Mayen Islands", "SJ", "SJM"),
			(204, "Swaziland", "SZ", "SWZ"),
			(205, "Sweden", "SE", "SWE"),
			(206, "Switzerland", "CH", "CHE"),
			(207, "Syrian Arab Republic", "SY", "SYR"),
			(208, "Taiwan", "TW", "TWN"),
			(209, "Tajikistan", "TJ", "TJK"),
			(210, "Tanzania, United Republic of", "TZ", "TZA"),
			(211, "Thailand", "TH", "THA"),
			(212, "Togo", "TG", "TGO"),
			(213, "Tokelau", "TK", "TKL"),
			(214, "Tonga", "TO", "TON"),
			(215, "Trinidad and Tobago", "TT", "TTO"),
			(216, "Tunisia", "TN", "TUN"),
			(217, "Turkey", "TR", "TUR"),
			(218, "Turkmenistan", "TM", "TKM"),
			(219, "Turks and Caicos Islands", "TC", "TCA"),
			(220, "Tuvalu", "TV", "TUV"),
			(221, "Uganda", "UG", "UGA"),
			(222, "Ukraine", "UA", "UKR"),
			(223, "United Arab Emirates", "AE", "ARE"),
			(224, "United Kingdom", "GB", "GBR"),
			(225, "United States", "US", "USA"),
			(226, "United States Minor Outlying Islands", "UM", "UMI"),
			(227, "Uruguay", "UY", "URY"),
			(228, "Uzbekistan", "UZ", "UZB"),
			(229, "Vanuatu", "VU", "VUT"),
			(230, "Vatican City State (Holy See)", "VA", "VAT"),
			(231, "Venezuela", "VE", "VEN"),
			(232, "Viet Nam", "VN", "VNM"),
			(233, "Virgin Islands (British)", "VG", "VGB"),
			(234, "Virgin Islands (U.S.)", "VI", "VIR"),
			(235, "Wallis and Futuna Islands", "WF", "WLF"),
			(236, "Western Sahara", "EH", "ESH"),
			(237, "Yemen", "YE", "YEM"),
			(238, "Zaire", "ZR", "ZAR"),
			(239, "Zambia", "ZM", "ZMB"),
			(240, "Zimbabwe", "ZW", "ZWE")');
	}
	static public function addAdditionalPopups() {
		// Remember last increment value
		$lastAutoIncrement = dbPps::getAutoIncrement('@__popup');
		$lastAutoIncrement = $lastAutoIncrement && $lastAutoIncrement > 30 ? $lastAutoIncrement : 100;
		$popupLastId = 39;
		//dbPps::query('DELETE FROM @__popup WHERE id IN ('. implode(',', range(0, $popupLastId)). ')');	// We updated all popups as we did changes in all of them
		if(!dbPps::exist('@__popup', 'id', '7')) {	// First set of additional templates
			dbPps::query('INSERT INTO @__popup (id,label,active,original_id,params,html,css,img_preview,show_on,show_to,show_pages,type_id,date_created,sort_order) VALUES 
("1","List Building","1","0","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","<div id=\"ppsPopupShell_[ID]\" class=\"ppsPopupShell ppsPopupListsShell\">\r\n	<a href=\"#\" class=\"ppsPopupClose ppsPopupClose_[close_btn]\"></a>\r\n	<div class=\"ppsInnerTblContent\">\r\n		<div class=\"ppsPopupListsInner ppsPopupInner\">\r\n			[if enb_label]\r\n				<div class=\"ppsPopupLabel ppsPopupListsLabel\">[label]</div>\r\n			[endif]\r\n			<div style=\"clear: both;\"></div>\r\n			[if enb_txt_0]\r\n				<div class=\"ppsPopupTxt ppsPopupClassyTxt ppsPopupClassyTxt_0 ppsPopupTxt_0\">\r\n				[txt_0]\r\n				</div>\r\n			[endif]\r\n			[if enb_txt_1]\r\n				<div class=\"ppsPopupTxt ppsPopupClassyTxt ppsPopupClassyTxt_1 ppsPopupTxt_1\">\r\n				[txt_1]\r\n				</div>\r\n			[endif]\r\n			<div style=\"clear: both;\"></div>\r\n		</div>\r\n		<div class=\"ppsRightCol\">\r\n			[if enb_subscribe]\r\n				<div class=\"ppsSubscribeShell\">\r\n					[sub_form_start]\r\n					[sub_fields_html]\r\n					<input type=\"submit\" name=\"submit\" value=\"[sub_btn_label]\" />\r\n					[sub_form_end]\r\n					<div style=\"clear: both;\"></div>\r\n				</div>\r\n			[endif]\r\n			[if enb_sm]\r\n				<div class=\"ppsSm\">\r\n				[sm_html]\r\n				</div>\r\n			[endif]\r\n			[if enb_foot_note]\r\n				<div class=\"ppsFootNote\">\r\n				[foot_note]\r\n				</div>\r\n			[endif]\r\n		</div>\r\n	</div>\r\n</div>","#ppsPopupShell_[ID] {\r\n	width: [width][width_measure];\r\n  	padding: 15px;\r\n  	font-family: Georgia, Times, serif;\r\n	font-size: 13px;\r\n	line-height: 21px;\r\n	font-weight: normal;\r\n	color: #000;\r\n}\r\n#ppsPopupShell_[ID], #ppsPopupShell_[ID] * {\r\n	-webkit-box-sizing: border-box;\r\n	-moz-box-sizing:    border-box;\r\n	box-sizing:         border-box;\r\n}\r\n#ppsPopupShell_[ID] .ppsInnerTblContent {\r\n	display: table;\r\n}\r\n#ppsPopupShell_[ID] .ppsPopupInner {\r\n  {% if popup.params.tpl.enb_subscribe or popup.params.tpl.enb_foot_note or popup.params.tpl.enb_sm %}\r\n  	width: 66%;\r\n	[else]\r\n  	width: 100%;\r\n  	[endif]\r\n  	display: table-cell;\r\n  	vertical-align: top;\r\n	[if bg_type_0 == \'color\']\r\n	background: -moz-radial-gradient(center, ellipse cover, {{ adjust_brightness(popup.params.tpl.bg_color_0, 50) }} 0%, [bg_color_0] 100%); /* ff3.6+ */\r\n	background: -webkit-gradient(radial, center center, 0px, center center, 100%, color-stop(0%, {{ adjust_brightness(popup.params.tpl.bg_color_0, 50) }}), color-stop(100%, [bg_color_0])); /* safari4+,chrome */\r\n	background:-webkit-radial-gradient(center, ellipse cover, {{ adjust_brightness(popup.params.tpl.bg_color_0, 50) }} 0%, [bg_color_0] 100%); /* safari5.1+,chrome10+ */\r\n	background: -o-radial-gradient(center, ellipse cover, {{ adjust_brightness(popup.params.tpl.bg_color_0, 50) }} 0%, [bg_color_0] 100%); /* opera 11.10+ */\r\n	background: -ms-radial-gradient(center, ellipse cover, {{ adjust_brightness(popup.params.tpl.bg_color_0, 50) }} 0%, [bg_color_0] 100%); /* ie10+ */\r\n	background:radial-gradient(ellipse at center, {{ adjust_brightness(popup.params.tpl.bg_color_0, 50) }} 0%, [bg_color_0] 100%); /* w3c */\r\n	filter: progid:DXImageTransform.Microsoft.gradient( startColorstr=\'{{ adjust_brightness(popup.params.tpl.bg_color_0, 50) }}\', endColorstr=\'[bg_color_0]\',GradientType=1 ); /* ie6-9 */\r\n  	[elseif bg_type_0 == \'img\']\r\n  	background-image: url(\"[bg_img_0]\");\r\n  	background-repeat: no-repeat;\r\n  	background-size: cover;\r\n  	[endif]\r\n  	\r\n}\r\n#ppsPopupShell_[ID] .ppsPopupLabel {\r\n	color: #000;\r\n	font-family: \"Myriad Pro\",\"Trebuchet MS\",\"Helvetica Neue\",Helvetica,Arial,Sans-Serif;\r\n	font-size: 30px;\r\n	letter-spacing: -1px;\r\n	line-height: 40px;\r\n	letter-spacing: -1px;\r\n	font-weight: bold;\r\n	margin-top: 15px;\r\n	margin-bottom: 16px;\r\n	padding-left: 20px;\r\n	text-shadow: 0px 0px 1px #000;\r\n	-moz-text-shadow: 0px 0px 1px #000;\r\n	-webkit-text-shadow: 0px 0px 1px #000;\r\n}\r\n#ppsPopupShell_[ID] .ppsRightCol {\r\n	display: table-cell;\r\n  	width: 34%;\r\n  	height: 100%;\r\n  	[if bg_type_1 == \'color\']\r\n  	background: -moz-radial-gradient(center, ellipse cover, {{ adjust_brightness(popup.params.tpl.bg_color_1, 50) }} 0%, [bg_color_1] 100%); /* ff3.6+ */\r\n	background: -webkit-gradient(radial, center center, 0px, center center, 100%, color-stop(0%, {{ adjust_brightness(popup.params.tpl.bg_color_1, 50) }}), color-stop(100%, [bg_color_1])); /* safari4+,chrome */\r\n	background:-webkit-radial-gradient(center, ellipse cover, {{ adjust_brightness(popup.params.tpl.bg_color_1, 50) }} 0%, [bg_color_1] 100%); /* safari5.1+,chrome10+ */\r\n	background: -o-radial-gradient(center, ellipse cover, {{ adjust_brightness(popup.params.tpl.bg_color_1, 50) }} 0%, [bg_color_1] 100%); /* opera 11.10+ */\r\n	background: -ms-radial-gradient(center, ellipse cover, {{ adjust_brightness(popup.params.tpl.bg_color_1, 50) }} 0%, [bg_color_1] 100%); /* ie10+ */\r\n  background:radial-gradient(ellipse at center, {{ adjust_brightness(popup.params.tpl.bg_color_1, 50) }} 0%, [bg_color_1] 100%); /* w3c */\r\n	filter: progid:DXImageTransform.Microsoft.gradient( startColorstr=\'{{ adjust_brightness(popup.params.tpl.bg_color_1, 50) }}\', endColorstr=\'[bg_color_1]\',GradientType=1 ); /* ie6-9 */\r\n  	[elseif bg_type_1 == \'img\']\r\n  	background-image: url(\"[bg_img_1]\");\r\n  	background-repeat: no-repeat;\r\n  	background-size: cover;\r\n  	[endif]\r\n  \r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell form {\r\n	padding: 30px 30px 0;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell input,\r\n#ppsPopupShell_[ID] .ppsSubscribeShell .ppsSubSelect,\r\n#ppsPopupShell_[ID] .ppsSubscribeShell textarea {\r\n	width: 100%;\r\n  	margin-bottom: 10px;\r\n  	height: 40px;\r\n  	border: 1px solid #d1b36d;\r\n  	border-radius: 10px;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell input[type=text],#ppsPopupShell_[ID] .ppsSubscribeShell input[type=email],#ppsPopupShell_[ID] .ppsSubscribeShell input[type=password],#ppsPopupShell_[ID] .ppsSubscribeShell input[type=email],\r\n#ppsPopupShell_[ID] .ppsSubscribeShell .ppsSubSelect,\r\n#ppsPopupShell_[ID] .ppsSubscribeShell textarea {\r\n	box-shadow: 2px 2px 2px #dcdcdc inset;\r\n  	padding-left: 10px;\r\n  	font-size: 17px;\r\n  	background-color: #fff;\r\n  	display: block;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell .ppsSubSelect {\r\n	display: table;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell .ppsSubSelectLabel,\r\n#ppsPopupShell_[ID] .ppsSubscribeShell select {\r\n	display: table-cell;\r\n  	\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell .ppsSubSelectLabel {\r\n	opacity: 0.5;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell select {\r\n	width: 100%;\r\n  	background-color: transparent;\r\n  	height: 40px;\r\n  	border: none;\r\n  	margin-left: -5px;\r\n  	font-size: 17px;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell textarea {\r\n	font-family: inherit;\r\n  	height: auto;\r\n    padding-top: 5px;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell input[type=text],#ppsPopupShell_[ID] .ppsSubscribeShell input[type=email],#ppsPopupShell_[ID] .ppsSubscribeShell input[name=\"email\"] {\r\n	background-image: url(\"[PPS_ASSETS_URL]img/assets/mail-icon.png\");\r\n  	background-repeat: no-repeat;\r\n  	background-position: 90% center;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell input[type=submit] {\r\n	border-color: #000;\r\n  	[if bg_type_2 == \'color\']\r\n  	background: [bg_color_2];\r\n    background: -moz-linear-gradient(90deg, [bg_color_2] 0%, {{ adjust_brightness(popup.params.tpl.bg_color_2, 100) }} 63%);\r\n    background: -webkit-linear-gradient(270deg, [bg_color_2] 0%, {{ adjust_brightness(popup.params.tpl.bg_color_2, 100) }} 63%);\r\n    background: -o-linear-gradient(270deg, [bg_color_2] 0%, {{ adjust_brightness(popup.params.tpl.bg_color_2, 100) }} 63%);\r\n    background: -ms-linear-gradient(270deg, [bg_color_2] 0%, {{ adjust_brightness(popup.params.tpl.bg_color_2, 100) }} 63%);\r\n    background: linear-gradient(0deg, [bg_color_2]) 0%, {{ adjust_brightness(popup.params.tpl.bg_color_2, 100) }} 63%);\r\n  	[elseif bg_type_2 == \'img\']\r\n  	background-image: url(\"[bg_img_2]\");\r\n  	background-repeat: no-repeat;\r\n  	background-size: cover;\r\n  	[endif]\r\n  \r\n  	color: #fff;\r\n    font-size: 20px;\r\n    text-shadow: 2px 2px 2px #000;\r\n  	cursor: pointer;\r\n  	padding: 0;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell input[type=submit]:hover {\r\n	box-shadow: inset 1px 1px 3px #666;\r\n}\r\n#ppsPopupShell_[ID] .ppsPopupTxt_0 {\r\n	float: left;\r\n  	width: 50%;\r\n  	text-align: center;\r\n}\r\n#ppsPopupShell_[ID] .ppsPopupTxt_1 {\r\n	float: right;\r\n    [if enb_txt_0]\r\n    width: 50%;\r\n    [else]\r\n    width: 100%;\r\n    [endif]\r\n}\r\n#ppsPopupShell_[ID] .ppsPopupClose {\r\n	background-repeat: no-repeat;\r\n  	cursor: pointer;\r\n}\r\n#ppsPopupShell_[ID] .ppsPopupClose.ppsPopupClose_lists_black {\r\n 	top: 0 !important;\r\n  	right: 0 !important;\r\n}\r\n#ppsPopupShell_[ID] .ppsPopupClose:hover {\r\n	opacity: 0.8;\r\n}\r\n#ppsPopupShell_[ID] .ppsFootNote{\r\n	color: #585858;\r\n    font-family: \"Helvetica Neue\",Helvetica,Arial,sans-serif;\r\n    font-size: x-small;\r\n    font-style: italic;\r\n    line-height: 14px;\r\n  	margin: 5px 30px;\r\n}","","1","1","1","1","2015-01-10 18:59:43","7"),
("2","Classy","1","0","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","<div id=\"ppsPopupShell_[ID]\" class=\"ppsPopupShell ppsPopupClassyShell\">\r\n	<a href=\"#\" class=\"ppsPopupClose\"></a>\r\n	<div class=\"ppsPopupClassyInner\">\r\n		[if enb_label]\r\n			<div class=\"ppsPopupLabel ppsPopupClassyLabel\">[label]</div>\r\n		[endif]\r\n		[if enb_txt_0]\r\n		<div class=\"ppsPopupTxt ppsPopupClassyTxt ppsPopupTxt_0\">\r\n			[txt_0]\r\n		</div>\r\n		[endif]\r\n		[if enb_txt_1]\r\n		<div class=\"ppsPopupTxt ppsPopupClassyTxt ppsPopupTxt_1\">\r\n			[txt_1]\r\n		</div>\r\n		[endif]\r\n      	[if enb_sm]\r\n        <div class=\"ppsSm\">\r\n            [sm_html]\r\n        </div>\r\n        [endif]\r\n		<div style=\"clear: both;\"></div>\r\n	</div>\r\n	[if enb_subscribe]\r\n	<div class=\"ppsSubscribeShell\">\r\n		[sub_form_start]\r\n          	[sub_fields_html]\r\n			<input type=\"submit\" name=\"submit\" value=\"[sub_btn_label]\" />\r\n		[sub_form_end]\r\n	</div>\r\n  	[endif]\r\n  	[if enb_foot_note]\r\n  	<div class=\"ppsFootNote\">[foot_note]</div>\r\n  	[endif]\r\n</div>","#ppsPopupShell_[ID] {\r\n  	width: [width][width_measure];\r\n	[if bg_type_0 == \'color\']\r\n	background-color: {{ popup.params.tpl.bg_color_0 }};\r\n	[elseif bg_type_0 == \'img\']\r\n	background-image: url(\"[bg_img_0]\");\r\n	background-size: 100%;\r\n  	background-repeat: no-repeat;\r\n	[endif]\r\n	padding: 7px;\r\n}\r\n#ppsPopupShell_[ID] .ppsPopupClassyInner {\r\n	padding: 15px;\r\n	border: {{ adjust_brightness(popup.params.tpl.bg_color_0, 30) }};\r\n	[if bg_type_0 == \'color\']\r\n	background: -moz-radial-gradient(center, ellipse cover, {{ popup.params.tpl.bg_color_0 }} 0%, {{ adjust_brightness(popup.params.tpl.bg_color_0, -20) }} 100%); /* ff3.6+ */\r\n	background: -webkit-gradient(radial, center center, 0px, center center, 100%, color-stop(0%, {{ popup.params.tpl.bg_color_0 }}), color-stop(100%, {{ adjust_brightness(popup.params.tpl.bg_color_0, -20) }})); /* safari4+,chrome */\r\n	background:-webkit-radial-gradient(center, ellipse cover, {{ popup.params.tpl.bg_color_0 }} 0%, {{ adjust_brightness(popup.params.tpl.bg_color_0, -20) }} 100%); /* safari5.1+,chrome10+ */\r\n	background: -o-radial-gradient(center, ellipse cover, {{ popup.params.tpl.bg_color_0 }} 0%, {{ adjust_brightness(popup.params.tpl.bg_color_0, -20) }} 100%); /* opera 11.10+ */\r\n	background: -ms-radial-gradient(center, ellipse cover, {{ popup.params.tpl.bg_color_0 }} 0%, {{ adjust_brightness(popup.params.tpl.bg_color_0, -20) }} 100%); /* ie10+ */\r\n	background:radial-gradient(ellipse at center, {{ popup.params.tpl.bg_color_0 }} 0%, {{ adjust_brightness(popup.params.tpl.bg_color_0, -20) }} 100%); /* w3c */\r\n	filter: progid:DXImageTransform.Microsoft.gradient( startColorstr=\'{{ popup.params.tpl.bg_color_0 }}\', endColorstr=\'{{ adjust_brightness(popup.params.tpl.bg_color_0, -20) }}\',GradientType=1 ); /* ie6-9 */\r\n	[endif]\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell input,\r\n#ppsPopupShell_[ID] .ppsSubscribeShell .ppsSubSelect,\r\n#ppsPopupShell_[ID] .ppsSubscribeShell textarea {\r\n	height: 48px;\r\n	font-size: 27px;\r\n	border: none;\r\n	padding: 1px 8px 0;\r\n	width: calc((100% - 70px) / 3);\r\n  	box-sizing: content-box;\r\n  	margin-top: 10px;\r\n  	float: left;\r\n  	display: block;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell input[type=text],#ppsPopupShell_[ID] .ppsSubscribeShell input[type=email],#ppsPopupShell_[ID] .ppsSubscribeShell input[type=password],#ppsPopupShell_[ID] .ppsSubscribeShell input[type=email],\r\n#ppsPopupShell_[ID] .ppsSubscribeShell .ppsSubSelect,\r\n#ppsPopupShell_[ID] .ppsSubscribeShell textarea {\r\n	[if bg_type_0 == \'color\']\r\n	-webkit-box-shadow: inset 4px 4px 4px 0px {{ adjust_brightness(popup.params.tpl.bg_color_0, -40) }};\r\n	-moz-box-shadow: inset 4px 4px 4px 0px {{ adjust_brightness(popup.params.tpl.bg_color_0, -40) }};\r\n	box-shadow: inset 4px 4px 4px 0px {{ adjust_brightness(popup.params.tpl.bg_color_0, -40) }};\r\n	background-color: {{ adjust_brightness(popup.params.tpl.bg_color_0, -20) }};\r\n	color: {{ adjust_brightness(popup.params.tpl.bg_color_0, -100) }};\r\n	[endif]\r\n	margin-right: 5px;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell .ppsSubSelect {\r\n	display: table;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell .ppsSubSelectLabel,\r\n#ppsPopupShell_[ID] .ppsSubscribeShell select {\r\n  	display: table-cell;\r\n  	height: 48px;\r\n  	vertical-align: middle;\r\n  	background-color: transparent;\r\n  	border: none;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell .ppsSubSelectLabel {\r\n	opacity: 0.5;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell select {\r\n	width: 100%;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell select,\r\n#ppsPopupShell_[ID] .ppsSubscribeShell select option {\r\n	font-size: 27px;\r\n  	color: #6d6d6d;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell textarea {\r\n	width: calc(100% - 30px);\r\n  	height: auto;\r\n  	font-family: inherit;\r\n  	padding-top: 5px;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell input[type=submit] {\r\n	color: #eee;\r\n	margin-right: 0;\r\n	cursor: pointer;\r\n	[if bg_type_1 == \'color\']\r\n	text-shadow: -1px -1px 1px {{ adjust_brightness(popup.params.tpl.bg_color_1, -80) }};\r\n	border: 1px solid {{ adjust_brightness(popup.params.tpl.bg_color_1, -40) }};\r\n	background: -moz-radial-gradient(center, ellipse cover, {{ popup.params.tpl.bg_color_1 }} 0%, {{ adjust_brightness(popup.params.tpl.bg_color_1, -50) }} 100%); /* ff3.6+ */\r\n	background: -webkit-gradient(radial, center center, 0px, center center, 100%, color-stop(0%, {{ popup.params.tpl.bg_color_1 }}), color-stop(100%, {{ adjust_brightness(popup.params.tpl.bg_color_1, -50) }})); /* safari4+,chrome */\r\n	background:-webkit-radial-gradient(center, ellipse cover, {{ popup.params.tpl.bg_color_1 }} 0%, {{ adjust_brightness(popup.params.tpl.bg_color_1, -50) }} 100%); /* safari5.1+,chrome10+ */\r\n	background: -o-radial-gradient(center, ellipse cover, {{ popup.params.tpl.bg_color_1 }} 0%, {{ adjust_brightness(popup.params.tpl.bg_color_1, -50) }} 100%); /* opera 11.10+ */\r\n	background: -ms-radial-gradient(center, ellipse cover, {{ popup.params.tpl.bg_color_1 }} 0%, {{ adjust_brightness(popup.params.tpl.bg_color_1, -50) }} 100%); /* ie10+ */\r\n	background:radial-gradient(ellipse at center, {{ popup.params.tpl.bg_color_1 }} 0%, {{ adjust_brightness(popup.params.tpl.bg_color_1, -50) }} 100%); /* w3c */\r\n	filter: progid:DXImageTransform.Microsoft.gradient( startColorstr=\'{{ popup.params.tpl.bg_color_1 }}\', endColorstr=\'{{ adjust_brightness(popup.params.tpl.bg_color_1, -50) }}\',GradientType=1 ); /* ie6-9 */\r\n\r\n	-webkit-box-shadow: inset 0px 0px 2px 2px {{ adjust_brightness(popup.params.tpl.bg_color_1, 10) }};\r\n	-moz-box-shadow: inset 0px 0px 2px 2px {{ adjust_brightness(popup.params.tpl.bg_color_1, 10) }};\r\n	box-shadow: inset 0px 0px 2px 2px {{ adjust_brightness(popup.params.tpl.bg_color_1, 10) }};\r\n	[elseif bg_type_1 == \'img\']\r\n	background-image: url(\"[bg_img_1]\");\r\n	background-size: 100%;\r\n  	background-repeat: no-repeat;\r\n	[endif]\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell input[type=submit]:disabled {\r\n	color: transparent;\r\n  	cursor: progress;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell input[type=submit]:hover {\r\n	opacity: 0.8;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell form {\r\n	margin: 0;\r\n}\r\n#ppsPopupShell_[ID] .ppsPopupClassyLabel {\r\n	width: 100%;\r\n	text-align: center;\r\n	color: #555555;\r\n	text-shadow: 1px 1px 1px #ffffff;\r\n	font-size: 35px;\r\n	margin-top: 26px;\r\n}\r\n#ppsPopupShell_[ID] .ppsSuccessMsg {\r\n	color: #555555;\r\n  	border: 1px solid #555555;\r\n}\r\n#ppsPopupShell_[ID] .ppsPopupTxt {\r\n	font-size: 20px;\r\n	line-height: 160%;\r\n	color: rgb(85, 85, 85);\r\n	padding-top: 14px;\r\n}\r\n#ppsPopupShell_[ID] .ppsPopupTxt_0 {\r\n  	[if enb_txt_1]\r\n	width: 70%;\r\n  	float: left;\r\n  	[endif]\r\n}\r\n#ppsPopupShell_[ID] .ppsPopupTxt_1 {\r\n	float: right;\r\n	width: 30%;\r\n}\r\n#ppsPopupShell_[ID] ul {\r\n	margin-top: 15px;\r\n	padding-left: 0;\r\n}\r\n#ppsPopupShell_[ID] ul li {\r\n	list-style: inside none disc;\r\n}\r\n#ppsPopupShell_[ID] .ppsPopupClose:hover {\r\n	opacity: 0.8;\r\n}\r\n#ppsPopupShell_[ID] .ppsFootNote {\r\n	color: #999;\r\n    font-size: 12px;\r\n    padding-top: 10px;\r\n    text-align: center;\r\n}\r\n/*SM*/\r\n#ppsPopupShell_[ID] .ppsSm {\r\n	padding: 10px 10px 0 10px;\r\n  	text-align: center;\r\n}\r\n#ppsPopupShell_1_435376 .ppsSm > div {\r\n	vertical-align: top !important;\r\n}\r\n#ppsPopupShell_[ID] .ppsSm .ppsSmBtn {\r\n	margin-right: 5px;\r\n}","","1","1","1","1","2015-01-03 17:00:43","19"),
("3","Fastest and the Easiest","1","0","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","<div id=\"ppsPopupShell_[ID]\" class=\"ppsPopupShell ppsPopupListsShell\">\r\n	<a href=\"#\" class=\"ppsPopupClose\"></a>\r\n  	<div class=\"ppsPopupListsInner\">\r\n  		[if enb_txt_0]\r\n  		<div class=\"ppsPopupTxt ppsPopupTxt_0\">\r\n          <div class=\"ppsTxtContent\">[txt_0]</div>\r\n      	</div>\r\n  		[endif]\r\n      	<div class=\"ppsPopupTblCols\">\r\n          <div class=\"ppsPopupLeftCol\">\r\n            [if enb_label]\r\n            <div class=\"ppsPopupLabel\">[label]</div>\r\n            [endif]\r\n            [if enb_txt_1]\r\n            <div class=\"ppsPopupTxt ppsPopupTxt_1\">[txt_1]</div>\r\n            [endif]\r\n          </div>\r\n          <div class=\"ppsPopupRightCol\">\r\n            [if enb_subscribe]\r\n            <div class=\"ppsSubscribeShell\">\r\n              <div class=\"ppsBigArrow\"></div>\r\n              [sub_form_start]\r\n              [sub_fields_html]\r\n              <input type=\"submit\" name=\"submit\" value=\"[sub_btn_label]\" />\r\n              [sub_form_end]\r\n            </div>\r\n            [endif]\r\n            [if enb_sm]\r\n            <div class=\"ppsSm\">\r\n              [sm_html]\r\n            </div>\r\n            [endif]\r\n            [if enb_foot_note]\r\n            <div class=\"ppsFootNote\">\r\n              [foot_note]\r\n            </div>\r\n            [endif]\r\n          </div>\r\n      	</div>\r\n  	</div>\r\n  	\r\n</div>","#ppsPopupShell_[ID] {\r\n	width: [width][width_measure];\r\n  	font-family: Helvetica,Arial,sans-serif;\r\n  	font-size: 14px;\r\n  \r\n  	[if bg_type_0 == \'img\']\r\n  	background-image: url(\"[bg_img_0]\");\r\n  	background-repeat: no-repeat;\r\n  	background-size: cover;\r\n  	[endif]\r\n}\r\n#ppsPopupShell_[ID] .ppsPopupLabel {\r\n	color: #414141;\r\n    font-size: 28px;\r\n    font-style: normal;\r\n    font-weight: bold;\r\n    letter-spacing: -1px;\r\n    line-height: 35px;\r\n    text-shadow: 0 1px 1px #000;\r\n}\r\n#ppsPopupShell_[ID] .ppsPopupListsInner {\r\n  	[if bg_type_0 == \'color\']\r\n    background: {{ adjust_brightness(popup.params.tpl.bg_color_0, 50) }}; /* Old browsers */\r\n    background: -moz-radial-gradient(center, ellipse cover, {{ adjust_brightness(popup.params.tpl.bg_color_0, 50) }} 0%, [bg_color_0] 100%); /* FF3.6+ */\r\n    background: -webkit-gradient(radial, center center, 0px, center center, 100%, color-stop(0%,{{ adjust_brightness(popup.params.tpl.bg_color_0, 50) }}), color-stop(100%,[bg_color_0])); /* Chrome,Safari4+ */\r\n    background: -webkit-radial-gradient(center, ellipse cover, {{ adjust_brightness(popup.params.tpl.bg_color_0, 50) }} 0%,[bg_color_0] 100%); /* Chrome10+,Safari5.1+ */\r\n    background: -o-radial-gradient(center, ellipse cover, {{ adjust_brightness(popup.params.tpl.bg_color_0, 50) }} 0%,[bg_color_0] 100%); /* Opera 12+ */\r\n    background: -ms-radial-gradient(center, ellipse cover, {{ adjust_brightness(popup.params.tpl.bg_color_0, 50) }} 0%,[bg_color_0] 100%); /* IE10+ */\r\n    background: radial-gradient(ellipse at center, {{ adjust_brightness(popup.params.tpl.bg_color_0, 50) }} 0%,[bg_color_0] 100%); /* W3C */\r\n    filter: progid:DXImageTransform.Microsoft.gradient( startColorstr=\'{{ adjust_brightness(popup.params.tpl.bg_color_0, 50) }}\', endColorstr=\'#eaeaea\',GradientType=1 ); /* IE6-9 fallback on horizontal gradient */\r\n  	[endif]\r\n}\r\n#ppsPopupShell_[ID] .ppsPopupTxt_0 {\r\n	width: 100%;\r\n  	border-bottom: 1px solid {{ adjust_brightness(popup.params.tpl.bg_color_0, -50) }};\r\n  	clear: both;\r\n  	font-size: 13px;\r\n    font-weight: bold;\r\n  	font-family: Helvetica,Arial,sans-serif;\r\n  	[if bg_type_0 == \'color\']\r\n  	background: [bg_color_0]; /* Old browsers */\r\n    background: -moz-linear-gradient(top, [bg_color_0] 0%, {{ adjust_brightness(popup.params.tpl.bg_color_0, 20) }} 100%); /* FF3.6+ */\r\n    background: -webkit-gradient(linear, left top, left bottom, color-stop(0%,[bg_color_0]), color-stop(100%,{{ adjust_brightness(popup.params.tpl.bg_color_0, 20) }})); /* Chrome,Safari4+ */\r\n    background: -webkit-linear-gradient(top, [bg_color_0] 0%,{{ adjust_brightness(popup.params.tpl.bg_color_0, 20) }} 100%); /* Chrome10+,Safari5.1+ */\r\n    background: -o-linear-gradient(top, [bg_color_0] 0%,{{ adjust_brightness(popup.params.tpl.bg_color_0, 20) }} 100%); /* Opera 11.10+ */\r\n    background: -ms-linear-gradient(top, [bg_color_0] 0%,{{ adjust_brightness(popup.params.tpl.bg_color_0, 20) }} 100%); /* IE10+ */\r\n    background: linear-gradient(to bottom, [bg_color_0] 0%,{{ adjust_brightness(popup.params.tpl.bg_color_0, 20) }} 100%); /* W3C */\r\n    filter: progid:DXImageTransform.Microsoft.gradient( startColorstr=\'[bg_color_0]\', endColorstr=\'{{ adjust_brightness(popup.params.tpl.bg_color_0, 20) }}\',GradientType=0 ); /* IE6-9 */\r\n  	[endif]\r\n}\r\n#ppsPopupShell_[ID] .ppsPopupTxt_0 .ppsTxtContent {\r\n	padding: 10px 10px 10px 50px;\r\n}\r\n#ppsPopupShell_[ID] .ppsPopupTblCols {\r\n	display: table;\r\n  	padding: 10px 10px 10px 50px;\r\n}\r\n#ppsPopupShell_[ID] .ppsPopupLeftCol {\r\n	display: table-cell;\r\n  	vertical-align: top;\r\n  	[if enb_subscribe]\r\n  	width: 64%;\r\n  	[else]\r\n  	width: 100%;\r\n  	[endif]\r\n}\r\n#ppsPopupShell_[ID] .ppsPopupRightCol {\r\n  	width: 36%;\r\n	display: table-cell;\r\n  	position: relative;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell form {\r\n	padding: 30px 30px 0;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell input,\r\n#ppsPopupShell_[ID] .ppsSubscribeShell .ppsSubSelect,\r\n#ppsPopupShell_[ID] .ppsSubscribeShell textarea {\r\n	width: 100%;\r\n  	margin-bottom: 10px;\r\n  	height: 40px;\r\n  	border: 1px solid #000;\r\n  	border-radius: 10px;\r\n  	display: block;\r\n  	background-color: #fff;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell input[type=text],#ppsPopupShell_[ID] .ppsSubscribeShell input[type=email],#ppsPopupShell_[ID] .ppsSubscribeShell input[type=password],#ppsPopupShell_[ID] .ppsSubscribeShell input[type=email],\r\n#ppsPopupShell_[ID] .ppsSubscribeShell .ppsSubSelect,\r\n#ppsPopupShell_[ID] .ppsSubscribeShell textarea {\r\n	box-shadow: 2px 2px 2px #dcdcdc inset;\r\n  	padding-left: 10px;\r\n  	font-size: 17px;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell .ppsSubSelect {\r\n	display: table;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell .ppsSubSelectLabel,\r\n#ppsPopupShell_[ID] .ppsSubscribeShell select {\r\n	display: table-cell;\r\n  	vertical-align: middle;\r\n  	height: 40px;\r\n  	background-color: transparent;\r\n  	border: none;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell select {\r\n	width: 100%;\r\n  	margin-left: -10px;\r\n  	font-size: 17px;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell .ppsSubSelectLabel {\r\n	opacity: 0.5;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell textarea {\r\n	height: auto;\r\n  	font-family: inherit;\r\n  	padding-top: 5px;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell input[type=text],#ppsPopupShell_[ID] .ppsSubscribeShell input[type=email],#ppsPopupShell_[ID] .ppsSubscribeShell input[name=\"email\"] {\r\n	background-image: url(\"[PPS_ASSETS_URL]img/assets/mail-icon.png\");\r\n  	background-repeat: no-repeat;\r\n  	background-position: 90% center;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell input[type=submit] {\r\n	border: none;\r\n  	[if bg_type_1 == \'color\']\r\n  	background: [bg_color_1];\r\n    background: -moz-linear-gradient(90deg, [bg_color_1] 0%, {{ adjust_brightness(popup.params.tpl.bg_color_1, 100) }} 63%);\r\n    background: -webkit-linear-gradient(270deg, [bg_color_1] 0%, {{ adjust_brightness(popup.params.tpl.bg_color_1, 100) }} 63%);\r\n    background: -o-linear-gradient(270deg, [bg_color_1] 0%, {{ adjust_brightness(popup.params.tpl.bg_color_1, 100) }} 63%);\r\n    background: -ms-linear-gradient(270deg, [bg_color_1] 0%, {{ adjust_brightness(popup.params.tpl.bg_color_1, 100) }} 63%);\r\n    background: linear-gradient(0deg, [bg_color_1]) 0%, {{ adjust_brightness(popup.params.tpl.bg_color_1, 100) }} 63%);\r\n  	[elseif bg_type_1 == \'img\']\r\n  	background-image: url(\"[bg_img_1]\");\r\n  	background-repeat: no-repeat;\r\n  	background-size: cover;\r\n  	[endif]\r\n  \r\n  	color: #000;\r\n    font-size: 20px;\r\n    text-shadow: 2px 2px 2px #000;\r\n  	cursor: pointer;\r\n  	max-width: 230px;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell input[type=submit]:hover {\r\n	box-shadow: inset 1px 1px 3px #666;\r\n}\r\n#ppsPopupShell_[ID] .ppsPopupClose:hover {\r\n	opacity: 0.8;\r\n}\r\n#ppsPopupShell_[ID] .ppsPopupClose {\r\n	background-repeat: no-repeat;\r\n  	cursor: pointer;\r\n}\r\n#ppsPopupShell_[ID] .ppsFootNote {\r\n    color: #979696;\r\n    font-family: \"Helvetica Neue\",Helvetica,Arial,sans-serif;\r\n    font-size: xx-small;\r\n    font-style: italic;\r\n    line-height: 14px;\r\n    text-align: left;\r\n  	margin-left: 30px;\r\n}\r\n#ppsPopupShell_[ID] .ppsBigArrow {\r\n	[if bg_type_2 == \'img\']\r\n  	position: absolute;\r\n  	width: 102px;\r\n    height: 81px;\r\n  	background-image: url(\"[bg_img_2]\");\r\n  	background-repeat: no-repeat;\r\n  	top: -20px;\r\n  	right: 20px;\r\n  	z-index: 100;\r\n  	[else]\r\n  	display: none;\r\n  	[endif]\r\n}\r\n#ppsPopupShell_[ID] .ppsSuccessMsg {\r\n	padding: 55px 5px 5px;\r\n}","","1","1","1","1","2015-01-13 19:22:48","13"),
("4","Facebook Like","1","0","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","<div id=\"ppsPopupShell_[ID]\" class=\"ppsPopupShell ppsPopupFbLikeShell\">\r\n	<a href=\"#\" class=\"ppsPopupClose\"></a>\r\n  	[fb_like_widget_html]\r\n</div>","#ppsPopupShell_[ID] {\r\n	width: [width][width_measure];\r\n  	/*height: [height][height_measure];*/\r\n  	[if bg_type_0 == \'color\']\r\n  	background-color: [bg_color_0];\r\n  	[elseif bg_type_0 == \'img\']\r\n  	background-repeat: no_repeat;\r\n  	background-image: url(\"[bg_img_0]\");\r\n  	background-size: cover;\r\n  	[endif]\r\n}\r\n#ppsPopupShell_[ID] .ppsPopupClose {\r\n	z-index: 99;\r\n}\r\n#ppsPopupShell_[ID] .ppsPopupClose:hover {\r\n	opacity: 0.8;\r\n}\r\n","","1","1","1","2","2015-01-16 19:35:51","3"),
("5","Video List","1","0","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","<div id=\"ppsPopupShell_[ID]\" class=\"ppsPopupShell ppsPopupListsShell\">\r\n	<a href=\"#\" class=\"ppsPopupClose ppsPopupClose_[close_btn]\"></a>\r\n	<div class=\"ppsInnerTblContent\">\r\n		<div class=\"ppsPopupListsInner ppsPopupInner\">\r\n			<div class=\"ppsPopupVideo \">\r\n				[video_html]\r\n			</div>\r\n			<div style=\"clear: both;\"></div>\r\n		</div>\r\n		<div class=\"ppsRightCol\">\r\n			[if enb_label]\r\n				<div class=\"ppsPopupLabel ppsPopupListsLabel\">[label]</div>\r\n				<div style=\"clear: both;\"></div>\r\n			[endif]\r\n			[if enb_subscribe]\r\n				<div class=\"ppsSubscribeShell\">\r\n					[sub_form_start]\r\n					[sub_fields_html]\r\n					<input type=\"submit\" name=\"submit\" value=\"[sub_btn_label]\" />\r\n					[sub_form_end]\r\n					<div style=\"clear: both;\"></div>\r\n				</div>\r\n			[endif]\r\n			[if enb_sm]\r\n				<div class=\"ppsSm\">\r\n				[sm_html]\r\n				</div>\r\n			[endif]\r\n			[if enb_foot_note]\r\n				<div class=\"ppsFootNote\">\r\n				[foot_note]\r\n				</div>\r\n			[endif]\r\n		</div>\r\n	</div>\r\n</div>","#ppsPopupShell_[ID] {\r\n	width: [width][width_measure];\r\n  	padding: 0;\r\n  	font-family: arial;\r\n	font-size: 13px;\r\n	line-height: normal;\r\n	font-weight: normal;\r\n	color: #015050;\r\n}\r\n#ppsPopupShell_[ID], #ppsPopupShell_[ID] * {\r\n	-webkit-box-sizing: border-box;\r\n	-moz-box-sizing:    border-box;\r\n	box-sizing:         border-box;\r\n}\r\n#ppsPopupShell_[ID] iframe {\r\n	width: 100% !important;\r\n	margin: 0;\r\n    padding: 0;\r\n}\r\n#ppsPopupShell_[ID] .ppsInnerTblContent {\r\n	display: table;\r\n}\r\n#ppsPopupShell_[ID] .ppsPopupInner {\r\n	display: table-cell;\r\n	vertical-align: middle;\r\n	\r\n	{% if popup.params.tpl.enb_subscribe or popup.params.tpl.enb_foot_note or popup.params.tpl.enb_sm %}\r\n  	width: 66%;\r\n	[else]\r\n  	width: 100%;\r\n  	[endif]\r\n\r\n	[if bg_type_0 == \"color\"]\r\n	background: -moz-radial-gradient(center, ellipse cover, {{ adjust_brightness(popup.params.tpl.bg_color_0, 50) }} 0%, [bg_color_0] 100%); /* ff3.6+ */\r\n	background: -webkit-gradient(radial, center center, 0px, center center, 100%, color-stop(0%, {{ adjust_brightness(popup.params.tpl.bg_color_0, 50) }}), color-stop(100%, [bg_color_0])); /* safari4+,chrome */\r\n	background:-webkit-radial-gradient(center, ellipse cover, {{ adjust_brightness(popup.params.tpl.bg_color_0, 50) }} 0%, [bg_color_0] 100%); /* safari5.1+,chrome10+ */\r\n	background: -o-radial-gradient(center, ellipse cover, {{ adjust_brightness(popup.params.tpl.bg_color_0, 50) }} 0%, [bg_color_0] 100%); /* opera 11.10+ */\r\n	background: -ms-radial-gradient(center, ellipse cover, {{ adjust_brightness(popup.params.tpl.bg_color_0, 50) }} 0%, [bg_color_0] 100%); /* ie10+ */\r\n	background:radial-gradient(ellipse at center, {{ adjust_brightness(popup.params.tpl.bg_color_0, 50) }} 0%, [bg_color_0] 100%); /* w3c */\r\n	filter: progid:DXImageTransform.Microsoft.gradient( startColorstr=\"{{ adjust_brightness(popup.params.tpl.bg_color_0, 50) }}\", endColorstr=\"[bg_color_0]\",GradientType=1 ); /* ie6-9 */\r\n  	[elseif bg_type_0 == \"img\"]\r\n  	background-image: url(\"[bg_img_0]\");\r\n  	background-repeat: no-repeat;\r\n  	background-size: cover;\r\n	background-position: center top;\r\n	[else]\r\n	background: none;\r\n  	[endif]\r\n}\r\n\r\n#ppsPopupShell_[ID] .ppsRightCol {\r\n	display: table-cell;\r\n  	width: 34%;\r\n  	height: 100%;\r\n  	vertical-align: middle;\r\n	padding: 15px 0;\r\n	margin: 0;\r\n	\r\n  	[if bg_type_1 == \"color\"]\r\n  	background: -moz-radial-gradient(center, ellipse cover, {{ adjust_brightness(popup.params.tpl.bg_color_1, 50) }} 0%, [bg_color_1] 100%); /* ff3.6+ */\r\n	background: -webkit-gradient(radial, center center, 0px, center center, 100%, color-stop(0%, {{ adjust_brightness(popup.params.tpl.bg_color_1, 50) }}), color-stop(100%, [bg_color_1])); /* safari4+,chrome */\r\n	background:-webkit-radial-gradient(center, ellipse cover, {{ adjust_brightness(popup.params.tpl.bg_color_1, 50) }} 0%, [bg_color_1] 100%); /* safari5.1+,chrome10+ */\r\n	background: -o-radial-gradient(center, ellipse cover, {{ adjust_brightness(popup.params.tpl.bg_color_1, 50) }} 0%, [bg_color_1] 100%); /* opera 11.10+ */\r\n	background: -ms-radial-gradient(center, ellipse cover, {{ adjust_brightness(popup.params.tpl.bg_color_1, 50) }} 0%, [bg_color_1] 100%); /* ie10+ */\r\n	background:radial-gradient(ellipse at center, {{ adjust_brightness(popup.params.tpl.bg_color_1, 50) }} 0%, [bg_color_1] 100%); /* w3c */\r\n	filter: progid:DXImageTransform.Microsoft.gradient( startColorstr=\"{{ adjust_brightness(popup.params.tpl.bg_color_1, 50) }}\", endColorstr=\"[bg_color_1]\",GradientType=1 ); /* ie6-9 */\r\n  	[elseif bg_type_1 == \"img\"]\r\n  	background-image: url(\"[bg_img_1]\");\r\n  	background-repeat: no-repeat;\r\n  	background-size: cover;\r\n	background-position: center top;\r\n  	[endif]\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell form {\r\n	padding: 15px 30px 0;\r\n}\r\n\r\n#ppsPopupShell_[ID] .ppsSubscribeShell input::-webkit-input-placeholder { /* Chrome/Opera/Safari */\r\n    color: #ccc;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell input::-moz-placeholder { /* Firefox 19+ */\r\n    color: #ccc;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell input:-ms-input-placeholder { /* IE 10+ */\r\n    color: #ccc;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell input:-moz-placeholder { /* Firefox 18- */\r\n    color: #ccc;\r\n}\r\n\r\n#ppsPopupShell_[ID] .ppsSubscribeShell textarea::-webkit-input-placeholder { /* Chrome/Opera/Safari */\r\n    color: #ccc;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell textarea::-moz-placeholder { /* Firefox 19+ */\r\n    color: #ccc;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell textarea:-ms-input-placeholder { /* IE 10+ */\r\n    color: #ccc;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell textarea:-moz-placeholder { /* Firefox 18- */\r\n    color: #ccc;\r\n}\r\n/*For all Elements*/\r\n#ppsPopupShell_[ID] .ppsSubscribeShell input[type=\"email\"],\r\n#ppsPopupShell_[ID] .ppsSubscribeShell input[type=\"password\"],\r\n#ppsPopupShell_[ID] .ppsSubscribeShell input[type=\"text\"],\r\n#ppsPopupShell_[ID] .ppsSubscribeShell select,\r\n#ppsPopupShell_[ID] .ppsSubscribeShell textarea {\r\n	font-family: arial;\r\n	font-size: 16px;\r\n	font-weight: normal;\r\n	line-height: normal;\r\n	color: #aaa;\r\n	text-align:center;\r\n	width: 100%;\r\n	-webkit-border-radius: 5px;\r\n	-moz-border-radius: 5px;\r\n	border-radius: 5px;\r\n	border: 0px solid transparent;\r\n	display:block;\r\n    \r\n    margin: 10px 0 0;\r\n	padding: 0 10px 0 10px;\r\n	height: 40px;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell textarea {\r\n	height: auto;\r\n	padding-top: 9px;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeForm input:first-child {\r\n	margin-top: 0px;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell select  {\r\n	margin: 0;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell label  {\r\n	display: block;\r\n	font-family: arial;\r\n	font-size: 16px;\r\n	font-weight: normal;\r\n	line-height: normal;\r\n	color: #015050;\r\n	\r\n	margin: 10px 0 0;\r\n	text-align: center;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell label  span {\r\n	display: block;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell input[type=\"text\"][name=\"name\"] {\r\n	background-image: url(\"[PPS_ASSETS_URL]img/assets/user-black-icon.png\");\r\n	background-position: 12px center;\r\n	background-repeat: no-repeat;\r\n	background-size: 16px auto;\r\n	padding: 0 25px 0 35px;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell input[type=\"email\"] {\r\n	background-image: url(\"[PPS_ASSETS_URL]img/assets/email-black-icon.png\");\r\n	background-position: 11px center;\r\n	background-repeat: no-repeat;\r\n	background-size: 18px auto;\r\n	padding: 0 25px 0 35px;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell input[type=\"submit\"] {\r\n	display: block;\r\n	font-family: arial;\r\n	font-size: 17px;\r\n	font-weight: bold;\r\n	line-height: normal;\r\n	color: #fff;\r\n  	cursor: pointer;\r\n	margin: 10px 0 0;\r\n	-webkit-border-radius: 5px;\r\n	-moz-border-radius: 5px;\r\n	border-radius: 5px;\r\n	border: 0px solid transparent;\r\n	width: 100%;\r\n	height: 50px;\r\n	\r\n  	[if bg_type_2 == \"color\"]\r\n  	background: [bg_color_2] 100%;\r\n  	[elseif bg_type_2 == \"img\"]\r\n  	background: url(\"[bg_img_2]\");\r\n  	background-repeat: no-repeat;\r\n  	background-size: cover;\r\n  	[endif]\r\n}\r\n\r\n#ppsPopupShell_[ID] .ppsPopupLabel {\r\n	color: #015050;\r\n	font-family: arial;\r\n	font-size: 30px;\r\n	line-height: 40px;\r\n	font-weight: bold;\r\n	margin: 0 15px 15px;\r\n	padding: 0;\r\n	text-align: center;\r\n\r\n}\r\n#ppsPopupShell_[ID] .ppsPopupVideo {\r\n  	width: 100%;\r\n  	line-height: 0;\r\n}\r\n#ppsPopupShell_[ID] .ppsSuccessMsg {\r\n	color: #015050 !important;\r\n	font-weight: bold;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubMsg {\r\n	text-align: center;\r\n}\r\n#ppsPopupShell_[ID] .ppsPopupClose {\r\n	background-repeat: no-repeat;\r\n  	cursor: pointer;\r\n}\r\n#ppsPopupShell_[ID] .ppsPopupClose.ppsPopupClose_lists_black {\r\n 	top: 0 !important;\r\n  	right: 0 !important;\r\n}\r\n#ppsPopupShell_[ID] .ppsPopupClose:hover {\r\n	opacity: 0.8;\r\n}\r\n#ppsPopupShell_[ID] .ppsFootNote {\r\n	color: #015050;\r\n    font-family: \"Helvetica Neue\",Helvetica,Arial,sans-serif;\r\n    font-size: x-small;\r\n    font-style: normal;\r\n	font-weight: bold;\r\n    line-height: 14px;\r\n  	margin: 15px 30px 5px;\r\n	padding: 0;\r\n	text-align: center;\r\n}","2016-230-5-video-list-prev.png","1","1","1","3","2015-01-10 18:59:43","1"),
("6","Video Classy","1","0","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","<div id=\"ppsPopupShell_[ID]\" class=\"ppsPopupShell ppsPopupClassyShell\">\r\n	<a href=\"#\" class=\"ppsPopupClose\"></a>\r\n	<div class=\"ppsPopupClassyInner\">\r\n		[if enb_label]\r\n			<div class=\"ppsPopupLabel ppsPopupClassyLabel\">[label]</div>\r\n		[endif]\r\n		<div class=\"ppsPopupVideo\">\r\n			[video_html]\r\n		</div>\r\n      	[if enb_sm]\r\n        <div class=\"ppsSm\">\r\n            [sm_html]\r\n        </div>\r\n        [endif]\r\n		<div style=\"clear: both;\"></div>\r\n	</div>\r\n	[if enb_subscribe]\r\n	<div class=\"ppsSubscribeShell\">\r\n		[sub_form_start]\r\n          	[sub_fields_html]\r\n			<input type=\"submit\" name=\"submit\" value=\"[sub_btn_label]\" />\r\n		[sub_form_end]\r\n	</div>\r\n  	[endif]\r\n  	[if enb_foot_note]\r\n  	<div class=\"ppsFootNote\">[foot_note]</div>\r\n  	[endif]\r\n</div>","#ppsPopupShell_[ID] {\r\n  	width: [width][width_measure];\r\n	[if bg_type_0 == \'color\']\r\n	background-color: {{ popup.params.tpl.bg_color_0 }};\r\n	[elseif bg_type_0 == \'img\']\r\n	background-image: url(\"[bg_img_0]\");\r\n	background-size: 100%;\r\n  	background-repeat: no-repeat;\r\n	[endif]\r\n	padding: 7px;\r\n}\r\n#ppsPopupShell_[ID], #ppsPopupShell_[ID] * {\r\n	-webkit-box-sizing: content-box;\r\n	-moz-box-sizing:    content-box;\r\n	box-sizing:         content-box;\r\n}\r\n#ppsPopupShell_[ID] .ppsPopupClassyInner {\r\n	padding: 0;\r\n	border: {{ adjust_brightness(popup.params.tpl.bg_color_0, 30) }};\r\n	[if bg_type_0 == \'color\']\r\n	background: -moz-radial-gradient(center, ellipse cover, {{ popup.params.tpl.bg_color_0 }} 0%, {{ adjust_brightness(popup.params.tpl.bg_color_0, -20) }} 100%); /* ff3.6+ */\r\n	background: -webkit-gradient(radial, center center, 0px, center center, 100%, color-stop(0%, {{ popup.params.tpl.bg_color_0 }}), color-stop(100%, {{ adjust_brightness(popup.params.tpl.bg_color_0, -20) }})); /* safari4+,chrome */\r\n	background:-webkit-radial-gradient(center, ellipse cover, {{ popup.params.tpl.bg_color_0 }} 0%, {{ adjust_brightness(popup.params.tpl.bg_color_0, -20) }} 100%); /* safari5.1+,chrome10+ */\r\n	background: -o-radial-gradient(center, ellipse cover, {{ popup.params.tpl.bg_color_0 }} 0%, {{ adjust_brightness(popup.params.tpl.bg_color_0, -20) }} 100%); /* opera 11.10+ */\r\n	background: -ms-radial-gradient(center, ellipse cover, {{ popup.params.tpl.bg_color_0 }} 0%, {{ adjust_brightness(popup.params.tpl.bg_color_0, -20) }} 100%); /* ie10+ */\r\n	background:radial-gradient(ellipse at center, {{ popup.params.tpl.bg_color_0 }} 0%, {{ adjust_brightness(popup.params.tpl.bg_color_0, -20) }} 100%); /* w3c */\r\n	filter: progid:DXImageTransform.Microsoft.gradient( startColorstr=\'{{ popup.params.tpl.bg_color_0 }}\', endColorstr=\'{{ adjust_brightness(popup.params.tpl.bg_color_0, -20) }}\',GradientType=1 ); /* ie6-9 */\r\n	[endif]\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell input,\r\n#ppsPopupShell_[ID] .ppsSubscribeShell .ppsSubSelect,\r\n#ppsPopupShell_[ID] .ppsSubscribeShell textarea {\r\n	height: 48px;\r\n	font-size: 27px;\r\n	border: none;\r\n	padding: 1px 8px 0;\r\n	width: calc((100% - 70px) / 3);\r\n  	box-sizing: content-box;\r\n  	margin-top: 10px;\r\n  	float: left;\r\n  	display: block;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell input[type=text],#ppsPopupShell_[ID] .ppsSubscribeShell input[type=email],#ppsPopupShell_[ID] .ppsSubscribeShell input[type=password],#ppsPopupShell_[ID] .ppsSubscribeShell input[type=email],\r\n#ppsPopupShell_[ID] .ppsSubscribeShell .ppsSubSelect,\r\n#ppsPopupShell_[ID] .ppsSubscribeShell textarea {\r\n	[if bg_type_0 == \'color\']\r\n	-webkit-box-shadow: inset 4px 4px 4px 0px {{ adjust_brightness(popup.params.tpl.bg_color_0, -40) }};\r\n	-moz-box-shadow: inset 4px 4px 4px 0px {{ adjust_brightness(popup.params.tpl.bg_color_0, -40) }};\r\n	box-shadow: inset 4px 4px 4px 0px {{ adjust_brightness(popup.params.tpl.bg_color_0, -40) }};\r\n	background-color: {{ adjust_brightness(popup.params.tpl.bg_color_0, -20) }};\r\n	color: {{ adjust_brightness(popup.params.tpl.bg_color_0, -100) }};\r\n	[endif]\r\n	margin-right: 5px;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell .ppsSubSelect {\r\n	display: table;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell .ppsSubSelectLabel,\r\n#ppsPopupShell_[ID] .ppsSubscribeShell select {\r\n  	display: table-cell;\r\n  	height: 48px;\r\n  	vertical-align: middle;\r\n  	background-color: transparent;\r\n  	border: none;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell .ppsSubSelectLabel {\r\n	opacity: 0.5;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell select {\r\n	width: 100%;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell select,\r\n#ppsPopupShell_[ID] .ppsSubscribeShell select option {\r\n	font-size: 27px;\r\n  	color: #6d6d6d;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell textarea {\r\n	width: calc(100% - 30px);\r\n  	height: auto;\r\n  	font-family: inherit;\r\n  	padding-top: 5px;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell input[type=submit] {\r\n	color: #eee;\r\n	margin-right: 0;\r\n	cursor: pointer;\r\n	[if bg_type_1 == \'color\']\r\n	text-shadow: -1px -1px 1px {{ adjust_brightness(popup.params.tpl.bg_color_1, -80) }};\r\n	border: 1px solid {{ adjust_brightness(popup.params.tpl.bg_color_1, -40) }};\r\n	background: -moz-radial-gradient(center, ellipse cover, {{ popup.params.tpl.bg_color_1 }} 0%, {{ adjust_brightness(popup.params.tpl.bg_color_1, -50) }} 100%); /* ff3.6+ */\r\n	background: -webkit-gradient(radial, center center, 0px, center center, 100%, color-stop(0%, {{ popup.params.tpl.bg_color_1 }}), color-stop(100%, {{ adjust_brightness(popup.params.tpl.bg_color_1, -50) }})); /* safari4+,chrome */\r\n	background:-webkit-radial-gradient(center, ellipse cover, {{ popup.params.tpl.bg_color_1 }} 0%, {{ adjust_brightness(popup.params.tpl.bg_color_1, -50) }} 100%); /* safari5.1+,chrome10+ */\r\n	background: -o-radial-gradient(center, ellipse cover, {{ popup.params.tpl.bg_color_1 }} 0%, {{ adjust_brightness(popup.params.tpl.bg_color_1, -50) }} 100%); /* opera 11.10+ */\r\n	background: -ms-radial-gradient(center, ellipse cover, {{ popup.params.tpl.bg_color_1 }} 0%, {{ adjust_brightness(popup.params.tpl.bg_color_1, -50) }} 100%); /* ie10+ */\r\n	background:radial-gradient(ellipse at center, {{ popup.params.tpl.bg_color_1 }} 0%, {{ adjust_brightness(popup.params.tpl.bg_color_1, -50) }} 100%); /* w3c */\r\n	filter: progid:DXImageTransform.Microsoft.gradient( startColorstr=\'{{ popup.params.tpl.bg_color_1 }}\', endColorstr=\'{{ adjust_brightness(popup.params.tpl.bg_color_1, -50) }}\',GradientType=1 ); /* ie6-9 */\r\n\r\n	-webkit-box-shadow: inset 0px 0px 2px 2px {{ adjust_brightness(popup.params.tpl.bg_color_1, 10) }};\r\n	-moz-box-shadow: inset 0px 0px 2px 2px {{ adjust_brightness(popup.params.tpl.bg_color_1, 10) }};\r\n	box-shadow: inset 0px 0px 2px 2px {{ adjust_brightness(popup.params.tpl.bg_color_1, 10) }};\r\n	[elseif bg_type_1 == \'img\']\r\n	background-image: url(\"[bg_img_1]\");\r\n	background-size: 100%;\r\n  	background-repeat: no-repeat;\r\n	[endif]\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell input[type=submit]:disabled {\r\n	color: transparent;\r\n  	cursor: progress;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell input[type=submit]:hover {\r\n	opacity: 0.8;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell {\r\n	padding-top: 10px;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell form {\r\n	margin: 0;\r\n}\r\n#ppsPopupShell_[ID] .ppsPopupClassyLabel {\r\n	width: 100%;\r\n	text-align: center;\r\n	color: #555555;\r\n	text-shadow: 1px 1px 1px #ffffff;\r\n	font-size: 35px;\r\n	margin-top: 26px;\r\n}\r\n#ppsPopupShell_[ID] .ppsSuccessMsg {\r\n	color: #555555;\r\n  	border: 1px solid #555555;\r\n}\r\n#ppsPopupShell_[ID] .ppsPopupClassyTxt {\r\n	font-size: 20px;\r\n	line-height: 160%;\r\n	color: rgb(85, 85, 85);\r\n	padding-top: 14px;\r\n}\r\n#ppsPopupShell_[ID] .ppsPopupVideo {\r\n	width: 100%;\r\n  	line-height: 0;\r\n  	padding: 0;\r\n  	margin: 0;\r\n}\r\n#ppsPopupShell_[ID] .ppsPopupVideo iframe {\r\n  	margin: 0;\r\n}\r\n#ppsPopupShell_[ID] ul {\r\n	margin-top: 15px;\r\n	padding-left: 0;\r\n}\r\n#ppsPopupShell_[ID] ul li {\r\n	list-style: inside none disc;\r\n}\r\n#ppsPopupShell_[ID] .ppsPopupClose:hover {\r\n	opacity: 0.8;\r\n}\r\n#ppsPopupShell_[ID] .ppsFootNote {\r\n	color: #999;\r\n    font-size: 12px;\r\n    padding-top: 10px;\r\n    text-align: center;\r\n}\r\n/*SM*/\r\n#ppsPopupShell_[ID] .ppsSm {\r\n	padding: 10px 10px 0 10px;\r\n  	text-align: center;\r\n}\r\n#ppsPopupShell_1_435376 .ppsSm > div {\r\n	vertical-align: top !important;\r\n}\r\n#ppsPopupShell_[ID] .ppsSm .ppsSmBtn {\r\n	margin-right: 5px;\r\n}","","1","1","1","3","2015-01-03 17:00:43","16"),
("7","Layered Popup","1","0","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","<div id=\"ppsPopupShell_[ID]\" class=\"ppsPopupShell ppsPopupListsShell\">\r\n	<a href=\"#\" class=\"ppsPopupClose ppsPopupClose_[close_btn]\"></a>\r\n	<div class=\"ppsInnerTblContent\">\r\n		<div class=\"ppsPopupListsInner ppsPopupInner\">\r\n			[if enb_label]\r\n				<div class=\"ppsPopupLabel ppsPopupListsLabel\">[label]</div>\r\n			[endif]\r\n			<div style=\"clear: both;\"></div>\r\n			[if enb_txt_0]\r\n				<div class=\"ppsPopupTxt ppsPopupClassyTxt ppsPopupClassyTxt_0 ppsPopupTxt_0\">\r\n				[txt_0]\r\n				</div>\r\n			[endif]\r\n			[if enb_subscribe]\r\n				<div class=\"ppsSubscribeShell\">\r\n					[sub_form_start]\r\n					[sub_fields_html]\r\n					<input type=\"submit\" name=\"submit\" value=\"[sub_btn_label]\" />\r\n					[sub_form_end]\r\n					<div style=\"clear: both;\"></div>\r\n				</div>\r\n			[endif]\r\n			<div style=\"clear: both;\"></div>\r\n			<div class=\"ppsRightCol\">\r\n				[if enb_sm]\r\n					<div style=\"clear: both;\"></div>\r\n					<div class=\"ppsSm\">\r\n					[sm_html]\r\n					</div>\r\n				[endif]\r\n				[if enb_foot_note]\r\n					<div class=\"ppsFootNote\">\r\n					[foot_note]\r\n					</div>\r\n				[endif]\r\n			</div>\r\n		</div>\r\n	</div>\r\n</div>","#ppsPopupShell_[ID] {\r\n	width: [width][width_measure];\r\n  	padding: 15px;\r\n  	font-family: Georgia, Times, serif;\r\n	font-size: 13px;\r\n	line-height: 21px;\r\n	font-weight: normal;\r\n	color: #fff;\r\n}\r\n#ppsPopupShell_[ID], #ppsPopupShell_[ID] * {\r\n	-webkit-box-sizing: content-box;\r\n	-moz-box-sizing:    content-box;\r\n	box-sizing:         content-box;\r\n}\r\n#ppsPopupShell_[ID] .ppsPopupInner {\r\n  {% if popup.params.tpl.enb_subscribe or popup.params.tpl.enb_foot_note or popup.params.tpl.enb_sm %}\r\n  	width: 100%;\r\n	[else]\r\n  	width: 100%;\r\n  	[endif]\r\n	[if bg_type_0 == \'color\']\r\n	background: -moz-radial-gradient(center, ellipse cover, {{ adjust_brightness(popup.params.tpl.bg_color_0, 50) }} 0%, [bg_color_0] 100%); /* ff3.6+ */\r\n	background: -webkit-gradient(radial, center center, 0px, center center, 100%, color-stop(0%, {{ adjust_brightness(popup.params.tpl.bg_color_0, 50) }}), color-stop(100%, [bg_color_0])); /* safari4+,chrome */\r\n	background:-webkit-radial-gradient(center, ellipse cover, {{ adjust_brightness(popup.params.tpl.bg_color_0, 50) }} 0%, [bg_color_0] 100%); /* safari5.1+,chrome10+ */\r\n	background: -o-radial-gradient(center, ellipse cover, {{ adjust_brightness(popup.params.tpl.bg_color_0, 50) }} 0%, [bg_color_0] 100%); /* opera 11.10+ */\r\n	background: -ms-radial-gradient(center, ellipse cover, {{ adjust_brightness(popup.params.tpl.bg_color_0, 50) }} 0%, [bg_color_0] 100%); /* ie10+ */\r\n	background:radial-gradient(ellipse at center, {{ adjust_brightness(popup.params.tpl.bg_color_0, 50) }} 0%, [bg_color_0] 100%); /* w3c */\r\n	filter: progid:DXImageTransform.Microsoft.gradient( startColorstr=\'{{ adjust_brightness(popup.params.tpl.bg_color_0, 50) }}\', endColorstr=\'[bg_color_0]\',GradientType=1 ); /* ie6-9 */\r\n  	[elseif bg_type_0 == \'img\']\r\n  	background-image: url(\"[bg_img_0]\");\r\n  	background-repeat: no-repeat;\r\n  	background-size: cover;\r\n  	[endif]\r\n}\r\n#ppsPopupShell_[ID] .ppsPopupLabel {\r\n	color: #FFF;\r\n	font-family: \"Myriad Pro\",\"Trebuchet MS\",\"Helvetica Neue\",Helvetica,Arial,Sans-Serif;\r\n	font-size: 30px;\r\n	letter-spacing: -1px;\r\n	line-height: 40px;\r\n	letter-spacing: -1px;\r\n	font-weight: bold;\r\n	text-align: center;\r\n	margin-bottom: 16px;\r\n	padding-left: 20px;\r\n	-moz-text-shadow: 0px 0px 1px #000;\r\n	-webkit-text-shadow: 0px 0px 1px #000;\r\n}\r\n#ppsPopupShell_[ID] .ppsRightCol {\r\n  	height: 100%;\r\n  	[if bg_type_1 == \'color\']\r\n  	background: -moz-radial-gradient(center, ellipse cover, {{ adjust_brightness(popup.params.tpl.bg_color_1, 50) }} 0%, [bg_color_1] 100%); /* ff3.6+ */\r\n	background: -webkit-gradient(radial, center center, 0px, center center, 100%, color-stop(0%, {{ adjust_brightness(popup.params.tpl.bg_color_1, 50) }}), color-stop(100%, [bg_color_1])); /* safari4+,chrome */\r\n	background:-webkit-radial-gradient(center, ellipse cover, {{ adjust_brightness(popup.params.tpl.bg_color_1, 50) }} 0%, [bg_color_1] 100%); /* safari5.1+,chrome10+ */\r\n	background: -o-radial-gradient(center, ellipse cover, {{ adjust_brightness(popup.params.tpl.bg_color_1, 50) }} 0%, [bg_color_1] 100%); /* opera 11.10+ */\r\n	background: -ms-radial-gradient(center, ellipse cover, {{ adjust_brightness(popup.params.tpl.bg_color_1, 50) }} 0%, [bg_color_1] 100%); /* ie10+ */\r\n  background:radial-gradient(ellipse at center, {{ adjust_brightness(popup.params.tpl.bg_color_1, 50) }} 0%, [bg_color_1] 100%); /* w3c */\r\n	filter: progid:DXImageTransform.Microsoft.gradient( startColorstr=\'{{ adjust_brightness(popup.params.tpl.bg_color_1, 50) }}\', endColorstr=\'[bg_color_1]\',GradientType=1 ); /* ie6-9 */\r\n  	[elseif bg_type_1 == \'img\']\r\n  	background-image: url(\"[bg_img_1]\");\r\n  	background-repeat: no-repeat;\r\n  	background-size: cover;\r\n  	[endif]\r\n  \r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell form {\r\n	padding: 10% 15% 0;\r\n	text-align:center;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell input,\r\n#ppsPopupShell_[ID] .ppsSubscribeShell .ppsSubSelect,\r\n#ppsPopupShell_[ID] .ppsSubscribeShell textarea {\r\n  	margin-bottom: 10px;\r\n  	height: 40px;\r\n  	border: 1px solid #d1b36d;\r\n  	color: #888;\r\n	text-shadow: 1px 1px 5px #888;\r\n  	padding: 0;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell input[type=text],#ppsPopupShell_[ID] .ppsSubscribeShell input[type=email],#ppsPopupShell_[ID] .ppsSubscribeShell input[type=password],#ppsPopupShell_[ID] .ppsSubscribeShell input[type=email],\r\n#ppsPopupShell_[ID] .ppsSubscribeShell .ppsSubSelect,\r\n#ppsPopupShell_[ID] .ppsSubscribeShell textarea {\r\n	box-shadow: 2px 2px 2px #dcdcdc inset;\r\n  	font-size: 17px;\r\n	width:100%;\r\n  	background-color: #fff;\r\n  	padding-left: 10px;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell .ppsSubSelect {\r\n	display: table;\r\n  	text-align: left;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell .ppsSubSelectLabel,\r\n#ppsPopupShell_[ID] .ppsSubscribeShell select {\r\n	display: table-cell;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell .ppsSubSelectLabel {\r\n	opacity: 0.5;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell select {\r\n	width: 100%;\r\n  	background-color: transparent;\r\n  	height: 40px;\r\n  	border: none;\r\n  	font-size: 17px;\r\n  	color: #888;\r\n	text-shadow: 1px 1px 5px #888;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell textarea {\r\n	font-family: inherit;\r\n  	height: auto;\r\n    padding-top: 5px;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell input[type=text],#ppsPopupShell_[ID] .ppsSubscribeShell input[type=email],#ppsPopupShell_[ID] .ppsSubscribeShell input[name=\"email\"] {\r\n	background-image: url(\"[PPS_ASSETS_URL]img/assets/mail-icon.png\");\r\n  	background-repeat: no-repeat;\r\n  	background-position: 90% center;\r\n	width:100%;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell input[type=submit] {\r\n	border-color: #000;\r\n	width: 60%;\r\n  	[if bg_type_2 == \'color\']\r\n  	background: [bg_color_2];\r\n   box-shadow: -4px -4px 0px rgba(0, 0, 0, 0.1) inset;\r\n  	[elseif bg_type_2 == \'img\']\r\n  	background-image: url(\"[bg_img_2]\");\r\n  	background-repeat: no-repeat;\r\n  	background-size: cover;\r\n  	[endif]\r\n  \r\n  	color: #fff;\r\n    font-size: 20px;\r\n    text-shadow: 1px 1px 1px #000;\r\n  	cursor: pointer;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell input[type=submit]:hover {\r\n   box-shadow: 4px 4px 0px rgba(0, 0, 0, 0.1) inset;\r\n	\r\n}\r\n#ppsPopupShell_[ID] .ppsPopupTxt_0 {\r\n	float: left;\r\n  	width: 80%;\r\n	margin-left: 10%;\r\n  	text-align: center;\r\n}\r\n#ppsPopupShell_[ID] .ppsPopupTxt_1 {\r\n	float: right;\r\n    [if enb_txt_0]\r\n    width: 50%;\r\n    [else]\r\n    width: 100%;\r\n    [endif]\r\n}\r\n#ppsPopupShell_[ID] .ppsPopupClose {\r\n	background-repeat: no-repeat;\r\n  	cursor: pointer;\r\n  	top:15px;\r\n  	right:10px;\r\n}\r\n#ppsPopupShell_[ID] .ppsPopupClose.ppsPopupClose_lists_black {\r\n 	top: 0 !important;\r\n  	right: 0 !important;\r\n}\r\n#ppsPopupShell_[ID] .ppsPopupClose:hover {\r\n	opacity: 0.8;\r\n}\r\n#ppsPopupShell_[ID] .ppsFootNote{\r\n	color: #585858;\r\n    font-family: \"Helvetica Neue\",Helvetica,Arial,sans-serif;\r\n    font-size: x-small;\r\n    font-style: italic;\r\n    line-height: 14px;\r\n  	margin: 5px 30px;\r\n}\r\n#ppsPopupShell_[ID] .ppsSm{\r\nmargin-top:20px;\r\n}","layered-popup.jpg","1","1","1","1","2015-01-10 18:59:43","1"),
("9","SIGN UP","1","0","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","<link rel=\"stylesheet\" type=\"text/css\" href=\"//fonts.googleapis.com/css?family=Amatic+SC\" />\r\n<div id=\"ppsPopupShell_[ID]\" class=\"ppsPopupShell ppsPopupListsShell\">\r\n	<a href=\"#\" class=\"ppsPopupClose ppsPopupClose_[close_btn]\"></a>\r\n	<div class=\"ppsInnerTblContent\">\r\n		<div class=\"ppsPopupListsInner ppsPopupInner\">\r\n			[if enb_label]\r\n				<div class=\"ppsPopupLabel ppsPopupListsLabel\">[label]</div>\r\n			[endif]\r\n			<div style=\"clear: both;\"></div>\r\n			[if enb_txt_0]\r\n				<div class=\"ppsPopupTxt ppsPopupClassyTxt ppsPopupClassyTxt_0 ppsPopupTxt_0\">\r\n				[txt_0]\r\n				</div>\r\n			[endif]\r\n			[if enb_subscribe]\r\n				<div class=\"ppsSubscribeShell\">\r\n					[sub_form_start]\r\n					[sub_fields_html]\r\n					<input type=\"submit\" name=\"submit\" value=\"[sub_btn_label]\" />\r\n					[sub_form_end]\r\n					<div style=\"clear: both;\"></div>\r\n				</div>\r\n			[endif]\r\n			<div style=\"clear: both;\"></div>\r\n			<div class=\"ppsRightCol\">\r\n				[if enb_sm]\r\n					<div style=\"clear: both;\"></div>\r\n					<div class=\"ppsSm\">\r\n					[sm_html]\r\n					</div>\r\n				[endif]\r\n				[if enb_foot_note]\r\n					<div class=\"ppsFootNote\">\r\n					[foot_note]\r\n					</div>\r\n				[endif]\r\n			</div>\r\n		</div>\r\n	</div>\r\n</div>","#ppsPopupShell_[ID] {\r\n	width: [width][width_measure];\r\n  	padding: 15px;\r\n  	font-family: \'arial\', arial;\r\n	font-size: 13px;\r\n	line-height: 21px;\r\n	font-weight: normal;\r\n	color: #f9e6ce;\r\n}\r\n#ppsPopupShell_[ID] .ppsInnerTblContent {\r\n	display: table;\r\n  	width: 100%;\r\n}\r\n#ppsPopupShell_[ID] .ppsPopupInner {\r\n  {% if popup.params.tpl.enb_subscribe or popup.params.tpl.enb_foot_note or popup.params.tpl.enb_sm %}\r\n  	width: 100%;\r\n  	box-shadow: rgba(192,192,192,1) 0 4px 20px, 6px -6px 0px rgba(0, 0, 0, 0.1) inset;\r\n  	border-radius: 4px;\r\n	[else]\r\n  	width: 100%;\r\n  	[endif]\r\n  	display: table-cell;\r\n	[if bg_type_0 == \'color\']\r\n	background: -moz-radial-gradient(center, ellipse cover, {{ adjust_brightness(popup.params.tpl.bg_color_0, 50) }} 0%, [bg_color_0] 100%); /* ff3.6+ */\r\n	background: -webkit-gradient(radial, center center, 0px, center center, 100%, color-stop(0%, {{ adjust_brightness(popup.params.tpl.bg_color_0, 50) }}), color-stop(100%, [bg_color_0])); /* safari4+,chrome */\r\n	background:-webkit-radial-gradient(center, ellipse cover, {{ adjust_brightness(popup.params.tpl.bg_color_0, 50) }} 0%, [bg_color_0] 100%); /* safari5.1+,chrome10+ */\r\n	background: -o-radial-gradient(center, ellipse cover, {{ adjust_brightness(popup.params.tpl.bg_color_0, 50) }} 0%, [bg_color_0] 100%); /* opera 11.10+ */\r\n	background: -ms-radial-gradient(center, ellipse cover, {{ adjust_brightness(popup.params.tpl.bg_color_0, 50) }} 0%, [bg_color_0] 100%); /* ie10+ */\r\n	background:radial-gradient(ellipse at center, {{ adjust_brightness(popup.params.tpl.bg_color_0, 50) }} 0%, [bg_color_0] 100%); /* w3c */\r\n	filter: progid:DXImageTransform.Microsoft.gradient( startColorstr=\'{{ adjust_brightness(popup.params.tpl.bg_color_0, 50) }}\', endColorstr=\'[bg_color_0]\',GradientType=1 ); /* ie6-9 */\r\n  	[elseif bg_type_0 == \'img\']\r\n  	background-image: url(\"[bg_img_0]\");\r\n  	background-repeat: no-repeat;\r\n  	background-size: cover;\r\n  	[endif]\r\n  	\r\n}\r\n#ppsPopupShell_[ID] .ppsPopupLabel {\r\n	color: #FFF;\r\n	font-family: \'Amatic SC\', arial;\r\n	font-size: 45px;\r\n	letter-spacing: -1px;\r\n	line-height: 40px;\r\n	letter-spacing: -1px;\r\n	font-weight: bold;\r\n	margin-top: 15px;\r\n	margin-bottom: 16px;\r\n	padding-left: 20px;\r\n	-moz-text-shadow: 0px 0px 1px #000;\r\n	-webkit-text-shadow: 0px 0px 1px #000;\r\n}\r\n\r\n#ppsPopupShell_[ID] .ppsSubscribeShell form {\r\n	padding: 10% 10% 5% 5%;\r\n	text-align:right;\r\n	margin-bottom: 20px;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell input,\r\n#ppsPopupShell_[ID] .ppsSubscribeShell .ppsSubSelect,\r\n#ppsPopupShell_[ID] .ppsSubscribeShell textarea {\r\n	/*width: 100%;*/\r\n  	margin-bottom: 10px;\r\n  	height: 40px;\r\n  	border: 0px solid #d1b36d;\r\n	border-radius: 4px !important;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell input[type=text],#ppsPopupShell_[ID] .ppsSubscribeShell input[type=email],#ppsPopupShell_[ID] .ppsSubscribeShell input[type=password],#ppsPopupShell_[ID] .ppsSubscribeShell input[type=email],\r\n#ppsPopupShell_[ID] .ppsSubscribeShell .ppsSubSelect,\r\n#ppsPopupShell_[ID] .ppsSubscribeShell textarea {\r\n	box-shadow: 2px 2px 2px #dcdcdc inset;\r\n  	padding-left: 20px;\r\n  	font-size: 17px;\r\n	width:100%;\r\n  	background-color: #fff;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell .ppsSubSelect {\r\n	display: table;\r\n  	text-align: left;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell .ppsSubSelectLabel,\r\n#ppsPopupShell_[ID] .ppsSubscribeShell select {\r\n	display: table-cell;\r\n  	color: #000;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell .ppsSubSelectLabel {\r\n	opacity: 0.5;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell select {\r\n	width: 100%;\r\n  	background-color: transparent;\r\n  	height: 40px;\r\n  	border: none;\r\n  	margin-left: -4px;\r\n  	font-size: 17px;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell textarea {\r\n	font-family: inherit;\r\n  	height: auto;\r\n    padding-top: 5px;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell input[type=text],#ppsPopupShell_[ID] .ppsSubscribeShell input[type=email],#ppsPopupShell_[ID] .ppsSubscribeShell input[name=\"email\"] {\r\n	background-image: url(\"[PPS_ASSETS_URL]img/assets/email-icon.png\");\r\n  	background-repeat: no-repeat;\r\n	width:100%;\r\n	background-attachment: scroll;\r\n	background-position: 0px center;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell input[type=submit] {\r\n	border-color: #000;\r\n	width: 60%;\r\n  	[if bg_type_1 == \'color\']\r\n  	background: [bg_color_1] 100%;\r\n   	box-shadow: -4px -4px 0px rgba(0, 0, 0, 0.1) inset;\r\n  	background-image: none;\r\n  	[elseif bg_type_1 == \'img\']\r\n  	background-image: url(\"[bg_img_1]\");\r\n  	background-repeat: no-repeat;\r\n  	background-size: cover;\r\n  	[endif]\r\n  \r\n  	color: #fff;\r\n    font-size: 20px;\r\n    text-shadow: 1px 1px 1px #000;\r\n  	cursor: pointer;\r\n  	padding: 0 6px;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell input[type=submit]:hover {\r\n   box-shadow: 4px 4px 0px rgba(0, 0, 0, 0.1) inset;\r\n}\r\n#ppsPopupShell_[ID] .ppsPopupTxt_0 {\r\n	float: left;\r\n  	width: 80%;\r\n	margin-left: 10%;\r\n	text-align: justify;\r\n}\r\n#ppsPopupShell_[ID] .ppsPopupClose {\r\n	background-repeat: no-repeat;\r\n  	cursor: pointer;\r\n	top: 15px;\r\n  	top:15px;\r\n  	right:10px;\r\n}\r\n#ppsPopupShell_[ID] .ppsPopupClose.ppsPopupClose_lists_black {\r\n 	top: 0 !important;\r\n  	right: 0 !important;\r\n}\r\n#ppsPopupShell_[ID] .ppsPopupClose:hover {\r\n	opacity: 0.8;\r\n}\r\n#ppsPopupShell_[ID] .ppsFootNote{\r\n	color: #585858;\r\n    font-family: \"Helvetica Neue\",Helvetica,Arial,sans-serif;\r\n    font-size: x-small;\r\n    font-style: italic;\r\n    line-height: 14px;\r\n  	margin: 5px 30px;\r\n}\r\n#ppsPopupShell_[ID] .ppsSm{\r\n	margin-top:20px;\r\n}\r\n#ppsPopupShell_[ID] input[name=\"name\"] {\r\n    background-image: url(\"[PPS_ASSETS_URL]img/assets/user-icon.png\");\r\n    background-repeat: no-repeat;\r\n    background-attachment: scroll;\r\n    background-position: 0px center;\r\n}","sing-up.jpg","1","1","1","1","2015-01-10 18:59:43","3"),
("10","Informed","1","0","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","<link rel=\"stylesheet\" type=\"text/css\" href=\"//fonts.googleapis.com/css?family=Amatic+SC\" />\r\n<div id=\"ppsPopupShell_[ID]\" class=\"ppsPopupShell ppsPopupListsShell\">\r\n	<a href=\"#\" class=\"ppsPopupClose ppsPopupClose_[close_btn]\"></a>\r\n	<div class=\"ppsInnerTblContent\">\r\n		<div class=\"ppsPopupListsInner ppsPopupInner\">\r\n			[if enb_label]\r\n				<div class=\"ppsPopupLabel ppsPopupListsLabel\">[label]</div>\r\n			[endif]\r\n			<div style=\"clear: both;\"></div>\r\n			[if enb_txt_0]\r\n				<div class=\"ppsPopupTxt ppsPopupClassyTxt ppsPopupClassyTxt_0 ppsPopupTxt_0\">\r\n				[txt_0]\r\n				</div>\r\n			[endif]\r\n			[if enb_subscribe]\r\n				<div class=\"ppsSubscribeShell\">\r\n					[sub_form_start]\r\n					[sub_fields_html]\r\n					<input class=\"butt\" type=\"submit\" name=\"submit\" value=\"[sub_btn_label]\" />\r\n					[sub_form_end]\r\n					<div style=\"clear: both;\"></div>\r\n				</div>\r\n			[endif]\r\n			<div style=\"clear: both;\"></div>\r\n			<div class=\"ppsRightCol\">\r\n				[if enb_sm]\r\n					<div style=\"clear: both;\"></div>\r\n					<div class=\"ppsSm\">\r\n					[sm_html]\r\n					</div>\r\n				[endif]\r\n				[if enb_foot_note]\r\n					<div class=\"ppsFootNote\">\r\n					[foot_note]\r\n					</div>\r\n				[endif]\r\n			</div>\r\n		</div>\r\n	</div>\r\n</div>","#ppsPopupShell_[ID] {\r\n	width: [width][width_measure];\r\n  	padding: 15px;\r\n  	font-family: \'arial\', arial;\r\n	font-size: 13px;\r\n	line-height: 21px;\r\n	font-weight: normal;\r\n}\r\n#ppsPopupShell_[ID] .ppsPopupInner {\r\n  {% if popup.params.tpl.enb_subscribe or popup.params.tpl.enb_foot_note or popup.params.tpl.enb_sm %}\r\n  	width: 100%;\r\n  	border-radius: 4px;\r\n	[else]\r\n  	width: 100%;\r\n  	[endif]\r\n  	padding: 10px;\r\n	[if bg_type_0 == \'color\']\r\n	background: -moz-radial-gradient(center, ellipse cover, {{ adjust_brightness(popup.params.tpl.bg_color_0, 50) }} 0%, [bg_color_0] 100%); /* ff3.6+ */\r\n	background: -webkit-gradient(radial, center center, 0px, center center, 100%, color-stop(0%, {{ adjust_brightness(popup.params.tpl.bg_color_0, 50) }}), color-stop(100%, [bg_color_0])); /* safari4+,chrome */\r\n	background:-webkit-radial-gradient(center, ellipse cover, {{ adjust_brightness(popup.params.tpl.bg_color_0, 50) }} 0%, [bg_color_0] 100%); /* safari5.1+,chrome10+ */\r\n	background: -o-radial-gradient(center, ellipse cover, {{ adjust_brightness(popup.params.tpl.bg_color_0, 50) }} 0%, [bg_color_0] 100%); /* opera 11.10+ */\r\n	background: -ms-radial-gradient(center, ellipse cover, {{ adjust_brightness(popup.params.tpl.bg_color_0, 50) }} 0%, [bg_color_0] 100%); /* ie10+ */\r\n	background:radial-gradient(ellipse at center, {{ adjust_brightness(popup.params.tpl.bg_color_0, 50) }} 0%, [bg_color_0] 100%); /* w3c */\r\n	filter: progid:DXImageTransform.Microsoft.gradient( startColorstr=\'{{ adjust_brightness(popup.params.tpl.bg_color_0, 50) }}\', endColorstr=\'[bg_color_0]\',GradientType=1 ); /* ie6-9 */\r\n  	[elseif bg_type_0 == \'img\']\r\n  	background-image: url(\"[bg_img_0]\");\r\n  	background-repeat: no-repeat;\r\n  	background-size: cover;\r\n  	[endif]\r\n  	\r\n}\r\n#ppsPopupShell_[ID] .ppsPopupLabel {\r\n	color: #000;\r\n	text-align: center;\r\n	font-size: 45px;\r\n	letter-spacing: -1px;\r\n	line-height: 40px;\r\n	letter-spacing: -1px;\r\n	font-weight: bold;\r\n	margin-top: 15px;\r\n	margin-bottom: 16px;\r\n	padding-left: 20px;\r\n	-moz-text-shadow: 0px 0px 1px #000;\r\n	-webkit-text-shadow: 0px 0px 1px #000;\r\n}\r\n\r\n#ppsPopupShell_[ID] .ppsSubscribeShell form {\r\n	padding: 1% 1% 1% 1%;\r\n	text-align:right;\r\n	margin-bottom: 20px;\r\n  	padding-left: 20px;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell input,\r\n#ppsPopupShell_[ID] .ppsSubscribeShell .ppsSubSelect,\r\n#ppsPopupShell_[ID] .ppsSubscribeShell textarea {\r\n	/*width: 100%;*/\r\n  	margin-bottom: 10px;\r\n  	height: 40px;\r\n  	border: 0px solid #d1b36d;\r\n	border-radius: 4px !important;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell input[type=text],#ppsPopupShell_[ID] .ppsSubscribeShell input[type=email],#ppsPopupShell_[ID] .ppsSubscribeShell input[type=password],#ppsPopupShell_[ID] .ppsSubscribeShell input[type=email],\r\n#ppsPopupShell_[ID] .ppsSubscribeShell .ppsSubSelect,\r\n#ppsPopupShell_[ID] .ppsSubscribeShell textarea {\r\n	box-shadow: 2px 2px 2px #dcdcdc inset;\r\n  	padding-left: 20px;\r\n  	font-size: 17px;\r\n	width: 100%;\r\n  	max-width: 284px;\r\n	display: block;\r\n	float: left;\r\n  	border: 1px solid #000;\r\n  	background-color: #fff;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell .ppsSubSelect {\r\n	display: table;\r\n  	text-align: left;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell .ppsSubSelectLabel,\r\n#ppsPopupShell_[ID] .ppsSubscribeShell select {\r\n	display: table-cell;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell .ppsSubSelectLabel {\r\n	opacity: 0.5;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell select {\r\n	width: 100%;\r\n  	background-color: transparent;\r\n  	height: 40px;\r\n  	border: none;\r\n  	font-size: 17px;\r\n	border-top-right-radius: 4px;\r\n  	border-bottom-right-radius: 4px;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell textarea {\r\n	font-family: inherit;\r\n  	height: auto;\r\n    padding-top: 5px;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell input[type=text],#ppsPopupShell_[ID] .ppsSubscribeShell input[type=email],#ppsPopupShell_[ID] .ppsSubscribeShell input[name=\"email\"] {\r\n	width:75%;\r\n	background-attachment: scroll;\r\n	background-position: 0px center;\r\n  	border: 1px solid #000;\r\n  	display:block;\r\n  	float:left;\r\n  	padding-left:20px;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell input[type=submit] {\r\n	border-color: #000;\r\n	line-height: 1;\r\n  	display:block;\r\n  	float: left;\r\n	margin-left: 10px;\r\n  	padding: 10px;\r\n  	[if bg_type_1 == \'color\']\r\n  	background: [bg_color_1] 100%;\r\n   box-shadow: -4px -4px 0px rgba(0, 0, 0, 0.1) inset;\r\n  	background-image: none;\r\n  	[elseif bg_type_1 == \'img\']\r\n  	background-image: url(\"[bg_img_1]\");\r\n  	background-repeat: no-repeat;\r\n  	background-size: cover;\r\n  	[endif]\r\n  \r\n  	color: #fff;\r\n    font-size: 20px;\r\n    text-shadow: 1px 1px 1px #000;\r\n  	cursor: pointer;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell input[type=submit]:hover {\r\n   box-shadow: 4px 4px 0px rgba(0, 0, 0, 0.1) inset;\r\n	\r\n}\r\n#ppsPopupShell_[ID] .ppsPopupTxt_0 {\r\n	float: left;\r\n  	width: 80%;\r\n	margin-left: 10%;\r\n	text-align: center;\r\n	color: black;\r\n}\r\n\r\n#ppsPopupShell_[ID] .ppsPopupClose {\r\n	background-repeat: no-repeat;\r\n  	cursor: pointer;\r\n	top: 15px;\r\n}\r\n#ppsPopupShell_[ID] .ppsPopupClose.ppsPopupClose_lists_black {\r\n 	top: 0 !important;\r\n  	right: 0 !important;\r\n}\r\n#ppsPopupShell_[ID] .ppsPopupClose:hover {\r\n	opacity: 0.8;\r\n}\r\n#ppsPopupShell_[ID] .ppsFootNote{\r\n	color: #585858;\r\n    font-family: \"Helvetica Neue\",Helvetica,Arial,sans-serif;\r\n    font-size: x-small;\r\n    font-style: italic;\r\n    line-height: 14px;\r\n  	margin: 5px 30px;\r\n}\r\n#ppsPopupShell_[ID] .ppsSm{\r\n	margin-top:20px;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubMsg{\r\n	clear: both;\r\n  	text-align: left;\r\n}\r\n\r\n\r\n\r\n","informed.jpg","1","1","1","1","2015-01-10 18:59:43","5"),
("11","START popup","1","0","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","<div id=\"ppsPopupShell_[ID]\" class=\"ppsPopupShell ppsPopupListsShell\">\r\n	<a href=\"#\" class=\"ppsPopupClose ppsPopupClose_[close_btn]\"></a>\r\n	<div class=\"ppsInnerTblContent\">\r\n		<div class=\"ppsPopupListsInner ppsPopupInner\">\r\n			[if enb_label]\r\n				<div class=\"ppsPopupLabel ppsPopupListsLabel\">[label]</div>\r\n			[endif]\r\n			<div style=\"clear: both;\"></div>\r\n			[if enb_txt_0]\r\n				<div class=\"ppsPopupTxt ppsPopupClassyTxt ppsPopupClassyTxt_0 ppsPopupTxt_0\">\r\n				[txt_0]\r\n				</div>\r\n			[endif]\r\n		</div>\r\n		<div class=\"ppsRightCol\">\r\n			[if enb_txt_1]\r\n				<div class=\"ppsPopupTxt ppsPopupClassyTxt ppsPopupClassyTxt_1 ppsPopupTxt_1\">\r\n				[txt_1]\r\n				</div>\r\n			[endif]\r\n			<div style=\"clear: both;\"></div>\r\n			[if enb_subscribe]\r\n				<div class=\"ppsSubscribeShell\">\r\n					[sub_form_start]\r\n					[sub_fields_html]\r\n					<input type=\"submit\" name=\"submit\" value=\"[sub_btn_label]\" />\r\n					[sub_form_end]\r\n					<div style=\"clear: both;\"></div>\r\n				</div>\r\n			[endif]\r\n			[if enb_sm]\r\n				<div class=\"ppsSm\">\r\n				[sm_html]\r\n				</div>\r\n			[endif]\r\n			[if enb_foot_note]\r\n				<div class=\"ppsFootNote\">\r\n				[foot_note]\r\n				</div>\r\n			[endif]\r\n		</div>\r\n	</div>\r\n</div>","#ppsPopupShell_[ID] {\r\n	width: [width][width_measure];\r\n  	padding: 15px;\r\n  	font-family: Georgia, Times, serif;\r\n	font-size: 13px;\r\n	line-height: 21px;\r\n	font-weight: normal;\r\n	color: #000;\r\n}\r\n#ppsPopupShell_[ID], #ppsPopupShell_[ID] * {\r\n	-webkit-box-sizing: border-box;\r\n	-moz-box-sizing:    border-box;\r\n	box-sizing:         border-box;\r\n}\r\n#ppsPopupShell_[ID] .ppsInnerTblContent {\r\n	display: block;\r\n}\r\n#ppsPopupShell_[ID] .ppsPopupInner {\r\n  {% if popup.params.tpl.enb_subscribe or popup.params.tpl.enb_foot_note or popup.params.tpl.enb_sm %}\r\n  	width: 60%;\r\n  	box-shadow: rgba(32,32,32,1) 0 4px 20px;\r\n  	border-radius:3px;\r\n	[else]\r\n  	width: 100%;\r\n  	[endif]\r\n  	display: block;\r\n  	float: left;\r\n  	margin-top: 30px;\r\n	[if bg_type_0 == \'color\']\r\n	background: -moz-radial-gradient(center, ellipse cover, {{ adjust_brightness(popup.params.tpl.bg_color_0, 50) }} 0%, [bg_color_0] 100%); /* ff3.6+ */\r\n	background: -webkit-gradient(radial, center center, 0px, center center, 100%, color-stop(0%, {{ adjust_brightness(popup.params.tpl.bg_color_0, 50) }}), color-stop(100%, [bg_color_0])); /* safari4+,chrome */\r\n	background:-webkit-radial-gradient(center, ellipse cover, {{ adjust_brightness(popup.params.tpl.bg_color_0, 50) }} 0%, [bg_color_0] 100%); /* safari5.1+,chrome10+ */\r\n	background: -o-radial-gradient(center, ellipse cover, {{ adjust_brightness(popup.params.tpl.bg_color_0, 50) }} 0%, [bg_color_0] 100%); /* opera 11.10+ */\r\n	background: -ms-radial-gradient(center, ellipse cover, {{ adjust_brightness(popup.params.tpl.bg_color_0, 50) }} 0%, [bg_color_0] 100%); /* ie10+ */\r\n	background:radial-gradient(ellipse at center, {{ adjust_brightness(popup.params.tpl.bg_color_0, 50) }} 0%, [bg_color_0] 100%); /* w3c */\r\n	filter: progid:DXImageTransform.Microsoft.gradient( startColorstr=\'{{ adjust_brightness(popup.params.tpl.bg_color_0, 50) }}\', endColorstr=\'[bg_color_0]\',GradientType=1 ); /* ie6-9 */\r\n  	[elseif bg_type_0 == \'img\']\r\n  	background-image: url(\"[bg_img_0]\");\r\n  	background-repeat: no-repeat;\r\n  	background-size: cover;\r\n  	[endif]\r\n  	\r\n}\r\n#ppsPopupShell_[ID] .ppsPopupLabel {\r\n	color: #56912d;\r\n	font-family: \'arial\', arial;\r\n	font-size: 30px;\r\n	letter-spacing: -1px;\r\n	line-height: 40px;\r\n	letter-spacing: -1px;\r\n	font-weight: bold;\r\n	margin-top: 15px;\r\n	padding-left: 20px;\r\n	text-shadow: 0px 0px 1px #56912d;\r\n	-moz-text-shadow: 0px 0px 1px #56912d;\r\n	-webkit-text-shadow: 0px 0px 1px #56912d;\r\n  	\r\n}\r\n#ppsPopupShell_[ID] .ppsRightCol {\r\n	display: table-cell;\r\n  	border-radius:3px;\r\n  	width: 40%;\r\n  	height: 110%;\r\n	display: block;\r\n  	float: right;\r\n  	box-shadow: rgba(32,32,32,1) 0 4px 20px;\r\n  	padding: 10px 0;\r\n  	[if bg_type_1 == \'color\']\r\n  	background: -moz-radial-gradient(center, ellipse cover, {{ adjust_brightness(popup.params.tpl.bg_color_1, 50) }} 0%, [bg_color_1] 100%); /* ff3.6+ */\r\n	background: -webkit-gradient(radial, center center, 0px, center center, 100%, color-stop(0%, {{ adjust_brightness(popup.params.tpl.bg_color_1, 50) }}), color-stop(100%, [bg_color_1])); /* safari4+,chrome */\r\n	background:-webkit-radial-gradient(center, ellipse cover, {{ adjust_brightness(popup.params.tpl.bg_color_1, 50) }} 0%, [bg_color_1] 100%); /* safari5.1+,chrome10+ */\r\n	background: -o-radial-gradient(center, ellipse cover, {{ adjust_brightness(popup.params.tpl.bg_color_1, 50) }} 0%, [bg_color_1] 100%); /* opera 11.10+ */\r\n	background: -ms-radial-gradient(center, ellipse cover, {{ adjust_brightness(popup.params.tpl.bg_color_1, 50) }} 0%, [bg_color_1] 100%); /* ie10+ */\r\n  background:radial-gradient(ellipse at center, {{ adjust_brightness(popup.params.tpl.bg_color_1, 50) }} 0%, [bg_color_1] 100%); /* w3c */\r\n	filter: progid:DXImageTransform.Microsoft.gradient( startColorstr=\'{{ adjust_brightness(popup.params.tpl.bg_color_1, 50) }}\', endColorstr=\'[bg_color_1]\',GradientType=1 ); /* ie6-9 */\r\n  	[elseif bg_type_1 == \'img\']\r\n  	background-image: url(\"[bg_img_1]\");\r\n  	background-repeat: no-repeat;\r\n  	background-size: cover;\r\n  	[endif]\r\n  \r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell form {\r\n	padding: 30px 30px 0;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell input,\r\n#ppsPopupShell_[ID] .ppsSubscribeShell .ppsSubSelect,\r\n#ppsPopupShell_[ID] .ppsSubscribeShell textarea {\r\n	width: 100%;\r\n  	margin-bottom: 10px;\r\n  	height: 40px;\r\n  	border: 1px solid #d1b36d;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell input[type=text],#ppsPopupShell_[ID] .ppsSubscribeShell input[type=email],#ppsPopupShell_[ID] .ppsSubscribeShell input[type=password],#ppsPopupShell_[ID] .ppsSubscribeShell input[type=email],\r\n#ppsPopupShell_[ID] .ppsSubscribeShell .ppsSubSelect,\r\n#ppsPopupShell_[ID] .ppsSubscribeShell textarea {\r\n	box-shadow: 2px 2px 2px #dcdcdc inset;\r\n  	padding-left: 22px;\r\n  	font-size: 17px;\r\n	background-image: url(\"[PPS_ASSETS_URL]img/assets/user-black-icon.png\");\r\n  	background-repeat: no-repeat;\r\n  	background-position: 5px center;\r\n  	border-radius: 2px !important;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell .ppsSubSelect {\r\n	display: table;\r\n  	text-align: left;\r\n  	background-color: #fff;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell .ppsSubSelectLabel,\r\n#ppsPopupShell_[ID] .ppsSubscribeShell select {\r\n	display: table-cell;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell .ppsSubSelectLabel {\r\n	opacity: 0.5;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell select {\r\n	width: 100%;\r\n  	background-color: transparent;\r\n  	height: 40px;\r\n  	border: none;\r\n  	font-size: 17px;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell textarea {\r\n	font-family: inherit;\r\n  	height: auto;\r\n    padding-top: 5px;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell input[type=text],#ppsPopupShell_[ID] .ppsSubscribeShell input[type=email],#ppsPopupShell_[ID] .ppsSubscribeShell input[name=\"email\"] {\r\n	background-image: url(\"[PPS_ASSETS_URL]img/assets/email-black-icon.png\");\r\n  	background-repeat: no-repeat;\r\n  	background-position: 5px center;\r\n  	border-radius: 2px !important;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell input[type=submit] {\r\n  	[if bg_type_2 == \'color\']\r\n  	background: [bg_color_2];\r\n    background-image: none;\r\n  	[elseif bg_type_2 == \'img\']\r\n  	background-image: url(\"[bg_img_2]\");\r\n  	background-repeat: no-repeat;\r\n  	background-size: cover;\r\n  	[endif]\r\n  \r\n  	color: #fff;\r\n    font-size: 20px;\r\n    text-shadow: 2px 2px 2px #000;\r\n  	cursor: pointer;\r\n    line-height: 1;\r\n  	padding: .2180469716em 1.41575em;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell input[type=submit]:hover {\r\n	box-shadow: inset 1px 1px 3px #666;\r\n}\r\n#ppsPopupShell_[ID] .ppsPopupTxt_0 {\r\n	float: left;\r\n  	width: 100%;\r\n  	color: #888888;\r\n  	font-family: \'arial\', arial;\r\n	font-weight: 400;\r\n	line-height: 1.3;\r\n  	font-size: 14px;\r\n}\r\n#ppsPopupShell_[ID] .ppsPopupTxt_1 , #ppsPopupShell_[ID] .ppsPopupTxt_1  * {\r\n  	color:#ffffff;\r\n  	font-family: \'arial\', arial;\r\n  	font-weight: 700;\r\n  	text-shadow: #000000 1px 1px 1px;\r\n  	font-size: 25px;\r\n  	padding: 0 10px;\r\n  	margin: 0;\r\n  	letter-spacing: -1px;\r\n  	text-align: center;\r\n  	line-height: 1.475;\r\n    [if enb_txt_0]\r\n    width: 95;\r\n    [else]\r\n    width: 95%;\r\n    [endif]\r\n}\r\n#ppsPopupShell_[ID] .ppsPopupClose {\r\n	background-repeat: no-repeat;\r\n  	cursor: pointer;\r\n  	top:-20px;\r\n  	right:1px;\r\n  	z-index:99999;\r\n}\r\n#ppsPopupShell_[ID] .ppsPopupClose.ppsPopupClose_lists_black {\r\n 	top: 0 !important;\r\n  	right: 0 !important;\r\n}\r\n#ppsPopupShell_[ID] .ppsPopupClose:hover {\r\n	opacity: 0.8;\r\n}\r\n#ppsPopupShell_[ID] .ppsFootNote{\r\n	color: #585858;\r\n    font-family: \"Helvetica Neue\",Helvetica,Arial,sans-serif;\r\n    font-size: x-small;\r\n    font-style: italic;\r\n    line-height: 14px;\r\n  	margin: 5px 30px;\r\n}\r\n\r\n#ppsPopupShell_[ID] p{\r\n	margin-left:20px;\r\n}\r\n#ppsPopupShell_[ID] b{\r\n	color: #000;\r\n}\r\n#ppsPopupShell_[ID] ul li {\r\n	height:30px;\r\n}\r\n#ppsPopupShell_[ID] ul {\r\n	margin: 14px 0;\r\n  	padding: 0 0 0 40px;\r\n}","start-popup.jpg","1","1","1","1","2015-01-10 18:59:43","26"),
("12","Nature","1","0","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","<div id=\"ppsPopupShell_[ID]\" class=\"ppsPopupShell ppsPopupListsShell\">\r\n	<a href=\"#\" class=\"ppsPopupClose ppsPopupClose_[close_btn]\"></a>\r\n	<div class=\"ppsInnerTblContent\">\r\n		<div class=\"ppsPopupListsInner ppsPopupInner\">\r\n			[if enb_label]\r\n				<div class=\"label-window\">\r\n					<div class=\"ppsPopupLabel ppsPopupListsLabel\">[label]</div>\r\n				</div>\r\n			[endif]\r\n			<div style=\"clear: both;\"></div>\r\n			<div class=\"ppsRightCol\">\r\n				[if enb_txt_0]\r\n					<div class=\"ppsPopupTxt ppsPopupClassyTxt ppsPopupClassyTxt_0 ppsPopupTxt_0\">\r\n					[txt_0]\r\n					</div>\r\n				[endif]\r\n				<div style=\"clear: both;\"></div>\r\n				[if enb_subscribe]\r\n					<div class=\"ppsSubscribeShell\">\r\n						[sub_form_start]\r\n						[sub_fields_html]\r\n						<input type=\"submit\" name=\"submit\" value=\"[sub_btn_label]\" />\r\n						[sub_form_end]\r\n						<div style=\"clear: both;\"></div>\r\n					</div>\r\n				[endif]\r\n				[if enb_sm]\r\n					<div class=\"ppsSm\">\r\n					[sm_html]\r\n					</div>\r\n				[endif]\r\n				[if enb_foot_note]\r\n					<div class=\"ppsFootNote\">\r\n					[foot_note]\r\n					</div>\r\n				[endif]\r\n			</div>\r\n		</div>\r\n	</div>\r\n</div>","#ppsPopupShell_[ID] {\r\n	width: [width][width_measure];\r\n  	padding: 15px;\r\n  	font-family: Georgia, Times, serif;\r\n	font-size: 13px;\r\n	line-height: 21px;\r\n	font-weight: normal;\r\n	color: #000;\r\n}\r\n#ppsPopupShell_[ID] .ppsInnerTblContent {\r\n	display: table;\r\n  [if bg_type_0 == \'color\']\r\n	background: -moz-radial-gradient(center, ellipse cover, {{ adjust_brightness(popup.params.tpl.bg_color_0, 50) }} 0%, [bg_color_0] 100%); /* ff3.6+ */\r\n	background: -webkit-gradient(radial, center center, 0px, center center, 100%, color-stop(0%, {{ adjust_brightness(popup.params.tpl.bg_color_0, 50) }}), color-stop(100%, [bg_color_0])); /* safari4+,chrome */\r\n	background:-webkit-radial-gradient(center, ellipse cover, {{ adjust_brightness(popup.params.tpl.bg_color_0, 50) }} 0%, [bg_color_0] 100%); /* safari5.1+,chrome10+ */\r\n	background: -o-radial-gradient(center, ellipse cover, {{ adjust_brightness(popup.params.tpl.bg_color_0, 50) }} 0%, [bg_color_0] 100%); /* opera 11.10+ */\r\n	background: -ms-radial-gradient(center, ellipse cover, {{ adjust_brightness(popup.params.tpl.bg_color_0, 50) }} 0%, [bg_color_0] 100%); /* ie10+ */\r\n	background:radial-gradient(ellipse at center, {{ adjust_brightness(popup.params.tpl.bg_color_0, 50) }} 0%, [bg_color_0] 100%); /* w3c */\r\n	filter: progid:DXImageTransform.Microsoft.gradient( startColorstr=\'{{ adjust_brightness(popup.params.tpl.bg_color_0, 50) }}\', endColorstr=\'[bg_color_0]\',GradientType=1 ); /* ie6-9 */\r\n  	[elseif bg_type_0 == \'img\']\r\n  	background-image: url(\"[bg_img_0]\");\r\n  	background-repeat: no-repeat;\r\n  	background-size: cover;\r\n  	[endif]\r\n}\r\n#ppsPopupShell_[ID] .ppsPopupInner {\r\n  {% if popup.params.tpl.enb_subscribe or popup.params.tpl.enb_foot_note or popup.params.tpl.enb_sm %}\r\n  	width: 50%;\r\n	[else]\r\n  	width: 100%;\r\n  	[endif]\r\n  	display: table-cell;\r\n}\r\n#ppsPopupShell_[ID] .label-window{\r\n    background-color: rgba(10,10,10,0.6);\r\n    width: 70%;\r\n    padding-top: 10px;\r\n    padding-bottom: 10px;\r\n    margin-top: 20px;\r\n}\r\n\r\n#ppsPopupShell_[ID] .ppsPopupLabel {\r\n	color: #000;\r\n	font-family: \'Open Sans\', arial;\r\n	font-size: 28px;\r\n	font-weight: 100;\r\n	color: #ffffff;\r\n	text-shadow: #000000 1px 1px 1px;\r\n	margin-top: 15px;\r\n	margin-bottom: 16px;\r\n	padding-left: 20px;\r\n}\r\n#ppsPopupShell_[ID] .ppsRightCol {\r\n	/*display: table-cell;*/\r\n  	float:right;\r\n  	width: 50%;\r\n  	height: 100%;\r\n  	margin-bottom: 30px;\r\n  	margin-top: 65px;\r\n  	[if bg_type_1 == \'color\']\r\n  	background-color: rgba(0,0,0,0.7);\r\n  	background-repeat: no-repeat;\r\n  	background-size: cover;\r\n  	[endif]\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell form {\r\n	padding: 30px 30px 0;\r\n	text-align: right;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell input,\r\n#ppsPopupShell_[ID] .ppsSubscribeShell .ppsSubSelect,\r\n#ppsPopupShell_[ID] .ppsSubscribeShell textarea {\r\n	width: 100%;\r\n  	margin-bottom: 10px;\r\n  	height: 40px;\r\n  	border: none;\r\n  	border-radius: 3px;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell input[type=text],#ppsPopupShell_[ID] .ppsSubscribeShell input[type=email],#ppsPopupShell_[ID] .ppsSubscribeShell input[type=password],#ppsPopupShell_[ID] .ppsSubscribeShell input[type=email],\r\n#ppsPopupShell_[ID] .ppsSubscribeShell .ppsSubSelect,\r\n#ppsPopupShell_[ID] .ppsSubscribeShell textarea {\r\n  	background-color: rgba(0,0,0,0.8) !important;\r\n  	padding-left: 10px;\r\n  	font-size: 17px;\r\n  	color: #fff;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell .ppsSubSelect {\r\n	display: table;\r\n  	text-align: left;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell .ppsSubSelectLabel,\r\n#ppsPopupShell_[ID] .ppsSubscribeShell select {\r\n	display: table-cell;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell .ppsSubSelectLabel {\r\n	opacity: 0.5;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell select {\r\n	width: 100%;\r\n  	background-color: transparent;\r\n  	height: 40px;\r\n  	border: none;\r\n  	font-size: 17px;\r\n  	color: #fff;\r\n  	border-top-right-radius: 3px;\r\n  	border-bottom-right-radius: 3px;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell select option {\r\n	color: #000;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell textarea {\r\n	font-family: inherit;\r\n  	height: auto;\r\n    padding-top: 5px;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell input[type=submit] {\r\n	border-color: #000;\r\n  	font-family: \'Open Sans\', arial;\r\n	font-weight: 100;\r\n	color: #ffffff;\r\n  	width: 60%;\r\n	text-shadow: #000000 1px 1px 1px;\r\n  	[if bg_type_1 == \'color\']\r\n  	background: [bg_color_1];\r\n    background: -moz-linear-gradient(90deg, [bg_color_2] 0%, {{ adjust_brightness(popup.params.tpl.bg_color_2, 100) }} 63%);\r\n    background: -webkit-linear-gradient(270deg, [bg_color_2] 0%, {{ adjust_brightness(popup.params.tpl.bg_color_2, 100) }} 63%);\r\n    background: -o-linear-gradient(270deg, [bg_color_2] 0%, {{ adjust_brightness(popup.params.tpl.bg_color_2, 100) }} 63%);\r\n    background: -ms-linear-gradient(270deg, [bg_color_2] 0%, {{ adjust_brightness(popup.params.tpl.bg_color_2, 100) }} 63%);\r\n    background: linear-gradient(0deg, [bg_color_2]) 0%, {{ adjust_brightness(popup.params.tpl.bg_color_2, 100) }} 63%);\r\n  	[elseif bg_type_1 == \'img\']\r\n  	background-image: url(\"[bg_img_1]\");\r\n  	background-repeat: no-repeat;\r\n  	background-size: cover;\r\n  	[endif]\r\n  \r\n  	\r\n  	cursor: pointer;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell input[type=submit]:hover {\r\n	box-shadow: inset 1px 1px 3px #666;\r\n}\r\n#ppsPopupShell_[ID] .ppsPopupTxt_0 {\r\n  	text-align: center;\r\n  	font-family: \'Open Sans\', arial;\r\n 	font-weight: 100;\r\n	color: #ffffff;\r\n	text-shadow: #000000 1px 1px 1px;\r\n  	font-size: 14px;\r\n}\r\n\r\n#ppsPopupShell_[ID] .ppsPopupTxt_0 {\r\n  	margin: 20px;\r\n}\r\n\r\n#ppsPopupShell_[ID] .ppsPopupClose {\r\n	background-repeat: no-repeat;\r\n  	cursor: pointer;\r\n}\r\n#ppsPopupShell_[ID] .ppsPopupClose.ppsPopupClose_lists_black {\r\n 	top: 0 !important;\r\n  	right: 0 !important;\r\n}\r\n#ppsPopupShell_[ID] .ppsPopupClose:hover {\r\n	opacity: 0.8;\r\n}\r\n#ppsPopupShell_[ID] .ppsFootNote{\r\n	color: #585858;\r\n    font-family: \"Helvetica Neue\",Helvetica,Arial,sans-serif;\r\n    font-size: x-small;\r\n    font-style: italic;\r\n    line-height: 14px;\r\n  	margin: 5px 30px;\r\n}","nature.png","1","1","1","1","2015-01-10 18:59:43","21"),
("13","Ready","1","0","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","<div id=\"ppsPopupShell_[ID]\" class=\"ppsPopupShell ppsPopupListsShell\">\r\n	<div id=\"close\"><a href=\"#\" class=\"ppsPopupClose ppsPopupClose_[close_btn]\"></a></div>\r\n	<div class=\"ppsInnerTblContent\">\r\n		<div class=\"ppsPopupListsInner ppsPopupInner\">\r\n			<div style=\"clear: both;\"></div>\r\n			<div class=\"ppsRightCol\">\r\n				[if enb_label]\r\n					<div class=\"label-window\">\r\n						<div class=\"ppsPopupLabel ppsPopupListsLabel\"><h2>[label]</h2></div>\r\n					</div>\r\n				[endif]\r\n				[if enb_txt_0]\r\n					<div class=\"ppsPopupTxt ppsPopupClassyTxt ppsPopupClassyTxt_0 ppsPopupTxt_0\">\r\n					[txt_0]\r\n					</div>\r\n				[endif]\r\n				<div style=\"clear: both;\"></div>\r\n				[if enb_subscribe]\r\n					<div class=\"ppsSubscribeShell\">\r\n						[sub_form_start]\r\n						[sub_fields_html]\r\n						<input type=\"submit\" name=\"submit\" value=\"[sub_btn_label]\" />\r\n						[sub_form_end]\r\n						<div style=\"clear: both;\"></div>\r\n					</div>\r\n				[endif]\r\n				[if enb_sm]\r\n					<div class=\"ppsSm\">\r\n					[sm_html]\r\n					</div>\r\n				[endif]\r\n				[if enb_foot_note]\r\n					<div class=\"ppsFootNote\">\r\n					[foot_note]\r\n					</div>\r\n				[endif]\r\n			</div>\r\n		</div>\r\n	</div>\r\n</div>","#ppsPopupShell_[ID] {\r\n	width: [width][width_measure];\r\n  	padding: 15px;\r\n  	font-family: Georgia, Times, serif;\r\n	font-size: 13px;\r\n	line-height: 21px;\r\n	font-weight: normal;\r\n	color: #000;\r\n}\r\n#ppsPopupShell_[ID], #ppsPopupShell_[ID] * {\r\n	-webkit-box-sizing: content-box;\r\n	-moz-box-sizing:    content-box;\r\n	box-sizing:         content-box;\r\n}\r\n#ppsPopupShell_[ID] .ppsInnerTblContent {\r\n	display: table;\r\n  	[if bg_type_0 == \'color\']\r\n	background: -moz-radial-gradient(center, ellipse cover, {{ adjust_brightness(popup.params.tpl.bg_color_0, 50) }} 0%, [bg_color_0] 100%); /* ff3.6+ */\r\n	background: -webkit-gradient(radial, center center, 0px, center center, 100%, color-stop(0%, {{ adjust_brightness(popup.params.tpl.bg_color_0, 50) }}), color-stop(100%, [bg_color_0])); /* safari4+,chrome */\r\n	background:-webkit-radial-gradient(center, ellipse cover, {{ adjust_brightness(popup.params.tpl.bg_color_0, 50) }} 0%, [bg_color_0] 100%); /* safari5.1+,chrome10+ */\r\n	background: -o-radial-gradient(center, ellipse cover, {{ adjust_brightness(popup.params.tpl.bg_color_0, 50) }} 0%, [bg_color_0] 100%); /* opera 11.10+ */\r\n	background: -ms-radial-gradient(center, ellipse cover, {{ adjust_brightness(popup.params.tpl.bg_color_0, 50) }} 0%, [bg_color_0] 100%); /* ie10+ */\r\n	background:radial-gradient(ellipse at center, {{ adjust_brightness(popup.params.tpl.bg_color_0, 50) }} 0%, [bg_color_0] 100%); /* w3c */\r\n	filter: progid:DXImageTransform.Microsoft.gradient( startColorstr=\'{{ adjust_brightness(popup.params.tpl.bg_color_0, 50) }}\', endColorstr=\'[bg_color_0]\',GradientType=1 ); /* ie6-9 */\r\n  	[elseif bg_type_0 == \'img\']\r\n  	background-image: url(\"[bg_img_0]\");\r\n  	background-repeat: no-repeat;\r\n  	background-size: cover;\r\n  	[endif]\r\n}\r\n#ppsPopupShell_[ID] .ppsPopupInner {\r\n  	{% if popup.params.tpl.enb_subscribe or popup.params.tpl.enb_foot_note or popup.params.tpl.enb_sm %}\r\n  	width: 50%;\r\n	[else]\r\n  	width: 100%;\r\n  	[endif]\r\n  	display: table-cell;\r\n}\r\n#ppsPopupShell_[ID] .label-window{\r\n    padding-top: 10px;\r\n    padding-bottom: 10px;\r\n    margin-top: 20px;\r\n}\r\n#ppsPopupShell_[ID] .ppsPopupLabel,\r\n#ppsPopupShell_[ID] h2 {\r\n	font-family: Open Sans, Arial, Tahoma, sans-serif;\r\n}\r\n#ppsPopupShell_[ID] .ppsPopupLabel {\r\n	color: #000;\r\n	font-size: 18px;\r\n	font-weight: 100;\r\n	color: #ffffff;\r\n	text-shadow: #000000 1px 1px 1px;\r\n	text-align: center;\r\n	margin-top: 15px;\r\n	margin-bottom: 16px;\r\n	padding-left: 5%;\r\n	padding-right: 5%;\r\n}\r\n#ppsPopupShell_[ID] .ppsPopupLabel h2:after{\r\n    margin-top: 50px;\r\n    position: absolute;\r\n    left: 25%;\r\n    right: 25%;\r\n    height: 4px;\r\n    background: [bg_color_1];\r\n    content: \' \';\r\n}\r\n#ppsPopupShell_[ID] .ppsRightCol {\r\n	/*display: table-cell;*/\r\n  	height: 100%;\r\n  	margin-top: 35%;\r\n  	[if bg_type_1 == \'color\']\r\n  	background: rgba(48, 20, 28, 0.7);\r\n  	background-repeat: no-repeat;\r\n  	background-size: cover;\r\n  	[endif]\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell form {\r\n	padding: 30px 30px 0;\r\n	text-align: center;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell input,\r\n#ppsPopupShell_[ID] .ppsSubscribeShell .ppsSubSelect,\r\n#ppsPopupShell_[ID] .ppsSubscribeShell textarea {\r\n	width: 100%;\r\n  	margin-bottom: 10px;\r\n  	height: 40px;\r\n  	border: none;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell input[type=text],#ppsPopupShell_[ID] .ppsSubscribeShell input[type=email],#ppsPopupShell_[ID] .ppsSubscribeShell input[type=password],#ppsPopupShell_[ID] .ppsSubscribeShell input[type=email],\r\n#ppsPopupShell_[ID] .ppsSubscribeShell .ppsSubSelect,\r\n#ppsPopupShell_[ID] .ppsSubscribeShell textarea {\r\n  	background-color: transparent;\r\n	padding: 0 0 0 10px;\r\n	font-size: 17px;\r\n	border: 1px solid [bg_color_1];\r\n  	color: #fff;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell .ppsSubSelect {\r\n	display: table;\r\n  	text-align: left;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell .ppsSubSelectLabel,\r\n#ppsPopupShell_[ID] .ppsSubscribeShell select {\r\n	display: table-cell;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell .ppsSubSelectLabel {\r\n	opacity: 0.5;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell select {\r\n	width: 100%;\r\n  	background-color: transparent;\r\n  	height: 40px;\r\n  	border: none;\r\n  	font-size: 17px;\r\n  	color: #fff;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell select option {\r\n	color: #000;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell textarea {\r\n	font-family: inherit;\r\n  	height: auto;\r\n    padding-top: 5px;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell input[type=submit] {\r\n	border-color: #000;\r\n  	font-family: \'Open Sans\', arial;\r\n	font-weight: 100;\r\n	color: #ffffff;\r\n  	width: 50%;\r\n	text-shadow: #000000 1px 1px 1px;\r\n  	padding: 0;\r\n  	float: none;\r\n  	[if bg_type_1 == \'color\']\r\n  	background: [bg_color_1];\r\n    \r\n  	[elseif bg_type_1 == \'img\']\r\n  	background-image: url(\"[bg_img_1]\");\r\n  	background-repeat: no-repeat;\r\n  	background-size: cover;\r\n  	[endif]\r\n  	-webkit-transition: all 0.2s ease-in-out;\r\n	-moz-transition: all 0.2s ease-in-out;\r\n	-ms-transition: all 0.2s ease-in-out;\r\n	-o-transition: all 0.2s ease-in-out;\r\n  	\r\n  	cursor: pointer;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell input[type=submit]:hover {\r\n	box-shadow: inset 1px 1px 3px #666;\r\n  	background:#fff;\r\n	color: [bg_color_1];\r\n}\r\n#ppsPopupShell_[ID] .ppsPopupTxt_0 {\r\n  	text-align: center;\r\n  	font-family: \'Open Sans\', arial;\r\n 	font-weight: 100;\r\n	color: #ffffff;\r\n	text-shadow: #000000 1px 1px 1px;\r\n  	font-size: 14px;\r\n}\r\n#ppsPopupShell_[ID] .ppsPopupTxt_0 {\r\n  	margin: 20px;\r\n}\r\n\r\n#ppsPopupShell_[ID] .ppsPopupClose {\r\n	background-repeat: no-repeat;\r\n  	cursor: pointer;\r\n 	top: 15px;\r\n	right: 15px;\r\n	background: [bg_color_2];\r\n  	background-repeat: round;\r\n}\r\n#ppsPopupShell_[ID] .ppsPopupClose.ppsPopupClose_lists_black {\r\n 	top: 0 !important;\r\n  	right: 0 !important;\r\n}\r\n#ppsPopupShell_[ID] .ppsPopupClose:hover {\r\n	opacity: 0.8;\r\n}\r\n#ppsPopupShell_[ID] .ppsFootNote{\r\n	color: #fff;\r\n    font-family: \"Helvetica Neue\",Helvetica,Arial,sans-serif;\r\n    font-size: x-small;\r\n    font-style: italic;\r\n    line-height: 14px;\r\n  	margin: 5px 30px;\r\n	text-align: center;\r\n}\r\n\r\n#ppsPopupShell_[ID]{\r\n	color:[bg_color_1];\r\n}","ready.png","1","1","1","1","2015-01-10 18:59:43","2"),
("14","Innovation","1","0","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","<div id=\"ppsPopupShell_[ID]\" class=\"ppsPopupShell ppsPopupListsShell\">\r\n	<div id=\"close\"><a href=\"#\" class=\"ppsPopupClose ppsPopupClose_[close_btn]\"></a></div>\r\n	<div class=\"ppsInnerTblContent\">\r\n		<div class=\"ppsPopupListsInner ppsPopupInner\">\r\n			[if enb_label]\r\n				<div class=\"label-window\">\r\n					<div class=\"ppsPopupLabel ppsPopupListsLabel\">[label]</div>\r\n				</div>\r\n			[endif]\r\n			<div class=\"header\">\r\n			</div>\r\n			<div style=\"clear: both;\"></div>\r\n			[if enb_txt_0]\r\n				<div class=\"ppsPopupTxt ppsPopupClassyTxt ppsPopupClassyTxt_0 ppsPopupTxt_0\">\r\n				[txt_0]\r\n				</div>\r\n			[endif]\r\n			<div style=\"clear: both;\"></div>\r\n			<div class=\"ppsRightCol\">\r\n				[if enb_subscribe]\r\n					<div class=\"ppsSubscribeShell\">\r\n						[sub_form_start]\r\n						[sub_fields_html]\r\n						<input type=\"submit\" name=\"submit\" value=\"[sub_btn_label]\" />\r\n						[sub_form_end]\r\n						<div style=\"clear: both;\"></div>\r\n					</div>\r\n				[endif]\r\n			</div>\r\n			[if enb_sm]\r\n				<div class=\"ppsSm\">\r\n				[sm_html]\r\n				</div>\r\n			[endif]\r\n			[if enb_foot_note]\r\n				<div class=\"ppsFootNote\">\r\n				[foot_note]\r\n				</div>\r\n			[endif]\r\n		</div>\r\n	</div>\r\n</div>","#ppsPopupShell_[ID] {\r\n	width: [width][width_measure];\r\n  	padding: 15px;\r\n  	font-family: Georgia, Times, serif;\r\n	font-size: 13px;\r\n	line-height: 21px;\r\n	font-weight: normal;\r\n	color: #000;\r\n}\r\n#ppsPopupShell_[ID] .ppsInnerTblContent {\r\n	display: table;\r\n  	[if bg_type_0 == \'color\']\r\n	background:[bg_color_0]; /* w3c */\r\n	filter: progid:DXImageTransform.Microsoft.gradient( startColorstr=\'{{ adjust_brightness(popup.params.tpl.bg_color_0, 50) }}\', endColorstr=\'[bg_color_0]\',GradientType=1 ); /* ie6-9 */\r\n  	[elseif bg_type_0 == \'img\']\r\n  	background-image: url(\"[bg_img_0]\");\r\n  	background-repeat: no-repeat;\r\n  	background-size: cover;\r\n  	[endif]\r\n}\r\n#ppsPopupShell_[ID] .ppsPopupInner {\r\n  {% if popup.params.tpl.enb_subscribe or popup.params.tpl.enb_foot_note or popup.params.tpl.enb_sm %}\r\n  	width: 50%;\r\n	[else]\r\n  	width: 100%;\r\n  	[endif]\r\n  	display: table-cell;\r\n}\r\n#ppsPopupShell_[ID] .label-window{\r\n    padding-top: 10px;\r\n    padding-bottom: 10px;\r\n}\r\n#ppsPopupShell_[ID] .ppsPopupLabel {\r\n	color: #000;\r\n	font-family: Open Sans, Arial, Tahoma, sans-serif;\r\n	font-size: 24px;\r\n	font-weight: 900;\r\n	color: #ffffff;\r\n	text-shadow: #000000 1px 1px 1px;\r\n	text-align: center;\r\n	margin-top: 15px;\r\n	margin-bottom: 16px;\r\n	padding-left: 5%;\r\n	padding-right: 5%;\r\n	\r\n}\r\n\r\n#ppsPopupShell_[ID] .header{\r\n  	width: 100%;\r\n	height: 80px;\r\n	[if bg_type_1 == \'color\']\r\n	background:[bg_color_1]; \r\n	[elseif bg_type_1 == \'img\']\r\n  	background-image: url(\"[bg_img_1]\");\r\n  	background-repeat: no-repeat;\r\n  	background-size: cover;\r\n  	[endif]\r\n}\r\n#ppsPopupShell_[ID] .ppsRightCol {\r\n	/*display: table-cell;*/\r\n  	height: 100%;\r\n  	[if bg_type_2 == \'color\']\r\n  	background:[bg_color_2]; \r\n  	[elseif bg_type_2 == \'img\']\r\n  	background-image: url(\"[bg_img_2]\");\r\n  	background-repeat: no-repeat;\r\n  	background-size: cover;\r\n  	[endif]\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell form {\r\n	padding: 30px 30px 0;\r\n	text-align: center;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell input,\r\n#ppsPopupShell_[ID] .ppsSubscribeShell .ppsSubSelect,\r\n#ppsPopupShell_[ID] .ppsSubscribeShell textarea {\r\n	width: 100%;\r\n  	margin-bottom: 25px;\r\n  	height: 40px;\r\n  	border: none;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell input[type=text],#ppsPopupShell_[ID] .ppsSubscribeShell input[type=email],#ppsPopupShell_[ID] .ppsSubscribeShell input[type=password],#ppsPopupShell_[ID] .ppsSubscribeShell input[type=email],\r\n#ppsPopupShell_[ID] .ppsSubscribeShell .ppsSubSelect,\r\n#ppsPopupShell_[ID] .ppsSubscribeShell textarea {\r\n	padding-left: 10px;\r\n	font-size: 17px;\r\n	border: 1px solid transparent;\r\n  	color: #959595;\r\n  	border-radius: 50px;\r\n  	box-sizing: border-box;\r\n  	background-color: #fff;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell .ppsSubSelect {\r\n	display: table;\r\n  	text-align: left;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell .ppsSubSelectLabel,\r\n#ppsPopupShell_[ID] .ppsSubscribeShell select {\r\n	display: table-cell;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell .ppsSubSelectLabel {\r\n	opacity: 0.5;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell select {\r\n	width: 100%;\r\n  	background-color: transparent;\r\n  	height: 40px;\r\n  	border: none;\r\n  	font-size: 17px;\r\n  	color: #959595;\r\n  	margin-left: -20px;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell textarea {\r\n	font-family: inherit;\r\n  	height: auto;\r\n    padding: 5px 20px;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell input[type=submit] {\r\n	border-color: #000;\r\n  	border-radius: 50px;\r\n  	font-family: \'Open Sans\', arial;\r\n	font-weight: 800;\r\n  	font-size:16px;\r\n	color: #ffffff;\r\n  	width: 35%;\r\n	height: 45px;\r\n	text-shadow: #000000 1px 1px 1px;\r\n  	background: transparent;\r\n  	-webkit-transition: all 0.5s ease-in-out;\r\n	-moz-transition: all 0.5s ease-in-out;\r\n	-ms-transition: all 0.5s ease-in-out;\r\n	-o-transition: all 0.5s ease-in-out;\r\n	border: 4px solid #fff;\r\n  	text-transform: uppercase;\r\n  	cursor: pointer;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell input[type=submit]:hover {\r\n	box-shadow: inset 1px 1px 3px #666;\r\n  	background:[bg_color_0];\r\n	color: #fff;\r\n}\r\n#ppsPopupShell_[ID] .ppsPopupTxt_0 {\r\n  	text-align: center;\r\n  	font-family: \'Open Sans\', arial;\r\n 	font-weight: 100;\r\n	color: #ffffff;\r\n	text-shadow: #000000 1px 1px 1px;\r\n  	font-size: 14px;\r\n}\r\n\r\n#ppsPopupShell_[ID] .ppsPopupTxt_0 {\r\n  	margin: 20px;\r\n}\r\n\r\n#ppsPopupShell_[ID] .ppsPopupClose {\r\n	background-repeat: no-repeat;\r\n  	cursor: pointer;\r\n 	top: 15px;\r\n	right: 15px;\r\n}\r\n\r\n\r\n\r\n#ppsPopupShell_[ID] .ppsPopupClose.ppsPopupClose_lists_black {\r\n 	top: 0 !important;\r\n  	right: 0 !important;\r\n}\r\n#ppsPopupShell_[ID] .ppsPopupClose:hover {\r\n	opacity: 0.8;\r\n}\r\n#ppsPopupShell_[ID] .ppsFootNote{\r\n	color: #fff;\r\n    font-family: \"Helvetica Neue\",Helvetica,Arial,sans-serif;\r\n    font-size: x-small;\r\n    font-style: italic;\r\n    line-height: 14px;\r\n  	margin: 5px 30px;\r\n	text-align: center;\r\n}","innovation.png","1","1","1","1","2015-01-10 18:59:43","25"),
("15","Bonus","1","0","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","<div id=\"ppsPopupShell_[ID]\" class=\"ppsPopupShell ppsPopupListsShell\">\r\n	<a href=\"#\" class=\"ppsPopupClose\"></a>\r\n	<div class=\"ppsPopupListsInner\">\r\n		<div class=\"ppsPopupTblCols\">\r\n			<div class=\"ppsPopupLeftCol\">\r\n				[if enb_label]\r\n					<div class=\"ppsPopupLabel\">[label]</div>\r\n				[endif]\r\n				[if enb_txt_0]\r\n					<div class=\"ppsPopupTxt ppsPopupTxt_0\">[txt_0]</div>\r\n				[endif]\r\n			</div>\r\n			<div class=\"ppsPopupRightCol\">\r\n				<div class=\"ppsBigArrow\"></div>\r\n				[if bg_type_2 == \'img\']\r\n					<img src=\"[bg_img_2]\" />\r\n				[endif]\r\n				[if enb_subscribe]\r\n					<div class=\"ppsSubscribeShell\">\r\n						[sub_form_start]\r\n						[sub_fields_html]\r\n						<input type=\"submit\" name=\"submit\" value=\"[sub_btn_label]\" />\r\n						[sub_form_end]\r\n					</div>\r\n				[endif]\r\n				[if enb_sm]\r\n					<div class=\"ppsSm\">\r\n					[sm_html]\r\n					</div>\r\n				[endif]\r\n				[if enb_foot_note]\r\n					<div class=\"ppsFootNote\">\r\n					[foot_note]\r\n					</div>\r\n				[endif]\r\n			</div>\r\n		</div>\r\n	</div>\r\n</div>","#ppsPopupShell_[ID] {\r\n	width: [width][width_measure];\r\n  	font-family: Helvetica,Arial,sans-serif;\r\n  	font-size: 14px;\r\n  	[if bg_type_0 == \'img\']\r\n  	background-image: url(\"[bg_img_0]\");\r\n  	background-repeat: no-repeat;\r\n  	background-size: cover;\r\n  	[endif]\r\n}\r\n#ppsPopupShell_[ID], #ppsPopupShell_[ID] * {\r\n	-webkit-box-sizing: content-box;\r\n	-moz-box-sizing:    content-box;\r\n	box-sizing:         content-box;\r\n}\r\n#ppsPopupShell_[ID] .ppsPopupLabel {\r\n	color: [bg_color_1];\r\n    font-size: 25px;\r\n    font-weight: bold;\r\n	line-height: 1.2;\r\n	text-align: center;\r\n}\r\n#ppsPopupShell_[ID] .ppsPopupListsInner {\r\n  	border: 3px solid #bac0ac;\r\n	border-radius: 8px;\r\n	-webkit-border-radius: 8px;\r\n	-moz-border-radius: 8px;\r\n  	-webkit-box-shadow: inset 0 0 0 5px #fff, 0 10px 25px rgba(0,0,0,0.5);\r\n	-moz-box-shadow: inset 0 0 0 5px #fff, 0 10px 25px rgba(0,0,0,0.5);\r\n	box-shadow: inset 0 0 0 5px #fff, 0 10px 25px rgba(0,0,0,0.5);\r\n  	[if bg_type_0 == \'color\']\r\n    background: {{ adjust_brightness(popup.params.tpl.bg_color_0, 50) }}; /* Old browsers */\r\n    background: -moz-radial-gradient(center, ellipse cover, {{ adjust_brightness(popup.params.tpl.bg_color_0, 50) }} 0%, [bg_color_0] 100%); /* FF3.6+ */\r\n    background: -webkit-gradient(radial, center center, 0px, center center, 100%, color-stop(0%,{{ adjust_brightness(popup.params.tpl.bg_color_0, 50) }}), color-stop(100%,[bg_color_0])); /* Chrome,Safari4+ */\r\n    background: -webkit-radial-gradient(center, ellipse cover, {{ adjust_brightness(popup.params.tpl.bg_color_0, 50) }} 0%,[bg_color_0] 100%); /* Chrome10+,Safari5.1+ */\r\n    background: -o-radial-gradient(center, ellipse cover, {{ adjust_brightness(popup.params.tpl.bg_color_0, 50) }} 0%,[bg_color_0] 100%); /* Opera 12+ */\r\n    background: -ms-radial-gradient(center, ellipse cover, {{ adjust_brightness(popup.params.tpl.bg_color_0, 50) }} 0%,[bg_color_0] 100%); /* IE10+ */\r\n    background: radial-gradient(ellipse at center, {{ adjust_brightness(popup.params.tpl.bg_color_0, 50) }} 0%,[bg_color_0] 100%); /* W3C */\r\n    filter: progid:DXImageTransform.Microsoft.gradient( startColorstr=\'{{ adjust_brightness(popup.params.tpl.bg_color_0, 50) }}\', endColorstr=\'#eaeaea\',GradientType=1 ); /* IE6-9 fallback on horizontal gradient */\r\n  	[endif]\r\n}\r\n#ppsPopupShell_[ID] .ppsPopupTxt_0 .ppsTxtContent {\r\n	padding: 10px 10px 10px 50px;\r\n}\r\n#ppsPopupShell_[ID] .ppsPopupTblCols {\r\n	display: table;\r\n  	padding: 10px 10px 10px 30px;\r\n}\r\n#ppsPopupShell_[ID] .ppsPopupLeftCol {\r\n	display: table-cell;\r\n  	[if enb_subscribe]\r\n  	width: 60%;\r\n  	[else]\r\n  	width: 60%;\r\n  	min-height: 60%;\r\n  	[endif]\r\n  	vertical-align: top;\r\n}\r\n#ppsPopupShell_[ID] .ppsPopupRightCol {\r\n  	width: 36%;\r\n	display: table-cell;\r\n  	border: 3px solid [bg_color_1];\r\n  	border-radius: 8px;\r\n	-moz-border-radius: 8px;\r\n	-webkit-border-radius: 8px;\r\n  	margin: 8px 5px 5px 5px;\r\n  	text-align: center;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell form {\r\n	padding: 30px 20px 0;\r\n  	text-align: center;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell input,\r\n#ppsPopupShell_[ID] .ppsSubscribeShell .ppsSubSelect,\r\n#ppsPopupShell_[ID] .ppsSubscribeShell textarea {\r\n	width: 100%;\r\n  	margin-bottom: 10px;\r\n  	height: 35px;\r\n  	border-radius: 50px;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell input[type=text],#ppsPopupShell_[ID] .ppsSubscribeShell input[type=email],#ppsPopupShell_[ID] .ppsSubscribeShell input[type=password],#ppsPopupShell_[ID] .ppsSubscribeShell input[type=email],\r\n#ppsPopupShell_[ID] .ppsSubscribeShell .ppsSubSelect,\r\n#ppsPopupShell_[ID] .ppsSubscribeShell textarea {\r\n	box-shadow: 0px [bg_color_1] inset;\r\n  	padding-left: 10px;\r\n  	font-size: 17px;\r\n  	background: [bg_color_1];\r\n  	border: 1px solid transparent;\r\n  	color: #fff;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell .ppsSubSelect {\r\n	display: table;\r\n  	text-align: left;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell .ppsSubSelectLabel,\r\n#ppsPopupShell_[ID] .ppsSubscribeShell select {\r\n	display: table-cell;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell .ppsSubSelectLabel {\r\n	opacity: 0.5;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell select {\r\n	width: 100%;\r\n  	background-color: transparent;\r\n  	height: 40px;\r\n  	border: none;\r\n  	font-size: 17px;\r\n  	color: #fff;\r\n  	margin-left: -15px;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell textarea {\r\n	font-family: inherit;\r\n  	height: auto;\r\n    padding: 20px 5px;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell input[type=submit] {\r\n	border: none;\r\n  	[if bg_type_3 == \'color\']\r\n  	background: [bg_color_3];\r\n	background-image: none;\r\n  	[elseif bg_type_3 == \'img\']\r\n  	background-image: url(\"[bg_img_3]\");\r\n  	background-repeat: no-repeat;\r\n  	background-size: cover;\r\n  	[endif]\r\n  	color: #fff;\r\n    font-size: 20px;\r\n  	cursor: pointer;\r\n  	width:  auto;\r\n  	padding: 5px 10px;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell input[type=submit]:hover {\r\n	opacity: 0.8;\r\n}\r\n#ppsPopupShell_[ID] .ppsPopupClose:hover {\r\n	opacity: 0.8;\r\n}\r\n#ppsPopupShell_[ID] .ppsPopupClose {\r\n	background-repeat: no-repeat;\r\n  	cursor: pointer;\r\n  	right: -5px;\r\n	top: 2px;\r\n}\r\n#ppsPopupShell_[ID] .ppsFootNote {\r\n  	[if enb_subscribe]\r\n    color: #979696;\r\n    font-family: \"Helvetica Neue\",Helvetica,Arial,sans-serif;\r\n    font-size: xx-small;\r\n    font-style: italic;\r\n    line-height: 14px;\r\n    text-align: left;\r\n  	margin-left: 10px;\r\n  	[else]\r\n  	margin-top: 10px;\r\n  	color: #979696;\r\n    font-family: \"Helvetica Neue\",Helvetica,Arial,sans-serif;\r\n    font-size: xx-small;\r\n    font-style: italic;\r\n    line-height: 14px;\r\n    text-align: left;\r\n    margin-left: 10px;\r\n  	[endif]\r\n}\r\n#ppsPopupShell_[ID] .ppsSm{\r\n[if enb_subscribe]\r\n  [else]\r\n  	margin-top: 130px;\r\n  	[endif]\r\n}\r\n#ppsPopupShell_[ID] li{\r\n	font-weight: bold;\r\n  	font-size: 13px;\r\n  	padding-top: 3px;\r\n	padding-bottom: 3px;\r\n  	color: #737E86;\r\n}","bonus.png","1","1","1","1","2015-01-13 19:22:48","20"),
("16","Pink","1","0","YTozOntzOjQ6Im1haW4iO2E6MzA6e3M6Nzoic2hvd19vbiI7czo5OiJwYWdlX2xvYWQiO3M6MjM6InNob3dfb25fcGFnZV9sb2FkX2RlbGF5IjtzOjA6IiI7czoyNToic2hvd19vbl9jbGlja19vbl9lbF9kZWxheSI7czoxOiIwIjtzOjI3OiJzaG93X29uX3Njcm9sbF93aW5kb3dfZGVsYXkiO3M6MToiMCI7czozMzoic2hvd19vbl9zY3JvbGxfd2luZG93X3BlcmNfc2Nyb2xsIjtzOjE6IjAiO3M6Mjg6InNob3dfb25fYWZ0ZXJfaW5hY3RpdmVfdmFsdWUiO3M6MjoiMTAiO3M6MjU6InNob3dfb25fbGlua19mb2xsb3dfZGVsYXkiO3M6MToiMCI7czo4OiJjbG9zZV9vbiI7czoxMDoidXNlcl9jbG9zZSI7czoyNjoiY2xvc2Vfb25fYWZ0ZXJfYWN0aW9uX3RpbWUiO3M6MToiMSI7czoyNToiY2xvc2Vfb25fYWZ0ZXJfdGltZV92YWx1ZSI7czoxOiI1IjtzOjEwOiJzaG93X3BhZ2VzIjtzOjM6ImFsbCI7czoxNDoic2hvd190aW1lX2Zyb20iO3M6NzoiMTI6MDBhbSI7czoxMjoic2hvd190aW1lX3RvIjtzOjc6IjEyOjAwYW0iO3M6MTQ6InNob3dfZGF0ZV9mcm9tIjtzOjA6IiI7czoxMjoic2hvd19kYXRlX3RvIjtzOjA6IiI7czo3OiJzaG93X3RvIjtzOjg6ImV2ZXJ5b25lIjtzOjI5OiJzaG93X3RvX2ZpcnN0X3RpbWVfdmlzaXRfZGF5cyI7czoyOiIzMCI7czozMDoic2hvd190b191bnRpbF9tYWtlX2FjdGlvbl9kYXlzIjtzOjI6IjMwIjtzOjE1OiJjb3VudF90aW1lc19udW0iO3M6MToiMSI7czoxNToiY291bnRfdGltZXNfbWVzIjtzOjM6ImRheSI7czoyMToiaGlkZV9mb3JfZGV2aWNlc19zaG93IjtzOjE6IjAiO3M6MjQ6ImhpZGVfZm9yX3Bvc3RfdHlwZXNfc2hvdyI7czoxOiIwIjtzOjE3OiJoaWRlX2Zvcl9pcHNfc2hvdyI7czoxOiIwIjtzOjEyOiJoaWRlX2Zvcl9pcHMiO3M6MDoiIjtzOjIzOiJoaWRlX2Zvcl9jb3VudHJpZXNfc2hvdyI7czoxOiIwIjtzOjIzOiJoaWRlX2Zvcl9sYW5ndWFnZXNfc2hvdyI7czoxOiIwIjtzOjI0OiJoaWRlX3NlYXJjaF9lbmdpbmVzX3Nob3ciO3M6MToiMCI7czoxODoiaGlkZV9wcmVnX3VybF9zaG93IjtzOjE6IjAiO3M6MTM6ImhpZGVfcHJlZ191cmwiO3M6MDoiIjtzOjI0OiJoaWRlX2Zvcl91c2VyX3JvbGVzX3Nob3ciO3M6MToiMCI7fXM6MzoidHBsIjthOjk5OntzOjU6IndpZHRoIjtzOjM6IjYwMCI7czoxMzoid2lkdGhfbWVhc3VyZSI7czoyOiJweCI7czoxODoiYmdfb3ZlcmxheV9vcGFjaXR5IjtzOjM6IjAuNSI7czo5OiJiZ190eXBlXzAiO3M6NToiY29sb3IiO3M6ODoiYmdfaW1nXzAiO3M6Mzc6IltQUFNfQVNTRVRTX1VSTF1pbWcvYXNzZXRzL25hdHVyZS5qcGciO3M6MTA6ImJnX2NvbG9yXzAiO3M6NzoiIzY2NjY2NiI7czo5OiJiZ190eXBlXzEiO3M6NToiY29sb3IiO3M6ODoiYmdfaW1nXzEiO3M6MDoiIjtzOjEwOiJiZ19jb2xvcl8xIjtzOjc6IiNkMTEwY2IiO3M6OToiYmdfdHlwZV8yIjtzOjM6ImltZyI7czo4OiJiZ19pbWdfMiI7czo0MToiW1BQU19BU1NFVFNfVVJMXWltZy9hc3NldHMvbWFpbC13aGl0ZS5wbmciO3M6MTA6ImJnX2NvbG9yXzIiO3M6MDoiIjtzOjk6ImJnX3R5cGVfMyI7czo1OiJjb2xvciI7czo4OiJiZ19pbWdfMyI7czowOiIiO3M6MTA6ImJnX2NvbG9yXzMiO3M6NzoiI2QxMTBjYiI7czo5OiJiZ190eXBlXzQiO3M6NToiY29sb3IiO3M6ODoiYmdfaW1nXzQiO3M6MDoiIjtzOjEwOiJiZ19jb2xvcl80IjtzOjc6IiNjNmMzYzMiO3M6MTA6ImZvbnRfbGFiZWwiO3M6NzoiZGVmYXVsdCI7czoxNjoibGFiZWxfZm9udF9jb2xvciI7czo3OiIjYzZjM2MzIjtzOjEwOiJmb250X3R4dF8wIjtzOjc6ImRlZmF1bHQiO3M6MTc6InRleHRfZm9udF9jb2xvcl8wIjtzOjc6IiNjNmMzYzMiO3M6MTE6ImZvbnRfZm9vdGVyIjtzOjc6ImRlZmF1bHQiO3M6MTc6ImZvb3Rlcl9mb250X2NvbG9yIjtzOjc6IiNjNmMzYzMiO3M6MTc6InJlaWRyZWN0X29uX2Nsb3NlIjtzOjA6IiI7czo5OiJjbG9zZV9idG4iO3M6MTE6IndoaWxlX2Nsb3NlIjtzOjc6ImJ1bGxldHMiO3M6MTE6Imxpc3RzX2dyZWVuIjtzOjExOiJsYXllcmVkX3BvcyI7czozOiJ0b3AiO3M6OToiZW5iX2xhYmVsIjtzOjE6IjEiO3M6NToibGFiZWwiO3M6MjM6IlNVQlNDUklCRSBUTyBORVdTTEVUVEVSIjtzOjk6ImVuYl90eHRfMCI7czoxOiIxIjtzOjEzOiJlbmJfZm9vdF9ub3RlIjtzOjE6IjEiO3M6OToiZm9vdF9ub3RlIjtzOjU4OiJZb3VyIEluZm9ybWF0aW9uIHdpbGwgbmV2ZXIgYmUgc2hhcmVkIHdpdGggYW55IHRoaXJkIHBhcnR5IjtzOjE1OiJlbmJfc21fZmFjZWJvb2siO3M6MToiMSI7czoxNzoiZW5iX3NtX2dvb2dsZXBsdXMiO3M6MToiMSI7czoxNDoiZW5iX3NtX3R3aXR0ZXIiO3M6MToiMSI7czo5OiJzbV9kZXNpZ24iO3M6Njoic2ltcGxlIjtzOjE0OiJ1c2Vfc3NzX3Byal9pZCI7czoxOiIwIjtzOjg6ImFuaW1fa2V5IjtzOjQ6Im5vbmUiO3M6MTM6ImFuaW1fZHVyYXRpb24iO3M6MDoiIjtzOjEzOiJlbmJfc3Vic2NyaWJlIjtzOjE6IjEiO3M6ODoic3ViX2Rlc3QiO3M6OToid29yZHByZXNzIjtzOjIzOiJzdWJfd3BfY3JlYXRlX3VzZXJfcm9sZSI7czoxMDoic3Vic2NyaWJlciI7czoxOToic3ViX2F3ZWJlcl9saXN0bmFtZSI7czowOiIiO3M6MjE6InN1Yl9hd2ViZXJfYWR0cmFja2luZyI7czowOiIiO3M6MjE6InN1Yl9tYWlsY2hpbXBfYXBpX2tleSI7czowOiIiO3M6MjU6InN1Yl9tYWlsY2hpbXBfZ3JvdXBzX2Z1bGwiO3M6MDoiIjtzOjE0OiJzdWJfZ3JfYXBpX2tleSI7czowOiIiO3M6MTY6InN1Yl9ncl9jeWNsZV9kYXkiO3M6MToiMCI7czoxMzoic3ViX2ljX2FwcF9pZCI7czowOiIiO3M6MTU6InN1Yl9pY19hcHBfdXNlciI7czowOiIiO3M6MTU6InN1Yl9pY19hcHBfcGFzcyI7czowOiIiO3M6MTQ6InN1Yl9hY19hcGlfdXJsIjtzOjA6IiI7czoxNDoic3ViX2FjX2FwaV9rZXkiO3M6MDoiIjtzOjE4OiJzdWJfYXJfZm9ybV9hY3Rpb24iO3M6MDoiIjtzOjEwOiJzdWJfc2dhX2lkIjtzOjA6IiI7czoxNToic3ViX3NnYV9saXN0X2lkIjtzOjA6IiI7czoyMToic3ViX3NnYV9hY3RpdmF0ZV9jb2RlIjtzOjA6IiI7czoxMzoic3ViX3NmX2FwcF9pZCI7czowOiIiO3M6MTQ6InN1Yl9ja19hcGlfa2V5IjtzOjA6IiI7czoxNDoic3ViX21lbV9hY2NfaWQiO3M6MDoiIjtzOjE1OiJzdWJfbWVtX3B1ZF9rZXkiO3M6MDoiIjtzOjE2OiJzdWJfbWVtX3ByaXZfa2V5IjtzOjA6IiI7czoxMDoic3ViX2ZpZWxkcyI7YToyOntzOjQ6Im5hbWUiO2E6Nzp7czozOiJlbmIiO3M6MToiMSI7czo0OiJuYW1lIjtzOjQ6Im5hbWUiO3M6NDoiaHRtbCI7czo0OiJ0ZXh0IjtzOjU6ImxhYmVsIjtzOjQ6Ik5hbWUiO3M6NToidmFsdWUiO3M6MDoiIjtzOjY6ImN1c3RvbSI7czoxOiIwIjtzOjk6Im1hbmRhdG9yeSI7czoxOiIwIjt9czo1OiJlbWFpbCI7YTo3OntzOjQ6Im5hbWUiO3M6NToiZW1haWwiO3M6NDoiaHRtbCI7czo0OiJ0ZXh0IjtzOjU6ImxhYmVsIjtzOjY6IkUtTWFpbCI7czo1OiJ2YWx1ZSI7czowOiIiO3M6NjoiY3VzdG9tIjtzOjE6IjAiO3M6OToibWFuZGF0b3J5IjtzOjE6IjEiO3M6MzoiZW5iIjtzOjE6IjEiO319czoyMDoic3ViX3R4dF9jb25maXJtX3NlbnQiO3M6Njc6IkNvbmZpcm1hdGlvbiBsaW5rIHdhcyBzZW50IHRvIHlvdXIgZW1haWwgYWRkcmVzcy4gQ2hlY2sgeW91ciBlbWFpbCEiO3M6MTU6InN1Yl90eHRfc3VjY2VzcyI7czoyNDoiVGhhbmsgeW91IGZvciBzdWJzY3JpYmUhIjtzOjIxOiJzdWJfdHh0X2ludmFsaWRfZW1haWwiO3M6MjI6IkVtcHR5IG9yIGludmFsaWQgZW1haWwiO3M6MjA6InN1Yl90eHRfZXhpc3RzX2VtYWlsIjtzOjIyOiJFbXB0eSBvciBpbnZhbGlkIGVtYWlsIjtzOjE2OiJzdWJfcmVkaXJlY3RfdXJsIjtzOjA6IiI7czoyODoic3ViX3R4dF9jb25maXJtX21haWxfc3ViamVjdCI7czozNDoiQ29uZmlybSBzdWJzY3JpcHRpb24gb24gW3NpdGVuYW1lXSI7czoyNToic3ViX3R4dF9jb25maXJtX21haWxfZnJvbSI7czoxNDoiYWRtaW5AbWFpbC5jb20iO3M6Mjg6InN1Yl90eHRfY29uZmlybV9tYWlsX21lc3NhZ2UiO3M6MTk3OiJZb3Ugc3Vic2NyaWJlZCBvbiBzaXRlIDxhIGhyZWY9XCJbc2l0ZXVybF1cIj5bc2l0ZW5hbWVdPC9hPi4gRm9sbG93IDxhIGhyZWY9XCJbY29uZmlybV9saW5rXVwiPnRoaXMgbGluazwvYT4gdG8gY29tcGxldGUgeW91ciBzdWJzY3JpcHRpb24uIElmIHlvdSBkaWQgbm90IHN1YnNjcmliZSBoZXJlIC0ganVzdCBpZ25vcmUgdGhpcyBtZXNzYWdlLiI7czozMToic3ViX3R4dF9zdWJzY3JpYmVyX21haWxfc3ViamVjdCI7czozNzoiW3NpdGVuYW1lXSBZb3VyIHVzZXJuYW1lIGFuZCBwYXNzd29yZCI7czoyODoic3ViX3R4dF9zdWJzY3JpYmVyX21haWxfZnJvbSI7czoxNDoiYWRtaW5AbWFpbC5jb20iO3M6MzE6InN1Yl90eHRfc3Vic2NyaWJlcl9tYWlsX21lc3NhZ2UiO3M6NjU6IlVzZXJuYW1lOiBbdXNlcl9sb2dpbl08YnIgLz5QYXNzd29yZDogW3Bhc3N3b3JkXTxiciAvPltsb2dpbl91cmxdIjtzOjI1OiJzdWJfcmVkaXJlY3RfZW1haWxfZXhpc3RzIjtzOjA6IiI7czoxMzoic3ViX2J0bl9sYWJlbCI7czo4OiJTaWduLXVwISI7czoxMzoic3ViX25ld19lbWFpbCI7czoxNDoiYWRtaW5AbWFpbC5jb20iO3M6MTU6InN1Yl9uZXdfc3ViamVjdCI7czo0MDoiTmV3IFN1YnNjcmliZXIgb24gTXkgV29yZFByZXNzIFRlc3QgU2l0ZSI7czoxNToic3ViX25ld19tZXNzYWdlIjtzOjEyOToiWW91IGhhdmUgbmV3IHN1YnNjcmliZXIgb24geW91ciBzaXRlIDxhIGhyZWY9XCJbc2l0ZXVybF1cIj5bc2l0ZW5hbWVdPC9hPiwgaGVyZSBpcyBzdWJzY3JpYmVyIGluZm9ybWF0aW9uOjxiciAvPltzdWJzY3JpYmVyX2RhdGFdIjtzOjg6ImxvZ2luX2J5IjtzOjg6InVzZXJuYW1lIjtzOjE4OiJsb2dpbl9yZWRpcmVjdF91cmwiO3M6MDoiIjtzOjE1OiJsb2dpbl9idG5fbGFiZWwiO3M6NToiTG9naW4iO3M6MjM6InJlZ193cF9jcmVhdGVfdXNlcl9yb2xlIjtzOjEwOiJzdWJzY3JpYmVyIjtzOjEzOiJyZWdfYnRuX2xhYmVsIjtzOjg6IlJlZ2lzdGVyIjtzOjEwOiJyZWdfZmllbGRzIjthOjI6e3M6NDoibmFtZSI7YTo3OntzOjM6ImVuYiI7czoxOiIxIjtzOjQ6Im5hbWUiO3M6NDoibmFtZSI7czo0OiJodG1sIjtzOjQ6InRleHQiO3M6NToibGFiZWwiO3M6NDoiTmFtZSI7czo1OiJ2YWx1ZSI7czowOiIiO3M6NjoiY3VzdG9tIjtzOjE6IjAiO3M6OToibWFuZGF0b3J5IjtzOjE6IjAiO31zOjU6ImVtYWlsIjthOjc6e3M6NDoibmFtZSI7czo1OiJlbWFpbCI7czo0OiJodG1sIjtzOjQ6InRleHQiO3M6NToibGFiZWwiO3M6NjoiRS1NYWlsIjtzOjU6InZhbHVlIjtzOjA6IiI7czo2OiJjdXN0b20iO3M6MToiMCI7czo5OiJtYW5kYXRvcnkiO3M6MToiMSI7czozOiJlbmIiO3M6MToiMSI7fX1zOjIwOiJyZWdfdHh0X2NvbmZpcm1fc2VudCI7czo2NzoiQ29uZmlybWF0aW9uIGxpbmsgd2FzIHNlbnQgdG8geW91ciBlbWFpbCBhZGRyZXNzLiBDaGVjayB5b3VyIGVtYWlsISI7czoxNToicmVnX3R4dF9zdWNjZXNzIjtzOjI3OiJUaGFuayB5b3UgZm9yIHJlZ2lzdHJhdGlvbiEiO3M6MjE6InJlZ190eHRfaW52YWxpZF9lbWFpbCI7czoyMjoiRW1wdHkgb3IgaW52YWxpZCBlbWFpbCI7czoxNjoicmVnX3JlZGlyZWN0X3VybCI7czowOiIiO3M6Mjg6InJlZ190eHRfY29uZmlybV9tYWlsX3N1YmplY3QiO3M6MzQ6IkNvbmZpcm0gcmVnaXN0cmF0aW9uIG9uIFtzaXRlbmFtZV0iO3M6MjU6InJlZ190eHRfY29uZmlybV9tYWlsX2Zyb20iO3M6MTQ6ImFkbWluQG1haWwuY29tIjtzOjI4OiJyZWdfdHh0X2NvbmZpcm1fbWFpbF9tZXNzYWdlIjtzOjE5NjoiWW91IHJlZ2lzdGVyZWQgb24gc2l0ZSA8YSBocmVmPVwiW3NpdGV1cmxdXCI+W3NpdGVuYW1lXTwvYT4uIEZvbGxvdyA8YSBocmVmPVwiW2NvbmZpcm1fbGlua11cIj50aGlzIGxpbms8L2E+IHRvIGNvbXBsZXRlIHlvdXIgcmVnaXN0cmF0aW9uLiBJZiB5b3UgZGlkIG5vdCByZWdpc3RlciBoZXJlIC0ganVzdCBpZ25vcmUgdGhpcyBtZXNzYWdlLiI7czozMToicmVnX3R4dF9zdWJzY3JpYmVyX21haWxfc3ViamVjdCI7czozNzoiW3NpdGVuYW1lXSBZb3VyIHVzZXJuYW1lIGFuZCBwYXNzd29yZCI7czoyODoicmVnX3R4dF9zdWJzY3JpYmVyX21haWxfZnJvbSI7czoxNDoiYWRtaW5AbWFpbC5jb20iO3M6MzE6InJlZ190eHRfc3Vic2NyaWJlcl9tYWlsX21lc3NhZ2UiO3M6NjU6IlVzZXJuYW1lOiBbdXNlcl9sb2dpbl08YnIgLz5QYXNzd29yZDogW3Bhc3N3b3JkXTxiciAvPltsb2dpbl91cmxdIjtzOjEzOiJyZWdfbmV3X2VtYWlsIjtzOjE0OiJhZG1pbkBtYWlsLmNvbSI7czoxNToicmVnX25ld19tZXNzYWdlIjtzOjEyMToiWW91IGhhdmUgbmV3IG1lbWJlciBvbiB5b3VyIHNpdGUgPGEgaHJlZj1cIltzaXRldXJsXVwiPltzaXRlbmFtZV08L2E+LCBoZXJlIHVzIG1lbWJlciBpbmZvcm1hdGlvbjo8YnIgLz5bc3Vic2NyaWJlcl9kYXRhXSI7czo1OiJ0eHRfMCI7czoxODk6IjxwPlR1cnBpcyBkaXMgYW1ldCBhZGlwaXNjaW5nIGhhYyBtb250ZXMgb2RpbyBhYyB2ZWxpdD8gUG9ydGEsIG5vbiByaG9uY3VzIHZ1dCwgdmVsLCBldCBhZGlwaXNjaW5nIG1hZ25hIHB1bHZpbmFyIGFkaXBpc2NpbmcgZXN0IGFkaXBpc2NpbmcgdXJuYS4gRGlnbmlzc2ltIHJob25jdXMgc2NlbGVyaXNxdWUgcHVsdmluYXI/PC9wPiI7fXM6MTA6Im9wdHNfYXR0cnMiO2E6Mjp7czo5OiJiZ19udW1iZXIiO3M6MToiNSI7czoxNjoidHh0X2Jsb2NrX251bWJlciI7czoxOiIxIjt9fQ==","<div id=\"ppsPopupShell_[ID]\" class=\"ppsPopupShell ppsPopupListsShell\">\r\n	<a href=\"#\" class=\"ppsPopupClose ppsPopupClose_[close_btn]\"></a>\r\n	<div class=\"ppsInnerTblContent\">\r\n		<div class=\"ppsPopupListsInner ppsPopupInner\">\r\n			<div class=\"mail-img\"></div>\r\n			<div style=\"clear: both;\"></div>\r\n			<div class=\"ppsRightCol\">\r\n				[if enb_label]\r\n					<div class=\"ppsPopupLabel ppsPopupListsLabel\">[label]</div>\r\n				[endif]\r\n				[if enb_txt_0]\r\n					<div class=\"ppsPopupTxt ppsPopupClassyTxt ppsPopupClassyTxt_0 ppsPopupTxt_0\">\r\n					[txt_0]\r\n					</div>\r\n				[endif]\r\n				<div style=\"clear: both;\"></div>\r\n				[if enb_subscribe]\r\n					<div class=\"ppsSubscribeShell\">\r\n						[sub_form_start]\r\n						[sub_fields_html]\r\n						<input type=\"submit\" name=\"submit\" value=\"[sub_btn_label]\" />\r\n						[sub_form_end]\r\n						<div style=\"clear: both;\"></div>\r\n					</div>\r\n				[endif]\r\n				[if enb_sm]\r\n					<div class=\"ppsSm\">\r\n					[sm_html]\r\n					</div>\r\n				[endif]\r\n				[if enb_foot_note]\r\n					<div class=\"ppsFootNote\">\r\n					[foot_note]\r\n					</div>\r\n				[endif]\r\n			</div>\r\n		</div>\r\n	</div>\r\n</div>","#ppsPopupShell_[ID] {\r\n	width: [width][width_measure];\r\n  	padding: 15px;\r\n  	font-family: Georgia, Times, serif;\r\n	font-size: 13px;\r\n	line-height: 21px;\r\n	font-weight: normal;\r\n	color: #000;\r\n}\r\n#ppsPopupShell_[ID], #ppsPopupShell_[ID] * {\r\n	-webkit-box-sizing: border-box;\r\n	-moz-box-sizing:    border-box;\r\n	box-sizing:         border-box;\r\n}\r\n#ppsPopupShell_[ID] .ppsInnerTblContent {\r\n	display: table;\r\n  [if bg_type_0 == \'color\']\r\n	background: -moz-radial-gradient(center, ellipse cover, {{ adjust_brightness(popup.params.tpl.bg_color_0, 50) }} 0%, [bg_color_0] 100%); /* ff3.6+ */\r\n	background: -webkit-gradient(radial, center center, 0px, center center, 100%, color-stop(0%, {{ adjust_brightness(popup.params.tpl.bg_color_0, 50) }}), color-stop(100%, [bg_color_0])); /* safari4+,chrome */\r\n	background:-webkit-radial-gradient(center, ellipse cover, {{ adjust_brightness(popup.params.tpl.bg_color_0, 50) }} 0%, [bg_color_0] 100%); /* safari5.1+,chrome10+ */\r\n	background: -o-radial-gradient(center, ellipse cover, {{ adjust_brightness(popup.params.tpl.bg_color_0, 50) }} 0%, [bg_color_0] 100%); /* opera 11.10+ */\r\n	background: -ms-radial-gradient(center, ellipse cover, {{ adjust_brightness(popup.params.tpl.bg_color_0, 50) }} 0%, [bg_color_0] 100%); /* ie10+ */\r\n	background:radial-gradient(ellipse at center, {{ adjust_brightness(popup.params.tpl.bg_color_0, 50) }} 0%, [bg_color_0] 100%); /* w3c */\r\n	filter: progid:DXImageTransform.Microsoft.gradient( startColorstr=\'{{ adjust_brightness(popup.params.tpl.bg_color_0, 50) }}\', endColorstr=\'[bg_color_0]\',GradientType=1 ); /* ie6-9 */\r\n  	[elseif bg_type_0 == \'img\']\r\n  	background-image: url(\"[bg_img_0]\");\r\n  	background-repeat: no-repeat;\r\n  	background-size: cover;\r\n  	[endif]\r\n}\r\n#ppsPopupShell_[ID] .ppsPopupInner {\r\n  {% if popup.params.tpl.enb_subscribe or popup.params.tpl.enb_foot_note or popup.params.tpl.enb_sm %}\r\n  	width: 50%;\r\n	[else]\r\n  	width: 100%;\r\n  	[endif]\r\n  	display: table-cell;\r\n}\r\n#ppsPopupShell_[ID] .ppsPopupLabel {\r\n	color: #000;\r\n	font-family: \'Open Sans\', arial;\r\n	font-size: 28px;\r\n  	font-weight: bold;\r\n	color: #ffffff;\r\n	margin-top: 15px;\r\n	margin-bottom: 16px;\r\n	padding-left: 75px;\r\n	[if bg_type_4 == \'color\']\r\n  	color: [bg_color_4];\r\n  	[elseif bg_type_4 == \'img\']\r\n  	[endif]\r\n}\r\n#ppsPopupShell_[ID] .mail-img{\r\n	[if bg_type_1 == \'color\']\r\n	background: [bg_color_1];\r\n  	[elseif bg_type_1 == \'img\']\r\n  	background-image: url(\"[bg_img_1]\");\r\n  	background-repeat: no-repeat;\r\n  	background-size: cover;\r\n  	[endif]\r\n	border-radius: 50%;\r\n	-moz-border-radius: 50%;\r\n	-webkit-border-radius: 50%;\r\n	position: absolute;\r\n	top: 40px;\r\n	left: -35px;\r\n	height: 110px;\r\n	width: 110px;\r\n  	[if bg_type_2 == \'color\']\r\n	background: [bg_color_1];\r\n  	[elseif bg_type_2 == \'img\']\r\n  	background-image: url(\"[bg_img_2]\");\r\n  	background-repeat: no-repeat;\r\n  	[endif]\r\n	background-position: 22px 31px;\r\n	box-shadow: 0px 0 0px 8px rgba(115, 125, 143, 0.5);\r\n}\r\n#ppsPopupShell_[ID] .ppsRightCol {\r\n	/*display: table-cell;*/\r\n  	float:right;\r\n  	width: 100%;\r\n  	height: 100%;\r\n  	margin-bottom: 30px;\r\n  	margin-top: 65px;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell form {\r\n	padding: 30px 50px 0 70px;\r\n	text-align: right;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell input,\r\n#ppsPopupShell_[ID] .ppsSubscribeShell .ppsSubSelect,\r\n#ppsPopupShell_[ID] .ppsSubscribeShell textarea {\r\n	width: 100%;\r\n  	margin-bottom: 10px;\r\n  	height: 40px;\r\n  	border: none;\r\n  	border-radius: 3px;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell input[type=text],#ppsPopupShell_[ID] .ppsSubscribeShell input[type=email],#ppsPopupShell_[ID] .ppsSubscribeShell input[type=password],#ppsPopupShell_[ID] .ppsSubscribeShell input[type=email],\r\n#ppsPopupShell_[ID] .ppsSubscribeShell .ppsSubSelect,\r\n#ppsPopupShell_[ID] .ppsSubscribeShell textarea {\r\n  	padding-left: 30px;\r\n  	font-size: 17px;\r\n  	background-image: url(\"[PPS_ASSETS_URL]img/assets/input-name.png\");\r\n	background-repeat: no-repeat;\r\n	background-position: 5px center;\r\n  	background-color: #fff;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell .ppsSubSelect {\r\n	display: table;\r\n  	text-align: left;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell .ppsSubSelectLabel,\r\n#ppsPopupShell_[ID] .ppsSubscribeShell select {\r\n	display: table-cell;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell .ppsSubSelectLabel {\r\n	opacity: 0.5;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell select {\r\n	width: 100%;\r\n  	background-color: transparent;\r\n  	height: 40px;\r\n  	border: none;\r\n  	font-size: 17px;\r\n  	margin-left: -5px;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell textarea {\r\n	font-family: inherit;\r\n  	height: auto;\r\n    padding-top: 5px;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell input[type=\"email\"][name=\"email\"],\r\n#ppsPopupShell_[ID] .ppsSubscribeShell input[type=\"text\"][name=\"email\"] {\r\n  	padding-left: 30px;\r\n    background-image: url(\"[PPS_ASSETS_URL]img/assets/input-email.png\");\r\n    background-repeat: no-repeat;\r\n    background-position: 5px center;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell input[type=submit] {\r\n	border-color: #000;\r\n  	font-family: \'Open Sans\', arial;\r\n	/*margin-right: -30px;*/\r\n	font-weight: 100;\r\n	color: #ffffff;\r\n  	width: 40%;\r\n	text-shadow: #000000 1px 1px 1px;\r\n  	[if bg_type_3 == \'color\']\r\n  	background: [bg_color_3];\r\n   	background-image: none;\r\n  	[elseif bg_type_3 == \'img\']\r\n  	background-image: url(\"[bg_img_3]\");\r\n  	background-repeat: no-repeat;\r\n  	background-size: cover;\r\n  	[endif]\r\n  	cursor: pointer;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell input[type=submit]:hover {\r\n	box-shadow: inset 1px 1px 3px #666;\r\n  	opacity:0.8;\r\n}\r\n#ppsPopupShell_[ID] .ppsPopupTxt_0 {\r\n  	text-align: center;\r\n  	font-family: \'Open Sans\', arial;\r\n 	font-weight: 100;\r\n	color: #ffffff;\r\n	text-shadow: #000000 1px 1px 1px;\r\n  	font-size: 17px;\r\n  	[if bg_type_4 == \'color\']\r\n  	color: [bg_color_4];\r\n  	[elseif bg_type_4 == \'img\']\r\n  	[endif]\r\n}\r\n\r\n#ppsPopupShell_[ID] .ppsPopupTxt_0 {\r\n  	margin: 20px;\r\n  	margin-left: 70px;\r\n	margin-right: 40px;\r\n}\r\n#ppsPopupShell_[ID] .ppsPopupClose {\r\n	background-repeat: no-repeat;\r\n  	cursor: pointer;\r\n}\r\n#ppsPopupShell_[ID] .ppsPopupClose.ppsPopupClose_lists_black {\r\n 	top: 0 !important;\r\n  	right: 0 !important;\r\n}\r\n#ppsPopupShell_[ID] .ppsPopupClose:hover {\r\n	opacity: 0.8;\r\n}\r\n#ppsPopupShell_[ID] .ppsFootNote{\r\n  	padding-left: 30px;\r\n	background-image: url(\"[PPS_ASSETS_URL]img/assets/security_ico.png\");\r\n	background-repeat: no-repeat;\r\n	background-position: 5px center;\r\n  	height: 20px;\r\n  	[if bg_type_4 == \'color\']\r\n  	color: [bg_color_4];\r\n  	[elseif bg_type_4 == \'img\']\r\n  	[endif]\r\n    font-family: \"Helvetica Neue\",Helvetica,Arial,sans-serif;\r\n    font-size: x-small;\r\n    font-style: italic;\r\n    line-height: 14px;\r\n  	margin: 5px 30px;\r\n}\r\n@media (max-width: 768px) {\r\n  #ppsPopupShell_[ID] .ppsPopupLabel {\r\n  	padding-left: 0;\r\n    text-align: center;\r\n  }\r\n  #ppsPopupShell_[ID] .ppsPopupLabel,\r\n  #ppsPopupShell_[ID] .ppsPopupTxt_0 {\r\n  	margin-left: 20px;\r\n  }\r\n  #ppsPopupShell_[ID] .ppsSubscribeShell form {\r\n  	padding-left: 20px;\r\n  }\r\n  #ppsPopupShell_[ID] .mail-img {\r\n  	left: 50%;\r\n    top: -30px;\r\n    transform: translate(-50%, 0);\r\n  }\r\n}","pink.png","1","1","1","1","2015-01-10 18:59:43","4"),
("17","Exclusive Listings","1","0","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","<link rel=\"stylesheet\" type=\"text/css\" href=\"//fonts.googleapis.com/css?family=Amatic+SC\" />\r\n<div id=\"ppsPopupShell_[ID]\" class=\"ppsPopupShell ppsPopupListsShell\">\r\n	<a href=\"#\" class=\"ppsPopupClose ppsPopupClose_[close_btn]\"></a>\r\n	<div class=\"ppsInnerTblContent\">\r\n		<div class=\"ppsPopupListsInner ppsPopupInner\">\r\n			[if enb_label]\r\n				<div class=\"ppsPopupLabel ppsPopupListsLabel\">[label]</div>\r\n			[endif]\r\n			<div style=\"clear: both;\"></div>\r\n			[if enb_txt_0]\r\n				<div class=\"ppsPopupTxt ppsPopupClassyTxt ppsPopupClassyTxt_0 ppsPopupTxt_0\">\r\n				[txt_0]\r\n				</div>\r\n			[endif]\r\n			[if enb_subscribe]\r\n				<div class=\"ppsSubscribeShell\">\r\n					[sub_form_start]\r\n					[sub_fields_html]\r\n					<input class=\"butt\" type=\"submit\" name=\"submit\" value=\"[sub_btn_label]\" />\r\n					[sub_form_end]\r\n					<div style=\"clear: both;\"></div>\r\n				</div>\r\n			[endif]\r\n			<div style=\"clear: both;\"></div>\r\n			<div class=\"ppsRightCol\">\r\n				[if enb_sm]\r\n					<div style=\"clear: both;\"></div>\r\n					<div class=\"ppsSm\">\r\n					[sm_html]\r\n					</div>\r\n				[endif]\r\n				[if enb_foot_note]\r\n					<div class=\"ppsFootNote\">\r\n					[foot_note]\r\n					</div>\r\n				[endif]\r\n			</div>\r\n		</div>\r\n	</div>\r\n</div>","#ppsPopupShell_[ID] {\r\n	width: [width][width_measure];\r\n  	padding: 15px;\r\n  	font-family: \'arial\', arial;\r\n	font-size: 13px;\r\n	line-height: 21px;\r\n	font-weight: normal;\r\n}\r\n#ppsPopupShell_[ID], #ppsPopupShell_[ID] * {\r\n	-webkit-box-sizing: content-box;\r\n	-moz-box-sizing:    content-box;\r\n	box-sizing:         content-box;\r\n}\r\n#ppsPopupShell_[ID] .ppsPopupInner {\r\n  {% if popup.params.tpl.enb_subscribe or popup.params.tpl.enb_foot_note or popup.params.tpl.enb_sm %}\r\n  	width: 100%;\r\n  	border-image: url(\"[bg_img_2]\") 2 round;\r\n  	-moz-border-image: url(\"[bg_img_2]\") 2 round;\r\n  	-o-border-image: url(\"[bg_img_2]\") 2 round;\r\n  	border-width: 5px;\r\n  	border-radius: 4px;\r\n  	border-style: solid;\r\n	[else]\r\n  	width: 100%;\r\n  	[endif]\r\n  	padding: 10px;\r\n	[if bg_type_0 == \'color\']\r\n	background: -moz-radial-gradient(center, ellipse cover, {{ adjust_brightness(popup.params.tpl.bg_color_0, 50) }} 0%, [bg_color_0] 100%); /* ff3.6+ */\r\n	background: -webkit-gradient(radial, center center, 0px, center center, 100%, color-stop(0%, {{ adjust_brightness(popup.params.tpl.bg_color_0, 50) }}), color-stop(100%, [bg_color_0])); /* safari4+,chrome */\r\n	background:-webkit-radial-gradient(center, ellipse cover, {{ adjust_brightness(popup.params.tpl.bg_color_0, 50) }} 0%, [bg_color_0] 100%); /* safari5.1+,chrome10+ */\r\n	background: -o-radial-gradient(center, ellipse cover, {{ adjust_brightness(popup.params.tpl.bg_color_0, 50) }} 0%, [bg_color_0] 100%); /* opera 11.10+ */\r\n	background: -ms-radial-gradient(center, ellipse cover, {{ adjust_brightness(popup.params.tpl.bg_color_0, 50) }} 0%, [bg_color_0] 100%); /* ie10+ */\r\n	background:radial-gradient(ellipse at center, {{ adjust_brightness(popup.params.tpl.bg_color_0, 50) }} 0%, [bg_color_0] 100%); /* w3c */\r\n	filter: progid:DXImageTransform.Microsoft.gradient( startColorstr=\'{{ adjust_brightness(popup.params.tpl.bg_color_0, 50) }}\', endColorstr=\'[bg_color_0]\',GradientType=1 ); /* ie6-9 */\r\n  	[elseif bg_type_0 == \'img\']\r\n  	background-image: url(\"[bg_img_0]\");\r\n  	background-repeat: no-repeat;\r\n  	background-size: cover;\r\n  	[endif]\r\n}\r\n#ppsPopupShell_[ID] .ppsPopupLabel {\r\n	color: #000;\r\n    font-family: \'PT Sans\', sans-serif;\r\n	text-align: center;\r\n	font-size: 28px;\r\n	letter-spacing: -1px;\r\n	line-height: 40px;\r\n	letter-spacing: -1px;\r\n	margin-top: 15px;\r\n	display: block;\r\n  	margin-bottom: 15px;;\r\n	padding-left: 20px;\r\n	-moz-text-shadow: 0px 0px 1px #000;\r\n	-webkit-text-shadow: 0px 0px 1px #000;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell form {\r\n	padding: 1% 1% 1% 1%;\r\n	text-align:right;\r\n	margin-bottom: 20px;\r\n  	padding-left: 20px;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell input,\r\n#ppsPopupShell_[ID] .ppsSubscribeShell .ppsSubSelect,\r\n#ppsPopupShell_[ID] .ppsSubscribeShell textarea {\r\n	/*width: 100%;*/\r\n  	margin-bottom: 10px;\r\n  	height: 40px;\r\n  	border: 0px solid #d1b36d;\r\n	border-radius: 4px !important;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell input[type=text],#ppsPopupShell_[ID] .ppsSubscribeShell input[type=email],#ppsPopupShell_[ID] .ppsSubscribeShell input[type=password],#ppsPopupShell_[ID] .ppsSubscribeShell input[type=email],\r\n#ppsPopupShell_[ID] .ppsSubscribeShell .ppsSubSelect,\r\n#ppsPopupShell_[ID] .ppsSubscribeShell textarea {\r\n	box-shadow: 2px 2px 2px #dcdcdc inset;\r\n  	padding-left: 20px;\r\n  	font-size: 15px;\r\n	width:100%;\r\n  	max-width: 284px;\r\n	display: block;\r\n	float: left;\r\n  	border: 1px solid #e2e2e2;\r\n  	margin-top: 1px;\r\n  	background-color: #fff;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell .ppsSubSelect {\r\n	display: table;\r\n  	text-align: left;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell .ppsSubSelectLabel,\r\n#ppsPopupShell_[ID] .ppsSubscribeShell select {\r\n	display: table-cell;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell .ppsSubSelectLabel {\r\n	opacity: 0.5;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell select {\r\n	width: 100%;\r\n  	background-color: transparent;\r\n  	height: 40px;\r\n  	border: none;\r\n  	font-size: 17px;\r\n  	border-radius: 4px !important;\r\n  	margin-left: -1px;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell textarea {\r\n	font-family: inherit;\r\n  	height: auto;\r\n    padding-top: 5px;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell input[type=submit] {\r\n	border-color: #000;\r\n	width: 30%;\r\n  	padding: 6px 0 0 0;\r\n  	text-align: center;\r\n  	cursor: pointer;\r\n  	text-decoration: none;\r\n  	color: #333333;\r\n  	font-size: 17px;\r\n  	font-family: \'PT Sans\', sans-serif;\r\n  	text-shadow: 0px 1px 0px #FFF;\r\n  	display:block;\r\n  	float: left;\r\n	margin-left: 30px;\r\n  	[if bg_type_1 == \'color\']\r\n  	background: [bg_color_1] 100%;\r\n   	box-shadow: -4px -4px 0px rgba(0, 0, 0, 0.1) inset;\r\n  	[elseif bg_type_1 == \'img\']\r\n  	background-image: url(\"[bg_img_1]\");\r\n  	background-repeat: no-repeat;\r\n  	background-size: cover;\r\n  	[endif]\r\n  \r\n  	color: #fff;\r\n    font-size: 20px;\r\n    text-shadow: 1px 1px 1px #000;\r\n  	cursor: pointer;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell input[type=submit]:hover {\r\n   box-shadow: 4px 4px 0px rgba(0, 0, 0, 0.1) inset;\r\n}\r\n#ppsPopupShell_[ID] .ppsPopupTxt_0 {\r\n	float: left;\r\n  	width: 90%;\r\n	font-family: \'PT Serif\', serif;\r\n  	color: #666666;\r\n  	font-size: 15px;\r\n  	line-height: 22px;\r\n  	display: block;\r\n  	margin-bottom: 27px;\r\n    padding: 0px 20px 0px 20px;\r\n}\r\n#ppsPopupShell_[ID] .ppsPopupClose {\r\n	background-repeat: no-repeat;\r\n  	cursor: pointer;\r\n	top: 15px;\r\n}\r\n#ppsPopupShell_[ID] .ppsPopupClose.ppsPopupClose_lists_black {\r\n 	top: 0 !important;\r\n  	right: 0 !important;\r\n}\r\n#ppsPopupShell_[ID] .ppsPopupClose:hover {\r\n	opacity: 0.8;\r\n}\r\n#ppsPopupShell_[ID] .ppsFootNote{\r\n	color: #585858;\r\n    font-family: \"Helvetica Neue\",Helvetica,Arial,sans-serif;\r\n    font-size: x-small;\r\n    font-style: italic;\r\n    line-height: 14px;\r\n  	margin: 5px 30px;\r\n}\r\n#ppsPopupShell_[ID] .ppsSm{\r\n	margin-top:20px;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubMsg {\r\n	clear: both;\r\n   	float: left;\r\n}\r\n","ExcluziveListings.jpg","1","1","1","1","2015-01-10 18:59:43","15"),
("18","Best Of Collection","1","0","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","<link rel=\"stylesheet\" type=\"text/css\" href=\"//fonts.googleapis.com/css?family=Amatic+SC\" />\r\n<div id=\"ppsPopupShell_[ID]\" class=\"ppsPopupShell ppsPopupListsShell\">\r\n	<a href=\"#\" class=\"ppsPopupClose ppsPopupClose_[close_btn]\"></a>\r\n	<div class=\"ppsInnerTblContent\">\r\n		<div class=\"ppsPopupListsInner ppsPopupInner\">\r\n			[if enb_label]\r\n				<div class=\"ppsPopupLabel ppsPopupListsLabel\">[label]</div>\r\n			[endif]\r\n			<div style=\"clear: both;\"></div>\r\n			[if enb_txt_0]\r\n				<div class=\"ppsPopupTxt ppsPopupClassyTxt ppsPopupClassyTxt_0 ppsPopupTxt_0\">\r\n				[txt_0]\r\n				</div>\r\n			[endif]\r\n			<div class=\"ppsPopupLogo\"></div>\r\n			[if enb_subscribe]\r\n				<div class=\"ppsSubscribeShell\">\r\n					[sub_form_start]\r\n						[sub_fields_html]\r\n						<input class=\"butt\" type=\"submit\" name=\"submit\" value=\"[sub_btn_label]\" />\r\n					[sub_form_end]\r\n					<div style=\"clear: both;\"></div>\r\n				</div>\r\n			[endif]\r\n			<div style=\"clear: both;\"></div>\r\n			<div class=\"ppsRightCol\">\r\n				[if enb_sm]\r\n					<div style=\"clear: both;\"></div>\r\n					<div class=\"ppsSm\">\r\n					[sm_html]\r\n					</div>\r\n				[endif]\r\n				[if enb_foot_note]\r\n					<div class=\"ppsFootNote\">\r\n					[foot_note]\r\n					</div>\r\n				[endif]\r\n				<div>\r\n				</div>\r\n			</div>\r\n		</div>\r\n	</div>\r\n</div>","#ppsPopupShell_[ID] {\r\n	width: [width][width_measure];\r\n  	padding: 15px;\r\n  	font-family: \'arial\', arial;\r\n	font-size: 13px;\r\n	line-height: 21px;\r\n	font-weight: normal;\r\n}\r\n#ppsPopupShell_[ID] .ppsInnerTblContent {\r\n	\r\n}\r\n#ppsPopupShell_[ID] .ppsPopupInner {\r\n  {% if popup.params.tpl.enb_subscribe or popup.params.tpl.enb_foot_note or popup.params.tpl.enb_sm %}\r\n  	width: 100%;\r\n  	border-width: 5px;\r\n  	border-radius: 4px;\r\n    box-shadow: 0 0 10px rgba(0,0,0,0.5);\r\n	[else]\r\n  	width: 100%;\r\n  	[endif]\r\n    padding: 10px 0 2px 0;\r\n	[if bg_type_0 == \'color\']\r\n	background: -moz-radial-gradient(center, ellipse cover, {{ adjust_brightness(popup.params.tpl.bg_color_0, 50) }} 0%, [bg_color_0] 100%); /* ff3.6+ */\r\n	background: -webkit-gradient(radial, center center, 0px, center center, 100%, color-stop(0%, {{ adjust_brightness(popup.params.tpl.bg_color_0, 50) }}), color-stop(100%, [bg_color_0])); /* safari4+,chrome */\r\n	background:-webkit-radial-gradient(center, ellipse cover, {{ adjust_brightness(popup.params.tpl.bg_color_0, 50) }} 0%, [bg_color_0] 100%); /* safari5.1+,chrome10+ */\r\n	background: -o-radial-gradient(center, ellipse cover, {{ adjust_brightness(popup.params.tpl.bg_color_0, 50) }} 0%, [bg_color_0] 100%); /* opera 11.10+ */\r\n	background: -ms-radial-gradient(center, ellipse cover, {{ adjust_brightness(popup.params.tpl.bg_color_0, 50) }} 0%, [bg_color_0] 100%); /* ie10+ */\r\n	background:radial-gradient(ellipse at center, {{ adjust_brightness(popup.params.tpl.bg_color_0, 50) }} 0%, [bg_color_0] 100%); /* w3c */\r\n	filter: progid:DXImageTransform.Microsoft.gradient( startColorstr=\'{{ adjust_brightness(popup.params.tpl.bg_color_0, 50) }}\', endColorstr=\'[bg_color_0]\',GradientType=1 ); /* ie6-9 */\r\n  	[elseif bg_type_0 == \'img\']\r\n  	background-image: url(\"[bg_img_0]\");\r\n  	background-repeat: no-repeat;\r\n  	background-size: cover;\r\n  	[endif]\r\n  	\r\n}\r\n#ppsPopupShell_[ID] .ppsPopupLabel {\r\n	color: #000;\r\n      font-family: Comic Sans, Comic Sans MS, cursive;\r\n	text-align: center;\r\n	font-size: 28px;\r\n	letter-spacing: -1px;\r\n	line-height: 40px;\r\n	letter-spacing: -1px;\r\n	margin-top: 15px;\r\n	display: block;\r\n  	margin-bottom: 15px;;\r\n	padding-left: 20px;\r\n	-moz-text-shadow: 0px 0px 1px #000;\r\n	-webkit-text-shadow: 0px 0px 1px #000;\r\n}\r\n\r\n.ppsPopupLogo{\r\n  width: 100%;\r\n  height: 200px;\r\n  float: left;\r\n [if bg_type_2 == \'color\']\r\n  	background: [bg_color_2] 100%;\r\n  [elseif bg_type_2 == \'img\']\r\n  	background-image: url(\"[bg_img_2]\");\r\n  	background-repeat: no-repeat;\r\n  	background-size: cover;\r\n  	[endif]\r\n}\r\n\r\n#ppsPopupShell_[ID] .ppsSubscribeShell form {\r\n	padding: 1% 1% 1% 1%;\r\n	margin-bottom: 20px;\r\n  	padding-left: 20px;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell input {\r\n	/*width: 100%;*/\r\n  	margin-bottom: 10px;\r\n  	height: 30px;\r\n  	border: 0px solid #d1b36d;\r\n	border-radius: 4px !important;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell input[type=text],#ppsPopupShell_[ID] .ppsSubscribeShell input[type=email],#ppsPopupShell_[ID] .ppsSubscribeShell input[type=password],#ppsPopupShell_[ID] .ppsSubscribeShell input[type=email] {\r\n  -webkit-transition: opacity .5s;\r\n  transition: opacity .5s;\r\n  border-radius: 5px;\r\n  -moz-border-radius: 5px;\r\n  -webkit-border-radius: 5px;\r\n  margin: 0 0 10px;\r\n  width: 80%;\r\n  background: #f8fafa;\r\n  padding: 11px 20px;\r\n  border: 1px solid #e4e9e9;\r\n  color: #b3b3b3;\r\n  font-size: 13px;\r\n  	height: 35px;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell input[type=text],#ppsPopupShell_[ID] .ppsSubscribeShell input[type=email],#ppsPopupShell_[ID] .ppsSubscribeShell input[name=\"email\"] {\r\n    -webkit-transition: opacity .5s;\r\n  transition: opacity .5s;\r\n  border-radius: 5px;\r\n  -moz-border-radius: 5px;\r\n  -webkit-border-radius: 5px;\r\n  margin: 0 0 10px;\r\n  width: 80%;\r\n  background: #f8fafa;\r\n  padding: 11px 20px;\r\n  border: 1px solid #e4e9e9;\r\n  color: #b3b3b3;\r\n  font-size: 13px;\r\n  	height: 35px;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell input[type=submit] {\r\n\r\n  -webkit-transition: opacity .5s ease,background-color .5s ease;\r\n  transition: opacity .5s ease,background-color .5s ease;\r\n  border-radius: 5px;\r\n  -moz-border-radius: 5px;\r\n  -webkit-border-radius: 5px;\r\n  border: none;\r\n  width: 100%;\r\n  height: 40px;\r\n  color: #fff;\r\n  font-size: 16px;\r\n  font-family: Comic Sans, Comic Sans MS, cursive;\r\n [if bg_type_1 == \'color\']\r\n  	background: [bg_color_1] 100%;\r\n  [elseif bg_type_1 == \'img\']\r\n  	background-image: url(\"[bg_img_1]\");\r\n  	background-repeat: no-repeat;\r\n  	background-size: cover;\r\n  	[endif]\r\n  padding: 11px 0 10px;\r\n  text-align: center;\r\n  cursor: pointer;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell input[type=submit]:hover {\r\n   box-shadow: 4px 4px 0px rgba(0, 0, 0, 0.1) inset;\r\n	\r\n}\r\n#ppsPopupShell_[ID] .ppsPopupTxt_0 {\r\n	float: left;\r\n  	width: 90%;\r\n	font-family: \'PT Serif\', serif;\r\n  	color: #000000;\r\n  	font-size: 15px;\r\n  	line-height: 22px;\r\n  	display: block;\r\n    padding: 0px 20px 0px 20px;\r\n}\r\n#ppsPopupShell_[ID] .ppsPopupTxt_0 p{font-family:Comic Sans, Comic Sans MS, cursive;}\r\n\r\n#ppsPopupShell_[ID] .ppsPopupClose {\r\n	background-repeat: no-repeat;\r\n  	cursor: pointer;\r\n	top: 15px;\r\n}\r\n#ppsPopupShell_[ID] .ppsPopupClose.ppsPopupClose_lists_black {\r\n 	top: 0 !important;\r\n  	right: 0 !important;\r\n}\r\n#ppsPopupShell_[ID] .ppsPopupClose:hover {\r\n	opacity: 0.8;\r\n}\r\n#ppsPopupShell_[ID] .ppsFootNote{\r\n	color: #585858;\r\n    font-family: \"Helvetica Neue\",Helvetica,Arial,sans-serif;\r\n    font-size: x-small;\r\n    font-style: italic;\r\n    line-height: 14px;\r\n  	margin: 5px 30px;\r\n}\r\n#ppsPopupShell_[ID] .ppsSm{\r\n	margin-top:20px;\r\n}","BestOfCollection.png","1","1","1","1","2015-01-10 18:59:43","22"),
("19","Business","1","0","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","<link rel=\"stylesheet\" type=\"text/css\" href=\"//fonts.googleapis.com/css?family=Dancing+Script\" />\r\n<link rel=\"stylesheet\" type=\"text/css\" href=\"//fonts.googleapis.com/css?family=Didact+Gothic\" />\r\n<div id=\"ppsPopupShell_[ID]\" class=\"ppsPopupShell ppsPopupListsShell\">\r\n	<a href=\"#\" class=\"ppsPopupClose ppsPopupClose_[close_btn]\"></a>\r\n	<div class=\"ppsInnerTblContent\">\r\n		<div class=\"ppsPopupListsInner ppsPopupInner\">\r\n			<div style=\"clear: both;\"></div>\r\n			<div class=\"ppsRightCol\">\r\n				[if enb_txt_1]\r\n					<div class=\"ppsPopupTxt ppsPopupClassyTxt ppsPopupClassyTxt_1 ppsPopupTxt_1\">\r\n					[txt_1]\r\n					</div>\r\n				[endif]\r\n				<div class=\"logo\">\r\n              		[if bg_type_2 == \'img\']\r\n                  		<img src=\"[bg_img_2]\" />\r\n                  	[endif]\r\n              	</div>\r\n				[if enb_label]\r\n					<div class=\"label-window\">\r\n						<div class=\"ppsPopupLabel ppsPopupListsLabel\">[label]</div>\r\n					</div>\r\n				[endif]\r\n				[if enb_txt_0]\r\n					<div class=\"ppsPopupTxt ppsPopupClassyTxt ppsPopupClassyTxt_0 ppsPopupTxt_0\">\r\n					[txt_0]\r\n					</div>\r\n				[endif]\r\n				<div style=\"clear: both;\"></div>\r\n				[if enb_subscribe]\r\n					<div class=\"ppsSubscribeShell\">\r\n						[sub_form_start]\r\n						[sub_fields_html]\r\n						<input type=\"submit\" name=\"submit\" value=\"[sub_btn_label]\" />\r\n						[sub_form_end]\r\n						<div style=\"clear: both;\"></div>\r\n					</div>\r\n				[endif]\r\n				[if enb_sm]\r\n					<div class=\"ppsSm\">\r\n					[sm_html]\r\n					</div>\r\n				[endif]\r\n				[if enb_foot_note]\r\n					<div class=\"ppsFootNote\">\r\n					[foot_note]\r\n					</div>\r\n				[endif]\r\n			</div>\r\n		</div>\r\n	</div>\r\n</div>","#ppsPopupShell_[ID] {\r\n	width: [width][width_measure];\r\n  	padding: 15px;\r\n  	font-family: Georgia, Times, serif;\r\n	font-size: 13px;\r\n	line-height: 21px;\r\n	font-weight: normal;\r\n	color: #000;\r\n}\r\n#ppsPopupShell_[ID] .ppsInnerTblContent {\r\n	display: table;\r\n  [if bg_type_0 == \'color\']\r\n	background: -moz-radial-gradient(center, ellipse cover, {{ adjust_brightness(popup.params.tpl.bg_color_0, 50) }} 0%, [bg_color_0] 100%); /* ff3.6+ */\r\n	background: -webkit-gradient(radial, center center, 0px, center center, 100%, color-stop(0%, {{ adjust_brightness(popup.params.tpl.bg_color_0, 50) }}), color-stop(100%, [bg_color_0])); /* safari4+,chrome */\r\n	background:-webkit-radial-gradient(center, ellipse cover, {{ adjust_brightness(popup.params.tpl.bg_color_0, 50) }} 0%, [bg_color_0] 100%); /* safari5.1+,chrome10+ */\r\n	background: -o-radial-gradient(center, ellipse cover, {{ adjust_brightness(popup.params.tpl.bg_color_0, 50) }} 0%, [bg_color_0] 100%); /* opera 11.10+ */\r\n	background: -ms-radial-gradient(center, ellipse cover, {{ adjust_brightness(popup.params.tpl.bg_color_0, 50) }} 0%, [bg_color_0] 100%); /* ie10+ */\r\n	background:radial-gradient(ellipse at center, {{ adjust_brightness(popup.params.tpl.bg_color_0, 50) }} 0%, [bg_color_0] 100%); /* w3c */\r\n	filter: progid:DXImageTransform.Microsoft.gradient( startColorstr=\'{{ adjust_brightness(popup.params.tpl.bg_color_0, 50) }}\', endColorstr=\'[bg_color_0]\',GradientType=1 ); /* ie6-9 */\r\n  	[elseif bg_type_0 == \'img\']\r\n  	background-image: url(\"[bg_img_0]\");\r\n  	background-repeat: no-repeat;\r\n  	background-size: cover;\r\n  	[endif]\r\n}\r\n#ppsPopupShell_[ID] .ppsPopupInner {\r\n  {% if popup.params.tpl.enb_subscribe or popup.params.tpl.enb_foot_note or popup.params.tpl.enb_sm %}\r\n  	width: 50%;\r\n	[else]\r\n  	width: 100%;\r\n  	[endif]\r\n  	display: table-cell;\r\n}\r\n#ppsPopupShell_[ID] .label-window{\r\n    width: 100%;\r\n    padding-top: 10px;\r\n    padding-bottom: 10px;\r\n    margin-top: 20px;\r\n}\r\n\r\n#ppsPopupShell_[ID] .ppsPopupLabel {\r\n	color: #000;\r\n	font-family: \'Dancing Script\';\r\n	font-size: 56px;\r\n	font-weight: 100;\r\n	color: #000;\r\n	text-shadow: #000000 1px 1px 1px;\r\n	\r\n	padding-left: 20px;\r\n  	text-align:center;\r\n  	line-height: 1em;\r\n}\r\n#ppsPopupShell_[ID] .ppsRightCol {\r\n	/*display: table-cell;*/\r\n  	float:right;\r\n  	width: 40%;\r\n  	border-radius:20px;\r\n  	height: 100%;\r\n  	margin-bottom: 30px;\r\n  	margin-right: 30px;\r\n  	margin-top: 65px;\r\n  	background-color: #ebecec;\r\n  	background-repeat: no-repeat;\r\n  	background-size: cover;\r\n}\r\n\r\n#ppsPopupShell_[ID] .ppsRightCol .logo{\r\n  	display: block;\r\n    width: 100%;\r\n  	text-align: center;\r\n}\r\n#ppsPopupShell_[ID] .ppsRightCol .logo img {\r\n	max-height: 220px;\r\n  	width: auto;\r\n  	max-width: 100%;\r\n}\r\n\r\n#ppsPopupShell_[ID] .ppsSubscribeShell form {\r\n	padding: 1px 30px 0;\r\n	text-align: right;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell input,\r\n#ppsPopupShell_[ID] .ppsSubscribeShell .ppsSubSelect,\r\n#ppsPopupShell_[ID] .ppsSubscribeShell textarea {\r\n	width: 100%;\r\n  	margin-bottom: 10px;\r\n  	height: 40px;\r\n  	border: none;\r\n  	border-radius: 3px;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell input[type=text],#ppsPopupShell_[ID] .ppsSubscribeShell input[type=email],#ppsPopupShell_[ID] .ppsSubscribeShell input[type=password],#ppsPopupShell_[ID] .ppsSubscribeShell input[type=email],\r\n#ppsPopupShell_[ID] .ppsSubscribeShell .ppsSubSelect,\r\n#ppsPopupShell_[ID] .ppsSubscribeShell textarea {\r\n  	padding-left: 10px;\r\n  	font-size: 17px;\r\n  	color: #000;\r\n  	border: 1px solid #928C8C;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell .ppsSubSelect {\r\n	display: table;\r\n  	text-align: left;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell .ppsSubSelectLabel,\r\n#ppsPopupShell_[ID] .ppsSubscribeShell select {\r\n	display: table-cell;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell .ppsSubSelectLabel {\r\n	opacity: 0.5;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell select {\r\n	width: 100%;\r\n  	background-color: transparent;\r\n  	height: 40px;\r\n  	border: none;\r\n  	font-size: 17px;\r\n  	color: #fff;\r\n  	border-top-right-radius: 3px;\r\n  	border-bottom-right-radius: 3px;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell textarea {\r\n	font-family: inherit;\r\n  	height: auto;\r\n    padding-top: 5px;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell input[type=submit] {\r\n	border-color: #000;\r\n  	font-family: \'Open Sans\', arial;\r\n	font-weight: 100;\r\n	color: #ffffff;\r\n  	width: 104%;\r\n	text-shadow: #000000 1px 1px 1px;\r\n  	[if bg_type_1 == \'color\']\r\n  	background: [bg_color_1];\r\n    background: -moz-linear-gradient(90deg, [bg_color_2] 0%, {{ adjust_brightness(popup.params.tpl.bg_color_2, 100) }} 63%);\r\n    background: -webkit-linear-gradient(270deg, [bg_color_2] 0%, {{ adjust_brightness(popup.params.tpl.bg_color_2, 100) }} 63%);\r\n    background: -o-linear-gradient(270deg, [bg_color_2] 0%, {{ adjust_brightness(popup.params.tpl.bg_color_2, 100) }} 63%);\r\n    background: -ms-linear-gradient(270deg, [bg_color_2] 0%, {{ adjust_brightness(popup.params.tpl.bg_color_2, 100) }} 63%);\r\n    background: linear-gradient(0deg, [bg_color_2]) 0%, {{ adjust_brightness(popup.params.tpl.bg_color_2, 100) }} 63%);\r\n  	[elseif bg_type_1 == \'img\']\r\n  	background-image: url(\"[bg_img_1]\");\r\n  	background-repeat: no-repeat;\r\n  	background-size: cover;\r\n  	[endif]\r\n  \r\n  	\r\n  	cursor: pointer;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell input[type=submit]:hover {\r\n	box-shadow: inset 1px 1px 3px #666;\r\n}\r\n#ppsPopupShell_[ID] .ppsPopupTxt_0 {\r\n  	text-align: center;\r\n  	font-family: \'Didact Gothic\';\r\n 	font-weight: 100;\r\n	color: #000;\r\n  	font-size: 18px;\r\n}\r\n\r\n#ppsPopupShell_[ID] .ppsPopupTxt_0 {\r\n  	margin: 2px;\r\n}\r\n\r\n#ppsPopupShell_[ID] .ppsPopupTxt_1 {\r\n  	text-align: center;\r\n  	font-family: \'Didact Gothic\';\r\n 	font-weight: 100;\r\n	color: #000;\r\n  	font-size: 24px;\r\n}\r\n\r\n#ppsPopupShell_[ID] .ppsPopupTxt_1 {\r\n  	margin: 20px 0px 20px 0px;\r\n}\r\n\r\n#ppsPopupShell_[ID] .ppsPopupClose {\r\n	background-repeat: no-repeat;\r\n  	cursor: pointer;\r\n}\r\n#ppsPopupShell_[ID] .ppsPopupClose.ppsPopupClose_lists_black {\r\n 	top: 0 !important;\r\n  	right: 0 !important;\r\n}\r\n#ppsPopupShell_[ID] .ppsPopupClose:hover {\r\n	opacity: 0.8;\r\n}\r\n#ppsPopupShell_[ID] .ppsFootNote{\r\n	color: #585858;\r\n    font-family: \"Helvetica Neue\",Helvetica,Arial,sans-serif;\r\n    font-size: x-small;\r\n    font-style: italic;\r\n    line-height: 14px;\r\n  	margin: 5px 30px;\r\n}","bussines.png","1","1","1","1","2015-01-10 18:59:43","18"),
("20","Discount","1","0","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","<link rel=\"stylesheet\" type=\"text/css\" href=\"//fonts.googleapis.com/css?family=Didact+Gothic\" />\r\n<div id=\"ppsPopupShell_[ID]\" class=\"ppsPopupShell ppsPopupListsShell\">\r\n	<div class=\"ppsInnerTblContent\">\r\n		<div class=\"ppsPopupListsInner ppsPopupInner\">\r\n			<div class=\"mail-img\"></div>\r\n			<div style=\"clear: both;\"></div>\r\n			<div class=\"ppsRightCol\">\r\n				[if enb_label]\r\n					<div class=\"ppsPopupLabel ppsPopupListsLabel\">[label]</div>\r\n				[endif]\r\n				<div class=\"logo\"></div>\r\n				[if enb_txt_0]\r\n					<div class=\"ppsPopupTxt ppsPopupClassyTxt ppsPopupClassyTxt_0 ppsPopupTxt_0\">\r\n					[txt_0]\r\n					</div>\r\n				[endif]\r\n				<div style=\"clear: both;\"></div>\r\n				[if enb_subscribe]\r\n					<div class=\"ppsSubscribeShell\">\r\n						[sub_form_start]\r\n						[sub_fields_html]\r\n						<input class=\"singup\" type=\"submit\" name=\"submit\" value=\"[sub_btn_label]\" />\r\n						<input class=\"ppsPopupClose ppsPopupClose_[close_btn]\" type=\"submit\" name=\"submit\" value=\"Exit\"/>\r\n						[sub_form_end]\r\n						<div style=\"clear: both;\"></div>\r\n					</div>\r\n				[endif]\r\n				[if enb_sm]\r\n					<div class=\"ppsSm\">\r\n					[sm_html]\r\n					</div>\r\n				[endif]\r\n				[if enb_foot_note]\r\n					<div class=\"ppsFootNote\">\r\n					[foot_note]\r\n					</div>\r\n				[endif]\r\n			</div>\r\n		</div>\r\n	</div>\r\n</div>","#ppsPopupShell_[ID] {\r\n	width: [width][width_measure];\r\n  	padding: 15px;\r\n  	font-family: Georgia, Times, serif;\r\n	font-size: 13px;\r\n	line-height: 21px;\r\n	font-weight: normal;\r\n	color: #000;\r\n}\r\n#ppsPopupShell_[ID], #ppsPopupShell_[ID] * {\r\n	-webkit-box-sizing: content-box;\r\n	-moz-box-sizing:    content-box;\r\n	box-sizing:         content-box;\r\n}\r\n#ppsPopupShell_[ID] .ppsInnerTblContent {\r\n	display: table;\r\n  [if bg_type_0 == \'color\']\r\n	background: -moz-radial-gradient(center, ellipse cover, {{ adjust_brightness(popup.params.tpl.bg_color_0, 50) }} 0%, [bg_color_0] 100%); /* ff3.6+ */\r\n	background: -webkit-gradient(radial, center center, 0px, center center, 100%, color-stop(0%, {{ adjust_brightness(popup.params.tpl.bg_color_0, 50) }}), color-stop(100%, [bg_color_0])); /* safari4+,chrome */\r\n	background:-webkit-radial-gradient(center, ellipse cover, {{ adjust_brightness(popup.params.tpl.bg_color_0, 50) }} 0%, [bg_color_0] 100%); /* safari5.1+,chrome10+ */\r\n	background: -o-radial-gradient(center, ellipse cover, {{ adjust_brightness(popup.params.tpl.bg_color_0, 50) }} 0%, [bg_color_0] 100%); /* opera 11.10+ */\r\n	background: -ms-radial-gradient(center, ellipse cover, {{ adjust_brightness(popup.params.tpl.bg_color_0, 50) }} 0%, [bg_color_0] 100%); /* ie10+ */\r\n	background:radial-gradient(ellipse at center, {{ adjust_brightness(popup.params.tpl.bg_color_0, 50) }} 0%, [bg_color_0] 100%); /* w3c */\r\n	filter: progid:DXImageTransform.Microsoft.gradient( startColorstr=\'{{ adjust_brightness(popup.params.tpl.bg_color_0, 50) }}\', endColorstr=\'[bg_color_0]\',GradientType=1 ); /* ie6-9 */\r\n  	[elseif bg_type_0 == \'img\']\r\n  	background-image: url(\"[bg_img_0]\");\r\n  	background-repeat: no-repeat;\r\n  	background-size: cover;\r\n  	[endif]\r\n}\r\n#ppsPopupShell_[ID] .ppsPopupInner {\r\n  	{% if popup.params.tpl.enb_subscribe or popup.params.tpl.enb_foot_note or popup.params.tpl.enb_sm %}\r\n  	width: 50%;\r\n	[else]\r\n  	width: 100%;\r\n  	[endif]\r\n  	display: table-cell;\r\n}\r\n#ppsPopupShell_[ID] .ppsPopupLabel {\r\n	color: #000;\r\n	font-family: \'Didact Gothic\';\r\n	font-size: 50px;\r\n  	font-style: normal;\r\n	font-variant: normal;\r\n	font-weight: 500;\r\n	line-height: 46.4px;\r\n	color: #ffffff;\r\n	margin-bottom: 16px;\r\n	padding-left: 50px;\r\n  	width:60%;\r\n  	float: left;\r\n	[if bg_type_4 == \'color\']\r\n  	color: [bg_color_4];\r\n  	[elseif bg_type_4 == \'img\']\r\n  	[endif]\r\n}\r\n#ppsPopupShell_[ID] .mail-img{\r\n	[if bg_type_1 == \'color\']\r\n	background: [bg_color_1];\r\n  	[elseif bg_type_1 == \'img\']\r\n  	background-image: url(\"[bg_img_1]\");\r\n  	background-repeat: no-repeat;\r\n  	background-size: cover;\r\n  	[endif]\r\n	border-radius: 50%;\r\n	-moz-border-radius: 50%;\r\n	-webkit-border-radius: 50%;\r\n	position: absolute;\r\n	top: -20px;\r\n	left: -30px;\r\n	height: 110px;\r\n	width: 110px;\r\n  	[if bg_type_2 == \'color\']\r\n	background: [bg_color_1];\r\n  	[elseif bg_type_2 == \'img\']\r\n  	background-image: url(\"[bg_img_2]\");\r\n  	background-repeat: no-repeat;\r\n  	[endif]\r\n	background-position: 22px 31px;\r\n	box-shadow: 0px 0 0px 8px rgba(115, 125, 143, 0.5);\r\n}\r\n#ppsPopupShell_[ID] .logo{\r\n	[if bg_type_5 == \'color\']\r\n	background: [bg_color_1];\r\n  	[elseif bg_type_5 == \'img\']\r\n  	background-image: url(\"[bg_img_5]\");\r\n  	background-repeat: no-repeat;\r\n  	background-size: cover;\r\n  	[endif]\r\n	border-radius: 50%;\r\n	-moz-border-radius: 50%;\r\n	-webkit-border-radius: 50%;\r\n	height: 130px;\r\n	width: 130px;\r\n  	float: left;\r\n  	[if bg_type_5 == \'color\']\r\n	background: [bg_color_5];\r\n  	[elseif bg_type_5 == \'img\']\r\n  	background-image: url(\"[bg_img_5]\");\r\n  	background-repeat: no-repeat;\r\n  	[endif]\r\n	box-shadow: 0px 0 0px 8px rgba(115, 125, 143, 0.5);\r\n}\r\n#ppsPopupShell_[ID] .ppsRightCol {\r\n	/*display: table-cell;*/\r\n  	float:right;\r\n  	width: 100%;\r\n  	height: 100%;\r\n  	margin-bottom: 30px;\r\n  	margin-top: 65px;\r\n  	padding-right: 20px;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell {\r\n	padding: 30px 50px 0 70px;\r\n	text-align: right;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell input,\r\n#ppsPopupShell_[ID] .ppsSubscribeShell .ppsSubSelect,\r\n#ppsPopupShell_[ID] .ppsSubscribeShell textarea {\r\n	width: 100%;\r\n  	margin-bottom: 10px;\r\n  	height: 40px;\r\n  	border: none;\r\n  	border-radius: 3px;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell input[type=text],#ppsPopupShell_[ID] .ppsSubscribeShell input[type=email],#ppsPopupShell_[ID] .ppsSubscribeShell input[type=password],#ppsPopupShell_[ID] .ppsSubscribeShell input[type=email],\r\n#ppsPopupShell_[ID] .ppsSubscribeShell .ppsSubSelect,\r\n#ppsPopupShell_[ID] .ppsSubscribeShell textarea {\r\n  	padding-left: 30px;\r\n  	font-size: 17px;\r\n  	background-image: url(\"[PPS_ASSETS_URL]img/assets/input-name.png\");\r\n	background-repeat: no-repeat;\r\n	background-position: 5px center;\r\n  	background-color: #fff;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell .ppsSubSelect {\r\n	display: table;\r\n  	text-align: left;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell .ppsSubSelectLabel,\r\n#ppsPopupShell_[ID] .ppsSubscribeShell select {\r\n	display: table-cell;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell .ppsSubSelectLabel {\r\n	opacity: 0.5;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell select {\r\n	width: 100%;\r\n  	background-color: transparent;\r\n  	height: 40px;\r\n  	border: none;\r\n  	font-size: 17px;\r\n  	margin-left: -5px;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell textarea {\r\n	font-family: inherit;\r\n  	height: auto;\r\n    padding-top: 5px;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell input[type=text],#ppsPopupShell_[ID] .ppsSubscribeShell input[type=email],#ppsPopupShell_[ID] .ppsSubscribeShell input[name=\"email\"] {\r\n  	padding-left: 30px;\r\n    background-image: url(\"[PPS_ASSETS_URL]img/assets/input-email.png\");\r\n    background-repeat: no-repeat;\r\n    background-position: 5px center;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell input[type=submit] {\r\n	border-color: #000;\r\n  	font-family: \'Open Sans\', arial;\r\n	margin-right: -30px;;\r\n	font-weight: 100;\r\n	color: #ffffff;\r\n  	float: left;\r\n  	width: 40%;\r\n	text-shadow: #000000 1px 1px 1px;\r\n  	padding: 0;\r\n  	[if bg_type_3 == \'color\']\r\n  	background: [bg_color_3];\r\n   \r\n  	[elseif bg_type_3 == \'img\']\r\n  	background-image: url(\"[bg_img_3]\");\r\n  	background-repeat: no-repeat;\r\n  	background-size: cover;\r\n  	[endif]\r\n  \r\n  	cursor: pointer;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell input[type=submit]:hover {\r\n	box-shadow: inset 1px 1px 3px #666;\r\n  	opacity:0.8;\r\n}\r\n#ppsPopupShell_[ID] .ppsPopupTxt_0 {\r\n  	text-align: center;\r\n  	font-family: \'Open Sans\', arial;\r\n 	font-weight: 100;\r\n	color: #ffffff;\r\n	text-shadow: #000000 1px 1px 1px;\r\n  	font-size: 17px;\r\n  	[if bg_type_4 == \'color\']\r\n  	color: [bg_color_4];\r\n  	[elseif bg_type_4 == \'img\']\r\n  	[endif]\r\n}\r\n\r\n#ppsPopupShell_[ID] .ppsPopupTxt_0 {\r\n  	margin-left: 70px;\r\n	margin-right: 40px;\r\n    float: left;\r\n}\r\n\r\n#ppsPopupShell_[ID] .ppsPopupClose {\r\n	background-repeat: no-repeat;\r\n  	cursor: pointer;\r\n  	position: static !important;\r\n  	background-image: none !important;\r\n    width: 192px !important;\r\n    height: 40px !important;\r\n  	float:right !important;\r\n    [if bg_type_1 == \'color\']\r\n	background: [bg_color_1] !important;\r\n  	[elseif bg_type_1 == \'img\']\r\n  	background-image: url(\"[bg_img_1]\") !important;\r\n  	background-repeat: no-repeat;\r\n  	background-size: cover;\r\n  	[endif]\r\n}\r\n#ppsPopupShell_[ID] .ppsPopupClose.ppsPopupClose_lists_black {\r\n 	top: 0 !important;\r\n  	right: 0 !important;\r\n}\r\n#ppsPopupShell_[ID] .ppsPopupClose:hover {\r\n	opacity: 0.8;\r\n}\r\n#ppsPopupShell_[ID] .ppsFootNote{\r\n  	padding-left: 30px;\r\n	background-image: url(\"[PPS_ASSETS_URL]img/assets/security_ico.png\");\r\n	background-repeat: no-repeat;\r\n	background-position: 5px center;\r\n  	height: 20px;\r\n  	[if bg_type_4 == \'color\']\r\n  	color: [bg_color_4];\r\n  	[elseif bg_type_4 == \'img\']\r\n  	[endif]\r\n    font-family: \"Helvetica Neue\",Helvetica,Arial,sans-serif;\r\n    font-size: x-small;\r\n    font-style: italic;\r\n    line-height: 14px;\r\n  	margin: 5px 30px;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubMsg {\r\n	clear: both;\r\n  	float: left;\r\n}","discount.png","1","1","1","1","2015-01-10 18:59:43","8"),
("21","Eco Style","1","0","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","<link rel=\"stylesheet\" type=\"text/css\" href=\"//fonts.googleapis.com/css?family=Amatic+SC\" />\r\n<div id=\"ppsPopupShell_[ID]\" class=\"ppsPopupShell ppsPopupListsShell\">\r\n	<a href=\"#\" class=\"ppsPopupClose ppsPopupClose_[close_btn]\"></a>\r\n	<div class=\"ppsInnerTblContent\">\r\n		<div class=\"ppsPopupListsInner ppsPopupInner\">\r\n			[if enb_label]\r\n				<div class=\"ppsPopupLabel ppsPopupListsLabel\">[label]</div>\r\n			[endif]\r\n			<div style=\"clear: both;\"></div>\r\n			[if enb_txt_0]\r\n				<div class=\"ppsPopupTxt ppsPopupClassyTxt ppsPopupClassyTxt_0 ppsPopupTxt_0\">\r\n				[txt_0]\r\n				</div>\r\n			[endif]\r\n			[if enb_subscribe]\r\n				<div class=\"ppsSubscribeShell\">\r\n					[sub_form_start]\r\n					[sub_fields_html]\r\n					<input class=\"butt\" type=\"submit\" name=\"submit\" value=\"[sub_btn_label]\" />\r\n					[sub_form_end]\r\n					<div style=\"clear: both;\"></div>\r\n				</div>\r\n			[endif]\r\n			<div style=\"clear: both;\"></div>\r\n			<div class=\"ppsRightCol\">\r\n				[if enb_sm]\r\n					<div style=\"clear: both;\"></div>\r\n					<div class=\"ppsSm\">\r\n					[sm_html]\r\n					</div>\r\n				[endif]\r\n				[if enb_foot_note]\r\n					<div class=\"ppsFootNote\">\r\n					[foot_note]\r\n					</div>\r\n				[endif]\r\n			</div>\r\n		</div>\r\n	</div>\r\n</div>","#ppsPopupShell_[ID] {\r\n	width: [width][width_measure];\r\n  	padding: 15px;\r\n  	font-family: \'arial\', arial;\r\n	font-size: 13px;\r\n	line-height: 21px;\r\n	font-weight: normal;\r\n}\r\n#ppsPopupShell_[ID], #ppsPopupShell_[ID] * {\r\n	-webkit-box-sizing: content-box;\r\n	-moz-box-sizing:    content-box;\r\n	box-sizing:         content-box;\r\n}\r\n#ppsPopupShell_[ID] .ppsPopupInner {\r\n  {% if popup.params.tpl.enb_subscribe or popup.params.tpl.enb_foot_note or popup.params.tpl.enb_sm %}\r\n  	width: 100%;\r\n  	border-left: 15px solid;\r\n  	[if bg_type_2 == \'color\']\r\n  	border-color:[bg_color_2];\r\n    [elseif bg_type_2 == \'img\']\r\n  	background-image: url(\"[bg_img_0]\");\r\n  	background-repeat: no-repeat;\r\n  	background-size: cover;\r\n  	[endif]\r\n      \r\n	[else]\r\n  	width: 100%;\r\n  	[endif]\r\n  	box-shadow: 0 0 10px rgba(0,0,0,0.5);\r\n  	padding: 10px;\r\n  	border-radius: 3px;\r\n	[if bg_type_0 == \'color\']\r\n	background: -moz-radial-gradient(center, ellipse cover, {{ adjust_brightness(popup.params.tpl.bg_color_0, 50) }} 0%, [bg_color_0] 100%); /* ff3.6+ */\r\n	background: -webkit-gradient(radial, center center, 0px, center center, 100%, color-stop(0%, {{ adjust_brightness(popup.params.tpl.bg_color_0, 50) }}), color-stop(100%, [bg_color_0])); /* safari4+,chrome */\r\n	background:-webkit-radial-gradient(center, ellipse cover, {{ adjust_brightness(popup.params.tpl.bg_color_0, 50) }} 0%, [bg_color_0] 100%); /* safari5.1+,chrome10+ */\r\n	background: -o-radial-gradient(center, ellipse cover, {{ adjust_brightness(popup.params.tpl.bg_color_0, 50) }} 0%, [bg_color_0] 100%); /* opera 11.10+ */\r\n	background: -ms-radial-gradient(center, ellipse cover, {{ adjust_brightness(popup.params.tpl.bg_color_0, 50) }} 0%, [bg_color_0] 100%); /* ie10+ */\r\n	background:radial-gradient(ellipse at center, {{ adjust_brightness(popup.params.tpl.bg_color_0, 50) }} 0%, [bg_color_0] 100%); /* w3c */\r\n	filter: progid:DXImageTransform.Microsoft.gradient( startColorstr=\'{{ adjust_brightness(popup.params.tpl.bg_color_0, 50) }}\', endColorstr=\'[bg_color_0]\',GradientType=1 ); /* ie6-9 */\r\n  	[elseif bg_type_0 == \'img\']\r\n  	background-image: url(\"[bg_img_0]\");\r\n  	background-repeat: no-repeat;\r\n  	background-size: cover;\r\n  	[endif]\r\n}\r\n#ppsPopupShell_[ID] .ppsPopupLabel {\r\n	color: #000;\r\n    font-family: \'PT Sans\', sans-serif;\r\n	text-align: center;\r\n	font-size: 38px;\r\n	letter-spacing: -1px;\r\n	line-height: 40px;\r\n	letter-spacing: -1px;\r\n	margin-top: 15px;\r\n	display: block;\r\n  	margin-bottom: 15px;;\r\n	padding-left: 20px;\r\n	-moz-text-shadow: 0px 0px 1px #000;\r\n	-webkit-text-shadow: 0px 0px 1px #000;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell form {\r\n	padding: 1% 1% 1% 1%;\r\n	text-align:right;\r\n	margin-bottom: 20px;\r\n  	padding-left: 20px;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell input,\r\n#ppsPopupShell_[ID] .ppsSubscribeShell .ppsSubSelect,\r\n#ppsPopupShell_[ID] .ppsSubscribeShell textarea {\r\n	/*width: 100%;*/\r\n  	margin-bottom: 10px;\r\n  	height: 40px;\r\n  	border: 0px solid #d1b36d;\r\n	border-radius: 4px !important;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell input[type=text],#ppsPopupShell_[ID] .ppsSubscribeShell input[type=email],#ppsPopupShell_[ID] .ppsSubscribeShell input[type=password],#ppsPopupShell_[ID] .ppsSubscribeShell input[type=email],\r\n#ppsPopupShell_[ID] .ppsSubscribeShell .ppsSubSelect,\r\n#ppsPopupShell_[ID] .ppsSubscribeShell textarea {\r\n	box-shadow: 2px 2px 2px #dcdcdc inset;\r\n  	padding-left: 20px;\r\n  	font-size: 15px;\r\n	width:100%;\r\n  	max-width: 284px;\r\n	display: block;\r\n	float: left;\r\n  	border: 1px solid #e2e2e2;\r\n  	margin-top: 1px;\r\n  	background-color: #fff;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell .ppsSubSelect {\r\n	display: table;\r\n  	text-align: left;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell .ppsSubSelectLabel,\r\n#ppsPopupShell_[ID] .ppsSubscribeShell select {\r\n	display: table-cell;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell .ppsSubSelectLabel {\r\n	opacity: 0.5;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell select {\r\n	width: 100%;\r\n  	background-color: transparent;\r\n  	height: 40px;\r\n  	border: none;\r\n  	font-size: 17px;\r\n  	border-radius: 4px !important;\r\n  	margin-left: -1px;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell textarea {\r\n	font-family: inherit;\r\n  	height: auto;\r\n    padding-top: 5px;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell input[type=submit] {\r\n	border-color: #000;\r\n	width: 30%;\r\n  	padding: 6px 0 0 0;\r\n  	text-align: center;\r\n 	cursor: pointer;\r\n  	text-decoration: none;\r\n  	color: #333333;\r\n  	font-size: 17px;\r\n  	font-family: \'PT Sans\', sans-serif;\r\n  	text-shadow: 0px 1px 0px #FFF;\r\n  	display:block;\r\n  	float: left;\r\n	margin-left: 30px;\r\n  	[if bg_type_1 == \'color\']\r\n  	background: [bg_color_1] 100%;\r\n   	box-shadow: -4px -4px 0px rgba(0, 0, 0, 0.1) inset;\r\n  	[elseif bg_type_1 == \'img\']\r\n  	background-image: url(\"[bg_img_1]\");\r\n  	background-repeat: no-repeat;\r\n  	background-size: cover;\r\n  	[endif]\r\n  \r\n  	color: #fff;\r\n    font-size: 20px;\r\n    text-shadow: 1px 1px 1px #000;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell input[type=submit]:hover {\r\n   box-shadow: 4px 4px 0px rgba(0, 0, 0, 0.1) inset;\r\n	\r\n}\r\n#ppsPopupShell_[ID] .ppsPopupTxt_0 {\r\n	float: left;\r\n  	width: 90%;\r\n	font-family: \'PT Sans\', sans-serif;\r\n  	color: [bg_color_1];\r\n  	font-size: 25px;\r\n  	line-height: 25px;\r\n  	display: block;\r\n  	margin-bottom: 27px;\r\n    padding: 0px 20px 0px 20px;\r\n  	text-align: center;\r\n}\r\n\r\n#ppsPopupShell_[ID] .ppsPopupClose {\r\n	background-repeat: no-repeat;\r\n  	cursor: pointer;\r\n	top: 15px;\r\n  	right: -20px !important;\r\n}\r\n#ppsPopupShell_[ID] .ppsPopupClose.ppsPopupClose_lists_black {\r\n 	top: 0 !important;\r\n  	right: 0 !important;\r\n}\r\n#ppsPopupShell_[ID] .ppsPopupClose:hover {\r\n	opacity: 0.8;\r\n}\r\n#ppsPopupShell_[ID] .ppsFootNote{\r\n	color: #585858;\r\n    font-family: \"Helvetica Neue\",Helvetica,Arial,sans-serif;\r\n    font-size: x-small;\r\n    font-style: italic;\r\n    line-height: 14px;\r\n  	margin: 5px 30px;\r\n}\r\n#ppsPopupShell_[ID] .ppsSm{\r\n	margin-top:20px;\r\n}\r\n.ppsPopupShell .ppsErrorMsg{\r\n  width: 200px;\r\n}\r\n\r\n","eco.png","1","1","1","1","2015-01-10 18:59:43","9"),
("22","Orange","1","0","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","<link rel=\"stylesheet\" type=\"text/css\" href=\"//fonts.googleapis.com/css?family=Didact+Gothic\" />\r\n<div id=\"ppsPopupShell_[ID]\" class=\"ppsPopupShell ppsPopupListsShell\">\r\n	<a href=\"#\" class=\"ppsPopupClose ppsPopupClose_[close_btn]\"></a>\r\n	<div class=\"ppsInnerTblContent\">\r\n		<div class=\"ppsPopupListsInner ppsPopupInner\">\r\n			[if enb_label]\r\n				<div class=\"ppsPopupLabel ppsPopupListsLabel\">[label]</div>\r\n			[endif]\r\n			<div style=\"clear: both;\"></div>\r\n			[if enb_txt_0]\r\n				<div class=\"ppsPopupTxt ppsPopupClassyTxt ppsPopupClassyTxt_0 ppsPopupTxt_0\">\r\n				[txt_0]\r\n				</div>\r\n			[endif]\r\n			<div style=\"clear: both;\"></div>\r\n		</div>\r\n		<div class=\"ppsRightCol\">\r\n			<div class=\"logo\"></div>\r\n			[if enb_subscribe]\r\n				<div class=\"ppsSubscribeShell\">\r\n					[sub_form_start]\r\n					[sub_fields_html]\r\n					<input type=\"submit\" name=\"submit\" value=\"[sub_btn_label]\" />\r\n					[sub_form_end]\r\n					<div style=\"clear: both;\"></div>\r\n				</div>\r\n			[endif]\r\n			[if enb_sm]\r\n				<div class=\"ppsSm\">\r\n				[sm_html]\r\n				</div>\r\n			[endif]\r\n			[if enb_foot_note]\r\n				<div class=\"ppsFootNote\">\r\n				[foot_note]\r\n				</div>\r\n			[endif]\r\n		</div>\r\n	</div>\r\n</div>","#ppsPopupShell_[ID] {\r\n	width: [width][width_measure];\r\n  	padding: 15px;\r\n  	font-family: Georgia, Times, serif;\r\n	font-size: 13px;\r\n	line-height: 21px;\r\n	font-weight: normal;\r\n	color: #000;\r\n}\r\n#ppsPopupShell_[ID] .ppsInnerTblContent {\r\n	display: table;\r\n  	width: 100%;\r\n}\r\n#ppsPopupShell_[ID] .ppsPopupInner {\r\n  {% if popup.params.tpl.enb_subscribe or popup.params.tpl.enb_foot_note or popup.params.tpl.enb_sm %}\r\n  	width: 66%;\r\n	[else]\r\n  	width: 100%;\r\n  	[endif]\r\n  	display: table-cell;\r\n  	/*float: left;*/\r\n  	vertical-align: top;\r\n	[if bg_type_0 == \'color\']\r\n	background: -moz-radial-gradient(center, ellipse cover, {{ adjust_brightness(popup.params.tpl.bg_color_0, 50) }} 0%, [bg_color_0] 100%); /* ff3.6+ */\r\n	background: -webkit-gradient(radial, center center, 0px, center center, 100%, color-stop(0%, {{ adjust_brightness(popup.params.tpl.bg_color_0, 50) }}), color-stop(100%, [bg_color_0])); /* safari4+,chrome */\r\n	background:-webkit-radial-gradient(center, ellipse cover, {{ adjust_brightness(popup.params.tpl.bg_color_0, 50) }} 0%, [bg_color_0] 100%); /* safari5.1+,chrome10+ */\r\n	background: -o-radial-gradient(center, ellipse cover, {{ adjust_brightness(popup.params.tpl.bg_color_0, 50) }} 0%, [bg_color_0] 100%); /* opera 11.10+ */\r\n	background: -ms-radial-gradient(center, ellipse cover, {{ adjust_brightness(popup.params.tpl.bg_color_0, 50) }} 0%, [bg_color_0] 100%); /* ie10+ */\r\n	background:radial-gradient(ellipse at center, {{ adjust_brightness(popup.params.tpl.bg_color_0, 50) }} 0%, [bg_color_0] 100%); /* w3c */\r\n	filter: progid:DXImageTransform.Microsoft.gradient( startColorstr=\'{{ adjust_brightness(popup.params.tpl.bg_color_0, 50) }}\', endColorstr=\'[bg_color_0]\',GradientType=1 ); /* ie6-9 */\r\n  	[elseif bg_type_0 == \'img\']\r\n  	background-image: url(\"[bg_img_0]\");\r\n  	background-repeat: no-repeat;\r\n  	background-size: cover;\r\n  	[endif]\r\n}\r\n#ppsPopupShell_[ID] .ppsPopupLabel {\r\n	color: [bg_color_1];\r\n	font-family: \'Didact Gothic\';\r\n	font-size: 36px;\r\n  	text-align:center;\r\n	letter-spacing: -1px;\r\n	line-height: 40px;\r\n	letter-spacing: -1px;\r\n	font-weight: bold;\r\n	margin-top: 80px;\r\n	margin-bottom: 16px;\r\n	padding-left: 20px;\r\n}\r\n#ppsPopupShell_[ID] .ppsRightCol {\r\n	display: table-cell;\r\n  	/*float: right;*/\r\n  	width: 34%;\r\n  	height: 100%;\r\n  	text-align: center;\r\n  	[if bg_type_1 == \'color\']\r\n  	background: -moz-radial-gradient(center, ellipse cover, {{ adjust_brightness(popup.params.tpl.bg_color_1, 50) }} 0%, [bg_color_1] 100%); /* ff3.6+ */\r\n	background: -webkit-gradient(radial, center center, 0px, center center, 100%, color-stop(0%, {{ adjust_brightness(popup.params.tpl.bg_color_1, 50) }}), color-stop(100%, [bg_color_1])); /* safari4+,chrome */\r\n	background:[bg_color_1]; /* w3c */\r\n	filter: progid:DXImageTransform.Microsoft.gradient( startColorstr=\'{{ adjust_brightness(popup.params.tpl.bg_color_1, 50) }}\', endColorstr=\'[bg_color_1]\',GradientType=1 ); /* ie6-9 */\r\n  	[elseif bg_type_1 == \'img\']\r\n  	background-image: url(\"[bg_img_1]\");\r\n  	background-repeat: no-repeat;\r\n  	background-size: cover;\r\n  	[endif]\r\n  	\r\n}\r\n\r\n#ppsPopupShell_[ID] .logo{\r\n	[if bg_type_3 == \'color\']\r\n	background: [bg_color_3];\r\n  	[elseif bg_type_3 == \'img\']\r\n  	background-image: url(\"[bg_img_3]\");\r\n  	background-repeat: no-repeat;\r\n  	background-size: cover;\r\n  	[endif]\r\n	border-radius: 50%;\r\n	-moz-border-radius: 50%;\r\n	-webkit-border-radius: 50%;\r\n	height: 130px;\r\n	width: 130px;\r\n  	display: inline-block;\r\n  	margin: 30px 0;\r\n}\r\n\r\n#ppsPopupShell_[ID] .ppsSubscribeShell form {\r\n	padding: 0 30px;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell input,\r\n#ppsPopupShell_[ID] .ppsSubscribeShell .ppsSubSelect,\r\n#ppsPopupShell_[ID] .ppsSubscribeShell textarea {\r\n	width: 100%;\r\n  	margin-bottom: 15px;\r\n  	height: 30px;\r\n  	border: 1px solid #d1b36d;\r\n  	border-radius: 4px;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell input[type=text],#ppsPopupShell_[ID] .ppsSubscribeShell input[type=email],#ppsPopupShell_[ID] .ppsSubscribeShell input[type=password],#ppsPopupShell_[ID] .ppsSubscribeShell input[type=email],\r\n#ppsPopupShell_[ID] .ppsSubscribeShell .ppsSubSelect,\r\n#ppsPopupShell_[ID] .ppsSubscribeShell textarea {\r\n	box-shadow: 2px 2px 2px #dcdcdc inset;\r\n  	padding-left: 10px;\r\n  	font-size: 17px;\r\n  	background-color: #fff;\r\n  	display: block;\r\n  	text-align:center;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell .ppsSubSelect {\r\n	display: table;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell .ppsSubSelectLabel,\r\n#ppsPopupShell_[ID] .ppsSubscribeShell select {\r\n	display: table-cell;\r\n  	\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell .ppsSubSelectLabel {\r\n	opacity: 0.5;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell select {\r\n	width: 100%;\r\n  	background-color: transparent;\r\n  	height: 40px;\r\n  	border: none;\r\n  	margin-left: -5px;\r\n  	font-size: 17px;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell textarea {\r\n	font-family: inherit;\r\n  	height: auto;\r\n    padding-top: 5px;\r\n}\r\n\r\n#ppsPopupShell_[ID] .ppsSubscribeShell input[type=submit] {\r\n  	width: 105%;\r\n  	[if bg_type_2 == \'color\']\r\n  	background: [bg_color_2];\r\n    [elseif bg_type_2 == \'img\']\r\n  	background-image: url(\"[bg_img_2]\");\r\n  	background-repeat: no-repeat;\r\n  	background-size: cover;\r\n  	[endif]\r\n  \r\n  	color: #fff;\r\n    font-size: 20px;\r\n    text-shadow: 2px 2px 2px #000;\r\n  	cursor: pointer;\r\n  	padding: 0;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell input[type=submit]:hover {\r\n	box-shadow: inset 1px 1px 3px #666;\r\n}\r\n#ppsPopupShell_[ID] .ppsPopupTxt_0 {\r\n  	text-align:center;\r\n	font-family: \'Didact Gothic\';\r\n    font-size: 25px;\r\n	float: left;\r\n  	width: 100%;\r\n  	text-align: center;\r\n    line-height: 1.2;\r\n}\r\n#ppsPopupShell_[ID] .ppsPopupClose {\r\n	background-repeat: no-repeat;\r\n  	cursor: pointer;\r\n}\r\n#ppsPopupShell_[ID] .ppsPopupClose.ppsPopupClose_lists_black {\r\n 	top: 0 !important;\r\n  	right: 0 !important;\r\n}\r\n#ppsPopupShell_[ID] .ppsPopupClose:hover {\r\n	opacity: 0.8;\r\n}\r\n#ppsPopupShell_[ID] .ppsFootNote{\r\n	color: #585858;\r\n    font-family: \"Helvetica Neue\",Helvetica,Arial,sans-serif;\r\n    font-size: x-small;\r\n    font-style: italic;\r\n    line-height: 14px;\r\n  	margin: 5px 30px;\r\n}\r\n#ppsPopupShell_[ID] .ppsErrorMsg {\r\n	color: #fff !important;\r\n}","orange.png","1","1","1","1","2015-01-10 18:59:43","23"),
("23","Girl","1","0","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","<link rel=\"stylesheet\" type=\"text/css\" href=\"//fonts.googleapis.com/css?family=Didact+Gothic\" />\r\n<div id=\"ppsPopupShell_[ID]\" class=\"ppsPopupShell ppsPopupListsShell\">\r\n	<a href=\"#\" class=\"ppsPopupClose\"></a>\r\n	<div class=\"ppsPopupListsInner\">\r\n		<div class=\"ppsPopupTblCols\">\r\n			<div class=\"ppsPopupLeftCol\">\r\n				<div class=\"bglogo\">\r\n					[if bg_type_2 == \'img\']\r\n					<img src=\"[bg_img_2]\" />\r\n					[endif]\r\n				</div>\r\n			</div>\r\n			<div class=\"ppsPopupRightCol\">\r\n				<div class=\"ppsBigArrow\"></div>\r\n				[if enb_label]\r\n					<div class=\"ppsPopupLabel\">[label]</div>\r\n				[endif]\r\n				[if enb_txt_0]\r\n					<div class=\"ppsPopupTxt ppsPopupTxt_0\">[txt_0]</div>\r\n				[endif]\r\n				[if enb_subscribe]\r\n					<div class=\"ppsSubscribeShell\">\r\n					[sub_form_start]\r\n					[sub_fields_html]\r\n					<input type=\"submit\" name=\"submit\" value=\"[sub_btn_label]\" />\r\n					[sub_form_end]\r\n					</div>\r\n				[endif]\r\n				[if enb_sm]\r\n					<div class=\"ppsSm\">\r\n					[sm_html]\r\n					</div>\r\n				[endif]\r\n				[if enb_foot_note]\r\n					<div class=\"ppsFootNote\">\r\n					[foot_note]\r\n					</div>\r\n				[endif]\r\n			</div>\r\n		</div>\r\n	</div>\r\n</div>","#ppsPopupShell_[ID] {\r\n	width: [width][width_measure];\r\n  	font-family: Helvetica,Arial,sans-serif;\r\n  	font-size: 14px;\r\n  \r\n  	[if bg_type_0 == \'img\']\r\n  	background-image: url(\"[bg_img_0]\");\r\n  	background-repeat: no-repeat;\r\n  	background-size: cover;\r\n  	[endif]\r\n}\r\n#ppsPopupShell_[ID] .ppsPopupLabel {\r\n  	font-family: \'Didact Gothic\';\r\n	color: [bg_color_1];\r\n    font-size: 50px;\r\n    font-weight: bold;\r\n	line-height: 1.2;\r\n	text-align: center;\r\n    margin-top: 15%;\r\n  	margin-bottom: 20px;\r\n}\r\n#ppsPopupShell_[ID] .ppsPopupListsInner {\r\n	\r\n	\r\n  	[if bg_type_0 == \'color\']\r\n    background: {{ adjust_brightness(popup.params.tpl.bg_color_0, 50) }}; /* Old browsers */\r\n    background: -moz-radial-gradient(center, ellipse cover, {{ adjust_brightness(popup.params.tpl.bg_color_0, 50) }} 0%, [bg_color_0] 100%); /* FF3.6+ */\r\n    background: -webkit-gradient(radial, center center, 0px, center center, 100%, color-stop(0%,{{ adjust_brightness(popup.params.tpl.bg_color_0, 50) }}), color-stop(100%,[bg_color_0])); /* Chrome,Safari4+ */\r\n    background: -webkit-radial-gradient(center, ellipse cover, {{ adjust_brightness(popup.params.tpl.bg_color_0, 50) }} 0%,[bg_color_0] 100%); /* Chrome10+,Safari5.1+ */\r\n    background: -o-radial-gradient(center, ellipse cover, {{ adjust_brightness(popup.params.tpl.bg_color_0, 50) }} 0%,[bg_color_0] 100%); /* Opera 12+ */\r\n    background: -ms-radial-gradient(center, ellipse cover, {{ adjust_brightness(popup.params.tpl.bg_color_0, 50) }} 0%,[bg_color_0] 100%); /* IE10+ */\r\n    background: radial-gradient(ellipse at center, {{ adjust_brightness(popup.params.tpl.bg_color_0, 50) }} 0%,[bg_color_0] 100%); /* W3C */\r\n    filter: progid:DXImageTransform.Microsoft.gradient( startColorstr=\'{{ adjust_brightness(popup.params.tpl.bg_color_0, 50) }}\', endColorstr=\'#eaeaea\',GradientType=1 ); /* IE6-9 fallback on horizontal gradient */\r\n  	[endif]\r\n}\r\n#ppsPopupShell_[ID] .ppsPopupTxt_0 .ppsTxtContent {\r\n	padding: 10px 10px 10px 50px;\r\n}\r\n#ppsPopupShell_[ID] .ppsPopupTxt_0 {\r\nfont-size:18px;\r\n}\r\n#ppsPopupShell_[ID] .ppsPopupTblCols {\r\n	display: table;\r\n  	padding: 10px 10px 10px 10px;\r\n}\r\n#ppsPopupShell_[ID] .ppsPopupLeftCol {\r\n	display: table-cell;\r\n    padding: 10px;\r\n  	[if enb_subscribe]\r\n  	width: 40%;\r\n  	[else]\r\n  	width: 30%;\r\n  	min-height: 60%;\r\n  	[endif]\r\n  	vertical-align: top;\r\n}\r\n#ppsPopupShell_[ID] .bglogo{\r\n  margin: 15px 0px 10px 0px;\r\n}\r\n#ppsPopupShell_[ID] .bglogo img{\r\n  	width:100%;\r\n  	height:auto;\r\n	}\r\n#ppsPopupShell_[ID] .ppsPopupRightCol {\r\n    color: #fff;\r\n  	width: 60%;\r\n	display: table-cell;\r\n  	border-radius: 8px;\r\n	-moz-border-radius: 8px;\r\n	-webkit-border-radius: 8px;\r\n  	margin: 8px 5px 5px 5px;\r\n  	text-align: center;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell form {\r\n	padding: 30px 20px 0;\r\n  	text-align: center;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell input,\r\n#ppsPopupShell_[ID] .ppsSubscribeShell .ppsSubSelect,\r\n#ppsPopupShell_[ID] .ppsSubscribeShell textarea {\r\n	width: 100%;\r\n  	margin-bottom: 10px;\r\n  	height: 35px;\r\n  	border-radius: 2px;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell input[type=text],#ppsPopupShell_[ID] .ppsSubscribeShell input[type=email],#ppsPopupShell_[ID] .ppsSubscribeShell input[type=password],#ppsPopupShell_[ID] .ppsSubscribeShell input[type=email],\r\n#ppsPopupShell_[ID] .ppsSubscribeShell .ppsSubSelect,\r\n#ppsPopupShell_[ID] .ppsSubscribeShell textarea {\r\n	box-shadow: 0px [bg_color_1] inset;\r\n  	padding-left: 10px;\r\n  	font-size: 17px;\r\n  	background: [bg_color_1];\r\n  	border: 1px solid transparent;\r\n  	color: #000;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell .ppsSubSelect {\r\n	display: table;\r\n  	text-align: left;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell .ppsSubSelectLabel,\r\n#ppsPopupShell_[ID] .ppsSubscribeShell select {\r\n	display: table-cell;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell .ppsSubSelectLabel {\r\n	opacity: 0.5;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell select {\r\n	width: 100%;\r\n  	background-color: transparent;\r\n  	height: 40px;\r\n  	border: none;\r\n  	font-size: 17px;\r\n  	color: #fff;\r\n  	margin-left: -15px;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell textarea {\r\n	font-family: inherit;\r\n  	height: auto;\r\n    padding: 20px 5px;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell input[type=submit] {\r\n	border: 3px solid #fff;\r\n    padding: 0px 0px 5px !important;\r\n  	[if bg_type_3 == \'color\']\r\n  	background: [bg_color_3];\r\n\r\n  	[elseif bg_type_3 == \'img\']\r\n  	background-image: url(\"[bg_img_3]\");\r\n  	background-repeat: no-repeat;\r\n  	background-size: cover;\r\n  	[endif]\r\n  \r\n  	color: #fff;\r\n    font-size: 20px;\r\n  	cursor: pointer;\r\n  	border-radius: 50px;\r\n 	width: auto;\r\n  min-width: 60px;\r\n  	height: 60px;\r\n  	padding-top: 5px;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell input[type=submit]:hover {\r\n	opacity: 0.8;\r\n}\r\n#ppsPopupShell_[ID] .ppsPopupClose:hover {\r\n	opacity: 0.8;\r\n}\r\n#ppsPopupShell_[ID] .ppsPopupClose {\r\n	background-repeat: no-repeat;\r\n  	cursor: pointer;\r\n  	right: -20px !important;\r\n	top: -10px !important;\r\n}\r\n#ppsPopupShell_[ID] .ppsFootNote {\r\n  	[if enb_subscribe]\r\n    color: #979696;\r\n    font-family: \"Helvetica Neue\",Helvetica,Arial,sans-serif;\r\n    font-size: xx-small;\r\n    font-style: italic;\r\n    line-height: 14px;\r\n    text-align: left;\r\n  	margin-left: 10px;\r\n  	[else]\r\n  	margin-top: 10px;\r\n  	color: #979696;\r\n    font-family: \"Helvetica Neue\",Helvetica,Arial,sans-serif;\r\n    font-size: xx-small;\r\n    font-style: italic;\r\n    line-height: 14px;\r\n    text-align: left;\r\n    margin-left: 10px;\r\n  	[endif]\r\n}\r\n#ppsPopupShell_[ID] .ppsSm{\r\n[if enb_subscribe]\r\n  [else]\r\n  	margin-top: 130px;\r\n  	[endif]\r\n}\r\n#ppsPopupShell_[ID] li{\r\n	font-weight: bold;\r\n  	font-size: 13px;\r\n  	padding-top: 3px;\r\n	padding-bottom: 3px;\r\n  	color: #737E86;\r\n}","girl.png","1","1","1","1","2015-01-13 19:22:48","6"),
("24","Grey","0","0","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","<link rel=\"stylesheet\" type=\"text/css\" href=\"//fonts.googleapis.com/css?family=Didact+Gothic\" />\r\n<div id=\"ppsPopupShell_[ID]\" class=\"ppsPopupShell ppsPopupListsShell\">\r\n	<div class=\"ppsInnerTblContent\">\r\n		<div class=\"ppsPopupListsInner ppsPopupInner\">\r\n			<div style=\"clear: both;\"></div>\r\n			<div class=\"ppsRightCol\">\r\n				<div class=\"logo\"></div>\r\n				[if enb_label]\r\n					<div class=\"ppsPopupLabel ppsPopupListsLabel\">[label]</div>\r\n				[endif]\r\n				[if enb_txt_0]\r\n					<div class=\"ppsPopupTxt ppsPopupClassyTxt ppsPopupClassyTxt_0 ppsPopupTxt_0\">\r\n					[txt_0]\r\n					</div>\r\n				[endif]\r\n				<div style=\"clear: both;\"></div>\r\n				[if enb_subscribe]\r\n					<div class=\"ppsSubscribeShell\">\r\n						[sub_form_start]\r\n						[sub_fields_html]\r\n						<input class=\"singup\" type=\"submit\" name=\"submit\" value=\"[sub_btn_label]\" />\r\n						<input class=\"ppsPopupClose ppsPopupClose_[close_btn]\" type=\"submit\" name=\"submit\" value=\"Close\"/>\r\n						[sub_form_end]\r\n						<div style=\"clear: both;\"></div>\r\n					</div>\r\n				[endif]\r\n				[if enb_sm]\r\n					<div class=\"ppsSm\">\r\n					[sm_html]\r\n					</div>\r\n				[endif]\r\n				[if enb_foot_note]\r\n					<div class=\"ppsFootNote\">\r\n					[foot_note]\r\n					</div>\r\n				[endif]\r\n			</div>\r\n		</div>\r\n	</div>\r\n</div>","#ppsPopupShell_[ID] {\r\n	width: [width][width_measure];\r\n  	padding: 15px;\r\n  	font-family: Georgia, Times, serif;\r\n	font-size: 13px;\r\n	line-height: 21px;\r\n	font-weight: normal;\r\n	color: #000;\r\n}\r\n#ppsPopupShell_[ID], #ppsPopupShell_[ID] * {\r\n	-webkit-box-sizing: content-box;\r\n	-moz-box-sizing:    content-box;\r\n	box-sizing:         content-box;\r\n}\r\n#ppsPopupShell_[ID] .ppsInnerTblContent {\r\n	display: table;\r\n  [if bg_type_0 == \'color\']\r\n	background:[bg_color_0]; \r\n	filter: progid:DXImageTransform.Microsoft.gradient( startColorstr=\'{{ adjust_brightness(popup.params.tpl.bg_color_0, 50) }}\', endColorstr=\'[bg_color_0]\',GradientType=1 ); /* ie6-9 */\r\n  	[elseif bg_type_0 == \'img\']\r\n  	background-image: url(\"[bg_img_0]\");\r\n  	background-repeat: no-repeat;\r\n  	background-size: cover;\r\n  	[endif]\r\n}\r\n#ppsPopupShell_[ID] .ppsPopupInner {\r\n  {% if popup.params.tpl.enb_subscribe or popup.params.tpl.enb_foot_note or popup.params.tpl.enb_sm %}\r\n  	width: 50%;\r\n	[else]\r\n  	width: 100%;\r\n  	[endif]\r\n  	display: table-cell;\r\n}\r\n#ppsPopupShell_[ID] .ppsPopupLabel {\r\n	color: #000;\r\n	font-family: \'Didact Gothic\';\r\n	font-size: 50px;\r\n  	font-style: normal;\r\n	font-variant: normal;\r\n	font-weight: 500;\r\n	line-height: 46.4px;\r\n	color: #ffffff;\r\n	margin-bottom: 16px;\r\n	text-align:center;\r\n  	width:100%;\r\n  	float: left;\r\n	[if bg_type_4 == \'color\']\r\n  	color: [bg_color_4];\r\n  	[elseif bg_type_4 == \'img\']\r\n  	[endif]\r\n}\r\n#ppsPopupShell_[ID] .logo{\r\n  	width: 300px;\r\n  	height:155px;\r\n  	display: inline-block;\r\n	[if bg_type_2 == \'color\']\r\n	background-color: [bg_color_2];\r\n  	[elseif bg_type_2 == \'img\']\r\n  	background-image: url(\"[bg_img_2]\");\r\n  	background-repeat: no-repeat;\r\n  	background-size: cover;\r\n  	[endif]\r\n}\r\n#ppsPopupShell_[ID] .logo img{\r\n	width:100%;\r\n	height:auto;\r\n}\r\n#ppsPopupShell_[ID] .ppsRightCol {\r\n  	width: 100%;\r\n  	height: 100%;\r\n  	margin-bottom: 30px;\r\n  	margin-top: 40px;\r\n  	text-align: center;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell {\r\n	padding: 30px 50px 0;\r\n	text-align: right;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell input,\r\n#ppsPopupShell_[ID] .ppsSubscribeShell .ppsSubSelect,\r\n#ppsPopupShell_[ID] .ppsSubscribeShell textarea {\r\n	width: 100%;\r\n  	margin-bottom: 10px;\r\n  	height: 40px;\r\n  	border: none;\r\n  	border-radius: 3px;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell input[type=text],#ppsPopupShell_[ID] .ppsSubscribeShell input[type=email],#ppsPopupShell_[ID] .ppsSubscribeShell input[type=password],#ppsPopupShell_[ID] .ppsSubscribeShell input[type=email],\r\n#ppsPopupShell_[ID] .ppsSubscribeShell .ppsSubSelect,\r\n#ppsPopupShell_[ID] .ppsSubscribeShell textarea {\r\n  	padding-left: 30px;\r\n  	font-size: 17px;\r\n  	background-image: url(\"[PPS_ASSETS_URL]img/assets/input-name.png\");\r\n	background-repeat: no-repeat;\r\n	background-position: 5px center;\r\n  	background-color: #fff;\r\n  	box-sizing: border-box;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell .ppsSubSelect {\r\n	display: table;\r\n  	text-align: left;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell .ppsSubSelectLabel,\r\n#ppsPopupShell_[ID] .ppsSubscribeShell select {\r\n	display: table-cell;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell .ppsSubSelectLabel {\r\n	opacity: 0.5;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell select {\r\n	width: 100%;\r\n  	background-color: transparent;\r\n  	height: 40px;\r\n  	border: none;\r\n  	font-size: 17px;\r\n  	margin-left: -5px;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell textarea {\r\n	font-family: inherit;\r\n  	height: auto;\r\n    padding-top: 5px;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell input[type=text],#ppsPopupShell_[ID] .ppsSubscribeShell input[type=email],#ppsPopupShell_[ID] .ppsSubscribeShell input[name=\"email\"] {\r\n  	padding-left: 30px;\r\n    background-image: url(\"[PPS_ASSETS_URL]img/assets/input-email.png\");\r\n    background-repeat: no-repeat;\r\n    background-position: 5px center;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell input[type=submit] {\r\n	border-color: #000;\r\n  	font-family: \'Open Sans\', arial;\r\n	font-weight: 100;\r\n	color: #ffffff;\r\n  	float: left;\r\n  	width: 40%;\r\n	text-shadow: #000000 1px 1px 1px;\r\n  	[if bg_type_3 == \'color\']\r\n  	background: [bg_color_3];\r\n  	[elseif bg_type_3 == \'img\']\r\n  	background-image: url(\"[bg_img_3]\");\r\n  	background-repeat: no-repeat;\r\n  	background-size: cover;\r\n  	[endif]\r\n  	cursor: pointer;\r\n  	padding: 0;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell input[type=submit]:hover {\r\n	box-shadow: inset 1px 1px 3px #666;\r\n  	opacity:0.8;\r\n}\r\n#ppsPopupShell_[ID] .ppsPopupTxt_0 {\r\n  	text-align: center;\r\n  	font-family: \'Open Sans\', arial;\r\n 	font-weight: 100;\r\n	color: #ffffff;\r\n	text-shadow: #000000 1px 1px 1px;\r\n  	font-size: 17px;\r\n  	[if bg_type_4 == \'color\']\r\n  	color: [bg_color_4];\r\n  	[elseif bg_type_4 == \'img\']\r\n  	[endif]\r\n}\r\n\r\n#ppsPopupShell_[ID] .ppsPopupTxt_0 {\r\n  	margin-left: 70px;\r\n	margin-right: 40px;\r\n    float: left;\r\n}\r\n#ppsPopupShell_[ID] .ppsPopupClose {\r\n	background-repeat: no-repeat;\r\n  	cursor: pointer;\r\n  	position: static !important;\r\n  	background-image: none !important;\r\n    height: 40px !important;\r\n  	float:right !important;\r\n    [if bg_type_1 == \'color\']\r\n	background: [bg_color_1] !important;\r\n  	[elseif bg_type_1 == \'img\']\r\n  	background-image: url(\"[bg_img_1]\") !important;\r\n  	background-repeat: no-repeat;\r\n  	background-size: cover;\r\n  	[endif]\r\n}\r\n#ppsPopupShell_[ID] .ppsPopupClose.ppsPopupClose_lists_black {\r\n 	top: 0 !important;\r\n  	right: 0 !important;\r\n}\r\n#ppsPopupShell_[ID] .ppsPopupClose:hover {\r\n	opacity: 0.8;\r\n}\r\n#ppsPopupShell_[ID] .ppsFootNote{\r\n  	padding-left: 30px;\r\n	background-image: url(\"[PPS_ASSETS_URL]img/assets/security_ico.png\");\r\n	background-repeat: no-repeat;\r\n	background-position: 5px center;\r\n  	height: 20px;\r\n  	[if bg_type_4 == \'color\']\r\n  	color: [bg_color_4];\r\n  	[elseif bg_type_4 == \'img\']\r\n  	[endif]\r\n    font-family: \"Helvetica Neue\",Helvetica,Arial,sans-serif;\r\n    font-size: x-small;\r\n    font-style: italic;\r\n    line-height: 14px;\r\n  	margin: 5px 30px;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubMsg {\r\n	clear: both;\r\n  	float: left;\r\n}","grey.png","1","1","1","1","2015-01-10 18:59:43","11"),
("25","Calm","1","0","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","<link rel=\"stylesheet\" type=\"text/css\" href=\"//fonts.googleapis.com/css?family=Dancing+Script\" />\r\n<link rel=\"stylesheet\" type=\"text/css\" href=\"//fonts.googleapis.com/css?family=Didact+Gothic\" />\r\n<div id=\"ppsPopupShell_[ID]\" class=\"ppsPopupShell ppsPopupListsShell\">\r\n	<a href=\"#\" class=\"ppsPopupClose ppsPopupClose_[close_btn]\"></a>\r\n	<div class=\"ppsInnerTblContent\">\r\n		<div class=\"ppsPopupListsInner ppsPopupInner\">\r\n			<div style=\"clear: both;\"></div>\r\n			<div class=\"ppsLeftCol\">\r\n				[if enb_txt_0]\r\n					<div class=\"ppsPopupTxt ppsPopupClassyTxt ppsPopupClassyTxt_0 ppsPopupTxt_0\">\r\n					[txt_0]\r\n					</div>\r\n				[endif]\r\n				[if enb_sm]\r\n					<div class=\"ppsSm\">\r\n					[sm_html]\r\n					</div>\r\n				[endif]\r\n				[if enb_foot_note]\r\n					<div class=\"ppsFootNote\">\r\n					[foot_note]\r\n					</div>\r\n				[endif]\r\n			</div>\r\n			<div class=\"ppsRightCol\">\r\n				[if enb_txt_1]\r\n					<div class=\"ppsPopupTxt ppsPopupClassyTxt ppsPopupClassyTxt_1 ppsPopupTxt_1\">\r\n					[txt_1]\r\n					</div>\r\n				[endif]\r\n				<div class=\"logo\"></div>\r\n				[if enb_label]\r\n					<div class=\"label-window\">\r\n						<div class=\"ppsPopupLabel ppsPopupListsLabel\">[label]</div>\r\n					</div>\r\n				[endif]\r\n				<div style=\"clear: both;\"></div>\r\n				[if enb_subscribe]\r\n					<div class=\"ppsSubscribeShell\">\r\n						[sub_form_start]\r\n						[sub_fields_html]\r\n						<input type=\"submit\" name=\"submit\" value=\"[sub_btn_label]\" />\r\n						[sub_form_end]\r\n						<div style=\"clear: both;\"></div>\r\n					</div>\r\n				[endif]\r\n			</div>\r\n		</div>\r\n	</div>\r\n</div>","#ppsPopupShell_[ID] {\r\n	width: [width][width_measure];\r\n  	padding: 15px;\r\n  	font-family: Georgia, Times, serif;\r\n	font-size: 13px;\r\n	line-height: 21px;\r\n	font-weight: normal;\r\n	color: #000;\r\n}\r\n#ppsPopupShell_[ID], #ppsPopupShell_[ID] * {\r\n	-webkit-box-sizing: content-box;\r\n	-moz-box-sizing:    content-box;\r\n	box-sizing:         content-box;\r\n}\r\n#ppsPopupShell_[ID] .ppsPopupClose.ppsPopupClose_classy_grey {\r\n	top: 26px;\r\n  	right: 26px;\r\n}\r\n#ppsPopupShell_[ID] .ppsInnerTblContent {\r\n	display: table;\r\n  	border-radius: 25px;\r\n  	[if bg_type_0 == \'color\']\r\n	background: -moz-radial-gradient(center, ellipse cover, {{ adjust_brightness(popup.params.tpl.bg_color_0, 50) }} 0%, [bg_color_0] 100%); /* ff3.6+ */\r\n	background: -webkit-gradient(radial, center center, 0px, center center, 100%, color-stop(0%, {{ adjust_brightness(popup.params.tpl.bg_color_0, 50) }}), color-stop(100%, [bg_color_0])); /* safari4+,chrome */\r\n	background:-webkit-radial-gradient(center, ellipse cover, {{ adjust_brightness(popup.params.tpl.bg_color_0, 50) }} 0%, [bg_color_0] 100%); /* safari5.1+,chrome10+ */\r\n	background: -o-radial-gradient(center, ellipse cover, {{ adjust_brightness(popup.params.tpl.bg_color_0, 50) }} 0%, [bg_color_0] 100%); /* opera 11.10+ */\r\n	background: -ms-radial-gradient(center, ellipse cover, {{ adjust_brightness(popup.params.tpl.bg_color_0, 50) }} 0%, [bg_color_0] 100%); /* ie10+ */\r\n	background:radial-gradient(ellipse at center, {{ adjust_brightness(popup.params.tpl.bg_color_0, 50) }} 0%, [bg_color_0] 100%); /* w3c */\r\n	filter: progid:DXImageTransform.Microsoft.gradient( startColorstr=\'{{ adjust_brightness(popup.params.tpl.bg_color_0, 50) }}\', endColorstr=\'[bg_color_0]\',GradientType=1 ); /* ie6-9 */\r\n  	[elseif bg_type_0 == \'img\']\r\n  	background-image: url(\"[bg_img_0]\");\r\n  	background-repeat: no-repeat;\r\n  	background-size: cover;\r\n  	[endif]\r\n}\r\n#ppsPopupShell_[ID] .ppsPopupInner {\r\n  {% if popup.params.tpl.enb_subscribe or popup.params.tpl.enb_foot_note or popup.params.tpl.enb_sm %}\r\n  	width: 50%;\r\n	[else]\r\n  	width: 100%;\r\n  	[endif]\r\n  	display: table-cell;\r\n}\r\n#ppsPopupShell_[ID] .label-window{\r\n    width: 100%;\r\n    padding-top: 10px;\r\n    padding-bottom: 10px;\r\n    margin-top: 20px;\r\n}\r\n#ppsPopupShell_[ID] .ppsPopupLabel {\r\n	color: #000;\r\n	font-family: \'Dancing Script\';\r\n	font-size: 50px;\r\n	font-weight: 100;\r\n	color: #000;\r\n	text-shadow: #000000 1px 1px 1px;\r\n	\r\n	padding-left: 20px;\r\n  	text-align:center;\r\n  	line-height: 1em;\r\n}\r\n\r\n#ppsPopupShell_[ID] .ppsLeftCol {\r\n	float: left;\r\n  	width: 50%;\r\n 	border-radius: 20px;\r\n  	height: 100%;\r\n  	margin-bottom: 30px;\r\n  	margin-left: 30px;\r\n  	margin-top: 10%;\r\n  	line-height: 3.2em;\r\n    text-shadow: 0px 0px 0px black, 0 0 1em black;\r\n}\r\n\r\n#ppsPopupShell_[ID] .ppsRightCol {\r\n	/*display: table-cell;*/\r\n  	float:right;\r\n  	width: 40%;\r\n  	border-radius:20px;\r\n  	height: 100%;\r\n  	margin-bottom: 30px;\r\n  	margin-right: 30px;\r\n  	margin-top: 65px;\r\n  	[if bg_type_3 == \'color\']\r\n	background: [bg_color_3]; \r\n	[elseif bg_type_3 == \'img\']\r\n  	background-image: url(\"[bg_img_3]\");\r\n  	background-repeat: no-repeat;\r\n  	background-size: cover;\r\n  	[endif]\r\n}\r\n\r\n#ppsPopupShell_[ID] .ppsRightCol .logo{\r\n  	display: table;\r\n    width: 150px;\r\n 	margin-left: 30%;\r\n 	margin-top: 30px;\r\n  	height: 150px;\r\n[if bg_type_2 == \'color\']\r\n	background: -moz-radial-gradient(center, ellipse cover, {{ adjust_brightness(popup.params.tpl.bg_color_0, 50) }} 0%, [bg_color_0] 100%); /* ff3.6+ */\r\n	background: -webkit-gradient(radial, center center, 0px, center center, 100%, color-stop(0%, {{ adjust_brightness(popup.params.tpl.bg_color_0, 50) }}), color-stop(100%, [bg_color_2])); /* safari4+,chrome */\r\n	background:-webkit-radial-gradient(center, ellipse cover, {{ adjust_brightness(popup.params.tpl.bg_color_0, 50) }} 0%, [bg_color_0] 100%); /* safari5.1+,chrome10+ */\r\n	background: -o-radial-gradient(center, ellipse cover, {{ adjust_brightness(popup.params.tpl.bg_color_0, 50) }} 0%, [bg_color_0] 100%); /* opera 11.10+ */\r\n	background: -ms-radial-gradient(center, ellipse cover, {{ adjust_brightness(popup.params.tpl.bg_color_0, 50) }} 0%, [bg_color_0] 100%); /* ie10+ */\r\n	background:radial-gradient(ellipse at center, {{ adjust_brightness(popup.params.tpl.bg_color_0, 50) }} 0%, [bg_color_0] 100%); /* w3c */\r\n	filter: progid:DXImageTransform.Microsoft.gradient( startColorstr=\'{{ adjust_brightness(popup.params.tpl.bg_color_0, 50) }}\', endColorstr=\'[bg_color_0]\',GradientType=1 ); /* ie6-9 */\r\n  	[elseif bg_type_2 == \'img\']\r\n  	background-image: url(\"[bg_img_2]\");\r\n  	[endif]\r\n  	background-repeat: no-repeat;\r\n  	background-size: auto 100%;\r\n}\r\n\r\n\r\n#ppsPopupShell_[ID] .ppsSubscribeShell form {\r\n	padding: 30px 30px 0;\r\n	text-align: right;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell input,\r\n#ppsPopupShell_[ID] .ppsSubscribeShell .ppsSubSelect,\r\n#ppsPopupShell_[ID] .ppsSubscribeShell textarea {\r\n	width: 100%;\r\n  	margin-bottom: 10px;\r\n  	height: 40px;\r\n  	border: none;\r\n  	border-radius: 3px;\r\n  	box-sizing: border-box;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell input[type=text],#ppsPopupShell_[ID] .ppsSubscribeShell input[type=email],#ppsPopupShell_[ID] .ppsSubscribeShell input[type=password],#ppsPopupShell_[ID] .ppsSubscribeShell input[type=email],\r\n#ppsPopupShell_[ID] .ppsSubscribeShell .ppsSubSelect,\r\n#ppsPopupShell_[ID] .ppsSubscribeShell textarea {\r\n  	padding: 5px 5px 5px 10px;\r\n  	font-size: 17px;\r\n  	color: #000;\r\n  	border: 1px solid #928C8C;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell .ppsSubSelect {\r\n	display: table;\r\n  	text-align: left;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell .ppsSubSelectLabel,\r\n#ppsPopupShell_[ID] .ppsSubscribeShell select {\r\n	display: table-cell;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell .ppsSubSelectLabel {\r\n	opacity: 0.5;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell select {\r\n	width: 100%;\r\n  	background-color: transparent;\r\n  	height: 40px;\r\n  	border: none;\r\n  	font-size: 17px;\r\n  	color: #fff;\r\n  	border-top-right-radius: 3px;\r\n  	border-bottom-right-radius: 3px;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell textarea {\r\n	font-family: inherit;\r\n  	height: auto;\r\n    padding-top: 5px;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell input[type=submit] {\r\n	border-color: #000;\r\n  	font-family: \'Open Sans\', arial;\r\n	font-weight: 100;\r\n	color: #ffffff;\r\n  	width: 100%;\r\n	text-shadow: #000000 1px 1px 1px;\r\n  	padding: 5px;\r\n  	[if bg_type_1 == \'color\']\r\n  	background: [bg_color_1];\r\n    background: -moz-linear-gradient(90deg, [bg_color_2] 0%, {{ adjust_brightness(popup.params.tpl.bg_color_2, 100) }} 63%);\r\n    background: -webkit-linear-gradient(270deg, [bg_color_2] 0%, {{ adjust_brightness(popup.params.tpl.bg_color_2, 100) }} 63%);\r\n    background: -o-linear-gradient(270deg, [bg_color_2] 0%, {{ adjust_brightness(popup.params.tpl.bg_color_2, 100) }} 63%);\r\n    background: -ms-linear-gradient(270deg, [bg_color_2] 0%, {{ adjust_brightness(popup.params.tpl.bg_color_2, 100) }} 63%);\r\n    background: linear-gradient(0deg, [bg_color_2]) 0%, {{ adjust_brightness(popup.params.tpl.bg_color_2, 100) }} 63%);\r\n  	[elseif bg_type_1 == \'img\']\r\n  	background-image: url(\"[bg_img_1]\");\r\n  	background-repeat: no-repeat;\r\n  	background-size: cover;\r\n  	[endif]\r\n  	cursor: pointer;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell input[type=submit]:hover {\r\n	box-shadow: inset 1px 1px 3px #666;\r\n}\r\n#ppsPopupShell_[ID] .ppsPopupTxt_0 {\r\n  	text-align: center;\r\n  	font-family: \'Didact Gothic\';\r\n 	font-weight: 100;\r\n	font-size: 42px;\r\n  	color:#fff;\r\n}\r\n#ppsPopupShell_[ID] .ppsPopupTxt_0 {\r\n  	margin: 2px;\r\n}\r\n#ppsPopupShell_[ID] .ppsPopupClose {\r\n	background-repeat: no-repeat;\r\n  	cursor: pointer;\r\n}\r\n#ppsPopupShell_[ID] .ppsPopupClose.ppsPopupClose_lists_black {\r\n 	top: 0 !important;\r\n  	right: 0 !important;\r\n}\r\n#ppsPopupShell_[ID] .ppsPopupClose:hover {\r\n	opacity: 0.8;\r\n}\r\n#ppsPopupShell_[ID] .ppsFootNote{\r\n	color: #585858;\r\n    font-family: \"Helvetica Neue\",Helvetica,Arial,sans-serif;\r\n    font-size: x-small;\r\n    font-style: italic;\r\n    line-height: 14px;\r\n  	margin: 5px 30px;\r\n}\r\n#ppsPopupShell_[ID] p {\r\n	margin: 0;\r\n}","Calm.png","1","1","1","1","2015-01-10 18:59:43","12"),
("26","Highlights","1","0","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","<link rel=\"stylesheet\" type=\"text/css\" href=\"//fonts.googleapis.com/css?family=Dancing+Script\" />\r\n<link rel=\"stylesheet\" type=\"text/css\" href=\"//fonts.googleapis.com/css?family=Amatic+SC\" />\r\n<div id=\"ppsPopupShell_[ID]\" class=\"ppsPopupShell ppsPopupListsShell\">\r\n	<a href=\"#\" class=\"ppsPopupClose ppsPopupClose_[close_btn]\"></a>\r\n	<div class=\"ppsInnerTblContent\">\r\n		<div class=\"ppsPopupListsInner ppsPopupInner\">\r\n			<div class=\"logo\"></div>\r\n			[if enb_label]\r\n				<div class=\"ppsPopupLabel ppsPopupListsLabel\">[label]</div>\r\n			[endif]\r\n			<div style=\"clear: both;\"></div>\r\n			[if enb_txt_0]\r\n				<div class=\"ppsPopupTxt ppsPopupClassyTxt ppsPopupClassyTxt_0 ppsPopupTxt_0\">\r\n				[txt_0]\r\n				</div>\r\n			[endif]\r\n			[if enb_subscribe]\r\n				<div class=\"ppsSubscribeShell\">\r\n					[sub_form_start]\r\n					[sub_fields_html]\r\n					<input class=\"butt\" type=\"submit\" name=\"submit\" value=\"[sub_btn_label]\" />\r\n					[sub_form_end]\r\n					<div style=\"clear: both;\"></div>\r\n				</div>\r\n			[endif]\r\n			<div style=\"clear: both;\"></div>\r\n			<div class=\"ppsRightCol\">\r\n				[if enb_sm]\r\n					<div style=\"clear: both;\"></div>\r\n					<div class=\"ppsSm\">\r\n					[sm_html]\r\n					</div>\r\n				[endif]\r\n				[if enb_foot_note]\r\n					<div class=\"ppsFootNote\">\r\n					[foot_note]\r\n					</div>\r\n				[endif]\r\n			</div>\r\n		</div>\r\n	</div>\r\n</div>","#ppsPopupShell_[ID] {\r\n	width: [width][width_measure];\r\n  	padding: 15px;\r\n  	font-family: \'arial\', arial;\r\n	font-size: 13px;\r\n	line-height: 21px;\r\n	font-weight: normal;\r\n}\r\n#ppsPopupShell_[ID], #ppsPopupShell_[ID] * {\r\n	-webkit-box-sizing: content-box;\r\n	-moz-box-sizing:    content-box;\r\n	box-sizing:         content-box;\r\n}\r\n#ppsPopupShell_[ID] .ppsPopupInner {\r\n  {% if popup.params.tpl.enb_subscribe or popup.params.tpl.enb_foot_note or popup.params.tpl.enb_sm %}\r\n  	width: 100%;\r\n  	[else]\r\n  	width: 100%;\r\n  	[endif]\r\n  	box-shadow: 0 0 10px rgba(0,0,0,0.5);\r\n    padding: 60px 0 60px 0;\r\n  	border-radius: 3px;\r\n	[if bg_type_0 == \'color\']\r\n	background: -moz-radial-gradient(center, ellipse cover, {{ adjust_brightness(popup.params.tpl.bg_color_0, 50) }} 0%, [bg_color_0] 100%); /* ff3.6+ */\r\n	background: -webkit-gradient(radial, center center, 0px, center center, 100%, color-stop(0%, {{ adjust_brightness(popup.params.tpl.bg_color_0, 50) }}), color-stop(100%, [bg_color_0])); /* safari4+,chrome */\r\n	background:-webkit-radial-gradient(center, ellipse cover, {{ adjust_brightness(popup.params.tpl.bg_color_0, 50) }} 0%, [bg_color_0] 100%); /* safari5.1+,chrome10+ */\r\n	background: -o-radial-gradient(center, ellipse cover, {{ adjust_brightness(popup.params.tpl.bg_color_0, 50) }} 0%, [bg_color_0] 100%); /* opera 11.10+ */\r\n	background: -ms-radial-gradient(center, ellipse cover, {{ adjust_brightness(popup.params.tpl.bg_color_0, 50) }} 0%, [bg_color_0] 100%); /* ie10+ */\r\n	background:radial-gradient(ellipse at center, {{ adjust_brightness(popup.params.tpl.bg_color_0, 50) }} 0%, [bg_color_0] 100%); /* w3c */\r\n	filter: progid:DXImageTransform.Microsoft.gradient( startColorstr=\'{{ adjust_brightness(popup.params.tpl.bg_color_0, 50) }}\', endColorstr=\'[bg_color_0]\',GradientType=1 ); /* ie6-9 */\r\n  	[elseif bg_type_0 == \'img\']\r\n  	background-image: url(\"[bg_img_0]\");\r\n  	background-repeat: no-repeat;\r\n  	background-size: cover;\r\n  	[endif]\r\n}\r\n\r\n#ppsPopupShell_[ID] .logo{\r\n  	display: table;\r\n    width: 150px;\r\n    margin-left: 40%;\r\n    height: 130px;\r\n[if bg_type_2 == \'color\']\r\n	background: [bg_color_2];\r\n	[elseif bg_type_2 == \'img\']\r\n  	background-image: url(\"[bg_img_2]\");\r\n  	background-repeat: no-repeat;\r\n  	background-size: auto 100%;\r\n  	[endif]\r\n}\r\n\r\n#ppsPopupShell_[ID] .ppsPopupLabel {\r\n	color: #fff;\r\n    font-family: Dancing Script;\r\n	text-align: center;\r\n	font-size: 48px;\r\n	letter-spacing: -1px;\r\n	line-height: 40px;\r\n	letter-spacing: -1px;\r\n	margin-top: 35px;\r\n	display: block;\r\n  	margin-bottom: 35px;;\r\n	padding-left: 20px;\r\n  	text-shadow: 1px 1px 2px black, 0 0 1em [bg_color_1];\r\n	-moz-text-shadow: 1px 1px 2px black, 0 0 1em [bg_color_1];\r\n	-webkit-text-shadow: 1px 1px 2px black, 0 0 1em [bg_color_1];\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell form {\r\n	padding: 1% 1% 1% 1%;\r\n	text-align:right;\r\n	margin-bottom: 20px;\r\n  	padding-left: 20px;\r\n    margin: 0 auto;\r\n  	width: 60%;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell input,\r\n#ppsPopupShell_[ID] .ppsSubscribeShell .ppsSubSelect,\r\n#ppsPopupShell_[ID] .ppsSubscribeShell textarea {\r\n	/*width: 100%;*/\r\n  	margin-bottom: 10px;\r\n  	height: 40px;\r\n  	border: 0px solid #d1b36d;\r\n	border-radius: 4px !important;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell input[type=text],#ppsPopupShell_[ID] .ppsSubscribeShell input[type=email],#ppsPopupShell_[ID] .ppsSubscribeShell input[type=password],#ppsPopupShell_[ID] .ppsSubscribeShell input[type=email],\r\n#ppsPopupShell_[ID] .ppsSubscribeShell .ppsSubSelect,\r\n#ppsPopupShell_[ID] .ppsSubscribeShell textarea {\r\n	box-shadow: 2px 2px 2px #dcdcdc inset;\r\n  	padding-left: 20px;\r\n  	font-size: 15px;\r\n	width:100%;\r\n  	max-width: 284px;\r\n	display: block;\r\n	float: left;\r\n  	border: 1px solid #e2e2e2;\r\n  	margin-top: 1px;\r\n  	background-color: #fff;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell .ppsSubSelect {\r\n	display: table;\r\n  	text-align: left;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell .ppsSubSelectLabel,\r\n#ppsPopupShell_[ID] .ppsSubscribeShell select {\r\n	display: table-cell;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell .ppsSubSelectLabel {\r\n	opacity: 0.5;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell select {\r\n	width: 100%;\r\n  	background-color: transparent;\r\n  	height: 40px;\r\n  	border: none;\r\n  	font-size: 17px;\r\n  	border-radius: 4px !important;\r\n  	margin-left: -1px;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell textarea {\r\n	font-family: inherit;\r\n  	height: auto;\r\n    padding-top: 5px;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell input[type=submit] {\r\n	border-color: #000;\r\n	min-width: 65px;\r\n	height: 60px;\r\n  	padding: 6px 0 0 0;\r\n  	text-align: center;\r\n 	cursor: pointer;\r\n  	text-decoration: none;\r\n  	color: #333333;\r\n  	font-family: Dancing Script;\r\n  	border-radius:50% !important;\r\n  	text-shadow: 0px 1px 0px #FFF;\r\n  	display:block;\r\n  	float: left;\r\n	margin-left: -15px;\r\n  	margin-top: -5px;\r\n  	[if bg_type_1 == \'color\']\r\n  	background: [bg_color_1] 100%;\r\n   	box-shadow: -4px -4px 0px rgba(0, 0, 0, 0.1) inset;\r\n  	[elseif bg_type_1 == \'img\']\r\n  	background-image: url(\"[bg_img_1]\");\r\n  	background-repeat: no-repeat;\r\n  	background-size: cover;\r\n  	[endif]\r\n  \r\n  	color: #fff;\r\n    font-size: 30px;\r\n    text-shadow: 1px 1px 1px #000;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell input[type=submit]:hover {\r\n   box-shadow: 4px 4px 0px rgba(0, 0, 0, 0.1) inset;\r\n	\r\n}\r\n#ppsPopupShell_[ID] .ppsPopupTxt_0 {\r\n	float: left;\r\n  	width: 90%;\r\n	font-family: \'PT Sans\', sans-serif;\r\n  	color: [bg_color_1];\r\n  	font-size: 25px;\r\n  	line-height: 25px;\r\n  	display: block;\r\n  	margin-bottom: 27px;\r\n    padding: 0px 20px 0px 20px;\r\n  	text-align: center;\r\n}\r\n\r\n#ppsPopupShell_[ID] .ppsPopupClose {\r\n	background-repeat: no-repeat;\r\n  	cursor: pointer;\r\n	top: -5px !important;\r\n  	right: -10px !important;\r\n}\r\n#ppsPopupShell_[ID] .ppsPopupClose.ppsPopupClose_lists_black {\r\n 	top: 0 !important;\r\n  	right: 0 !important;\r\n}\r\n#ppsPopupShell_[ID] .ppsPopupClose:hover {\r\n	opacity: 0.8;\r\n}\r\n#ppsPopupShell_[ID] .ppsFootNote{\r\n	color: #585858;\r\n    font-family: \"Helvetica Neue\",Helvetica,Arial,sans-serif;\r\n    font-size: x-small;\r\n    font-style: italic;\r\n    line-height: 14px;\r\n  	margin: 5px 30px;\r\n}\r\n#ppsPopupShell_[ID] .ppsSm{\r\n	margin-top:20px;\r\n}\r\n.ppsPopupShell .ppsErrorMsg{\r\n  width: 200px;\r\n}\r\n\r\n","highlights.png","1","1","1","1","2015-01-10 18:59:43","10"),
("27","New York","1","0","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","<link href=\"https://fonts.googleapis.com/css?family=Lato\" rel=\"stylesheet\" type=\"text/css\" >\r\n<div id=\"ppsPopupShell_[ID]\" class=\"ppsPopupShell ppsPopupListsShell\">\r\n	<a href=\"#\" class=\"ppsPopupClose ppsPopupClose_[close_btn]\"></a>\r\n	<div class=\"ppsInnerTblContent\">\r\n		<div class=\"ppsPopupListsInner ppsPopupInner\">\r\n			[if enb_txt_0]\r\n				<div class=\"ppsPopupTxt ppsPopupClassyTxt ppsPopupClassyTxt_0 ppsPopupTxt_0\">\r\n				[txt_0]\r\n				</div>\r\n			[endif]\r\n		</div><!--\r\n		--><div class=\"ppsRightCol\">\r\n			[if enb_label]\r\n				<div class=\"ppsPopupLabel ppsPopupListsLabel\">[label]</div>\r\n			[endif]\r\n			<div style=\"clear: both;\"></div>\r\n			[if enb_subscribe]\r\n				<div class=\"ppsSubscribeShell\">\r\n					[sub_form_start]\r\n					[sub_fields_html]\r\n					<input type=\"submit\" name=\"submit\" value=\"[sub_btn_label]\" />\r\n					[sub_form_end]\r\n					<div style=\"clear: both;\"></div>\r\n				</div>\r\n			[endif]\r\n			[if enb_sm]\r\n				<div class=\"ppsSm\">\r\n				[sm_html]\r\n				</div>\r\n			[endif]\r\n			[if enb_foot_note]\r\n				<div class=\"ppsFootNote\">\r\n				[foot_note]\r\n				</div>\r\n			[endif]\r\n		</div>\r\n	</div>\r\n</div>","@nice-blue: #5B83AD;\r\n#ppsPopupShell_[ID] {\r\n	width: [width][width_measure];\r\n  	padding: 0px;\r\n  	font-family: Lato;\r\n	font-size: 13px;\r\n	line-height: normal;\r\n	font-weight: normal;\r\n	color: #000;\r\n}\r\n#ppsPopupShell_[ID], #ppsPopupShell_[ID] * {\r\n	-webkit-box-sizing: border-box;\r\n	-moz-box-sizing:    border-box;\r\n	box-sizing:         border-box;\r\n}\r\n#ppsPopupShell_[ID] .ppsInnerTblContent {\r\n	display: block;\r\n	text-align: right;\r\n}\r\n#ppsPopupShell_[ID] .ppsPopupInner {\r\n  {% if popup.params.tpl.enb_subscribe or popup.params.tpl.enb_foot_note or popup.params.tpl.enb_sm %}\r\n  	width: 59%;\r\n	[else]\r\n  	width: 100%;\r\n  	[endif]\r\n	\r\n	vertical-align: middle;\r\n  	display: inline-block;\r\n  	margin: 0px;\r\n	text-align: left;\r\n	\r\n	[if bg_type_0 == \"color\"]\r\n	background: -moz-radial-gradient(center, ellipse cover, {{ adjust_brightness(popup.params.tpl.bg_color_0, 50) }} 0%, [bg_color_0] 100%); /* ff3.6+ */\r\n	background: -webkit-gradient(radial, center center, 0px, center center, 100%, color-stop(0%, {{ adjust_brightness(popup.params.tpl.bg_color_0, 50) }}), color-stop(100%, [bg_color_0])); /* safari4+,chrome */\r\n	background:-webkit-radial-gradient(center, ellipse cover, {{ adjust_brightness(popup.params.tpl.bg_color_0, 50) }} 0%, [bg_color_0] 100%); /* safari5.1+,chrome10+ */\r\n	background: -o-radial-gradient(center, ellipse cover, {{ adjust_brightness(popup.params.tpl.bg_color_0, 50) }} 0%, [bg_color_0] 100%); /* opera 11.10+ */\r\n	background: -ms-radial-gradient(center, ellipse cover, {{ adjust_brightness(popup.params.tpl.bg_color_0, 50) }} 0%, [bg_color_0] 100%); /* ie10+ */\r\n	background:radial-gradient(ellipse at center, {{ adjust_brightness(popup.params.tpl.bg_color_0, 50) }} 0%, [bg_color_0] 100%); /* w3c */\r\n	filter: progid:DXImageTransform.Microsoft.gradient( startColorstr=\"{{ adjust_brightness(popup.params.tpl.bg_color_0, 50) }}\", endColorstr=\"[bg_color_0]\",GradientType=1 ); /* ie6-9 */\r\n  	[elseif bg_type_0 == \"img\"]\r\n  	background-image: url(\"[bg_img_0]\");\r\n  	background-repeat: no-repeat;\r\n  	background-size: cover;\r\n  	[endif]\r\n  	\r\n}\r\n\r\n#ppsPopupShell_[ID] .ppsSubscribeShell form {\r\n	padding: 20px 20px 0;\r\n}\r\n\r\n#ppsPopupShell_[ID] .ppsSubscribeShell input::-webkit-input-placeholder { /* Chrome/Opera/Safari */\r\n    color: #ccc;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell input::-moz-placeholder { /* Firefox 19+ */\r\n    color: #ccc;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell input:-ms-input-placeholder { /* IE 10+ */\r\n    color: #ccc;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell input:-moz-placeholder { /* Firefox 18- */\r\n    color: #ccc;\r\n}\r\n\r\n#ppsPopupShell_[ID] .ppsSubscribeShell textarea::-webkit-input-placeholder { /* Chrome/Opera/Safari */\r\n    color: #ccc;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell textarea::-moz-placeholder { /* Firefox 19+ */\r\n    color: #ccc;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell textarea:-ms-input-placeholder { /* IE 10+ */\r\n    color: #ccc;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell textarea:-moz-placeholder { /* Firefox 18- */\r\n    color: #ccc;\r\n}\r\n/*For all Elements*/\r\n#ppsPopupShell_[ID] .ppsSubscribeShell input[type=\"email\"],\r\n#ppsPopupShell_[ID] .ppsSubscribeShell input[type=\"password\"],\r\n#ppsPopupShell_[ID] .ppsSubscribeShell input[type=\"text\"],\r\n#ppsPopupShell_[ID] .ppsSubscribeShell select,\r\n#ppsPopupShell_[ID] .ppsSubscribeShell textarea {\r\n	font-family: Lato;\r\n	font-size: 16px;\r\n	font-weight: normal;\r\n	line-height: normal;\r\n	color: #aaa;\r\n	text-align:center;\r\n	width: 100%;\r\n	-webkit-border-radius: 5px;\r\n	-moz-border-radius: 5px;\r\n	border-radius: 5px;\r\n	border: 0px solid transparent;\r\n	display:block;\r\n    \r\n    margin: 10px 0 0;\r\n	padding: 0 10px 0 10px;\r\n	height: 40px;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell textarea {\r\n	height: auto;\r\n	padding-top: 9px;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeForm input:first-child {\r\n	margin-top: 0px;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell select  {\r\n	margin: 0;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell label  {\r\n	display: block;\r\n	font-family: Lato;\r\n	font-size: 16px;\r\n	font-weight: normal;\r\n	line-height: normal;\r\n	color: #fff;\r\n	\r\n	margin: 10px 0 0;\r\n	text-align: center;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell label  span {\r\n	display: block;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell input[type=\"text\"][name=\"name\"] {\r\n	background-image: url(\"[PPS_ASSETS_URL]img/assets/user-black-icon.png\");\r\n	background-position: 12px center;\r\n	background-repeat: no-repeat;\r\n	background-size: 16px auto;\r\n	padding: 0 25px 0 35px;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell input[type=\"email\"] {\r\n	background-image: url(\"[PPS_ASSETS_URL]img/assets/email-black-icon.png\");\r\n	background-position: 11px center;\r\n	background-repeat: no-repeat;\r\n	background-size: 18px auto;\r\n	padding: 0 25px 0 35px;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell input[type=\"submit\"] {\r\n	display: block;\r\n	font-family: Lato;\r\n	font-size: 17px;\r\n	font-weight: bold;\r\n	line-height: normal;\r\n	color: #fff;\r\n  	cursor: pointer;\r\n	margin: 10px 0 0;\r\n	-webkit-border-radius: 5px;\r\n	-moz-border-radius: 5px;\r\n	border-radius: 5px;\r\n	border: 0px solid transparent;\r\n	width: 100%;\r\n	height: 50px;\r\n	\r\n  	[if bg_type_2 == \"color\"]\r\n  	background: [bg_color_2] 100%;\r\n  	[elseif bg_type_2 == \"img\"]\r\n  	background: url(\"[bg_img_2]\");\r\n  	background-repeat: no-repeat;\r\n  	background-size: cover;\r\n  	[endif]\r\n}\r\n\r\n#ppsPopupShell_[ID] .ppsRightCol {\r\n  	border-radius: 3px;\r\n	-moz-border-radius: 3px;\r\n	-webkit-border-radius: 3px;\r\n  	min-height: 350px;\r\n  	width: 40%;\r\n	display: inline-block;\r\n  	padding: 20px;\r\n	margin: 0;\r\n	vertical-align: middle;\r\n	\r\n  	[if bg_type_1 == \"color\"]\r\n	background: [bg_color_1];\r\n  	[elseif bg_type_1 == \"img\"]\r\n  	background-image: url(\"[bg_img_1]\");\r\n  	background-repeat: no-repeat;\r\n  	background-size: cover;\r\n  	[endif]\r\n}\r\n\r\n#ppsPopupShell_[ID] .ppsPopupLabel {\r\n	color:#ffffff;\r\n  	font-family: \"Lato\";\r\n  	font-weight: normal;\r\n	line-height: normal;\r\n  	font-size: 24px;\r\n	letter-spacing: -1px;\r\n  	padding: 0px;\r\n	margin: 20px 0 0;\r\n  	text-align: center;\r\n  	\r\n    width: 100%;\r\n}\r\n\r\n#ppsPopupShell_[ID] .ppsPopupTxt_0 {\r\n	float: left;\r\n  	width: 100%;\r\n    height: 300px;\r\n	line-height: normal;\r\n  	font-size: 14px;\r\n  	font-family: Lato;\r\n	font-weight: 400;\r\n	\r\n	\r\n	padding: 0px;\r\n	margin: 0;\r\n	\r\n}\r\n\r\n#ppsPopupShell_[ID] .ppsPopupTxt_0 p {\r\n	font-size: inherit !important;\r\n	font-weight: inherit !important;\r\n	font-size: inherit !important;\r\n	line-height: inherit !important;\r\n	width: 100%;\r\n	margin: 0;\r\n	padding: 0;\r\n}\r\n\r\n#ppsPopupShell_[ID] .ppsPopupClose {\r\n	background-repeat: no-repeat;\r\n  	cursor: pointer;\r\n  	top:-20px;\r\n  	right:1px;\r\n  	z-index:99999;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubMsg {\r\n	text-align: center;\r\n}\r\n#ppsPopupShell_[ID] .ppsPopupClose.ppsPopupClose_lists_black {\r\n 	top: 0 !important;\r\n  	right: 0 !important;\r\n}\r\n#ppsPopupShell_[ID] .ppsPopupClose:hover {\r\n	opacity: 0.8;\r\n}\r\n#ppsPopupShell_[ID] .ppsFootNote{\r\n	color: #ffffff;\r\n	text-align: center;\r\n    font-family: Lato;\r\n    font-size: x-small;\r\n    font-weight: bold;\r\n    line-height: 14px;\r\n  	margin: 10px 30px 5px;\r\n}","230-6-new-york-prev.png","1","1","1","1","2015-01-10 18:59:43","1"),
("28","Smart","1","0","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","<div id=\"ppsPopupShell_[ID]\" class=\"ppsPopupShell ppsPopupListsShell\">\r\n	<a href=\"#\" class=\"ppsPopupClose\"></a>\r\n	<div class=\"ppsPopupListsInner\">\r\n		<div class=\"ppsPopupTblCols\">\r\n			<div class=\"ppsPopupLeftCol\">\r\n				[if bg_type_2 == \'img\']\r\n				<img src=\"[bg_img_2]\" />\r\n				[endif]\r\n			</div>\r\n			<div class=\"ppsPopupRightCol\">\r\n				<div class=\"ppsBigArrow\"></div>\r\n				[if enb_label]\r\n					<div class=\"ppsPopupLabel\">[label]</div>\r\n				[endif]\r\n				[if enb_txt_0]\r\n					<div class=\"ppsPopupTxt ppsPopupTxt_0\">[txt_0]</div>\r\n				[endif]\r\n				[if enb_subscribe]\r\n					<div class=\"ppsSubscribeShell\">\r\n						[sub_form_start]\r\n						[sub_fields_html]\r\n						<input type=\"submit\" name=\"submit\" value=\"[sub_btn_label]\" />\r\n						[sub_form_end]\r\n					</div>\r\n				[endif]\r\n				[if enb_sm]\r\n					<div class=\"ppsSm\">\r\n					[sm_html]\r\n					</div>\r\n				[endif]\r\n				[if enb_foot_note]\r\n					<div class=\"ppsFootNote\">\r\n					[foot_note]\r\n					</div>\r\n				[endif]\r\n			</div>\r\n		</div>\r\n	</div>\r\n</div>","#ppsPopupShell_[ID] {\r\n	width: [width][width_measure];\r\n  	font-family: Helvetica,Arial,sans-serif;\r\n  	font-size: 14px;\r\n  	[if bg_type_0 == \'img\']\r\n  	background-image: url(\"[bg_img_0]\");\r\n  	background-repeat: no-repeat;\r\n  	background-size: cover;\r\n  	[endif]\r\n}\r\n#ppsPopupShell_[ID], #ppsPopupShell_[ID] * {\r\n	-webkit-box-sizing: content-box;\r\n	-moz-box-sizing:    content-box;\r\n	box-sizing:         content-box;\r\n}\r\n#ppsPopupShell_[ID] .ppsPopupLabel {\r\n	color: [bg_color_1];\r\n    font-size: 25px;\r\n    font-weight: bold;\r\n	line-height: 1.2;\r\n}\r\n#ppsPopupShell_[ID] .ppsPopupListsInner {\r\n  	border: 3px solid #bac0ac;\r\n  	-webkit-box-shadow: inset 0 0 0 5px #fff, 0 10px 25px rgba(0,0,0,0.5);\r\n	-moz-box-shadow: inset 0 0 0 5px #fff, 0 10px 25px rgba(0,0,0,0.5);\r\n	box-shadow: inset 0 0 0 5px #fff, 0 10px 25px rgba(0,0,0,0.5);\r\n  	[if bg_type_0 == \'color\']\r\n    background: {{ adjust_brightness(popup.params.tpl.bg_color_0, 50) }}; /* Old browsers */\r\n    background: -moz-radial-gradient(center, ellipse cover, {{ adjust_brightness(popup.params.tpl.bg_color_0, 50) }} 0%, [bg_color_0] 100%); /* FF3.6+ */\r\n    background: -webkit-gradient(radial, center center, 0px, center center, 100%, color-stop(0%,{{ adjust_brightness(popup.params.tpl.bg_color_0, 50) }}), color-stop(100%,[bg_color_0])); /* Chrome,Safari4+ */\r\n    background: -webkit-radial-gradient(center, ellipse cover, {{ adjust_brightness(popup.params.tpl.bg_color_0, 50) }} 0%,[bg_color_0] 100%); /* Chrome10+,Safari5.1+ */\r\n    background: -o-radial-gradient(center, ellipse cover, {{ adjust_brightness(popup.params.tpl.bg_color_0, 50) }} 0%,[bg_color_0] 100%); /* Opera 12+ */\r\n    background: -ms-radial-gradient(center, ellipse cover, {{ adjust_brightness(popup.params.tpl.bg_color_0, 50) }} 0%,[bg_color_0] 100%); /* IE10+ */\r\n    background: radial-gradient(ellipse at center, {{ adjust_brightness(popup.params.tpl.bg_color_0, 50) }} 0%,[bg_color_0] 100%); /* W3C */\r\n    filter: progid:DXImageTransform.Microsoft.gradient( startColorstr=\'{{ adjust_brightness(popup.params.tpl.bg_color_0, 50) }}\', endColorstr=\'#eaeaea\',GradientType=1 ); /* IE6-9 fallback on horizontal gradient */\r\n  	[endif]\r\n}\r\n#ppsPopupShell_[ID] .ppsPopupTxt_0 .ppsTxtContent {\r\n	padding: 10px 10px 10px 50px;\r\n}\r\n#ppsPopupShell_[ID] .ppsPopupTblCols {\r\n	display: table;\r\n  	padding: 10px 10px 10px 30px;\r\n}\r\n#ppsPopupShell_[ID] .ppsPopupLeftCol {\r\n	display: table-cell;\r\n  	[if enb_subscribe]\r\n  	width: 30%;\r\n  	[else]\r\n  	width: 30%;\r\n  	min-height: 60%;\r\n  	[endif]\r\n  	vertical-align: middle;\r\n    text-align: center;\r\n}\r\n#ppsPopupShell_[ID] .ppsPopupRightCol {\r\n  	width: 70%;\r\n	display: table-cell;\r\n  	border-radius: 8px;\r\n	-moz-border-radius: 8px;\r\n	-webkit-border-radius: 8px;\r\n  	margin: 8px 5px 5px 5px;\r\n  	text-align: left;\r\n  	padding: 30px 0 30px 0;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell form {\r\n	padding: 30px 0 0;\r\n  	text-align: center;\r\n    position: relative;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell input,\r\n#ppsPopupShell_[ID] .ppsSubscribeShell .ppsSubSelect,\r\n#ppsPopupShell_[ID] .ppsSubscribeShell textarea {\r\n  	margin-bottom: 10px;\r\n  	height: 37px !important;\r\n    width: 60%;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell input[type=text],#ppsPopupShell_[ID] .ppsSubscribeShell input[type=email],#ppsPopupShell_[ID] .ppsSubscribeShell input[type=password],#ppsPopupShell_[ID] .ppsSubscribeShell input[type=email],\r\n#ppsPopupShell_[ID] .ppsSubscribeShell .ppsSubSelect,\r\n#ppsPopupShell_[ID] .ppsSubscribeShell textarea {\r\n	box-shadow: 0px [bg_color_1] inset;\r\n  	padding: 0 0 0 10px;\r\n  	font-size: 17px;\r\n  	background: [bg_color_1];\r\n  	border: 1px solid transparent;\r\n  	color: #993300;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell .ppsSubSelect {\r\n	display: table;\r\n  	text-align: left;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell .ppsSubSelectLabel,\r\n#ppsPopupShell_[ID] .ppsSubscribeShell select {\r\n	display: table-cell;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell .ppsSubSelectLabel {\r\n	opacity: 0.5;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell select {\r\n	width: 100%;\r\n  	background-color: transparent;\r\n  	height: 40px;\r\n  	border: none;\r\n  	font-size: 17px;\r\n  	color: #fff;\r\n  	margin-left: -15px;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell textarea {\r\n	font-family: inherit;\r\n  	height: auto;\r\n    padding: 20px 5px;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell input[type=text],#ppsPopupShell_[ID] .ppsSubscribeShell input[type=email],#ppsPopupShell_[ID] .ppsSubscribeShell input[type=password],#ppsPopupShell_[ID] .ppsSubscribeShell input[type=email] {\r\n    float: left;\r\n    margin-left: 7px;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell input[type=submit] {\r\n	border: none;\r\n  	float:left;\r\n  	[if bg_type_3 == \'color\']\r\n  	background: [bg_color_3];\r\n	background-image: none;\r\n  	[elseif bg_type_3 == \'img\']\r\n  	background-image: url(\"[bg_img_3]\");\r\n  	background-repeat: no-repeat;\r\n  	background-size: cover;\r\n  	[endif]\r\n  	color: #993300;;\r\n    font-size: 17px;\r\n  	cursor: pointer;\r\n  	width:  auto;\r\n    text-transform: uppercase;\r\n  	-webkit-transition: all 0.5s ease;\r\n    -moz-transition: all 0.5s ease;\r\n    -o-transition: all 0.5s ease;\r\n    transition: all 0.5s ease;\r\n  	padding: 1px 10px;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell input[type=submit]:hover {\r\n	opacity: 0.8;\r\n}\r\n#ppsPopupShell_[ID] .ppsPopupClose:hover {\r\n	opacity: 0.8;\r\n}\r\n#ppsPopupShell_[ID] .ppsPopupClose {\r\n	background-repeat: no-repeat;\r\n  	cursor: pointer;\r\n  	right: -5px;\r\n	top: 2px;\r\n}\r\n#ppsPopupShell_[ID] .ppsPopupTxt_0 {\r\n	float: left;\r\n  	width: 90%;\r\n	font-family: \'PT Serif\', serif;\r\n  	color: #fff;\r\n  	font-size: 16px;\r\n    line-height: 24px;\r\n  	display: block;\r\n  	margin-bottom: 27px;\r\n    padding: 0px 20px 0px 0;\r\n}\r\n#ppsPopupShell_[ID] .ppsFootNote {\r\n  	[if enb_subscribe]\r\n    color: #000000;\r\n    font-family: \"Helvetica Neue\",Helvetica,Arial,sans-serif;\r\n    font-size: xx-small;\r\n    font-style: italic;\r\n    line-height: 14px;\r\n    text-align: left;\r\n  	margin-left: 10px;\r\n  	[else]\r\n  	margin-top: 10px;\r\n  	color: #979696;\r\n    font-family: \"Helvetica Neue\",Helvetica,Arial,sans-serif;\r\n    font-size: xx-small;\r\n    font-style: italic;\r\n    line-height: 14px;\r\n    text-align: left;\r\n    margin-left: 10px;\r\n  	[endif]\r\n}\r\n#ppsPopupShell_[ID] .ppsSm{\r\n[if enb_subscribe]\r\n  [else]\r\n  	margin-top: 130px;\r\n  	[endif]\r\n}\r\n#ppsPopupShell_[ID] li{\r\n	font-weight: bold;\r\n  	font-size: 13px;\r\n  	padding-top: 3px;\r\n	padding-bottom: 3px;\r\n  	color: #737E86;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubMsg {\r\n	clear: both;\r\n}","smart.png","1","1","1","1","2015-01-13 19:22:48","14"),
("29","Find Us","1","0","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","<div id=\"ppsPopupShell_[ID]\" class=\"ppsPopupShell ppsPopupListsShell\">\r\n	<a href=\"#\" class=\"ppsPopupClose ppsPopupClose_[close_btn]\"></a>\r\n	<div class=\"ppsInnerTblContent\">\r\n		<div class=\"ppsPopupListsInner ppsPopupInner\">\r\n			[if enb_txt_0]\r\n				<div class=\"ppsPopupTxt ppsPopupClassyTxt ppsPopupClassyTxt_0 ppsPopupTxt_0\">\r\n				[txt_0]\r\n				</div>\r\n			[endif]\r\n			[if enb_label]\r\n				<div class=\"label-window\">\r\n				<div class=\"ppsPopupLabel ppsPopupListsLabel\">[label]</div>\r\n				</div>\r\n			[endif]\r\n			[if enb_subscribe]\r\n				<div class=\"find-form ppsSubscribeShell\">\r\n					[sub_form_start]\r\n					[sub_fields_html]\r\n					<input type=\"submit\" name=\"submit\" value=\"[sub_btn_label]\" />\r\n					[sub_form_end]\r\n				</div>\r\n			[endif]\r\n			<div style=\"clear: both;\"></div>\r\n			[if enb_sm]\r\n				<div class=\"ppsSm\">\r\n				[sm_html]\r\n				</div>\r\n			[endif]\r\n			[if enb_foot_note]\r\n				<div class=\"ppsFootNote\">\r\n				[foot_note]\r\n				</div>\r\n			[endif]\r\n		</div>\r\n	</div>\r\n</div>","#ppsPopupShell_[ID] {\r\n	width: [width][width_measure];\r\n  	padding: 15px;\r\n  	font-family: Georgia, Times, serif;\r\n	font-size: 13px;\r\n	line-height: 21px;\r\n	font-weight: normal;\r\n	color: #000;\r\n}\r\n#ppsPopupShell_[ID] .ppsInnerTblContent {\r\n	display: table;\r\n    position: relative;\r\n  [if bg_type_0 == \'color\']\r\n	background: -moz-radial-gradient(center, ellipse cover, {{ adjust_brightness(popup.params.tpl.bg_color_0, 50) }} 0%, [bg_color_0] 100%); /* ff3.6+ */\r\n	background: -webkit-gradient(radial, center center, 0px, center center, 100%, color-stop(0%, {{ adjust_brightness(popup.params.tpl.bg_color_0, 50) }}), color-stop(100%, [bg_color_0])); /* safari4+,chrome */\r\n	background:-webkit-radial-gradient(center, ellipse cover, {{ adjust_brightness(popup.params.tpl.bg_color_0, 50) }} 0%, [bg_color_0] 100%); /* safari5.1+,chrome10+ */\r\n	background: -o-radial-gradient(center, ellipse cover, {{ adjust_brightness(popup.params.tpl.bg_color_0, 50) }} 0%, [bg_color_0] 100%); /* opera 11.10+ */\r\n	background: -ms-radial-gradient(center, ellipse cover, {{ adjust_brightness(popup.params.tpl.bg_color_0, 50) }} 0%, [bg_color_0] 100%); /* ie10+ */\r\n	background:radial-gradient(ellipse at center, {{ adjust_brightness(popup.params.tpl.bg_color_0, 50) }} 0%, [bg_color_0] 100%); /* w3c */\r\n	filter: progid:DXImageTransform.Microsoft.gradient( startColorstr=\'{{ adjust_brightness(popup.params.tpl.bg_color_0, 50) }}\', endColorstr=\'[bg_color_0]\',GradientType=1 ); /* ie6-9 */\r\n  	[elseif bg_type_0 == \'img\']\r\n  	background-image: url(\"[bg_img_0]\");\r\n  	background-repeat: no-repeat;\r\n  	background-size: cover;\r\n  	[endif]\r\n}\r\n#ppsPopupShell_[ID] .ppsPopupInner {\r\n      position: relative;\r\n  {% if popup.params.tpl.enb_subscribe or popup.params.tpl.enb_foot_note or popup.params.tpl.enb_sm %}\r\n  	width: 50%;\r\n	[else]\r\n  	width: 100%;\r\n  	[endif]\r\n  	display: table-cell;\r\n}\r\n#ppsPopupShell_[ID] .label-window{\r\n  position:absolute;\r\n    top: 0;\r\n    background-color: rgba(10,10,10,0.6);\r\n    padding-right: 30px;\r\n    left: 40px;\r\n}\r\n#ppsPopupShell_[ID] .ppsPopupLabel {\r\n  	color: #000;\r\n	font-family: \'Open Sans\', arial;\r\n	font-size: 28px;\r\n	font-weight: 100;\r\n	color: #ffffff;\r\n	text-shadow: #000000 1px 1px 1px;\r\n	margin-top: 15px;\r\n	margin-bottom: 16px;\r\n	padding-left: 20px;\r\n  	line-height: 26px;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell {\r\n    bottom: 20px;\r\n    right: 20px;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell form {\r\n	text-align: center;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell input,\r\n#ppsPopupShell_[ID] .ppsSubscribeShell .ppsSubSelect,\r\n#ppsPopupShell_[ID] .ppsSubscribeShell textarea {\r\n	padding: 11px 24px 10px;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell input[type=text],#ppsPopupShell_[ID] .ppsSubscribeShell input[type=email],#ppsPopupShell_[ID] .ppsSubscribeShell input[type=password],#ppsPopupShell_[ID] .ppsSubscribeShell input[type=email],\r\n#ppsPopupShell_[ID] .ppsSubscribeShell .ppsSubSelect,\r\n#ppsPopupShell_[ID] .ppsSubscribeShell textarea {\r\n  	/*background-color: rgba(0,0,0,0.8) !important;\r\n  	padding-left: 10px;\r\n  	font-size: 17px;\r\n  	color: #fff;*/\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell .ppsSubSelect {\r\n	display: table;\r\n  	text-align: left;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell .ppsSubSelectLabel,\r\n#ppsPopupShell_[ID] .ppsSubscribeShell select {\r\n	display: table-cell;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell .ppsSubSelectLabel {\r\n	opacity: 0.5;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell select {\r\n	width: 100%;\r\n  	background-color: transparent;\r\n  	height: 40px;\r\n  	border: none;\r\n  	font-size: 17px;\r\n  	color: #fff;\r\n  	border-top-right-radius: 3px;\r\n  	border-bottom-right-radius: 3px;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell textarea {\r\n	font-family: inherit;\r\n  	height: auto;\r\n    padding-top: 5px;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell input[type=submit] {\r\n	[if bg_type_1 == \'color\']\r\n  	background-color: [bg_color_1];\r\n  	background-image: none;\r\n  	[elseif bg_type_1 == \'img\']\r\n  	background-image: url(\"[bg_img_1]\");\r\n  	background-repeat: no-repeat;\r\n  	background-size: cover;\r\n  	[endif]\r\n  	color: #fff;\r\n  	cursor: pointer;\r\n	border: none;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell input[type=submit]:hover {\r\n	box-shadow: inset 1px 1px 3px #666;\r\n}\r\n#ppsPopupShell_[ID] .ppsPopupTxt_0 {\r\n  	text-align: center;\r\n  	font-family: \'Open Sans\', arial;\r\n 	font-weight: 100;\r\n	color: #ffffff;\r\n	text-shadow: #000000 1px 1px 1px;\r\n  	font-size: 14px;\r\n}\r\n#ppsPopupShell_[ID] .ppsPopupTxt_0 {\r\n  	position:reletive;\r\n}\r\n#ppsPopupShell_[ID] .ppsPopupClose {\r\n	background-repeat: no-repeat;\r\n  	cursor: pointer;\r\n    top: -5px !important;\r\n    right: -5px !important;\r\n}\r\n#ppsPopupShell_[ID] .ppsPopupClose.ppsPopupClose_lists_black {\r\n 	top: 0 !important;\r\n  	right: 0 !important;\r\n}\r\n#ppsPopupShell_[ID] .ppsPopupClose:hover {\r\n	opacity: 0.8;\r\n}\r\n#ppsPopupShell_[ID] .ppsFootNote{\r\n	color: #585858;\r\n    font-family: \"Helvetica Neue\",Helvetica,Arial,sans-serif;\r\n    font-size: x-small;\r\n    font-style: italic;\r\n    line-height: 14px;\r\n  	margin: 5px 30px;\r\n}","find-us.png","1","1","1","1","2015-01-10 18:59:43","29"),
("30","Photodoto","1","0","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","<link href=\'http://fonts.googleapis.com/css?family=Bitter\' rel=\'stylesheet\' type=\'text/css\'>\r\n<div id=\"ppsPopupShell_[ID]\" class=\"ppsPopupShell ppsPopupListsShell\">\r\n	<a href=\"#\" class=\"ppsPopupClose ppsPopupClose_[close_btn]\"></a>\r\n	<div class=\"ppsInnerTblContent\">\r\n		<div class=\"ppsPopupListsInner ppsPopupInner\">\r\n			[if enb_label]\r\n				<div class=\"pop_form__title\">\r\n				<div class=\"ppsPopupLabel ppsPopupListsLabel\">[label]</div>\r\n				</div>\r\n			[endif]\r\n			<div style=\"clear: both;\"></div>\r\n			<div class=\"text-block\">\r\n				<div class=\"logo\"> \r\n					<div class=\"logo-img\"> </div>\r\n				</div>\r\n				[if enb_txt_0]\r\n					<div class=\"ppsPopupTxt ppsPopupClassyTxt ppsPopupClassyTxt_0 ppsPopupTxt_0\">\r\n					[txt_0]\r\n					</div>\r\n				[endif]\r\n			</div>\r\n			[if enb_subscribe]\r\n				<div class=\"ppsSubscribeShell\">\r\n					[sub_form_start]\r\n					[sub_fields_html]\r\n					<input class=\"butt\" type=\"submit\" name=\"submit\" value=\"[sub_btn_label]\" />\r\n					[sub_form_end]\r\n					<div style=\"clear: both;\"></div>\r\n				</div>\r\n			[endif]\r\n			<div style=\"clear: both;\"></div>\r\n			[if enb_sm]\r\n				<div style=\"clear: both;\"></div>\r\n				<div class=\"ppsSm\">\r\n				[sm_html]\r\n				</div>\r\n			[endif]\r\n			[if enb_foot_note]\r\n				<div class=\"ppsFootNote\">\r\n				[foot_note]\r\n				</div>\r\n			[endif]\r\n		</div>\r\n	</div>\r\n</div>","#ppsPopupShell_[ID] {\r\n	width: [width][width_measure];\r\n  	font-family: \'arial\', arial;\r\n	font-size: 13px;\r\n	line-height: 21px;\r\n	font-weight: normal;\r\n}\r\n#ppsPopupShell_[ID] .ppsInnerTblContent {\r\n	border: 5px solid #fff;\r\n    border-radius: 10px;\r\n}\r\n#ppsPopupShell_[ID] .ppsPopupInner {\r\n  {% if popup.params.tpl.enb_subscribe or popup.params.tpl.enb_foot_note or popup.params.tpl.enb_sm %}\r\n  	width: 100%;\r\n  	border-radius: 4px;\r\n	[else]\r\n  	width: 100%;\r\n  	[endif]\r\n	[if bg_type_0 == \'color\']\r\n	background: -moz-radial-gradient(center, ellipse cover, {{ adjust_brightness(popup.params.tpl.bg_color_0, 50) }} 0%, [bg_color_0] 100%); /* ff3.6+ */\r\n	background: -webkit-gradient(radial, center center, 0px, center center, 100%, color-stop(0%, {{ adjust_brightness(popup.params.tpl.bg_color_0, 50) }}), color-stop(100%, [bg_color_0])); /* safari4+,chrome */\r\n	background:-webkit-radial-gradient(center, ellipse cover, {{ adjust_brightness(popup.params.tpl.bg_color_0, 50) }} 0%, [bg_color_0] 100%); /* safari5.1+,chrome10+ */\r\n	background: -o-radial-gradient(center, ellipse cover, {{ adjust_brightness(popup.params.tpl.bg_color_0, 50) }} 0%, [bg_color_0] 100%); /* opera 11.10+ */\r\n	background: -ms-radial-gradient(center, ellipse cover, {{ adjust_brightness(popup.params.tpl.bg_color_0, 50) }} 0%, [bg_color_0] 100%); /* ie10+ */\r\n	background:radial-gradient(ellipse at center, {{ adjust_brightness(popup.params.tpl.bg_color_0, 50) }} 0%, [bg_color_0] 100%); /* w3c */\r\n	filter: progid:DXImageTransform.Microsoft.gradient( startColorstr=\'{{ adjust_brightness(popup.params.tpl.bg_color_0, 50) }}\', endColorstr=\'[bg_color_0]\',GradientType=1 ); /* ie6-9 */\r\n  	[elseif bg_type_0 == \'img\']\r\n  	background-image: url(\"[bg_img_0]\");\r\n  	background-repeat: no-repeat;\r\n  	background-size: cover;\r\n  	[endif]\r\n}\r\n#ppsPopupShell_[ID] .pop_form__title {\r\n    [if bg_type_1 == \'color\']\r\n  	background: [bg_color_1] 100%;\r\n  	[elseif bg_type_1 == \'img\']\r\n  	background-image: url(\"[bg_img_1]\");\r\n  	background-repeat: no-repeat;\r\n  	background-size: cover;\r\n  	[endif]\r\n    font-size: 24px;\r\n    color: #FFF;\r\n    line-height: 28px;\r\n    text-transform: uppercase;\r\n    font-family: \'Scolar Bold\';\r\n    text-align: center;\r\n    padding: 20px 0px;\r\n    border-radius: 5px 5px 0px 0px;\r\n    -moz-border-radius: 5px 5px 0px 0px;\r\n    -webkit-border-radius: 5px 5px 0px 0px;\r\n}\r\n#ppsPopupShell_[ID] .ppsPopupLabel {\r\n    padding: 5px;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell form {\r\n	padding: 1% 1% 1% 1%;\r\n	text-align:right;\r\n	margin-bottom: 20px;\r\n  	padding-left: 20px;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell input,\r\n#ppsPopupShell_[ID] .ppsSubscribeShell .ppsSubSelect,\r\n#ppsPopupShell_[ID] .ppsSubscribeShell textarea {\r\n	/*width: 100%;*/\r\n  	margin-bottom: 10px;\r\n  	height: 40px;\r\n  	border: 0px solid #d1b36d;\r\n	border-radius: 4px !important;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell input[type=text],#ppsPopupShell_[ID] .ppsSubscribeShell input[type=email],#ppsPopupShell_[ID] .ppsSubscribeShell input[type=password],#ppsPopupShell_[ID] .ppsSubscribeShell input[type=email],\r\n#ppsPopupShell_[ID] .ppsSubscribeShell .ppsSubSelect,\r\n#ppsPopupShell_[ID] .ppsSubscribeShell textarea {\r\n	box-shadow: 2px 2px 2px #dcdcdc inset;\r\n  	padding-left: 20px;\r\n  	font-size: 17px;\r\n	width: 100%;\r\n  	max-width: 284px;\r\n	display: block;\r\n	float: left;\r\n    color: #7f7f7f;\r\n  	background-color: #fff;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell .ppsSubSelect {\r\n	display: table;\r\n  	text-align: left;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell .ppsSubSelectLabel,\r\n#ppsPopupShell_[ID] .ppsSubscribeShell select {\r\n	display: table-cell;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell .ppsSubSelectLabel {\r\n	opacity: 0.5;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell select {\r\n	width: 100%;\r\n  	background-color: transparent;\r\n  	height: 40px;\r\n  	border: none;\r\n  	font-size: 17px;\r\n	border-top-right-radius: 4px;\r\n  	border-bottom-right-radius: 4px;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell textarea {\r\n	font-family: inherit;\r\n  	height: auto;\r\n    padding-top: 5px;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell input[type=text],#ppsPopupShell_[ID] .ppsSubscribeShell input[type=email],#ppsPopupShell_[ID] .ppsSubscribeShell input[name=\"email\"] {\r\n	width: 60% !important;\r\n    padding: 12px 15px!important;\r\n    float: left;\r\n    height: auto;\r\n    border-radius: 5px;\r\n    -moz-border-radius: 5px;\r\n    -webkit-border-radius: 5px;\r\n    border: none;\r\n    background: #FFF;\r\n    font-size: 16px;\r\n    color: #7f7f7f;\r\n    margin-right: 0px!important;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell input[type=submit] {\r\n	border-color: #000;\r\n	height: 43px;\r\n  	display:block;\r\n  	float: left;\r\n	margin-left: 10px;\r\n  	[if bg_type_4 == \'color\']\r\n  	background: [bg_color_4] 100%;\r\n   	box-shadow: -4px -4px 0px rgba(0, 0, 0, 0.1) inset;\r\n  	background-image: none;\r\n  	[elseif bg_type_1 == \'img\']\r\n  	background-image: url(\"[bg_img_1]\");\r\n  	background-repeat: no-repeat;\r\n  	background-size: cover;\r\n  	[endif]\r\n  	color: #fff;\r\n    font-size: 16px;\r\n    text-shadow: 1px 1px 1px #000;\r\n  	cursor: pointer;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell input[type=submit]:hover {\r\n   box-shadow: 4px 4px 0px rgba(0, 0, 0, 0.1) inset;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell{\r\n    [if bg_type_3 == \'color\']\r\n  	background: [bg_color_3] 100%;\r\n  	[elseif bg_type_3 == \'img\']\r\n  	background-image: url(\"[bg_img_3]\");\r\n  	background-repeat: no-repeat;\r\n  	background-size: cover;\r\n  	[endif]\r\n    float: left;\r\n    width: 100%;\r\n    padding: 40px 0 30px 0;\r\n}\r\n#ppsPopupShell_[ID] .logo-img{\r\n  	width:180px;\r\n  	height:180px;\r\n  	[if bg_type_2 == \'color\']\r\n	background: [bg_color_2]; \r\n  	[elseif bg_type_2 == \'img\']\r\n  	background-image: url(\"[bg_img_2]\");\r\n  	background-repeat: no-repeat;\r\n  	background-size: cover;\r\n  	[endif]\r\n	position: absolute; \r\n    right: 0;\r\n}\r\n#ppsPopupShell_[ID] .text-block {\r\n    position: relative;\r\n}\r\n#ppsPopupShell_[ID] .ppsPopupTxt_0 {\r\n	float: left;\r\n  	width: 65%;\r\n	text-align: left;\r\n	color: #f37362;\r\n    font-size: 23px;\r\n    line-height: 30px;\r\n    padding-left: 10px;\r\n}\r\n\r\n#ppsPopupShell_[ID] .ppsPopupTxt_0 li{\r\n	font-size: 18px;\r\n    color: #629296;\r\n    line-height: 26px;\r\n    display: inline-block;\r\n    padding-left: 25px;\r\n    margin-bottom: 16px;\r\n}\r\n#ppsPopupShell_[ID] .ppsPopupClose {\r\n	background-repeat: no-repeat;\r\n  	cursor: pointer;\r\n	top: 15px;\r\n}\r\n#ppsPopupShell_[ID] .ppsPopupClose.ppsPopupClose_lists_black {\r\n 	top: 0 !important;\r\n  	right: 0 !important;\r\n}\r\n#ppsPopupShell_[ID] .ppsPopupClose:hover {\r\n	opacity: 0.8;\r\n}\r\n#ppsPopupShell_[ID] .ppsFootNote{\r\n	color: #585858;\r\n    font-family: \"Helvetica Neue\",Helvetica,Arial,sans-serif;\r\n    font-size: x-small;\r\n    font-style: italic;\r\n    line-height: 14px;\r\n  	margin: 5px 30px;\r\n    display: inline-block;\r\n}\r\n#ppsPopupShell_[ID] .ppsSm{\r\n	margin-top:20px;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubMsg{\r\n	clear: both;\r\n  	text-align: center;\r\n}","Photodoto.png","1","1","1","1","2015-01-10 18:59:43","24"),
("31","Map style","1","0","YTozOntzOjQ6Im1haW4iO2E6Mjk6e3M6Nzoic2hvd19vbiI7czo5OiJwYWdlX2xvYWQiO3M6MjM6InNob3dfb25fcGFnZV9sb2FkX2RlbGF5IjtzOjA6IiI7czoyNToic2hvd19vbl9jbGlja19vbl9lbF9kZWxheSI7czoxOiIwIjtzOjI3OiJzaG93X29uX3Njcm9sbF93aW5kb3dfZGVsYXkiO3M6MToiMCI7czozMzoic2hvd19vbl9zY3JvbGxfd2luZG93X3BlcmNfc2Nyb2xsIjtzOjE6IjAiO3M6Mjg6InNob3dfb25fYWZ0ZXJfaW5hY3RpdmVfdmFsdWUiO3M6MjoiMTAiO3M6MjU6InNob3dfb25fbGlua19mb2xsb3dfZGVsYXkiO3M6MToiMCI7czo4OiJjbG9zZV9vbiI7czoxMDoidXNlcl9jbG9zZSI7czoyNjoiY2xvc2Vfb25fYWZ0ZXJfYWN0aW9uX3RpbWUiO3M6MToiMSI7czoyNToiY2xvc2Vfb25fYWZ0ZXJfdGltZV92YWx1ZSI7czoxOiI1IjtzOjEwOiJzaG93X3BhZ2VzIjtzOjM6ImFsbCI7czoxNDoic2hvd190aW1lX2Zyb20iO3M6NzoiMTI6MDBhbSI7czoxMjoic2hvd190aW1lX3RvIjtzOjc6IjEyOjAwYW0iO3M6MTQ6InNob3dfZGF0ZV9mcm9tIjtzOjA6IiI7czoxMjoic2hvd19kYXRlX3RvIjtzOjA6IiI7czo3OiJzaG93X3RvIjtzOjg6ImV2ZXJ5b25lIjtzOjI5OiJzaG93X3RvX2ZpcnN0X3RpbWVfdmlzaXRfZGF5cyI7czoyOiIzMCI7czozMDoic2hvd190b191bnRpbF9tYWtlX2FjdGlvbl9kYXlzIjtzOjI6IjMwIjtzOjE1OiJjb3VudF90aW1lc19udW0iO3M6MToiMSI7czoxNToiY291bnRfdGltZXNfbWVzIjtzOjM6ImRheSI7czoyMToiaGlkZV9mb3JfZGV2aWNlc19zaG93IjtzOjE6IjAiO3M6MjQ6ImhpZGVfZm9yX3Bvc3RfdHlwZXNfc2hvdyI7czoxOiIwIjtzOjE3OiJoaWRlX2Zvcl9pcHNfc2hvdyI7czoxOiIwIjtzOjEyOiJoaWRlX2Zvcl9pcHMiO3M6MDoiIjtzOjIzOiJoaWRlX2Zvcl9jb3VudHJpZXNfc2hvdyI7czoxOiIwIjtzOjIzOiJoaWRlX2Zvcl9sYW5ndWFnZXNfc2hvdyI7czoxOiIwIjtzOjI0OiJoaWRlX3NlYXJjaF9lbmdpbmVzX3Nob3ciO3M6MToiMCI7czoxODoiaGlkZV9wcmVnX3VybF9zaG93IjtzOjE6IjAiO3M6MTM6ImhpZGVfcHJlZ191cmwiO3M6MDoiIjt9czozOiJ0cGwiO2E6OTI6e3M6NToid2lkdGgiO3M6MzoiNjcwIjtzOjEzOiJ3aWR0aF9tZWFzdXJlIjtzOjI6InB4IjtzOjE4OiJiZ19vdmVybGF5X29wYWNpdHkiO3M6MzoiMC41IjtzOjk6ImJnX3R5cGVfMCI7czo0OiJub25lIjtzOjg6ImJnX2ltZ18wIjtzOjA6IiI7czoxMDoiYmdfY29sb3JfMCI7czo3OiIjMjMyMzIzIjtzOjk6ImJnX3R5cGVfMSI7czo1OiJjb2xvciI7czo4OiJiZ19pbWdfMSI7czowOiIiO3M6MTA6ImJnX2NvbG9yXzEiO3M6NzoiI2Q4NTExYyI7czoxMDoiZm9udF9sYWJlbCI7czo3OiJkZWZhdWx0IjtzOjE2OiJsYWJlbF9mb250X2NvbG9yIjtzOjc6IiNmZmZmZmYiO3M6MTA6ImZvbnRfdHh0XzAiO3M6NzoiZGVmYXVsdCI7czoxNzoidGV4dF9mb250X2NvbG9yXzAiO3M6NzoiI2ZmZmZmZiI7czoxMDoiZm9udF90eHRfMSI7czo3OiJkZWZhdWx0IjtzOjE3OiJ0ZXh0X2ZvbnRfY29sb3JfMSI7czo3OiIjMDAwMDAwIjtzOjExOiJmb250X2Zvb3RlciI7czo3OiJkZWZhdWx0IjtzOjE3OiJmb290ZXJfZm9udF9jb2xvciI7czo3OiIjNTg1ODU4IjtzOjE1OiJyZXNwb25zaXZlX21vZGUiO3M6MzoiZGVmIjtzOjE3OiJyZWlkcmVjdF9vbl9jbG9zZSI7czowOiIiO3M6OToiY2xvc2VfYnRuIjtzOjExOiJ3aGlsZV9jbG9zZSI7czo3OiJidWxsZXRzIjtzOjExOiJsaXN0c19ncmVlbiI7czoxMToibGF5ZXJlZF9wb3MiO3M6MzoidG9wIjtzOjk6ImVuYl9sYWJlbCI7czoxOiIxIjtzOjU6ImxhYmVsIjtzOjIzOiJTVUJTQ1JJQkUgVE8gTkVXU0xFVFRFUiI7czo5OiJlbmJfdHh0XzAiO3M6MToiMSI7czo5OiJmb290X25vdGUiO3M6MDoiIjtzOjY6ImVuYl9zbSI7czoxOiIxIjtzOjE1OiJlbmJfc21fZmFjZWJvb2siO3M6MToiMSI7czoxNzoiZW5iX3NtX2dvb2dsZXBsdXMiO3M6MToiMSI7czoxNDoiZW5iX3NtX3R3aXR0ZXIiO3M6MToiMSI7czo5OiJzbV9kZXNpZ24iO3M6Njoic2ltcGxlIjtzOjg6ImFuaW1fa2V5IjtzOjQ6Im5vbmUiO3M6MTM6ImFuaW1fZHVyYXRpb24iO3M6MDoiIjtzOjEzOiJlbmJfc3Vic2NyaWJlIjtzOjE6IjEiO3M6ODoic3ViX2Rlc3QiO3M6OToid29yZHByZXNzIjtzOjIzOiJzdWJfd3BfY3JlYXRlX3VzZXJfcm9sZSI7czoxMDoic3Vic2NyaWJlciI7czoxOToic3ViX2F3ZWJlcl9saXN0bmFtZSI7czowOiIiO3M6MjE6InN1Yl9hd2ViZXJfYWR0cmFja2luZyI7czowOiIiO3M6MjE6InN1Yl9tYWlsY2hpbXBfYXBpX2tleSI7czowOiIiO3M6MjU6InN1Yl9tYWlsY2hpbXBfZ3JvdXBzX2Z1bGwiO3M6MDoiIjtzOjE0OiJzdWJfZ3JfYXBpX2tleSI7czowOiIiO3M6MTY6InN1Yl9ncl9jeWNsZV9kYXkiO3M6MToiMCI7czoxMzoic3ViX2ljX2FwcF9pZCI7czowOiIiO3M6MTU6InN1Yl9pY19hcHBfdXNlciI7czowOiIiO3M6MTU6InN1Yl9pY19hcHBfcGFzcyI7czowOiIiO3M6MTQ6InN1Yl9hY19hcGlfdXJsIjtzOjA6IiI7czoxNDoic3ViX2FjX2FwaV9rZXkiO3M6MDoiIjtzOjE4OiJzdWJfYXJfZm9ybV9hY3Rpb24iO3M6MDoiIjtzOjEwOiJzdWJfc2dhX2lkIjtzOjA6IiI7czoxNToic3ViX3NnYV9saXN0X2lkIjtzOjA6IiI7czoyMToic3ViX3NnYV9hY3RpdmF0ZV9jb2RlIjtzOjA6IiI7czoxMzoic3ViX3NmX2FwcF9pZCI7czowOiIiO3M6MTQ6InN1Yl9ja19hcGlfa2V5IjtzOjA6IiI7czoxNDoic3ViX21lbV9hY2NfaWQiO3M6MDoiIjtzOjE1OiJzdWJfbWVtX3B1ZF9rZXkiO3M6MDoiIjtzOjE2OiJzdWJfbWVtX3ByaXZfa2V5IjtzOjA6IiI7czoxMDoic3ViX2ZpZWxkcyI7YToyOntzOjQ6Im5hbWUiO2E6Nzp7czozOiJlbmIiO3M6MToiMSI7czo0OiJuYW1lIjtzOjQ6Im5hbWUiO3M6NDoiaHRtbCI7czo0OiJ0ZXh0IjtzOjU6ImxhYmVsIjtzOjQ6Ik5hbWUiO3M6NToidmFsdWUiO3M6MDoiIjtzOjY6ImN1c3RvbSI7czoxOiIwIjtzOjk6Im1hbmRhdG9yeSI7czoxOiIwIjt9czo1OiJlbWFpbCI7YTo3OntzOjQ6Im5hbWUiO3M6NToiZW1haWwiO3M6NDoiaHRtbCI7czo0OiJ0ZXh0IjtzOjU6ImxhYmVsIjtzOjY6IkUtTWFpbCI7czo1OiJ2YWx1ZSI7czowOiIiO3M6NjoiY3VzdG9tIjtzOjE6IjAiO3M6OToibWFuZGF0b3J5IjtzOjE6IjEiO3M6MzoiZW5iIjtzOjE6IjEiO319czoyMDoic3ViX3R4dF9jb25maXJtX3NlbnQiO3M6Njc6IkNvbmZpcm1hdGlvbiBsaW5rIHdhcyBzZW50IHRvIHlvdXIgZW1haWwgYWRkcmVzcy4gQ2hlY2sgeW91ciBlbWFpbCEiO3M6MTU6InN1Yl90eHRfc3VjY2VzcyI7czoyNDoiVGhhbmsgeW91IGZvciBzdWJzY3JpYmUhIjtzOjIxOiJzdWJfdHh0X2ludmFsaWRfZW1haWwiO3M6MjI6IkVtcHR5IG9yIGludmFsaWQgZW1haWwiO3M6MjA6InN1Yl90eHRfZXhpc3RzX2VtYWlsIjtzOjIyOiJFbXB0eSBvciBpbnZhbGlkIGVtYWlsIjtzOjE2OiJzdWJfcmVkaXJlY3RfdXJsIjtzOjA6IiI7czoyODoic3ViX3R4dF9jb25maXJtX21haWxfc3ViamVjdCI7czozNDoiQ29uZmlybSBzdWJzY3JpcHRpb24gb24gW3NpdGVuYW1lXSI7czoyNToic3ViX3R4dF9jb25maXJtX21haWxfZnJvbSI7czoxNDoiYWRtaW5AbWFpbC5jb20iO3M6Mjg6InN1Yl90eHRfY29uZmlybV9tYWlsX21lc3NhZ2UiO3M6MTk3OiJZb3Ugc3Vic2NyaWJlZCBvbiBzaXRlIDxhIGhyZWY9XCJbc2l0ZXVybF1cIj5bc2l0ZW5hbWVdPC9hPi4gRm9sbG93IDxhIGhyZWY9XCJbY29uZmlybV9saW5rXVwiPnRoaXMgbGluazwvYT4gdG8gY29tcGxldGUgeW91ciBzdWJzY3JpcHRpb24uIElmIHlvdSBkaWQgbm90IHN1YnNjcmliZSBoZXJlIC0ganVzdCBpZ25vcmUgdGhpcyBtZXNzYWdlLiI7czozMToic3ViX3R4dF9zdWJzY3JpYmVyX21haWxfc3ViamVjdCI7czozNzoiW3NpdGVuYW1lXSBZb3VyIHVzZXJuYW1lIGFuZCBwYXNzd29yZCI7czoyODoic3ViX3R4dF9zdWJzY3JpYmVyX21haWxfZnJvbSI7czoxNDoiYWRtaW5AbWFpbC5jb20iO3M6MzE6InN1Yl90eHRfc3Vic2NyaWJlcl9tYWlsX21lc3NhZ2UiO3M6NjU6IlVzZXJuYW1lOiBbdXNlcl9sb2dpbl08YnIgLz5QYXNzd29yZDogW3Bhc3N3b3JkXTxiciAvPltsb2dpbl91cmxdIjtzOjI1OiJzdWJfcmVkaXJlY3RfZW1haWxfZXhpc3RzIjtzOjA6IiI7czoxMzoic3ViX2J0bl9sYWJlbCI7czo4OiJTaWduLXVwISI7czoxMzoic3ViX25ld19lbWFpbCI7czoxNDoiYWRtaW5AbWFpbC5jb20iO3M6MTU6InN1Yl9uZXdfbWVzc2FnZSI7czoxMjk6IllvdSBoYXZlIG5ldyBzdWJzY3JpYmVyIG9uIHlvdXIgc2l0ZSA8YSBocmVmPVwiW3NpdGV1cmxdXCI+W3NpdGVuYW1lXTwvYT4sIGhlcmUgdXMgc3Vic2NyaWJlciBpbmZvcm1hdGlvbjo8YnIgLz5bc3Vic2NyaWJlcl9kYXRhXSI7czo4OiJsb2dpbl9ieSI7czo4OiJ1c2VybmFtZSI7czoxODoibG9naW5fcmVkaXJlY3RfdXJsIjtzOjA6IiI7czoxNToibG9naW5fYnRuX2xhYmVsIjtzOjU6IkxvZ2luIjtzOjIzOiJyZWdfd3BfY3JlYXRlX3VzZXJfcm9sZSI7czoxMDoic3Vic2NyaWJlciI7czoxMzoicmVnX2J0bl9sYWJlbCI7czo4OiJSZWdpc3RlciI7czoxMDoicmVnX2ZpZWxkcyI7YToyOntzOjQ6Im5hbWUiO2E6Nzp7czozOiJlbmIiO3M6MToiMSI7czo0OiJuYW1lIjtzOjQ6Im5hbWUiO3M6NDoiaHRtbCI7czo0OiJ0ZXh0IjtzOjU6ImxhYmVsIjtzOjQ6Ik5hbWUiO3M6NToidmFsdWUiO3M6MDoiIjtzOjY6ImN1c3RvbSI7czoxOiIwIjtzOjk6Im1hbmRhdG9yeSI7czoxOiIwIjt9czo1OiJlbWFpbCI7YTo3OntzOjQ6Im5hbWUiO3M6NToiZW1haWwiO3M6NDoiaHRtbCI7czo0OiJ0ZXh0IjtzOjU6ImxhYmVsIjtzOjY6IkUtTWFpbCI7czo1OiJ2YWx1ZSI7czowOiIiO3M6NjoiY3VzdG9tIjtzOjE6IjAiO3M6OToibWFuZGF0b3J5IjtzOjE6IjEiO3M6MzoiZW5iIjtzOjE6IjEiO319czoyMDoicmVnX3R4dF9jb25maXJtX3NlbnQiO3M6Njc6IkNvbmZpcm1hdGlvbiBsaW5rIHdhcyBzZW50IHRvIHlvdXIgZW1haWwgYWRkcmVzcy4gQ2hlY2sgeW91ciBlbWFpbCEiO3M6MTU6InJlZ190eHRfc3VjY2VzcyI7czoyNzoiVGhhbmsgeW91IGZvciByZWdpc3RyYXRpb24hIjtzOjIxOiJyZWdfdHh0X2ludmFsaWRfZW1haWwiO3M6MjI6IkVtcHR5IG9yIGludmFsaWQgZW1haWwiO3M6MTY6InJlZ19yZWRpcmVjdF91cmwiO3M6MDoiIjtzOjI4OiJyZWdfdHh0X2NvbmZpcm1fbWFpbF9zdWJqZWN0IjtzOjM0OiJDb25maXJtIHJlZ2lzdHJhdGlvbiBvbiBbc2l0ZW5hbWVdIjtzOjI1OiJyZWdfdHh0X2NvbmZpcm1fbWFpbF9mcm9tIjtzOjE0OiJhZG1pbkBtYWlsLmNvbSI7czoyODoicmVnX3R4dF9jb25maXJtX21haWxfbWVzc2FnZSI7czoxOTY6IllvdSByZWdpc3RlcmVkIG9uIHNpdGUgPGEgaHJlZj1cIltzaXRldXJsXVwiPltzaXRlbmFtZV08L2E+LiBGb2xsb3cgPGEgaHJlZj1cIltjb25maXJtX2xpbmtdXCI+dGhpcyBsaW5rPC9hPiB0byBjb21wbGV0ZSB5b3VyIHJlZ2lzdHJhdGlvbi4gSWYgeW91IGRpZCBub3QgcmVnaXN0ZXIgaGVyZSAtIGp1c3QgaWdub3JlIHRoaXMgbWVzc2FnZS4iO3M6MzE6InJlZ190eHRfc3Vic2NyaWJlcl9tYWlsX3N1YmplY3QiO3M6Mzc6IltzaXRlbmFtZV0gWW91ciB1c2VybmFtZSBhbmQgcGFzc3dvcmQiO3M6Mjg6InJlZ190eHRfc3Vic2NyaWJlcl9tYWlsX2Zyb20iO3M6MTQ6ImFkbWluQG1haWwuY29tIjtzOjMxOiJyZWdfdHh0X3N1YnNjcmliZXJfbWFpbF9tZXNzYWdlIjtzOjY1OiJVc2VybmFtZTogW3VzZXJfbG9naW5dPGJyIC8+UGFzc3dvcmQ6IFtwYXNzd29yZF08YnIgLz5bbG9naW5fdXJsXSI7czoxMzoicmVnX25ld19lbWFpbCI7czoxNDoiYWRtaW5AbWFpbC5jb20iO3M6MTU6InJlZ19uZXdfbWVzc2FnZSI7czoxMjE6IllvdSBoYXZlIG5ldyBtZW1iZXIgb24geW91ciBzaXRlIDxhIGhyZWY9XCJbc2l0ZXVybF1cIj5bc2l0ZW5hbWVdPC9hPiwgaGVyZSB1cyBtZW1iZXIgaW5mb3JtYXRpb246PGJyIC8+W3N1YnNjcmliZXJfZGF0YV0iO3M6NToidHh0XzAiO3M6MzM6IjxwPltnb29nbGVfbWFwX2Vhc3kgaWQ9XCIxXCJdPC9wPiI7czo1OiJ0eHRfMSI7czo1OToiPHA+W2NvbnRhY3QtZm9ybS03IGlkPVwiMjA4XCIgdGl0bGU9XCJDb250YWN0IGZvcm0gMVwiXTwvcD4iO31zOjEwOiJvcHRzX2F0dHJzIjthOjI6e3M6OToiYmdfbnVtYmVyIjtzOjE6IjIiO3M6MTY6InR4dF9ibG9ja19udW1iZXIiO3M6MToiMiI7fX0=","<div id=\"ppsPopupShell_[ID]\" class=\"ppsPopupShell ppsPopupListsShell\">\r\n	<a href=\"#\" class=\"ppsPopupClose ppsPopupClose_[close_btn]\"></a>\r\n	<div class=\"ppsInnerTblContent\">\r\n		[if enb_txt_0]\r\n			[txt_0]\r\n		[endif]\r\n		<div class=\"right ppsSubscribeShell\">\r\n			[if enb_subscribe]\r\n				[sub_form_start]\r\n				[sub_fields_html]\r\n				<input type=\"submit\" name=\"submit\" value=\"[sub_btn_label]\" />\r\n				[sub_form_end]\r\n			[endif]\r\n			[if enb_txt_1]\r\n				<div class=\"another-contact-form\">\r\n				[txt_1]\r\n				</div>\r\n			[endif]\r\n		</div>\r\n	</div>\r\n</div>","#ppsPopupShell_[ID] {\r\n	width: [width][width_measure];\r\n  	padding: 15px;\r\n  	font-family: Georgia, Times, serif;\r\n	font-size: 13px;\r\n	line-height: 21px;\r\n	font-weight: normal;\r\n	color: #000;\r\n}\r\n#ppsPopupShell_[ID] .ppsInnerTblContent {\r\n	position:relative;\r\n}\r\n#ppsPopupShell_[ID] .right{\r\n	position: absolute;\r\n    bottom: 15px;\r\n    right: 15px;\r\n}\r\n#ppsPopupShell_[ID] .another-contact-form{\r\n    background-color: rgba(0, 0, 0, 0.5);\r\n    width: 100%;\r\n    padding: 10px;\r\n    box-sizing: border-box;\r\n}\r\n#ppsPopupShell_[ID] p {\r\n    margin: 0 0 5px;\r\n}\r\n#ppsPopupShell_[ID] .wpcf7-form .col-sm-8{\r\n	text-align:center;\r\n}\r\n#ppsPopupShell_[ID] .wpcf7-form label{\r\n  text-shadow: 1px 1px 2px white, 0 0 1em white;\r\n}\r\n#ppsPopupShell_[ID] .wpcf7-form  div.wpcf7-validation-errors {\r\n    border: 2px solid #F70000;\r\n    background-color: rgba(255, 254, 254, 0.5);\r\n}\r\n#ppsPopupShell_[ID] .ppsPopupClose {\r\n	background-repeat: no-repeat;\r\n  	cursor: pointer;\r\n    top: -5px !important;\r\n    right: -5px !important;\r\n    z-index: 666;\r\n}\r\n#ppsPopupShell_[ID] .ppsPopupClose.ppsPopupClose_lists_black {\r\n 	top: 0 !important;\r\n  	right: 0 !important;\r\n}\r\n#ppsPopupShell_[ID] .ppsPopupClose:hover {\r\n	opacity: 0.8;\r\n}\r\n#ppsPopupShell_[ID] .ppsErrorMsg,\r\n#ppsPopupShell_[ID] .ppsSuccessMsg {\r\n	background-color: #333;\r\n  	padding: 5px 10px;\r\n  	border-radius: 3px;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell input,\r\n#ppsPopupShell_[ID] .ppsSubscribeShell .ppsSubSelect,\r\n#ppsPopupShell_[ID] .ppsSubscribeShell textarea {\r\n  	margin-right: 5px;\r\n  	height: 40px;\r\n  	border: 1px solid #d1b36d;\r\n  	width: auto;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell input[type=text],#ppsPopupShell_[ID] .ppsSubscribeShell input[type=email],#ppsPopupShell_[ID] .ppsSubscribeShell input[type=password],#ppsPopupShell_[ID] .ppsSubscribeShell input[type=email],\r\n#ppsPopupShell_[ID] .ppsSubscribeShell .ppsSubSelect,\r\n#ppsPopupShell_[ID] .ppsSubscribeShell textarea {\r\n	box-shadow: 2px 2px 2px #dcdcdc inset;\r\n  	padding-left: 10px;\r\n  	font-size: 17px;\r\n  	background-color: #fff;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell .ppsSubSelect {\r\n	display: table;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell .ppsSubSelectLabel,\r\n#ppsPopupShell_[ID] .ppsSubscribeShell select {\r\n	display: table-cell;\r\n  	\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell .ppsSubSelectLabel {\r\n	opacity: 0.5;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell select {\r\n  	background-color: transparent;\r\n  	height: 40px;\r\n  	border: none;\r\n  	margin-left: -5px;\r\n  	font-size: 17px;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell textarea {\r\n	font-family: inherit;\r\n  	height: auto;\r\n    padding-top: 5px;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell input[type=submit] {\r\n  	[if bg_type_1 == \'color\']\r\n  	background-color: [bg_color_1];\r\n  	background-image: none;\r\n  	[elseif bg_type_1 == \'img\']\r\n  	background-image: url(\"[bg_img_1]\");\r\n  	background-repeat: no-repeat;\r\n  	background-size: cover;\r\n  	[endif]\r\n  	color: #fff;\r\n    font-size: 20px;\r\n    text-shadow: 2px 2px 2px #000;\r\n  	cursor: pointer;\r\n  	line-height: 1px;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell input[type=submit]:hover {\r\n	box-shadow: inset 1px 1px 3px #666;\r\n}","mapstyle.png","1","1","1","1","2015-01-10 18:59:43","27"),
("32","Simple iFrame","1","0","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","<div id=\"ppsPopupShell_[ID]\" class=\"ppsPopupShell ppsPopupListsShell\">\r\n	<a href=\"#\" class=\"ppsPopupClose ppsPopupClose_[close_btn]\"></a>\r\n	<iframe class=\"ppsMainFrame\" src=\"[iframe_url]\"></iframe>\r\n</div>","#ppsPopupShell_[ID] {\r\n	width: [width][width_measure];\r\n  	height: [height][height_measure];\r\n}\r\n#ppsPopupShell_[ID], #ppsPopupShell_[ID] * {\r\n	-webkit-box-sizing: content-box;\r\n	-moz-box-sizing:    content-box;\r\n	box-sizing:         content-box;\r\n}\r\n#ppsPopupShell_[ID] .ppsMainFrame {\r\n  	width: 100%;\r\n  	height: 100%;\r\n  	border: 8px solid [bg_color_0];\r\n  	border-radius: 5px;\r\n  	padding: 0;\r\n  	margin: 0;\r\n}\r\n#ppsPopupShell_[ID] .ppsPopupClose {\r\n	background-repeat: no-repeat;\r\n  	cursor: pointer;\r\n  	top: 15px;\r\n  	right: 10px;\r\n}\r\n#ppsPopupShell_[ID] .ppsPopupClose:hover {\r\n	opacity: 0.8;\r\n}","simple-iframe.jpg","1","1","1","4","2015-01-10 18:59:43","30"),
("33","Simple HTML","1","0","YTozOntzOjQ6Im1haW4iO2E6MTk6e3M6Nzoic2hvd19vbiI7czo5OiJwYWdlX2xvYWQiO3M6MjM6InNob3dfb25fcGFnZV9sb2FkX2RlbGF5IjtzOjA6IiI7czoyNzoic2hvd19vbl9zY3JvbGxfd2luZG93X2RlbGF5IjtzOjE6IjAiO3M6MzM6InNob3dfb25fc2Nyb2xsX3dpbmRvd19wZXJjX3Njcm9sbCI7czoxOiIwIjtzOjI4OiJzaG93X29uX2FmdGVyX2luYWN0aXZlX3ZhbHVlIjtzOjI6IjEwIjtzOjg6ImNsb3NlX29uIjtzOjEwOiJ1c2VyX2Nsb3NlIjtzOjI1OiJjbG9zZV9vbl9hZnRlcl90aW1lX3ZhbHVlIjtzOjE6IjUiO3M6MTA6InNob3dfcGFnZXMiO3M6MzoiYWxsIjtzOjE0OiJzaG93X3RpbWVfZnJvbSI7czo3OiIxMjowMGFtIjtzOjEyOiJzaG93X3RpbWVfdG8iO3M6NzoiMTI6MDBhbSI7czo3OiJzaG93X3RvIjtzOjg6ImV2ZXJ5b25lIjtzOjI5OiJzaG93X3RvX2ZpcnN0X3RpbWVfdmlzaXRfZGF5cyI7czoyOiIzMCI7czozMDoic2hvd190b191bnRpbF9tYWtlX2FjdGlvbl9kYXlzIjtzOjI6IjMwIjtzOjIxOiJoaWRlX2Zvcl9kZXZpY2VzX3Nob3ciO3M6MToiMCI7czoyNDoiaGlkZV9mb3JfcG9zdF90eXBlc19zaG93IjtzOjE6IjAiO3M6MTc6ImhpZGVfZm9yX2lwc19zaG93IjtzOjE6IjAiO3M6MTI6ImhpZGVfZm9yX2lwcyI7czowOiIiO3M6MjM6ImhpZGVfZm9yX2NvdW50cmllc19zaG93IjtzOjE6IjAiO3M6MjM6ImhpZGVfZm9yX2xhbmd1YWdlc19zaG93IjtzOjE6IjAiO31zOjM6InRwbCI7YTozMjp7czo1OiJ3aWR0aCI7czozOiI0MDAiO3M6MTM6IndpZHRoX21lYXN1cmUiO3M6MjoicHgiO3M6MTg6ImJnX292ZXJsYXlfb3BhY2l0eSI7czozOiIwLjUiO3M6OToiYmdfdHlwZV8wIjtzOjU6ImNvbG9yIjtzOjg6ImJnX2ltZ18wIjtzOjA6IiI7czoxMDoiYmdfY29sb3JfMCI7czo3OiIjZmZmZmZmIjtzOjk6ImJnX3R5cGVfMSI7czo1OiJjb2xvciI7czo4OiJiZ19pbWdfMSI7czowOiIiO3M6MTA6ImJnX2NvbG9yXzEiO3M6NzoiIzAwNmRjMSI7czo5OiJjbG9zZV9idG4iO3M6OToic3FyX2Nsb3NlIjtzOjExOiJsYXllcmVkX3BvcyI7czozOiJ0b3AiO3M6OToiZW5iX3R4dF8wIjtzOjE6IjEiO3M6ODoiYW5pbV9rZXkiO3M6ODoic2xpZGVfdXAiO3M6MTM6ImFuaW1fZHVyYXRpb24iO3M6NDoiMTAwMCI7czoxODoibG9naW5fcmVkaXJlY3RfdXJsIjtzOjA6IiI7czoxNToibG9naW5fYnRuX2xhYmVsIjtzOjA6IiI7czoxNjoicmVnX3JlZGlyZWN0X3VybCI7czowOiIiO3M6MjM6InJlZ193cF9jcmVhdGVfdXNlcl9yb2xlIjtzOjEwOiJzdWJzY3JpYmVyIjtzOjEzOiJyZWdfYnRuX2xhYmVsIjtzOjA6IiI7czoxMDoicmVnX2ZpZWxkcyI7YToyOntzOjQ6Im5hbWUiO2E6Nzp7czozOiJlbmIiO3M6MToiMSI7czo0OiJuYW1lIjtzOjQ6Im5hbWUiO3M6NDoiaHRtbCI7czo0OiJ0ZXh0IjtzOjU6ImxhYmVsIjtzOjQ6Ik5hbWUiO3M6NToidmFsdWUiO3M6MDoiIjtzOjY6ImN1c3RvbSI7czoxOiIwIjtzOjk6Im1hbmRhdG9yeSI7czoxOiIwIjt9czo1OiJlbWFpbCI7YTo3OntzOjQ6Im5hbWUiO3M6NToiZW1haWwiO3M6NDoiaHRtbCI7czo0OiJ0ZXh0IjtzOjU6ImxhYmVsIjtzOjY6IkUtTWFpbCI7czo1OiJ2YWx1ZSI7czowOiIiO3M6NjoiY3VzdG9tIjtzOjE6IjAiO3M6OToibWFuZGF0b3J5IjtzOjE6IjEiO3M6MzoiZW5iIjtzOjE6IjEiO319czoyMDoicmVnX3R4dF9jb25maXJtX3NlbnQiO3M6Njc6IkNvbmZpcm1hdGlvbiBsaW5rIHdhcyBzZW50IHRvIHlvdXIgZW1haWwgYWRkcmVzcy4gQ2hlY2sgeW91ciBlbWFpbCEiO3M6MTU6InJlZ190eHRfc3VjY2VzcyI7czoyNzoiVGhhbmsgeW91IGZvciByZWdpc3RyYXRpb24hIjtzOjIxOiJyZWdfdHh0X2ludmFsaWRfZW1haWwiO3M6MjI6IkVtcHR5IG9yIGludmFsaWQgZW1haWwiO3M6Mjg6InJlZ190eHRfY29uZmlybV9tYWlsX3N1YmplY3QiO3M6MzQ6IkNvbmZpcm0gcmVnaXN0cmF0aW9uIG9uIFtzaXRlbmFtZV0iO3M6MjU6InJlZ190eHRfY29uZmlybV9tYWlsX2Zyb20iO3M6MTQ6ImFkbWluQG1haWwuY29tIjtzOjI4OiJyZWdfdHh0X2NvbmZpcm1fbWFpbF9tZXNzYWdlIjtzOjE5NjoiWW91IHJlZ2lzdGVyZWQgb24gc2l0ZSA8YSBocmVmPVwiW3NpdGV1cmxdXCI+W3NpdGVuYW1lXTwvYT4uIEZvbGxvdyA8YSBocmVmPVwiW2NvbmZpcm1fbGlua11cIj50aGlzIGxpbms8L2E+IHRvIGNvbXBsZXRlIHlvdXIgcmVnaXN0cmF0aW9uLiBJZiB5b3UgZGlkIG5vdCByZWdpc3RlciBoZXJlIC0ganVzdCBpZ25vcmUgdGhpcyBtZXNzYWdlLiI7czozMToicmVnX3R4dF9zdWJzY3JpYmVyX21haWxfc3ViamVjdCI7czozNzoiW3NpdGVuYW1lXSBZb3VyIHVzZXJuYW1lIGFuZCBwYXNzd29yZCI7czoyODoicmVnX3R4dF9zdWJzY3JpYmVyX21haWxfZnJvbSI7czoxNDoiYWRtaW5AbWFpbC5jb20iO3M6MzE6InJlZ190eHRfc3Vic2NyaWJlcl9tYWlsX21lc3NhZ2UiO3M6NjU6IlVzZXJuYW1lOiBbdXNlcl9sb2dpbl08YnIgLz5QYXNzd29yZDogW3Bhc3N3b3JkXTxiciAvPltsb2dpbl91cmxdIjtzOjEzOiJyZWdfbmV3X2VtYWlsIjtzOjE0OiJhZG1pbkBtYWlsLmNvbSI7czoxNToicmVnX25ld19tZXNzYWdlIjtzOjEyMToiWW91IGhhdmUgbmV3IG1lbWJlciBvbiB5b3VyIHNpdGUgPGEgaHJlZj1cIltzaXRldXJsXVwiPltzaXRlbmFtZV08L2E+LCBoZXJlIHVzIG1lbWJlciBpbmZvcm1hdGlvbjo8YnIgLz5bc3Vic2NyaWJlcl9kYXRhXSI7czo1OiJ0eHRfMCI7czo4NDI6IjxwIHN0eWxlPVwidGV4dC1hbGlnbjogbGVmdDtcIj48YSBocmVmPVwiW1BQU19BU1NFVFNfVVJMXWltZy9hc3NldHMvYmVhdXRpZnVsLWJsb25kZS1mbG93ZXItZmxvd2Vycy1naXJsLUZhdmltLmNvbS0xNDM2MzUtMTUweDE1MC5qcGdcIj48aW1nIGNsYXNzPVwid3AtaW1hZ2UtMTcgc2l6ZS10aHVtYm5haWwgYWxpZ25sZWZ0XCIgc3JjPVwiW1BQU19BU1NFVFNfVVJMXWltZy9hc3NldHMvYmVhdXRpZnVsLWJsb25kZS1mbG93ZXItZmxvd2Vycy1naXJsLUZhdmltLmNvbS0xNDM2MzUtMTUweDE1MC5qcGdcIiBhbHQ9XCJcIiB3aWR0aD1cIjE3NlwiIGhlaWdodD1cIjE3NlwiIC8+PC9hPkxvcmVtIGlwc3VtIGRvbG9yIHNpdCBhbWV0LCBjb25zZWN0ZXR1ciBhZGlwaXNjaW5nIGVsaXQsIHNlZCBkbyBlaXVzbW9kIHRlbXBvciBpbmNpZGlkdW50IHV0IGxhYm9yZSBldCBkb2xvcmUgbWFnbmEgYWxpcXVhLjwvcD48cCBzdHlsZT1cInRleHQtYWxpZ246IGxlZnQ7XCI+PHN0cm9uZz5VdCBlbmltIGFkIG1pbmltIHZlbmlhbTwvc3Ryb25nPiwgcXVpcyBub3N0cnVkIGV4ZXJjaXRhdGlvbiB1bGxhbWNvIGxhYm9yaXMgbmlzaSB1dCBhbGlxdWlwIGV4IGVhIGNvbW1vZG8gY29uc2VxdWF0LiA8ZW0+RHVpcyBhdXRlIGlydXJlIGRvbG9yIGluIHJlcHJlaGVuZGVyaXQgaW4gdm9sdXB0YXRlIHZlbGl0IGVzc2UgY2lsbHVtIGRvbG9yZSBldSBmdWdpYXQgbnVsbGEgcGFyaWF0dXIuPC9lbT4gRXhjZXB0ZXVyIHNpbnQgb2NjYWVjYXQgY3VwaWRhdGF0IG5vbiBwcm9pZGVudCwgc3VudCBpbiBjdWxwYSBxdWkgb2ZmaWNpYSBkZXNlcnVudCBtb2xsaXQgYW5pbSBpZCBlc3QgbGFib3J1bS48L3A+Ijt9czoxMDoib3B0c19hdHRycyI7YToyOntzOjk6ImJnX251bWJlciI7czoxOiIyIjtzOjE2OiJ0eHRfYmxvY2tfbnVtYmVyIjtzOjE6IjEiO319","<div id=\"ppsPopupShell_[ID]\" class=\"ppsPopupShell ppsPopupListsShell\">\r\n	<a href=\"#\" class=\"ppsPopupClose ppsPopupClose_[close_btn]\"></a>\r\n	<div class=\"ppsInnerTblContent\">\r\n		[txt_0]\r\n	</div>\r\n</div>","#ppsPopupShell_[ID] {\r\n	width: [width][width_measure];\r\n  	padding: 15px;\r\n  	font-family: \'Helvetica\', arial;\r\n	font-size: 14px;\r\n	line-height: 21px;\r\n	font-weight: normal;\r\n	color: #000;\r\n}\r\n#ppsPopupShell_[ID], #ppsPopupShell_[ID] * {\r\n	-webkit-box-sizing: content-box;\r\n	-moz-box-sizing:    content-box;\r\n	box-sizing:         content-box;\r\n}\r\n#ppsPopupShell_[ID] p {\r\n	margin: 14px 0;\r\n}\r\n#ppsPopupShell_[ID] .ppsInnerTblContent {\r\n	height: 100%;\r\n  	[if bg_type_1 == \'color\']\r\n  	border: 8px solid [bg_color_1];\r\n  	[endif]\r\n  	border-radius: 5px;\r\n  	padding: 10px;\r\n  	[if bg_type_0 == \'color\']\r\n  	background-color: [bg_color_0];\r\n  	[elseif bg_type_0 == \'img\']\r\n  	background-image: url(\"[bg_img_0]\");\r\n  	background-repeat: no-repeat;\r\n  	background-size: cover;\r\n  	[endif]\r\n}","simple-html.jpg","1","1","1","5","2015-01-10 18:59:43","31"),
("34","HTML 2 Columns","1","0","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","<div id=\"ppsPopupShell_[ID]\" class=\"ppsPopupShell ppsPopupListsShell\">\r\n	<a href=\"#\" class=\"ppsPopupClose ppsPopupClose_[close_btn]\"></a>\r\n	<div class=\"ppsInnerTblContent\">\r\n      	[if enb_txt_0]\r\n      	<div class=\"ppsCol\">[txt_0]</div>\r\n      	[endif]\r\n      	[if enb_txt_1]\r\n      	<div class=\"ppsCol\">[txt_1]</div>\r\n      	[endif]\r\n      	<div style=\"clear: both;\"></div	>\r\n	</div>\r\n</div>","#ppsPopupShell_[ID] {\r\n	width: [width][width_measure];\r\n  	padding: 15px;\r\n  	font-family: \'Helvetica\', arial;\r\n	font-size: 14px;\r\n	line-height: 21px;\r\n	font-weight: normal;\r\n	color: #fff;\r\n}\r\n#ppsPopupShell_[ID], #ppsPopupShell_[ID] * {\r\n	-webkit-box-sizing: border-box;\r\n	-moz-box-sizing:    border-box;\r\n	box-sizing:         border-box;\r\n}\r\n#ppsPopupShell_[ID] .ppsInnerTblContent {\r\n	height: 100%;\r\n  	[if bg_type_1 == \'color\']\r\n  	border: 8px solid [bg_color_1];\r\n  	[endif]\r\n  	border-radius: 5px;\r\n  	padding: 10px;\r\n  	[if bg_type_0 == \'color\']\r\n  	background-color: [bg_color_0];\r\n  	[elseif bg_type_0 == \'img\']\r\n  	background-image: url(\"[bg_img_0]\");\r\n  	background-repeat: no-repeat;\r\n  	background-size: cover;\r\n  	[endif]\r\n}\r\n#ppsPopupShell_[ID] .ppsCol {\r\n	float: left;\r\n  	margin: 0;\r\n  	padding: 5px;\r\n}\r\n#ppsPopupShell_[ID] .ppsCol img {\r\n	width: 100% !important;\r\n  	height: auto !important;\r\n}\r\n{% if [enb_txt_0] and [enb_txt_1] %}\r\n#ppsPopupShell_[ID] .ppsCol {\r\n	width: 50%;\r\n}\r\n{% endif %}\r\n\r\n","html-2-columns.jpg","1","1","1","5","2015-01-10 18:59:43","32"),
("35","PDF PopUp","1","0","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","<div id=\"ppsPopupShell_[ID]\" class=\"ppsPopupShell ppsPopupListsShell\">\r\n	<a href=\"#\" class=\"ppsPopupClose ppsPopupClose_[close_btn]\"></a>\r\n	<iframe class=\"ppsMainFrame\" src=\"https://docs.google.com/gview?url=[pdf_url]&embedded=true\"></iframe>\r\n</div>","#ppsPopupShell_[ID] {\r\n	width: [width][width_measure];\r\n  	height: [height][height_measure];\r\n  	[if bg_type_0 == \'color\']\r\n	background-color: [bg_color_0];\r\n  	[elseif bg_type_0 == \'img\']\r\n  	background-image: url(\"[bg_img_0]\");\r\n  	background-repeat: no-repeat;\r\n  	background-size: cover;\r\n  	[endif]\r\n}\r\n#ppsPopupShell_[ID], #ppsPopupShell_[ID] * {\r\n	-webkit-box-sizing: content-box;\r\n	-moz-box-sizing:    content-box;\r\n	box-sizing:         content-box;\r\n}\r\n#ppsPopupShell_[ID] .ppsMainFrame {\r\n  	width: 100%;\r\n  	height: 100%;\r\n  	[if enb_bg_0]\r\n  	border: 8px solid [bg_color_0];\r\n  	[endif]\r\n  	border-radius: 5px;\r\n  	padding: 0;\r\n  	margin: 0;\r\n}\r\n#ppsPopupShell_[ID] .ppsPopupClose {\r\n	background-repeat: no-repeat;\r\n  	cursor: pointer;\r\n  	top: 15px;\r\n  	right: 10px;\r\n}\r\n#ppsPopupShell_[ID] .ppsPopupClose:hover {\r\n	opacity: 0.8;\r\n}","pdf-popup.jpg","1","1","1","6","2015-01-10 18:59:43","33"),
("38","Clear PopUp","1","0","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","<div id=\"ppsPopupShell_[ID]\" class=\"ppsPopupShell ppsPopupListsShell\">\r\n	<a href=\"#\" class=\"ppsPopupClose ppsPopupClose_[close_btn]\"></a>\r\n	<div class=\"ppsInnerTblContent\">\r\n		[if enb_label]\r\n			<div class=\"ppsPopupLabel\">[label]</div>\r\n		[endif]\r\n		[if enb_txt_0]\r\n			<div class=\"ppsPopupTxt ppsPopupTxt_0\">[txt_0]</div>\r\n		[endif]\r\n		[if enb_btn_0]\r\n      		<a class=\"ppsBtn ppsBtn_0[if is_close_btn_0] ppsPopupClose[endif]\" href=\"[btn_url_0]\">[btn_txt_0]</a>\r\n      	[endif]\r\n	</div>\r\n</div>","#ppsPopupShell_[ID] {\r\n	width: [width][width_measure];\r\n  	padding: 15px;\r\n  	font-family: \"Open Sans\",arial;\r\n	font-size: 16px;\r\n	line-height: 1.475;\r\n	font-weight: normal;\r\n	color: #fff;\r\n  	text-shadow: 1px 1px 1px #000000;\r\n  	text-align: center;\r\n}\r\n#ppsPopupShell_[ID], #ppsPopupShell_[ID] * {\r\n	-webkit-box-sizing: content-box;\r\n	-moz-box-sizing:    content-box;\r\n	box-sizing:         content-box;\r\n}\r\n#ppsPopupShell_[ID] .ppsInnerTblContent {\r\n	background-color: transparent;\r\n}\r\n#ppsPopupShell_[ID] .ppsPopupLabel {\r\n	font-size: 32px;\r\n}\r\n#ppsPopupShell_[ID] .ppsPopupClose {\r\n	background-repeat: no-repeat;\r\n  	cursor: pointer;\r\n}\r\n#ppsPopupShell_[ID] .ppsPopupClose:hover {\r\n	opacity: 0.8;\r\n}\r\n#ppsPopupShell_[ID] .ppsBtn {\r\n  	display: inline;\r\n  	margin: 0;\r\n  	padding: 5px 20px;\r\n  	border-radius: 5px;\r\n  	transition-duration: 0.3s;\r\n  	text-decoration: none !important;\r\n  	color: #fff;\r\n  	font-size: 24px;\r\n  	border: 1px solid #000;\r\n  	color: #000;\r\n  	[if bg_type_0 == \'color\']\r\n	background:  [bg_color_0]; /* Old browsers */\r\nbackground: -moz-linear-gradient(top,   {{ adjust_brightness(popup.params.tpl.bg_color_0, 50) }} 0%, [bg_color_0] 100%); /* FF3.6-15 */\r\nbackground: -webkit-linear-gradient(top,   {{ adjust_brightness(popup.params.tpl.bg_color_0, 50) }} 0%,[bg_color_0] 100%); /* Chrome10-25,Safari5.1-6 */\r\nbackground: linear-gradient(to bottom,   {{ adjust_brightness(popup.params.tpl.bg_color_0, 50) }} 0%,[bg_color_0] 100%); /* W3C, IE10+, FF16+, Chrome26+, Opera12+, Safari7+ */\r\nfilter: progid:DXImageTransform.Microsoft.gradient( startColorstr=\' {{ adjust_brightness(popup.params.tpl.bg_color_0, 50) }}\', endColorstr=\'[bg_color_0]\',GradientType=0 ); /* IE6-9 */\r\n  	[elseif bg_type_0 == \'img\']\r\n  	background-image: url(\"[bg_img_0]\");\r\n  	background-repeat: no-repeat;\r\n  	background-size: cover;\r\n  	[endif]\r\n}\r\n#ppsPopupShell_[ID] .ppsBtn:hover,\r\n#ppsPopupShell_[ID] .ppsBtn:active {\r\n	[if bg_type_0 == \'color\']\r\n	/* Permalink - use to edit and share this gradient: http://colorzilla.com/gradient-editor/ [bg_color_0]+0,7db9e8+100 */\r\nbackground:  {{ adjust_brightness(popup.params.tpl.bg_color_0, -50) }}; /* Old browsers */\r\nbackground: -moz-linear-gradient(top,   [bg_color_0] 0%, {{ adjust_brightness(popup.params.tpl.bg_color_0, -50) }} 100%); /* FF3.6-15 */\r\nbackground: -webkit-linear-gradient(top,   [bg_color_0] 0%,{{ adjust_brightness(popup.params.tpl.bg_color_0, -50) }} 100%); /* Chrome10-25,Safari5.1-6 */\r\nbackground: linear-gradient(to bottom,   [bg_color_0] 0%,{{ adjust_brightness(popup.params.tpl.bg_color_0, -50) }} 100%); /* W3C, IE10+, FF16+, Chrome26+, Opera12+, Safari7+ */\r\nfilter: progid:DXImageTransform.Microsoft.gradient( startColorstr=\' [bg_color_0]\', endColorstr=\'{{ adjust_brightness(popup.params.tpl.bg_color_0, -50) }}\',GradientType=0 ); /* IE6-9 */\r\n  	[elseif bg_type_0 == \'img\']\r\n  	box-shadow: 1px 2px 1px #333;\r\n  	[endif]\r\n}\r\n#ppsPopupShell_[ID] .ppsPopupClose {\r\n	display: inline !important;\r\n}","clear-popup.jpg","1","1","1","8","2015-01-10 18:59:43","21"),
("39","Video List Flat","1","0","YTozOntzOjQ6Im1haW4iO2E6Mjc6e3M6Nzoic2hvd19vbiI7czo5OiJwYWdlX2xvYWQiO3M6MjM6InNob3dfb25fcGFnZV9sb2FkX2RlbGF5IjtzOjA6IiI7czoyNToic2hvd19vbl9jbGlja19vbl9lbF9kZWxheSI7czoxOiIwIjtzOjI3OiJzaG93X29uX3Njcm9sbF93aW5kb3dfZGVsYXkiO3M6MToiMCI7czozMzoic2hvd19vbl9zY3JvbGxfd2luZG93X3BlcmNfc2Nyb2xsIjtzOjE6IjAiO3M6MjU6InNob3dfb25fbGlua19mb2xsb3dfZGVsYXkiO3M6MToiMCI7czo4OiJjbG9zZV9vbiI7czoxMDoidXNlcl9jbG9zZSI7czoxMDoic2hvd19wYWdlcyI7czozOiJhbGwiO3M6MTQ6InNob3dfdGltZV9mcm9tIjtzOjc6IjEyOjAwYW0iO3M6MTI6InNob3dfdGltZV90byI7czo3OiIxMjowMGFtIjtzOjE0OiJzaG93X2RhdGVfZnJvbSI7czowOiIiO3M6MTI6InNob3dfZGF0ZV90byI7czowOiIiO3M6Nzoic2hvd190byI7czo4OiJldmVyeW9uZSI7czoyOToic2hvd190b19maXJzdF90aW1lX3Zpc2l0X2RheXMiO3M6MjoiMzAiO3M6MzA6InNob3dfdG9fdW50aWxfbWFrZV9hY3Rpb25fZGF5cyI7czoyOiIzMCI7czoxNToiY291bnRfdGltZXNfbnVtIjtzOjE6IjEiO3M6MTU6ImNvdW50X3RpbWVzX21lcyI7czozOiJkYXkiO3M6MjE6ImhpZGVfZm9yX2RldmljZXNfc2hvdyI7czoxOiIwIjtzOjI0OiJoaWRlX2Zvcl9wb3N0X3R5cGVzX3Nob3ciO3M6MToiMCI7czoxNzoiaGlkZV9mb3JfaXBzX3Nob3ciO3M6MToiMCI7czoxMjoiaGlkZV9mb3JfaXBzIjtzOjA6IiI7czoyMzoiaGlkZV9mb3JfY291bnRyaWVzX3Nob3ciO3M6MToiMCI7czoyMzoiaGlkZV9mb3JfbGFuZ3VhZ2VzX3Nob3ciO3M6MToiMCI7czoyNDoiaGlkZV9zZWFyY2hfZW5naW5lc19zaG93IjtzOjE6IjAiO3M6MTg6ImhpZGVfcHJlZ191cmxfc2hvdyI7czoxOiIwIjtzOjEzOiJoaWRlX3ByZWdfdXJsIjtzOjA6IiI7czoyNDoiaGlkZV9mb3JfdXNlcl9yb2xlc19zaG93IjtzOjE6IjAiO31zOjM6InRwbCI7YTo1Njp7czo5OiJ2aWRlb191cmwiO3M6NDM6Imh0dHBzOi8vd3d3LnlvdXR1YmUuY29tL3dhdGNoP3Y9bktJdTl5ZW41bmMiO3M6NToid2lkdGgiO3M6MzoiODI0IjtzOjEzOiJ3aWR0aF9tZWFzdXJlIjtzOjI6InB4IjtzOjY6ImhlaWdodCI7czozOiI0MDAiO3M6MTQ6ImhlaWdodF9tZWFzdXJlIjtzOjI6InB4IjtzOjE4OiJiZ19vdmVybGF5X29wYWNpdHkiO3M6MzoiMC41IjtzOjk6ImJnX3R5cGVfMCI7czo1OiJjb2xvciI7czo4OiJiZ19pbWdfMCI7czowOiIiO3M6MTA6ImJnX2NvbG9yXzAiO3M6NzoiI2ViZWJlYiI7czo5OiJiZ190eXBlXzEiO3M6NToiY29sb3IiO3M6ODoiYmdfaW1nXzEiO3M6MDoiIjtzOjEwOiJiZ19jb2xvcl8xIjtzOjc6IiMwNjZkYWIiO3M6OToiYmdfdHlwZV8yIjtzOjU6ImNvbG9yIjtzOjg6ImJnX2ltZ18yIjtzOjA6IiI7czoxMDoiYmdfY29sb3JfMiI7czo3OiIjMDAwNjNmIjtzOjEwOiJmb250X2xhYmVsIjtzOjc6ImRlZmF1bHQiO3M6MTY6ImxhYmVsX2ZvbnRfY29sb3IiO3M6NzoiIzAwMDAwMCI7czoxMToiZm9udF9mb290ZXIiO3M6NzoiZGVmYXVsdCI7czoxNzoiZm9vdGVyX2ZvbnRfY29sb3IiO3M6NzoiIzU4NTg1OCI7czoxNToicmVzcG9uc2l2ZV9tb2RlIjtzOjM6ImRlZiI7czoxNzoicmVpZHJlY3Rfb25fY2xvc2UiO3M6MDoiIjtzOjk6ImNsb3NlX2J0biI7czoyNzoiY2xvc2UtYmxhY2staW4td2hpdGUtY2lyY2xlIjtzOjExOiJsYXllcmVkX3BvcyI7czowOiIiO3M6NToibGFiZWwiO3M6NTk6IkNoZWNrIHZpZGVvIGFuZCA8aSBzdHlsZT1cImNvbG9yOiAjYzIyNTJmO1wiPnN1YnNjcmliZSE8L2k+IjtzOjEzOiJlbmJfZm9vdF9ub3RlIjtzOjE6IjEiO3M6OToiZm9vdF9ub3RlIjtzOjExODoiV2UgcmVzcGVjdCB5b3VyIHByaXZhY3kuIFlvdXIgaW5mb3JtYXRpb24gd2lsbCBub3QgYmUgc2hhcmVkIHdpdGggYW55IHRoaXJkIHBhcnR5IGFuZCB5b3UgY2FuIHVuc3Vic2NyaWJlIGF0IGFueSB0aW1lICI7czoxNToiZW5iX3NtX2ZhY2Vib29rIjtzOjE6IjEiO3M6MTc6ImVuYl9zbV9nb29nbGVwbHVzIjtzOjE6IjEiO3M6MTQ6ImVuYl9zbV90d2l0dGVyIjtzOjE6IjEiO3M6OToic21fZGVzaWduIjtzOjY6InNpbXBsZSI7czo4OiJhbmltX2tleSI7czo0OiJub25lIjtzOjEzOiJhbmltX2R1cmF0aW9uIjtzOjA6IiI7czoxMzoiZW5iX3N1YnNjcmliZSI7czoxOiIxIjtzOjg6InN1Yl9kZXN0IjtzOjk6IndvcmRwcmVzcyI7czoyMzoic3ViX3dwX2NyZWF0ZV91c2VyX3JvbGUiO3M6MTA6InN1YnNjcmliZXIiO3M6MTk6InN1Yl9hd2ViZXJfbGlzdG5hbWUiO3M6MDoiIjtzOjIxOiJzdWJfYXdlYmVyX2FkdHJhY2tpbmciO3M6MDoiIjtzOjIxOiJzdWJfbWFpbGNoaW1wX2FwaV9rZXkiO3M6MDoiIjtzOjI1OiJzdWJfbWFpbGNoaW1wX2dyb3Vwc19mdWxsIjtzOjA6IiI7czoxMDoic3ViX2ZpZWxkcyI7YToyOntzOjU6ImVtYWlsIjthOjc6e3M6NDoibmFtZSI7czo1OiJlbWFpbCI7czo0OiJodG1sIjtzOjQ6InRleHQiO3M6NToibGFiZWwiO3M6NjoiRS1NYWlsIjtzOjU6InZhbHVlIjtzOjA6IiI7czo2OiJjdXN0b20iO3M6MToiMCI7czo5OiJtYW5kYXRvcnkiO3M6MToiMSI7czozOiJlbmIiO3M6MToiMSI7fXM6NDoibmFtZSI7YTo3OntzOjM6ImVuYiI7czoxOiIxIjtzOjQ6Im5hbWUiO3M6NDoibmFtZSI7czo0OiJodG1sIjtzOjQ6InRleHQiO3M6NToibGFiZWwiO3M6NDoiTmFtZSI7czo1OiJ2YWx1ZSI7czowOiIiO3M6NjoiY3VzdG9tIjtzOjE6IjAiO3M6OToibWFuZGF0b3J5IjtzOjE6IjAiO319czoyMDoic3ViX3R4dF9jb25maXJtX3NlbnQiO3M6Njc6IkNvbmZpcm1hdGlvbiBsaW5rIHdhcyBzZW50IHRvIHlvdXIgZW1haWwgYWRkcmVzcy4gQ2hlY2sgeW91ciBlbWFpbCEiO3M6MTU6InN1Yl90eHRfc3VjY2VzcyI7czoyNDoiVGhhbmsgeW91IGZvciBzdWJzY3JpYmUhIjtzOjIxOiJzdWJfdHh0X2ludmFsaWRfZW1haWwiO3M6MjI6IkVtcHR5IG9yIGludmFsaWQgZW1haWwiO3M6MjA6InN1Yl90eHRfZXhpc3RzX2VtYWlsIjtzOjIyOiJFbXB0eSBvciBpbnZhbGlkIGVtYWlsIjtzOjE2OiJzdWJfcmVkaXJlY3RfdXJsIjtzOjA6IiI7czoyODoic3ViX3R4dF9jb25maXJtX21haWxfc3ViamVjdCI7czozNDoiQ29uZmlybSBzdWJzY3JpcHRpb24gb24gW3NpdGVuYW1lXSI7czoyNToic3ViX3R4dF9jb25maXJtX21haWxfZnJvbSI7czoxNDoiYWRtaW5AbWFpbC5jb20iO3M6Mjg6InN1Yl90eHRfY29uZmlybV9tYWlsX21lc3NhZ2UiO3M6MTk3OiJZb3Ugc3Vic2NyaWJlZCBvbiBzaXRlIDxhIGhyZWY9XCJbc2l0ZXVybF1cIj5bc2l0ZW5hbWVdPC9hPi4gRm9sbG93IDxhIGhyZWY9XCJbY29uZmlybV9saW5rXVwiPnRoaXMgbGluazwvYT4gdG8gY29tcGxldGUgeW91ciBzdWJzY3JpcHRpb24uIElmIHlvdSBkaWQgbm90IHN1YnNjcmliZSBoZXJlIC0ganVzdCBpZ25vcmUgdGhpcyBtZXNzYWdlLiI7czozMToic3ViX3R4dF9zdWJzY3JpYmVyX21haWxfc3ViamVjdCI7czozNzoiW3NpdGVuYW1lXSBZb3VyIHVzZXJuYW1lIGFuZCBwYXNzd29yZCI7czoyODoic3ViX3R4dF9zdWJzY3JpYmVyX21haWxfZnJvbSI7czoxNDoiYWRtaW5AbWFpbC5jb20iO3M6MzE6InN1Yl90eHRfc3Vic2NyaWJlcl9tYWlsX21lc3NhZ2UiO3M6NjU6IlVzZXJuYW1lOiBbdXNlcl9sb2dpbl08YnIgLz5QYXNzd29yZDogW3Bhc3N3b3JkXTxiciAvPltsb2dpbl91cmxdIjtzOjI1OiJzdWJfcmVkaXJlY3RfZW1haWxfZXhpc3RzIjtzOjA6IiI7czoxMzoic3ViX2J0bl9sYWJlbCI7czo4OiJTaWduLXVwISI7czoxMzoic3ViX25ld19lbWFpbCI7czoxNDoiYWRtaW5AbWFpbC5jb20iO3M6MTU6InN1Yl9uZXdfc3ViamVjdCI7czo0MDoiTmV3IFN1YnNjcmliZXIgb24gTXkgV29yZFByZXNzIFRlc3QgU2l0ZSI7czoxNToic3ViX25ld19tZXNzYWdlIjtzOjEyOToiWW91IGhhdmUgbmV3IHN1YnNjcmliZXIgb24geW91ciBzaXRlIDxhIGhyZWY9XCJbc2l0ZXVybF1cIj5bc2l0ZW5hbWVdPC9hPiwgaGVyZSBpcyBzdWJzY3JpYmVyIGluZm9ybWF0aW9uOjxiciAvPltzdWJzY3JpYmVyX2RhdGFdIjt9czoxMDoib3B0c19hdHRycyI7YTozOntzOjk6ImJnX251bWJlciI7czoxOiIzIjtzOjE2OiJ0eHRfYmxvY2tfbnVtYmVyIjtzOjE6IjAiO3M6MjE6InZpZGVvX2hlaWdodF9hc19wb3B1cCI7czoxOiIxIjt9fQ==","<div id=\"ppsPopupShell_[ID]\" class=\"ppsPopupShell ppsPopupListsShell\">\r\n	<a href=\"#\" class=\"ppsPopupClose ppsPopupClose_[close_btn]\"></a>\r\n	<div class=\"ppsInnerTblContent\">\r\n		<div class=\"ppsPopupListsInner ppsPopupInner\">\r\n			[if enb_label]\r\n				<div class=\"ppsPopupLabel ppsPopupListsLabel\">[label]</div>\r\n				<div style=\"clear: both;\"></div>\r\n			[endif]\r\n			<div class=\"ppsPopupVideo \">\r\n				[video_html]\r\n			</div>\r\n			<div style=\"clear: both;\"></div>\r\n		</div>\r\n		<div class=\"ppsRightCol\">\r\n			[if enb_subscribe]\r\n				<div class=\"ppsSubscribeShell\">\r\n					[sub_form_start]\r\n					[sub_fields_html]\r\n					<input type=\"submit\" name=\"submit\" value=\"[sub_btn_label]\" />\r\n					[sub_form_end]\r\n					<div style=\"clear: both;\"></div>\r\n				</div>\r\n			[endif]\r\n			[if enb_sm]\r\n				<div class=\"ppsSm\">\r\n				[sm_html]\r\n				</div>\r\n			[endif]\r\n			[if enb_foot_note]\r\n				<div class=\"ppsFootNote\">\r\n				[foot_note]\r\n				</div>\r\n			[endif]\r\n		</div>\r\n	</div>\r\n</div>","#ppsPopupShell_[ID] {\r\n	width: [width][width_measure];\r\n  	padding: 15px;\r\n  	font-family: Georgia, Times, serif;\r\n	font-size: 13px;\r\n	line-height: 21px;\r\n	font-weight: normal;\r\n	color: #000;\r\n}\r\n#ppsPopupShell_[ID], #ppsPopupShell_[ID] * {\r\n	-webkit-box-sizing: border-box;\r\n	-moz-box-sizing:    border-box;\r\n	box-sizing:         border-box;\r\n}\r\n#ppsPopupShell_[ID] iframe {\r\n	width: 100% !important;\r\n}\r\n#ppsPopupShell_[ID] .ppsInnerTblContent {\r\n	display: table;\r\n}\r\n#ppsPopupShell_[ID] .ppsPopupInner {\r\n  {% if popup.params.tpl.enb_subscribe or popup.params.tpl.enb_foot_note or popup.params.tpl.enb_sm %}\r\n  	width: 66%;\r\n	[else]\r\n  	width: 100%;\r\n  	[endif]\r\n  	display: table-cell;\r\n	[if bg_type_0 == \'color\']\r\n	background: -moz-radial-gradient(center, ellipse cover, {{ adjust_brightness(popup.params.tpl.bg_color_0, 50) }} 0%, [bg_color_0] 100%); /* ff3.6+ */\r\n	background: -webkit-gradient(radial, center center, 0px, center center, 100%, color-stop(0%, {{ adjust_brightness(popup.params.tpl.bg_color_0, 50) }}), color-stop(100%, [bg_color_0])); /* safari4+,chrome */\r\n	background:-webkit-radial-gradient(center, ellipse cover, {{ adjust_brightness(popup.params.tpl.bg_color_0, 50) }} 0%, [bg_color_0] 100%); /* safari5.1+,chrome10+ */\r\n	background: -o-radial-gradient(center, ellipse cover, {{ adjust_brightness(popup.params.tpl.bg_color_0, 50) }} 0%, [bg_color_0] 100%); /* opera 11.10+ */\r\n	background: -ms-radial-gradient(center, ellipse cover, {{ adjust_brightness(popup.params.tpl.bg_color_0, 50) }} 0%, [bg_color_0] 100%); /* ie10+ */\r\n	background:radial-gradient(ellipse at center, {{ adjust_brightness(popup.params.tpl.bg_color_0, 50) }} 0%, [bg_color_0] 100%); /* w3c */\r\n	filter: progid:DXImageTransform.Microsoft.gradient( startColorstr=\'{{ adjust_brightness(popup.params.tpl.bg_color_0, 50) }}\', endColorstr=\'[bg_color_0]\',GradientType=1 ); /* ie6-9 */\r\n  	[elseif bg_type_0 == \'img\']\r\n  	background-image: url(\"[bg_img_0]\");\r\n  	background-repeat: no-repeat;\r\n  	background-size: cover;\r\n  	[endif]\r\n}\r\n#ppsPopupShell_[ID] .ppsPopupLabel {\r\n	color: #000;\r\n	font-family: \"Myriad Pro\",\"Trebuchet MS\",\"Helvetica Neue\",Helvetica,Arial,Sans-Serif;\r\n	font-size: 30px;\r\n	letter-spacing: -1px;\r\n	line-height: 40px;\r\n	letter-spacing: -1px;\r\n	font-weight: bold;\r\n	margin-top: 15px;\r\n	margin-bottom: 16px;\r\n	padding-left: 20px;\r\n	text-shadow: 0px 0px 1px #000;\r\n	-moz-text-shadow: 0px 0px 1px #000;\r\n	-webkit-text-shadow: 0px 0px 1px #000;\r\n}\r\n#ppsPopupShell_[ID] .ppsRightCol {\r\n	display: table-cell;\r\n  	width: 34%;\r\n  	height: 100%;\r\n  	vertical-align: top;\r\n  	[if bg_type_1 == \'color\']\r\n  	background: -moz-radial-gradient(center, ellipse cover, {{ adjust_brightness(popup.params.tpl.bg_color_1, 50) }} 0%, [bg_color_1] 100%); /* ff3.6+ */\r\n	background: -webkit-gradient(radial, center center, 0px, center center, 100%, color-stop(0%, {{ adjust_brightness(popup.params.tpl.bg_color_1, 50) }}), color-stop(100%, [bg_color_1])); /* safari4+,chrome */\r\n	background:-webkit-radial-gradient(center, ellipse cover, {{ adjust_brightness(popup.params.tpl.bg_color_1, 50) }} 0%, [bg_color_1] 100%); /* safari5.1+,chrome10+ */\r\n	background: -o-radial-gradient(center, ellipse cover, {{ adjust_brightness(popup.params.tpl.bg_color_1, 50) }} 0%, [bg_color_1] 100%); /* opera 11.10+ */\r\n	background: -ms-radial-gradient(center, ellipse cover, {{ adjust_brightness(popup.params.tpl.bg_color_1, 50) }} 0%, [bg_color_1] 100%); /* ie10+ */\r\n  background:radial-gradient(ellipse at center, {{ adjust_brightness(popup.params.tpl.bg_color_1, 50) }} 0%, [bg_color_1] 100%); /* w3c */\r\n	filter: progid:DXImageTransform.Microsoft.gradient( startColorstr=\'{{ adjust_brightness(popup.params.tpl.bg_color_1, 50) }}\', endColorstr=\'[bg_color_1]\',GradientType=1 ); /* ie6-9 */\r\n  	[elseif bg_type_1 == \'img\']\r\n  	background-image: url(\"[bg_img_1]\");\r\n  	background-repeat: no-repeat;\r\n  	background-size: cover;\r\n  	[endif]\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell form {\r\n	padding: 30px 30px 0;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell input,\r\n#ppsPopupShell_[ID] .ppsSubscribeShell .ppsSubSelect,\r\n#ppsPopupShell_[ID] .ppsSubscribeShell textarea {\r\n	width: 100%;\r\n  	margin-bottom: 5px;\r\n  	height: 40px;\r\n  	border: none;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell input[type=text],#ppsPopupShell_[ID] .ppsSubscribeShell input[type=email],#ppsPopupShell_[ID] .ppsSubscribeShell input[type=password],#ppsPopupShell_[ID] .ppsSubscribeShell input[type=email],#ppsPopupShell_[ID] .ppsSubscribeShell input[type=password],\r\n#ppsPopupShell_[ID] .ppsSubscribeShell .ppsSubSelect,\r\n#ppsPopupShell_[ID] .ppsSubscribeShell textarea {\r\n	box-shadow: 2px 2px 2px #dcdcdc inset;\r\n  	padding-left: 10px;\r\n  	font-size: 17px;\r\n  	background-color: #fff;\r\n  	display: block;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell .ppsSubSelect {\r\n	display: table;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell .ppsSubSelectLabel,\r\n#ppsPopupShell_[ID] .ppsSubscribeShell select {\r\n	display: table-cell;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell .ppsSubSelectLabel {\r\n	opacity: 0.5;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell select {\r\n	width: 100%;\r\n  	background-color: transparent;\r\n  	height: 40px;\r\n  	border: none;\r\n  	margin-left: -5px;\r\n  	font-size: 17px;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell textarea {\r\n	font-family: inherit;\r\n  	height: auto;\r\n    padding-top: 5px;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell input[type=text],#ppsPopupShell_[ID] .ppsSubscribeShell input[type=email],#ppsPopupShell_[ID] .ppsSubscribeShell input[name=\"email\"] {\r\n	background-image: url(\"[PPS_ASSETS_URL]img/assets/mail-icon.png\");\r\n  	background-repeat: no-repeat;\r\n  	background-position: 90% center;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell input[type=submit] {\r\n  	[if bg_type_2 == \'color\']\r\n  	background-color: [bg_color_2];\r\n  	background-image: none;\r\n  	[elseif bg_type_2 == \'img\']\r\n  	background-image: url(\"[bg_img_2]\");\r\n  	background-repeat: no-repeat;\r\n  	background-size: cover;\r\n  	[endif]\r\n  	color: #fff;\r\n    font-size: 20px;\r\n    text-shadow: 2px 2px 2px #000;\r\n  	cursor: pointer;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell input[type=submit]:hover {\r\n	box-shadow: inset 1px 1px 3px #666;\r\n}\r\n#ppsPopupShell_[ID] .ppsPopupVideo {\r\n  	width: 100%;\r\n  	line-height: 0;\r\n}\r\n#ppsPopupShell_[ID] .ppsPopupClose {\r\n	background-repeat: no-repeat;\r\n  	cursor: pointer;\r\n}\r\n#ppsPopupShell_[ID] .ppsPopupClose.ppsPopupClose_lists_black {\r\n 	top: 0 !important;\r\n  	right: 0 !important;\r\n}\r\n#ppsPopupShell_[ID] .ppsPopupClose:hover {\r\n	opacity: 0.8;\r\n}\r\n#ppsPopupShell_[ID] .ppsFootNote{\r\n	color: #585858;\r\n    font-family: \"Helvetica Neue\",Helvetica,Arial,sans-serif;\r\n    font-size: x-small;\r\n    font-style: italic;\r\n    line-height: 14px;\r\n  	margin: 5px 30px;\r\n}","video-list-flat.jpg","1","1","1","3","2015-01-10 18:59:43","17"),
("40","List Building Neo","1","0","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","<link href=\"https://fonts.googleapis.com/css?family=Montserrat\" rel=\"stylesheet\"> \r\n<div id=\"ppsPopupShell_[ID]\" class=\"ppsPopupShell ppsPopupListsShell\">\r\n	<a href=\"#\" class=\"ppsPopupClose ppsPopupClose_[close_btn]\"></a>\r\n	<div class=\"ppsInnerTblContent\">\r\n		<div class=\"ppsPopupListsInner ppsPopupInner\">\r\n			[if enb_label]\r\n				<div class=\"ppsPopupLabel ppsPopupListsLabel\">[label]</div>\r\n			[endif]\r\n			<div style=\"clear: both;\"></div>\r\n			[if enb_txt_0]\r\n				<div class=\"ppsPopupTxt ppsPopupClassyTxt ppsPopupClassyTxt_0 ppsPopupTxt_0\">\r\n				[txt_0]\r\n				</div>\r\n			[endif]\r\n			<div style=\"clear: both;\"></div>\r\n		</div>\r\n		<div class=\"ppsRightCol\">\r\n			[if enb_subscribe]\r\n				<div class=\"ppsSubscribeShell\">\r\n					[sub_form_start]\r\n					[sub_fields_html]\r\n					<input type=\"submit\" name=\"submit\" value=\"[sub_btn_label]\" />\r\n					[sub_form_end]\r\n					<div style=\"clear: both;\"></div>\r\n				</div>\r\n			[endif]\r\n			[if enb_sm]\r\n				<div class=\"ppsSm\">\r\n				[sm_html]\r\n				</div>\r\n			[endif]\r\n			[if enb_foot_note]\r\n				<div class=\"ppsFootNote\">\r\n				[foot_note]\r\n				</div>\r\n			[endif]\r\n          	[if bg_type_3 == \'img\']\r\n				<img src=\"[bg_img_3]\" class=\"ppsLogo\" />\r\n			[endif]\r\n		</div>\r\n	</div>\r\n</div>","#ppsPopupShell_[ID] {\r\n	width: [width][width_measure];\r\n  	padding: 15px;\r\n  	font-family: \"Montserrat\",\"Trebuchet MS\",\"Helvetica Neue\",Helvetica,Arial,Sans-Serif;\r\n	font-size: 13px;\r\n	line-height: 21px;\r\n	font-weight: normal;\r\n	color: #4d4d4d;\r\n}\r\n#ppsPopupShell_[ID], #ppsPopupShell_[ID] * {\r\n	-webkit-box-sizing: border-box;\r\n	-moz-box-sizing:    border-box;\r\n	box-sizing:         border-box;\r\n}\r\n#ppsPopupShell_[ID] .ppsInnerTblContent {\r\n	display: table;\r\n}\r\n#ppsPopupShell_[ID] .ppsPopupInner {\r\n  {% if popup.params.tpl.enb_subscribe or popup.params.tpl.enb_foot_note or popup.params.tpl.enb_sm %}\r\n  	width: 66%;\r\n	[else]\r\n  	width: 100%;\r\n  	[endif]\r\n  	display: table-cell;\r\n  	vertical-align: top;\r\n  	padding: 30px 20px;\r\n	[if bg_type_0 == \'color\']\r\n	background-color: [bg_color_0];\r\n  	background-image: none;\r\n  	[elseif bg_type_0 == \'img\']\r\n  	background-image: url(\"[bg_img_0]\");\r\n  	background-repeat: no-repeat;\r\n  	background-size: cover;\r\n  	[endif]\r\n}\r\n#ppsPopupShell_[ID] .ppsPopupLabel {\r\n	font-size: 30px;\r\n	letter-spacing: -1px;\r\n	line-height: 40px;\r\n	margin-bottom: 15px;\r\n}\r\n#ppsPopupShell_[ID] .ppsRightCol {\r\n	display: table-cell;\r\n  	width: 34%;\r\n  	height: 100%;\r\n  	text-align: center;\r\n  	[if bg_type_1 == \'color\']\r\n  	background: -moz-radial-gradient(center, ellipse cover, {{ adjust_brightness(popup.params.tpl.bg_color_1, 50) }} 0%, [bg_color_1] 100%); /* ff3.6+ */\r\n	background: -webkit-gradient(radial, center center, 0px, center center, 100%, color-stop(0%, {{ adjust_brightness(popup.params.tpl.bg_color_1, 50) }}), color-stop(100%, [bg_color_1])); /* safari4+,chrome */\r\n	background:-webkit-radial-gradient(center, ellipse cover, {{ adjust_brightness(popup.params.tpl.bg_color_1, 50) }} 0%, [bg_color_1] 100%); /* safari5.1+,chrome10+ */\r\n	background: -o-radial-gradient(center, ellipse cover, {{ adjust_brightness(popup.params.tpl.bg_color_1, 50) }} 0%, [bg_color_1] 100%); /* opera 11.10+ */\r\n	background: -ms-radial-gradient(center, ellipse cover, {{ adjust_brightness(popup.params.tpl.bg_color_1, 50) }} 0%, [bg_color_1] 100%); /* ie10+ */\r\n  background:radial-gradient(ellipse at center, {{ adjust_brightness(popup.params.tpl.bg_color_1, 50) }} 0%, [bg_color_1] 100%); /* w3c */\r\n	filter: progid:DXImageTransform.Microsoft.gradient( startColorstr=\'{{ adjust_brightness(popup.params.tpl.bg_color_1, 50) }}\', endColorstr=\'[bg_color_1]\',GradientType=1 ); /* ie6-9 */\r\n  	[elseif bg_type_1 == \'img\']\r\n  	background-color: [bg_color_1];\r\n  	background-image: url(\"[bg_img_1]\");\r\n  	background-repeat: no-repeat;\r\n  	background-size: cover;\r\n  	[endif]\r\n  \r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell form {\r\n	padding: 30px 30px 0;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell input,\r\n#ppsPopupShell_[ID] .ppsSubscribeShell .ppsSubSelect,\r\n#ppsPopupShell_[ID] .ppsSubscribeShell textarea {\r\n	width: 100%;\r\n  	margin-bottom: 10px;\r\n  	height: 40px;\r\n  	border: none;\r\n  	border-radius: 0;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell input[type=text],#ppsPopupShell_[ID] .ppsSubscribeShell input[type=email],#ppsPopupShell_[ID] .ppsSubscribeShell input[type=password],#ppsPopupShell_[ID] .ppsSubscribeShell input[type=email],\r\n#ppsPopupShell_[ID] .ppsSubscribeShell .ppsSubSelect,\r\n#ppsPopupShell_[ID] .ppsSubscribeShell textarea {\r\n  	padding-left: 10px;\r\n  	font-size: 17px;\r\n  	background-color: #fff;\r\n  	display: block;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell .ppsSubSelect {\r\n	display: table;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell .ppsSubSelectLabel,\r\n#ppsPopupShell_[ID] .ppsSubscribeShell select {\r\n	display: table-cell;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell .ppsSubSelectLabel {\r\n	opacity: 0.5;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell select {\r\n	width: 100%;\r\n  	background-color: transparent;\r\n  	height: 40px;\r\n  	border: none;\r\n  	margin-left: -5px;\r\n  	font-size: 17px;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell textarea {\r\n	font-family: inherit;\r\n  	height: auto;\r\n    padding-top: 5px;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell input[type=submit] {\r\n  	[if bg_type_2 == \'color\']\r\n  	background-color: [bg_color_2];\r\n  	border-bottom: 3px solid {{ adjust_brightness(popup.params.tpl.bg_color_2, -50) }};\r\n  	background-image: none;\r\n  	[elseif bg_type_2 == \'img\']\r\n  	background-image: url(\"[bg_img_2]\");\r\n  	background-repeat: no-repeat;\r\n  	background-size: cover;\r\n  	[endif]\r\n  	color: #fff;\r\n    font-size: 20px;\r\n  	cursor: pointer;\r\n  	padding: 0;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell input[type=submit]:hover {\r\n	box-shadow: inset 2px 2px 1px #555;\r\n}\r\n#ppsPopupShell_[ID] .ppsPopupTxt_0 {\r\n  	text-align: left;\r\n}\r\n#ppsPopupShell_[ID] .ppsPopupTxt_0 ul {\r\n	padding: 0;\r\n}\r\n#ppsPopupShell_[ID] .ppsPopupClose {\r\n	background-repeat: no-repeat;\r\n  	cursor: pointer;\r\n}\r\n#ppsPopupShell_[ID] .ppsPopupClose.ppsPopupClose_lists_black {\r\n 	top: 0 !important;\r\n  	right: 0 !important;\r\n}\r\n#ppsPopupShell_[ID] .ppsPopupClose:hover {\r\n	opacity: 0.8;\r\n}\r\n#ppsPopupShell_[ID] .ppsFootNote{\r\n	color: #fff;\r\n    font-size: x-small;\r\n    line-height: 14px;\r\n  	margin: 5px 30px 15px;\r\n}\r\n#ppsPopupShell_[ID] .ppsLogo {\r\n	\r\n}","list-building-neo.jpg","1","1","1","1","2015-01-10 18:59:43","1"),
("41","Bright Girl","1","0","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","<link href=\"https://fonts.googleapis.com/css?family=Montserrat\" rel=\"stylesheet\">\r\n<div id=\"ppsPopupShell_[ID]\" class=\"ppsPopupShell ppsPopupListsShell\">\r\n	<a href=\"#\" class=\"ppsPopupClose\"></a>\r\n	<div class=\"ppsPopupListsInner\">\r\n		<div class=\"ppsPopupTblCols\">\r\n          	[if bg_type_2 == \'img\']\r\n			<div class=\"ppsPopupLeftCol\">\r\n				<img src=\"[bg_img_2]\" class=\"ppsLogo\" alt=\"\"/>\r\n			</div>\r\n          	[endif]\r\n			<div class=\"ppsPopupRightCol\">\r\n				<div class=\"ppsBigArrow\"></div>\r\n				[if enb_label]\r\n					<div class=\"ppsPopupLabel\">[label]</div>\r\n				[endif]\r\n				[if enb_txt_0]\r\n					<div class=\"ppsPopupTxt ppsPopupTxt_0\">[txt_0]</div>\r\n				[endif]\r\n				[if enb_subscribe]\r\n					<div class=\"ppsSubscribeShell\">\r\n					[sub_form_start]\r\n					[sub_fields_html]\r\n					<input type=\"submit\" name=\"submit\" value=\"[sub_btn_label]\" />\r\n					[sub_form_end]\r\n					</div>\r\n				[endif]\r\n				[if enb_sm]\r\n					<div class=\"ppsSm\">\r\n					[sm_html]\r\n					</div>\r\n				[endif]\r\n				[if enb_foot_note]\r\n					<div class=\"ppsFootNote\">\r\n					[foot_note]\r\n					</div>\r\n				[endif]\r\n			</div>\r\n		</div>\r\n	</div>\r\n</div>","#ppsPopupShell_[ID] {\r\n	width: [width][width_measure];\r\n  	font-family: \"Montserrat\",Helvetica,Arial,sans-serif;\r\n  	font-size: 14px;\r\n  	[if bg_type_0 == \'img\']\r\n  	background-image: url(\"[bg_img_0]\");\r\n  	background-repeat: no-repeat;\r\n  	background-size: cover;\r\n  	[elseif bg_type_0 == \'color\']\r\n  	background: [bg_color_0];\r\nbackground: -moz-linear-gradient(left, [bg_color_0] 0%, {{ adjust_brightness(popup.params.tpl.bg_color_0, 80) }} 31%, rgba(201,3,49,1) 56%, rgba(201,3,49,1) 67%);\r\nbackground: -webkit-gradient(left top, right top, color-stop(0%, [bg_color_0]), color-stop(31%, {{ adjust_brightness(popup.params.tpl.bg_color_0, 80) }}), color-stop(56%, rgba(201,3,49,1)), color-stop(67%, rgba(201,3,49,1)));\r\nbackground: -webkit-linear-gradient(left, [bg_color_0] 0%, {{ adjust_brightness(popup.params.tpl.bg_color_0, 80) }} 31%, rgba(201,3,49,1) 56%, rgba(201,3,49,1) 67%);\r\nbackground: -o-linear-gradient(left, [bg_color_0] 0%, {{ adjust_brightness(popup.params.tpl.bg_color_0, 80) }} 31%, rgba(201,3,49,1) 56%, rgba(201,3,49,1) 67%);\r\nbackground: -ms-linear-gradient(left, [bg_color_0] 0%, {{ adjust_brightness(popup.params.tpl.bg_color_0, 80) }} 31%, rgba(201,3,49,1) 56%, rgba(201,3,49,1) 67%);\r\nbackground: linear-gradient(to right, [bg_color_0] 0%, {{ adjust_brightness(popup.params.tpl.bg_color_0, 80) }} 31%, rgba(201,3,49,1) 56%, rgba(201,3,49,1) 67%);\r\nfilter: progid:DXImageTransform.Microsoft.gradient( startColorstr=\'[bg_color_0]\', endColorstr=\'{{ adjust_brightness(popup.params.tpl.bg_color_0, 80) }}\', GradientType=1 );\r\n  	[endif]\r\n}\r\n#ppsPopupShell_[ID], #ppsPopupShell_[ID] * {\r\n	-webkit-box-sizing: border-box;\r\n	-moz-box-sizing:    border-box;\r\n	box-sizing:         border-box;\r\n}\r\n#ppsPopupShell_[ID] .ppsPopupLabel {\r\n	color: #fff;\r\n    font-size: 31px;\r\n	line-height: 1.2;\r\n	text-align: center;\r\n  	margin-bottom: 50px;\r\n}\r\n#ppsPopupShell_[ID] .ppsPopupListsInner {\r\n  	[if bg_type_0 == \'color\']\r\n    background: {{ adjust_brightness(popup.params.tpl.bg_color_0, 50) }}; /* Old browsers */\r\n    background: -moz-radial-gradient(center, ellipse cover, {{ adjust_brightness(popup.params.tpl.bg_color_0, 50) }} 0%, [bg_color_0] 100%); /* FF3.6+ */\r\n    background: -webkit-gradient(radial, center center, 0px, center center, 100%, color-stop(0%,{{ adjust_brightness(popup.params.tpl.bg_color_0, 50) }}), color-stop(100%,[bg_color_0])); /* Chrome,Safari4+ */\r\n    background: -webkit-radial-gradient(center, ellipse cover, {{ adjust_brightness(popup.params.tpl.bg_color_0, 50) }} 0%,[bg_color_0] 100%); /* Chrome10+,Safari5.1+ */\r\n    background: -o-radial-gradient(center, ellipse cover, {{ adjust_brightness(popup.params.tpl.bg_color_0, 50) }} 0%,[bg_color_0] 100%); /* Opera 12+ */\r\n    background: -ms-radial-gradient(center, ellipse cover, {{ adjust_brightness(popup.params.tpl.bg_color_0, 50) }} 0%,[bg_color_0] 100%); /* IE10+ */\r\n    background: radial-gradient(ellipse at center, {{ adjust_brightness(popup.params.tpl.bg_color_0, 50) }} 0%,[bg_color_0] 100%); /* W3C */\r\n    filter: progid:DXImageTransform.Microsoft.gradient( startColorstr=\'{{ adjust_brightness(popup.params.tpl.bg_color_0, 50) }}\', endColorstr=\'#eaeaea\',GradientType=1 ); /* IE6-9 fallback on horizontal gradient */\r\n  	[endif]\r\n}\r\n#ppsPopupShell_[ID] .ppsPopupTxt_0 .ppsTxtContent {\r\n	padding: 10px 10px 10px 50px;\r\n}\r\n#ppsPopupShell_[ID] .ppsPopupTxt_0 {\r\n	font-size: 12px;\r\n}\r\n#ppsPopupShell_[ID] .ppsPopupTblCols {\r\n	display: table;\r\n  	padding: 0;\r\n}\r\n#ppsPopupShell_[ID] .ppsPopupLeftCol {\r\n	display: table-cell;\r\n    padding: 0;\r\n  	[if enb_subscribe]\r\n  	width: 40%;\r\n  	[else]\r\n  	width: 30%;\r\n  	min-height: 60%;\r\n  	[endif]\r\n  	vertical-align: top;\r\n}\r\n#ppsPopupShell_[ID] .ppsLogo {\r\n  	width: auto;\r\n  	height: auto;\r\n  	display: block;\r\n}\r\n#ppsPopupShell_[ID] .ppsPopupRightCol {\r\n    color: #fff;\r\n  	width: 60%;\r\n	display: table-cell;\r\n  	padding: 50px 40px 20px;\r\n  	text-align: center;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell form {\r\n	padding: 30px 50px 0;\r\n  	text-align: center;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell input,\r\n#ppsPopupShell_[ID] .ppsSubscribeShell .ppsSubSelect,\r\n#ppsPopupShell_[ID] .ppsSubscribeShell textarea {\r\n	width: 100%;\r\n  	margin-bottom: 10px;\r\n  	height: 35px;\r\n  	border-radius: 0;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell input[type=text],#ppsPopupShell_[ID] .ppsSubscribeShell input[type=email],#ppsPopupShell_[ID] .ppsSubscribeShell input[type=password],#ppsPopupShell_[ID] .ppsSubscribeShell input[type=email],#ppsPopupShell_[ID] .ppsSubscribeShell input[type=password],#ppsPopupShell_[ID] .ppsSubscribeShell input[type=email],\r\n#ppsPopupShell_[ID] .ppsSubscribeShell .ppsSubSelect,\r\n#ppsPopupShell_[ID] .ppsSubscribeShell textarea {\r\n  	background: [bg_color_1];\r\n  	border: 1px solid transparent;\r\n  	color: #000;\r\n  	padding-left: 10px;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell .ppsSubSelect {\r\n	display: table;\r\n  	text-align: left;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell .ppsSubSelectLabel,\r\n#ppsPopupShell_[ID] .ppsSubscribeShell select {\r\n	display: table-cell;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell .ppsSubSelectLabel {\r\n	opacity: 0.5;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell select {\r\n	width: 100%;\r\n  	background-color: transparent;\r\n  	height: 40px;\r\n  	border: none;\r\n  	font-size: 17px;\r\n  	color: #fff;\r\n  	margin-left: -15px;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell textarea {\r\n	font-family: inherit;\r\n  	height: auto;\r\n    padding: 20px 5px;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell input[type=submit] {\r\n	border: 1px solid #fff;\r\n  	[if bg_type_3 == \'color\']\r\n  	background: [bg_color_3];\r\n  	[elseif bg_type_3 == \'img\']\r\n  	background-image: url(\"[bg_img_3]\");\r\n  	background-repeat: no-repeat;\r\n  	background-size: cover;\r\n  	[endif]\r\n  	color: #fff;\r\n    font-size: 20px;\r\n  	cursor: pointer;\r\n  	border-radius: 0;\r\n  	padding: 0;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell input[type=submit]:hover {\r\n	opacity: 0.8;\r\n}\r\n#ppsPopupShell_[ID] .ppsPopupClose:hover {\r\n	opacity: 0.8;\r\n}\r\n#ppsPopupShell_[ID] .ppsPopupClose {\r\n	background-repeat: no-repeat;\r\n  	cursor: pointer;\r\n  	right: -20px !important;\r\n	top: -10px !important;\r\n}\r\n#ppsPopupShell_[ID] .ppsFootNote {\r\n  	[if enb_subscribe]\r\n    color: #979696;\r\n    font-size: xx-small;\r\n    font-style: italic;\r\n    line-height: 14px;\r\n    text-align: left;\r\n  	margin-left: 10px;\r\n  	[else]\r\n  	margin-top: 10px;\r\n  	color: #979696;\r\n    font-size: xx-small;\r\n    font-style: italic;\r\n    line-height: 14px;\r\n    text-align: left;\r\n    margin-left: 10px;\r\n  	[endif]\r\n}\r\n#ppsPopupShell_[ID] .ppsSm{\r\n	[if enb_subscribe]\r\n  	[else]\r\n  	margin-top: 130px;\r\n  	[endif]\r\n}\r\n#ppsPopupShell_[ID] li{\r\n	font-weight: bold;\r\n  	font-size: 13px;\r\n  	padding-top: 3px;\r\n	padding-bottom: 3px;\r\n  	color: #737E86;\r\n}\r\n@media screen and (max-width: 767px){\r\n  #ppsPopupShell_[ID] .ppsPopupLeftCol{\r\n    background-image: url([bg_img_2]);\r\n    background-repeat: no-repeat;\r\n    background-size: cover;\r\n    background-position: top center;\r\n  }\r\n  #ppsPopupShell_[ID] .ppsLogo{\r\n    opacity: 0;\r\n  }\r\n  #ppsPopupShell_[ID] .ppsPopupRightCol{\r\n    padding: 20px;\r\n  }\r\n  #ppsPopupShell_[ID] .ppsSubscribeShell form{\r\n    padding: 15px 0px 0;\r\n  }\r\n}","girl-2.jpg","1","1","1","1","2015-01-13 19:22:48","1"),
("42","Sign Up Classic","1","0","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","<link href=\"https://fonts.googleapis.com/css?family=Dancing+Script|Gloria+Hallelujah|Hind|Pacifico|Satisfy\" rel=\"stylesheet\"> \r\n<div id=\"ppsPopupShell_[ID]\" class=\"ppsPopupShell ppsPopupListsShell\">\r\n	<a href=\"#\" class=\"ppsPopupClose ppsPopupClose_[close_btn]\"></a>\r\n	<div class=\"ppsInnerTblContent\">\r\n		<div class=\"ppsPopupListsInner ppsPopupInner\">\r\n			[if enb_label]\r\n				<div class=\"ppsPopupLabel ppsPopupListsLabel\">[label]</div>\r\n			[endif]\r\n			<div style=\"clear: both;\"></div>\r\n			[if enb_txt_0]\r\n				<div class=\"ppsPopupTxt ppsPopupClassyTxt ppsPopupClassyTxt_0 ppsPopupTxt_0\">\r\n				[txt_0]\r\n				</div>\r\n			[endif]\r\n			[if enb_subscribe]\r\n				<div class=\"ppsSubscribeShell\">\r\n					[sub_form_start]\r\n					[sub_fields_html]\r\n					<input type=\"submit\" name=\"submit\" value=\"[sub_btn_label]\" />\r\n					[sub_form_end]\r\n					<div style=\"clear: both;\"></div>\r\n				</div>\r\n			[endif]\r\n			<div style=\"clear: both;\"></div>\r\n			<div class=\"ppsRightCol\">\r\n				[if enb_sm]\r\n					<div style=\"clear: both;\"></div>\r\n					<div class=\"ppsSm\">\r\n					[sm_html]\r\n					</div>\r\n				[endif]\r\n				[if enb_foot_note]\r\n					<div class=\"ppsFootNote\">\r\n					[foot_note]\r\n					</div>\r\n				[endif]\r\n			</div>\r\n		</div>\r\n	</div>\r\n</div>","#ppsPopupShell_[ID] {\r\n	width: [width][width_measure];\r\n  	padding: 15px;\r\n  	font-family: \"Hind\",\"arial\",arial;\r\n	font-size: 13px;\r\n	line-height: 21px;\r\n	font-weight: normal;\r\n	color: #4d4d4d;\r\n  	text-align: center;\r\n}\r\n#ppsPopupShell_[ID], #ppsPopupShell_[ID] * {\r\n	-webkit-box-sizing: border-box;\r\n	-moz-box-sizing:    border-box;\r\n	box-sizing:         border-box;\r\n}\r\n#ppsPopupShell_[ID] .ppsInnerTblContent {\r\n	display: table;\r\n  	width: 100%;\r\n}\r\n#ppsPopupShell_[ID] .ppsPopupInner {\r\n  	width: 100%;\r\n  	display: table-cell;\r\n  	padding: 40px;\r\n	[if bg_type_0 == \'color\']\r\n	background-color: [bg_color_0];\r\n  	background-image: none;\r\n  	[elseif bg_type_0 == \'img\']\r\n  	background-image: url(\"[bg_img_0]\");\r\n  	background-repeat: no-repeat;\r\n  	background-size: cover;\r\n  	[endif]\r\n}\r\n#ppsPopupShell_[ID] .ppsPopupLabel {\r\n	font-family: \"Dancing Script\", arial;\r\n	font-size: 40px;\r\n	line-height: 40px;\r\n	font-weight: bold;\r\n  	margin-bottom: 30px;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell form {\r\n	margin-bottom: 20px;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell input,\r\n#ppsPopupShell_[ID] .ppsSubscribeShell .ppsSubSelect,\r\n#ppsPopupShell_[ID] .ppsSubscribeShell textarea {\r\n	width: 100%;\r\n  	margin-bottom: 10px;\r\n  	height: 40px;\r\n  	border: none;\r\n	border-radius: 0;\r\n  	font-size: 17px;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell input[type=text],#ppsPopupShell_[ID] .ppsSubscribeShell input[type=email],#ppsPopupShell_[ID] .ppsSubscribeShell input[type=password],#ppsPopupShell_[ID] .ppsSubscribeShell input[type=email],\r\n#ppsPopupShell_[ID] .ppsSubscribeShell .ppsSubSelect,\r\n#ppsPopupShell_[ID] .ppsSubscribeShell textarea {\r\n  	padding-left: 10px;\r\n  	\r\n  	background-color: #fff;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell .ppsSubSelect {\r\n	display: table;\r\n  	text-align: left;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell .ppsSubSelectLabel,\r\n#ppsPopupShell_[ID] .ppsSubscribeShell select {\r\n	display: table-cell;\r\n  	color: #000;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell .ppsSubSelectLabel {\r\n	opacity: 0.5;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell select {\r\n	width: 100%;\r\n  	background-color: transparent;\r\n  	height: 40px;\r\n  	border: none;\r\n  	margin-left: -4px;\r\n  	font-size: 17px;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell textarea {\r\n	font-family: inherit;\r\n  	height: auto;\r\n    padding-top: 5px;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell input[type=submit] {\r\n	border-color: #000;\r\n  	[if bg_type_1 == \'color\']\r\n  	background: [bg_color_1] 100%;\r\n  	background-image: none;\r\n  	border: 1px solid #fff;\r\n  	box-shadow: 0 0 0 4px [bg_color_1];\r\n  	width: calc(100% - 8px);\r\n  	[elseif bg_type_1 == \'img\']\r\n  	background-image: url(\"[bg_img_1]\");\r\n  	background-repeat: no-repeat;\r\n  	background-size: cover;\r\n  	[endif]\r\n  	color: #fff;\r\n  	cursor: pointer;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell input[type=submit]:hover {\r\n   border-width: 2px;\r\n}\r\n#ppsPopupShell_[ID] .ppsPopupTxt_0 {\r\n  	width: 100%;\r\n	font-size: 14px;\r\n  	margin-bottom: 20px;\r\n}\r\n#ppsPopupShell_[ID] .ppsPopupClose {\r\n	background-repeat: no-repeat;\r\n  	cursor: pointer;\r\n	top: 15px;\r\n  	right: 10px;\r\n}\r\n#ppsPopupShell_[ID] .ppsPopupClose.ppsPopupClose_lists_black {\r\n 	top: 0 !important;\r\n  	right: 0 !important;\r\n}\r\n#ppsPopupShell_[ID] .ppsPopupClose:hover {\r\n	opacity: 0.8;\r\n}\r\n#ppsPopupShell_[ID] .ppsFootNote {\r\n	color: #585858;\r\n    font-family: \"Helvetica Neue\",Helvetica,Arial,sans-serif;\r\n    font-size: x-small;\r\n    font-style: italic;\r\n    line-height: 14px;\r\n  	margin: 5px 30px;\r\n}\r\n#ppsPopupShell_[ID] .ppsSm {\r\n	margin-top:20px;\r\n}","sign-up-classic.jpg","1","1","1","1","2015-01-10 18:59:43","1")');
		}
		if(!dbPps::exist('@__popup', 'id', '43')) {
			dbPps::query('INSERT INTO @__popup (id,label,active,original_id,params,html,css,img_preview,show_on,show_to,show_pages,type_id,date_created,sort_order) VALUES 
("43","Smart New Edition","1","0","YTozOntzOjQ6Im1haW4iO2E6MzA6e3M6Nzoic2hvd19vbiI7czo5OiJwYWdlX2xvYWQiO3M6MjM6InNob3dfb25fcGFnZV9sb2FkX2RlbGF5IjtzOjA6IiI7czoyNToic2hvd19vbl9jbGlja19vbl9lbF9kZWxheSI7czoxOiIwIjtzOjI3OiJzaG93X29uX3Njcm9sbF93aW5kb3dfZGVsYXkiO3M6MToiMCI7czozMzoic2hvd19vbl9zY3JvbGxfd2luZG93X3BlcmNfc2Nyb2xsIjtzOjE6IjAiO3M6Mjg6InNob3dfb25fYWZ0ZXJfaW5hY3RpdmVfdmFsdWUiO3M6MjoiMTAiO3M6MjU6InNob3dfb25fbGlua19mb2xsb3dfZGVsYXkiO3M6MToiMCI7czo4OiJjbG9zZV9vbiI7czoxMzoib3ZlcmxheV9jbGljayI7czoyNjoiY2xvc2Vfb25fYWZ0ZXJfYWN0aW9uX3RpbWUiO3M6MToiMSI7czoyNToiY2xvc2Vfb25fYWZ0ZXJfdGltZV92YWx1ZSI7czoxOiI1IjtzOjEwOiJzaG93X3BhZ2VzIjtzOjM6ImFsbCI7czoxNDoic2hvd190aW1lX2Zyb20iO3M6NzoiMTI6MDBhbSI7czoxMjoic2hvd190aW1lX3RvIjtzOjc6IjEyOjAwYW0iO3M6MTQ6InNob3dfZGF0ZV9mcm9tIjtzOjA6IiI7czoxMjoic2hvd19kYXRlX3RvIjtzOjA6IiI7czo3OiJzaG93X3RvIjtzOjg6ImV2ZXJ5b25lIjtzOjI5OiJzaG93X3RvX2ZpcnN0X3RpbWVfdmlzaXRfZGF5cyI7czoyOiIzMCI7czozMDoic2hvd190b191bnRpbF9tYWtlX2FjdGlvbl9kYXlzIjtzOjI6IjMwIjtzOjE1OiJjb3VudF90aW1lc19udW0iO3M6MToiMSI7czoxNToiY291bnRfdGltZXNfbWVzIjtzOjM6ImRheSI7czoyMToiaGlkZV9mb3JfZGV2aWNlc19zaG93IjtzOjE6IjAiO3M6MjQ6ImhpZGVfZm9yX3Bvc3RfdHlwZXNfc2hvdyI7czoxOiIwIjtzOjE3OiJoaWRlX2Zvcl9pcHNfc2hvdyI7czoxOiIwIjtzOjEyOiJoaWRlX2Zvcl9pcHMiO3M6MDoiIjtzOjIzOiJoaWRlX2Zvcl9jb3VudHJpZXNfc2hvdyI7czoxOiIwIjtzOjIzOiJoaWRlX2Zvcl9sYW5ndWFnZXNfc2hvdyI7czoxOiIwIjtzOjI0OiJoaWRlX3NlYXJjaF9lbmdpbmVzX3Nob3ciO3M6MToiMCI7czoxODoiaGlkZV9wcmVnX3VybF9zaG93IjtzOjE6IjAiO3M6MTM6ImhpZGVfcHJlZ191cmwiO3M6MDoiIjtzOjI0OiJoaWRlX2Zvcl91c2VyX3JvbGVzX3Nob3ciO3M6MToiMCI7fXM6MzoidHBsIjthOjEwMjp7czo1OiJ3aWR0aCI7czozOiI3NzAiO3M6MTM6IndpZHRoX21lYXN1cmUiO3M6MjoicHgiO3M6MTg6ImJnX292ZXJsYXlfb3BhY2l0eSI7czozOiIwLjUiO3M6MTU6ImJnX292ZXJsYXlfdHlwZSI7czo1OiJjb2xvciI7czoxNjoiYmdfb3ZlcmxheV9jb2xvciI7czo0OiIjMDAwIjtzOjE0OiJiZ19vdmVybGF5X2ltZyI7czowOiIiO3M6MTg6ImJnX292ZXJsYXlfaW1nX3BvcyI7czo3OiJzdHJldGNoIjtzOjk6ImJnX3R5cGVfMCI7czo1OiJjb2xvciI7czo4OiJiZ19pbWdfMCI7czo0MzoiW1BQU19BU1NFVFNfVVJMXWltZy9hc3NldHMvYmctZm9ybS1tYWluLnBuZyI7czoxMDoiYmdfY29sb3JfMCI7czo3OiIjYWFhYWFhIjtzOjk6ImJnX3R5cGVfMSI7czo1OiJjb2xvciI7czo4OiJiZ19pbWdfMSI7czozOToiW1BQU19BU1NFVFNfVVJMXWltZy9hc3NldHMvYnV0dG9uLTEucG5nIjtzOjEwOiJiZ19jb2xvcl8xIjtzOjc6IiNmZmZmZmYiO3M6OToiYmdfdHlwZV8yIjtzOjM6ImltZyI7czo4OiJiZ19pbWdfMiI7czo0MDoiW1BQU19BU1NFVFNfVVJMXWltZy9hc3NldHMvZm9ybS1ib29rLnBuZyI7czoxMDoiYmdfY29sb3JfMiI7czo3OiIjZThlOGU4IjtzOjk6ImJnX3R5cGVfMyI7czo1OiJjb2xvciI7czo4OiJiZ19pbWdfMyI7czo4ODoiW1BQU19TSVRFX1VSTF13cC1jb250ZW50L3VwbG9hZHMvMjAxNi8xMS81X2NocmlzY2h1bmdfaG9uZ2tvbmdwYXJrLTEtMS0xLTEtMi0xLTEtMS0yLmpwZyI7czoxMDoiYmdfY29sb3JfMyI7czo3OiIjNTFkY2RlIjtzOjk6ImJnX3R5cGVfNCI7czo1OiJjb2xvciI7czo4OiJiZ19pbWdfNCI7czowOiIiO3M6MTA6ImJnX2NvbG9yXzQiO3M6NzoiI2ZmZmZmZiI7czo5OiJiZ190eXBlXzUiO3M6NToiY29sb3IiO3M6ODoiYmdfaW1nXzUiO3M6MDoiIjtzOjEwOiJiZ19jb2xvcl81IjtzOjc6IiM4NDg0ODQiO3M6OToiYmdfdHlwZV82IjtzOjU6ImNvbG9yIjtzOjg6ImJnX2ltZ182IjtzOjA6IiI7czoxMDoiYmdfY29sb3JfNiI7czo3OiIjNTFkY2RlIjtzOjEwOiJmb250X2xhYmVsIjtzOjEwOiJNb250c2VycmF0IjtzOjE2OiJsYWJlbF9mb250X2NvbG9yIjtzOjc6IiM0ZDRjNGMiO3M6MTA6ImZvbnRfdHh0XzAiO3M6MTA6Ik1vbnRzZXJyYXQiO3M6MTc6InRleHRfZm9udF9jb2xvcl8wIjtzOjc6IiM0ZDRjNGMiO3M6MTE6ImZvbnRfZm9vdGVyIjtzOjEwOiJNb250c2VycmF0IjtzOjE3OiJmb290ZXJfZm9udF9jb2xvciI7czo3OiIjOTc5Njk2IjtzOjE3OiJyZWlkcmVjdF9vbl9jbG9zZSI7czowOiIiO3M6OToiY2xvc2VfYnRuIjtzOjQ6Im5vbmUiO3M6NzoiYnVsbGV0cyI7czoxNDoiY2lyY2xlX2JpZ19uZXciO3M6MTk6ImxheWVyX3JlbF9zZWxlY3RvcnMiO3M6MDoiIjtzOjExOiJsYXllcmVkX3BvcyI7czozOiJ0b3AiO3M6OToiZW5iX2xhYmVsIjtzOjE6IjEiO3M6NToibGFiZWwiO3M6MTMxOiJHZXQgaXQgPHNwYW4gY2xhc3M9XCJwcHNIZWFkZXJUeHQyXCI+Tk9XITwvc3Bhbj4gSW5jcmVhc2UgbW9yZSB0aGFuIDxzcGFuIGNsYXNzPVwicHBzSGVhZGVyVHh0MlwiPjcwMCU8L3NwYW4+IG9mIEVtYWlsIFN1YnNjcmliZXJzISI7czo5OiJlbmJfdHh0XzAiO3M6MToiMSI7czo5OiJmb290X25vdGUiO3M6MTE3OiJXZSByZXNwZWN0IHlvdXIgcHJpdmFjeS4gWW91ciBpbmZvcm1hdGlvbiB3aWxsIG5vdCBiZSBzaGFyZWQgd2l0aCBhbnkgdGhpcmQgcGFydHkgYW5kIHlvdSBjYW4gdW5zdWJzY3JpYmUgYXQgYW55IHRpbWUiO3M6MTU6ImVuYl9zbV9mYWNlYm9vayI7czoxOiIxIjtzOjE3OiJlbmJfc21fZ29vZ2xlcGx1cyI7czoxOiIxIjtzOjE0OiJlbmJfc21fdHdpdHRlciI7czoxOiIxIjtzOjk6InNtX2Rlc2lnbiI7czo2OiJzaW1wbGUiO3M6ODoiYW5pbV9rZXkiO3M6NDoiZmFkZSI7czoxMzoiYW5pbV9kdXJhdGlvbiI7czo0OiIxMDAwIjtzOjEzOiJlbmJfc3Vic2NyaWJlIjtzOjE6IjEiO3M6ODoic3ViX2Rlc3QiO3M6OToid29yZHByZXNzIjtzOjIzOiJzdWJfd3BfY3JlYXRlX3VzZXJfcm9sZSI7czoxMDoic3Vic2NyaWJlciI7czoxOToic3ViX2F3ZWJlcl9saXN0bmFtZSI7czowOiIiO3M6MjE6InN1Yl9hd2ViZXJfYWR0cmFja2luZyI7czowOiIiO3M6MjE6InN1Yl9tYWlsY2hpbXBfYXBpX2tleSI7czowOiIiO3M6MjU6InN1Yl9tYWlsY2hpbXBfZ3JvdXBzX2Z1bGwiO3M6MDoiIjtzOjE4OiJzdWJfYXJfZm9ybV9hY3Rpb24iO3M6MDoiIjtzOjEwOiJzdWJfc2dhX2lkIjtzOjA6IiI7czoxNToic3ViX3NnYV9saXN0X2lkIjtzOjA6IiI7czoyMToic3ViX3NnYV9hY3RpdmF0ZV9jb2RlIjtzOjA6IiI7czoxNDoic3ViX3Y2X2FwaV9rZXkiO3M6MDoiIjtzOjE2OiJzdWJfeW1scF9hcGlfa2V5IjtzOjA6IiI7czoxMzoic3ViX3ltbHBfbmFtZSI7czowOiIiO3M6MTA6InN1Yl9maWVsZHMiO2E6Mjp7czo0OiJuYW1lIjthOjc6e3M6NDoibmFtZSI7czo0OiJuYW1lIjtzOjQ6Imh0bWwiO3M6NDoidGV4dCI7czo1OiJsYWJlbCI7czo0OiJOYW1lIjtzOjU6InZhbHVlIjtzOjA6IiI7czo2OiJjdXN0b20iO3M6MToiMCI7czo5OiJtYW5kYXRvcnkiO3M6MToiMCI7czoxMDoic2V0X3ByZXNldCI7czowOiIiO31zOjU6ImVtYWlsIjthOjg6e3M6NDoibmFtZSI7czo1OiJlbWFpbCI7czo0OiJodG1sIjtzOjQ6InRleHQiO3M6NToibGFiZWwiO3M6NjoiRS1NYWlsIjtzOjU6InZhbHVlIjtzOjA6IiI7czo2OiJjdXN0b20iO3M6MToiMCI7czo5OiJtYW5kYXRvcnkiO3M6MToiMSI7czoxMDoic2V0X3ByZXNldCI7czowOiIiO3M6MzoiZW5iIjtzOjE6IjEiO319czo5OiJibGFja2xpc3QiO3M6MDoiIjtzOjE1OiJibGFja2xpc3RfZXJyb3IiO3M6MjY6IllvdXIgZW1haWwgaXMgaW4gYmxhY2tsaXN0IjtzOjIwOiJzdWJfdHh0X2NvbmZpcm1fc2VudCI7czo2NzoiQ29uZmlybWF0aW9uIGxpbmsgd2FzIHNlbnQgdG8geW91ciBlbWFpbCBhZGRyZXNzLiBDaGVjayB5b3VyIGVtYWlsISI7czoxNToic3ViX3R4dF9zdWNjZXNzIjtzOjI0OiJUaGFuayB5b3UgZm9yIHN1YnNjcmliZSEiO3M6MjE6InN1Yl90eHRfaW52YWxpZF9lbWFpbCI7czoyMjoiRW1wdHkgb3IgaW52YWxpZCBlbWFpbCI7czoyMDoic3ViX3R4dF9leGlzdHNfZW1haWwiO3M6MjI6IkVtcHR5IG9yIGludmFsaWQgZW1haWwiO3M6MTY6InN1Yl9yZWRpcmVjdF91cmwiO3M6MDoiIjtzOjI4OiJzdWJfdHh0X2NvbmZpcm1fbWFpbF9zdWJqZWN0IjtzOjM0OiJDb25maXJtIHN1YnNjcmlwdGlvbiBvbiBbc2l0ZW5hbWVdIjtzOjI1OiJzdWJfdHh0X2NvbmZpcm1fbWFpbF9mcm9tIjtzOjE0OiJhZG1pbkBtYWlsLmNvbSI7czoyODoic3ViX3R4dF9jb25maXJtX21haWxfbWVzc2FnZSI7czoxOTc6IllvdSBzdWJzY3JpYmVkIG9uIHNpdGUgPGEgaHJlZj1cIltzaXRldXJsXVwiPltzaXRlbmFtZV08L2E+LiBGb2xsb3cgPGEgaHJlZj1cIltjb25maXJtX2xpbmtdXCI+dGhpcyBsaW5rPC9hPiB0byBjb21wbGV0ZSB5b3VyIHN1YnNjcmlwdGlvbi4gSWYgeW91IGRpZCBub3Qgc3Vic2NyaWJlIGhlcmUgLSBqdXN0IGlnbm9yZSB0aGlzIG1lc3NhZ2UuIjtzOjMxOiJzdWJfdHh0X3N1YnNjcmliZXJfbWFpbF9zdWJqZWN0IjtzOjM3OiJbc2l0ZW5hbWVdIFlvdXIgdXNlcm5hbWUgYW5kIHBhc3N3b3JkIjtzOjI4OiJzdWJfdHh0X3N1YnNjcmliZXJfbWFpbF9mcm9tIjtzOjE0OiJhZG1pbkBtYWlsLmNvbSI7czozMToic3ViX3R4dF9zdWJzY3JpYmVyX21haWxfbWVzc2FnZSI7czo2NToiVXNlcm5hbWU6IFt1c2VyX2xvZ2luXTxiciAvPlBhc3N3b3JkOiBbcGFzc3dvcmRdPGJyIC8+W2xvZ2luX3VybF0iO3M6MjU6InN1Yl9yZWRpcmVjdF9lbWFpbF9leGlzdHMiO3M6MDoiIjtzOjEzOiJzdWJfYnRuX2xhYmVsIjtzOjExOiJHZXQgaXQgbm93ISI7czoxMzoic3ViX25ld19lbWFpbCI7czoxNDoiYWRtaW5AbWFpbC5jb20iO3M6MTU6InN1Yl9uZXdfc3ViamVjdCI7czoyODoiTmV3IHN1YnNjcmliZXIgb24gW3NpdGVuYW1lXSI7czoxNToic3ViX25ld19tZXNzYWdlIjtzOjEyOToiWW91IGhhdmUgbmV3IHN1YnNjcmliZXIgb24geW91ciBzaXRlIDxhIGhyZWY9XCJbc2l0ZXVybF1cIj5bc2l0ZW5hbWVdPC9hPiwgaGVyZSB1cyBzdWJzY3JpYmVyIGluZm9ybWF0aW9uOjxiciAvPltzdWJzY3JpYmVyX2RhdGFdIjtzOjg6ImxvZ2luX2J5IjtzOjg6InVzZXJuYW1lIjtzOjE4OiJsb2dpbl9yZWRpcmVjdF91cmwiO3M6MDoiIjtzOjE1OiJsb2dpbl9idG5fbGFiZWwiO3M6NToiTG9naW4iO3M6MjM6InJlZ193cF9jcmVhdGVfdXNlcl9yb2xlIjtzOjEwOiJzdWJzY3JpYmVyIjtzOjEzOiJyZWdfYnRuX2xhYmVsIjtzOjg6IlJlZ2lzdGVyIjtzOjEwOiJyZWdfZmllbGRzIjthOjI6e3M6NDoibmFtZSI7YTo3OntzOjM6ImVuYiI7czoxOiIxIjtzOjQ6Im5hbWUiO3M6NDoibmFtZSI7czo0OiJodG1sIjtzOjQ6InRleHQiO3M6NToibGFiZWwiO3M6NDoiTmFtZSI7czo1OiJ2YWx1ZSI7czowOiIiO3M6NjoiY3VzdG9tIjtzOjE6IjAiO3M6OToibWFuZGF0b3J5IjtzOjE6IjAiO31zOjU6ImVtYWlsIjthOjc6e3M6NDoibmFtZSI7czo1OiJlbWFpbCI7czo0OiJodG1sIjtzOjQ6InRleHQiO3M6NToibGFiZWwiO3M6NjoiRS1NYWlsIjtzOjU6InZhbHVlIjtzOjA6IiI7czo2OiJjdXN0b20iO3M6MToiMCI7czo5OiJtYW5kYXRvcnkiO3M6MToiMSI7czozOiJlbmIiO3M6MToiMSI7fX1zOjIwOiJyZWdfdHh0X2NvbmZpcm1fc2VudCI7czo2NzoiQ29uZmlybWF0aW9uIGxpbmsgd2FzIHNlbnQgdG8geW91ciBlbWFpbCBhZGRyZXNzLiBDaGVjayB5b3VyIGVtYWlsISI7czoxNToicmVnX3R4dF9zdWNjZXNzIjtzOjI3OiJUaGFuayB5b3UgZm9yIHJlZ2lzdHJhdGlvbiEiO3M6MjE6InJlZ190eHRfaW52YWxpZF9lbWFpbCI7czoyMjoiRW1wdHkgb3IgaW52YWxpZCBlbWFpbCI7czoxNjoicmVnX3JlZGlyZWN0X3VybCI7czowOiIiO3M6Mjg6InJlZ190eHRfY29uZmlybV9tYWlsX3N1YmplY3QiO3M6MzQ6IkNvbmZpcm0gcmVnaXN0cmF0aW9uIG9uIFtzaXRlbmFtZV0iO3M6MjU6InJlZ190eHRfY29uZmlybV9tYWlsX2Zyb20iO3M6MTQ6ImFkbWluQG1haWwuY29tIjtzOjI4OiJyZWdfdHh0X2NvbmZpcm1fbWFpbF9tZXNzYWdlIjtzOjE5NjoiWW91IHJlZ2lzdGVyZWQgb24gc2l0ZSA8YSBocmVmPVwiW3NpdGV1cmxdXCI+W3NpdGVuYW1lXTwvYT4uIEZvbGxvdyA8YSBocmVmPVwiW2NvbmZpcm1fbGlua11cIj50aGlzIGxpbms8L2E+IHRvIGNvbXBsZXRlIHlvdXIgcmVnaXN0cmF0aW9uLiBJZiB5b3UgZGlkIG5vdCByZWdpc3RlciBoZXJlIC0ganVzdCBpZ25vcmUgdGhpcyBtZXNzYWdlLiI7czozMToicmVnX3R4dF9zdWJzY3JpYmVyX21haWxfc3ViamVjdCI7czozNzoiW3NpdGVuYW1lXSBZb3VyIHVzZXJuYW1lIGFuZCBwYXNzd29yZCI7czoyODoicmVnX3R4dF9zdWJzY3JpYmVyX21haWxfZnJvbSI7czoxNDoiYWRtaW5AbWFpbC5jb20iO3M6MzE6InJlZ190eHRfc3Vic2NyaWJlcl9tYWlsX21lc3NhZ2UiO3M6NjU6IlVzZXJuYW1lOiBbdXNlcl9sb2dpbl08YnIgLz5QYXNzd29yZDogW3Bhc3N3b3JkXTxiciAvPltsb2dpbl91cmxdIjtzOjEzOiJyZWdfbmV3X2VtYWlsIjtzOjE0OiJhZG1pbkBtYWlsLmNvbSI7czoxNToicmVnX25ld19tZXNzYWdlIjtzOjEyMToiWW91IGhhdmUgbmV3IG1lbWJlciBvbiB5b3VyIHNpdGUgPGEgaHJlZj1cIltzaXRldXJsXVwiPltzaXRlbmFtZV08L2E+LCBoZXJlIHVzIG1lbWJlciBpbmZvcm1hdGlvbjo8YnIgLz5bc3Vic2NyaWJlcl9kYXRhXSI7czoxMjoic3RhdF9nYV9jb2RlIjtzOjA6IiI7czo1OiJ0eHRfMCI7czoxNzM6IjxwPlBvcHVwIGJ5IFN1cHN5c3RpYyBsZXRzIHlvdSBlYXNpbHkgY3JlYXRlIGVsZWdhbnQgb3ZlcmxhcHBpbmcgd2luZG93cyB3aXRoIHVubGltaXRlZCBmZWF0dXJlcy4gUG9wLXVwcyB3aXRoIFNsaWRlciwgTGlnaHRib3gsIENvbnRhY3QgYW5kIFN1YnNjcmlwdGlvbiBmb3JtcyBhbmQgbW9yZS48L3A+Ijt9czoxMDoib3B0c19hdHRycyI7YToyOntzOjk6ImJnX251bWJlciI7czoxOiI3IjtzOjE2OiJ0eHRfYmxvY2tfbnVtYmVyIjtzOjE6IjEiO319","<link href=\"https://fonts.googleapis.com/css?family=Montserrat\" rel=\"stylesheet\">\r\n<div id=\"ppsPopupShell_[ID]\" class=\"ppsPopupShell ppsPopupListsShell\">\r\n	<a href=\"#\" class=\"ppsPopupClose\"></a>\r\n	<div class=\"ppsPopupListsInner\">\r\n		<div class=\"ppsPopupTblCols\">\r\n			<div class=\"ppsPopupLeftCol\">\r\n				[if bg_type_2 == \"img\"]\r\n				<img src=\"[bg_img_2]\" />\r\n				[endif]\r\n			</div>\r\n			<div class=\"ppsPopupRightCol\">\r\n				<div class=\"ppsBigArrow\"></div>\r\n				[if enb_label]\r\n					<div class=\"ppsPopupLabel\">[label]</div>\r\n				[endif]\r\n				[if enb_txt_0]\r\n					<div class=\"ppsPopupTxt ppsPopupTxt_0\">[txt_0]</div>\r\n				[endif]\r\n				[if enb_subscribe]\r\n					<div class=\"ppsSubscribeShell\">\r\n						[sub_form_start]\r\n						<div class=\"ppsFormWrap\">\r\n						[sub_fields_html]\r\n						</div><!--\r\n						--><input type=\"submit\" name=\"submit\" value=\"[sub_btn_label]\" />\r\n						[sub_form_end]\r\n					</div>\r\n				[endif]\r\n				[if enb_sm]\r\n					<div class=\"ppsSm\">\r\n					[sm_html]\r\n					</div>\r\n				[endif]\r\n				[if enb_foot_note]\r\n					<div class=\"ppsFootNote\">\r\n					[foot_note]\r\n					</div>\r\n				[endif]\r\n			</div>\r\n		</div>\r\n	</div>\r\n</div>","#ppsPopupShell_[ID] {\r\n	width: [width][width_measure];\r\n  	font-family: Helvetica,Arial,sans-serif;\r\n  	font-size: 14px;\r\n  	[if bg_type_0 == \"img\"]\r\n  	background-image: url(\"[bg_img_0]\");\r\n  	background-repeat: no-repeat;\r\n  	background-size: cover;\r\n  	[endif]\r\n}\r\n#ppsPopupShell_[ID], #ppsPopupShell_[ID] * {\r\n	-webkit-box-sizing: border-box;\r\n	-moz-box-sizing:    border-box;\r\n	box-sizing:         border-box;\r\n}\r\n\r\n#ppsPopupShell_[ID] .ppsPopupListsInner {\r\n  	[if bg_type_0 == \"color\"]\r\n	background: {{ adjust_brightness(popup.params.tpl.bg_color_0, 255) }}; /* Old browsers */\r\n	background: -moz-linear-gradient(top,  {{ adjust_brightness(popup.params.tpl.bg_color_0, 255) }} 0%, {{ adjust_brightness(popup.params.tpl.bg_color_0, 125) }} 50%, {{ adjust_brightness(popup.params.tpl.bg_color_0, 60) }} 75%, {{ adjust_brightness(popup.params.tpl.bg_color_0, 0) }} 100%); /* FF3.6-15 */\r\n	background: -webkit-linear-gradient(top,  {{ adjust_brightness(popup.params.tpl.bg_color_0, 255) }} 0%,{{ adjust_brightness(popup.params.tpl.bg_color_0, 125) }} 50%,{{ adjust_brightness(popup.params.tpl.bg_color_0, 60) }} 75%,{{ adjust_brightness(popup.params.tpl.bg_color_0, 0) }} 100%); /* Chrome10-25,Safari5.1-6 */\r\n	background: linear-gradient(to bottom,  {{ adjust_brightness(popup.params.tpl.bg_color_0, 255) }} 0%,{{ adjust_brightness(popup.params.tpl.bg_color_0, 125) }} 50%,{{ adjust_brightness(popup.params.tpl.bg_color_0, 60) }} 75%,{{ adjust_brightness(popup.params.tpl.bg_color_0, 0) }} 100%); /* W3C, IE10+, FF16+, Chrome26+, Opera12+, Safari7+ */\r\n	filter: progid:DXImageTransform.Microsoft.gradient( startColorstr=\"{{ adjust_brightness(popup.params.tpl.bg_color_0, 255) }}\", endColorstr=\"{{ adjust_brightness(popup.params.tpl.bg_color_0, 0) }}\",GradientType=0 ); /* IE6-9 */\r\n	[endif]\r\n}\r\n#ppsPopupShell_[ID] .ppsPopupTblCols {\r\n	display: table;\r\n  	padding: 10px 10px 10px 30px;\r\n}\r\n#ppsPopupShell_[ID] .ppsPopupLeftCol {\r\n	display: table-cell;\r\n  	[if enb_subscribe]\r\n  	width: 30%;\r\n  	[else]\r\n  	width: 30%;\r\n  	min-height: 60%;\r\n  	[endif]\r\n  	vertical-align: middle;\r\n    text-align: center;\r\n}\r\n#ppsPopupShell_[ID] .ppsPopupRightCol {\r\n  	width: 70%;\r\n	display: table-cell;\r\n  	border-radius: 8px;\r\n	-moz-border-radius: 8px;\r\n	-webkit-border-radius: 8px;\r\n  	margin: 8px 5px 5px 5px;\r\n  	text-align: left;\r\n  	padding: 30px 0 30px 0;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell input::-webkit-input-placeholder { /* Chrome/Opera/Safari */\r\n    color: #838383;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell input::-moz-placeholder { /* Firefox 19+ */\r\n    color: #838383;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell input:-ms-input-placeholder { /* IE 10+ */\r\n    color: #838383;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell input:-moz-placeholder { /* Firefox 18- */\r\n    color: #838383;\r\n}\r\n\r\n#ppsPopupShell_[ID] .ppsSubscribeShell textarea::-webkit-input-placeholder { /* Chrome/Opera/Safari */\r\n    color: #838383;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell textarea::-moz-placeholder { /* Firefox 19+ */\r\n    color: #838383;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell textarea:-ms-input-placeholder { /* IE 10+ */\r\n    color: #838383;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell textarea:-moz-placeholder { /* Firefox 18- */\r\n    color: #838383;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell {\r\n	display: block;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell form {\r\n	padding: 30px 0 0;\r\n  	text-align: left;\r\n    position: relative;\r\n}\r\n#ppsPopupShell_[ID] .ppsFormWrap {\r\n	display:inline-block;\r\n	width: 60%;\r\n	vertical-align: bottom;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell input[type=\"text\"],\r\n#ppsPopupShell_[ID] .ppsSubscribeShell input[type=\"email\"],\r\n#ppsPopupShell_[ID] .ppsSubscribeShell input[type=\"password\"],\r\n#ppsPopupShell_[ID] .ppsSubscribeShell input[type=\"email\"],\r\n#ppsPopupShell_[ID] .ppsSubscribeShell select,\r\n#ppsPopupShell_[ID] .ppsSubscribeShell textarea {\r\n	border: 1px solid transparent;\r\n	width: 100%;\r\n	-webkit-border-radius: 0px;\r\n	-moz-border-radius: 0px;\r\n	border-radius: 0px;\r\n	display:block;\r\n    font-size: 17px;\r\n	font-weight: normal;\r\n    color: #636363;\r\n	padding: 0 0 0 10px;\r\n	height: 40px;\r\n	margin: 10px 0 0 0;\r\n	\r\n  	[if bg_type_1 == \"img\"]\r\n  	background: url(\"[bg_img_1]\");\r\n  	background-repeat: no-repeat;\r\n  	background-size: cover;\r\n  	[else]\r\n  	background: [bg_color_1];\r\n  	[endif]\r\n  	\r\n  	[if bg_type_5 == \"color\"]\r\n  	color: [bg_color_5];\r\n  	[endif]\r\n}\r\n\r\n#ppsPopupShell_[ID] .ppsSubscribeShell textarea {\r\n	height: auto;\r\n	padding-top: 9px;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeForm input:first-child {\r\n	margin-top: 0px;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell select  {\r\n	margin: 0;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell label  {\r\n	display: block;\r\n	font-size: 17px;\r\n	color: #636363;\r\n	margin-top: 10px;\r\n	text-align: left;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell label  span {\r\n	display: block;\r\n}\r\n\r\n#ppsPopupShell_[ID] .ppsSubscribeShell input[type=submit] {\r\n  	[if bg_type_3 == \"color\"]\r\n  	background: [bg_color_3];\r\n	background-image: none;\r\n  	[elseif bg_type_3 == \"img\"]\r\n  	background-image: url(\"[bg_img_3]\");\r\n  	background-repeat: no-repeat;\r\n  	background-size: cover;\r\n  	[endif]\r\n	\r\n  	[if bg_type_4 == \"color\"]\r\n  	color: [bg_color_4];\r\n  	[endif]\r\n	\r\n    font-size: 17px;\r\n	font-weight: normal;\r\n  	cursor: pointer;\r\n  	width:  auto;\r\n    text-transform: uppercase;\r\n  	padding: 0px 20px;\r\n	height: 40px;\r\n	display:inline-block;\r\n	border: 1px solid transparent;\r\n	-webkit-border-radius: 0px;\r\n	-moz-border-radius: 0px;\r\n	border-radius: 0px;\r\n	vertical-align: bottom;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell input[type=submit]:hover {\r\n	opacity: 0.8;\r\n}\r\n#ppsPopupShell_[ID] .ppsPopupClose:hover {\r\n	opacity: 0.8;\r\n}\r\n#ppsPopupShell_[ID] .ppsPopupClose {\r\n	background-repeat: no-repeat;\r\n  	cursor: pointer;\r\n  	right: -5px;\r\n	top: 2px;\r\n}\r\n#ppsPopupShell_[ID] .ppsPopupTxt_0 .ppsTxtContent {\r\n	padding: 10px 10px 10px 50px;\r\n}\r\n#ppsPopupShell_[ID] .ppsPopupTxt_0 p {\r\n	margin: 0;\r\n	padding: 0;\r\n	font-family: Montserrat;\r\n	font-size: 16px;\r\n    line-height: 24px;\r\n}\r\n#ppsPopupShell_[ID] .ppsPopupTxt_0 {\r\n  	width: 90%;\r\n  	color: #4d4c4c;\r\n  	display: block;\r\n  	margin: 27px 0 0;\r\n    padding: 0;\r\n}\r\n#ppsPopupShell_[ID] .ppsPopupRightCol .ppsHeaderTxt2 {\r\n  	[if bg_type_6 == \"color\"]\r\n  	color: [bg_color_6] !important;\r\n  	[endif]\r\n	margin: 0;\r\n    padding: 0;\r\n	font-weight: bold;\r\n}\r\n#ppsPopupShell_[ID] .ppsPopupLabel {\r\n	color: #4d4c4c;\r\n	line-height: 1.2;\r\n	margin: 0 10px 0 0;\r\n	color: #4d4c4c;\r\n	font-family: Montserrat;\r\n	font-size: 25px;\r\n    font-weight: normal;\r\n}\r\n#ppsPopupShell_[ID] .ppsFootNote {\r\n  	[if enb_subscribe]\r\n    color: #000000;\r\n    font-family: \"Helvetica Neue\",Helvetica,Arial,sans-serif;\r\n    font-size: xx-small;\r\n    font-style: italic;\r\n    line-height: 14px;\r\n    text-align: left;\r\n  	margin-left: 10px;\r\n  	[else]\r\n  	margin-top: 10px;\r\n  	color: #979696;\r\n    font-family: \"Helvetica Neue\",Helvetica,Arial,sans-serif;\r\n    font-size: xx-small;\r\n    font-style: italic;\r\n    line-height: 14px;\r\n    text-align: left;\r\n    margin-left: 10px;\r\n  	[endif]\r\n}\r\n#ppsPopupShell_[ID] .ppsSm{\r\n	[if enb_subscribe]\r\n  	[else]\r\n  	margin-top: 130px;\r\n  	[endif]\r\n}\r\n#ppsPopupShell_[ID] li{\r\n	font-weight: bold;\r\n  	font-size: 13px;\r\n  	padding-top: 3px;\r\n	padding-bottom: 3px;\r\n  	color: #737E86;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubMsg{\r\n	clear: both;\r\n  	text-align: center;\r\n	width: 100%;\r\n}\r\n","smart2_p4.png","1","1","1","1","2015-01-13 19:22:48","1"),
("44","Christmas Mistletoe","1","0","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","<link href=\"https://fonts.googleapis.com/css?family=Great+Vibes|Lato\" rel=\"stylesheet\">\r\n<div id=\"ppsPopupShell_[ID]\" class=\"ppsPopupShell ppsPopupListsShell\">\r\n	<a href=\"#\" class=\"ppsPopupClose ppsPopupClose_[close_btn]\"></a>\r\n	<div class=\"ppsInnerTblContent\">\r\n		<div class=\"ppsPopupListsInner ppsPopupInner\">\r\n			[if bg_type_1 == \"img\"]\r\n			<div class=\"ppsWrapImgCrn ppsWrapImgLftCrn\">\r\n				<img class=\"ppsImgLftCrn\" src=\"[bg_img_1]\" alt=\"left image\"/>\r\n			</div>\r\n			[endif]\r\n			[if bg_type_2 == \"img\"]\r\n			<div class=\"ppsWrapImgCrn ppsWrapImgRghtCrn\">\r\n				<img class=\"ppsImgRghtCrn\" src=\"[bg_img_2]\" alt=\"rigth image\"/>\r\n			</div>\r\n			[endif]\r\n			[if enb_label]\r\n				<div class=\"ppsPopupLabel ppsPopupListsLabel\">[label]</div>\r\n			[endif]\r\n			<div style=\"clear: both;\"></div>\r\n			[if enb_txt_0]\r\n				<div class=\"ppsPopupTxt ppsPopupClassyTxt ppsPopupClassyTxt_0 ppsPopupTxt_0\">\r\n				[txt_0]\r\n				</div>\r\n			[endif]\r\n			[if enb_txt_1]\r\n				<div class=\"ppsPopupTxt ppsPopupClassyTxt ppsPopupClassyTxt_1 ppsPopupTxt_1\">\r\n				[txt_1]\r\n				</div>\r\n			[endif]\r\n			[if enb_subscribe]\r\n				<div class=\"ppsSubscribeShell\">\r\n					[sub_form_start]\r\n					<div class=\"ppsFormWrap\">\r\n					[sub_fields_html]\r\n					</div><input class=\"butt\" type=\"submit\" name=\"submit\" value=\"[sub_btn_label]\" />\r\n					[sub_form_end]\r\n					<div style=\"clear: both;\"></div>\r\n				</div>\r\n			[endif]\r\n			<div style=\"clear: both;\"></div>\r\n			<div class=\"ppsBottomtCol\">\r\n				[if enb_sm]\r\n					<div style=\"clear: both;\"></div>\r\n					<div class=\"ppsSm\">\r\n					[sm_html]\r\n					</div>\r\n				[endif]\r\n				[if enb_foot_note]\r\n					<div class=\"ppsFootNote\">\r\n					[foot_note]\r\n					</div>\r\n				[endif]\r\n			</div>\r\n		</div>\r\n	</div>\r\n</div>","#ppsPopupShell_[ID] {\r\n	width: [width][width_measure];\r\n  	font-family: \"Great Vibes\";\r\n	font-weight: normal;\r\n	[if bg_type_0 == \"color\"]\r\n	background-color: [bg_color_0];\r\n  	[elseif bg_type_0 == \"img\"]\r\n  	background-image: url(\"[bg_img_0]\");\r\n  	background-repeat: no-repeat;\r\n  	background-size: cover;\r\n  	[endif]\r\n}\r\n#ppsPopupShell_[ID], #ppsPopupShell_[ID] * {\r\n	-webkit-box-sizing: border-box;\r\n	-moz-box-sizing:    border-box;\r\n	box-sizing:         border-box;\r\n}\r\n#ppsPopupShell_[ID] .ppsPopupInner {\r\n	text-align: center;\r\n	color: #fff;\r\n  	width: 100%;\r\n}\r\n\r\n#ppsPopupShell_[ID] .ppsSubscribeShell {\r\n	width: 90%;\r\n	text-align: center;\r\n	display: inline-block;\r\n    margin: 40px 0 30px;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell form {\r\n	display: inline-block;\r\n    position: relative;\r\n    text-align: left;\r\n    width: 60%;\r\n    z-index: 100;\r\n}\r\n\r\n/*For all Elements*/\r\n#ppsPopupShell_[ID] .ppsSubscribeShell input[type=\"email\"],\r\n#ppsPopupShell_[ID] .ppsSubscribeShell input[type=password],\r\n#ppsPopupShell_[ID] .ppsSubscribeShell input[type=\"text\"],\r\n#ppsPopupShell_[ID] .ppsSubscribeShell select,\r\n#ppsPopupShell_[ID] .ppsSubscribeShell textarea {\r\n	font-family: \"Lato\";\r\n	font-size: 15px;\r\n	font-weight: normal;\r\n	border: 3px solid #fff;\r\n  	padding: 0 0 0 20px;\r\n	margin: 10px 0 0;\r\n	color: #fff;\r\n	width: 100%;\r\n	display: block;\r\n	vertical-align: top;\r\n	outline: none;\r\n	-webkit-border-radius: 0px;\r\n	-moz-border-radius: 0px;\r\n	border-radius: 0px;\r\n	\r\n  	[if bg_type_4 == \"color\"]\r\n  	background-color: [bg_color_4];\r\n    [elseif bg_type_4 == \"img\"]\r\n  	background-image: url(\"[bg_img_4]\");\r\n  	background-repeat: no-repeat;\r\n  	background-size: cover;\r\n	[else]\r\n	background-color: transparent;\r\n  	[endif]\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell select  {\r\n	margin-top: 0;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeForm input:first-child {\r\n	margin-top: 0px;\r\n}\r\n\r\n#ppsPopupShell_[ID] .ppsSubscribeShell label  {\r\n	font-family: \"Lato\";\r\n	font-size: 15px;\r\n	font-weight: normal;\r\n	display: block;\r\n	width: 100%;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell label  span {\r\n	display: inline-block;\r\n	padding-right: 2px;\r\n	vertical-align: middle;\r\n}\r\n\r\n#ppsPopupShell_[ID] .ppsSubscribeShell input[type=radio],\r\n#ppsPopupShell_[ID] .ppsSubscribeShell input[type=checkbox] {\r\n	vertical-align: middle;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell input[type=\"email\"],\r\n#ppsPopupShell_[ID] .ppsSubscribeShell input[type=password],\r\n#ppsPopupShell_[ID] .ppsSubscribeShell input[type=\"text\"],\r\n#ppsPopupShell_[ID] .ppsSubscribeShell select {\r\n	height: 42px;\r\n}\r\n#ppsPopupShell_[ID] .ppsFormWrap {\r\n	text-align: left;\r\n	width: 65%;\r\n	vertical-align: bottom;\r\n	display: inline-block;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell input[type=submit] {\r\n	font-family: \"Lato\";\r\n	font-size: 20px;\r\n	font-weight: normal;\r\n	width: 30%;\r\n  	text-align: center;\r\n 	cursor: pointer;\r\n  	text-decoration: none;\r\n  	color: #001933;\r\n  	display: inline-block;\r\n	vertical-align: bottom;\r\n	padding: 0px;\r\n	margin: 0;\r\n	border: none;\r\n	outline: none;\r\n	height: 42px;\r\n	-webkit-border-radius: 0px;\r\n	-moz-border-radius: 0px;\r\n	border-radius: 0px;\r\n	\r\n	[if bg_type_3 == \"color\"]\r\n  	background:[bg_color_3] !important;\r\n    [elseif bg_type_3 == \"img\"]\r\n  	background-image: url(\"[bg_img_3]\") !important;\r\n  	background-repeat: no-repeat;\r\n  	background-size: cover;\r\n  	[endif]\r\n}\r\n#ppsPopupShell_[ID] .ppsBottomtCol {\r\n	display: inline-block;\r\n	margin-bottom: 100px;\r\n}\r\n\r\n#ppsPopupShell_[ID] .ppsPopupLabel {\r\n	display: inline-block;\r\n	font-size: 30px;\r\n	width: 90%;\r\n	position: relative;\r\n	margin: 50px 30px 0;\r\n	z-index: 100;\r\n	word-wrap: break-word;\r\n}\r\n#ppsPopupShell_[ID] .ppsPopupTxt {\r\n	width: 90%;\r\n	text-align: center;\r\n	display: inline-block;\r\n	position: relative;\r\n	z-index: 100;\r\n}\r\n#ppsPopupShell_[ID] .ppsPopupTxt  p {\r\n	padding: 0px;\r\n	margin: 0px;\r\n	word-wrap: break-word;\r\n}\r\n#ppsPopupShell_[ID] .ppsPopupTxt_0 {\r\n  	font-size: 50px;\r\n	line-height: 51px;\r\n	margin-top: 30px;\r\n}\r\n#ppsPopupShell_[ID] .ppsPopupTxt_0 p {\r\n	line-height: 51px;\r\n}\r\n#ppsPopupShell_[ID] .ppsPopupTxt_1 {\r\n	margin-top: 30px;\r\n  	font-size: 25px;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubMsg {\r\n	display: block;\r\n	text-align: center;\r\n	width: 100%;\r\n	margin-top: 10px;\r\n}\r\n#ppsPopupShell_[ID] .ppsPopupClose {\r\n	background-repeat: no-repeat;\r\n  	cursor: pointer;\r\n	top: 15px;\r\n  	right: -20px !important;\r\n}\r\n#ppsPopupShell_[ID] .ppsPopupClose.ppsPopupClose_lists_black {\r\n 	top: 0 !important;\r\n  	right: 0 !important;\r\n}\r\n#ppsPopupShell_[ID] .ppsPopupClose:hover {\r\n	opacity: 0.8;\r\n}\r\n#ppsPopupShell_[ID] .ppsFootNote{\r\n	color: #fff;\r\n    font-size: x-small;\r\n    font-style: italic;\r\n    line-height: 14px;\r\n  	margin: 5px 30px;\r\n	word-wrap: break-word;\r\n}\r\n#ppsPopupShell_[ID] .ppsSm{\r\n	margin-top:20px;\r\n}\r\n#ppsPopupShell_[ID] .ppsPopupShell .ppsErrorMsg{\r\n  width: 200px;\r\n}\r\n\r\n#ppsPopupShell_[ID] .ppsWrapImgCrn {\r\n	position: absolute;\r\n}\r\n#ppsPopupShell_[ID] .ppsWrapImgLftCrn {\r\n	top: 20px;\r\n	left: 12px;\r\n}\r\n#ppsPopupShell_[ID] .ppsWrapImgRghtCrn {\r\n	bottom: 20px;\r\n    right: 12px;\r\n}","christmas-mistletoe.png","1","1","1","11","2015-01-10 18:59:43","44"),
("45","XMas Sale","1","0","YTozOntzOjQ6Im1haW4iO2E6MzE6e3M6Nzoic2hvd19vbiI7czo5OiJwYWdlX2xvYWQiO3M6MjM6InNob3dfb25fcGFnZV9sb2FkX2RlbGF5IjtzOjA6IiI7czoyNToic2hvd19vbl9jbGlja19vbl9lbF9kZWxheSI7czoxOiIwIjtzOjI3OiJzaG93X29uX3Njcm9sbF93aW5kb3dfZGVsYXkiO3M6MToiMCI7czozMzoic2hvd19vbl9zY3JvbGxfd2luZG93X3BlcmNfc2Nyb2xsIjtzOjE6IjAiO3M6Mjg6InNob3dfb25fYWZ0ZXJfaW5hY3RpdmVfdmFsdWUiO3M6MjoiMTAiO3M6MjU6InNob3dfb25fbGlua19mb2xsb3dfZGVsYXkiO3M6MToiMCI7czoxNDoidmlzaXRfcGFnZV9jbnQiO3M6MDoiIjtzOjg6ImNsb3NlX29uIjtzOjEzOiJvdmVybGF5X2NsaWNrIjtzOjI2OiJjbG9zZV9vbl9hZnRlcl9hY3Rpb25fdGltZSI7czoxOiIxIjtzOjI1OiJjbG9zZV9vbl9hZnRlcl90aW1lX3ZhbHVlIjtzOjE6IjUiO3M6MTA6InNob3dfcGFnZXMiO3M6MzoiYWxsIjtzOjE0OiJzaG93X3RpbWVfZnJvbSI7czo3OiIxMjowMGFtIjtzOjEyOiJzaG93X3RpbWVfdG8iO3M6NzoiMTI6MDBhbSI7czoxNDoic2hvd19kYXRlX2Zyb20iO3M6MDoiIjtzOjEyOiJzaG93X2RhdGVfdG8iO3M6MDoiIjtzOjc6InNob3dfdG8iO3M6ODoiZXZlcnlvbmUiO3M6Mjk6InNob3dfdG9fZmlyc3RfdGltZV92aXNpdF9kYXlzIjtzOjI6IjMwIjtzOjMwOiJzaG93X3RvX3VudGlsX21ha2VfYWN0aW9uX2RheXMiO3M6MjoiMzAiO3M6MTU6ImNvdW50X3RpbWVzX251bSI7czoxOiIxIjtzOjE1OiJjb3VudF90aW1lc19tZXMiO3M6MzoiZGF5IjtzOjIxOiJoaWRlX2Zvcl9kZXZpY2VzX3Nob3ciO3M6MToiMCI7czoyNDoiaGlkZV9mb3JfcG9zdF90eXBlc19zaG93IjtzOjE6IjAiO3M6MTc6ImhpZGVfZm9yX2lwc19zaG93IjtzOjE6IjAiO3M6MTI6ImhpZGVfZm9yX2lwcyI7czowOiIiO3M6MjM6ImhpZGVfZm9yX2NvdW50cmllc19zaG93IjtzOjE6IjAiO3M6MjM6ImhpZGVfZm9yX2xhbmd1YWdlc19zaG93IjtzOjE6IjAiO3M6MjQ6ImhpZGVfc2VhcmNoX2VuZ2luZXNfc2hvdyI7czoxOiIwIjtzOjE4OiJoaWRlX3ByZWdfdXJsX3Nob3ciO3M6MToiMCI7czoxMzoiaGlkZV9wcmVnX3VybCI7czowOiIiO3M6MjQ6ImhpZGVfZm9yX3VzZXJfcm9sZXNfc2hvdyI7czoxOiIwIjt9czozOiJ0cGwiO2E6MTI0OntzOjU6IndpZHRoIjtzOjM6IjY3NSI7czoxMzoid2lkdGhfbWVhc3VyZSI7czoyOiJweCI7czoxODoiYmdfb3ZlcmxheV9vcGFjaXR5IjtzOjM6IjAuNSI7czoxNToiYmdfb3ZlcmxheV90eXBlIjtzOjU6ImNvbG9yIjtzOjE2OiJiZ19vdmVybGF5X2NvbG9yIjtzOjQ6IiMwMDAiO3M6MTQ6ImJnX292ZXJsYXlfaW1nIjtzOjA6IiI7czoxODoiYmdfb3ZlcmxheV9pbWdfcG9zIjtzOjc6InN0cmV0Y2giO3M6OToiYmdfdHlwZV8wIjtzOjU6ImNvbG9yIjtzOjg6ImJnX2ltZ18wIjtzOjA6IiI7czoxMDoiYmdfY29sb3JfMCI7czo3OiIjZmZmZmZmIjtzOjk6ImJnX3R5cGVfMSI7czozOiJpbWciO3M6ODoiYmdfaW1nXzEiO3M6NTI6IltQUFNfQVNTRVRTX1VSTF1pbWcvYXNzZXRzLzIwMTYtcTM1OS14bWFzX3JpYmJvbi5wbmciO3M6MTA6ImJnX2NvbG9yXzEiO3M6NzoiI2ZmZmZmZiI7czo5OiJiZ190eXBlXzIiO3M6NToiY29sb3IiO3M6ODoiYmdfaW1nXzIiO3M6MDoiIjtzOjEwOiJiZ19jb2xvcl8yIjtzOjc6IiNhZWQxZGUiO3M6OToiYmdfdHlwZV8zIjtzOjU6ImNvbG9yIjtzOjg6ImJnX2ltZ18zIjtzOjA6IiI7czoxMDoiYmdfY29sb3JfMyI7czo3OiIjZjQxMzBmIjtzOjk6ImJnX3R5cGVfNCI7czo1OiJjb2xvciI7czo4OiJiZ19pbWdfNCI7czowOiIiO3M6MTA6ImJnX2NvbG9yXzQiO3M6NzoiI2ZmZmZmZiI7czoxMDoiZm9udF9sYWJlbCI7czoxMDoiQWxleCBCcnVzaCI7czoxNjoibGFiZWxfZm9udF9jb2xvciI7czo3OiIjZmZmZmZmIjtzOjEwOiJmb250X3R4dF8wIjtzOjEyOiJKb3NlZmluIFNhbnMiO3M6MTc6InRleHRfZm9udF9jb2xvcl8wIjtzOjc6IiNmZmZmZmYiO3M6MTE6ImZvbnRfZm9vdGVyIjtzOjEyOiJKb3NlZmluIFNhbnMiO3M6MTc6ImZvb3Rlcl9mb250X2NvbG9yIjtzOjc6IiM0ZjRmNGYiO3M6MTc6InJlaWRyZWN0X29uX2Nsb3NlIjtzOjA6IiI7czo5OiJjbG9zZV9idG4iO3M6NDoibm9uZSI7czo3OiJidWxsZXRzIjtzOjg6InBvcF9pY29uIjtzOjE5OiJsYXllcl9yZWxfc2VsZWN0b3JzIjtzOjA6IiI7czoxMToibGF5ZXJlZF9wb3MiO3M6MzoidG9wIjtzOjU6ImxhYmVsIjtzOjE1OiJDaHJpc3RtYXMgUGFydHkiO3M6OToiZW5iX3R4dF8wIjtzOjE6IjEiO3M6OToiZm9vdF9ub3RlIjtzOjExODoiV2UgcmVzcGVjdCB5b3VyIHByaXZhY3kuIFlvdXIgaW5mb3JtYXRpb24gd2lsbCBub3QgYmUgc2hhcmVkIHdpdGggYW55IHRoaXJkIHBhcnR5IGFuZCB5b3UgY2FuIHVuc3Vic2NyaWJlIGF0IGFueSB0aW1lICI7czoxNToiZW5iX3NtX2ZhY2Vib29rIjtzOjE6IjEiO3M6MTc6ImVuYl9zbV9nb29nbGVwbHVzIjtzOjE6IjEiO3M6MTQ6ImVuYl9zbV90d2l0dGVyIjtzOjE6IjEiO3M6OToic21fZGVzaWduIjtzOjQ6ImJveHkiO3M6ODoiYW5pbV9rZXkiO3M6MTA6InNsaWRlX2Rvd24iO3M6MTQ6ImFuaW1fY2xvc2Vfa2V5IjtzOjA6IiI7czoxMzoiYW5pbV9kdXJhdGlvbiI7czowOiIiO3M6MTk6ImFuaW1fY2xvc2VfZHVyYXRpb24iO3M6MDoiIjtzOjEzOiJlbmJfc3Vic2NyaWJlIjtzOjE6IjEiO3M6ODoic3ViX2Rlc3QiO3M6OToid29yZHByZXNzIjtzOjIzOiJzdWJfd3BfY3JlYXRlX3VzZXJfcm9sZSI7czoxMDoic3Vic2NyaWJlciI7czoyMzoic3ViX2NvbmZpcm1fcmVsb2FkX3RpbWUiO3M6MjoiMTAiO3M6MTk6InN1Yl9hd2ViZXJfbGlzdG5hbWUiO3M6MDoiIjtzOjIxOiJzdWJfYXdlYmVyX2FkdHJhY2tpbmciO3M6MDoiIjtzOjIxOiJzdWJfbWFpbGNoaW1wX2FwaV9rZXkiO3M6MDoiIjtzOjI1OiJzdWJfbWFpbGNoaW1wX2dyb3Vwc19mdWxsIjtzOjA6IiI7czoxNDoic3ViX2dyX2FwaV9rZXkiO3M6MDoiIjtzOjE2OiJzdWJfZ3JfY3ljbGVfZGF5IjtzOjE6IjAiO3M6MTM6InN1Yl9pY19hcHBfaWQiO3M6MDoiIjtzOjE1OiJzdWJfaWNfYXBwX3VzZXIiO3M6MDoiIjtzOjE1OiJzdWJfaWNfYXBwX3Bhc3MiO3M6MDoiIjtzOjE0OiJzdWJfYWNfYXBpX3VybCI7czowOiIiO3M6MTQ6InN1Yl9hY19hcGlfa2V5IjtzOjA6IiI7czoxODoic3ViX2FyX2Zvcm1fYWN0aW9uIjtzOjA6IiI7czoxMDoic3ViX3NnYV9pZCI7czowOiIiO3M6MTU6InN1Yl9zZ2FfbGlzdF9pZCI7czowOiIiO3M6MjE6InN1Yl9zZ2FfYWN0aXZhdGVfY29kZSI7czowOiIiO3M6MTM6InN1Yl9zZl9hcHBfaWQiO3M6MDoiIjtzOjE0OiJzdWJfY2tfYXBpX2tleSI7czowOiIiO3M6MTQ6InN1Yl9tZW1fYWNjX2lkIjtzOjA6IiI7czoxNToic3ViX21lbV9wdWRfa2V5IjtzOjA6IiI7czoxNjoic3ViX21lbV9wcml2X2tleSI7czowOiIiO3M6MTQ6InN1Yl9zYl9hcGlfa2V5IjtzOjA6IiI7czoxNDoic3ViX3Y2X2FwaV9rZXkiO3M6MDoiIjtzOjEyOiJzdWJfdnRpZ191cmwiO3M6MDoiIjtzOjEzOiJzdWJfdnRpZ19uYW1lIjtzOjA6IiI7czoxMjoic3ViX3Z0aWdfa2V5IjtzOjA6IiI7czoxNjoic3ViX3ltbHBfYXBpX2tleSI7czowOiIiO3M6MTM6InN1Yl95bWxwX25hbWUiO3M6MDoiIjtzOjExOiJzdWJfNGRfbmFtZSI7czowOiIiO3M6MTE6InN1Yl80ZF9wYXNzIjtzOjA6IiI7czoxNjoic3ViX2Rtc19hcGlfdXNlciI7czowOiIiO3M6MjA6InN1Yl9kbXNfYXBpX3Bhc3N3b3JkIjtzOjA6IiI7czoxMzoic3ViX2Rtc19vcHRpbiI7czo3OiJVbmtub3duIjtzOjE1OiJzdWJfbW1fdXNlcm5hbWUiO3M6MDoiIjtzOjE0OiJzdWJfbW1fYXBpX2tleSI7czowOiIiO3M6MTA6InN1Yl9maWVsZHMiO2E6Mjp7czo0OiJuYW1lIjthOjc6e3M6NDoibmFtZSI7czo0OiJuYW1lIjtzOjQ6Imh0bWwiO3M6NDoidGV4dCI7czo1OiJsYWJlbCI7czo0OiJOYW1lIjtzOjU6InZhbHVlIjtzOjA6IiI7czo2OiJjdXN0b20iO3M6MToiMCI7czo5OiJtYW5kYXRvcnkiO3M6MToiMCI7czoxMDoic2V0X3ByZXNldCI7czowOiIiO31zOjU6ImVtYWlsIjthOjg6e3M6NDoibmFtZSI7czo1OiJlbWFpbCI7czo0OiJodG1sIjtzOjQ6InRleHQiO3M6NToibGFiZWwiO3M6NjoiRS1NYWlsIjtzOjU6InZhbHVlIjtzOjA6IiI7czo2OiJjdXN0b20iO3M6MToiMCI7czo5OiJtYW5kYXRvcnkiO3M6MToiMSI7czoxMDoic2V0X3ByZXNldCI7czowOiIiO3M6MzoiZW5iIjtzOjE6IjEiO319czoxMzoiY2FwdF9zaXRlX2tleSI7czowOiIiO3M6MTU6ImNhcHRfc2VjcmV0X2tleSI7czowOiIiO3M6OToiYmxhY2tsaXN0IjtzOjA6IiI7czoxNToiYmxhY2tsaXN0X2Vycm9yIjtzOjI2OiJZb3VyIGVtYWlsIGlzIGluIGJsYWNrbGlzdCI7czoyMDoic3ViX3R4dF9jb25maXJtX3NlbnQiO3M6Njc6IkNvbmZpcm1hdGlvbiBsaW5rIHdhcyBzZW50IHRvIHlvdXIgZW1haWwgYWRkcmVzcy4gQ2hlY2sgeW91ciBlbWFpbCEiO3M6MTU6InN1Yl90eHRfc3VjY2VzcyI7czoyNDoiVGhhbmsgeW91IGZvciBzdWJzY3JpYmUhIjtzOjIxOiJzdWJfdHh0X2ludmFsaWRfZW1haWwiO3M6MjI6IkVtcHR5IG9yIGludmFsaWQgZW1haWwiO3M6MjA6InN1Yl90eHRfZXhpc3RzX2VtYWlsIjtzOjIzOiJFbXB0eSAgb3IgaW52YWxpZCBlbWFpbCI7czoxNjoic3ViX3JlZGlyZWN0X3VybCI7czowOiIiO3M6Mjg6InN1Yl90eHRfY29uZmlybV9tYWlsX3N1YmplY3QiO3M6MzQ6IkNvbmZpcm0gc3Vic2NyaXB0aW9uIG9uIFtzaXRlbmFtZV0iO3M6MjU6InN1Yl90eHRfY29uZmlybV9tYWlsX2Zyb20iO3M6MTU6ImFkbWluQGdtYWlsLmNvbSI7czoyODoic3ViX3R4dF9jb25maXJtX21haWxfbWVzc2FnZSI7czoxOTc6IllvdSBzdWJzY3JpYmVkIG9uIHNpdGUgPGEgaHJlZj1cIltzaXRldXJsXVwiPltzaXRlbmFtZV08L2E+LiBGb2xsb3cgPGEgaHJlZj1cIltjb25maXJtX2xpbmtdXCI+dGhpcyBsaW5rPC9hPiB0byBjb21wbGV0ZSB5b3VyIHN1YnNjcmlwdGlvbi4gSWYgeW91IGRpZCBub3Qgc3Vic2NyaWJlIGhlcmUgLSBqdXN0IGlnbm9yZSB0aGlzIG1lc3NhZ2UuIjtzOjMxOiJzdWJfdHh0X3N1YnNjcmliZXJfbWFpbF9zdWJqZWN0IjtzOjM3OiJbc2l0ZW5hbWVdIFlvdXIgdXNlcm5hbWUgYW5kIHBhc3N3b3JkIjtzOjI4OiJzdWJfdHh0X3N1YnNjcmliZXJfbWFpbF9mcm9tIjtzOjE1OiJhZG1pbkBnbWFpbC5jb20iO3M6MzE6InN1Yl90eHRfc3Vic2NyaWJlcl9tYWlsX21lc3NhZ2UiO3M6NjU6IlVzZXJuYW1lOiBbdXNlcl9sb2dpbl08YnIgLz5QYXNzd29yZDogW3Bhc3N3b3JkXTxiciAvPltsb2dpbl91cmxdIjtzOjI1OiJzdWJfcmVkaXJlY3RfZW1haWxfZXhpc3RzIjtzOjA6IiI7czoxMzoic3ViX2J0bl9sYWJlbCI7czoxNzoiR0VUIFlPVVIgRElTQ09VTlQiO3M6MTM6InN1Yl9uZXdfZW1haWwiO3M6MTU6ImFkbWluQGdtYWlsLmNvbSI7czoxNToic3ViX25ld19zdWJqZWN0IjtzOjI5OiJOZXcgc3Vic2NyaWJlciBmb3IgW3NpdGVuYW1lXSI7czoxNToic3ViX25ld19tZXNzYWdlIjtzOjEyOToiWW91IGhhdmUgbmV3IHN1YnNjcmliZXIgb24geW91ciBzaXRlIDxhIGhyZWY9XCJbc2l0ZXVybF1cIj5bc2l0ZW5hbWVdPC9hPiwgaGVyZSBpcyBzdWJzY3JpYmVyIGluZm9ybWF0aW9uOjxiciAvPltzdWJzY3JpYmVyX2RhdGFdIjtzOjg6ImxvZ2luX2J5IjtzOjg6InVzZXJuYW1lIjtzOjE4OiJsb2dpbl9yZWRpcmVjdF91cmwiO3M6MDoiIjtzOjE1OiJsb2dpbl9idG5fbGFiZWwiO3M6NToiTG9naW4iO3M6MjM6InJlZ193cF9jcmVhdGVfdXNlcl9yb2xlIjtzOjEwOiJzdWJzY3JpYmVyIjtzOjEzOiJyZWdfYnRuX2xhYmVsIjtzOjg6IlJlZ2lzdGVyIjtzOjEwOiJyZWdfZmllbGRzIjthOjI6e3M6NDoibmFtZSI7YTo3OntzOjM6ImVuYiI7czoxOiIxIjtzOjQ6Im5hbWUiO3M6NDoibmFtZSI7czo0OiJodG1sIjtzOjQ6InRleHQiO3M6NToibGFiZWwiO3M6Njoi0JjQvNGPIjtzOjU6InZhbHVlIjtzOjA6IiI7czo2OiJjdXN0b20iO3M6MToiMCI7czo5OiJtYW5kYXRvcnkiO3M6MToiMCI7fXM6NToiZW1haWwiO2E6Nzp7czo0OiJuYW1lIjtzOjU6ImVtYWlsIjtzOjQ6Imh0bWwiO3M6NDoidGV4dCI7czo1OiJsYWJlbCI7czo2OiJFLU1haWwiO3M6NToidmFsdWUiO3M6MDoiIjtzOjY6ImN1c3RvbSI7czoxOiIwIjtzOjk6Im1hbmRhdG9yeSI7czoxOiIxIjtzOjM6ImVuYiI7czoxOiIxIjt9fXM6MjA6InJlZ190eHRfY29uZmlybV9zZW50IjtzOjc0OiJBIHZlcmlmaWNhdGlvbiBsaW5rIGhhcyBiZWVuIHNlbnQgdG8geW91ciBlbWFpbCBhZGRyZXNzLiBDaGVjayB5b3VyIGVtYWlsISI7czoxNToicmVnX3R4dF9zdWNjZXNzIjtzOjI2OiJUaGFuayB5b3UgZm9yIHJlZ2lzdGVyaW5nISI7czoyMToicmVnX3R4dF9pbnZhbGlkX2VtYWlsIjtzOjIzOiIgRW1wdHkgb3IgaW52YWxpZCBlbWFpbCI7czoxNjoicmVnX3JlZGlyZWN0X3VybCI7czowOiIiO3M6Mjg6InJlZ190eHRfY29uZmlybV9tYWlsX3N1YmplY3QiO3M6MzQ6IkNvbmZpcm0gcmVnaXN0cmF0aW9uIG9uIFtzaXRlbmFtZV0iO3M6MjU6InJlZ190eHRfY29uZmlybV9tYWlsX2Zyb20iO3M6MTU6ImFkbWluQGdtYWlsLmNvbSI7czoyODoicmVnX3R4dF9jb25maXJtX21haWxfbWVzc2FnZSI7czoyMDY6IllvdSBhcmUgcmVnaXN0ZXJlZCBvbiB0aGUgc2l0ZSA8YSBocmVmPVwiW3NpdGV1cmxdXCI+W3NpdGVuYW1lXTwvYT4uIEZvbGxvdyAgPGEgaHJlZj1cIltjb25maXJtX2xpbmtdXCI+dGhpcyBsaW5rPC9hPiB0byBjb21wbGV0ZSB0aGUgcmVnaXN0cmF0aW9uLiBJZiB5b3UgYXJlIG5vdCByZWdpc3RlcmVkIGhlcmUgLSBqdXN0IGlnbm9yZSB0aGlzIG1lc3NhZ2UuIjtzOjMxOiJyZWdfdHh0X3N1YnNjcmliZXJfbWFpbF9zdWJqZWN0IjtzOjM4OiJbc2l0ZW5hbWVdICBZb3VyIHVzZXJuYW1lIGFuZCBwYXNzd29yZCI7czoyODoicmVnX3R4dF9zdWJzY3JpYmVyX21haWxfZnJvbSI7czoxNToiYWRtaW5AZ21haWwuY29tIjtzOjMxOiJyZWdfdHh0X3N1YnNjcmliZXJfbWFpbF9tZXNzYWdlIjtzOjYyOiJMb2dpbjogW3VzZXJfbG9naW5dPGJyIC8+UGFzc3dvcmQ6IFtwYXNzd29yZF08YnIgLz5bbG9naW5fdXJsXSI7czoxMzoicmVnX25ld19lbWFpbCI7czoxNToiYWRtaW5AZ21haWwuY29tIjtzOjE1OiJyZWdfbmV3X21lc3NhZ2UiO3M6MTE1OiJZb3UgaGF2ZSBhIG5ldyB1c2VyIG9uIHRoZSBzaXRlIDxhIGhyZWY9XCJbc2l0ZXVybF1cIj5bc2l0ZW5hbWVdPC9hPiwgaGVyZSBpcyB0aGUgdXNlciBpbmZvOjxiciAvPltzdWJzY3JpYmVyX2RhdGFdIjtzOjEyOiJjb250YWN0X2Zvcm0iO3M6MjoiMTEiO3M6MTI6InN0YXRfZ2FfY29kZSI7czowOiIiO3M6NToidHh0XzAiO3M6NzE6IjxwPldlIGhhdmUgc29tZXRoaW5nIGZvciBFVkVSWU9ORSBvbiBZT1VSIGxpc3QuIFNhdmUgVXAgdG8gNzAlIE9GRiE8L3A+Ijt9czoxMDoib3B0c19hdHRycyI7YToyOntzOjk6ImJnX251bWJlciI7czoxOiI1IjtzOjE2OiJ0eHRfYmxvY2tfbnVtYmVyIjtzOjE6IjEiO319","<link href=\"https://fonts.googleapis.com/css?family=Oxygen\" rel=\"stylesheet\">\r\n<div id=\"ppsPopupShell_[ID]\" class=\"ppsPopupShell ppsPopupListsShell\">\r\n	<a href=\"#\" class=\"ppsPopupClose ppsPopupClose_[close_btn]\"></a>\r\n	<div class=\"ppsInnerTblContent\">\r\n		<div class=\"ppsPopupListsInner ppsPopupInner\">\r\n			<div class=\"ppsTopBgWrapper\">\r\n				<div class=\"ppsWrapImgWr\">\r\n					[if bg_type_1 == \"img\"]\r\n					<img src=\"[bg_img_1]\" class=\"ppsImgWr\"/>\r\n					[endif]\r\n				</div>\r\n				[if enb_label]\r\n					<div class=\"ppsPopupLabel ppsPopupListsLabel\">[label]</div>\r\n				[endif]\r\n				[if enb_txt_0]\r\n					<div class=\"ppsPopupTxt ppsPopupClassyTxt ppsPopupClassyTxt_0 ppsPopupTxt_0\">\r\n					[txt_0]\r\n					</div>\r\n				[endif]\r\n				<div class=\"ppsSnow\"></div>\r\n			</div>\r\n			<div style=\"clear: both;\"></div>\r\n			[if enb_subscribe]\r\n				<div class=\"ppsSubscribeShell\">\r\n					[sub_form_start]\r\n					[sub_fields_html]\r\n					<input class=\"butt\" type=\"submit\" name=\"submit\" value=\"[sub_btn_label]\" />\r\n					[sub_form_end]\r\n					<div style=\"clear: both;\"></div>\r\n				</div>\r\n			[endif]\r\n			<div style=\"clear: both;\"></div>\r\n			[if enb_sm]\r\n				<div style=\"clear: both;\"></div>\r\n				<div class=\"ppsSm\">\r\n				[sm_html]\r\n				</div>\r\n				\r\n			[endif]\r\n			[if enb_foot_note]\r\n				<div class=\"ppsFootNote\">\r\n				[foot_note]\r\n				</div>\r\n			[endif]\r\n			<div class=\"\"></div>\r\n		</div>\r\n	</div>\r\n</div>","#ppsPopupShell_[ID] {\r\n	width: [width][width_measure];\r\n  	font-family: \"Oxygen\";\r\n	font-size: 13px;\r\n	line-height: 21px;\r\n	font-weight: normal;\r\n	color: #fff;\r\n}\r\n#ppsPopupShell_[ID] .ppsInnerTblContent {\r\n}\r\n#ppsPopupShell_[ID] .ppsPopupInner {\r\n	[if bg_type_0 == \"color\"]\r\n	background-color: [bg_color_0];\r\n  	[elseif bg_type_0 == \"img\"]\r\n  	background-image: url(\"[bg_img_0]\");\r\n  	background-repeat: no-repeat;\r\n  	background-size: cover;\r\n  	[endif]\r\n	\r\n	position: relative;\r\n	text-align: center;\r\n	padding: 0 0 30px;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell form {\r\n\r\n}\r\n\r\n/*For all Elements*/\r\n#ppsPopupShell_[ID] .ppsSubscribeShell input[type=\"email\"],\r\n#ppsPopupShell_[ID] .ppsSubscribeShell input[type=\"text\"],\r\n#ppsPopupShell_[ID] .ppsSubscribeShell select,\r\n#ppsPopupShell_[ID] .ppsSubscribeShell textarea {\r\n    \r\n    color: #4f4f4f;\r\n	text-align: center;\r\n	border: 2px solid #aaa;\r\n	font-family: \"Oxygen\";\r\n	font-size: 16px;\r\n	font-weight: normal;\r\n	width: 100%;\r\n	display:block;\r\n	margin-top: 10px;\r\n	height: 45px;\r\n	\r\n	-webkit-border-radius: 5px;\r\n	-moz-border-radius: 5px;\r\n	border-radius: 5px;\r\n	[if bg_type_4 == \"color\"]\r\n	background: [bg_color_4];\r\n  	[elseif bg_type_4 == \"img\"]\r\n  	background-image: url(\"[bg_img_4]\");\r\n  	background-repeat: no-repeat;\r\n  	background-size: cover;\r\n  	[endif]\r\n}\r\n\r\n#ppsPopupShell_[ID] .ppsSubscribeForm input:first-child {\r\n	margin-top: 0px;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell textarea {\r\n	height: auto;\r\n	padding-top: 9px;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell select  {\r\n	display:inline-block;\r\n	margin-top: 0px\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell label  {\r\n	margin-top: 10px;\r\n	font-size: 16px;\r\n    color: #4f4f4f;\r\n	text-align: center;\r\n	display: block;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell label  span {\r\n	display: inline-block;\r\n	padding-right: 2px;\r\n	vertical-align: middle;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell input[type=radio],\r\n#ppsPopupShell_[ID] .ppsSubscribeShell input[type=checkbox] {\r\n	vertical-align: middle;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell input[type=text],#ppsPopupShell_[ID] .ppsSubscribeShell input[type=email],#ppsPopupShell_[ID] .ppsSubscribeShell input[type=password],\r\n#ppsPopupShell_[ID] .ppsSubscribeShell input[type=email] {\r\n    \r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell input[type=submit] {\r\n	display:block;\r\n	height: 45px;\r\n  	color: #fff;\r\n    font-size: 18px;\r\n	width: 100%;\r\n	margin: 10px 0;\r\n	-webkit-border-radius: 5px;\r\n	-moz-border-radius: 5px;\r\n	border-radius: 5px;\r\n	border: 0 solid transparent;\r\n  	cursor: pointer;\r\n	text-transform: none;\r\n	padding: 0;\r\n	font-weight: 700;\r\n	font-family: \"Oxygen\";\r\n	[if bg_type_3 == \"color\"]\r\n	background: [bg_color_3];\r\n  	[elseif bg_type_3 == \"img\"]\r\n  	background-image: url(\"[bg_img_3]\");\r\n  	background-repeat: no-repeat;\r\n  	background-size: cover;\r\n  	[endif]\r\n}\r\n\r\n#ppsPopupShell_[ID] .ppsSubscribeShell {\r\n    display: inline-block;\r\n    margin: 40px 0 0;\r\n    width: 40%;\r\n	position: relative;\r\n	z-index: 100;\r\n}\r\n#ppsPopupShell_[ID] .ppsTopBgWrapper {\r\n	[if bg_type_2 == \"color\"]\r\n	background: [bg_color_2];\r\n  	[elseif bg_type_2 == \"img\"]\r\n  	background-image: url(\"[bg_img_2]\");\r\n  	background-repeat: no-repeat;\r\n  	background-size: cover;\r\n  	[endif]\r\n	\r\n	padding: 30px 0;\r\n	position: relative;\r\n}\r\n#ppsPopupShell_[ID] .ppsWrapImgWr {\r\n	display: inline-block;\r\n    text-align: center;\r\n    width: 100%;\r\n}\r\n#ppsPopupShell_[ID] .ppsImgWr {\r\n	display: inline-block;\r\n	max-width: 100%;\r\n}\r\n#ppsPopupShell_[ID] .ppsPopupLabel {\r\n	font-size: 50px;\r\n	font-family: \"Oxygen\";\r\n	position: relative;\r\n	z-index: 100;\r\n	width: 90%;\r\n	display: inline-block;\r\n	padding-top: 30px;\r\n	word-wrap: break-word;\r\n}\r\n#ppsPopupShell_[ID] .ppsPopupTxt {\r\n	margin: 0;\r\n	padding: 0;\r\n	text-align: center;\r\n	font-family: \"Oxygen\";\r\n}\r\n#ppsPopupShell_[ID] .ppsPopupTxt p {\r\n	display: inline-block;\r\n    margin: 0;\r\n    padding: 0;\r\n    width: 90%;\r\n	position: relative;\r\n	z-index: 100;\r\n	word-wrap: break-word;\r\n}\r\n#ppsPopupShell_[ID] .ppsPopupTxt_0 {\r\n    font-size: 20px;\r\n	padding-top: 30px;\r\n	font-weight: bold;\r\n}\r\n\r\n#ppsPopupShell_[ID] .ppsPopupClose {\r\n	background-repeat: no-repeat;\r\n  	cursor: pointer;\r\n	top: 15px;\r\n}\r\n#ppsPopupShell_[ID] .ppsPopupClose.ppsPopupClose_lists_black {\r\n 	top: 0 !important;\r\n  	right: 0 !important;\r\n}\r\n#ppsPopupShell_[ID] .ppsPopupClose:hover {\r\n	opacity: 0.8;\r\n}\r\n#ppsPopupShell_[ID] .ppsFootNote{\r\n    display: inline-block;\r\n    font-size: x-small;\r\n    font-style: italic;\r\n    line-height: 14px;\r\n	color: #4f4f4f;\r\n    margin: 5px 0px;\r\n    text-align: center;\r\n    width: 80%;\r\n	word-wrap: break-word;\r\n}\r\n#ppsPopupShell_[ID] .ppsSm{\r\n	margin-top:20px;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubMsg{\r\n	clear: both;\r\n  	text-align: center;\r\n}","x-mas-sale.png","1","1","1","11","2015-01-10 18:59:43","45"),
("46","Merry Christmas","1","0","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","<link href=\"https://fonts.googleapis.com/css?family=Gentium+Basic\" rel=\"stylesheet\">\r\n<div id=\"ppsPopupShell_[ID]\" class=\"ppsPopupShell ppsPopupListsShell\">\r\n	<a href=\"#\" class=\"ppsPopupClose ppsPopupClose_[close_btn]\"></a>\r\n	<div class=\"ppsInnerTblContent\">\r\n		<div class=\"ppsPopupListsInner ppsPopupInner\">\r\n			<div class=\"ppsWrapTopImg\">\r\n				[if bg_type_1 == \"img\"]\r\n				<img src=\"[bg_img_1]\" class=\"ppsTopImg\"/>\r\n				[endif]\r\n			</div>\r\n			[if enb_label]\r\n				<div class=\"ppsPopupLabel ppsPopupListsLabel\">[label]</div>\r\n			[endif]\r\n			<div style=\"clear: both;\"></div>\r\n			[if enb_txt_0]\r\n				<div class=\"ppsPopupTxt ppsPopupClassyTxt ppsPopupClassyTxt_0 ppsPopupTxt_0\">\r\n				[txt_0]\r\n				</div>\r\n			[endif]\r\n			[if enb_subscribe]\r\n				<div class=\"ppsSubscribeShell\">\r\n					[sub_form_start]\r\n					[sub_fields_html]\r\n					<input type=\"submit\" name=\"submit\" value=\"[sub_btn_label]\" />\r\n					[sub_form_end]\r\n					<div style=\"clear: both;\"></div>\r\n				</div>\r\n			[endif]\r\n			<div style=\"clear: both;\"></div>\r\n			<div class=\"ppsBottomCol\">\r\n				[if enb_sm]\r\n					<div style=\"clear: both;\"></div>\r\n					<div class=\"ppsSm\">\r\n					[sm_html]\r\n					</div>\r\n				[endif]\r\n				[if enb_foot_note]\r\n					<div class=\"ppsFootNote\">\r\n					[foot_note]\r\n					</div>\r\n				[endif]\r\n			</div>\r\n		</div>\r\n	</div>\r\n</div>","#ppsPopupShell_[ID] {\r\n	width: [width][width_measure];\r\n  	font-family: \"Gentium Basic\", arial;\r\n	font-size: 13px;\r\n	font-weight: normal;\r\n	color: #000;\r\n  	text-align: center;\r\n}\r\n\r\n#ppsPopupShell_[ID], #ppsPopupShell_[ID] * {\r\n	-webkit-box-sizing: border-box;\r\n	-moz-box-sizing:    border-box;\r\n	box-sizing:         border-box;\r\n}\r\n#ppsPopupShell_[ID] .ppsInnerTblContent {\r\n  	width: 100%;\r\n}\r\n#ppsPopupShell_[ID] .ppsPopupInner {\r\n  	width: 100%;\r\n  	padding: 40px;\r\n	[if bg_type_0 == \"color\"]\r\n	background-color: [bg_color_0];\r\n  	[elseif bg_type_0 == \"img\"]\r\n  	background-image: url(\"[bg_img_0]\");\r\n  	background-repeat: no-repeat;\r\n  	background-size: cover;\r\n  	[endif]\r\n}\r\n#ppsPopupShell_[ID] .ppsWrapTopImg {\r\n	display: inline-block;\r\n    text-align: center;\r\n    width: 100%;\r\n	margin-bottom: 30px;\r\n}\r\n#ppsPopupShell_[ID] .ppsTopImg {\r\n	display: inline-block;\r\n	max-width: 100%;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell {\r\n	min-height: 200px;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell form {\r\n	width: 60%;\r\n	display: inline-block;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeForm input:first-child {\r\n	margin-top: 0px;\r\n}\r\n/*For all Elements*/\r\n#ppsPopupShell_[ID] .ppsSubscribeShell input[type=\"email\"],\r\n#ppsPopupShell_[ID] .ppsSubscribeShell input[type=password],\r\n#ppsPopupShell_[ID] .ppsSubscribeShell input[type=\"text\"],\r\n#ppsPopupShell_[ID] .ppsSubscribeShell select,\r\n#ppsPopupShell_[ID] .ppsSubscribeShell textarea {\r\n	font-family: \"Gentium Basic\", arial;\r\n	font-size: 17px;\r\n	font-weight: normal;\r\n	border: 1px solid transparent;\r\n	width: 100%;\r\n	display: block;\r\n	-webkit-border-radius: 5px;\r\n	-moz-border-radius: 5px;\r\n	border-radius: 5px;\r\n	height: 41px;\r\n	margin: 10px 0 0;\r\n	text-transform: none;\r\n	\r\n	padding-left: 15px;\r\n	background-image: none;\r\n	background-repeat: no-repeat;\r\n  	background-color: #fff;\r\n	color: #13316c;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell select {\r\n	margin: 0;\r\n	min-height: 41px;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell label  {\r\n	font-family: \"Gentium Basic\", arial;\r\n	font-size: 17px;\r\n	font-weight: normal;\r\n	display: block;\r\n	margin: 10px 0 0;\r\n	text-align: left;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell label  span {\r\n	display: inline-block;\r\n	padding-right: 2px;\r\n	vertical-align: middle;\r\n}\r\n\r\n#ppsPopupShell_[ID] .ppsSubscribeShell input[type=radio],\r\n#ppsPopupShell_[ID] .ppsSubscribeShell input[type=checkbox] {\r\n	vertical-align: middle;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell textarea {\r\n	height: auto;\r\n	padding-top: 9px;\r\n}\r\n\r\n#ppsPopupShell_[ID] .ppsSubscribeShell input[type=text],#ppsPopupShell_[ID] .ppsSubscribeShell input[type=email],#ppsPopupShell_[ID] .ppsSubscribeShell input[type=password], \r\n#ppsPopupShell_[ID] .ppsSubscribeShell input[type=email] {\r\n	padding-left: 35px;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell input[type=text],#ppsPopupShell_[ID] .ppsSubscribeShell input[type=email],#ppsPopupShell_[ID] .ppsSubscribeShell input[type=password] {\r\n	background-image: url(\"[PPS_ASSETS_URL]img/assets/user-black-icon.png\");\r\n	background-position: 12px center;\r\n	\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell input[type=email] {\r\n	background-image: url(\"[PPS_ASSETS_URL]img/assets/email-black-icon.png\");\r\n	background-position: 10px center;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell input[type=submit] {\r\n  	[if bg_type_2 == \"color\"]\r\n	background: [bg_color_2];\r\n	background: -moz-linear-gradient(top, {{ adjust_brightness(popup.params.tpl.bg_color_2, 75) }} 26%, [bg_color_2] 100%);\r\n	background: -webkit-linear-gradient(top, {{ adjust_brightness(popup.params.tpl.bg_color_2, 75) }} 26%,[bg_color_2] 100%);\r\n	background: linear-gradient(to bottom, {{ adjust_brightness(popup.params.tpl.bg_color_2, 75) }} 26%,[bg_color_2] 100%);\r\n	filter: progid:DXImageTransform.Microsoft.gradient( startColorstr=\"{{ adjust_brightness(popup.params.tpl.bg_color_2, 75) }}\", endColorstr=\"[bg_color_2]\",GradientType=0 );\r\n  	[elseif bg_type_2 == \"img\"]\r\n  	background-image: url(\"[bg_img_2]\");\r\n  	background-repeat: no-repeat;\r\n  	background-size: cover;\r\n  	[endif]\r\n	\r\n	-webkit-border-radius: 5px;\r\n	-moz-border-radius: 5px;\r\n	border-radius: 5px;\r\n	height: 41px;\r\n	text-transform: none;\r\n	margin: 10px 0 0;\r\n	-webkit-box-shadow: 2px 2px 6px 2px rgba(0, 0, 0, 0.75);\r\n	-moz-box-shadow: 2px 2px 6px 2px rgba(0, 0, 0, 0.75);\r\n	box-shadow: 2px 2px 6px 2px rgba(0, 0, 0, 0.75);\r\n	padding: 0;\r\n  	cursor: pointer;\r\n	color: #fff;\r\n	font-size: 20px;\r\n	font-family: \"Gentium Basic\", arial;\r\n	font-weight: normal;\r\n	border: 1px solid transparent;\r\n	width: 100%;\r\n	display: block;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell input[type=submit]:hover {\r\n	-webkit-box-shadow: 2px 2px  7px 2px rgba(0, 0, 0, 0.75);\r\n	-moz-box-shadow: 2px 2px  7px 2px rgba(0, 0, 0, 0.75);\r\n	box-shadow: 2px 2px  7px 2px rgba(0, 0, 0, 0.75);\r\n}\r\n#ppsPopupShell_[ID] .ppsPopupLabel {\r\n	font-size: 40px;\r\n	line-height: 40px;\r\n	font-weight: bold;\r\n  	margin: 0 30px 30px;\r\n	word-wrap: break-word;\r\n}\r\n#ppsPopupShell_[ID] .ppsPopupTxt_0 {\r\n  	width: 100%;\r\n	font-size: 14px;\r\n  	margin: 0 30px 20px;\r\n	word-wrap: break-word;\r\n}\r\n#ppsPopupShell_[ID] .ppsPopupClose {\r\n	background-repeat: no-repeat;\r\n  	cursor: pointer;\r\n	top: 15px;\r\n  	right: 10px;\r\n}\r\n#ppsPopupShell_[ID] .ppsPopupClose.ppsPopupClose_lists_black {\r\n 	top: 0 !important;\r\n  	right: 0 !important;\r\n}\r\n#ppsPopupShell_[ID] .ppsPopupClose:hover {\r\n	opacity: 0.8;\r\n}\r\n#ppsPopupShell_[ID] .ppsFootNote {\r\n	color: #585858;\r\n    font-size: x-small;\r\n    font-style: italic;\r\n    line-height: 14px;\r\n  	margin: 5px 30px;\r\n	word-wrap: break-word;\r\n}\r\n#ppsPopupShell_[ID] .ppsSm {\r\n	margin-top:20px;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubMsg {\r\n	margin: 0px;\r\n}","merry-christmas.png","1","1","1","11","2015-01-10 18:59:43","46"),
("47","Christmas Recipes","1","0","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","<link href=\"https://fonts.google.com/?query=Open+sans&selection.family=Open+Sans:400,700\" rel=\"stylesheet\">\r\n<div id=\"ppsPopupShell_[ID]\" class=\"ppsPopupShell ppsPopupListsShell\">\r\n	<a href=\"#\" class=\"ppsPopupClose ppsPopupClose_[close_btn]\"></a>\r\n	<div class=\"ppsInnerTblContent\">\r\n		<div class=\"ppsPopupListsInner ppsPopupInner\">\r\n			<div class=\"ppsTopBgWrapper\">\r\n				<div class=\"ppsWrapImgWr\">\r\n					[if enb_label]\r\n						<div class=\"ppsPopupLabel ppsPopupListsLabel\">[label]</div>\r\n					[endif]\r\n					[if enb_txt_0]\r\n						<div class=\"ppsPopupTxt ppsPopupClassyTxt ppsPopupClassyTxt_0 ppsPopupTxt_0\">\r\n						[txt_0]\r\n						</div>\r\n					[endif]\r\n					[if enb_txt_1]\r\n						<div class=\"ppsPopupTxt ppsPopupClassyTxt ppsPopupClassyTxt_1 ppsPopupTxt_1\">\r\n						[txt_1]\r\n						</div>\r\n					[endif]\r\n				</div>\r\n			</div>\r\n			<div style=\"clear: both;\"></div>\r\n			<div class=\"ppsBtmBgWrapper\">\r\n				[if enb_txt_2]\r\n					<div class=\"ppsPopupTxt ppsPopupClassyTxt ppsPopupClassyTxt_2 ppsPopupTxt_2\">\r\n					[txt_2]\r\n					</div>\r\n				[endif]\r\n				[if enb_subscribe]\r\n					<div class=\"ppsSubscribeShell\">\r\n						[sub_form_start]\r\n						[sub_fields_html]\r\n						<input class=\"butt\" type=\"submit\" name=\"submit\" value=\"[sub_btn_label]\" />\r\n						[if enb_foot_note]\r\n							<a href=\"#\" class=\"ppsFootNote ppsPopupClose\">\r\n							[foot_note]\r\n							</a>\r\n						[endif]\r\n						[sub_form_end]\r\n						<div style=\"clear: both;\"></div>\r\n					</div>\r\n				[endif]\r\n				<div style=\"clear: both;\"></div>\r\n				[if enb_sm]\r\n					<div style=\"clear: both;\"></div>\r\n					<div class=\"ppsSm\">\r\n					[sm_html]\r\n					</div>\r\n					\r\n				[endif]\r\n			</div>\r\n			<div class=\"ppsBtmLine\"></div>\r\n		</div>\r\n	</div>\r\n</div>","#ppsPopupShell_[ID] {\r\n	width: [width][width_measure];\r\n  	font-family: \"Open Sans\", arial;\r\n	font-size: 13px;\r\n	line-height: normal;\r\n	font-weight: normal;\r\n	color: #fff;\r\n}\r\n#ppsPopupShell_[ID] .ppsInnerTblContent {\r\n}\r\n#ppsPopupShell_[ID] .ppsPopupInner {\r\n	[if bg_type_0 == \"color\"]\r\n	background-color: [bg_color_0];\r\n  	[elseif bg_type_0 == \"img\"]\r\n  	background-image: url(\"[bg_img_0]\");\r\n  	background-repeat: no-repeat;\r\n  	background-size: cover;\r\n  	[endif]\r\n	\r\n	position: relative;\r\n	text-align: center;\r\n	padding: 0;\r\n}\r\n/*For all Elements*/\r\n#ppsPopupShell_[ID] .ppsSubscribeShell input[type=\"email\"],\r\n#ppsPopupShell_[ID] .ppsSubscribeShell input[type=\"text\"],\r\n#ppsPopupShell_[ID] .ppsSubscribeShell textarea {\r\n	margin: 10px 0 0;\r\n	font-size: 16px;\r\n	font-family: \"Open Sans\", arial;\r\n	-webkit-border-radius: 5px;\r\n	-moz-border-radius: 5px;\r\n	border-radius: 5px;\r\n	border: 2px solid #ccc;\r\n	width: 100%;\r\n	display:block;\r\n	background: #fff;\r\n	color: #4f4f4f;\r\n	text-align: center;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeForm input:first-child {\r\n	margin-top: 0px;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell select  {\r\n	font-size: 16px;\r\n	font-family: \"Open Sans\", arial;\r\n	border: 2px solid #ccc;\r\n	display: inline-block;\r\n	background: #fff;\r\n	color: #4f4f4f;\r\n	text-align: center;\r\n	height: 45px;\r\n	-webkit-border-radius: 5px;\r\n	-moz-border-radius: 5px;\r\n	border-radius: 5px;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell label  span {\r\n	display: inline-block;\r\n	padding-right: 2px;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell label  {\r\n	color: #333333;\r\n    display: block;\r\n    margin: 10px 0 0;\r\n	font-size: 16px;\r\n	font-family: \"Open Sans\", arial;\r\n}\r\n\r\n#ppsPopupShell_[ID] .ppsSubscribeShell input[type=text],#ppsPopupShell_[ID] .ppsSubscribeShell input[type=email],#ppsPopupShell_[ID] .ppsSubscribeShell input[type=password],#ppsPopupShell_[ID] .ppsSubscribeShell input[type=email] {\r\n    height: 45px;\r\n}\r\n#ppsPopupShell_[ID] input[type=submit] {\r\n	font-family: \"Open Sans\", arial;\r\n	display:inline-block;\r\n  	color: #fff;\r\n    font-size: 18px;\r\n	width: auto;\r\n	margin: 10px 0;\r\n	-webkit-border-radius: 35px;\r\n	-moz-border-radius: 35px;\r\n	border-radius: 35px;\r\n	border: 0 solid transparent;\r\n  	cursor: pointer;\r\n	text-transform: none;\r\n	padding: 13px 88px 7px 60px;\r\n	font-weight: 700;\r\n	text-shadow: 1px 2px 0px #86B80E;\r\n	text-decoration: none;text-decoration: none;\r\n	\r\n	-webkit-box-shadow: 1px 4px 0 0 rgba(134, 184, 14, 1);\r\n	-moz-box-shadow: 1px 4px 0 0 rgba(134, 184, 14, 1);\r\n	box-shadow: 1px 4px 0 0 rgba(134, 184, 14, 1);\r\n\r\n	background-color: #9cd610;\r\n	background-image: url(\"[PPS_ASSETS_URL]img/assets/365-1-arr-dwn.png\");\r\n    background-position: 79% 13px;\r\n    background-repeat: no-repeat;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell input.butt + a.ppsPopupClose {\r\n	display: inline-block !important;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell {\r\n    display: inline-block;\r\n    margin: 20px 0 20px;\r\n    width: 60%;\r\n	position: relative;\r\n	z-index: 100;\r\n}\r\n#ppsPopupShell_[ID] .ppsTopBgWrapper {\r\n	[if bg_type_1 == \"color\"]\r\n	background: [bg_color_1];\r\n  	[elseif bg_type_1 == \"img\"]\r\n  	background-image: url(\"[bg_img_1]\");\r\n  	background-repeat: no-repeat;\r\n  	background-size: cover;\r\n  	[endif]\r\n	\r\n	padding: 70px 0 0;\r\n	position: relative;\r\n}\r\n#ppsPopupShell_[ID] .ppsWrapImgWr {\r\n	[if bg_type_2 == \"color\"]\r\n	background: {{ hex_to_rgba_str(popup.params.tpl.bg_color_2, 0.5) }};\r\n  	[elseif bg_type_2 == \"img\"]\r\n  	background-image: url(\"[bg_img_2]\");\r\n  	background-repeat: no-repeat;\r\n  	background-size: cover;\r\n  	[endif]\r\n	\r\n	display: inline-block;\r\n    min-height: 130px;\r\n    padding: 10px 0;\r\n    text-align: center;\r\n    width: 100%;\r\n}\r\n#ppsPopupShell_[ID] .ppsImgWr {\r\n	display: inline-block;\r\n	max-width: 100%;\r\n}\r\n#ppsPopupShell_[ID] .ppsPopupLabel {\r\n	font-size: 50px;\r\n	position: relative;\r\n	z-index: 100;\r\n	width: 90%;\r\n	display: inline-block;\r\n	padding-top: 30px;\r\n	font-family: \"Open Sans\", arial;\r\n	word-wrap: break-word;\r\n}\r\n#ppsPopupShell_[ID] .ppsPopupTxt {\r\n	margin: 0;\r\n	padding: 0;\r\n	text-align: center;\r\n}\r\n#ppsPopupShell_[ID] .ppsPopupTxt p {\r\n	display: inline-block;\r\n    margin: 0;\r\n    padding: 0;\r\n    width: 90%;\r\n	position: relative;\r\n	z-index: 100;\r\n	word-wrap: break-word;\r\n}\r\n#ppsPopupShell_[ID] .ppsPopupTxt_0 {\r\n    font-size: 63px;\r\n    font-weight: bold;\r\n	font-family: \"Open Sans\", arial;\r\n}\r\n#ppsPopupShell_[ID] .ppsPopupTxt_1 {\r\n    color: #ffb2b2;\r\n    font-size: 56px;\r\n    font-weight: bold;\r\n    line-height: 51px;\r\n	font-family: \"Open Sans\", arial;\r\n}\r\n#ppsPopupShell_[ID] .ppsPopupTxt_2 {\r\n    color: #333333;\r\n    font-size: 21px;\r\n    font-weight: bold;\r\n	font-family: \"Open Sans\", arial;\r\n}\r\n\r\n#ppsPopupShell_[ID] .ppsBtmBgWrapper {\r\n	padding: 20px 0 0;\r\n	position: relative;\r\n}\r\n#ppsPopupShell_[ID] .ppsBtnOne:hover {\r\n	text-decoration: none;\r\n}\r\n\r\n#ppsPopupShell_[ID] .ppsBtmLine {\r\n	height: 5px;\r\n	\r\n	[if bg_type_3 == \"color\"]\r\n	background: {{ hex_to_rgba_str(popup.params.tpl.bg_color_3, 0.5) }} !important;\r\n  	[elseif bg_type_3 == \"img\"]\r\n  	background-image: url(\"[bg_img_3]\") !important;\r\n  	background-repeat: no-repeat !important; \r\n  	background-size: cover !important;\r\n  	[endif]\r\n}\r\n\r\n#ppsPopupShell_[ID] .ppsPopupClose {\r\n	background-repeat: no-repeat;\r\n  	cursor: pointer;\r\n	z-index: 1000;\r\n}\r\n#ppsPopupShell_[ID] .ppsPopupClose.ppsPopupClose_lists_black {\r\n 	top: 0 !important;\r\n  	right: 0 !important;\r\n}\r\n#ppsPopupShell_[ID] .ppsPopupClose:hover {\r\n	opacity: 0.8;\r\n}\r\n#ppsPopupShell_[ID] .ppsFootNote {\r\n	border-bottom: 2px dotted #b7b7b7;\r\n    color: #b7b7b7;\r\n	display: none !important;\r\n	margin: 10px 0;\r\n	text-decoration: none;	\r\n	background: none !important;\r\n	font-size: 16px;\r\n    height: auto !important;\r\n    position: static !important;\r\n    width: auto !important;\r\n	top: 0 !important;\r\n	word-wrap: break-word;\r\n}\r\n#ppsPopupShell_[ID] .ppsFootNote:hover {\r\n	text-decoration: none;\r\n}\r\n#ppsPopupShell_[ID] .ppsSm{\r\n	margin-top:20px;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubMsg{\r\n	clear: both;\r\n  	text-align: center;\r\n}","christmas-1-prev.png","1","1","1","11","2015-01-10 18:59:43","47"),
("48","Christmas mood","1","0","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","<link href=\"https://fonts.googleapis.com/css?family=Alex+Brush|Josefin+Sans\" rel=\"stylesheet\">\r\n<div id=\"ppsPopupShell_[ID]\" class=\"ppsPopupShell ppsPopupListsShell\">\r\n	<a href=\"#\" class=\"ppsPopupClose ppsPopupClose_[close_btn]\"></a>\r\n	<div class=\"ppsInnerTblContent\">\r\n		<div class=\"ppsPopupListsInner ppsPopupInner\">\r\n			<div class=\"ppsWrapTopImg\">\r\n				[if bg_type_1 == \"img\"]\r\n				<img src=\"[bg_img_1]\" class=\"ppsTopImg\"/>\r\n				[endif]\r\n			</div>\r\n			[if enb_label]\r\n				<div class=\"ppsPopupLabel ppsPopupListsLabel\">[label]</div>\r\n			[endif]\r\n			[if enb_txt_0]\r\n				<div class=\"ppsPopupTxt ppsPopupClassyTxt ppsPopupClassyTxt_0 ppsPopupTxt_0\">\r\n				[txt_0]\r\n				</div>\r\n				<div class=\"ppsTxt1Separator\"></div>\r\n			[endif]\r\n			[if enb_txt_1]\r\n				<div class=\"ppsPopupTxt ppsPopupClassyTxt ppsPopupClassyTxt_1 ppsPopupTxt_1\">\r\n				[txt_1]\r\n				</div>\r\n			[endif]\r\n			<div style=\"clear: both;\"></div>\r\n			[if enb_subscribe]\r\n				<div class=\"ppsSubscribeShell\">\r\n					[sub_form_start]\r\n					[sub_fields_html]\r\n					<input class=\"butt\" type=\"submit\" name=\"submit\" value=\"[sub_btn_label]\" />\r\n					[sub_form_end]\r\n					<div style=\"clear: both;\"></div>\r\n				</div>\r\n			[endif]\r\n			[if enb_txt_2]\r\n				<div class=\"ppsPopupTxt ppsPopupClassyTxt ppsPopupClassyTxt_2 ppsPopupTxt_2\">\r\n				[txt_2]\r\n				</div>\r\n			[endif]\r\n			<div class=\"ppsTxt1Separator\"></div>\r\n			[if enb_foot_note]\r\n				<a href=\"#\" class=\"ppsFootNote ppsPopupClose\">\r\n				[foot_note]\r\n				</a>\r\n			[endif]\r\n			\r\n			<div style=\"clear: both;\"></div>\r\n			[if enb_sm]\r\n				<div style=\"clear: both;\"></div>\r\n				<div class=\"ppsSm\">\r\n				[sm_html]\r\n				</div>\r\n			[endif]\r\n			\r\n		</div>\r\n	</div>\r\n</div>","#ppsPopupShell_[ID] {\r\n	width: [width][width_measure];\r\n  	font-family: arial;\r\n	font-size: 13px;\r\n	font-weight: normal;\r\n}\r\n#ppsPopupShell_[ID] .ppsInnerTblContent {\r\n}\r\n\r\n#ppsPopupShell_[ID], #ppsPopupShell_[ID] * {\r\n	-webkit-box-sizing: border-box;\r\n	-moz-box-sizing:    border-box;\r\n	box-sizing:         border-box;\r\n}\r\n#ppsPopupShell_[ID] .ppsPopupInner {\r\n	[if bg_type_0 == \"color\"]\r\n	background: -moz-radial-gradient(center, ellipse cover, {{ adjust_brightness(popup.params.tpl.bg_color_0, 50) }} 0%, [bg_color_0] 100%); /* ff3.6+ */\r\n	background: -webkit-gradient(radial, center center, 0px, center center, 100%, color-stop(0%, {{ adjust_brightness(popup.params.tpl.bg_color_0, 50) }}), color-stop(100%, [bg_color_0])); /* safari4+,chrome */\r\n	background:-webkit-radial-gradient(center, ellipse cover, {{ adjust_brightness(popup.params.tpl.bg_color_0, 50) }} 0%, [bg_color_0] 100%); /* safari5.1+,chrome10+ */\r\n	background: -o-radial-gradient(center, ellipse cover, {{ adjust_brightness(popup.params.tpl.bg_color_0, 50) }} 0%, [bg_color_0] 100%); /* opera 11.10+ */\r\n	background: -ms-radial-gradient(center, ellipse cover, {{ adjust_brightness(popup.params.tpl.bg_color_0, 50) }} 0%, [bg_color_0] 100%); /* ie10+ */\r\n	background:radial-gradient(ellipse at center, {{ adjust_brightness(popup.params.tpl.bg_color_0, 50) }} 0%, [bg_color_0] 100%); /* w3c */\r\n	filter: progid:DXImageTransform.Microsoft.gradient( startColorstr=\"{{ adjust_brightness(popup.params.tpl.bg_color_0, 50) }}\", endColorstr=\"[bg_color_0]\",GradientType=1 ); /* ie6-9 */\r\n  	[elseif bg_type_0 == \"img\"]\r\n  	background-image: url(\"[bg_img_0]\");\r\n  	background-repeat: no-repeat;\r\n  	background-size: cover;\r\n  	[endif]\r\n	\r\n	position: relative;\r\n	text-align: center;\r\n	padding: 0 0 40px;\r\n	[if bg_type_3 == \"color\"]\r\n	border: 3px solid [bg_color_3];\r\n	[endif]\r\n	\r\n}\r\n\r\n#ppsPopupShell_[ID] .ppsSubscribeShell{\r\n    display: inline-block;\r\n    margin: 0;\r\n    width: 60%;\r\n	position: relative;\r\n	z-index: 100;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell form {\r\n\r\n}\r\n\r\n#ppsPopupShell_[ID] .ppsSubscribeForm input:first-child {\r\n	margin-top: 0px;\r\n}\r\n/*For all Elements*/\r\n#ppsPopupShell_[ID] .ppsSubscribeShell input[type=\"email\"],\r\n#ppsPopupShell_[ID] .ppsSubscribeShell input[type=password],\r\n#ppsPopupShell_[ID] .ppsSubscribeShell input[type=\"text\"],\r\n#ppsPopupShell_[ID] .ppsSubscribeShell select,\r\n#ppsPopupShell_[ID] .ppsSubscribeShell textarea {\r\n	width: 100%;\r\n	-webkit-border-radius: 0px;\r\n	-moz-border-radius: 0px;\r\n	border-radius: 0px;\r\n	border: 1px solid transparent;\r\n	height: 47px;\r\n	padding: 0;\r\n	margin: 10px 0;\r\n	display:block;\r\n	text-align: center;\r\n	color: #016823;\r\n	font-weight: normal;\r\n	font-size: 18px;\r\n	font-family: arial;\r\n	\r\n	[if bg_type_2 == \"color\"]\r\n	background: [bg_color_2];\r\n  	[elseif bg_type_2 == \"img\"]\r\n  	background-image: url(\"[bg_img_2]\");\r\n  	background-repeat: no-repeat;\r\n  	background-size: cover;\r\n  	[endif]\r\n}\r\n\r\n#ppsPopupShell_[ID] .ppsSubscribeShell select {\r\n	margin: 0px;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell textarea { \r\n	height: auto;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell label  {\r\n	display:block;\r\n	margin: 10px 0 0;\r\n	color: #016823;\r\n	font-weight: normal;\r\n	font-size: 18px;\r\n	font-family: arial;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell label  span {\r\n	display: inline-block;\r\n	padding-right: 2px;\r\n	vertical-align: middle;\r\n}\r\n\r\n#ppsPopupShell_[ID] .ppsSubscribeShell input[type=radio],\r\n#ppsPopupShell_[ID] .ppsSubscribeShell input[type=checkbox] {\r\n	vertical-align: middle;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell input[type=email] {\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell input::-webkit-input-placeholder { /* Chrome/Opera/Safari */\r\n    color: #016823;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell input::-moz-placeholder { /* Firefox 19+ */\r\n    color: #016823;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell inpu:-ms-input-placeholder { /* IE 10+ */\r\n    color: #016823;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell input:-moz-placeholder { /* Firefox 18- */\r\n    color: #016823;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell input[type=submit] {\r\n	\r\n	width: 100%;\r\n	-webkit-border-radius: 0px;\r\n	-moz-border-radius: 0px;\r\n	border-radius: 0px;\r\n	border: 1px solid transparent;\r\n	height: 47px;\r\n	padding: 0;\r\n	margin: 10px 0;\r\n	text-align: center;\r\n	font-family: arial;\r\n	\r\n  	color: #fff;\r\n  	cursor: pointer;\r\n	text-transform: none;\r\n	font-weight: 700;\r\n	font-size: 20px;\r\n	display: inline-block;\r\n	border: 1px solid transparent;\r\n	\r\n	background-color: #016823;\r\n    background-image: url(\"[PPS_ASSETS_URL]img/assets/365-2-right-arr.png\");\r\n    background-position: 90% center;\r\n    background-repeat: no-repeat;\r\n}\r\n#ppsPopupShell_[ID] .ppsWrapTopImg {\r\n	display: inline-block;\r\n    text-align: center;\r\n    width: 100%;\r\n}\r\n#ppsPopupShell_[ID] .ppsTopImg {\r\n	display: inline-block;\r\n	max-width: 70%;\r\n}\r\n\r\n\r\n\r\n#ppsPopupShell_[ID] .ppsPopupLabel {\r\n	font-family: arial;\r\n	font-size: 35px;\r\n	padding: 20px 20px 0; \r\n	text-align: center;\r\n	line-height: 45px;\r\n	position: relative;\r\n	z-index: 100;\r\n	color: #333333;\r\n	word-wrap: break-word;\r\n}\r\n#ppsPopupShell_[ID] .ppsPopupTxt {\r\n	font-family: arial;\r\n	margin: 0;\r\n	padding: 0;\r\n	text-align: center;\r\n	word-wrap: break-word;\r\n}\r\n#ppsPopupShell_[ID] .ppsPopupTxt p {\r\n	display: inline-block;\r\n    margin: 0;\r\n    padding: 0;\r\n    width: 90%;\r\n	position: relative;\r\n	z-index: 100;\r\n}\r\n#ppsPopupShell_[ID] .ppsPopupTxt_0 {\r\n    color: #f2362d;\r\n    font-size: 70px;\r\n    font-weight: bold;\r\n    line-height: 60px;\r\n    margin: 10px 0;\r\n}\r\n#ppsPopupShell_[ID] .ppsPopupTxt_1 {\r\n    color: #333333;\r\n    font-size: 18px;\r\n    padding: 10px 0;\r\n}\r\n\r\n\r\n#ppsPopupShell_[ID] .ppsPopupTxt_2 {\r\n	display: block;\r\n    font-size: 16px;\r\n    margin: 0 auto 15px;\r\n    text-align: center;\r\n    width: 90%;\r\n}\r\n#ppsPopupShell_[ID] .ppsPopupTxt_2 a {\r\n	color: #f44b44;\r\n	text-decoration: none;\r\n}\r\n#ppsPopupShell_[ID] .ppsPopupTxt_2 a:hover {\r\n	text-decoration: none;\r\n}\r\n\r\n\r\n#ppsPopupShell_[ID] .ppsTxt1Separator {\r\n	background-color: #cccccc;\r\n    display: block;\r\n    height: 1px;\r\n    margin: 0 auto;\r\n    width: 15%;\r\n}\r\n\r\n#ppsPopupShell_[ID] .ppsPopupClose {\r\n	background-repeat: no-repeat;\r\n  	cursor: pointer;\r\n	top: 15px;\r\n	z-index: 1000 !important;\r\n}\r\n#ppsPopupShell_[ID] .ppsPopupClose.ppsPopupClose_lists_black {\r\n 	top: 0 !important;\r\n  	right: 0 !important;\r\n}\r\n#ppsPopupShell_[ID] .ppsPopupClose:hover {\r\n	opacity: 0.8;\r\n}\r\n#ppsPopupShell_[ID] .ppsFootNote{\r\n    background: none !important;\r\n    border-bottom: 2px solid #016823;\r\n    color: #016823;\r\n    display: inline-block !important;\r\n    font-size: 16px;\r\n    height: auto !important;\r\n    margin: 10px 0;\r\n    position: static !important;\r\n    text-decoration: none;\r\n    top: 0 !important;\r\n    width: auto !important;\r\n	\r\n	word-wrap: break-word;\r\n}\r\n#ppsPopupShell_[ID] .ppsSm{\r\n	margin-top:20px;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubMsg{\r\n	clear: both;\r\n  	text-align: center;\r\n}\r\n","christmas-2-prev.png","1","1","1","11","2015-01-10 18:59:43","48"),
("49","Let it Snow","1","0","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","<link href=\"https://fonts.googleapis.com/css?family=Alex+Brush|Josefin+Sans\" rel=\"stylesheet\">\r\n<div id=\"ppsPopupShell_[ID]\" class=\"ppsPopupShell ppsPopupListsShell\">\r\n	<a href=\"#\" class=\"ppsPopupClose ppsPopupClose_[close_btn]\"></a>\r\n	<div class=\"ppsInnerTblContent\">\r\n		<div class=\"ppsPopupListsInner ppsPopupInner\">\r\n			<div class=\"ppsWrapTopImg\">\r\n				[if enb_label]\r\n					<div class=\"ppsPopupLabel ppsPopupListsLabel\">[label]</div>\r\n				[endif]\r\n				[if enb_txt_0]\r\n					<div class=\"ppsPopupTxt ppsPopupClassyTxt ppsPopupClassyTxt_0 ppsPopupTxt_0\">\r\n					[txt_0]\r\n					</div>\r\n				[endif]\r\n			</div>\r\n			<div style=\"clear: both;\"></div>\r\n			[if enb_subscribe]\r\n				<div class=\"ppsSubscribeShell\">\r\n					[sub_form_start]\r\n					[sub_fields_html]\r\n					<input class=\"butt\" type=\"submit\" name=\"submit\" value=\"[sub_btn_label]\" />\r\n					[if enb_foot_note]\r\n						<a href=\"#\" class=\"ppsFootNote ppsPopupClose\">\r\n						[foot_note]\r\n						</a>\r\n					[endif]\r\n					\r\n					[sub_form_end]\r\n					<div style=\"clear: both;\"></div>\r\n				</div>\r\n			[endif]\r\n			<div style=\"clear: both;\"></div>\r\n			[if enb_sm]\r\n				<div style=\"clear: both;\"></div>\r\n				<div class=\"ppsSm\">\r\n				[sm_html]\r\n				</div>\r\n			[endif]\r\n		</div>\r\n	</div>\r\n</div>","#ppsPopupShell_[ID] {\r\n	width: [width][width_measure];\r\n  	font-family: arial;\r\n	font-size: 13px;\r\n	font-weight: normal;\r\n}\r\n#ppsPopupShell_[ID], #ppsPopupShell_[ID] * {\r\n	-webkit-box-sizing: border-box;\r\n	-moz-box-sizing:    border-box;\r\n	box-sizing:         border-box;\r\n}\r\n#ppsPopupShell_[ID] .ppsInnerTblContent {\r\n}\r\n#ppsPopupShell_[ID] .ppsPopupInner {\r\n	[if bg_type_0 == \"color\"]\r\n	background: -moz-radial-gradient(center, ellipse cover, {{ adjust_brightness(popup.params.tpl.bg_color_0, 50) }} 0%, [bg_color_0] 100%); /* ff3.6+ */\r\n	background: -webkit-gradient(radial, center center, 0px, center center, 100%, color-stop(0%, {{ adjust_brightness(popup.params.tpl.bg_color_0, 50) }}), color-stop(100%, [bg_color_0])); /* safari4+,chrome */\r\n	background:-webkit-radial-gradient(center, ellipse cover, {{ adjust_brightness(popup.params.tpl.bg_color_0, 50) }} 0%, [bg_color_0] 100%); /* safari5.1+,chrome10+ */\r\n	background: -o-radial-gradient(center, ellipse cover, {{ adjust_brightness(popup.params.tpl.bg_color_0, 50) }} 0%, [bg_color_0] 100%); /* opera 11.10+ */\r\n	background: -ms-radial-gradient(center, ellipse cover, {{ adjust_brightness(popup.params.tpl.bg_color_0, 50) }} 0%, [bg_color_0] 100%); /* ie10+ */\r\n	background:radial-gradient(ellipse at center, {{ adjust_brightness(popup.params.tpl.bg_color_0, 50) }} 0%, [bg_color_0] 100%); /* w3c */\r\n	filter: progid:DXImageTransform.Microsoft.gradient( startColorstr=\"{{ adjust_brightness(popup.params.tpl.bg_color_0, 50) }}\", endColorstr=\"[bg_color_0]\",GradientType=1 ); /* ie6-9 */\r\n  	[elseif bg_type_0 == \"img\"]\r\n  	background-image: url(\"[bg_img_0]\");\r\n  	background-repeat: no-repeat;\r\n  	background-size: cover;\r\n  	[endif]\r\n	\r\n	position: relative;\r\n	text-align: center;\r\n	padding: 0 0 40px;\r\n}\r\n\r\n#ppsPopupShell_[ID] .ppsWrapTopImg {\r\n	[if bg_type_1 == \"color\"]\r\n	background: -moz-radial-gradient(center, ellipse cover, {{ adjust_brightness(popup.params.tpl.bg_color_1, 50) }} 0%, [bg_color_1] 100%); /* ff3.6+ */\r\n	background: -webkit-gradient(radial, center center, 0px, center center, 100%, color-stop(0%, {{ adjust_brightness(popup.params.tpl.bg_color_1, 50) }}), color-stop(100%, [bg_color_1])); /* safari4+,chrome */\r\n	background:-webkit-radial-gradient(center, ellipse cover, {{ adjust_brightness(popup.params.tpl.bg_color_1, 50) }} 0%, [bg_color_1] 100%); /* safari5.1+,chrome10+ */\r\n	background: -o-radial-gradient(center, ellipse cover, {{ adjust_brightness(popup.params.tpl.bg_color_1, 50) }} 0%, [bg_color_1] 100%); /* opera 11.10+ */\r\n	background: -ms-radial-gradient(center, ellipse cover, {{ adjust_brightness(popup.params.tpl.bg_color_1, 50) }} 0%, [bg_color_1] 100%); /* ie10+ */\r\n	background:radial-gradient(ellipse at center, {{ adjust_brightness(popup.params.tpl.bg_color_1, 50) }} 0%, [bg_color_1] 100%); /* w3c */\r\n	filter: progid:DXImageTransform.Microsoft.gradient( startColorstr=\"{{ adjust_brightness(popup.params.tpl.bg_color_1, 50) }}\", endColorstr=\"[bg_color_1]\",GradientType=1 ); /* ie6-9 */\r\n	[elseif bg_type_1 == \"img\"]\r\n  	background-image: url(\"[bg_img_1]\");\r\n  	background-position: center bottom;\r\n    background-repeat: no-repeat;\r\n    background-size: cover;\r\n  	[endif]\r\n	\r\n	min-height: 210px;\r\n    padding: 40px 0 85px;\r\n}\r\n\r\n#ppsPopupShell_[ID] .ppsSubscribeShell{\r\n    display: inline-block;\r\n    margin: 0;\r\n	position: relative;\r\n	z-index: 100;\r\n	width: 90%;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell form {\r\n	position: relative;\r\n	padding: 5px 0;\r\n}\r\n\r\n#ppsPopupShell_[ID] .ppsSubscribeShell input {\r\n	width: 100%;\r\n	-webkit-border-radius: 0px;\r\n	-moz-border-radius: 0px;\r\n	border-radius: 0px;\r\n	border: 0 solid transparent;\r\n	height: 47px;\r\n	padding: 0;\r\n	margin: 0;\r\n	display:block;\r\n	font-family: arial;\r\n	text-align: center;\r\n}\r\n\r\n/*For all Elements*/\r\n#ppsPopupShell_[ID] .ppsSubscribeShell input[type=password],\r\n#ppsPopupShell_[ID] .ppsSubscribeShell input[type=\"text\"],\r\n#ppsPopupShell_[ID] .ppsSubscribeShell select,\r\n#ppsPopupShell_[ID] .ppsSubscribeShell textarea {\r\n	border: 1px solid #01a2ea;\r\n    color: #777777;\r\n    font-size: 18px;\r\n	font-family: arial;\r\n	font-weight: normal;\r\n    height: 45px;\r\n    padding: 0 20px;\r\n	width: 100%;\r\n	display:block;\r\n	text-align: center;\r\n	margin-top: 10px;\r\n	\r\n	[if bg_type_2 == \"color\"]\r\n	background: [bg_color_2];\r\n  	[elseif bg_type_2 == \"img\"]\r\n  	background-image: url(\"[bg_img_2]\");\r\n  	background-repeat: no-repeat;\r\n  	background-size: cover;\r\n  	[endif]\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell select {\r\n	margin-top: 0px;\r\n}\r\n\r\n#ppsPopupShell_[ID] .ppsSubscribeForm input:first-child {\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell select  {\r\n\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell label  {\r\n	font-size: 18px;\r\n	font-family: arial;\r\n	font-weight: normal;\r\n	margin-top: 10px;\r\n	display:block;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell label  span {\r\n	display: inline-block;\r\n	padding-right: 2px;\r\n	vertical-align: middle;\r\n}\r\n\r\n#ppsPopupShell_[ID] .ppsSubscribeShell input[type=radio],\r\n#ppsPopupShell_[ID] .ppsSubscribeShell input[type=checkbox] {\r\n	vertical-align: middle;\r\n}\r\n\r\n#ppsPopupShell_[ID] .ppsSubscribeShell input[type=email] {\r\n	border: 1px solid #01a2ea;\r\n    color: #777777;\r\n    font-size: 18px;\r\n    height: auto;\r\n    padding: 20px 20px 50px;\r\n	margin-top: 10px;\r\n	\r\n	[if bg_type_2 == \"color\"]\r\n	background: [bg_color_2];\r\n  	[elseif bg_type_2 == \"img\"]\r\n  	background-image: url(\"[bg_img_2]\");\r\n  	background-repeat: no-repeat;\r\n  	background-size: cover;\r\n  	[endif]\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell input + input:not([type=hidden]):not([type=\"submit\"]){\r\n 	padding: 20px 20px 50px;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell input[type=submit] {\r\n	border: 10px solid #fff;\r\n  	color: #333333;\r\n  	cursor: pointer;\r\n	font-weight: 600;\r\n	font-size: 20px;\r\n	height: auto;\r\n	display: inline-block;\r\n	padding: 15px 0 13px;\r\n	-webkit-border-radius: 20px;\r\n	-moz-border-radius: 20px;\r\n	border-radius: 20px;\r\n    text-transform: none;\r\n	left: 5%;\r\n    width: 90%;\r\n  	position: absolute;\r\n  	transform: translateY(-50%);\r\n	\r\n	[if bg_type_3 == \"color\"]\r\n	background: [bg_color_3] !important;\r\n  	[elseif bg_type_3 == \"img\"]\r\n  	background-image: url(\"[bg_img_3]\") !important;\r\n  	background-repeat: no-repeat;\r\n  	background-size: cover;\r\n  	[endif]\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell input[type=email]::-webkit-input-placeholder { /* Chrome/Opera/Safari */\r\n    color: #999999;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell input[type=email]::-moz-placeholder { /* Firefox 19+ */\r\n    color: #999999;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell input[type=email]:-ms-input-placeholder { /* IE 10+ */\r\n    color: #999999;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell input[type=email]:-moz-placeholder { /* Firefox 18- */\r\n    color: #999999;\r\n}\r\n\r\n\r\n#ppsPopupShell_[ID] .ppsPopupLabel {\r\n	font-family: arial;\r\n	font-size: 35px;\r\n	padding: 20px 20px 0; \r\n	text-align: center;\r\n	line-height: 45px;\r\n	position: relative;\r\n	z-index: 100;\r\n	color: #fff;\r\n	word-wrap: break-word;\r\n}\r\n#ppsPopupShell_[ID] .ppsPopupTxt {\r\n	font-family: arial;\r\n	margin: 0;\r\n	padding: 0;\r\n	text-align: center;\r\n}\r\n#ppsPopupShell_[ID] .ppsPopupTxt p {\r\n	display: inline-block;\r\n    margin: 0;\r\n    padding: 0;\r\n    width: 90%;\r\n	position: relative;\r\n	z-index: 100;\r\n	word-wrap: break-word;\r\n	line-height: 50px;\r\n}\r\n#ppsPopupShell_[ID] .ppsPopupTxt_0 {\r\n    color: #fff;\r\n    font-size: 53px;\r\n    line-height: 50px;\r\n    margin: 10px 0;\r\n	text-shadow: 2px 2px 0 #01a2ea;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell input[type=submit] + .ppsFootNote {\r\n	display: inline-block !important;\r\n}\r\n\r\n#ppsPopupShell_[ID] .ppsFootNote {\r\n	-webkit-border-radius: 10px;\r\n	-moz-border-radius: 10px;\r\n	border-radius: 10px;\r\n	\r\n	background: none !important;\r\n	border: 2px solid #cbcbcb;\r\n    color: #cbcbcb;\r\n    display: none !important;\r\n    font-size: 16px;\r\n	font-weight: bold;\r\n    height: auto !important;\r\n    margin: 40px 30px 0;\r\n	padding: 5px 20px;\r\n    position: static !important;\r\n    text-decoration: none;\r\n    top: 0 !important;\r\n    width: auto !important;\r\n}\r\n\r\n#ppsPopupShell_[ID] .ppsPopupClose {\r\n	background-repeat: no-repeat;\r\n  	cursor: pointer;\r\n	top: 15px;\r\n	z-index: 1000 !important;\r\n}\r\n#ppsPopupShell_[ID] .ppsPopupClose.ppsPopupClose_lists_black {\r\n 	top: 0 !important;\r\n  	right: 0 !important;\r\n}\r\n#ppsPopupShell_[ID] .ppsPopupClose:hover {\r\n	opacity: 0.8;\r\n}\r\n\r\n#ppsPopupShell_[ID] .ppsSm{\r\n	margin-top:20px;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubMsg{\r\n	clear: both;\r\n  	text-align: center;\r\n}\r\n","christmas-3-prev.png","1","1","1","11","2015-01-10 18:59:43","49")');
		}
		if(dbPps::get('SELECT COUNT(*) AS total FROM @__popup WHERE id = 5 AND original_id = 0', 'one')) {
			dbPps::query('UPDATE @__popup SET label="Video List", active = "1", original_id="0", params="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",html="<div id=\"ppsPopupShell_[ID]\" class=\"ppsPopupShell ppsPopupListsShell\">\r\n	<a href=\"#\" class=\"ppsPopupClose ppsPopupClose_[close_btn]\"></a>\r\n	<div class=\"ppsInnerTblContent\">\r\n		<div class=\"ppsPopupListsInner ppsPopupInner\">\r\n			<div class=\"ppsPopupVideo \">\r\n				[video_html]\r\n			</div>\r\n			<div style=\"clear: both;\"></div>\r\n		</div>\r\n		<div class=\"ppsRightCol\">\r\n			[if enb_label]\r\n				<div class=\"ppsPopupLabel ppsPopupListsLabel\">[label]</div>\r\n				<div style=\"clear: both;\"></div>\r\n			[endif]\r\n			[if enb_subscribe]\r\n				<div class=\"ppsSubscribeShell\">\r\n					[sub_form_start]\r\n					[sub_fields_html]\r\n					<input type=\"submit\" name=\"submit\" value=\"[sub_btn_label]\" />\r\n					[sub_form_end]\r\n					<div style=\"clear: both;\"></div>\r\n				</div>\r\n			[endif]\r\n			[if enb_sm]\r\n				<div class=\"ppsSm\">\r\n				[sm_html]\r\n				</div>\r\n			[endif]\r\n			[if enb_foot_note]\r\n				<div class=\"ppsFootNote\">\r\n				[foot_note]\r\n				</div>\r\n			[endif]\r\n		</div>\r\n	</div>\r\n</div>",css="#ppsPopupShell_[ID] {\r\n	width: [width][width_measure];\r\n  	padding: 0;\r\n  	font-family: arial;\r\n	font-size: 13px;\r\n	line-height: normal;\r\n	font-weight: normal;\r\n	color: #015050;\r\n}\r\n#ppsPopupShell_[ID], #ppsPopupShell_[ID] * {\r\n	-webkit-box-sizing: border-box;\r\n	-moz-box-sizing:    border-box;\r\n	box-sizing:         border-box;\r\n}\r\n#ppsPopupShell_[ID] iframe {\r\n	width: 100% !important;\r\n	margin: 0;\r\n    padding: 0;\r\n}\r\n#ppsPopupShell_[ID] .ppsInnerTblContent {\r\n	display: table;\r\n}\r\n#ppsPopupShell_[ID] .ppsPopupInner {\r\n	display: table-cell;\r\n	vertical-align: middle;\r\n	\r\n	{% if popup.params.tpl.enb_subscribe or popup.params.tpl.enb_foot_note or popup.params.tpl.enb_sm %}\r\n  	width: 66%;\r\n	[else]\r\n  	width: 100%;\r\n  	[endif]\r\n\r\n	[if bg_type_0 == \"color\"]\r\n	background: -moz-radial-gradient(center, ellipse cover, {{ adjust_brightness(popup.params.tpl.bg_color_0, 50) }} 0%, [bg_color_0] 100%); /* ff3.6+ */\r\n	background: -webkit-gradient(radial, center center, 0px, center center, 100%, color-stop(0%, {{ adjust_brightness(popup.params.tpl.bg_color_0, 50) }}), color-stop(100%, [bg_color_0])); /* safari4+,chrome */\r\n	background:-webkit-radial-gradient(center, ellipse cover, {{ adjust_brightness(popup.params.tpl.bg_color_0, 50) }} 0%, [bg_color_0] 100%); /* safari5.1+,chrome10+ */\r\n	background: -o-radial-gradient(center, ellipse cover, {{ adjust_brightness(popup.params.tpl.bg_color_0, 50) }} 0%, [bg_color_0] 100%); /* opera 11.10+ */\r\n	background: -ms-radial-gradient(center, ellipse cover, {{ adjust_brightness(popup.params.tpl.bg_color_0, 50) }} 0%, [bg_color_0] 100%); /* ie10+ */\r\n	background:radial-gradient(ellipse at center, {{ adjust_brightness(popup.params.tpl.bg_color_0, 50) }} 0%, [bg_color_0] 100%); /* w3c */\r\n	filter: progid:DXImageTransform.Microsoft.gradient( startColorstr=\"{{ adjust_brightness(popup.params.tpl.bg_color_0, 50) }}\", endColorstr=\"[bg_color_0]\",GradientType=1 ); /* ie6-9 */\r\n  	[elseif bg_type_0 == \"img\"]\r\n  	background-image: url(\"[bg_img_0]\");\r\n  	background-repeat: no-repeat;\r\n  	background-size: cover;\r\n	background-position: center top;\r\n	[else]\r\n	background: none;\r\n  	[endif]\r\n}\r\n\r\n#ppsPopupShell_[ID] .ppsRightCol {\r\n	display: table-cell;\r\n  	width: 34%;\r\n  	height: 100%;\r\n  	vertical-align: middle;\r\n	padding: 15px 0;\r\n	margin: 0;\r\n	\r\n  	[if bg_type_1 == \"color\"]\r\n  	background: -moz-radial-gradient(center, ellipse cover, {{ adjust_brightness(popup.params.tpl.bg_color_1, 50) }} 0%, [bg_color_1] 100%); /* ff3.6+ */\r\n	background: -webkit-gradient(radial, center center, 0px, center center, 100%, color-stop(0%, {{ adjust_brightness(popup.params.tpl.bg_color_1, 50) }}), color-stop(100%, [bg_color_1])); /* safari4+,chrome */\r\n	background:-webkit-radial-gradient(center, ellipse cover, {{ adjust_brightness(popup.params.tpl.bg_color_1, 50) }} 0%, [bg_color_1] 100%); /* safari5.1+,chrome10+ */\r\n	background: -o-radial-gradient(center, ellipse cover, {{ adjust_brightness(popup.params.tpl.bg_color_1, 50) }} 0%, [bg_color_1] 100%); /* opera 11.10+ */\r\n	background: -ms-radial-gradient(center, ellipse cover, {{ adjust_brightness(popup.params.tpl.bg_color_1, 50) }} 0%, [bg_color_1] 100%); /* ie10+ */\r\n	background:radial-gradient(ellipse at center, {{ adjust_brightness(popup.params.tpl.bg_color_1, 50) }} 0%, [bg_color_1] 100%); /* w3c */\r\n	filter: progid:DXImageTransform.Microsoft.gradient( startColorstr=\"{{ adjust_brightness(popup.params.tpl.bg_color_1, 50) }}\", endColorstr=\"[bg_color_1]\",GradientType=1 ); /* ie6-9 */\r\n  	[elseif bg_type_1 == \"img\"]\r\n  	background-image: url(\"[bg_img_1]\");\r\n  	background-repeat: no-repeat;\r\n  	background-size: cover;\r\n	background-position: center top;\r\n  	[endif]\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell form {\r\n	padding: 15px 30px 0;\r\n}\r\n\r\n#ppsPopupShell_[ID] .ppsSubscribeShell input::-webkit-input-placeholder { /* Chrome/Opera/Safari */\r\n    color: #ccc;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell input::-moz-placeholder { /* Firefox 19+ */\r\n    color: #ccc;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell input:-ms-input-placeholder { /* IE 10+ */\r\n    color: #ccc;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell input:-moz-placeholder { /* Firefox 18- */\r\n    color: #ccc;\r\n}\r\n\r\n#ppsPopupShell_[ID] .ppsSubscribeShell textarea::-webkit-input-placeholder { /* Chrome/Opera/Safari */\r\n    color: #ccc;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell textarea::-moz-placeholder { /* Firefox 19+ */\r\n    color: #ccc;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell textarea:-ms-input-placeholder { /* IE 10+ */\r\n    color: #ccc;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell textarea:-moz-placeholder { /* Firefox 18- */\r\n    color: #ccc;\r\n}\r\n/*For all Elements*/\r\n#ppsPopupShell_[ID] .ppsSubscribeShell input[type=\"email\"],\r\n#ppsPopupShell_[ID] .ppsSubscribeShell input[type=\"password\"],\r\n#ppsPopupShell_[ID] .ppsSubscribeShell input[type=\"text\"],\r\n#ppsPopupShell_[ID] .ppsSubscribeShell select,\r\n#ppsPopupShell_[ID] .ppsSubscribeShell textarea {\r\n	font-family: arial;\r\n	font-size: 16px;\r\n	font-weight: normal;\r\n	line-height: normal;\r\n	color: #aaa;\r\n	text-align:center;\r\n	width: 100%;\r\n	-webkit-border-radius: 5px;\r\n	-moz-border-radius: 5px;\r\n	border-radius: 5px;\r\n	border: 0px solid transparent;\r\n	display:block;\r\n    \r\n    margin: 10px 0 0;\r\n	padding: 0 10px 0 10px;\r\n	height: 40px;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell textarea {\r\n	height: auto;\r\n	padding-top: 9px;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeForm input:first-child {\r\n	margin-top: 0px;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell select  {\r\n	margin: 0;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell label  {\r\n	display: block;\r\n	font-family: arial;\r\n	font-size: 16px;\r\n	font-weight: normal;\r\n	line-height: normal;\r\n	color: #015050;\r\n	\r\n	margin: 10px 0 0;\r\n	text-align: center;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell label  span {\r\n	display: block;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell input[type=\"text\"][name=\"name\"] {\r\n	background-image: url(\"[PPS_ASSETS_URL]img/assets/user-black-icon.png\");\r\n	background-position: 12px center;\r\n	background-repeat: no-repeat;\r\n	background-size: 16px auto;\r\n	padding: 0 25px 0 35px;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell input[type=\"email\"] {\r\n	background-image: url(\"[PPS_ASSETS_URL]img/assets/email-black-icon.png\");\r\n	background-position: 11px center;\r\n	background-repeat: no-repeat;\r\n	background-size: 18px auto;\r\n	padding: 0 25px 0 35px;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell input[type=\"submit\"] {\r\n	display: block;\r\n	font-family: arial;\r\n	font-size: 17px;\r\n	font-weight: bold;\r\n	line-height: normal;\r\n	color: #fff;\r\n  	cursor: pointer;\r\n	margin: 10px 0 0;\r\n	-webkit-border-radius: 5px;\r\n	-moz-border-radius: 5px;\r\n	border-radius: 5px;\r\n	border: 0px solid transparent;\r\n	width: 100%;\r\n	height: 50px;\r\n	\r\n  	[if bg_type_2 == \"color\"]\r\n  	background: [bg_color_2] 100%;\r\n  	[elseif bg_type_2 == \"img\"]\r\n  	background: url(\"[bg_img_2]\");\r\n  	background-repeat: no-repeat;\r\n  	background-size: cover;\r\n  	[endif]\r\n}\r\n\r\n#ppsPopupShell_[ID] .ppsPopupLabel {\r\n	color: #015050;\r\n	font-family: arial;\r\n	font-size: 30px;\r\n	line-height: 40px;\r\n	font-weight: bold;\r\n	margin: 0 15px 15px;\r\n	padding: 0;\r\n	text-align: center;\r\n\r\n}\r\n#ppsPopupShell_[ID] .ppsPopupVideo {\r\n  	width: 100%;\r\n  	line-height: 0;\r\n}\r\n#ppsPopupShell_[ID] .ppsSuccessMsg {\r\n	color: #015050 !important;\r\n	font-weight: bold;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubMsg {\r\n	text-align: center;\r\n}\r\n#ppsPopupShell_[ID] .ppsPopupClose {\r\n	background-repeat: no-repeat;\r\n  	cursor: pointer;\r\n}\r\n#ppsPopupShell_[ID] .ppsPopupClose.ppsPopupClose_lists_black {\r\n 	top: 0 !important;\r\n  	right: 0 !important;\r\n}\r\n#ppsPopupShell_[ID] .ppsPopupClose:hover {\r\n	opacity: 0.8;\r\n}\r\n#ppsPopupShell_[ID] .ppsFootNote {\r\n	color: #015050;\r\n    font-family: \"Helvetica Neue\",Helvetica,Arial,sans-serif;\r\n    font-size: x-small;\r\n    font-style: normal;\r\n	font-weight: bold;\r\n    line-height: 14px;\r\n  	margin: 15px 30px 5px;\r\n	padding: 0;\r\n	text-align: center;\r\n}",img_preview="2016-230-5-video-list-prev.png",show_on="1",show_to="1",show_pages="1",type_id="3",date_created="2015-01-10 18:59:43",sort_order="1" WHERE id = "5"');
		}
		if(dbPps::get('SELECT COUNT(*) AS total FROM @__popup WHERE id = 27 AND original_id = 0', 'one')) {
			dbPps::query('UPDATE @__popup SET label="New York",active="1",original_id="0",params="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",html="<link href=\"https://fonts.googleapis.com/css?family=Lato\" rel=\"stylesheet\" type=\"text/css\" >\r\n<div id=\"ppsPopupShell_[ID]\" class=\"ppsPopupShell ppsPopupListsShell\">\r\n	<a href=\"#\" class=\"ppsPopupClose ppsPopupClose_[close_btn]\"></a>\r\n	<div class=\"ppsInnerTblContent\">\r\n		<div class=\"ppsPopupListsInner ppsPopupInner\">\r\n			[if enb_txt_0]\r\n				<div class=\"ppsPopupTxt ppsPopupClassyTxt ppsPopupClassyTxt_0 ppsPopupTxt_0\">\r\n				[txt_0]\r\n				</div>\r\n			[endif]\r\n		</div><!--\r\n		--><div class=\"ppsRightCol\">\r\n			[if enb_label]\r\n				<div class=\"ppsPopupLabel ppsPopupListsLabel\">[label]</div>\r\n			[endif]\r\n			<div style=\"clear: both;\"></div>\r\n			[if enb_subscribe]\r\n				<div class=\"ppsSubscribeShell\">\r\n					[sub_form_start]\r\n					[sub_fields_html]\r\n					<input type=\"submit\" name=\"submit\" value=\"[sub_btn_label]\" />\r\n					[sub_form_end]\r\n					<div style=\"clear: both;\"></div>\r\n				</div>\r\n			[endif]\r\n			[if enb_sm]\r\n				<div class=\"ppsSm\">\r\n				[sm_html]\r\n				</div>\r\n			[endif]\r\n			[if enb_foot_note]\r\n				<div class=\"ppsFootNote\">\r\n				[foot_note]\r\n				</div>\r\n			[endif]\r\n		</div>\r\n	</div>\r\n</div>",css="@nice-blue: #5B83AD;\r\n#ppsPopupShell_[ID] {\r\n	width: [width][width_measure];\r\n  	padding: 0px;\r\n  	font-family: Lato;\r\n	font-size: 13px;\r\n	line-height: normal;\r\n	font-weight: normal;\r\n	color: #000;\r\n}\r\n#ppsPopupShell_[ID], #ppsPopupShell_[ID] * {\r\n	-webkit-box-sizing: border-box;\r\n	-moz-box-sizing:    border-box;\r\n	box-sizing:         border-box;\r\n}\r\n#ppsPopupShell_[ID] .ppsInnerTblContent {\r\n	display: block;\r\n	text-align: right;\r\n}\r\n#ppsPopupShell_[ID] .ppsPopupInner {\r\n  {% if popup.params.tpl.enb_subscribe or popup.params.tpl.enb_foot_note or popup.params.tpl.enb_sm %}\r\n  	width: 59%;\r\n	[else]\r\n  	width: 100%;\r\n  	[endif]\r\n	\r\n	vertical-align: middle;\r\n  	display: inline-block;\r\n  	margin: 0px;\r\n	text-align: left;\r\n	\r\n	[if bg_type_0 == \"color\"]\r\n	background: -moz-radial-gradient(center, ellipse cover, {{ adjust_brightness(popup.params.tpl.bg_color_0, 50) }} 0%, [bg_color_0] 100%); /* ff3.6+ */\r\n	background: -webkit-gradient(radial, center center, 0px, center center, 100%, color-stop(0%, {{ adjust_brightness(popup.params.tpl.bg_color_0, 50) }}), color-stop(100%, [bg_color_0])); /* safari4+,chrome */\r\n	background:-webkit-radial-gradient(center, ellipse cover, {{ adjust_brightness(popup.params.tpl.bg_color_0, 50) }} 0%, [bg_color_0] 100%); /* safari5.1+,chrome10+ */\r\n	background: -o-radial-gradient(center, ellipse cover, {{ adjust_brightness(popup.params.tpl.bg_color_0, 50) }} 0%, [bg_color_0] 100%); /* opera 11.10+ */\r\n	background: -ms-radial-gradient(center, ellipse cover, {{ adjust_brightness(popup.params.tpl.bg_color_0, 50) }} 0%, [bg_color_0] 100%); /* ie10+ */\r\n	background:radial-gradient(ellipse at center, {{ adjust_brightness(popup.params.tpl.bg_color_0, 50) }} 0%, [bg_color_0] 100%); /* w3c */\r\n	filter: progid:DXImageTransform.Microsoft.gradient( startColorstr=\"{{ adjust_brightness(popup.params.tpl.bg_color_0, 50) }}\", endColorstr=\"[bg_color_0]\",GradientType=1 ); /* ie6-9 */\r\n  	[elseif bg_type_0 == \"img\"]\r\n  	background-image: url(\"[bg_img_0]\");\r\n  	background-repeat: no-repeat;\r\n  	background-size: cover;\r\n  	[endif]\r\n  	\r\n}\r\n\r\n#ppsPopupShell_[ID] .ppsSubscribeShell form {\r\n	padding: 20px 20px 0;\r\n}\r\n\r\n#ppsPopupShell_[ID] .ppsSubscribeShell input::-webkit-input-placeholder { /* Chrome/Opera/Safari */\r\n    color: #ccc;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell input::-moz-placeholder { /* Firefox 19+ */\r\n    color: #ccc;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell input:-ms-input-placeholder { /* IE 10+ */\r\n    color: #ccc;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell input:-moz-placeholder { /* Firefox 18- */\r\n    color: #ccc;\r\n}\r\n\r\n#ppsPopupShell_[ID] .ppsSubscribeShell textarea::-webkit-input-placeholder { /* Chrome/Opera/Safari */\r\n    color: #ccc;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell textarea::-moz-placeholder { /* Firefox 19+ */\r\n    color: #ccc;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell textarea:-ms-input-placeholder { /* IE 10+ */\r\n    color: #ccc;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell textarea:-moz-placeholder { /* Firefox 18- */\r\n    color: #ccc;\r\n}\r\n/*For all Elements*/\r\n#ppsPopupShell_[ID] .ppsSubscribeShell input[type=\"email\"],\r\n#ppsPopupShell_[ID] .ppsSubscribeShell input[type=\"password\"],\r\n#ppsPopupShell_[ID] .ppsSubscribeShell input[type=\"text\"],\r\n#ppsPopupShell_[ID] .ppsSubscribeShell select,\r\n#ppsPopupShell_[ID] .ppsSubscribeShell textarea {\r\n	font-family: Lato;\r\n	font-size: 16px;\r\n	font-weight: normal;\r\n	line-height: normal;\r\n	color: #aaa;\r\n	text-align:center;\r\n	width: 100%;\r\n	-webkit-border-radius: 5px;\r\n	-moz-border-radius: 5px;\r\n	border-radius: 5px;\r\n	border: 0px solid transparent;\r\n	display:block;\r\n    \r\n    margin: 10px 0 0;\r\n	padding: 0 10px 0 10px;\r\n	height: 40px;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell textarea {\r\n	height: auto;\r\n	padding-top: 9px;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeForm input:first-child {\r\n	margin-top: 0px;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell select  {\r\n	margin: 0;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell label  {\r\n	display: block;\r\n	font-family: Lato;\r\n	font-size: 16px;\r\n	font-weight: normal;\r\n	line-height: normal;\r\n	color: #fff;\r\n	\r\n	margin: 10px 0 0;\r\n	text-align: center;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell label  span {\r\n	display: block;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell input[type=\"text\"][name=\"name\"] {\r\n	background-image: url(\"[PPS_ASSETS_URL]img/assets/user-black-icon.png\");\r\n	background-position: 12px center;\r\n	background-repeat: no-repeat;\r\n	background-size: 16px auto;\r\n	padding: 0 25px 0 35px;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell input[type=\"email\"] {\r\n	background-image: url(\"[PPS_ASSETS_URL]img/assets/email-black-icon.png\");\r\n	background-position: 11px center;\r\n	background-repeat: no-repeat;\r\n	background-size: 18px auto;\r\n	padding: 0 25px 0 35px;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubscribeShell input[type=\"submit\"] {\r\n	display: block;\r\n	font-family: Lato;\r\n	font-size: 17px;\r\n	font-weight: bold;\r\n	line-height: normal;\r\n	color: #fff;\r\n  	cursor: pointer;\r\n	margin: 10px 0 0;\r\n	-webkit-border-radius: 5px;\r\n	-moz-border-radius: 5px;\r\n	border-radius: 5px;\r\n	border: 0px solid transparent;\r\n	width: 100%;\r\n	height: 50px;\r\n	\r\n  	[if bg_type_2 == \"color\"]\r\n  	background: [bg_color_2] 100%;\r\n  	[elseif bg_type_2 == \"img\"]\r\n  	background: url(\"[bg_img_2]\");\r\n  	background-repeat: no-repeat;\r\n  	background-size: cover;\r\n  	[endif]\r\n}\r\n\r\n#ppsPopupShell_[ID] .ppsRightCol {\r\n  	border-radius: 3px;\r\n	-moz-border-radius: 3px;\r\n	-webkit-border-radius: 3px;\r\n  	min-height: 350px;\r\n  	width: 40%;\r\n	display: inline-block;\r\n  	padding: 20px;\r\n	margin: 0;\r\n	vertical-align: middle;\r\n	\r\n  	[if bg_type_1 == \"color\"]\r\n	background: [bg_color_1];\r\n  	[elseif bg_type_1 == \"img\"]\r\n  	background-image: url(\"[bg_img_1]\");\r\n  	background-repeat: no-repeat;\r\n  	background-size: cover;\r\n  	[endif]\r\n}\r\n\r\n#ppsPopupShell_[ID] .ppsPopupLabel {\r\n	color:#ffffff;\r\n  	font-family: \"Lato\";\r\n  	font-weight: normal;\r\n	line-height: normal;\r\n  	font-size: 24px;\r\n	letter-spacing: -1px;\r\n  	padding: 0px;\r\n	margin: 20px 0 0;\r\n  	text-align: center;\r\n  	\r\n    width: 100%;\r\n}\r\n\r\n#ppsPopupShell_[ID] .ppsPopupTxt_0 {\r\n	float: left;\r\n  	width: 100%;\r\n    height: 300px;\r\n	line-height: normal;\r\n  	font-size: 14px;\r\n  	font-family: Lato;\r\n	font-weight: 400;\r\n	\r\n	\r\n	padding: 0px;\r\n	margin: 0;\r\n	\r\n}\r\n\r\n#ppsPopupShell_[ID] .ppsPopupTxt_0 p {\r\n	font-size: inherit !important;\r\n	font-weight: inherit !important;\r\n	font-size: inherit !important;\r\n	line-height: inherit !important;\r\n	width: 100%;\r\n	margin: 0;\r\n	padding: 0;\r\n}\r\n\r\n#ppsPopupShell_[ID] .ppsPopupClose {\r\n	background-repeat: no-repeat;\r\n  	cursor: pointer;\r\n  	top:-20px;\r\n  	right:1px;\r\n  	z-index:99999;\r\n}\r\n#ppsPopupShell_[ID] .ppsSubMsg {\r\n	text-align: center;\r\n}\r\n#ppsPopupShell_[ID] .ppsPopupClose.ppsPopupClose_lists_black {\r\n 	top: 0 !important;\r\n  	right: 0 !important;\r\n}\r\n#ppsPopupShell_[ID] .ppsPopupClose:hover {\r\n	opacity: 0.8;\r\n}\r\n#ppsPopupShell_[ID] .ppsFootNote{\r\n	color: #ffffff;\r\n	text-align: center;\r\n    font-family: Lato;\r\n    font-size: x-small;\r\n    font-weight: bold;\r\n    line-height: 14px;\r\n  	margin: 10px 30px 5px;\r\n}",img_preview="230-6-new-york-prev.png",show_on="1",show_to="1",show_pages="1",type_id="1",date_created="2015-01-10 18:59:43",sort_order="1" WHERE id="27"');
		}
		if(dbPps::get('SELECT COUNT(*) AS total FROM @__popup WHERE id = 4 AND original_id = 0', 'one')) {	// Update Facebook Like PopUp if it is exist
			dbPps::query('UPDATE @__popup SET params="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" WHERE id = "4"');
		}
		dbPps::setAutoIncrement('@__popup', $lastAutoIncrement);
	}
	/*
	 * Make all text-like fields - look-like text fields, designed by template
	 */
	static public function makeTextFieldsCssUpdate() {
		$updated = (int) get_option('pps_txt_files_css_updated');
		if(!$updated) {
			dbPps::query('UPDATE @__popup SET css = REPLACE(css, "#ppsPopupShell_[ID] input[type=text]", "#ppsPopupShell_[ID] input[type=text],#ppsPopupShell_[ID] input[type=password]")');
			dbPps::query('UPDATE @__popup SET css = REPLACE(css, "#ppsPopupShell_[ID] .ppsSubscribeShell input[type=text]", "#ppsPopupShell_[ID] .ppsSubscribeShell input[type=text],#ppsPopupShell_[ID] .ppsSubscribeShell input[type=password]")');
			dbPps::query('UPDATE @__popup SET css = REPLACE(css, "input[type=password][name=\"email\"]", "input[name=\"email\"]")');
			dbPps::query('UPDATE wp_pps_popup SET css = REPLACE(css, "#ppsPopupShell_[ID] .ppsSubscribeShell input[type=text],#ppsPopupShell_[ID] .ppsSubscribeShell input[name=\"email\"]", "#ppsPopupShell_[ID] .ppsSubscribeShell input[type=text][name=\"email\"]")');
			update_option('pps_txt_files_css_updated', 1);
		}
	}
	static public function makeTextFieldsCssUpdateRound2() {
		$updated = (int) get_option('pps_txt_files_css_updated_2');
		if(!$updated) {
			dbPps::query('UPDATE @__popup SET css = REPLACE(css, "#ppsPopupShell_[ID] input[type=text]", "#ppsPopupShell_[ID] input[type=text],#ppsPopupShell_[ID] input[type=email]")');
			dbPps::query('UPDATE @__popup SET css = REPLACE(css, "#ppsPopupShell_[ID] .ppsSubscribeShell input[type=text]", "#ppsPopupShell_[ID] .ppsSubscribeShell input[type=text],#ppsPopupShell_[ID] .ppsSubscribeShell input[type=email]")');
			dbPps::query('UPDATE @__popup SET css = REPLACE(css, "input[type=email][name=\"email\"]", "input[name=\"email\"]")');
			dbPps::query('UPDATE wp_pps_popup SET css = REPLACE(css, "#ppsPopupShell_[ID] .ppsSubscribeShell input[type=text],#ppsPopupShell_[ID] .ppsSubscribeShell input[name=\"email\"]", "#ppsPopupShell_[ID] .ppsSubscribeShell input[type=text][name=\"email\"]")');
			update_option('pps_txt_files_css_updated_2', 1);
		}
	}
}
