<?php

if ( !defined( 'ABSPATH' ) ) {
	die( '-1' );
}

/**
 * Field Icon Picker.
 *
 * @param $settings
 * @param string $value
 *
 
 * @return string - html string.
 */
function mpl_form_icon_picker( $settings, $value = '' ) {

	$attrs = array();

	$css_class = 'mpl-field mpl-icon_picker';

	if ( !empty( $settings['name'] ) ) {
		$attrs[] = 'name="' . $settings['name'] . '"';
	}

	if ( !empty( $settings['id'] ) ) {
		$attrs[] = 'id="' . $settings['id'] . '"';
	}

	if ( !empty( $settings['el_class'] ) ) {
		$css_class.=' ' . $settings['el_class'];
	}

	$attrs[] = 'data-type="' . $settings['type'] . '"';

	/**
	 * Support Customizer
	 */
	if ( !empty( $settings['customize_link'] ) ) {
		$attrs[] = $settings['customize_link'];
	}

	$source_font = isset( $settings['font'] ) ? $settings['font'] : 'fontawesome';

	if ( !has_filter( 'mpl_source_' . $source_font ) ) {
		$source_font = 'fontawesome';
	}

	$arr = apply_filters( 'mpl_source_' . $source_font, array() );

	ob_start();
	?>
	<div class="<?php echo esc_attr( $css_class ) ?>">
		<select class="pf_value" <?php echo implode( ' ', $attrs ) ?>>
			<?php
			if ( !empty( $arr ) ) {

				foreach ( $arr as $group => $icons ) {

					if ( !is_array( $icons ) || !is_array( current( $icons ) ) ) {
						$class_key = key( $icons );
						echo '<option value="' . esc_attr( $class_key ) . '" ' . ( strcmp( $class_key, $value ) === 0 ? 'selected' : '' ) . '>' . esc_html( current( $icons ) ) . '</option>' . "\n";
					} else {

						echo '<optgroup label="' . esc_attr( $group ) . '">' . "\n";
						foreach ( $icons as $key => $label ) {
							$class_key = key( $label );
							echo'<option value="' . esc_attr( $class_key ) . '" ' . ( strcmp( $class_key, $value ) === 0 ? 'selected' : '' ) . '>' . esc_html( current( $label ) ) . '</option>' . "\n";
						}
						echo'</optgroup>' . "\n";
					}
				}
			}
			?>
		</select>
	</div>
	<?php
	return ob_get_clean();
}

/**
 * Fontawesome icons
 * 
 
 * @return array - of icons for iconpicker.
 */
function mpl_source_fontawesome( $icons ) {
	// Categorized icons ( you can also output simple array ( key=> value ), where key = icon class, value = icon readable name ).

	$fontawesome_icons = array(
		'20 New Icons in 4.5' => array(
			array( 'fa fa-bluetooth' => 'Bluetooth' ),
			array( 'fa fa-bluetooth-b' => 'Bluetooth-b' ),
			array( 'fa fa-codiepie' => 'Codiepie' ),
			array( 'fa fa-credit-card-alt' => 'Credit-card-alt' ),
			array( 'fa fa-edge' => 'Edge' ),
			array( 'fa fa-fort-awesome' => 'Fort-awesome' ),
			array( 'fa fa-hashtag' => 'Hashtag' ),
			array( 'fa fa-mixcloud' => 'Mixcloud' ),
			array( 'fa fa-modx' => 'Modx' ),
			array( 'fa fa-pause-circle' => 'Pause-circle' ),
			array( 'fa fa-pause-circle-o' => 'Pause-circle-o' ),
			array( 'fa fa-percent' => 'Percent' ),
			array( 'fa fa-product-hunt' => 'Product-hunt' ),
			array( 'fa fa-reddit-alien' => 'Reddit-alien' ),
			array( 'fa fa-scribd' => 'Scribd' ),
			array( 'fa fa-shopping-bag' => 'Shopping-bag' ),
			array( 'fa fa-shopping-basket' => 'Shopping-basket' ),
			array( 'fa fa-stop-circle' => 'Stop-circle' ),
			array( 'fa fa-stop-circle-o' => 'Stop-circle-o' ),
			array( 'fa fa-usb' => 'Usb' ),
		),
		'Web Application Icons' => array(
			array( 'fa fa-adjust' => 'Adjust' ),
			array( 'fa fa-anchor' => 'Anchor' ),
			array( 'fa fa-archive' => 'Archive' ),
			array( 'fa fa-area-chart' => 'Area Chart' ),
			array( 'fa fa-arrows' => 'Arrows' ),
			array( 'fa fa-arrows-h' => 'Arrows Horizontal' ),
			array( 'fa fa-arrows-v' => 'Arrows Vertical' ),
			array( 'fa fa-asterisk' => 'Asterisk' ),
			array( 'fa fa-at' => 'At' ),
			array( 'fa fa-balance-scale' => 'Balance Scale' ),
			array( 'fa fa-ban' => 'Ban' ),
			array( 'fa fa-bar-chart' => 'Bar Chart (bar-chart-o)' ),
			array( 'fa fa-barcode' => 'Barcode' ),
			array( 'fa fa-bars' => 'Bars (navicon, reorder)' ),
			array( 'fa fa-battery-empty' => 'Battery Empty (battery-0)' ),
			array( 'fa fa-battery-full' => 'Battery Full (battery-4)' ),
			array( 'fa fa-battery-half' => 'Battery 1/2 Full (battery-2)' ),
			array( 'fa fa-battery-quarter' => 'Battery 1/4 Full (battery-1)' ),
			array( 'fa fa-battery-three-quarters' => 'Battery 3/4 Full (battery-3)' ),
			array( 'fa fa-bed' => 'Bed (hotel)' ),
			array( 'fa fa-beer' => 'Beer' ),
			array( 'fa fa-bell' => 'Bell' ),
			array( 'fa fa-bell-o' => 'Bell Outlined' ),
			array( 'fa fa-bell-slash' => 'Bell Slash' ),
			array( 'fa fa-bell-slash-o' => 'Bell Slash Outlined' ),
			array( 'fa fa-bicycle' => 'Bicycle' ),
			array( 'fa fa-binoculars' => 'Binoculars' ),
			array( 'fa fa-birthday-cake' => 'Birthday Cake' ),
			array( 'fa fa-bluetooth' => 'Bluetooth' ),
			array( 'fa fa-bluetooth-b' => 'Bluetooth' ),
			array( 'fa fa-bolt' => 'Lightning Bolt (flash)' ),
			array( 'fa fa-bomb' => 'Bomb' ),
			array( 'fa fa-book' => 'Book' ),
			array( 'fa fa-bookmark' => 'Bookmark' ),
			array( 'fa fa-bookmark-o' => 'Bookmark Outlined' ),
			array( 'fa fa-briefcase' => 'Briefcase' ),
			array( 'fa fa-bug' => 'Bug' ),
			array( 'fa fa-building' => 'Building' ),
			array( 'fa fa-building-o' => 'Building Outlined' ),
			array( 'fa fa-bullhorn' => 'Bullhorn' ),
			array( 'fa fa-bullseye' => 'Bullseye' ),
			array( 'fa fa-bus' => 'Bus' ),
			array( 'fa fa-calculator' => 'Calculator' ),
			array( 'fa fa-calendar' => 'Calendar' ),
			array( 'fa fa-calendar-check-o' => 'Calendar Check Outlined' ),
			array( 'fa fa-calendar-minus-o' => 'Calendar Minus Outlined' ),
			array( 'fa fa-calendar-o' => 'Calendar-o' ),
			array( 'fa fa-calendar-plus-o' => 'Calendar Plus Outlined' ),
			array( 'fa fa-calendar-times-o' => 'Calendar Times Outlined' ),
			array( 'fa fa-camera' => 'Camera' ),
			array( 'fa fa-camera-retro' => 'Camera-retro' ),
			array( 'fa fa-car' => 'Car (automobile)' ),
			array( 'fa fa-caret-square-o-down' => 'Caret Square Outlined Down (toggle-down)' ),
			array( 'fa fa-caret-square-o-left' => 'Caret Square Outlined Left (toggle-left)' ),
			array( 'fa fa-caret-square-o-right' => 'Caret Square Outlined Right (toggle-right)' ),
			array( 'fa fa-caret-square-o-up' => 'Caret Square Outlined Up (toggle-up)' ),
			array( 'fa fa-cart-arrow-down' => 'Shopping Cart Arrow Down' ),
			array( 'fa fa-cart-plus' => 'Add to Shopping Cart' ),
			array( 'fa fa-cc' => 'Closed Captions' ),
			array( 'fa fa-certificate' => 'Certificate' ),
			array( 'fa fa-check' => 'Check' ),
			array( 'fa fa-check-circle' => 'Check Circle' ),
			array( 'fa fa-check-circle-o' => 'Check Circle Outlined' ),
			array( 'fa fa-check-square' => 'Check Square' ),
			array( 'fa fa-check-square-o' => 'Check Square Outlined' ),
			array( 'fa fa-child' => 'Child' ),
			array( 'fa fa-circle' => 'Circle' ),
			array( 'fa fa-circle-o' => 'Circle Outlined' ),
			array( 'fa fa-circle-o-notch' => 'Circle Outlined Notched' ),
			array( 'fa fa-circle-thin' => 'Circle Outlined Thin' ),
			array( 'fa fa-clock-o' => 'Clock Outlined' ),
			array( 'fa fa-clone' => 'Clone' ),
			array( 'fa fa-cloud' => 'Cloud' ),
			array( 'fa fa-cloud-download' => 'Cloud Download' ),
			array( 'fa fa-cloud-upload' => 'Cloud Upload' ),
			array( 'fa fa-code' => 'Code' ),
			array( 'fa fa-code-fork' => 'Code-fork' ),
			array( 'fa fa-coffee' => 'Coffee' ),
			array( 'fa fa-cog' => 'Cog (gear)' ),
			array( 'fa fa-cogs' => 'Cogs (gears)' ),
			array( 'fa fa-comment' => 'Comment' ),
			array( 'fa fa-comment-o' => 'Comment-o' ),
			array( 'fa fa-commenting' => 'Commenting' ),
			array( 'fa fa-commenting-o' => 'Commenting Outlined' ),
			array( 'fa fa-comments' => 'Comments' ),
			array( 'fa fa-comments-o' => 'Comments-o' ),
			array( 'fa fa-compass' => 'Compass' ),
			array( 'fa fa-copyright' => 'Copyright' ),
			array( 'fa fa-creative-commons' => 'Creative Commons' ),
			array( 'fa fa-credit-card' => 'Credit-card' ),
			array( 'fa fa-credit-card-alt' => 'Credit Card' ),
			array( 'fa fa-crop' => 'Crop' ),
			array( 'fa fa-crosshairs' => 'Crosshairs' ),
			array( 'fa fa-cube' => 'Cube' ),
			array( 'fa fa-cubes' => 'Cubes' ),
			array( 'fa fa-cutlery' => 'Cutlery' ),
			array( 'fa fa-database' => 'Database' ),
			array( 'fa fa-desktop' => 'Desktop' ),
			array( 'fa fa-diamond' => 'Diamond' ),
			array( 'fa fa-dot-circle-o' => 'Dot Circle Outlined' ),
			array( 'fa fa-download' => 'Download' ),
			array( 'fa fa-ellipsis-h' => 'Ellipsis Horizontal' ),
			array( 'fa fa-ellipsis-v' => 'Ellipsis Vertical' ),
			array( 'fa fa-envelope' => 'Envelope' ),
			array( 'fa fa-envelope-o' => 'Envelope Outlined' ),
			array( 'fa fa-envelope-square' => 'Envelope Square' ),
			array( 'fa fa-eraser' => 'Eraser' ),
			array( 'fa fa-exchange' => 'Exchange' ),
			array( 'fa fa-exclamation' => 'Exclamation' ),
			array( 'fa fa-exclamation-circle' => 'Exclamation Circle' ),
			array( 'fa fa-exclamation-triangle' => 'Exclamation Triangle (warning)' ),
			array( 'fa fa-external-link' => 'External Link' ),
			array( 'fa fa-external-link-square' => 'External Link Square' ),
			array( 'fa fa-eye' => 'Eye' ),
			array( 'fa fa-eye-slash' => 'Eye Slash' ),
			array( 'fa fa-eyedropper' => 'Eyedropper' ),
			array( 'fa fa-fax' => 'Fax' ),
			array( 'fa fa-female' => 'Female' ),
			array( 'fa fa-fighter-jet' => 'Fighter-jet' ),
			array( 'fa fa-file-archive-o' => 'Archive File Outlined (file-zip-o)' ),
			array( 'fa fa-file-audio-o' => 'Audio File Outlined (file-sound-o)' ),
			array( 'fa fa-file-code-o' => 'Code File Outlined' ),
			array( 'fa fa-file-excel-o' => 'Excel File Outlined' ),
			array( 'fa fa-file-image-o' => 'Image File Outlined (file-photo-o, file-picture-o)' ),
			array( 'fa fa-file-pdf-o' => 'PDF File Outlined' ),
			array( 'fa fa-file-powerpoint-o' => 'Powerpoint File Outlined' ),
			array( 'fa fa-file-video-o' => 'Video File Outlined (file-movie-o)' ),
			array( 'fa fa-file-word-o' => 'Word File Outlined' ),
			array( 'fa fa-film' => 'Film' ),
			array( 'fa fa-filter' => 'Filter' ),
			array( 'fa fa-fire' => 'Fire' ),
			array( 'fa fa-fire-extinguisher' => 'Fire-extinguisher' ),
			array( 'fa fa-flag' => 'Flag' ),
			array( 'fa fa-flag-checkered' => 'Flag-checkered' ),
			array( 'fa fa-flag-o' => 'Flag Outlined' ),
			array( 'fa fa-flask' => 'Flask' ),
			array( 'fa fa-folder' => 'Folder' ),
			array( 'fa fa-folder-o' => 'Folder Outlined' ),
			array( 'fa fa-folder-open' => 'Folder Open' ),
			array( 'fa fa-folder-open-o' => 'Folder Open Outlined' ),
			array( 'fa fa-frown-o' => 'Frown Outlined' ),
			array( 'fa fa-futbol-o' => 'Futbol Outlined (soccer-ball-o)' ),
			array( 'fa fa-gamepad' => 'Gamepad' ),
			array( 'fa fa-gavel' => 'Gavel (legal)' ),
			array( 'fa fa-gift' => 'Gift' ),
			array( 'fa fa-glass' => 'Glass' ),
			array( 'fa fa-globe' => 'Globe' ),
			array( 'fa fa-graduation-cap' => 'Graduation Cap (mortar-board)' ),
			array( 'fa fa-hand-lizard-o' => 'Lizard (Hand)' ),
			array( 'fa fa-hand-paper-o' => 'Paper (Hand) (hand-stop-o)' ),
			array( 'fa fa-hand-peace-o' => 'Hand Peace' ),
			array( 'fa fa-hand-pointer-o' => 'Hand Pointer' ),
			array( 'fa fa-hand-rock-o' => 'Rock (Hand) (hand-grab-o)' ),
			array( 'fa fa-hand-scissors-o' => 'Scissors (Hand)' ),
			array( 'fa fa-hand-spock-o' => 'Spock (Hand)' ),
			array( 'fa fa-hashtag' => 'Hashtag' ),
			array( 'fa fa-hdd-o' => 'HDD' ),
			array( 'fa fa-headphones' => 'Headphones' ),
			array( 'fa fa-heart' => 'Heart' ),
			array( 'fa fa-heart-o' => 'Heart Outlined' ),
			array( 'fa fa-heartbeat' => 'Heartbeat' ),
			array( 'fa fa-history' => 'History' ),
			array( 'fa fa-home' => 'Home' ),
			array( 'fa fa-hourglass' => 'Hourglass' ),
			array( 'fa fa-hourglass-end' => 'Hourglass End (hourglass-3)' ),
			array( 'fa fa-hourglass-half' => 'Hourglass Half (hourglass-2)' ),
			array( 'fa fa-hourglass-o' => 'Hourglass Outlined' ),
			array( 'fa fa-hourglass-start' => 'Hourglass Start (hourglass-1)' ),
			array( 'fa fa-i-cursor' => 'I Beam Cursor' ),
			array( 'fa fa-inbox' => 'Inbox' ),
			array( 'fa fa-industry' => 'Industry' ),
			array( 'fa fa-info' => 'Info' ),
			array( 'fa fa-info-circle' => 'Info Circle' ),
			array( 'fa fa-key' => 'Key' ),
			array( 'fa fa-keyboard-o' => 'Keyboard Outlined' ),
			array( 'fa fa-language' => 'Language' ),
			array( 'fa fa-laptop' => 'Laptop' ),
			array( 'fa fa-leaf' => 'Leaf' ),
			array( 'fa fa-lemon-o' => 'Lemon Outlined' ),
			array( 'fa fa-level-down' => 'Level Down' ),
			array( 'fa fa-level-up' => 'Level Up' ),
			array( 'fa fa-life-ring' => 'Life Ring (life-bouy, life-buoy, life-saver, support)' ),
			array( 'fa fa-lightbulb-o' => 'Lightbulb Outlined' ),
			array( 'fa fa-line-chart' => 'Line Chart' ),
			array( 'fa fa-location-arrow' => 'Location-arrow' ),
			array( 'fa fa-lock' => 'Lock' ),
			array( 'fa fa-magic' => 'Magic' ),
			array( 'fa fa-magnet' => 'Magnet' ),
			array( 'fa fa-male' => 'Male' ),
			array( 'fa fa-map' => 'Map' ),
			array( 'fa fa-map-marker' => 'Map-marker' ),
			array( 'fa fa-map-o' => 'Map Outline' ),
			array( 'fa fa-map-pin' => 'Map Pin' ),
			array( 'fa fa-map-signs' => 'Map Signs' ),
			array( 'fa fa-meh-o' => 'Meh Outlined' ),
			array( 'fa fa-microphone' => 'Microphone' ),
			array( 'fa fa-microphone-slash' => 'Microphone Slash' ),
			array( 'fa fa-minus' => 'Minus' ),
			array( 'fa fa-minus-circle' => 'Minus Circle' ),
			array( 'fa fa-minus-square' => 'Minus Square' ),
			array( 'fa fa-minus-square-o' => 'Minus Square Outlined' ),
			array( 'fa fa-mobile' => 'Mobile Phone (mobile-phone)' ),
			array( 'fa fa-money' => 'Money' ),
			array( 'fa fa-moon-o' => 'Moon Outlined' ),
			array( 'fa fa-motorcycle' => 'Motorcycle' ),
			array( 'fa fa-mouse-pointer' => 'Mouse Pointer' ),
			array( 'fa fa-music' => 'Music' ),
			array( 'fa fa-newspaper-o' => 'Newspaper Outlined' ),
			array( 'fa fa-object-group' => 'Object Group' ),
			array( 'fa fa-object-ungroup' => 'Object Ungroup' ),
			array( 'fa fa-paint-brush' => 'Paint Brush' ),
			array( 'fa fa-paper-plane' => 'Paper Plane (send)' ),
			array( 'fa fa-paper-plane-o' => 'Paper Plane Outlined (send-o)' ),
			array( 'fa fa-paw' => 'Paw' ),
			array( 'fa fa-pencil' => 'Pencil' ),
			array( 'fa fa-pencil-square' => 'Pencil Square' ),
			array( 'fa fa-pencil-square-o' => 'Pencil Square Outlined (edit)' ),
			array( 'fa fa-percent' => 'Percent' ),
			array( 'fa fa-phone' => 'Phone' ),
			array( 'fa fa-phone-square' => 'Phone Square' ),
			array( 'fa fa-picture-o' => 'Picture Outlined (photo, image)' ),
			array( 'fa fa-pie-chart' => 'Pie Chart' ),
			array( 'fa fa-plane' => 'Plane' ),
			array( 'fa fa-plug' => 'Plug' ),
			array( 'fa fa-plus' => 'Plus' ),
			array( 'fa fa-plus-circle' => 'Plus Circle' ),
			array( 'fa fa-plus-square' => 'Plus Square' ),
			array( 'fa fa-plus-square-o' => 'Plus Square Outlined' ),
			array( 'fa fa-power-off' => 'Power Off' ),
			array( 'fa fa-print' => 'Print' ),
			array( 'fa fa-puzzle-piece' => 'Puzzle Piece' ),
			array( 'fa fa-qrcode' => 'Qrcode' ),
			array( 'fa fa-question' => 'Question' ),
			array( 'fa fa-question-circle' => 'Question Circle' ),
			array( 'fa fa-quote-left' => 'Quote-left' ),
			array( 'fa fa-quote-right' => 'Quote-right' ),
			array( 'fa fa-random' => 'Random' ),
			array( 'fa fa-recycle' => 'Recycle' ),
			array( 'fa fa-refresh' => 'Refresh' ),
			array( 'fa fa-registered' => 'Registered Trademark' ),
			array( 'fa fa-reply' => 'Reply (mail-reply)' ),
			array( 'fa fa-reply-all' => 'Reply-all (mail-reply-all)' ),
			array( 'fa fa-retweet' => 'Retweet' ),
			array( 'fa fa-road' => 'Road' ),
			array( 'fa fa-rocket' => 'Rocket' ),
			array( 'fa fa-rss' => 'Rss (feed)' ),
			array( 'fa fa-rss-square' => 'RSS Square' ),
			array( 'fa fa-search' => 'Search' ),
			array( 'fa fa-search-minus' => 'Search Minus' ),
			array( 'fa fa-search-plus' => 'Search Plus' ),
			array( 'fa fa-server' => 'Server' ),
			array( 'fa fa-share' => 'Share (mail-forward)' ),
			array( 'fa fa-share-alt' => 'Share Alt' ),
			array( 'fa fa-share-alt-square' => 'Share Alt Square' ),
			array( 'fa fa-share-square' => 'Share Square' ),
			array( 'fa fa-share-square-o' => 'Share Square Outlined' ),
			array( 'fa fa-shield' => 'Shield' ),
			array( 'fa fa-ship' => 'Ship' ),
			array( 'fa fa-shopping-bag' => 'Shopping Bag' ),
			array( 'fa fa-shopping-basket' => 'Shopping Basket' ),
			array( 'fa fa-shopping-cart' => 'Shopping-cart' ),
			array( 'fa fa-sign-in' => 'Sign In' ),
			array( 'fa fa-sign-out' => 'Sign Out' ),
			array( 'fa fa-signal' => 'Signal' ),
			array( 'fa fa-sitemap' => 'Sitemap' ),
			array( 'fa fa-sliders' => 'Sliders' ),
			array( 'fa fa-smile-o' => 'Smile Outlined' ),
			array( 'fa fa-sort' => 'Sort (unsorted)' ),
			array( 'fa fa-sort-alpha-asc' => 'Sort Alpha Ascending' ),
			array( 'fa fa-sort-alpha-desc' => 'Sort Alpha Descending' ),
			array( 'fa fa-sort-amount-asc' => 'Sort Amount Ascending' ),
			array( 'fa fa-sort-amount-desc' => 'Sort Amount Descending' ),
			array( 'fa fa-sort-asc' => 'Sort Ascending (sort-up)' ),
			array( 'fa fa-sort-desc' => 'Sort Descending (sort-down)' ),
			array( 'fa fa-sort-numeric-asc' => 'Sort Numeric Ascending' ),
			array( 'fa fa-sort-numeric-desc' => 'Sort Numeric Descending' ),
			array( 'fa fa-space-shuttle' => 'Space Shuttle' ),
			array( 'fa fa-spinner' => 'Spinner' ),
			array( 'fa fa-spoon' => 'Spoon' ),
			array( 'fa fa-square' => 'Square' ),
			array( 'fa fa-square-o' => 'Square Outlined' ),
			array( 'fa fa-star' => 'Star' ),
			array( 'fa fa-star-half' => 'Star-half' ),
			array( 'fa fa-star-half-o' => 'Star Half Outlined (star-half-empty, star-half-full)' ),
			array( 'fa fa-star-o' => 'Star Outlined' ),
			array( 'fa fa-sticky-note' => 'Sticky Note' ),
			array( 'fa fa-sticky-note-o' => 'Sticky Note Outlined' ),
			array( 'fa fa-street-view' => 'Street View' ),
			array( 'fa fa-suitcase' => 'Suitcase' ),
			array( 'fa fa-sun-o' => 'Sun Outlined' ),
			array( 'fa fa-tablet' => 'Tablet' ),
			array( 'fa fa-tachometer' => 'Tachometer (dashboard)' ),
			array( 'fa fa-tag' => 'Tag' ),
			array( 'fa fa-tags' => 'Tags' ),
			array( 'fa fa-tasks' => 'Tasks' ),
			array( 'fa fa-taxi' => 'Taxi (cab)' ),
			array( 'fa fa-television' => 'Television (tv)' ),
			array( 'fa fa-terminal' => 'Terminal' ),
			array( 'fa fa-thumb-tack' => 'Thumb Tack' ),
			array( 'fa fa-thumbs-down' => 'Thumbs-down' ),
			array( 'fa fa-thumbs-o-down' => 'Thumbs Down Outlined' ),
			array( 'fa fa-thumbs-o-up' => 'Thumbs Up Outlined' ),
			array( 'fa fa-thumbs-up' => 'Thumbs-up' ),
			array( 'fa fa-ticket' => 'Ticket' ),
			array( 'fa fa-times' => 'Times (remove, close)' ),
			array( 'fa fa-times-circle' => 'Times Circle' ),
			array( 'fa fa-times-circle-o' => 'Times Circle Outlined' ),
			array( 'fa fa-tint' => 'Tint' ),
			array( 'fa fa-toggle-off' => 'Toggle Off' ),
			array( 'fa fa-toggle-on' => 'Toggle On' ),
			array( 'fa fa-trademark' => 'Trademark' ),
			array( 'fa fa-trash' => 'Trash' ),
			array( 'fa fa-trash-o' => 'Trash Outlined' ),
			array( 'fa fa-tree' => 'Tree' ),
			array( 'fa fa-trophy' => 'Trophy' ),
			array( 'fa fa-truck' => 'Truck' ),
			array( 'fa fa-tty' => 'TTY' ),
			array( 'fa fa-umbrella' => 'Umbrella' ),
			array( 'fa fa-university' => 'University (institution, bank)' ),
			array( 'fa fa-unlock' => 'Unlock' ),
			array( 'fa fa-unlock-alt' => 'Unlock Alt' ),
			array( 'fa fa-upload' => 'Upload' ),
			array( 'fa fa-user' => 'User' ),
			array( 'fa fa-user-plus' => 'Add User' ),
			array( 'fa fa-user-secret' => 'User Secret' ),
			array( 'fa fa-user-times' => 'Remove User' ),
			array( 'fa fa-users' => 'Users (group)' ),
			array( 'fa fa-video-camera' => 'Video Camera' ),
			array( 'fa fa-volume-down' => 'Volume-down' ),
			array( 'fa fa-volume-off' => 'Volume-off' ),
			array( 'fa fa-volume-up' => 'Volume-up' ),
			array( 'fa fa-wheelchair' => 'Wheelchair' ),
			array( 'fa fa-wifi' => 'WiFi' ),
			array( 'fa fa-wrench' => 'Wrench' ),
		),
		'File Type Icons' => array(
			array( 'fa fa-file' => 'File' ),
			array( 'fa fa-file-archive-o' => 'Archive File Outlined (file-zip-o)' ),
			array( 'fa fa-file-audio-o' => 'Audio File Outlined (file-sound-o)' ),
			array( 'fa fa-file-code-o' => 'Code File Outlined' ),
			array( 'fa fa-file-excel-o' => 'Excel File Outlined' ),
			array( 'fa fa-file-image-o' => 'Image File Outlined (file-photo-o, file-picture-o)' ),
			array( 'fa fa-file-o' => 'File Outlined' ),
			array( 'fa fa-file-pdf-o' => 'PDF File Outlined' ),
			array( 'fa fa-file-powerpoint-o' => 'Powerpoint File Outlined' ),
			array( 'fa fa-file-text' => 'File Text' ),
			array( 'fa fa-file-text-o' => 'File Text Outlined' ),
			array( 'fa fa-file-video-o' => 'Video File Outlined (file-movie-o)' ),
			array( 'fa fa-file-word-o' => 'Word File Outlined' ),
		),
		'Spinner Icons' => array(
			array( 'fa fa-circle-o-notch' => 'Circle Outlined Notched' ),
			array( 'fa fa-cog' => 'Cog (gear)' ),
			array( 'fa fa-refresh' => 'Refresh' ),
			array( 'fa fa-spinner' => 'Spinner' ),
		),
		'Form Control Icons' => array(
			array( 'fa fa-check-square' => 'Check Square' ),
			array( 'fa fa-check-square-o' => 'Check Square Outlined' ),
			array( 'fa fa-circle' => 'Circle' ),
			array( 'fa fa-circle-o' => 'Circle Outlined' ),
			array( 'fa fa-dot-circle-o' => 'Dot Circle Outlined' ),
			array( 'fa fa-minus-square' => 'Minus Square' ),
			array( 'fa fa-minus-square-o' => 'Minus Square Outlined' ),
			array( 'fa fa-plus-square' => 'Plus Square' ),
			array( 'fa fa-plus-square-o' => 'Plus Square Outlined' ),
			array( 'fa fa-square' => 'Square' ),
			array( 'fa fa-square-o' => 'Square Outlined' ),
		),
		'Payment Icons' => array(
			array( 'fa fa-cc-amex' => 'American Express Credit Card' ),
			array( 'fa fa-cc-diners-club' => 'Diner\'s Club Credit Card' ),
			array( 'fa fa-cc-discover' => 'Discover Credit Card' ),
			array( 'fa fa-cc-jcb' => 'JCB Credit Card' ),
			array( 'fa fa-cc-mastercard' => 'MasterCard Credit Card' ),
			array( 'fa fa-cc-paypal' => 'Paypal Credit Card' ),
			array( 'fa fa-cc-stripe' => 'Stripe Credit Card' ),
			array( 'fa fa-cc-visa' => 'Visa Credit Card' ),
			array( 'fa fa-credit-card' => 'Credit-card' ),
			array( 'fa fa-credit-card-alt' => 'Credit Card' ),
			array( 'fa fa-google-wallet' => 'Google Wallet' ),
			array( 'fa fa-paypal' => 'Paypal' ),
		),
		'Chart Icons' => array(
			array( 'fa fa-area-chart' => 'Area Chart' ),
			array( 'fa fa-bar-chart' => 'Bar Chart (bar-chart-o)' ),
			array( 'fa fa-line-chart' => 'Line Chart' ),
			array( 'fa fa-pie-chart' => 'Pie Chart' ),
		),
		'Currency Icons' => array(
			array( 'fa fa-btc' => 'Bitcoin (BTC) (bitcoin)' ),
			array( 'fa fa-eur' => 'Euro (EUR) (euro)' ),
			array( 'fa fa-gbp' => 'GBP' ),
			array( 'fa fa-gg' => 'GG Currency' ),
			array( 'fa fa-gg-circle' => 'GG Currency Circle' ),
			array( 'fa fa-ils' => 'Shekel (ILS) (shekel, sheqel)' ),
			array( 'fa fa-inr' => 'Indian Rupee (INR) (rupee)' ),
			array( 'fa fa-jpy' => 'Japanese Yen (JPY) (cny, rmb, yen)' ),
			array( 'fa fa-krw' => 'Korean Won (KRW) (won)' ),
			array( 'fa fa-money' => 'Money' ),
			array( 'fa fa-rub' => 'Russian Ruble (RUB) (ruble, rouble)' ),
			array( 'fa fa-try' => 'Turkish Lira (TRY) (turkish-lira)' ),
			array( 'fa fa-usd' => 'US Dollar (dollar)' ),
		),
		'Text Editor Icons' => array(
			array( 'fa fa-align-center' => 'Align-center' ),
			array( 'fa fa-align-justify' => 'Align-justify' ),
			array( 'fa fa-align-left' => 'Align-left' ),
			array( 'fa fa-align-right' => 'Align-right' ),
			array( 'fa fa-bold' => 'Bold' ),
			array( 'fa fa-chain-broken' => 'Chain Broken (unlink)' ),
			array( 'fa fa-clipboard' => 'Clipboard (paste)' ),
			array( 'fa fa-columns' => 'Columns' ),
			array( 'fa fa-eraser' => 'Eraser' ),
			array( 'fa fa-file' => 'File' ),
			array( 'fa fa-file-o' => 'File Outlined' ),
			array( 'fa fa-file-text' => 'File Text' ),
			array( 'fa fa-file-text-o' => 'File Text Outlined' ),
			array( 'fa fa-files-o' => 'Files Outlined (copy)' ),
			array( 'fa fa-floppy-o' => 'Floppy Outlined (save)' ),
			array( 'fa fa-font' => 'Font' ),
			array( 'fa fa-header' => 'Header' ),
			array( 'fa fa-indent' => 'Indent' ),
			array( 'fa fa-italic' => 'Italic' ),
			array( 'fa fa-link' => 'Link (chain)' ),
			array( 'fa fa-list' => 'List' ),
			array( 'fa fa-list-alt' => 'List-alt' ),
			array( 'fa fa-list-ol' => 'List-ol' ),
			array( 'fa fa-list-ul' => 'List-ul' ),
			array( 'fa fa-outdent' => 'Outdent (dedent)' ),
			array( 'fa fa-paperclip' => 'Paperclip' ),
			array( 'fa fa-paragraph' => 'Paragraph' ),
			array( 'fa fa-repeat' => 'Repeat (rotate-right)' ),
			array( 'fa fa-scissors' => 'Scissors (cut)' ),
			array( 'fa fa-strikethrough' => 'Strikethrough' ),
			array( 'fa fa-subscript' => 'Subscript' ),
			array( 'fa fa-superscript' => 'Superscript' ),
			array( 'fa fa-table' => 'Table' ),
			array( 'fa fa-text-height' => 'Text-height' ),
			array( 'fa fa-text-width' => 'Text-width' ),
			array( 'fa fa-th' => 'Th' ),
			array( 'fa fa-th-large' => 'Th-large' ),
			array( 'fa fa-th-list' => 'Th-list' ),
			array( 'fa fa-underline' => 'Underline' ),
			array( 'fa fa-undo' => 'Undo (rotate-left)' ),
		),
		'Directional Icons' => array(
			array( 'fa fa-angle-double-down' => 'Angle Double Down' ),
			array( 'fa fa-angle-double-left' => 'Angle Double Left' ),
			array( 'fa fa-angle-double-right' => 'Angle Double Right' ),
			array( 'fa fa-angle-double-up' => 'Angle Double Up' ),
			array( 'fa fa-angle-down' => 'Angle-down' ),
			array( 'fa fa-angle-left' => 'Angle-left' ),
			array( 'fa fa-angle-right' => 'Angle-right' ),
			array( 'fa fa-angle-up' => 'Angle-up' ),
			array( 'fa fa-arrow-circle-down' => 'Arrow Circle Down' ),
			array( 'fa fa-arrow-circle-left' => 'Arrow Circle Left' ),
			array( 'fa fa-arrow-circle-o-down' => 'Arrow Circle Outlined Down' ),
			array( 'fa fa-arrow-circle-o-left' => 'Arrow Circle Outlined Left' ),
			array( 'fa fa-arrow-circle-o-right' => 'Arrow Circle Outlined Right' ),
			array( 'fa fa-arrow-circle-o-up' => 'Arrow Circle Outlined Up' ),
			array( 'fa fa-arrow-circle-right' => 'Arrow Circle Right' ),
			array( 'fa fa-arrow-circle-up' => 'Arrow Circle Up' ),
			array( 'fa fa-arrow-down' => 'Arrow-down' ),
			array( 'fa fa-arrow-left' => 'Arrow-left' ),
			array( 'fa fa-arrow-right' => 'Arrow-right' ),
			array( 'fa fa-arrow-up' => 'Arrow-up' ),
			array( 'fa fa-arrows' => 'Arrows' ),
			array( 'fa fa-arrows-alt' => 'Arrows Alt' ),
			array( 'fa fa-arrows-h' => 'Arrows Horizontal' ),
			array( 'fa fa-arrows-v' => 'Arrows Vertical' ),
			array( 'fa fa-caret-down' => 'Caret Down' ),
			array( 'fa fa-caret-left' => 'Caret Left' ),
			array( 'fa fa-caret-right' => 'Caret Right' ),
			array( 'fa fa-caret-square-o-down' => 'Caret Square Outlined Down (toggle-down)' ),
			array( 'fa fa-caret-square-o-left' => 'Caret Square Outlined Left (toggle-left)' ),
			array( 'fa fa-caret-square-o-right' => 'Caret Square Outlined Right (toggle-right)' ),
			array( 'fa fa-caret-square-o-up' => 'Caret Square Outlined Up (toggle-up)' ),
			array( 'fa fa-caret-up' => 'Caret Up' ),
			array( 'fa fa-chevron-circle-down' => 'Chevron Circle Down' ),
			array( 'fa fa-chevron-circle-left' => 'Chevron Circle Left' ),
			array( 'fa fa-chevron-circle-right' => 'Chevron Circle Right' ),
			array( 'fa fa-chevron-circle-up' => 'Chevron Circle Up' ),
			array( 'fa fa-chevron-down' => 'Chevron-down' ),
			array( 'fa fa-chevron-left' => 'Chevron-left' ),
			array( 'fa fa-chevron-right' => 'Chevron-right' ),
			array( 'fa fa-chevron-up' => 'Chevron-up' ),
			array( 'fa fa-exchange' => 'Exchange' ),
			array( 'fa fa-hand-o-down' => 'Hand Outlined Down' ),
			array( 'fa fa-hand-o-left' => 'Hand Outlined Left' ),
			array( 'fa fa-hand-o-right' => 'Hand Outlined Right' ),
			array( 'fa fa-hand-o-up' => 'Hand Outlined Up' ),
			array( 'fa fa-long-arrow-down' => 'Long Arrow Down' ),
			array( 'fa fa-long-arrow-left' => 'Long Arrow Left' ),
			array( 'fa fa-long-arrow-right' => 'Long Arrow Right' ),
			array( 'fa fa-long-arrow-up' => 'Long Arrow Up' ),
		),
		'Video Player Icons' => array(
			array( 'fa fa-arrows-alt' => 'Arrows Alt' ),
			array( 'fa fa-backward' => 'Backward' ),
			array( 'fa fa-compress' => 'Compress' ),
			array( 'fa fa-eject' => 'Eject' ),
			array( 'fa fa-expand' => 'Expand' ),
			array( 'fa fa-fast-backward' => 'Fast-backward' ),
			array( 'fa fa-fast-forward' => 'Fast-forward' ),
			array( 'fa fa-forward' => 'Forward' ),
			array( 'fa fa-pause' => 'Pause' ),
			array( 'fa fa-pause-circle' => 'Pause Circle' ),
			array( 'fa fa-pause-circle-o' => 'Pause Circle Outlined' ),
			array( 'fa fa-play' => 'Play' ),
			array( 'fa fa-play-circle' => 'Play Circle' ),
			array( 'fa fa-play-circle-o' => 'Play Circle Outlined' ),
			array( 'fa fa-random' => 'Random' ),
			array( 'fa fa-step-backward' => 'Step-backward' ),
			array( 'fa fa-step-forward' => 'Step-forward' ),
			array( 'fa fa-stop' => 'Stop' ),
			array( 'fa fa-stop-circle' => 'Stop Circle' ),
			array( 'fa fa-stop-circle-o' => 'Stop Circle Outlined' ),
			array( 'fa fa-youtube-play' => 'YouTube Play' ),
		),
		'Transportation Icons' => array(
			array( 'fa fa-ambulance' => 'Ambulance' ),
			array( 'fa fa-bicycle' => 'Bicycle' ),
			array( 'fa fa-bus' => 'Bus' ),
			array( 'fa fa-car' => 'Car (automobile)' ),
			array( 'fa fa-fighter-jet' => 'Fighter-jet' ),
			array( 'fa fa-motorcycle' => 'Motorcycle' ),
			array( 'fa fa-plane' => 'Plane' ),
			array( 'fa fa-rocket' => 'Rocket' ),
			array( 'fa fa-ship' => 'Ship' ),
			array( 'fa fa-space-shuttle' => 'Space Shuttle' ),
			array( 'fa fa-subway' => 'Subway' ),
			array( 'fa fa-taxi' => 'Taxi (cab)' ),
			array( 'fa fa-train' => 'Train' ),
			array( 'fa fa-truck' => 'Truck' ),
			array( 'fa fa-wheelchair' => 'Wheelchair' ),
		),
		'Hand Icons' => array(
			array( 'fa fa-hand-lizard-o' => 'Lizard (Hand)' ),
			array( 'fa fa-hand-o-down' => 'Hand Outlined Down' ),
			array( 'fa fa-hand-o-left' => 'Hand Outlined Left' ),
			array( 'fa fa-hand-o-right' => 'Hand Outlined Right' ),
			array( 'fa fa-hand-o-up' => 'Hand Outlined Up' ),
			array( 'fa fa-hand-paper-o' => 'Paper (Hand) (hand-stop-o)' ),
			array( 'fa fa-hand-peace-o' => 'Hand Peace' ),
			array( 'fa fa-hand-pointer-o' => 'Hand Pointer' ),
			array( 'fa fa-hand-rock-o' => 'Rock (Hand) (hand-grab-o)' ),
			array( 'fa fa-hand-scissors-o' => 'Scissors (Hand)' ),
			array( 'fa fa-hand-spock-o' => 'Spock (Hand)' ),
			array( 'fa fa-thumbs-down' => 'Thumbs-down' ),
			array( 'fa fa-thumbs-o-down' => 'Thumbs Down Outlined' ),
			array( 'fa fa-thumbs-o-up' => 'Thumbs Up Outlined' ),
			array( 'fa fa-thumbs-up' => 'Thumbs-up' ),
		),
		'Gender Icons' => array(
			array( 'fa fa-genderless' => 'Genderless' ),
			array( 'fa fa-mars' => 'Mars' ),
			array( 'fa fa-mars-double' => 'Mars Double' ),
			array( 'fa fa-mars-stroke' => 'Mars Stroke' ),
			array( 'fa fa-mars-stroke-h' => 'Mars Stroke Horizontal' ),
			array( 'fa fa-mars-stroke-v' => 'Mars Stroke Vertical' ),
			array( 'fa fa-mercury' => 'Mercury' ),
			array( 'fa fa-neuter' => 'Neuter' ),
			array( 'fa fa-transgender' => 'Transgender (intersex)' ),
			array( 'fa fa-transgender-alt' => 'Transgender Alt' ),
			array( 'fa fa-venus' => 'Venus' ),
			array( 'fa fa-venus-double' => 'Venus Double' ),
			array( 'fa fa-venus-mars' => 'Venus Mars' ),
		),
		'Brand Icons' => array(
			array( 'fa fa-500px' => '500px' ),
			array( 'fa fa-adn' => 'App.net' ),
			array( 'fa fa-amazon' => 'Amazon' ),
			array( 'fa fa-android' => 'Android' ),
			array( 'fa fa-angellist' => 'AngelList' ),
			array( 'fa fa-apple' => 'Apple' ),
			array( 'fa fa-behance' => 'Behance' ),
			array( 'fa fa-behance-square' => 'Behance Square' ),
			array( 'fa fa-bitbucket' => 'Bitbucket' ),
			array( 'fa fa-bitbucket-square' => 'Bitbucket Square' ),
			array( 'fa fa-black-tie' => 'Font Awesome Black Tie' ),
			array( 'fa fa-bluetooth' => 'Bluetooth' ),
			array( 'fa fa-bluetooth-b' => 'Bluetooth' ),
			array( 'fa fa-btc' => 'Bitcoin (BTC) (bitcoin)' ),
			array( 'fa fa-buysellads' => 'BuySellAds' ),
			array( 'fa fa-cc-amex' => 'American Express Credit Card' ),
			array( 'fa fa-cc-diners-club' => 'Diner\'s Club Credit Card' ),
			array( 'fa fa-cc-discover' => 'Discover Credit Card' ),
			array( 'fa fa-cc-jcb' => 'JCB Credit Card' ),
			array( 'fa fa-cc-mastercard' => 'MasterCard Credit Card' ),
			array( 'fa fa-cc-paypal' => 'Paypal Credit Card' ),
			array( 'fa fa-cc-stripe' => 'Stripe Credit Card' ),
			array( 'fa fa-cc-visa' => 'Visa Credit Card' ),
			array( 'fa fa-chrome' => 'Chrome' ),
			array( 'fa fa-codepen' => 'Codepen' ),
			array( 'fa fa-codiepie' => 'Codie Pie' ),
			array( 'fa fa-connectdevelop' => 'Connect Develop' ),
			array( 'fa fa-contao' => 'Contao' ),
			array( 'fa fa-css3' => 'CSS 3 Logo' ),
			array( 'fa fa-dashcube' => 'DashCube' ),
			array( 'fa fa-delicious' => 'Delicious Logo' ),
			array( 'fa fa-deviantart' => 'DeviantART' ),
			array( 'fa fa-digg' => 'Digg Logo' ),
			array( 'fa fa-dribbble' => 'Dribbble' ),
			array( 'fa fa-dropbox' => 'Dropbox' ),
			array( 'fa fa-drupal' => 'Drupal Logo' ),
			array( 'fa fa-edge' => 'Edge Browser' ),
			array( 'fa fa-empire' => 'Galactic Empire (ge)' ),
			array( 'fa fa-expeditedssl' => 'ExpeditedSSL' ),
			array( 'fa fa-facebook' => 'Facebook (facebook-f)' ),
			array( 'fa fa-facebook-official' => 'Facebook Official' ),
			array( 'fa fa-facebook-square' => 'Facebook Square' ),
			array( 'fa fa-firefox' => 'Firefox' ),
			array( 'fa fa-flickr' => 'Flickr' ),
			array( 'fa fa-fonticons' => 'Fonticons' ),
			array( 'fa fa-fort-awesome' => 'Fort Awesome' ),
			array( 'fa fa-forumbee' => 'Forumbee' ),
			array( 'fa fa-foursquare' => 'Foursquare' ),
			array( 'fa fa-get-pocket' => 'Get Pocket' ),
			array( 'fa fa-gg' => 'GG Currency' ),
			array( 'fa fa-gg-circle' => 'GG Currency Circle' ),
			array( 'fa fa-git' => 'Git' ),
			array( 'fa fa-git-square' => 'Git Square' ),
			array( 'fa fa-github' => 'GitHub' ),
			array( 'fa fa-github-alt' => 'GitHub Alt' ),
			array( 'fa fa-github-square' => 'GitHub Square' ),
			array( 'fa fa-google' => 'Google Logo' ),
			array( 'fa fa-google-plus' => 'Google Plus' ),
			array( 'fa fa-google-plus-square' => 'Google Plus Square' ),
			array( 'fa fa-google-wallet' => 'Google Wallet' ),
			array( 'fa fa-gittip' => 'Gratipay (Gittip) (gittip)' ),
			array( 'fa fa-hacker-news' => 'Hacker News (y-combinator-square, yc-square)' ),
			array( 'fa fa-houzz' => 'Houzz' ),
			array( 'fa fa-html5' => 'HTML 5 Logo' ),
			array( 'fa fa-instagram' => 'Instagram' ),
			array( 'fa fa-internet-explorer' => 'Internet-explorer' ),
			array( 'fa fa-ioxhost' => 'Ioxhost' ),
			array( 'fa fa-joomla' => 'Joomla Logo' ),
			array( 'fa fa-jsfiddle' => 'JsFiddle' ),
			array( 'fa fa-lastfm' => 'Last.fm' ),
			array( 'fa fa-lastfm-square' => 'Last.fm Square' ),
			array( 'fa fa-leanpub' => 'Leanpub' ),
			array( 'fa fa-linkedin' => 'LinkedIn' ),
			array( 'fa fa-linkedin-square' => 'LinkedIn Square' ),
			array( 'fa fa-linux' => 'Linux' ),
			array( 'fa fa-maxcdn' => 'MaxCDN' ),
			array( 'fa fa-meanpath' => 'Meanpath' ),
			array( 'fa fa-medium' => 'Medium' ),
			array( 'fa fa-mixcloud' => 'Mixcloud' ),
			array( 'fa fa-modx' => 'MODX' ),
			array( 'fa fa-odnoklassniki' => 'Odnoklassniki' ),
			array( 'fa fa-odnoklassniki-square' => 'Odnoklassniki Square' ),
			array( 'fa fa-opencart' => 'OpenCart' ),
			array( 'fa fa-openid' => 'OpenID' ),
			array( 'fa fa-opera' => 'Opera' ),
			array( 'fa fa-optin-monster' => 'Optin Monster' ),
			array( 'fa fa-pagelines' => 'Pagelines' ),
			array( 'fa fa-paypal' => 'Paypal' ),
			array( 'fa fa-pied-piper' => 'Pied Piper Logo' ),
			array( 'fa fa-pied-piper-alt' => 'Pied Piper Alternate Logo' ),
			array( 'fa fa-pinterest' => 'Pinterest' ),
			array( 'fa fa-pinterest-p' => 'Pinterest P' ),
			array( 'fa fa-pinterest-square' => 'Pinterest Square' ),
			array( 'fa fa-product-hunt' => 'Product Hunt' ),
			array( 'fa fa-qq' => 'QQ' ),
			array( 'fa fa-rebel' => 'Rebel Alliance (ra)' ),
			array( 'fa fa-reddit' => 'Reddit Logo' ),
			array( 'fa fa-reddit-alien' => 'Reddit Alien' ),
			array( 'fa fa-reddit-square' => 'Reddit Square' ),
			array( 'fa fa-renren' => 'Renren' ),
			array( 'fa fa-safari' => 'Safari' ),
			array( 'fa fa-scribd' => 'Scribd' ),
			array( 'fa fa-sellsy' => 'Sellsy' ),
			array( 'fa fa-share-alt' => 'Share Alt' ),
			array( 'fa fa-share-alt-square' => 'Share Alt Square' ),
			array( 'fa fa-shirtsinbulk' => 'Shirts in Bulk' ),
			array( 'fa fa-simplybuilt' => 'SimplyBuilt' ),
			array( 'fa fa-skyatlas' => 'Skyatlas' ),
			array( 'fa fa-skype' => 'Skype' ),
			array( 'fa fa-slack' => 'Slack Logo' ),
			array( 'fa fa-slideshare' => 'Slideshare' ),
			array( 'fa fa-soundcloud' => 'SoundCloud' ),
			array( 'fa fa-spotify' => 'Spotify' ),
			array( 'fa fa-stack-exchange' => 'Stack Exchange' ),
			array( 'fa fa-stack-overflow' => 'Stack Overflow' ),
			array( 'fa fa-steam' => 'Steam' ),
			array( 'fa fa-steam-square' => 'Steam Square' ),
			array( 'fa fa-stumbleupon' => 'StumbleUpon Logo' ),
			array( 'fa fa-stumbleupon-circle' => 'StumbleUpon Circle' ),
			array( 'fa fa-tencent-weibo' => 'Tencent Weibo' ),
			array( 'fa fa-trello' => 'Trello' ),
			array( 'fa fa-tripadvisor' => 'TripAdvisor' ),
			array( 'fa fa-tumblr' => 'Tumblr' ),
			array( 'fa fa-tumblr-square' => 'Tumblr Square' ),
			array( 'fa fa-twitch' => 'Twitch' ),
			array( 'fa fa-twitter' => 'Twitter' ),
			array( 'fa fa-twitter-square' => 'Twitter Square' ),
			array( 'fa fa-usb' => 'USB' ),
			array( 'fa fa-viacoin' => 'Viacoin' ),
			array( 'fa fa-vimeo' => 'Vimeo' ),
			array( 'fa fa-vimeo-square' => 'Vimeo Square' ),
			array( 'fa fa-vine' => 'Vine' ),
			array( 'fa fa-vk' => 'VK' ),
			array( 'fa fa-weibo' => 'Weibo' ),
			array( 'fa fa-weixin' => 'Weixin (WeChat) (wechat)' ),
			array( 'fa fa-whatsapp' => 'What\'s App' ),
			array( 'fa fa-wikipedia-w' => 'Wikipedia W' ),
			array( 'fa fa-windows' => 'Windows' ),
			array( 'fa fa-wordpress' => 'WordPress Logo' ),
			array( 'fa fa-xing' => 'Xing' ),
			array( 'fa fa-xing-square' => 'Xing Square' ),
			array( 'fa fa-y-combinator' => 'Y Combinator (yc)' ),
			array( 'fa fa-yahoo' => 'Yahoo Logo' ),
			array( 'fa fa-yelp' => 'Yelp' ),
			array( 'fa fa-youtube' => 'YouTube' ),
			array( 'fa fa-youtube-play' => 'YouTube Play' ),
			array( 'fa fa-youtube-square' => 'YouTube Square' ),
		),
		'Medical Icons' => array(
			array( 'fa fa-ambulance' => 'Ambulance' ),
			array( 'fa fa-h-square' => 'H Square' ),
			array( 'fa fa-heart' => 'Heart' ),
			array( 'fa fa-heart-o' => 'Heart Outlined' ),
			array( 'fa fa-heartbeat' => 'Heartbeat' ),
			array( 'fa fa-hospital-o' => 'Hospital Outlined' ),
			array( 'fa fa-medkit' => 'Medkit' ),
			array( 'fa fa-plus-square' => 'Plus Square' ),
			array( 'fa fa-stethoscope' => 'Stethoscope' ),
			array( 'fa fa-user-md' => 'User-md' ),
			array( 'fa fa-wheelchair' => 'Wheelchair' ),
		),
	);

	return array_merge( $icons, $fontawesome_icons );
}

add_filter( 'mpl_source_fontawesome', 'mpl_source_fontawesome' );
