<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

/*
 *
 * This model contains all db functions related to user management
 * @author Teamtweaks
 *
 */
class User_model extends My_Model
{
	public function __construct() 
	{
		parent::__construct();
	}
	
	/*
    * 
    * Getting Users details
    * @param String $condition
    */
   public function get_users_details($condition=''){
   		$Query = " select * from ".USERS." ".$condition;
   		return $this->ExecuteQuery($Query);
   }
  
   public function insertUserQuick($fullname='',$username='',$lastname='',$email='',$pwd='',$brand='no'){

    $api_id = $this->input->post('api_id');
	$thumbnail = $this->input->post('thumbnail');
	
	if($thumbnail != '')
		$thumbnail = $thumbnail;
	else
		$thumbnail = '';
	
	/* get Referal user id start */
	
	$getReferalUserId =$this->getReferalUserId();
	
	
	/* get Referal user id end */
   		$dataArr = array(
			'full_name'	=>	$fullname,
			'user_name'	=>	$username,
			'last_name'=>	$lastname,
			'group'		=>	'User',
			'email'		=>	$email,
			'password'	=>	md5($pwd),
			'status'	=>	'Active',
			'is_verified'=>	'No',
   			'is_brand'	=> $brand,
			'api_id'	=> $api_id,
			'thumbnail'	=> $thumbnail,
			'referId' => $getReferalUserId,
			'created'	=>	mdate($this->data['datestring'],time()),
   			'email_notifications'	=>	implode(',', $this->data['emailArr']),
	    	'notifications'			=>	implode(',', $this->data['notyArr'])
		);

			
		$this->simple_insert(USERS,$dataArr);
		if($this->session->userdata('referenceName') != '')
		{
			$this->session->unset_userdata('referenceName');
		}
		
   }
   
   
   
   public function updateUserQuick($fullname='',$username='',$email='',$pwd=''){
   		$dataArr = array(
			'full_name'	=>	$fullname,
			'user_name'	=>	$username,
			'password'	=>	md5($pwd)
		);
		$conditionArr = array('email'=>$email);
		$this->update_details(USERS,$dataArr,$conditionArr);
   }
   
   
   //Sriram Code
   //update user template
   public function updateUserQuickTemp(){
	  extract($_POST);
   		$dataArr = array(
			'shop_template'	=>	$shop_template,
			'product_template'	=>	$product_template
			
		);
		$conditionArr = array('id'=>$seller_id);
		$this->update_details(USERS,$dataArr,$conditionArr);
		//echo $this->db->last_query(); 
		
		$conditionArr1 = array('seller_id'=>$seller_id);
		$this->update_details(SELLER,$dataArr,$conditionArr1);
		//echo $this->db->last_query(); die;
		
   }
   
   
   
   public function updategiftcard($table='',$temp_id='',$user_id=''){
   		$dataArr = array('user_id'	=>	$user_id,);
		$conditionArr = array('user_id'=>$temp_id);
		$this->update_details($table,$dataArr,$conditionArr);
   }
   
    public function updateShopingCart($table='',$temp_id='',$user_id=''){
   		$dataArr = array('user_id'	=>	$user_id,);
		$conditionArr = array('user_id'=>$temp_id);
		$this->update_details($table,$dataArr,$conditionArr);
   }
   
    public function updateUserShopingCart($table='',$temp_id='',$user_id=''){
   		$dataArr = array('user_id'	=>	$user_id,);
		$conditionArr = array('user_id'=>$temp_id);
		$this->update_details($table,$dataArr,$conditionArr);
   }
    
   public function get_purchase_details($uid='0'){
   	 	$Query = "select p.*,u.full_name from ".PAYMENT." p JOIN ".USERS." u on u.id=p.user_id where p.user_id='".$uid."' group by p.dealCodeNumber order by created desc";
   	 	return $this->ExecuteQuery($Query);
   }
   
    public function get_seller_purchase_details($uid='0'){
   	 	$Query = "select p.*,u.full_name from ".USER_PAYMENT." p JOIN ".USERS." u on u.id=p.user_id where p.user_id='".$uid."' group by p.dealCodeNumber order by created desc";
   	 	return $this->ExecuteQuery($Query);
   }
   
   public function get_like_details_fully($uid='0'){
   		$Query = 'select p.*,u.full_name,u.user_name from '.PRODUCT_LIKES.' pl
   					JOIN '.PRODUCT.' p on pl.product_id=p.seller_product_id
   					LEFT JOIN '.USERS.' u on p.user_id=u.id
   					where pl.user_id='.$uid.' and p.status="Publish" order by pl.time desc';
   		return $this->ExecuteQuery($Query);
   }
   
   public function get_like_details_fully_user_products($uid='0'){
   		$Query = 'select p.*,u.full_name,u.user_name from '.PRODUCT_LIKES.' pl
   					JOIN '.USER_PRODUCTS.' p on pl.product_id=p.seller_product_id
   					LEFT JOIN '.USERS.' u on p.user_id=u.id
   					where pl.user_id='.$uid.' and p.status="Publish" order by pl.time desc';
   		return $this->ExecuteQuery($Query);
   }
   
   public function get_activity_details($uid='0',$limit='5',$sort='desc'){
   		$Query = 'select a.*,p.product_name,p.id as productID,up.product_name as user_product_name,u.full_name,u.user_name from '.USER_ACTIVITY.' a
   					LEFT JOIN '.PRODUCT.' p on a.activity_id=p.seller_product_id
   					LEFT JOIN '.USER_PRODUCTS.' up on a.activity_id=up.seller_product_id
   					LEFT JOIN '.USERS.' u on a.activity_id=u.id
   					where a.user_id='.$uid.' order by a.activity_time '.$sort.' limit '.$limit;
   		return $this->ExecuteQuery($Query);
   }
   
   public function get_list_details($tid='0',$uid='0'){
   		$Query = 'select l.*,c.cat_name from '.LISTS_DETAILS.' l
   					LEFT JOIN '.CATEGORY.' c on l.category_id=c.id
   					where l.user_id='.$uid.' and l.product_id='.$tid.' or l.user_id='.$uid.' and l.product_id like "'.$tid.',%" or l.user_id='.$uid.' and l.product_id like "%,'.$tid.'" or l.user_id='.$uid.' and l.product_id like "%,'.$tid.',%"';
   		return $this->ExecuteQuery($Query);
   }
   
   public function get_search_user_list($search_key='',$uid='1'){
   		$Query = 'select * from '.USERS.' where `full_name` like "%'.$search_key.'%"  or  `user_name` like "%'.$search_key.'%"  or  `last_name` like "%'.$search_key.'%" and `id` != "'.$uid.'" and `status` = "Active"';
   		return $this->ExecuteQuery($Query);
   }
   
   public function get_search_user_list_search($search_key='',$uid='1',$order='',$group='`group`="user"'){
   		$Query = 'select * from '.USERS.' where `user_name` like "%'.$search_key.'%"  and `id` > "'.$uid.'" and `status` = "Active" and ('.$group.')  '.$order.'';
   		$result=$this->ExecuteQuery($Query);
		#echo $this->db->last_query(); die;
		return $result;
   }
   
   public function get_search_shop_list_search($search_key='',$uid='0',$order=''){
		$Query = "select u.id as sellerid,u.email as selleremail,u.full_name,u.user_name,u.thumbnail,s.seller_businessname as shop_name,s.seourl as shop_seourl from ".SELLER." s 
					JOIN ".USER." u on u.id=s.seller_id where s.status='Active' and s.seller_businessname like '%".$search_key."%'  and u.id > ".$uid." ".$order;
		if($search_key==''){
			$Query = "select u.id as sellerid,u.email as selleremail,u.full_name,u.user_name,u.thumbnail,s.seller_businessname as shop_name,s.seourl as shop_seourl from ".SELLER." s JOIN ".USER." u on u.id=s.seller_id where s.status='Active' and u.id > ".$uid." ".$order;
		}
		$resultVal=$this->ExecuteQuery($Query);
		#echo $this->db->last_query(); die;
		return $resultVal;
   }
   
   public function social_network_login_check($apiId='')
   {
   		 $twitterQuery = "select api_id from ".USERS." where api_id=".$apiId. " AND status='Active'";

		$twitterQueryDetails  = mysql_query($twitterQuery);
		$twitterFetchDetails = mysql_fetch_row($twitterQueryDetails);
		
		return $twitterCountById = mysql_num_rows($twitterQueryDetails);
   }
   
   public function get_social_login_details($apiId='')
   {
   		 $twitterQuery = "select * from ".USERS." where api_id=".$apiId. " AND status='Active'";

		$twitterQueryDetails  = mysql_query($twitterQuery);
		return $twitterFetchDetails = mysql_fetch_assoc($twitterQueryDetails);
		
		//return $twitterCountById = mysql_num_rows($twitterQueryDetails);
   }
   
   public function googleLoginCheck($email='')
   {
  // echo $email;die;
   		$this->db->select('id');
		$this->db->from(USERS);
		$this->db->where('email',$email);
		$this->db->where('status','Active');
		$googleQuery = $this->db->get();
		return $googleResult = $googleQuery->num_rows(); 
   }
   
   public function google_user_login_details($email='')
   {
   		$this->db->select('*');
		$this->db->from(USERS);
		$this->db->where('email',$email);
		$this->db->where('status','Active');
		$googleQuery1 = $this->db->get();
		return $googleResult1 = $googleQuery1->row_array(); 
   }
   
	public function getReferalUserId()
	{
		$referenceName = $this->session->userdata('referenceName');
		$referenceId = '';
		if($referenceName != '')
		{
			$this->db->select('id');
			$this->db->from(USERS);
			$this->db->where('user_name',$referenceName);
			$referQuery = $this->db->get();
			$referResult = $referQuery->row_array();
			
			if(!empty($referResult))
			{
				return $referenceId = $referResult['id'];
			}
			else
			{
				return $referenceId = '';
			}
		}
		else
		{
			return $referenceId = '';
		}
	}
	
	public function getReferalList($perpage='',$start='')
	{
		//echo $this->session->userdata('shopsy_session_user_id');die;
		$this->db->select('full_name,user_name,email,thumbnail');
		$this->db->from(USERS);
		$this->db->where('referId',$this->session->userdata('shopsy_session_user_id'));
		
		if($perpage !='')
		{
			$this->db->limit($perpage,$start);
		}			
		
		
		$this->db->order_by('id','desc');
		$referQuery = $this->db->get();
		return $referResult = $referQuery->result_array();
	}
	
	public function get_userlike_products($uid='0',$limit='5'){
		$Query = "select pl.*,p.id as pid,p.product_name,p.image from ".PRODUCT_LIKES.' pl 
					JOIN '.PRODUCT.' p on pl.product_id=p.seller_product_id 
					where pl.user_id='.$uid.' limit '.$limit;
		return $this->ExecuteQuery($Query);
	}
	
	public function get_user_orders_list($uid='0'){
		$Query = "select *, sum(sumtotal) as TotalPrice from ".PAYMENT.' where sell_id='.$uid.' and status="Paid" group by dealCodeNumber order by created desc';
		return $this->ExecuteQuery($Query);
	}
	
	public function get_seller_orders_list($uid='0'){
		$Query = "select *, sum(sumtotal) as TotalPrice from ".USER_PAYMENT.' where sell_id='.$uid.' and status="Paid" group by dealCodeNumber order by created desc';
		return $this->ExecuteQuery($Query);
	}
	
	public function get_subscriptions_list($uid='0'){
		$Query = "select * from ".FANCYYBOX_USES.' where user_id='.$uid.' group by invoice_no order by created desc';
		return $this->ExecuteQuery($Query);
	}
	
	public function get_gift_cards_list($email=''){
		$Query = "select * from ".GIFTCARDS.' where recipient_mail=\''.$email.'\' order by created desc';
		return $this->ExecuteQuery($Query);
	}
	
	public function get_send_gift_cards_list($email=''){
		$Query = "select * from ".GIFTCARDS.' where sender_mail=\''.$email.'\' order by created desc';
		return $this->ExecuteQuery($Query);
	}
	
	public function get_purchase_list($uid='0',$dealCode='0'){
		$this->db->select('p.*,u.email,u.full_name,u.address,u.phone_no,u.postal_code,u.state,u.country,u.city,pd.product_name,pd.id as PrdID,pd.image');
		$this->db->from(PAYMENT.' as p');
		$this->db->join(USERS.' as u' , 'p.user_id = u.id');
		$this->db->join(PRODUCT.' as pd' , 'pd.id = p.product_id');	
		$this->db->where('p.user_id = "'.$uid.'" and p.dealCodeNumber="'.$dealCode.'"');
		return $this->db->get();
	}
	
	public function get_seller_purchase_list($uid='0',$dealCode='0'){
		$this->db->select('p.*,u.email,u.full_name,u.address,u.phone_no,u.postal_code,u.state,u.country,u.city,pd.product_name,pd.id as PrdID,pd.image');
		$this->db->from(USER_PAYMENT.' as p');
		$this->db->join(USERS.' as u' , 'p.user_id = u.id');
		$this->db->join(USER_PRODUCTS.' as pd' , 'pd.id = p.product_id');	
		$this->db->where('p.user_id = "'.$uid.'" and p.dealCodeNumber="'.$dealCode.'"');
		return $this->db->get();
	}
	
	public function get_order_list($uid='0',$dealCode='0'){
		$this->db->select('p.*,u.email,u.full_name,u.address,u.phone_no,u.postal_code,u.state,u.country,u.city,pd.product_name,pd.id as PrdID,pd.image');
		$this->db->from(PAYMENT.' as p');
		$this->db->join(USERS.' as u' , 'p.user_id = u.id');
		$this->db->join(PRODUCT.' as pd' , 'pd.id = p.product_id');		
		$this->db->where('p.sell_id = "'.$uid.'" and p.dealCodeNumber="'.$dealCode.'"');
		return $this->db->get();
	}
	
	public function get_seller_order_list($uid='0',$dealCode='0'){
		$this->db->select('p.*,u.email,u.full_name,u.address,u.phone_no,u.postal_code,u.state,u.country,u.city,pd.product_name,pd.id as PrdID,pd.image');
		$this->db->from(USER_PAYMENT.' as p');
		$this->db->join(USERS.' as u' , 'p.user_id = u.id');
		$this->db->join(USER_PRODUCTS.' as pd' , 'pd.id = p.product_id');		
		$this->db->where('p.sell_id = "'.$uid.'" and p.dealCodeNumber="'.$dealCode.'"');
		return $this->db->get();
	}
	public function fav_delete($userid='',$shopid=''){
		    $this->db->where('shop_id', $shopid);
			$this->db->where('user_id', $userid);
			$this->db->delete(FAVORITE);
			//$this->db->where('shop_id', $shopid);
			//$this->db->where('user_id', $userid);
		    $this->db->last_query();
//		$referQuery = $this->db->get();
	//	$referResult = $referQuery->result_array();
		//echo $this->db->last_query(); die;
		return;	
	}
	
	public function product_fav_delete($userid='',$pid=''){
		    $this->db->where('p_id', $pid);
			$this->db->where('user_id', $userid);
			$this->db->delete(FAVORITE);
		    $this->db->last_query();
		return;	
	}
	
/*	function delete_prod_image($position='',$imgId='')
	{
		$this->db->select(PRODUCT.'.image');
		$this->db->from(PRODUCT);
		$this->db->where(PRODUCT.'.id',$imgId);
		$imageQuery = $this->db->get();
		$imageResult =$imageQuery->row_array();
		echo "<pre>";print_r($imageResult);die;
		$imageVals = $imageResult['$imageResult'];
		 echo str_replace($imageVals,"","Hello world!");
	}*/
	public function check_list_products($productId,$listId){
		$Query = "select * from ".LISTS_DETAILS." where FIND_IN_SET('".$productId."',product_id) and `id`=".$listId;
		$resultVal=$this->ExecuteQuery($Query);
		#echo $this->db->last_query();
		return $resultVal;
		
	}
	public function check_registry_products($productId,$usrId){		
		$this->db->select('*');
		$this->db->from(REGISTRY_LISTINGS);
		$this->db->where(REGISTRY_LISTINGS.'.collection_id',$usrId);
		$this->db->where(REGISTRY_LISTINGS.'.listing_id',$productId);
		$resultVal= $this->db->get();
		#echo $this->db->last_query(); die;
		return $resultVal;
		
	}
	public function get_list_products($productId,$listId){
		$Query = "select p.* from ".PRODUCT." p LEFT JOIN ".LISTS_DETAILS." l on l.id=".$listId." where FIND_IN_SET(".$productId.",l.product_id) and p.id=".$productId;
		$resultVal=$this->ExecuteQuery($Query);
		#echo $this->db->last_query(); die;
		return $resultVal;
		
	}

	public function get_userfav_products($uid='0',$limit=''){
		$Query = 'select f.*,p.seourl as pseourl,p.product_name,p.image,u.visibility,u.followers_count from '.FAVORITE.' f 
					JOIN '.PRODUCT.' p on f.p_id=p.id
					JOIN '.USER.' u on u.id=p.user_id 
					where p.status="Publish" and p.pay_status="Paid" and f.user_id='.$uid;
		$resultVal=$this->ExecuteQuery($Query);
		#echo $this->db->last_query(); die;
		return $resultVal;
	}
	public function get_userfav_products_with_cond($uid='',$limit=''){
		$status="'Public'";
		$Query = "select f.*,p.seourl as pseourl,p.product_name,p.image,u.visibility,u.followers_count from ".FAVORITE.' f 
					JOIN '.PRODUCT.' p on f.p_id=p.id
					JOIN '.USER.' u on u.id=p.user_id and  
					where u.favorites_visibility='.$status.' and f.user_id='.$uid;
		$resultVal=$this->ExecuteQuery($Query);
		#echo $this->db->last_query(); die;
		return $resultVal;
	}
	/*Search Favorite Products List*/
	public function get_search_favorite_list($search_key='',$uid='0'){
		
		$Query = "select p.*,u.id as sellerid,u.email as selleremail,u.full_name,u.user_name,u.thumbnail,u.feature_product,s.seller_businessname as shop_name,s.seourl as shop_seourl,a.pricing from ".PRODUCT." p LEFT JOIN ".USERS." u on u.id=p.user_id LEFT JOIN ".SELLER." s on u.id=s.seller_id LEFT JOIN ".SUBPRODUCT." a on p.id=a.product_id LEFT JOIN ".FAVORITE." f on p.id=f.p_id where  p.product_name like '%".$search_key."%'  and p.status='Publish' and p.pay_status='Paid' and f.user_id=".$uid." GROUP BY a.product_id";
   		$resultVal= $this->ExecuteQuery($Query);
		#echo $this->db->last_query(); die;
		return $resultVal;
   }
   
   /*Get Recent Favorites */
	public function get_resent_favorite_list(){
		$this->db->select('f.*,u.city,u.id as sellerid,u.email as selleremail,u.full_name,u.user_name,u.thumbnail,u.feature_product,s.seller_businessname as shop_name,s.seller_banner as seller_banner,s.seourl as shop_seourl,s.shop_ratting,s.review_count');
		$this->db->from(FAVORITE.' as f');
		$this->db->join(USERS.' as u' , 'u.id = f.shop_id','left');
		$this->db->join(SELLER.' as s' , 'f.shop_id = s.seller_id');	
		$this->db->where('f.shop_id IS NOT NULL');
		#$this->db->group_by('f.shop_id');		
		$this->db->order_by('f.time','DESC');
		#$this->db->limit(4,0);
		$resultVal= $this->db->get();
		#echo '<pre>'; print_r($resultVal->result_array()); die;
		#echo $this->db->last_query(); die;
		return $resultVal;
   }
   public function get_user_purchase_list($uid='0',$dealCode='',$condition='Paid'){
		$this->db->select('p.*,u.email,u.full_name,u.thumbnail,u.address,u.phone_no,u.postal_code,u.state,u.country,u.city,pd.product_name,pd.id as PrdID,pd.image,pd.ship_from,s.seller_businessname as shopname,s.seller_email');
		$this->db->from(USER_PAYMENT.' as p');
		$this->db->join(USERS.' as u' , 'p.sell_id = u.id');
		$this->db->join(PRODUCT.' as pd' , 'pd.id = p.product_id');
		$this->db->join(SELLER.' as s' , 's.seller_id = p.sell_id');
		if($condition!=''){
			$this->db->where('p.status = "'.$condition.'"');
		}	
		if($dealCode==''){
			$this->db->where('p.user_id = "'.$uid.'" GROUP BY p.dealCodeNumber ORDER BY p.inserttime  desc');
		}
		else{
			$this->db->where('p.user_id = "'.$uid.'" and p.dealCodeNumber="'.$dealCode.'" GROUP BY p.dealCodeNumber ORDER BY p.inserttime  desc');
		}
		return $this->db->get(); 
	}
	
	public function get_pickedItems(){
		$this->db->select('p.user_id,u.user_name,u.email,u.full_name,u.thumbnail,u.address,u.phone_no,u.postal_code,u.state,u.country,u.city');
		$this->db->from(USER_PAYMENT.' as p');
		$this->db->join(USERS.' as u' , 'p.user_id = u.id');
		$this->db->join(PRODUCT.' as pd' , 'pd.id = p.product_id');	
		$this->db->where('p.user_id > 1 GROUP BY p.user_id ');	
		return $this->db->get();
	}
	 function getrecentSellerBlog($type = '')
    {	
	
		
		$this->db->select('a.*,b.*,bu.user_email,s.seller_id,s.seller_banner,u.user_name,u.thumbnail,,u.full_name,s.seourl as shopurl,s.seller_businessname as shopname');
		$this->db->from(POSTS.' as a');
		$this->db->join(POSTMETA.' as b','b.post_id =a.ID');
		$this->db->join(BLOG_USERS.' as bu','a.post_author =bu.ID');
		$this->db->join(SELLER.' as s','s.seller_email=bu.user_email');
		$this->db->join(USERS.' as u','s.seller_id=u.id');
	   	$this->db->where('a.post_status','publish');
		$this->db->where('a.post_type','post');
		//$this->db->where('b.meta_key','_wp_attached_file');		
		
		$this->db->group_by('a.ID');
		#$this->db->order_by('post_date', 'desc');
		$this->db->order_by('s.seller_id','RANDOM');
		$this->db->limit(6);
		$query = $this->db->get();
		$resultContent = $query->result();
		return $resultContent;
		
    }
	
	public function get_testimonials(){
		$this->db->select('t.*,u.user_name,u.email,u.full_name,u.thumbnail,u.city,s.seller_businessname as shopname,s.seourl as shopurl,s.seller_banner as seller_banner');
		$this->db->from(TESTIMONIALS.' as t');
		$this->db->join(USERS.' as u' , 't.seller_id = u.id');	
		$this->db->join(SELLER.' as s' , 's.seller_id = t.seller_id');
		$this->db->order_by('t.seller_id','RANDOM');
		return $this->db->get();
	}
	
	///////// Get  activity List//////////////
	public function get_activity($condition='',$postnumbers=10,$offset=0){
		$this->db->select('ua.*');
		$this->db->from(USER_ACTIVITY.' as ua');
		$this->db->where($condition);	
		#$this->db->group_by('ua.activity_id');
		$this->db->order_by('ua.activity_time','desc');
		$this->db->limit($postnumbers,$offset);
		$activityDetails= $this->db->get();
		return $activityDetails;
	}
	///////// Get Shop activity List//////////////
	public function get_myshopactivity($condition='',$postnumbers=10,$offset=0){
		$this->db->select('ua.*,u.*');
		$this->db->from(USER_ACTIVITY.' as ua');
		$this->db->join(USERS.' as u' , 'ua.user_id = u.id');
		$this->db->where($condition);	
		#$this->db->group_by('ua.activity_id');
		$this->db->order_by('ua.activity_time','desc');
		$this->db->limit($postnumbers,$offset);
		$shopactivityDetails= $this->db->get();
		#echo $this->db->last_query(); die;
		return $shopactivityDetails;
	}
	///////// Get Favorite Shops with products for activity //////////////
	public function getfavshops_activity($userId=''){
		$this->db->select('p.*,u.user_name,u.email,u.full_name,u.thumbnail,u.city,s.seller_businessname as shopname,s.seourl as shopurl,s.seller_banner as seller_banner');
		$this->db->from(PRODUCT.' as p');
		$this->db->join(USERS.' as u' , 'p.user_id = u.id');	
		$this->db->join(SELLER.' as s' , 's.seller_id = p.user_id');
		$this->db->where('s.seller_id ='.$userId);	
		$shopproductDetails= $this->db->get();
		#echo $this->db->last_query(); die;
		return $shopproductDetails;
	}
	public function get_conversation_details($userId='',$type='inbox'){
	$this->db->select('c.*,u1.user_name as sender_name,u1.email as sender_email,u1.thumbnail as senderthumbnail,s1.seller_businessname as sendershopname,s1.seourl as sendershopurl,u.user_name,u.email,u.full_name,u.thumbnail,s.seller_businessname as shopname,s.seourl as shopurl');
		$this->db->from(CONTACTPEOPLE.' as c');		
		if($type=='inbox'){
			$this->db->join(USERS.' as u' , 'c.receiver_id = u.id');
			$this->db->join(USERS.' as u1' , 'c.sender_id = u1.id');
			$this->db->join(SELLER.' as s' , 's.seller_id = u.id');
			$this->db->join(SELLER.' as s1' , 's1.seller_id = u1.id');
			$condition='c.receiver_id ='.$userId.' AND (c.receiver_status ="Read" OR c.receiver_status ="Unread")';
			$this->db->where($condition);	
			/*$this->db->where('c.receiver_id ='.$userId);	
			$this->db->or_where('c.receiver_status ="Read"');
			$this->db->or_where('c.receiver_status ="Unread"'); 	*/
		}else if($type=='sent'){
			$this->db->join(USERS.' as u1' , 'c.sender_id = u1.id');
			$this->db->join(USERS.' as u' , 'c.receiver_id = u.id');
			$this->db->join(SELLER.' as s' , 's.seller_id = u.id');
			$this->db->join(SELLER.' as s1' , 's1.seller_id = u.id');
			$condition='c.sender_id ='.$userId.' AND (c.sender_status ="Read" OR c.sender_status ="Unread")';
			$this->db->where($condition);	
			/*$this->db->where('c.sender_id ='.$userId);
			$this->db->where('c.sender_status ="Read"');
			$this->db->or_where('c.sender_status ="Unread"'); 	*/
		}else if($type=='all'){
			$this->db->join(USERS.' as u' , 'c.sender_id = u.id');
			$this->db->join(USERS.' as u1' , 'c.receiver_id = u1.id');
			$this->db->join(SELLER.' as s' , 's.seller_id = u.id');
			$this->db->join(SELLER.' as s1' , 's1.seller_id = u.id');
			$condition='(c.sender_id ='.$userId.' AND (c.sender_status ="Read" OR c.sender_status ="Unread")) OR (c.receiver_id ='.$userId.' AND (c.receiver_status ="Read" OR c.receiver_status ="Unread"))';
			$this->db->where($condition); 	
			/*$this->db->where('c.sender_id ='.$userId);	
			$this->db->or_where('c.receiver_id ='.$userId);*/ 
		}else if($type=='trash'){
			$this->db->join(USERS.' as u' , 'c.sender_id = u.id');
			$this->db->join(USERS.' as u1' , 'c.receiver_id = u1.id');
			$this->db->join(SELLER.' as s' , 's.seller_id = u.id');
			$this->db->join(SELLER.' as s1' , 's1.seller_id = u.id');
			$condition='(c.sender_id ='.$userId.' AND c.sender_status ="Trash") OR (c.receiver_id ='.$userId.' AND c.receiver_status ="Trash")';
			$this->db->where($condition); 	
		}
		$this->db->order_by('c.dataAdded','desc');
		$conversationlist= $this->db->get();
		#echo $this->db->last_query(); die;
		return $conversationlist;
	}
	public function get_message_details($msgId=''){
	$this->db->select('c.*,u1.user_name as sender_name,u1.email as sender_email,u1.thumbnail as senderthumbnail,u.user_name,u.email,u.full_name,u.thumbnail,s.seller_businessname as shopname,s.seourl as shopurl');
		$this->db->from(CONTACTPEOPLE.' as c');		
		$this->db->join(USERS.' as u' , 'c.receiver_id = u.id');
		$this->db->join(USERS.' as u1' , 'c.sender_id = u1.id');
		$this->db->join(SELLER.' as s' , 's.seller_id = u.id');
		$this->db->where('c.id ='.$msgId);
		$messageDetails= $this->db->get();
		return $messageDetails;
	}

}