<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

/**
 * 
 * Shop related functions
 * @author Teamtweaks
 *
 */

class Shop extends MY_Controller {
	function __construct(){
        parent::__construct();
		$this->load->helper(array('cookie','date','form','email'));
		$this->load->library(array('encrypt','form_validation'));		
		$this->load->model(array('product_model','seller_model','user_model','order_model'));
		//$this->load->model(array('product_model','shop','seller_model'));
		$this->data['loginCheck'] = $this->checkLogin('U');
		$this->data['AdminloginCheck'] = $this->checkLogin('A');
		$this->data['likedProducts'] = array();
	 	if ($this->data['loginCheck'] != ''){
	 		//$this->data['likedProducts'] = $this->shop->get_all_details(PRODUCT_LIKES,array('user_id'=>$this->checkLogin('U')));
	 	}
		$SSeller_details=$this->seller_model->get_all_details(SELLER,array('seller_id'=>$this->checkLogin('U')));				
		$this->data['currentshopurl'] = $SSeller_details->row()->seourl;
		
    }
    
	public function index(){
		$this->data['heading'] = 'Shop';
		$this->data['bannerList'] = $this->shop->get_all_details(BANNER_CATEGORY,array('status'=>'Publish'));
		$this->data['recentProducts'] = $this->shop->view_product_details(" where p.status='Publish' and p.quantity > 0 and u.group='Seller' and u.status='Active' or p.status='Publish' and p.quantity > 0 and p.user_id=0 order by p.created desc limit 4");
		$this->load->view('site/shop/display_shop_list',$this->data);
    }
	
	
	// Shop template setting

	public function shop_template_setting()
	{
		if ($this->checkLogin('U')!=''){		
		$this->data['userVal'] = $this->seller_model->get_userdetail_data('product_template,shop_template,blog_template');
		//print_r($this->data['sellerVal']); die;
		
		$this->data['meta_title'] = $this->data['heading'] = 'Shop Product Setup';
		$this->load->view('site/shop/shop_template.php',$this->data);
			
		}else {
			$this->data['next'] = $this->input->get('next');
			$this->data['heading'] = 'Sign in';
			$this->load->view('site/user/signup.php',$this->data);
		}
	}
	
	
	/*******************load add new shop start**************************/
	public function load_shop_open($optionsLoad)
	{
		if ($this->checkLogin('U')!='' || $this->checkLogin('A')!=''){
		 $this->data['selectSeller_details']=$this->seller_model->get_sellers_data(SELLER,$condition);		 
		 $checkloginIDarr=$this->session->all_userdata(); 
		 if ($this->checkLogin('A')!=''){
			$checkUser = $this->user_model->get_all_details(USERS,array('id' => 1));
				#echo '<pre>'; print_r($checkUser); die;
					if ($checkUser->num_rows() == 1){ 
					
		$userdata1 = array('shopsy_session_user_id'=>'','shopsy_session_user_name'=>'','shopsy_session_full_name'=>'','shopsy_session_user_email'=>'','shopsy_session_temp_id'=>'');
		$this->session->unset_userdata($userdata1);
		$this->session->unset_userdata('currency_data');
		$this->session->unset_userdata('region');
					delete_cookie("Shopsy_NewUser");
					
					$userdata = array(
								'shopsy_session_user_id' => $checkUser->row()->id,
								'shopsy_session_user_name' => $checkUser->row()->user_name,
								'shopsy_session_full_name' => $checkUser->row()->full_name,
								'shopsy_session_user_email' => $checkUser->row()->email,
								'userType'=>$checkUser->row()->group
							);
					}
					$this->session->set_userdata($userdata);
					$loggeduserID=$checkUser->row()->id;
					$this->setErrorMessage('success','Welcome, Admin');
		
		 }else{
		 $loggeduserID=$checkloginIDarr['shopsy_session_user_id'];
		 }
		 $this->data['userIdVal']=$loggeduserID;
		 $this->data['countryList'] = $this->product_model->get_all_details(COUNTRY_LIST,array(),array('field'=>'name','type'=>'desc'))->result();
		    if($optionsLoad == 'sell' || $optionsLoad == 'reviews')
			{
				$this->data['selectUser_details']=$this->seller_model->get_all_details(USER,array('id'=>$loggeduserID))->result_array();
				$this->data['shopproductfeed_details']=$shopproductfeed_details = $this->seller_model->get_shopproductfeed_details($loggeduserID)->result();
				if($this->data['selectSeller_details'][0]['seller_businessname']!="")
				{
					$this->data['selectSeller_details']=$this->seller_model->get_sellers_data(SELLER,$condition);
					#$this->data['shopDetail'] = $this->product_model->get_all_details(PRODUCT,array('user_id' => $loggeduserID))->result_array();	
					$product_list=$shop_sec['product_id'];
				$condition1 = " where (u.group='User' or u.group='Seller') and u.status='Active' and p.user_id=".$loggeduserID." or p.user_id=".$loggeduserID." and a.pricing IS NOT NULL group by p.id order by p.created desc";
		
					$this->data['shopDetail'] =$this->product_model->view_product_details_from_section($condition1)->result_array();				 	  
					$cond=array('seller_id' => $loggeduserID); 
					$this->data['product'] = $this->product_model->get_all_details(PRODUCT,array('user_id' => $loggeduserID))->result_array();
					$this->data['Paidproduct'] = $this->product_model->get_all_details(PRODUCT,array('user_id' => $loggeduserID,'pay_status'=>'Paid'));
					$this->data['shop_section_details']=$this->seller_model->getShopSectionDetails($loggeduserID);
					$this->data['shop_section_count']=count($this->data['shop_section_details']);
					
					$this->data['meta_title'] = $this->data['heading'] = 'Shop';
					$this->load->view('site/shop/shop_preview',$this->data);
				}
				else
				{
					$this->data['meta_title'] = $this->data['heading'] = 'Open new shop';
				    $this->load->view('site/shop/add_new_shop',$this->data);
				}
			}
		
		  	if($optionsLoad == 'name')
			{
		    $this->data['meta_title'] = $this->data['heading'] = 'Open new shop';
		    $this->load->view('site/shop/add_new_shop',$this->data);
			}
			if($optionsLoad == 'listitem')
			{
				$this->data['seller_info']=$this->seller_model->get_sellers_data(SELLER,$condition);
			   	$this->data['variations_result']= $this->product_model->get_all_details(PRODUCT_ATTRIBUTE,array())->result();
			   
			   $condition = " where (p.status='Publish' or p.status='unpublish') and p.user_id=".$loggeduserID." and (u.group='User' or u.group='Seller') and u.status='Active' or p.status='Publish' and p.user_id=0 and a.pricing IS NOT NULL group by p.id order by p.created desc";
		$this->data['shopDetail']=$this->product_model->view_product_details($condition)->result();
			   
			   
			   //$this->data['shopDetail'] = $this->product_model->get_all_details(PRODUCT,array('user_id' => $loggeduserID))->result();
			   //$this->data['AllmainCategories'] = $this->product_model->get_all_details(CATEGORY,array('rootID'=> 0,'status' => 'Active'))->result();
#			   $this->data['countryList'] = $this->product_model->get_all_details(COUNTRY_LIST,array())->result();
			   $this->data['meta_title'] = $this->data['heading'] = 'Shop List Items';
		       $this->load->view('site/shop/add_shop_listitems',$this->data);
			}
			
			if($optionsLoad == 'admin-listitem')
			{ 
				if($this->checkLogin('A')!=''){
				
			   $this->data['variations_result']= $this->product_model->get_all_details(PRODUCT_ATTRIBUTE,array())->result();
			   
			   $condition = " where (p.status='Publish' or p.status='unpublish') and p.user_id=".$loggeduserID." and (u.group='User' or u.group='Seller') and u.status='Active' or p.status='Publish' and p.user_id=0 and a.pricing IS NOT NULL group by p.id order by p.created desc";
				$this->data['shopDetail']=$this->product_model->view_product_details($condition)->result();
 				//$this->db->last_query();
				//echo '<pre>';print_r($this->data['shopDetail']); die;
			   
			   //$this->data['shopDetail'] = $this->product_model->get_all_details(PRODUCT,array('user_id' => $loggeduserID))->result();
			   //$this->data['AllmainCategories'] = $this->product_model->get_all_details(CATEGORY,array('rootID'=> 0,'status' => 'Active'))->result();
#			   $this->data['countryList'] = $this->product_model->get_all_details(COUNTRY_LIST,array())->result();
			   $this->data['meta_title'] = $this->data['heading'] = 'Shop List Items';
		       $this->load->view('site/shop/add_shop_listitems',$this->data);
				}else{
					redirect('');	
				}
			   			 
			}
			if($optionsLoad == 'payment')
			{
#			$this->data['countryList'] = $this->product_model->get_all_details(COUNTRY_LIST,array())->result();
			$this->data['shopDetail'] = $this->product_model->get_all_details(PRODUCT,array('user_id' => $loggeduserID))->result();
			$this->data['meta_title'] = $this->data['heading'] = 'Shop Payment';
		    $this->load->view('site/shop/add_shop_getpaid',$this->data);
			}
			if($optionsLoad == 'billing')
			{
#			$this->data['countryList'] = $this->product_model->get_all_details(COUNTRY_LIST,array())->result();
			$this->data['shopDetail'] = $this->product_model->get_all_details(PRODUCT,array('user_id' => $loggeduserID,'pay_status'=>'Pending'))->result();
			$this->data['userDetails']=$this->seller_model->get_all_details(USER,array('id'=>$loggeduserID))->row();
			$this->data['CardsDetails'] = $this->product_model->get_all_details(CREDITCARDS,array('user_id'=>$loggeduserID))->row();
			$this->data['sellingPayment'] = $this->product_model->get_all_details(ADMIN_SETTINGS,array('id' => 1));
			
			$this->db->select('status');
			$this->db->from(SELLER);
			$this->db->where('seller_id = '.$this->data['loginCheck']);
			$this->data['SellerValShop'] = $this->db->get();
			
			$this->data['products_in_pay']=count($this->data['shopDetail']);
			$this->data['meta_title'] = $this->data['heading'] = 'Shop Billing';
			#echo "<pre>"; print_r($this->data['userDetails']); die;
		    $this->load->view('site/shop/add_shop_billing',$this->data);
			}
			
	  	}else {
			$this->data['next'] = $this->input->get('next');
			$this->data['meta_title'] = $this->data['heading'] =$this->data['title']= 'Shop index';
			$this->load->view('site/shop/add_shop_index',$this->data);
		}
	}
	public function load_shop_preview()
	{
		$checkloginIDarr=$this->session->all_userdata(); 
		$loggeduserID=$checkloginIDarr['shopsy_session_user_id'];
		$this->data['selectUser_details']=$this->seller_model->get_all_details(USER,array('id'=>$loggeduserID))->result_array();
		$this->data['selectSeller_details']=$this->seller_model->get_sellers_data(SELLER,$condition);
		
		$this->data['countryList'] = $this->product_model->get_all_details(COUNTRY_LIST,array())->result();
		$this->data['selectSeller_details']=$this->seller_model->get_sellers_data(SELLER,$condition);
		#$this->data['shopDetail'] = $this->product_model->get_all_details(PRODUCT,array('user_id' => $loggeduserID))->result();					 	  
		$cond=array('seller_id' => $loggeduserID); 
		$this->data['product'] = $this->product_model->get_all_details(PRODUCT,array('user_id' => $loggeduserID))->result_array();
		
		$this->data['shop_section_details']=$this->seller_model->getShopSectionDetails($loggeduserID);
		$section=$this->uri->segment(4);
		foreach($this->data['shop_section_details'] as $shop_sec)
		{
			if($shop_sec['section_id']==$section)
			{
				$product_list=$shop_sec['product_id'];
				$condition1 = " where u.group='Seller' and FIND_IN_SET(p.id,'".$product_list."') and u.status='Active' and p.user_id=".$loggeduserID." or p.user_id=".$loggeduserID." and FIND_IN_SET(p.id,'".$product_list."') and a.pricing IS NOT NULL group by p.id order by p.created desc";
			}
			
		}
		
		
		$this->data['shopDetail'] =$this->product_model->view_product_details_from_section($condition1)->result_array();
		#echo $this->db->last_query(); die;
		#echo "<pre>"; print_r($this->data['shopDetail']); die;		
		$this->data['product'] = $this->product_model->get_all_details(PRODUCT,array('user_id' => $loggeduserID))->result_array();
		$this->data['Paidproduct'] = $this->product_model->get_all_details(PRODUCT,array('user_id' => $loggeduserID,'pay_status'=>'Paid'));
		
		#$this->data['shop_section_details']=$this->seller_model->getShopSectionDetails($loggeduserID);
		$this->data['shop_section_count']=count($this->data['shop_section_details']);
		$this->data['meta_title'] = $this->data['heading'] = 'Your Shop';
		$this->load->view('site/shop/shop_preview',$this->data);
	}
	
	/*******************open new shop start**********insert &&&& update shop****************/
	public function open_new_shop()
	{
	   if ($this->checkLogin('U')!='')
	   {
	     $checkloginIDarr=$this->session->all_userdata(); 		
		  if($this->input->post('seller_businessname') != '')
		  {
			  $loggeduserID=$checkloginIDarr['shopsy_session_user_id'];
			  $checkUser_inSellerlist=$this->seller_model->get_sellers_data(SELLER,$condition);
		      if(count($checkUser_inSellerlist) == 1)  // if count 1 means user details exist in seller table,so we need to update the details else  need to insert details
			     {   
					   $seourl = url_title($this->input->post('seller_businessname'), '-', TRUE);
					   $checkSeo = $this->product_model->get_all_details(SELLER,array('seourl'=>$seourl,'seller_id !='=>$loggeduserID));
					   $seo_count = 1;
						  while ($checkSeo->num_rows()>0)
						  {
						  $seourl = $seourl.'-'.$seo_count;
						  $seo_count++;
						  $checkSeo = $this->product_model->get_all_details(SELLER,array('seourl'=>$seourl,'seller_id !='=>$loggeduserID));
						  }
					  $data_to_update=array('seller_businessname' => addslashes($this->input->post('seller_businessname')),'seourl' => $seourl);
					  $this->product_model->commonInsertUpdate(SELLER,'update','',$data_to_update,array('seller_id' => $loggeduserID));
				  }
				  else
				  {
					$this->data['UserVal'] = $this->user_model->get_all_details(USERS,array('id'=>$this->checkLogin('U')))->row();
					$seourl = url_title($this->input->post('seller_businessname'), '-', TRUE);
			        $checkSeo = $this->product_model->get_all_details(SELLER,array('seourl'=>$seourl,'seller_id !='=>$loggeduserID));
			        $seo_count = 1;
			          while ($checkSeo->num_rows()>0)
					  {
			 	      $seourl = $seourl.'-'.$seo_count;
				      $seo_count++;
				      $checkSeo = $this->product_model->get_all_details(SELLER,array('seourl'=>$seourl,'seller_id !='=>$loggeduserID));
			          }
					$inputArrval=array(
					'seller_id' => $this->data['UserVal']->id,
				    'seller_businessname' => $this->input->post('seller_businessname'),
					'seourl' => $seourl,
				    'seller_email' => $this->data['UserVal']->email,
					'seller_firstname' => $this->data['UserVal']->full_name,
					'seller_lastname' => $this->data['UserVal']->last_name,
					'status' => 'inactive',
					'created' => $this->data['UserVal']->created
					);
					$condition=array();
					$this->product_model->commonInsertUpdate(SELLER,'insert','',$inputArrval,$condition);
				  }
		    }
		  
		         $this->data['selectSeller_details']=$this->seller_model->get_sellers_data(SELLER,$condition);
				 $this->setErrorMessage('success','Success! Your shop name is now '.stripslashes($this->data['selectSeller_details'][0]['seller_businessname']));
		 		 redirect('shop/listitem');
				# $this->load->view('site/shop/add_shop_listitems',$this->data);

			}else {
				$this->data['heading'] = 'Sign in'; 
				redirect('site/user/login_user');
			}
	}
	/*******************open new shop end**************************/
	
	
	/*******************oShop get billing form Start**********insert & update ****************/
	public function shop_getpaid_details()
	{
		if ($this->checkLogin('U')!='')
		{
			$checkloginIDarr=$this->session->all_userdata(); 
			$loggeduserID=$checkloginIDarr['shopsy_session_user_id'];
			
			$selectSeller_details=$this->seller_model->get_sellers_data(SELLER,$condition);
												
			$payment_mode=implode(',', $this->input->post('payment_mode'));
			$PayPal_mode=$this->input->post('PayPal_mode');
			$PayPal_email=$this->input->post('PayPal_email');
			$paypal_username=$this->input->post('paypal_username');
			$paypal_password=$this->input->post('paypal_password');
			$paypal_signature=$this->input->post('paypal_signature');
			
			$authorize_key=$this->input->post('authorize_key');
			$authorize_mode=$this->input->post('authorize_mode');
			$authorize_id=$this->input->post('authorize_id');
			$authorize_key=$this->input->post('authorize_key');
			
			/*$Pay_country=$this->input->post('Pay_country');
			$Pay_fullname=$this->input->post('Pay_fullname');
			$Pay_street=$this->input->post('Pay_street');
			$Pay_aso=$this->input->post('Pay_aso');
			$Pay_city=$this->input->post('Pay_city');
			$Pay_state=$this->input->post('Pay_state');
			$Pay_zippostalcode=$this->input->post('Pay_zippostalcode');*/
			
			/*$inputArrVal=array(
							'payment_mode' => $payment_mode,
							'PayPal_email' => $PayPal_email,
							'Pay_country' => $Pay_country,
							'Pay_fullname' => $Pay_fullname,
							'Pay_street' => $Pay_street,
							'Pay_aso' => $Pay_aso,
							'Pay_city' => $Pay_city,
							'Pay_state'=>$Pay_state,
							'Pay_zippostalcode'=>$Pay_zippostalcode
						);*/
			$inputArrVal=array(
							'payment_mode' => $payment_mode,
							'PayPal_mode' =>$PayPal_mode,
							'PayPal_email' => $PayPal_email,
							'paypal_username' => $paypal_username,
							'paypal_password' => $paypal_password,
							'paypal_signature' => $paypal_signature,
							'authorize_mode' => $authorize_mode,
							'authorize_id' => $authorize_id,
							'authorize_key' => $authorize_key
						);
			#print_r($inputArrVal);  die;
			$condition=array('seller_id' => $loggeduserID);			
			$usrdataArr = array('paypal_email'=>$PayPal_email);
			if($selectSeller_details[0]['seller_businessname']=="")
			{
				$this->product_model->commonInsertUpdate(SELLER,'insert','',$inputArrVal,$condition);
				$this->data['selectSeller_details']=$this->seller_model->get_sellers_data(SELLER,$condition);
				$this->product_model->update_details(USERS,$usrdataArr,array('id'=>$loggeduserID));
				$this->setErrorMessage('success','Success! Your Shop Payment modes are Added');
				redirect('shop/billing');		
			}
			else
			{
				$this->product_model->commonInsertUpdate(SELLER,'update','',$inputArrVal,$condition);
				$this->data['selectSeller_details']=$this->seller_model->get_sellers_data(SELLER,$condition);
				$this->product_model->update_details(USERS,$usrdataArr,array('id'=>$loggeduserID));
				$this->setErrorMessage('success','Success! Your Shop Payment modes are Updated');
				redirect('shop/billing');
			}
				       			
		}
	}
	/*******************Shop get billing form End**************************/
	
	
	// Shop template setting Background

	public function shop_template_setting_background()
	{
		if ($this->checkLogin('U')!=''){
			$this->data['SellerVal'] = $this->seller_model->get_userselldetail_data('*',$this->checkLogin('U'));
			$this->data['userVal'] = $this->seller_model->get_userdetail_data('facebook,twitter,google,pinterest,thumbnail,location,full_name');
			//echo '<pre>'; print_r($this->data['SellerVal']); die;
			$this->data['meta_title'] = $this->data['heading'] = 'Shop Setup';
			$this->load->view('site/shop/shop_template_layout.php',$this->data);
			
		}else {
			$this->data['next'] = $this->input->get('next');
			$this->data['meta_title'] = $this->data['heading'] = 'Sigin'; 
			$this->load->view('site/user/signup.php',$this->data);
		}
	}
	

	 
	 
	 // Seller Store view form
	
	public function seller_store_view(){
		 $sellerstore_id = $this->uri->segment(2, 0); 
		 
		 
		 $cat_idname = $this->uri->segment(3, 0); 
	//echo $cat_id; die;
	
	//print_r($cat_idname); die;
	
		 $seller_idexplopde = @explode('-',$sellerstore_id);
		 
		 $seller_id = $seller_idexplopde[0];
		// print_r($seller_id); die;
		$cat_idnameexplopde = @explode('-',$cat_idname);

		$cat_id = $cat_idnameexplopde[0];
		
		//echo $cat_id; die;
		 $this->data['userVal'] = $this->seller_model->get_userselldetail_data('shop_template,seller_businessname,seourl,seller_firstname,seller_id,seller_store_image,seller_email,seller_social_icons',$seller_id);
		 $this->data['userpersonalVal'] = $this->seller_model->get_userdetail_datastore('full_name,city,thumbnail,facebook,twitter,google,pinterest,web_url',$seller_id);
		//echo $this->data['userVal'][0]['shop_template']; die;
		//echo $this->db->last_query(); die;
		$this->data['meta_title'] = $this->data['heading'] = $this->data['userVal'][0]['seller_businessname'];

		    $searchPerPage = 2;
		    $paginationNo = $this->uri->segment('2');  
	     
			if($paginationNo == '')
			{
					$paginationNo = 0;
			}
			else
			{
					$paginationNo = $paginationNo;
			}
			
		$this->data['productVal'] = $this->product_model->get_storedetail_data_store('id,seourl,product_name,sale_price,image,product_featured,user_id',$cat_id,$searchPerPage,$paginationNo,$seller_id);
		
		//echo $this->db->last_query(); die;
		//echo $this->data['productVal'][0]['product_name']; die;
		
		
		
		$this->data['catVal'] = $catVal = $this->product_model->view_cat_details($cat_id);
		if($this->data['catVal'][0]['cat_name'] != ''){
		    $this->data['heading'] = $this->data['catVal'][0]['cat_name'];
			$this->data['meta_title'] = $this->data['catVal'][0]['meta_title'];
			$this->data['meta_keyword'] = $this->data['catVal'][0]['seo_keyword'];
			$this->data['meta_description'] = $this->data['catVal'][0]['seo_description'];
			}
		//echo $this->db->last_query(); die;
		//echo $this->data['catVal']; die;
		if($this->data['userVal'][0]['shop_template'] == 'four'){
		$limit = '4';
		}else {
		
		$limit = '3';
		}
		$this->data['featured'] = $this->product_model->get_storedetail_data_storefeature('id,seourl,product_name,sale_price,image,product_featured,user_id',$cat_id,$searchPerPage,$paginationNo,$seller_id,$limit);
		//echo $this->db->last_query(); die;
		
		$searchbaseUrl = base_url().$this->uri->segment('1').'/';
			$product_routes_name = $this->uri->segment(); 
			$config['prev_link'] = '<img src="images/page_prevt_hover.png" />';
			$config['num_links'] = 3;
			$config['display_pages'] = TRUE; 
			$config['next_link'] = '<img src="images/page_next.png" />';
			$config['base_url'] = $searchbaseUrl;
			$config['total_rows'] = count($blogTotal); 
			$config["per_page"] = $searchPerPage;
			$config["uri_segment"] = 2;
			$config['first_link'] = '';
			$config['last_link'] = '';
			$this->pagination->initialize($config); 
			 $paginationLink = $this->pagination->create_links(); 
			$this->data['paginationLink'] = $paginationLink;
			
			//echo $this->data['catVal'][0]['cat_name']; die;
			
			/*$this->data['meta_keyword'] = $this->data['catVal'][0]['seo_keyword'];
			$this->data['meta_description'] = $this->data['catVal'][0]['seo_description'];*/
	//	echo '<pre>';
	//	print_r($this->data['userVal']); die;
		$this->load->view('site/shop/shop_display.php',$this->data);
			
	}
	
	// Shop Feedback view form
	
		public function feedback_store_view(){
		
		 $sellerstore_id = $this->uri->segment(2, 0); 
		 

		 $cat_idname = $this->uri->segment(3, 0); 
		 $seller_idexplopde = @explode('-',$sellerstore_id);
		 
		 $seller_id = $seller_idexplopde[0];
		$cat_idnameexplopde = @explode('-',$cat_idname);

		$cat_id = $cat_idnameexplopde[0];
		
		 $this->data['userVal'] = $this->seller_model->get_userselldetail_data('shop_template,id,seller_businessname,seourl,seller_firstname,seller_id',$seller_id);
				 $this->data['userpersonalVal'] = $this->seller_model->get_userdetail_datastore('full_name,city,thumbnail',$seller_id);

				$this->data['productVal'] = $this->product_model->get_storedetail_data_store('id,seourl,product_name,sale_price,image,product_featured,user_id',$cat_id,$searchPerPage,$paginationNo,$seller_id);

		
		$this->load->view('site/shop/shop_feedback.php',$this->data);
			
	}		
	
		// Add Feedback form

	//Store Feedback
public function store_all_feedback() 
{
			$searchPerPage = 1;
			
		    $paginationNo = $this->uri->segment('3');  

			if($paginationNo == '')
			{
				$paginationNo = 0;
			}
			else
			{
				$paginationNo = $paginationNo;
			}

	
	    $shopDetails = $this->uri->segment(2);
		$a = explode("-",$shopDetails);
		$shopId = $a[0]; 

	    $this->data['FeedbackDetails'] = $a = $this->seller_model->get_shop_feedback($shopId,$searchPerPage,$paginationNo); 
	     //print_r($a); die; 
	    $this->load->view('site/user/shop_all_feedback.php',$this->data);
}


//Ajax Image Upload Shop Banner
	public function upload_product_image_banner(){
		$returnStr['status_code'] = 0;
		$config['overwrite'] = FALSE;
    	$config['allowed_types'] = 'jpg|jpeg|gif|png';
//	    $config['max_size'] = 2000;
	    $config['upload_path'] = './images/store-banner';
	    $this->load->library('upload', $config);
		if ( $this->upload->do_upload('thefile')){
	    	$imgDetails = $this->upload->data();
	    	$returnStr['image']['url'] = base_url().'images/store-banner/'.$imgDetails['file_name'];
	    	$returnStr['image']['width'] = $imgDetails['image_width'];
	    	$returnStr['image']['height'] = $imgDetails['image_height'];
	    	$returnStr['image']['name'] = $imgDetails['file_name'];
			
			$this->ImageResizeWithCrop(760, 100, $imgDetails['file_name'], './images/store-banner/');
			
	    	//$this->ImageResizeWithCrop(1000, 108, $imgDetails['file_name'], './images/store-banner/');
			//@copy('./images/store-banner/'.$imgDetails['file_name'], './images/store-banner/thumb/'.$imgDetails['file_name']);
			//$this->ImageResizeWithCrop(780, 108, $imgDetails['file_name'], './images/store-banner/thumb/');
			
			$fileDetails = 	$imgDetails['file_name'];
			
			$this->seller_model->update_details(SELLER,array('seller_store_image'=>$fileDetails),array('seller_email'=>$this->session->userdata('shopsy_session_user_email')));
			
	    	$returnStr['status_code'] = 1;
		}else {
			$returnStr['message'] = "Can\'t be upload";
		}
		echo json_encode($returnStr);
	}

//Ajax Image Upload Shop Banner
	public function upload_product_image_profile(){
		$returnStr['status_code'] = 0;
		$config['overwrite'] = FALSE;
    	$config['allowed_types'] = 'jpg|jpeg|gif|png';
//	    $config['max_size'] = 2000;
	    $config['upload_path'] = './images/users';
	    $this->load->library('upload', $config);
		if ( $this->upload->do_upload('thefile')){
	    	$imgDetails = $this->upload->data();
	    	$returnStr['image']['url'] = base_url().'images/users/'.$imgDetails['file_name'];
	    	$returnStr['image']['width'] = $imgDetails['image_width'];
	    	$returnStr['image']['height'] = $imgDetails['image_height'];
	    	$returnStr['image']['name'] = $imgDetails['file_name'];
	    	$this->ImageResizeWithCrop(600, 600, $imgDetails['file_name'], './images/users/');
			//@copy('./images/store-banner/'.$imgDetails['file_name'], './images/store-banner/thumb/'.$imgDetails['file_name']);
			//$this->ImageResizeWithCrop(780, 108, $imgDetails['file_name'], './images/store-banner/thumb/');
			
			$fileDetails = 	$imgDetails['file_name'];
			
			$this->seller_model->update_details(USERS,array('thumbnail'=>$fileDetails),array('id'=>$this->checkLogin('U')));
			
	    	$returnStr['status_code'] = 1;
		}else {
			$returnStr['message'] = "Can\'t be upload";
		}
		echo json_encode($returnStr);
	}	
	//Social media update for shop banner page
	public function socialmediaupdate(){
		
		//echo '<pre>'; print_r($_POST); die;
		
		$this->seller_model->update_details(USERS,array($this->input->post('id')=>$this->input->post('idval')),array('id'=>$this->checkLogin('U')));
		return 1;
		
	}
	
	//Store set up Page 
	public function storesetupfirstpage(){
		
		$dataArrVal = array();
		foreach($this->input->post() as $key => $val){
			if(!(in_array($key,$excludeArr))){
				$dataArr[$key] = trim(addslashes($val));
			}
		}
		
		$condition =array('seller_id'=>$this->checkLogin('U'));
		$this->seller_model->update_details(SELLER,$dataArr,$condition);
		$this->setErrorMessage('success','Store Setup Successfully Updated.');
		return 1;
		
	}
	/* Ajax select for shipping country list from add shop list items */
	public function load_ajax_shipping_list($i,$selected_country){	 
		
		$selected_countryArr=explode(':',urldecode($selected_country));
		#print_r($selected_country); die;
		$selected_countryArr[1]; #die;
		$countryList= $this->product_model->get_all_details(COUNTRY_LIST,array())->result();
		echo '<tr><td width="30%"><p id="shipping_to_'.$i.'_lab" ></p><select name="shipping_to[]" id="shipping_to_'.$i.'" class="shipping_to" style="width: 200px; padding: 3px 4px; box-shadow: none; margin: 2px 0px 0px 20px; border: 1px solid rgb(205, 205, 205);"    onchange="display_sel_val(this); toggleDisability(this);">';
		echo '<option value="">Select a location</option>';
		foreach($countryList as $country) 
		{
			if (in_array($country->name,$selected_countryArr, TRUE)){ echo'<option value="'.$country->name.'" disabled>'.$country->name.'</option>';}
			else{echo'<option value="'.$country->id.'|'.$country->name.'">'.$country->name.'</option>';}			
		}			
		echo '</select><input type="hidden" name="ship_to_id[]" id="shipping_to_'.$i.'_id" />
		</td>
		<td width="20%" style="margin: 0px 0px 0px 50px;"><p style="width:auto; margin:2px 4px 0 0px">$</p><input type="text" value="" class="shipping_txt_box"  name="shipping_cost[]" id="shipping_cost_'.$i.'"></td>
		<td width="20%" style="margin: 0px 0px 0px 50px;"><p style="width:auto; margin:2px 4px 0 0px">$</p><input type="text" value="" class="shipping_txt_box"  name="shipping_with_another[]" id="shipping_with_another_'.$i.'"><a class="close_icon left" href="javascript:void(0)" style="margin:7px 0 0 5px" id="'.$i.'"></a></td>
		</tr>
		';
	}
	
	/* Ajax select for shipping country list from add shop list items */
	public function load_ajax_DigiFiles_list($filename){	 		
							$id=time();
							$path = "temp_digital_files/";
								echo '<tr>
                                	<td width="70%"> 
                                    	&nbsp;
										<a href="'.$path.$filename.'" target="_blank">'.$filename.'</a>
                                        <input type="hidden" value="'.$filename.'" class="DigiFiles" name="DigiFiles[]">
                                     </td>
                                    <td width="26%">
                                        <a class="close_icon" href="javascript:void(0);" style="margin:7px 0 0 5px" id="'.$id.'"></a>
                                    </td>
                                </tr>';
	}
	
	public function ajax_load_Files(){
		           $path = "temp_digital_files/";
				   $file = preg_replace('/\s+/', '_',$_FILES["file_upload"]["name"]);
				   if($_FILES["file_upload"]["name"] != ''){
	               move_uploaded_file($_FILES["file_upload"]["tmp_name"], $path.$file);
				   echo $file;
				   }
	}
	
	
	/*******************Shop appearance  Start****************/
	public function shop_appearance_setting()
	{
		if ($this->checkLogin('U')!='')
		{
			$checkloginIDarr=$this->session->all_userdata(); 
			$loggeduserID=$checkloginIDarr['shopsy_session_user_id'];			
			$selectSeller_details=$this->seller_model->get_sellers_data(SELLER,$condition);
												
			
			$shop_title=$this->input->post('shop_title');
			$shop_banner=$this->input->post('shop_banner');
			if($this->input->post('local_markets')){$local_markets="Yes";} else{$local_markets="No";}
			$shop_announcement=$this->input->post('shop_announcement');
			$msg_to_buyers=$this->input->post('msg_to_buyers');
			$msg_to_buyers_for_digiitem=$this->input->post('msg_to_buyers_for_digiitem');
			
			
			$config['overwrite'] = FALSE;
			$config['allowed_types'] = 'jpg|jpeg|gif|png';
			#$config['max_size'] = 2000;
			$config['upload_path'] = './images/store-banner';
			$this->load->library('upload', $config);
			if ( $this->upload->do_upload('shop_banner'))
			{
				$imgDetails = $this->upload->data();
				$returnStr['image']['url'] = base_url().'images/store-banner/'.$imgDetails['file_name'];
				$returnStr['image']['width'] = $imgDetails['image_width'];
				$returnStr['image']['height'] = $imgDetails['image_height'];
				$returnStr['image']['name'] = $imgDetails['file_name'];
				
				$this->ImageResizeWithCrop(760, 100, $imgDetails['file_name'], './images/store-banner/');
				$fileDetails = 	$imgDetails['file_name'];
				
			}
			
				if($fileDetails==""){
						$inputArrVal=array(
							'shop_title' => $shop_title,
							'local_markets' => $local_markets,
							'shop_announcement' => $shop_announcement,
							'msg_to_buyers' => $msg_to_buyers,
							'msg_to_buyers_for_digiitem' => $msg_to_buyers_for_digiitem
						);
				}
				else{
						$inputArrVal=array(
							'shop_title' => $shop_title,
							'seller_store_image' => $fileDetails,
							'local_markets' => $local_markets,
							'shop_announcement' => $shop_announcement,
							'msg_to_buyers' => $msg_to_buyers,
							'msg_to_buyers_for_digiitem' => $msg_to_buyers_for_digiitem
						);			
				}
				
				$condition=array('seller_id' => $loggeduserID);
			
				$this->product_model->commonInsertUpdate(SELLER,'update',array('shop-banner'),$inputArrVal,$condition);
				$this->data['selectSeller_details']=$this->seller_model->get_sellers_data(SELLER,$condition);
				$this->setErrorMessage('success','Success! Your Shop Apperances Updated');
				redirect('shop/sell');
			
				       			
		}
	}
	/*******************Shop appearance End**************************/
	
	/*******************Shop appearance  Start****************/
	public function shop_policy_setting()
	{
		if ($this->checkLogin('U')!='')
		{
			$checkloginIDarr=$this->session->all_userdata(); 
			$loggeduserID=$checkloginIDarr['shopsy_session_user_id'];			
												
			
			$welcome_message=$this->input->post('welcome_message');
			$payment_policy=$this->input->post('payment_policy');
			$shipping_policy=$this->input->post('shipping_policy');
			$refund_policy=$this->input->post('refund_policy');
			$additional_information=$this->input->post('additional_information');
			$seller_information=$this->input->post('seller_information');
			
						$inputArrVal=array(
							'welcome_message' => $welcome_message,
							'payment_policy' => $payment_policy,
							'shipping_policy' => $shipping_policy,
							'refund_policy' => $refund_policy,
							'additional_information' => $additional_information,
							'seller_information' => $seller_information
						);			
				
				$condition=array('seller_id' => $loggeduserID);
			
				$this->product_model->commonInsertUpdate(SELLER,'update','',$inputArrVal,$condition);
				$this->data['selectSeller_details']=$this->seller_model->get_sellers_data(SELLER,$condition);
				$this->setErrorMessage('success','Success! Your Shop Policy Updated');
				redirect('shop/sell');
			
				       			
		}
	}
	/*******************Shop appearance End**************************/
	/*******************Shop Sections  Start****************/
	public function add_shop_section_list()
	{
		if ($this->checkLogin('U')!='')
		{
			$checkloginIDarr=$this->session->all_userdata(); 
			
			$loggeduserID=$checkloginIDarr['shopsy_session_user_id'];
						
			$section_name=$this->input->post('name');
			
			$section_id=time();			
			
				$dataArr=array(
					'seller_id' =>$loggeduserID,
					'section_name' => $section_name,
					'section_id' => $section_id,
				);			
				
				$condition=array('seller_id' => $loggeduserID);
				$this->data['selectSeller_details']=$this->seller_model->get_sellers_data(SELLER,$condition);
				$this->data['selectSeller_details']=$this->seller_model->get_sellers_data(SHOP_SECTION_LIST,$condition);
				if($section_name.trim()==''){
					$this->setErrorMessage('error','Section name cannot be empty');
					redirect('shops/'.$this->data['selectSeller_details'][0]['seourl'].'/sections/All');
				}
				$this->seller_model->simple_insert(SHOP_SECTION_LIST,$dataArr);
				
				$this->setErrorMessage('success','Success! Section Created');
				redirect('shops/'.$this->data['selectSeller_details'][0]['seourl'].'/sections/'.$section_id);
			
				       			
		}
	}
	/*******************Shop Sections End**************************/
	
	
	/*************************************/
	public function load_shopowner_profile(){
		$checkloginIDarr=$this->session->all_userdata(); 
		$loggeduserID=$checkloginIDarr['shopsy_session_user_id'];		   
		$this->data['selectSeller_details']=$this->seller_model->display_seller_view_admin($loggeduserID);
		$this->load->view('site/shop/shop_owner',$this->data);
	}
	
	/**************************************Update Seller Profile********************************************************************/
	public function update_seller_profile(){
		if ($this->checkLogin('U')==''){
			$this->setErrorMessage('error','You must login');
			redirect('login');
		}
			 $city=addslashes(trim($this->input->post('city')));
			 $about=addslashes(trim($this->input->post('about')));
			 
			if($_FILES['profile_pict']['name']!=""){
				$config['overwrite'] = FALSE;
	    		$config['allowed_types'] = 'jpg|jpeg|gif|png';
	    		$config['upload_path'] = 'images/users';
		    	$this->load->library('upload', $config);
			 	if ($this->upload->do_upload('profile_pict')){
		   			$logoDetails = $this->upload->data(); 
		    		$this->ImageResizeWithCrop(600, 600, $logoDetails['file_name'], './images/users/');
					@copy('./images/users/'.$logoDetails['file_name'], './images/users/thumb/'.$logoDetails['file_name']);
		    		$this->ImageResizeWithCrop(210, 210, $logoDetails['file_name'], './images/users/thumb/');
			 		$profile_image=$logoDetails['file_name'];
				 	$dataArr=array('city'=>$city,'about'=>$about,'thumbnail'=>$logoDetails['file_name']);
			 	}
			 	else{
					$this->setErrorMessage('error',"There was a problem with your image");
			 		redirect("public-profile");
				}
			}else{
				$dataArr=array('city'=>$city,'about'=>$about);
			}
			
			$this->seller_model->update_details(USERS,$dataArr,array('id'=>$this->checkLogin('U')));
			if($this->db->affected_rows()>0){
				$this->setErrorMessage('success',"Your profile successfully updated");
			 	redirect("shops/".$this->uri->segment(2, 0)."/profile");	
			}else{
				$this->setErrorMessage('success',"No updation on your profile");
		 		redirect("shops/".$this->uri->segment(2, 0)."/profile");
			}
	}
	
	public function load_shop_policies(){
		$checkloginIDarr=$this->session->all_userdata(); 
		$loggeduserID=$checkloginIDarr['shopsy_session_user_id'];		   
		$this->data['selectSeller_details']=$this->seller_model->get_sellers_data(SELLER,$condition);
		$this->load->view('site/shop/shop_policies',$this->data);
	}
	public function load_info_appearance(){
		/*echo $this->uri->segment(2);
		echo $this->uri->segment(3); die;*/
		$checkloginIDarr=$this->session->all_userdata(); 
		$loggeduserID=$checkloginIDarr['shopsy_session_user_id'];		
	  	$condition=array('seller_id' => $loggeduserID); 
		$this->data['selectSeller_details']=$this->seller_model->get_sellers_data(SELLER,$condition);
		$this->data['shopDetail'] = $this->product_model->get_all_details(PRODUCT,array('user_id' => $loggeduserID))->result();		
		$this->load->view('site/shop/shop_info_appearance',$this->data);
	}
	public function load_shop_sections(){
		
		$section=$this->data['section_id']= $this->uri->segment(4,0); 		
		$checkloginIDarr=$this->session->all_userdata(); 
		$loggeduserID=$checkloginIDarr['shopsy_session_user_id'];		  
		$condition=array('seller_id' => $loggeduserID);  
		$this->data['selectSeller_details']=$this->seller_model->get_sellers_data(SELLER,$condition);		
		$this->data['shop_section_details']=$this->seller_model->getShopSectionDetails($loggeduserID);
		if($section=='All')
		{
			$condition1 = " where u.group='Seller' and u.status='Active' and p.user_id=".$loggeduserID." or p.user_id=".$loggeduserID." and a.pricing IS NOT NULL group by p.id order by p.created desc";
		}
		else
		{
			foreach($this->data['shop_section_details'] as $shop_sec)
			{
				if($shop_sec['section_id']==$section)
				{
					$product_list=$shop_sec['product_id'];
					$condition1 = " where u.group='Seller' and FIND_IN_SET(p.id,'".$product_list."') and u.status='Active' and p.user_id=".$loggeduserID." or p.user_id=".$loggeduserID." and FIND_IN_SET(p.id,'".$product_list."') and a.pricing IS NOT NULL group by p.id order by p.created desc";
				}
			}
		}
		
		$this->data['productDetail'] =$this->product_model->view_product_details_from_section($condition1)->result_array();
		#echo $this->db->last_query(); die;
		#echo "<pre>"; print_r($this->data['productDetail']); die;		
		$this->data['product'] = $this->product_model->get_all_details(PRODUCT,array('user_id' => $loggeduserID))->result_array();
		$this->data['shop_section_list']=$this->seller_model->get_sellers_data(SHOP_SECTION_LIST,$condition);
		$this->data['shop_section_count']=count($this->data['shop_section_list']);
		$this->data['shop_section_details']=$this->seller_model->getShopSectionDetails($loggeduserID);
		$this->load->view('site/shop/shop_sections',$this->data);
	}
	
	public function delete_shop_sections(){
		if ($this->checkLogin('U')!='')
		{
			$checkloginIDarr=$this->session->all_userdata(); 
			$loggeduserID=$checkloginIDarr['shopsy_session_user_id'];
			$status=$this->input->post('status');
			$section=$this->input->post('section');
			$name=$this->input->post('name');
				$CondArr=array(
					'seller_id' => $loggeduserID,
					'section_id' => $section,
				);			
			$this->seller_model->commonDelete(SHOP_SECTION_LIST,$CondArr);
			$this->setErrorMessage('success','Successfully deleted the section "'.$name.'"');
			redirect('site/shop/load_shop_sections');		
				       			
		}
		
	}
	public function edit_shop_section(){
		if ($this->checkLogin('U')!='')
		{
			$checkloginIDarr=$this->session->all_userdata(); 
			$loggeduserID=$checkloginIDarr['shopsy_session_user_id'];
			
			$section=$this->input->post('section');
			$name=$this->input->post('name');
			if($name.trim()==''){
				$this->setErrorMessage('error','Section name cannot be empty');
				redirect('site/shop/load_shop_sections');
			}
			$dataArr = array('section_name' => $name);
			$condition=array('seller_id' => $loggeduserID,'id' => $section);
			$this->seller_model->shopSectionUpdate(SHOP_SECTION_LIST,$condition,$dataArr);
			#echo $this->db->last_query(); die;
			$this->setErrorMessage('success','Successfully Updated the section "'.$name.'"');
			redirect('site/shop/load_shop_sections');		
				       			
		}
		
	}
	public function edit_shop_sections_list(){
		if ($this->checkLogin('U')!='')
		{
			$checkloginIDarr=$this->session->all_userdata(); 
			$loggeduserID=$checkloginIDarr['shopsy_session_user_id'];
			$condition=array('seller_id' => $loggeduserID); 
			$Seller_details=$this->seller_model->get_sellers_data(SELLER,$condition);
			$seourl=$Seller_details[0]['seourl'];
			
			$old_sec_id=$this->input->post('old_sec_id');
			$old_sec_prod=$this->input->post('old_sec_prod');
			$old_sec_count=$this->input->post('old_sec_count');
			
			$new_sec_id=$this->input->post('new_sec_id');
			$new_sec_prod=$this->input->post('new_sec_prod');
			$new_sec_count=$this->input->post('new_sec_count');
			
			if($old_sec_id!='All')
			{
				/*Get the Existing products in new Section List*/
				$newList= $this->product_model->get_all_details(SHOP_SECTION_LIST,array('seller_id' => $loggeduserID,'section_id' => $new_sec_id))->result_array();
				$new_sec_prod.=$newList[0]['product_id'];
				$new_sec_count=$new_sec_count+$newList[0]['shop_prod_count'];
				$dataArr = array('product_id' => $old_sec_prod,'shop_prod_count'=>$old_sec_count);
				$condition=array('seller_id' => $loggeduserID,'section_id' => $old_sec_id);
				$this->seller_model->shopSectionUpdate(SHOP_SECTION_LIST,$condition,$dataArr);
				#Update product into new list			
				$dataArr = array('product_id' => $new_sec_prod,'shop_prod_count'=>$new_sec_count);
				$condition=array('seller_id' => $loggeduserID,'section_id' => $new_sec_id);
				$this->seller_model->shopSectionUpdate(SHOP_SECTION_LIST,$condition,$dataArr);
			}
			else
			{
				$prod=explode(',',$new_sec_prod);
				$newProd=explode(',',$new_sec_prod);
				for($i=0;$i<count($prod)-1;$i++)
				{
					$oldList= $this->product_model->shop_section_list_exist($loggeduserID,$prod[$i]);
					$old_sec_prod=str_replace($prod[$i].',','',$oldList[0]['product_id']);
					$old_sec_count=$oldList[0]['shop_prod_count']-1;
					$dataArr = array('product_id' => $old_sec_prod,'shop_prod_count'=>$old_sec_count);
					$condition=array('seller_id' => $loggeduserID,'section_id' => $oldList[0]['section_id']);
					$this->seller_model->shopSectionUpdate(SHOP_SECTION_LIST,$condition,$dataArr);
					/*Get the Existing products in new Section List*/
					$newList= $this->product_model->get_all_details(SHOP_SECTION_LIST,array('seller_id' => $loggeduserID,'section_id' => $new_sec_id))->result_array();
					$new_sec_prod=$newList[0]['product_id'].$newProd[$i].',';
					$new_sec_count=$newList[0]['shop_prod_count']+1;
					#Update product into new list			
					$dataArr = array('product_id' => $new_sec_prod,'shop_prod_count'=>$new_sec_count);
					$condition=array('seller_id' => $loggeduserID,'section_id' => $new_sec_id);
					$this->seller_model->shopSectionUpdate(SHOP_SECTION_LIST,$condition,$dataArr);
				}
			}
			/*$this->setErrorMessage('success','Successfully moved "'.$new_sec_count.'" listing');
			redirect('shops/'.$seourl.'/sections/'.$new_sec_id);	*/	
		}
		
	}


	public function Preview($seourl){
		if ($this->checkLogin('U')!='' || $this->checkLogin('A')== 1){
			$dataArr=$this->data['preview_item_detail']=$this->product_model->get_all_details(PRODUCT,array('seourl'=>$seourl))->result_array();     
			$variation=$this->product_model->get_subproductdetail_Group(SUBPRODUCT,array('product_id'=> $this->data['preview_item_detail'][0]['id']),'attr_name');
	        $this->data['added_item_details']=$dataArr;
			if(count($variation)==0)
			{
				$this->data['variations_one']="";
				$this->data['variations_two']="";
			}
			if(count($variation)==1)
			{
				$this->data['variations_one']=$variation[0]['attr_name'];
				$this->data['variations_two']="";
				$this->data['variations_one_values']=$this->product_model->get_all_details(SUBPRODUCT,array('product_id'=> $this->data['preview_item_detail'][0]['id'],'attr_name'=>$variation[0]['attr_name']))->result_array();
			}
			if(count($variation)==2)
			{
				$this->data['variations_one']=$variation[0]['attr_name'];
				$this->data['variations_two']=$variation[1]['attr_name'];
				$this->data['variations_one_values']=$this->product_model->get_all_details(SUBPRODUCT,array('product_id'=> $this->data['preview_item_detail'][0]['id'],'attr_name'=>$variation[0]['attr_name']))->result_array();
				$this->data['variations_two_values']=$this->product_model->get_all_details(SUBPRODUCT,array('product_id'=> $this->data['preview_item_detail'][0]['id'],'attr_name'=>$variation[1]['attr_name']))->result_array();
			}
			$this->data['shipping_details']=$this->seller_model->get_all_details(SUB_SHIPPING,array('product_id'=> $this->data['preview_item_detail'][0]['id']))->result_array();
			#echo "<pre>"; print_r($this->data['shipping_details']); die;
 			$this->data['selectedSeller_details']=$this->seller_model->get_sellers_data(SELLER,array());	
			$this->load->view('site/shop/listitem_preview',$this->data);
		}			
	}
	
	
 function Load_ajax_shopName_check($nam){  
  // echo $this->input->get('s_name').'ccc'; die;
	 if($this->input->get('s_name') != ''){
	 $getShopname=$this->seller_model->get_shop_name($this->input->get('s_name'));
		 if($getShopname->num_rows() == 0) {
			 echo 'not exist';
		 } else {
		    echo 'exist';
		 }
	 }
 }
 
  function ajax_gift_card_status(){  
	 if($this->input->get('status') == 1){
	 $status='Yes';
	 } else {
	 $status='No';
	 } 
	 $this->seller_model->update_details(SELLER,array('gift_card'=>$status),array('seller_id'=>$this->input->get('sell_id')));	 
	 
  }
  
  
  /*Promote Shop in Shopsy*/
  public function promote_shop(){
		if ($this->checkLogin('U') == ''){
			redirect('login');
		}else {
			$checkloginIDarr=$this->session->all_userdata(); 
			$loggeduserID=$checkloginIDarr['shopsy_session_user_id'];		   
			$this->data['Seller_details']=$this->seller_model->get_sellers_data(SELLER,$condition);
			$this->data['heading'] = 'Promote Shop';  
			$this->load->view('site/shop/promote_shop',$this->data);
			
		}
	}

	public function insertShopBanner(){
		if ($this->checkLogin('U') == ''){
			redirect('login');
		}else {			
			
			//$config['encrypt_name'] = TRUE;
			$config['overwrite'] = FALSE;
			$config['allowed_types'] = 'jpg|jpeg|gif|png|bmp';
			$config['max_size'] = 10000;
			$config['upload_path'] = './images/banner';
			$this->load->library('upload', $config);
			if ( $this->upload->do_upload('image')){
				$imgDetails = $this->upload->data();
				$ImageName = $imgDetails['file_name'];
				$this->ImageResizeWithCrop(1400, 400, $imgDetails['file_name'], './images/banner/');
			}else{
				$imgDetails = $this->upload->display_errors();
				$this->setErrorMessage('error',strip_tags($imgDetails));
				redirect('site/shop/promote_shop');
			}
			$dataArr = array('seller_banner' => $ImageName);
				$condition=array('seller_id'=>$this->checkLogin('U'));
				$this->seller_model->update_details(SELLER,$dataArr,$condition);	
				$this->setErrorMessage('success','Banner Updated successfully for your shop');
						
			redirect('site/shop/promote_shop');
		}
	}
	
	
	function change_featuredShop_ajax(){
		if($this->input->get('fstatus') == '1'){
			$status='Yes';
		}else {
		  $status='No';
		}
	$this->seller_model->update_details(SELLER,array('featured_shop' => $status),array('seller_id' => $this->input->get('shop_id')));
	echo $this->db->last_query();
	}
	/**/
	public function display_shop_favoriters($seourl){
		$this->data['shopInfo']=$shopInfo=$this->seller_model->get_shop_owner_detail($seourl)->result_array();
		$this->data['favUserList']=$favUserList=$this->product_model->getShopFavDetails($shopInfo[0]['seller_id']);
		#echo $this->db->last_query(); die;
		#echo "<pre>"; print_r($shopInfo); die;
		if (count($favUserList)>0){
			foreach ($favUserList as $favUser){
				$this->data['favoritersUserfavDetails'][$favUser['user_id']] = $this->user_model->get_userfav_products($favUser['user_id']);
				$this->data['favoritersUserfavProdDetails'][$favUser['user_id']] = $this->user_model->get_userfav_products($favUser['user_id'])->result_array();
			}
		}
		#echo "<pre>"; print_r($this->data['favoritersUserfavDetails']);die;
		$condition = array('id'=>$this->checkLogin('U'));
		$this->data['userProfileDetails'] = $this->product_model->get_all_details(USERS,$newdata,$condition)->result_array();
		$this->data['title'] = 'People who have favorited '.$prodInfo[0]->product_name.' by '.$prodInfo[0]->shop_name.' - '.$this->config->item('meta_title');
		$this->data['meta_title'] ='People who have favorited '.$prodInfo[0]->product_name.' by '.$prodInfo[0]->shop_name.' - '.$this->config->item('meta_title');	
		$this->data['meta_description'] =$currentcatDetails->seo_description;   	
		
		$this->load->view('site/shop/shop_favorites',$this->data);
	}
	/*************************** Contact Reviewer popup function  *************************************/
	
	public function contactReviewer(){
	
		$reviewer_id = $this->input->post('reviewer_id'); 
		$review_id = $this->input->post('review_id'); 
		$reporter_id = $this->input->post('reporter_id');
		
		$userPurchase=$this->user_model->get_user_purchase_list($usrId,$orderId);
		$purchaseProducts=$userPurchase->result();
		
		$reviewerVal = $this->user_model->get_all_details(USERS,array( 'id' => $reviewer_id));	
		$reporterVal = $this->user_model->get_all_details(USERS,array( 'id' => $reporter_id));	
		
		$popupVal = '<div style="background:#fff;border-radius:8px;"> 
        	<form method="post" action="site/shop/reportReview" onsubmit="return rattingValidation();">
            <div class="contact_reg-header">
                <h2>Report This Review.</h2>
                <div class="contact_reg-body">
                	<input type="hidden" name="reporter_id" id="reporter_id" value="'.$reporterVal->row()->id.'" />
                    <input type="hidden" name="reporter_email" id="reporter_email" value="'.$reporterVal->row()->email.'" />
                    <input type="hidden" name="reviewer_id" id="reviewer_id" value="'.$reviewerVal->row()->id.'" />
                    <input type="hidden" name="reviewer_email" id="reviewer_email" value="'.$reviewerVal->row()->email.'" />
                    <input type="hidden" name="review_id" id="review_id" value="'.$review_id.'" />
                    <textarea class="conversation-textarea" rows="8" name="description" id="description" placeholder="Message text" style="width:382px; margin:10px 0;"></textarea>
					<span id="descriptionErr" style="color:red;"></span>
                </div>
            </div>
            <div class="contact_reg-footer">
                <span><input class="resending" type="submit" value="Report"></span>
            </div>
            </form>
        </div>';	
		
		echo $popupVal;		
		
		return;
	
	}
	public function reportReview(){
		if ($this->checkLogin('U') != ''){
			#echo ""; print_r($_POST); die;
			$this->user_model->commonInsertUpdate(REPORT_REVIEW,'insert',array(),array(),'');
			$this->setErrorMessage('success','Your Report has been submitted Successfully!.');
			redirect('shop/reviews');
		}
	}
	
	
	public function ajax_check_shop_mainBanner_size(){
		
		if($this->input->post('shop-banner') == 'shop-banner-img') {
			 list($w, $h) = getimagesize($_FILES["shop_banner"]["tmp_name"]);
			if($w >= 760 && $h >= 100){
			echo 'Success';
			} else {
			echo 'Error';
			}
		} else {
	        list($w, $h) = getimagesize($_FILES["image"]["tmp_name"]);
			if($w >= 1400 && $h >= 400){
			echo 'Success';
			} else {
			echo 'Error';
			}
		}
	}
	/*Shop coupon codes Starts here*/
	public function display_couponcards(){
		if ($this->checkLogin('U') == ''){
			redirect('login');
		}else {
			$this->data['heading'] = 'Coupon Codes List';
			$condition = array('sell_id'=>$this->checkLogin('U'));
			$this->data['couponCardsList'] = $this->user_model->get_all_details(COUPONCARDS,$condition);
			$this->load->view('site/shop/shop_couponcard',$this->data);
		}
	}
	public function add_couponcard(){
		if ($this->checkLogin('U') == ''){
			redirect('login');
		}else {
			$this->data['heading'] = 'Add New Coupon Code';
			$this->data['code'] = $this->get_rand_str('10');			
			$condition = array('code' => $this->data['code']);
			$couponcard_details= $this->user_model->get_all_details(COUPONCARDS,$condition);
			if ($couponcard_details->num_rows() == 0){
				$this->load->view('site/shop/shop_add_couponcard',$this->data);
			}
			else{
				$this->add_couponcard();
			}
		}
	}
	public function edit_couponcard(){
		if ($this->checkLogin('U') == ''){
			redirect('login');
		}else {
			$this->data['heading'] = 'Edit Coupon Code';
			$id = $this->uri->segment(4);
			$condition = array('id' => $id);
			$this->data['couponcard_details'] = $this->user_model->get_all_details(COUPONCARDS,$condition);
			if ($this->data['couponcard_details']->num_rows() == 1){
				$this->load->view('site/shop/shop_edit_couponcard',$this->data);
			}else {
				redirect('home');
			}
		}
	}
	public function insertEditCouponcard(){
		if ($this->checkLogin('U') == ''){
			redirect('login');
		}else {
			$excludeArr = array("coupon_id");
			$dataArr = array();
			$condition = array();
			if ($this->input->post('id') == ''){
				$this->user_model->commonInsertUpdate(COUPONCARDS,'insert',$excludeArr,$dataArr,$condition);
				$this->setErrorMessage('success','Coupon Code added successfully');
			}else {
				$condition = array('id' => $this->input->post('id'));
				$this->user_model->commonInsertUpdate(COUPONCARDS,'update',$excludeArr,$dataArr,$condition);
				$this->setErrorMessage('success','Coupon Code updated successfully');
			}
			redirect('shops/'.$this->data['currentshopurl'].'/coupon-code');
		}
	}
	/*Shop coupon codes Ends here*/	
	/*Shop User Contacts Starts here*/
	public function display_contact_user(){
		if ($this->checkLogin('U') == ''){
			redirect('login');
		}else {
			$this->data['heading'] = $this->uri->segment(2).' :: User Contacts';
			$condition = array('sellerid'=>$this->checkLogin('U'));
			$this->data['contactUserList'] = $this->user_model->get_all_details(CONTACTSELLER,$condition);
			$this->load->view('site/shop/shop_contact_user',$this->data);
		}
	}
	public function view_contact_user(){
		if ($this->checkLogin('U') == ''){
			redirect('login');
		}else {
			$this->data['heading'] = $this->uri->segment(2).' :: View Message';
			$condition = array('sellerid'=>$this->checkLogin('U'),'id'=>$this->uri->segment(4));
			$this->data['contactUserInfo'] = $this->user_model->get_all_details(CONTACTSELLER,$condition);
			$this->load->view('site/shop/shop_contact_user_message',$this->data);
		}
	}
	public function delete_contact_user(){
		if ($this->checkLogin('U') == ''){
			redirect('login');
		}else {
			$id = $this->uri->segment(4,0);
			$condition = array('id' => $id);
			$this->user_model->commonDelete(CONTACTSELLER,$condition);
			$this->setErrorMessage('success','Contact onformation deleted successfully');
			redirect('shops/'.$this->uri->segment(2,0).'/contact-user');
		}
	}
	public function contactuserpopup(){
		$id = $this->input->post('id'); 
		$condition = array('sellerid'=>$this->checkLogin('U'),'id'=>$id);
		$contactUserInfo = $this->user_model->get_all_details(CONTACTSELLER,$condition);
		$popupVal = '<div style="width:96.7%" class="conversation">
                <div style="padding:20px; width:94.5%;" class="conversation_container">
                    <h2 class="conversation_headline">Replay to : '.$contactUserInfo->row()->username.'</h2>
                    <div class="conversation_right" style="width:680px;">
                        <form name="contactpeople" id="contactpeople" method="post" action="site/user/contactpeople" onsubmit="return contactsCheck();">
                            <input class="conversation-subject" type="text" name="subject" id="subject" placeholder="Subject" style="width:610px;" value="Re:'.$contactUserInfo->row()->product_name.'" >
                            <textarea class="conversation-textarea" style="width:610px;" rows="11" name="message_text" id="message_text" placeholder="Message text"></textarea>
                            <input type="hidden" name="sender_email" id="sender_email" value="'.$this->session->userdata['shopsy_session_user_email'].'" >
                            <input type="hidden" name="sender_id" id="sender_id" value="'.$this->session->userdata['shopsy_session_user_id'].'" >
                            <input type="hidden" name="receiver_email" id="receiver_email" value="'.$contactUserInfo->row()->useremail.'" >
                            <input type="hidden" name="receiver_id" id="receiver_id" value="'.$contactUserInfo->row()->user_id.'" >
                            <input type="hidden" name="current_user" value="'.$this->session->userdata['shopsy_session_user_name'].'" >
                            <input type="hidden" name="FromURL" value="ContactUser" >
                            <input class="subscribe_btn" type="submit" value="send" style="height: auto; padding: 7px 10px; margin: 10px 0 7px 20px; font-weight: bold;">
                            <span class="error" id="ErrPUP"></span>
                        </form>		
                    </div> 
                </div>
            </div>';
		echo $popupVal;				
		return;
	}
	/*Shop User Contacts Ends here*/
	/*Shop Transaction starts here*/
	public function display_shop_transaction(){
		if ($this->checkLogin('U') == ''){
			redirect('login');
		}else {
			$this->data['heading'] = 'Shop Tranactions';
			$shop_id = $this->checkLogin('U');		
			$this->data['shop_trans_details'] = $this->seller_model->getShopTransactionDetails($shop_id);
			$this->load->view('site/shop/display_shop_tranaction',$this->data);
		}
	}
	public function view_shop_transaction(){
		if ($this->checkLogin('U') == ''){
			redirect('login');
		}else {
			$this->data['heading'] = $this->uri->segment(2,0).' :: Tranactions';
			$transdate = $this->uri->segment(4,0);
			$shop_id = $this->checkLogin('U');		
			$condition = array('pay_date' => date("Y-m-d H:i:s",$transdate),'user_id'=> $shop_id);
			$this->data['productList'] = $this->product_model->view_product_details('  where p.pay_date="'.date("Y-m-d H:i:s",$transdate).'" and p.user_id='.$shop_id.' and u.group="Seller" and u.status="Active" or p.pay_date="'.date("Y-m-d H:i:s",$transdate).'" and p.user_id='.$shop_id.' and a.pricing IS NOT NULL group by p.id order by p.created desc');
			#echo "<pre>"; print_r($this->data['productList']); die;
			$this->load->view('site/shop/view_shop_tranaction',$this->data);
			
		}
	}
	/*Shop Orders*/
	public function display_shop_orders(){
		if ($this->checkLogin('U') == ''){
			redirect('login');
		}else {
			$this->data['heading'] = 'Shop Orders';
			$shop_id = $this->checkLogin('U');		
			$this->data['orderList'] = $this->order_model->view_shop_order_details('Paid',$shop_id);
			$this->load->view('site/shop/display_shop_orders',$this->data);
		}
	}
	public function shoporder_update(){
		if ($this->checkLogin('U')==''){
			redirect('login');
		}else {
			$dealCode = $this->input->post('dealCodeNumber');
			$shipping_status = $this->input->post('shipping_status');
			$dataArr=array('shipping_status'=>$shipping_status);
			$condition=array('dealCodeNumber'=>$dealCode);
			$order_details = $this->order_model->update_details(USER_PAYMENT,$dataArr,$condition);
			if($order_details){
				$this->setErrorMessage('success','Order Status Updated Successfully');
				echo 'Success';
			}else{
				$this->setErrorMessage('error','Order Status Updated Failed');			
				echo 'error';
			}
		}
	}
	public function vieworder(){
		if ($this->checkLogin('U') == ''){
			redirect('login');
		}else {
			$this->data['heading'] = 'View Order';
			$user_id = $this->uri->segment(4,0);
			$deal_id = $this->uri->segment(5,0);
			$this->data['ViewList'] = $this->order_model->view_orders($user_id,$deal_id);
			$this->load->view('admin/order/view_orders',$this->data);
		}
	}
} 

// Class ends
/*End of file cms.php */
/* Location: ./application/controllers/site/product.php */