<?php if (!defined('BASEPATH')) exit('No direct script access allowed');

/**
 * 
 * User related functions
 * @author Teamtweaks
 *
 */

class Market extends MY_Controller {
	function __construct(){
        parent::__construct();
		//error_reporting(-1);
		$this->load->helper(array('cookie','date','form','email','text'));
		$this->load->library(array('encrypt','form_validation'));		
		$this->load->model(array('product_model','user_model','seller_model'));
		
		$this->data['loginCheck'] = $this->checkLogin('U');
		$this->data['likedProducts'] = array();	 	
    }
	
	public function index(){
		$this->data['searchTag'] =$searchTag=$this->uri->segment(2);
		#view_product_details
		$condition = " where p.status='Publish' and p.tag LIKE '%".$searchTag."%' and u.group='Seller' and u.status='Active' or p.status='Publish' and p.user_id=0 and a.pricing IS NOT NULL group by p.id order by p.created desc";
		$this->data['popularItems']=$popularItems= $this->product_model->view_product_details($condition)->result_array();
		#echo "<pre>"; print_r($popularItems); die;
		$this->load->view('site/market/relateditems',$this->data);
    }
   
	public function spam_report(){
		if($this->checkLogin('U') != ''){
			$p_id=$this->input->post('p_id');
			$s_id=$this->input->post('s_id');
			$spam_title=$this->input->post('spam_title'); 
			$complaint=$this->input->post('complaint');	
				$datArr=array('product_id' => $p_id,'user_id' => $this->checkLogin('U'),'spam_title'=> $spam_title,'complaint' => $complaint);
			if($s_id!=""){
				$datArr=array('seller_id' => $s_id,'user_id' => $this->checkLogin('U'),'spam_title'=> $spam_title,'complaint' => $complaint);
			}
			$this->product_model->simple_insert(SPAM_REPORT,$datArr);
			$this->setErrorMessage('success','Thank You! Your Spam Report Sent Successfully.');  //echo $this->input->post('s_seourl'); die;
			if($this->input->post('p_seourl')!=''){
				redirect('products/'.$this->input->post('p_seourl'));
			}   else if($this->input->post('s_seourl')!='')
			$this->setErrorMessage('success','Thank You! Your Spam Report Sent Successfully.');
			redirect('shop-section/'.$this->input->post('s_seourl'));
		} else {
		   $this->setErrorMessage('error','You Must Login First');
		   redirect('');
		}
	}
	
	/*********This function loads the Registry view file***********/
	public function loadRegistry(){
			if($this->checkLogin('U') != ''){
			$checkRigis=$this->product_model->get_all_details(REGISTRY,array('user_id' => $this->checkLogin('U')));
				if($checkRigis->num_rows() != 0){
				$this->data['registryMainList']=$this->product_model->get_all_details(CATEGORY,array('rootID' => '62'));
				$this->data['registryVals']=$checkRigis->row();
				$condition="where reg.collection_id ='".$this->checkLogin('U')."' and p.status='Publish' and (a.pricing IS NOT NULL or p.price IS NOT NULL) group by p.id order by p.created desc";
				$this->data['registryProductList']=$this->product_model->view_registry_product_details($condition);
				$this->data['heading'] =$this->config->item('email_title').' - Registry';
		        $this->data['meta_title'] =$this->config->item('email_title').' - Registry';
				$this->load->view('site/registry/registry_manage',$this->data);
				} else {
			    $this->data['registryBannerList']=$this->product_model->get_all_details(SELLER,array('seller_banner !=' => ''));
				$this->data['heading'] =$this->config->item('email_title').' - Registry';
		        $this->data['meta_title'] =$this->config->item('email_title').' - Registry';
			    $this->load->view('site/registry/registry_index',$this->data); 
				} 
		   } else {
			   
			  $this->data['heading'] =$this->config->item('email_title').' - Registry';
		      $this->data['meta_title'] =$this->config->item('email_title').' - Registry';
			  $this->data['registryBannerList']=$this->product_model->get_all_details(SELLER,array('seller_banner !=' => ''));
			  $this->load->view('site/registry/registry_index',$this->data); 
		  }
	}
	
	
	/*********This function inserts the Registry view file***********/
	public function insertRegistry(){
			if($this->checkLogin('U') != ''){ 
			 if($this->input->post('registryDate') == 'Select the date.'){
				  $wedding_date=date('Y-m-d',time());
				  } else { $wedding_date=$this->input->post('registryDate'); }
			$this->product_model->simple_insert(REGISTRY,array('wedding_date' => $wedding_date,'user_id' => $this->checkLogin('U')));
			$this->setErrorMessage('success','Your Wedding Registry Added Successfully');
			redirect('registry');
		  } else {
		  $this->setErrorMessage('error','You Must Login First');
		  redirect('');
		  }
	}
	
	
	
	
	
	/*********This function updates the Registry date***********/
	public function updateRegistry(){
		  if($this->checkLogin('U') != ''){    
			$this->product_model->update_details(REGISTRY,array('wedding_date' => $this->input->post('registryDate')),array('user_id' => $this->checkLogin('U')));
			$this->setErrorMessage('success','Your Wedding Date Updated Successfully');
			redirect('registry');
		  }  else {
		  $this->setErrorMessage('error','You Must Login First');
		  redirect('');
		  }
	}
	
	
	
	/*********This function delets the Registry details **********/
	public function deleteRegistry(){
		  if($this->checkLogin('U') != ''){ 
			$this->product_model->commonDelete(REGISTRY,array('user_id' => $this->checkLogin('U')));
			$this->product_model->commonDelete(REGISTRY_LISTINGS,array('collection_id'=>$this->checkLogin('U')));
			redirect('registry');
			$this->setErrorMessage('success','Your Registry Deleted Successfully');
		  }  else {
		  $this->setErrorMessage('error','You Must Login First');
		  redirect('');
		  }
	}
	
	
	
	
	
}
/*End of file market.php */
/* Location: ./application/controllers/site/market.php */