<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

/**
 * 
 * This controller contains the functions related to cms management 
 * @author Teamtweaks
 *
 */

class Shop extends MY_Controller {

	function __construct(){
        parent::__construct();
		$this->load->helper(array('cookie','date','form'));
		$this->load->library(array('encrypt','form_validation'));		
		$this->load->model('seller_model');
		if ($this->checkPrivileges('cms',$this->privStatus) == FALSE){
			redirect('admin');
		}
    }
    
    /**
     * 
     * This function loads the cms list page
     */
   	public function index(){	
		if ($this->checkLogin('A') == ''){
			redirect('admin');
		}else {
			redirect('admin/cms/display_blog');
		}
	}
	
	/**
	 * 
	 * This function loads the cms list page
	 */
	public function display_shop(){
		if ($this->checkLogin('A') == ''){
			redirect('admin');
		}else {
			$this->data['heading'] = 'Shop Lists';
			$condition = array();
			$this->data['shopDetails']  =  $this->seller_model->getShopDetails();
			$this->load->view('admin/shop/display_shop',$this->data);
		}
	}
	
	/**
	 * 
	 * This function loads the add new cms form
	 */
	public function add_cms_form(){
		if ($this->checkLogin('A') == ''){
			redirect('admin');
		}else {
			$this->data['heading'] = 'Add New Main Page';
			$this->load->view('admin/cms/add_cms',$this->data);
		}
	}
	
	/**
	 * 
	 * This function loads the add new subpage form
	 */
	public function add_subpage_form(){
		if ($this->checkLogin('A') == ''){
			redirect('admin');
		}else {
			$this->data['heading'] = 'Add New Sub Page';
			$condition = array('category' => 'Main');
			$this->data['cms_details'] = $this->seller_model->get_all_details(CMS,$condition);
			if ($this->data['cms_details']->num_rows() > 0){
				$this->load->view('admin/cms/add_sub_page',$this->data);
			}else {
				$this->setErrorMessage('error','You must add a main page first');
				redirect('admin/cms/display_cms');
			}
		}
	}
	/**
	 * 
	 * This function loads the user view page
	 */
	public function view_shop(){
		if ($this->checkLogin('A') == ''){
			redirect('admin');
		}else {
			$this->data['heading'] = 'View Shop';
			$post_id = explode('-',$this->uri->segment(4,0));
			$condition = array('user_id' => $post_id[1],'status' => 'Publish');
			$this->data['active_count'] = $this->seller_model->get_all_details(PRODUCT,$condition);
			$condition = array('user_id' => $post_id[1],'status' => 'UnPublish');
			$this->data['inactive_count'] = $this->seller_model->get_all_details(PRODUCT,$condition);
		//	$condition = array('post_id' => $post_id);
			$this->data['shop_details'] = $this->seller_model->getShopDetails($post_id[0]);
			$this->load->view('admin/shop/view_shop',$this->data);
		}
	}	
	/**
	 * 
	 * This function insert and edit a cms page
	 */
	public function insertEditPost(){
		//print_r($_POST); die;
/*		if ($this->checkLogin('A') == ''){
			redirect('admin');
		}else {*/
			 $cms_id = $this->input->post('cms_id'); 
			
			$page_name = $this->input->post('post_title');
			
			if ($page_name == ''){
				$this->setErrorMessage('error','Page name required');
				echo "<script>window.history.go(-1)</script>";exit();
			}

			$excludeArr = array("cms_id","hidden_page","subpage");
			$datestring = "%Y-%m-%d";
			$time = time();
				$seourl = url_title($page_name, '-', TRUE); 
				$dataArr = array('seourl' => $seourl);
			$condition = array('post_id' => $cms_id);

				//	print_r($dataArr); die;
				$this->seller_model->commonInsertUpdate(POSTS,'update',$excludeArr,$dataArr,$condition);
				$this->setErrorMessage('success','Page updated successfully');
				redirect('admin/blog/display_blog');
			/*}*/
		}
	/**
	 * 
	 * This function loads the edit cms form
	 */
	public function edit_post_form(){
		if ($this->checkLogin('A') == ''){
			redirect('admin');
		}else {
			$this->data['heading'] = 'Edit Posts';
			$cms_id = $this->uri->segment(4,0);
			$condition = array('post_id' => $cms_id);
			$this->data['cms_details'] = $this->seller_model->get_all_details(POSTS,$condition);
				
			$this->load->view('admin/blog/edit_blog',$this->data);
			
		}
	}
	
	/**
	 * 
	 * This function change the cms page status
	 */
	public function change_shop_status(){
		if ($this->checkLogin('A') == ''){
			redirect('admin');
		}else {
			$mode = $this->uri->segment(4,0);
			$cms_id = $this->uri->segment(5,0); 
			$status = ($mode == '0')?'inactive':'active';

			$newdata = array('status' => $status);
			$condition = array('id' => $cms_id);
			$this->seller_model->update_details(SELLER,$newdata,$condition);
			$userVals = $this->seller_model->get_all_details(SELLER,array( 'id' => $cms_id));
			$userNamevals = $this->seller_model->get_all_details(USERS,array( 'id' => $userVals->row()->seller_id));
			
			if($status == 'active'){
				$newdata1 = array('group' => 'Seller');
				$role='Author';
			}else{
				$newdata1 = array('group' => 'User');				
				$role='Subscriber';				
			}
				$condition1 = array('id' => $userVals->row()->seller_id);
				$this->seller_model->update_details(USERS,$newdata1,$condition1);
				//echo $this->db->last_query(); die;
				
			$this->setErrorMessage('success','Seller Status Changed Successfully');
			redirect('wp_change_role.php?un='.$userNamevals->row()->user_name.'&roles='.$role);
			//redirect('admin/shop/display_shop');
		}
	}
	
	/**
	 * 
	 * This function change the cms page display mode
	 */
	public function change_cms_mode(){
		if ($this->checkLogin('A') == ''){
			redirect('admin');
		}else {
			$mode = $this->uri->segment(4,0);
			$cms_id = $this->uri->segment(5,0);
			$newdata = array('hidden_page' => $mode);
			$condition = array('id' => $cms_id);
			$this->seller_model->update_details(CMS,$newdata,$condition);
			$this->setErrorMessage('success','Page Hidden Mode Changed Successfully');
			redirect('admin/shop/display_shop');
		}
	}
	
	/**
	 * 
	 * This function delete the cms page from db
	 */
	public function delete_shop(){
		if ($this->checkLogin('A') == ''){
			redirect('admin');
		}else {
			$cms_id = $this->uri->segment(4,0);
			$condition = array('id' => $cms_id);
			$this->seller_model->commonDelete(SELLER,$condition);
			$this->setErrorMessage('success','Shop deleted successfully');
			redirect('admin/shop/display_shop');
		}
	}
	
	/**
	 * 
	 * This function change the cms pages status
	 */
	public function change_shop_status_global(){
		if(count($_POST['checkbox_id']) > 0 &&  $_POST['statusMode'] != ''){
			$this->seller_model->activeInactiveCommon(SELLER,'id');
			if (strtolower($_POST['statusMode']) == 'delete'){
				$this->setErrorMessage('success','Seller deleted successfully');
			}else {
				$this->setErrorMessage('success','Seller status changed successfully');
			}
			redirect('admin/shop/display_shop');
		}
	}
	
	/*View the shop payments*/
	public function view_shop_transaction(){
		
		if ($this->checkLogin('A') == ''){
			redirect('admin');
		}else {
			$this->data['heading'] = 'Shop Tranactions';
			$shop_id = $this->uri->segment(4,0);		
			$this->data['shop_trans_details'] = $this->seller_model->getShopTransactionDetails($shop_id);
			$this->load->view('admin/shop/display_shop_tranaction',$this->data);
		}
	}
	public function view_shop_trans(){
		
		if ($this->checkLogin('A') == ''){
			redirect('admin');
		}else {
			$this->data['heading'] = 'Shop Tranactions Details';
			$transdate = $this->uri->segment(4,0);
			$shop_id = $this->uri->segment(5,0);		
			$condition = array('pay_date' => date("Y-m-d H:i:s",$transdate),'user_id'=> $shop_id);
			#$this->data['productList'] = $this->seller_model->get_all_details(PRODUCT,$condition);
			$this->data['productList'] = $this->product_model->view_product_details('  where p.pay_date="'.date("Y-m-d H:i:s",$transdate).'" and p.user_id='.$shop_id.' and u.group="Seller" and u.status="Active" or p.pay_date="'.date("Y-m-d H:i:s",$transdate).'" and p.user_id='.$shop_id.' and a.pricing IS NOT NULL group by p.id order by p.created desc');
			#echo "<pre>"; print_r($this->data['shop_trans_details']);
			$this->load->view('admin/shop/shop_tranaction_details',$this->data);
		}
	}
}

/* End of file cms.php */
/* Location: ./application/controllers/admin/cms.php */